% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_structure.R
\name{information_data_chunk}
\alias{information_data_chunk}
\title{Get chunk-level content information from a flextable}
\usage{
information_data_chunk(x, expand_special_chars = TRUE)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}
}
\value{
a data.frame containing information about chunks:
\itemize{
\item text chunk (column \code{txt}) and other content (\code{url}
for the linked url, \code{eq_data} for content of type 'equation',
\code{word_field_data} for content of type 'word_field' and
\code{img_data} for content of type 'image'),
\item formatting properties,
\item part (\code{.part}), position within the paragraph (\code{.chunk_index}),
row (\code{.row_id}) and column (\code{.col_id}).
}
}
\description{
This function takes a flextable object and returns a data.frame containing
information about each text chunk within the flextable. The data.frame includes
details such as the text content, formatting properties, position within the
paragraph, paragraph row, and column.
}
\section{don't use this}{


These data structures should not be used, as they
represent an interpretation of the underlying data
structures, which may evolve over time.

\strong{They are exported to enable two packages that exploit
these structures to make a transition, and should not
remain available for long.}
}

\examples{
ft <- as_flextable(iris)
x <- information_data_chunk(ft)
head(x)
}
\seealso{
Other information data functions: 
\code{\link{information_data_cell}()},
\code{\link{information_data_paragraph}()}
}
\concept{information data functions}
\keyword{internal}
