% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcorr.R
\name{ggcorr}
\alias{ggcorr}
\title{Correlation matrix}
\usage{
ggcorr(
  data,
  method = c("pairwise", "pearson"),
  cor_matrix = NULL,
  nbreaks = NULL,
  digits = 2,
  name = "",
  low = "#3B9AB2",
  mid = "#EEEEEE",
  high = "#F21A00",
  midpoint = 0,
  palette = NULL,
  geom = "tile",
  min_size = 2,
  max_size = 6,
  label = FALSE,
  label_alpha = FALSE,
  label_color = "black",
  label_round = 1,
  label_size = 4,
  limits = c(-1, 1),
  drop = is.null(limits) || identical(limits, FALSE),
  layout.exp = 0,
  legend.position = "right",
  legend.size = 9,
  ...
)
}
\arguments{
\item{data}{a data frame or matrix containing numeric (continuous) data. If
any of the columns contain non-numeric data, they will be dropped with a
warning.}

\item{method}{a vector of two character strings. The first value gives the
method for computing covariances in the presence of missing values, and must
be (an abbreviation of) one of \code{"everything"}, \code{"all.obs"},
\code{"complete.obs"}, \code{"na.or.complete"} or
\code{"pairwise.complete.obs"}. The second value gives the type of
correlation coefficient to compute, and must be one of \code{"pearson"},
\code{"kendall"} or \code{"spearman"}.
See \code{\link[stats]{cor}} for details.
Defaults to \code{c("pairwise", "pearson")}.}

\item{cor_matrix}{the named correlation matrix to use for calculations.
Defaults to the correlation matrix of \code{data} when \code{data} is
supplied.}

\item{nbreaks}{the number of breaks to apply to the correlation coefficients,
which results in a categorical color scale. See 'Note'.
Defaults to \code{NULL} (no breaks, continuous scaling).}

\item{digits}{the number of digits to show in the breaks of the correlation
coefficients: see \code{\link[base]{cut}} for details.
Defaults to \code{2}.}

\item{name}{a character string for the legend that shows the colors of the
correlation coefficients.
Defaults to \code{""} (no legend name).}

\item{low}{the lower color of the gradient for continuous scaling of the
correlation coefficients.
Defaults to \code{"#3B9AB2"} (blue).}

\item{mid}{the midpoint color of the gradient for continuous scaling of the
correlation coefficients.
Defaults to \code{"#EEEEEE"} (very light grey).}

\item{high}{the upper color of the gradient for continuous scaling of the
correlation coefficients.
Defaults to \code{"#F21A00"} (red).}

\item{midpoint}{the midpoint value for continuous scaling of the
correlation coefficients.
Defaults to \code{0}.}

\item{palette}{if \code{nbreaks} is used, a ColorBrewer palette to use
instead of the colors specified by \code{low}, \code{mid} and \code{high}.
Defaults to \code{NULL}.}

\item{geom}{the geom object to use. Accepts either \code{"tile"},
\code{"circle"}, \code{"text"} or \code{"blank"}.}

\item{min_size}{when \code{geom} has been set to \code{"circle"}, the minimum
size of the circles.
Defaults to \code{2}.}

\item{max_size}{when \code{geom} has been set to \code{"circle"}, the maximum
size of the circles.
Defaults to \code{6}.}

\item{label}{whether to add correlation coefficients to the plot.
Defaults to \code{FALSE}.}

\item{label_alpha}{whether to make the correlation coefficients increasingly
transparent as they come close to 0. Also accepts any numeric value between
\code{0} and \code{1}, in which case the level of transparency is set to that
fixed value.
Defaults to \code{FALSE} (no transparency).}

\item{label_color}{the color of the correlation coefficients.
Defaults to \code{"grey75"}.}

\item{label_round}{the decimal rounding of the correlation coefficients.
Defaults to \code{1}.}

\item{label_size}{the size of the correlation coefficients.
Defaults to \code{4}.}

\item{limits}{bounding of color scaling for correlations, set \code{limits = NULL} or \code{FALSE} to remove}

\item{drop}{if using \code{nbreaks}, whether to drop unused breaks from the
color scale.
Defaults to \code{FALSE} (recommended).}

\item{layout.exp}{a multiplier to expand the horizontal axis to the left if
variable names get clipped.
Defaults to \code{0} (no expansion).}

\item{legend.position}{where to put the legend of the correlation
coefficients: see \code{\link[ggplot2]{theme}} for details.
Defaults to \code{"bottom"}.}

\item{legend.size}{the size of the legend title and labels, in points: see
\code{\link[ggplot2]{theme}} for details.
Defaults to \code{9}.}

\item{...}{other arguments supplied to \code{\link[ggplot2]{geom_text}} for
the diagonal labels.}
}
\description{
Function for making a correlation matrix plot, using \pkg{ggplot2}.
The function is directly inspired by Tian Zheng and Yu-Sung Su's
\code{corrplot} function in the 'arm' package.
Please visit \url{https://github.com/briatte/ggcorr} for the latest version
of \code{ggcorr}, and see the vignette at
\url{https://briatte.github.io/ggcorr/} for many examples of how to use it.
}
\note{
Recommended values for the \code{nbreaks} argument are \code{3} to
\code{11}, as values above 11 are visually difficult to separate and are not
supported by diverging ColorBrewer palettes.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

# Basketball statistics provided by Nathan Yau at Flowing Data.
dt <- read.csv("http://datasets.flowingdata.com/ppg2008.csv")

# Default output.
p_(ggcorr(dt[, -1]))

# Labeled output, with coefficient transparency.
p_(ggcorr(dt[, -1],
  label = TRUE,
  label_alpha = TRUE
))

# Custom options.
p_(ggcorr(
  dt[, -1],
  name = expression(rho),
  geom = "circle",
  max_size = 10,
  min_size = 2,
  size = 3,
  hjust = 0.75,
  nbreaks = 6,
  angle = -45,
  palette = "PuOr" # colorblind safe, photocopy-able
))

# Supply your own correlation matrix
p_(ggcorr(
  data = NULL,
  cor_matrix = cor(dt[, -1], use = "pairwise")
))
}
\seealso{
\code{\link[stats]{cor}} and \code{corrplot} in the
\code{arm} package.
}
\author{
Francois Briatte, with contributions from Amos B. Elberg and
Barret Schloerke
}
