% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-step.R
\name{PlumberEndpoint}
\alias{PlumberEndpoint}
\title{Plumber Endpoint}
\description{
Plumber Endpoint

Plumber Endpoint
}
\details{
Defines a terminal handler in a PLumber router.

Parameters values are obtained from parsing blocks of lines in a plumber file.
They can also be provided manually for historical reasons.
}
\section{Super classes}{
\code{\link[plumber:Hookable]{plumber::Hookable}} -> \code{\link[plumber:PlumberStep]{plumber::PlumberStep}} -> \code{PlumberEndpoint}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{verbs}}{a character vector. http methods. For historical reasons we have
to accept multiple verbs for a single path. Now it's simpler to just parse
each separate verb/path into its own endpoint, so we just do that.}

\item{\code{path}}{a character string. endpoint path}

\item{\code{comments}}{endpoint comments}

\item{\code{responses}}{endpoint responses}

\item{\code{params}}{endpoint parameters}

\item{\code{tags}}{endpoint tags}

\item{\code{parsers}}{step allowed parsers}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-getTypedParams}{\code{PlumberEndpoint$getTypedParams()}}
\item \href{#method-canServe}{\code{PlumberEndpoint$canServe()}}
\item \href{#method-matchesPath}{\code{PlumberEndpoint$matchesPath()}}
\item \href{#method-new}{\code{PlumberEndpoint$new()}}
\item \href{#method-getPathParams}{\code{PlumberEndpoint$getPathParams()}}
\item \href{#method-getFuncParams}{\code{PlumberEndpoint$getFuncParams()}}
\item \href{#method-getEndpointParams}{\code{PlumberEndpoint$getEndpointParams()}}
\item \href{#method-clone}{\code{PlumberEndpoint$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="plumber" data-topic="Hookable" data-id="registerHooks">}\href{../../plumber/html/Hookable.html#method-registerHooks}{\code{plumber::Hookable$registerHooks()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="plumber" data-topic="PlumberStep" data-id="exec">}\href{../../plumber/html/PlumberStep.html#method-exec}{\code{plumber::PlumberStep$exec()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="plumber" data-topic="PlumberStep" data-id="registerHook">}\href{../../plumber/html/PlumberStep.html#method-registerHook}{\code{plumber::PlumberStep$registerHook()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTypedParams"></a>}}
\if{latex}{\out{\hypertarget{method-getTypedParams}{}}}
\subsection{Method \code{getTypedParams()}}{
retrieve endpoint typed parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$getTypedParams()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-canServe"></a>}}
\if{latex}{\out{\hypertarget{method-canServe}{}}}
\subsection{Method \code{canServe()}}{
ability to serve request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$canServe(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{a request object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a logical. \code{TRUE} when endpoint can serve request.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-matchesPath"></a>}}
\if{latex}{\out{\hypertarget{method-matchesPath}{}}}
\subsection{Method \code{matchesPath()}}{
determines if route matches requested path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$matchesPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{a url path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a logical. \code{TRUE} when endpoint matches the requested path.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{PlumberEndpoint} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$new(
  verbs,
  path,
  expr,
  envir,
  serializer,
  parsers,
  lines,
  params,
  comments,
  responses,
  tags
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbs}}{Endpoint verb Ex: \code{"GET"}, \code{"POST"}}

\item{\code{path}}{Endpoint path. Ex: \code{"/index.html"}, \code{"/foo/bar/baz"}}

\item{\code{expr}}{Endpoint function or expression that evaluates to a function.}

\item{\code{envir}}{Endpoint environment}

\item{\code{serializer}}{Endpoint serializer. Ex: \code{\link[=serializer_json]{serializer_json()}}}

\item{\code{parsers}}{Can be one of:
\itemize{
\item A \code{NULL} value
\item A character vector of parser names
\item A named \code{list()} whose keys are parser names names and values are arguments to be applied with \code{\link[=do.call]{do.call()}}
\item A \code{TRUE} value, which will default to combining all parsers. This is great for seeing what is possible, but not great for security purposes
}

If the parser name \code{"all"} is found in any character value or list name, all remaining parsers will be added.
When using a list, parser information already defined will maintain their existing argument values.  All remaining parsers will use their default arguments.

Example:\preformatted{# provide a character string
parsers = "json"

# provide a named list with no arguments
parsers = list(json = list())

# provide a named list with arguments; include `rds`
parsers = list(json = list(simplifyVector = FALSE), rds = list())

# default plumber parsers
parsers = c("json", "form", "text", "octet", "multi")
}}

\item{\code{lines}}{Endpoint block}

\item{\code{params}}{Endpoint params}

\item{\code{comments, responses, tags}}{Values to be used within the OpenAPI Spec}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{PlumberEndpoint} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPathParams"></a>}}
\if{latex}{\out{\hypertarget{method-getPathParams}{}}}
\subsection{Method \code{getPathParams()}}{
retrieve endpoint path parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$getPathParams(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{endpoint path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFuncParams"></a>}}
\if{latex}{\out{\hypertarget{method-getFuncParams}{}}}
\subsection{Method \code{getFuncParams()}}{
retrieve endpoint expression parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$getFuncParams()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getEndpointParams"></a>}}
\if{latex}{\out{\hypertarget{method-getEndpointParams}{}}}
\subsection{Method \code{getEndpointParams()}}{
retrieve endpoint defined parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$getEndpointParams()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
