% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{group_bootstraps}
\alias{group_bootstraps}
\title{Group Bootstraps}
\usage{
group_bootstraps(
  data,
  group,
  times = 25,
  apparent = FALSE,
  ...,
  strata = NULL,
  pool = 0.1
)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A variable in \code{data} (single character or name) used for
grouping observations with the same value to either the analysis or
assessment set within a fold.}

\item{times}{The number of bootstrap samples.}

\item{apparent}{A logical. Should an extra resample be added where the
analysis and holdout subset are the entire data set. This is required for
some estimators used by the \code{\link[=summary]{summary()}} function that require the apparent
error rate.}

\item{...}{These dots are for future extensions and must be empty.}

\item{strata}{A variable in \code{data} (single character or name) used to conduct
stratified sampling. When not \code{NULL}, each resample is created within the
stratification variable. Numeric \code{strata} are binned into quartiles.}

\item{pool}{A proportion of data used to determine if a particular group is
too small and should be pooled into another group. We do not recommend
decreasing this argument below its default of 0.1 because of the dangers
of stratifying groups that are too small.}
}
\value{
An tibble with classes \code{group_bootstraps} \code{bootstraps}, \code{rset},
\code{tbl_df}, \code{tbl}, and \code{data.frame}. The results include a column for the data
split objects and a column called \code{id} that has a character string with the
resample identifier.
}
\description{
Group bootstrapping creates splits of the data based
on some grouping variable (which may have more than a single row
associated with it). A common use of this kind of resampling is when you
have repeated measures of the same subject.
A bootstrap sample is a sample that is the same size as the original data
set that is made using replacement. This results in analysis samples that
have multiple replicates of some of the original rows of the data. The
assessment set is defined as the rows of the original data that were not
included in the bootstrap sample. This is often referred to as the
"out-of-bag" (OOB) sample.
}
\details{
The argument \code{apparent} enables the option of an additional
"resample" where the analysis and assessment data sets are the same as the
original data set. This can be required for some types of analysis of the
bootstrap results.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) withAutoprint(\{ # examplesIf}
data(ames, package = "modeldata")

set.seed(13)
group_bootstraps(ames, Neighborhood, times = 3)
group_bootstraps(ames, Neighborhood, times = 3, apparent = TRUE)
\dontshow{\}) # examplesIf}
}
