% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scattermore.R
\name{scattermoreplot}
\alias{scattermoreplot}
\title{scattermoreplot}
\usage{
scattermoreplot(
  x,
  y,
  xlim,
  ylim,
  size,
  col = grDevices::rgb(0, 0, 0, 1),
  cex = 0,
  pch = NULL,
  xlab,
  ylab,
  ...
)
}
\arguments{
\item{x, y, xlim, ylim, xlab, ylab, ...}{used as in \code{\link[graphics:plot.default]{graphics::plot()}} or forwarded to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{size}{forwarded to \code{\link[=scattermore]{scattermore()}}, or auto-derived from device and plot size if missing (the estimate is not pixel-perfect on most devices, but gets pretty close)}

\item{col}{point color(s)}

\item{cex}{forwarded to \code{\link[=scattermore]{scattermore()}}}

\item{pch}{ignored (to improve compatibility with \code{\link[graphics:plot.default]{graphics::plot()}}}
}
\description{
Convenience base-graphics-like layer around scattermore. Currently only works with linear axes!
}
\examples{
# plot an actual rainbow
library(scattermore)
d <- data.frame(s = qlogis(1:1e6 / (1e6 + 1), 6, 0.5), t = rnorm(1e6, pi / 2, 0.5))
scattermoreplot(
  d$s * cos(d$t),
  d$s * sin(d$t),
  col = rainbow(1e6, alpha = .05)[c((9e5 + 1):1e6, 1:9e5)],
  main = "scattermore demo"
)
}
