/*! shiny 1.5.0 | (c) 2012-2020 RStudio, Inc. | License: GPL-3 | file LICENSE */

"use strict";function _typeof(e){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function _defineProperty(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}!function(){var $=jQuery,exports=window.Shiny=window.Shiny||{};exports.version="1.5.0";var origPushState=window.history.pushState;function escapeHTML(e){var t={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#039;","/":"&#x2F;"};return e.replace(/[&<>'"\/]/g,function(e){return t[e]})}function randomId(){return Math.floor(4294967296+64424509440*Math.random()).toString(16)}function strToBool(e){if(e&&e.toLowerCase)switch(e.toLowerCase()){case"true":return!0;case"false":return!1;default:return}}function getStyle(e,t){var n;if(e.currentStyle)n=e.currentStyle[t];else if(window.getComputedStyle){var i=document.defaultView.getComputedStyle(e,null);i&&(n=i.getPropertyValue(t))}return n}function padZeros(e,t){for(var n=e.toString();n.length<t;)n="0"+n;return n}function roundSignif(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:1;if(t<1)throw"Significant digits must be at least 1.";return parseFloat(e.toPrecision(t))}function parseDate(e){var t=new Date(e);return isNaN(t)&&(t=new Date(e.replace(/-/g,"/"))),t}function formatDateUTC(e){return e instanceof Date?e.getUTCFullYear()+"-"+padZeros(e.getUTCMonth()+1,2)+"-"+padZeros(e.getUTCDate(),2):null}function makeResizeFilter(t,n){var i={};return function(){var e={w:t.offsetWidth,h:t.offsetHeight};0===e.w&&0===e.h||e.w===i.w&&e.h===i.h||n((i=e).w,e.h)}}window.history.pushState=function(){var e=origPushState.apply(this,arguments);return $(document).trigger("pushstate"),e},$(document).on("submit","form:not([action])",function(e){e.preventDefault()});var _BlobBuilder=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder;function makeBlob(t){try{return new Blob(t)}catch(e){var n=new _BlobBuilder;return $.each(t,function(e,t){n.append(t)}),n.getBlob()}}function pixelRatio(){return window.devicePixelRatio?window.devicePixelRatio:1}function scopeExprToFunc(t){var e=t.replace(/[\\"']/g,"\\$&").replace(/\u0000/g,"\\0").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[\b]/g,"\\b");try{var n=new Function("with (this) {\n        try {\n          return (".concat(t,");\n        } catch (e) {\n          console.error('Error evaluating expression: ").concat(e,"');\n          throw e;\n        }\n      }"))}catch(e){throw console.error("Error parsing expression: "+t),e}return function(e){return n.call(e)}}function asArray(e){return null==e?[]:$.isArray(e)?e:[e]}function mergeSort(e,t){function n(e,t,n){for(var i=0,a=0,r=[];i<t.length&&a<n.length;)e(t[i],n[a])<=0?r.push(t[i++]):r.push(n[a++]);for(;i<t.length;)r.push(t[i++]);for(;a<n.length;)r.push(n[a++]);return r}e=e.slice(0);for(var i=1;i<e.length;i*=2)for(var a=0;a<e.length;a+=2*i){var r=n(t,e.slice(a,a+i),e.slice(a+i,a+2*i)),o=[a,r.length];Array.prototype.push.apply(o,r),Array.prototype.splice.apply(e,o)}return e}var $escape=exports.$escape=function(e){return e.replace(/([!"#$%&'()*+,.\/:;<=>?@\[\\\]^`{|}~])/g,"\\$1")};function mapValues(e,t){var n={};for(var i in e)e.hasOwnProperty(i)&&(n[i]=t(e[i],i,e));return n}function isnan(e){return"number"==typeof e&&isNaN(e)}function _equal(e,t){if("object"===$.type(e)&&"object"===$.type(t)){if(Object.keys(e).length!==Object.keys(t).length)return;for(var n in e)if(!t.hasOwnProperty(n)||!_equal(e[n],t[n]))return;return 1}if("array"!==$.type(e)||"array"!==$.type(t))return e===t;if(e.length===t.length){for(var i=0;i<e.length;i++)if(!_equal(e[i],t[i]))return;return 1}}function equal(){if(arguments.length<2)throw new Error("equal requires at least two arguments.");for(var e=0;e<arguments.length-1;e++)if(!_equal(e<0||arguments.length<=e?void 0:arguments[e],e+1<0||arguments.length<=e+1?void 0:arguments[e+1]))return;return 1}function updateLabel(e,t){if(void 0!==e){if(1!==t.length)throw new Error("labelNode must be of length 1");$.isArray(e)&&0===e.length?t.addClass("shiny-label-null"):(t.text(e),t.removeClass("shiny-label-null"))}}exports.compareVersion=function(e,t,n){function r(e){return(e+"").replace(/-/,".").replace(/(\.0)+[^\.]*$/,"").split(".")}var i=function(e,t){e=r(e),t=r(t);for(var n,i=Math.min(e.length,t.length),a=0;a<i;a++)if(0!=(n=parseInt(e[a],10)-parseInt(t[a],10)))return n;return e.length-t.length}(e,n);if("=="===t)return 0===i;if(">="===t)return 0<=i;if(">"===t)return 0<i;if("<="===t)return i<=0;if("<"===t)return i<0;throw"Unknown operator: ".concat(t)};var browser=function(){var e=!1;/\bQt\//.test(window.navigator.userAgent)&&($(document.documentElement).addClass("qt"),e=!0),/\bQt\/5/.test(window.navigator.userAgent)&&/Linux/.test(window.navigator.userAgent)&&$(document.documentElement).addClass("qt5");var n="Microsoft Internet Explorer"===navigator.appName;return{isQt:e,isIE:n,IEVersion:function(){var e=-1;if(n){var t=navigator.userAgent;null!==new RegExp("MSIE ([0-9]{1,}[\\.0-9]{0,})").exec(t)&&(e=parseFloat(RegExp.$1))}return e}()}}(),Invoker=function(e,t){this.target=e,this.func=t};(function(){this.normalCall=this.immediateCall=function(){this.func.apply(this.target,arguments)}}).call(Invoker.prototype);var Debouncer=function(e,t,n){this.target=e,this.func=t,this.delayMs=n,this.timerId=null,this.args=null};(function(){this.normalCall=function(){var e=this;this.$clearTimer(),this.args=arguments,this.timerId=setTimeout(function(){null!==e.timerId&&(e.$clearTimer(),e.$invoke())},this.delayMs)},this.immediateCall=function(){this.$clearTimer(),this.args=arguments,this.$invoke()},this.isPending=function(){return null!==this.timerId},this.$clearTimer=function(){null!==this.timerId&&(clearTimeout(this.timerId),this.timerId=null)},this.$invoke=function(){this.func.apply(this.target,this.args),this.args=null}}).call(Debouncer.prototype);var Throttler=function(e,t,n){this.target=e,this.func=t,this.delayMs=n,this.timerId=null,this.args=null};function debounce(e,t){var n,i,a=null;return function(){n=this,i=arguments,null!==a&&(clearTimeout(a),a=null),a=setTimeout(function(){null!==a&&(a=null,t.apply(n,i))},e)}}function throttle(e,t){return 1}(function(){this.normalCall=function(){var e=this;this.args=arguments,null===this.timerId&&(this.$invoke(),this.timerId=setTimeout(function(){null!==e.timerId&&(e.$clearTimer(),e.args&&e.normalCall.apply(e,e.args))},this.delayMs))},this.immediateCall=function(){this.$clearTimer(),this.args=arguments,this.$invoke()},this.isPending=function(){return null!==this.timerId},this.$clearTimer=function(){null!==this.timerId&&(clearTimeout(this.timerId),this.timerId=null)},this.$invoke=function(){this.func.apply(this.target,this.args),this.args=null}}).call(Throttler.prototype);var InputBatchSender=function(e){this.shinyapp=e,this.timerId=null,this.pendingData={},this.reentrant=!1,this.lastChanceCallback=[]};(function(){this.setInput=function(e,t,n){this.pendingData[e]=t,this.reentrant||("event"===n.priority?this.$sendNow():this.timerId||(this.timerId=setTimeout(this.$sendNow.bind(this),0)))},this.$sendNow=function(){this.reentrant&&console.trace("Unexpected reentrancy in InputBatchSender!"),this.reentrant=!0;try{this.timerId=null,$.each(this.lastChanceCallback,function(e,t){t()});var e=this.pendingData;this.pendingData={},this.shinyapp.sendInput(e)}finally{this.reentrant=!1}}}).call(InputBatchSender.prototype);var InputNoResendDecorator=function(e,t){this.target=e,this.lastSentValues=this.reset(t)};(function(){this.setInput=function(e,t,n){var i=splitInputNameType(e),a=i.name,r=i.inputType,o=JSON.stringify(t);"event"!==n.priority&&this.lastSentValues[a]&&this.lastSentValues[a].jsonValue===o&&this.lastSentValues[a].inputType===r||(this.lastSentValues[a]={jsonValue:o,inputType:r},this.target.setInput(e,t,n))},this.reset=function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},t={};for(var n in e)if(e.hasOwnProperty(n)){var i=splitInputNameType(n),a=i.name,r=i.inputType;t[a]={jsonValue:JSON.stringify(e[n]),inputType:r}}this.lastSentValues=t}}).call(InputNoResendDecorator.prototype);var InputEventDecorator=function(e){this.target=e};(function(){this.setInput=function(e,t,n){var i=jQuery.Event("shiny:inputchanged"),a=splitInputNameType(e);if(i.name=a.name,i.inputType=a.inputType,i.value=t,i.binding=n.binding,i.el=n.el,i.priority=n.priority,$(n.el).trigger(i),!i.isDefaultPrevented()){var r=i.name;""!==i.inputType&&(r+=":"+i.inputType),this.target.setInput(r,i.value,{priority:n.priority})}}}).call(InputEventDecorator.prototype);var InputRateDecorator=function(e){this.target=e,this.inputRatePolicies={}};(function(){this.setInput=function(e,t,n){var i=splitInputNameType(e).name;this.$ensureInit(i),"deferred"!==n.priority?this.inputRatePolicies[i].immediateCall(e,t,n):this.inputRatePolicies[i].normalCall(e,t,n)},this.setRatePolicy=function(e,t,n){var i=splitInputNameType(e).name;"direct"===t?this.inputRatePolicies[i]=new Invoker(this,this.$doSetInput):"debounce"===t?this.inputRatePolicies[i]=new Debouncer(this,this.$doSetInput,n):"throttle"===t&&(this.inputRatePolicies[i]=new Throttler(this,this.$doSetInput,n))},this.$ensureInit=function(e){e in this.inputRatePolicies||this.setRatePolicy(e,"direct")},this.$doSetInput=function(e,t,n){this.target.setInput(e,t,n)}}).call(InputRateDecorator.prototype);var InputDeferDecorator=function(e){this.target=e,this.pendingInput={}};(function(){this.setInput=function(e,t,n){/^\./.test(e)?this.target.setInput(e,t,n):this.pendingInput[e]={value:t,opts:n}},this.submit=function(){for(var e in this.pendingInput)if(this.pendingInput.hasOwnProperty(e)){var t=this.pendingInput[e],n=t.value,i=t.opts;this.target.setInput(e,n,i)}}}).call(InputDeferDecorator.prototype);var InputValidateDecorator=function(e){this.target=e};function addDefaultInputOpts(e){if((e=$.extend({priority:"immediate",binding:null,el:null},e))&&void 0!==e.priority)switch(e.priority){case"deferred":case"immediate":case"event":break;default:throw new Error("Unexpected input value mode: '"+e.priority+"'")}return e}function splitInputNameType(e){var t=e.split(":");return{name:t[0],inputType:1<t.length?t[1]:""}}(function(){this.setInput=function(e,t,n){if(!e)throw"Can't set input with empty name.";n=addDefaultInputOpts(n),this.target.setInput(e,t,n)}}).call(InputValidateDecorator.prototype);var ShinyApp=function(){this.$socket=null,this.$inputValues={},this.$initialInput={},this.$bindings={},this.$values={},this.$errors={},this.$conditionals={},this.$pendingMessages=[],this.$activeRequests={},this.$nextRequestId=0,this.$allowReconnect=!1},Gg,Ng;function Hg(){var e=$("#shiny-reconnect-time");if(0!==e.length){var t=Math.floor((Gg-(new Date).getTime())/1e3);0<t?e.text(" in "+t+"s"):e.text("..."),setTimeout(Hg,1e3)}}function Pg(e){Qg(e).fadeOut(Ng,function(){exports.unbindAll(this),$(this).remove(),0===Sg().find(".shiny-notification").map(function(){return this.id.replace(/shiny-notification-/,"")}).get().length&&Sg().remove()})}function Qg(e){return e?Sg().find("#shiny-notification-"+$escape(e)):null}function Sg(){return $("#shiny-notification-panel")}function Wg(e){var t=Qg(e).data("removalCallback");t&&clearTimeout(t)}(function(){this.connect=function(e){if(this.$socket)throw"Connect was already called on this application object";this.$socket=this.createSocket(),this.$initialInput=e,$.extend(this.$inputValues,e),this.$updateConditionals()},this.isConnected=function(){return!!this.$socket};var scheduledReconnect=null;this.reconnect=function(){if(clearTimeout(scheduledReconnect),this.isConnected())throw"Attempted to reconnect, but already connected.";this.$socket=this.createSocket(),this.$initialInput=$.extend({},this.$inputValues),this.$updateConditionals()},this.createSocket=function(){var t=this,n=(exports.createSocket||function(){var e="ws:";"https:"===window.location.protocol&&(e="wss:");var t=window.location.pathname;/^([$#!&-;=?-[\]_a-z~]|%[0-9a-fA-F]{2})+$/.test(t)||(t=encodeURI(t),browser.isQt&&(t=encodeURI(t))),/\/$/.test(t)||(t+="/"),t+="websocket/";var n=new WebSocket(e+"//"+window.location.host+t);return n.binaryType="arraybuffer",n})(),i=!1;return n.onopen=function(){for(i=!0,$(document).trigger({type:"shiny:connected",socket:n}),t.onConnected(),n.send(JSON.stringify({method:"init",data:t.$initialInput}));t.$pendingMessages.length;){var e=t.$pendingMessages.shift();n.send(e)}},n.onmessage=function(e){t.dispatchMessage(e.data)},n.onclose=function(){i&&($(document).trigger({type:"shiny:disconnected",socket:n}),t.$notifyDisconnected()),t.onDisconnected(),t.$removeSocket()},n},this.sendInput=function(e){var t=JSON.stringify({method:"update",data:e});this.$sendMsg(t),$.extend(this.$inputValues,e),this.$updateConditionals()},this.$notifyDisconnected=function(){window.parent&&window.parent.postMessage("disconnected","*")},this.$removeSocket=function(){this.$socket=null},this.$scheduleReconnect=function(e){var t=this;scheduledReconnect=setTimeout(function(){t.reconnect()},e)};var reconnectDelay=(Ic=0,Jc=[1500,1500,2500,2500,5500,5500,10500],{next:function(){var e=Ic;return Jc.length<=e&&(e=Jc.length-1),Ic++,Jc[e]},reset:function(){Ic=0}}),Ic,Jc;function narrowScopeComponent(t,n){return Object.keys(t).filter(function(e){return 0===e.indexOf(n)}).map(function(e){return _defineProperty({},e.substring(n.length),t[e])}).reduce(function(e,t){return $.extend(e,t)},{})}function narrowScope(e,t){return t?{input:narrowScopeComponent(e.input,t),output:narrowScopeComponent(e.output,t)}:e}this.onDisconnected=function(){if(0===$("#shiny-disconnected-overlay").length&&$(document.body).append('<div id="shiny-disconnected-overlay"></div>'),!0===this.$allowReconnect&&!0===this.$socket.allowReconnect||"force"===this.$allowReconnect){var e=reconnectDelay.next();exports.showReconnectDialog(e),this.$scheduleReconnect(e)}},this.onConnected=function(){$("#shiny-disconnected-overlay").remove(),exports.hideReconnectDialog(),reconnectDelay.reset()},this.makeRequest=function(e,t,n,i,a){for(var r=this.$nextRequestId;this.$activeRequests[r];)r=(r+1)%1e9;this.$nextRequestId=r+1,this.$activeRequests[r]={onSuccess:n,onError:i};var o=JSON.stringify({method:e,args:t,tag:r});if(a){var s=function(e){var t=new ArrayBuffer(4);return new DataView(t).setUint32(0,e,!0),t},u=[];u.push(s(16908802));var l=makeBlob([o]);u.push(s(l.size)),u.push(l);for(var d=0;d<a.length;d++)u.push(s(a[d].byteLength||a[d].size||0)),u.push(a[d]);o=makeBlob(u)}this.$sendMsg(o)},this.$sendMsg=function(e){this.$socket.readyState?this.$socket.send(e):this.$pendingMessages.push(e)},this.receiveError=function(e,t){if(this.$errors[e]!==t){this.$errors[e]=t,delete this.$values[e];var n=this.$bindings[e],i=jQuery.Event("shiny:error");i.name=e,i.error=t,i.binding=n,$(n?n.el:document).trigger(i),!i.isDefaultPrevented()&&n&&n.onValueError&&n.onValueError(i.error)}},this.receiveOutput=function(e,t){var n=this.$bindings[e],i=jQuery.Event("shiny:value");if(i.name=e,i.value=t,i.binding=n,this.$values[e]!==t)return this.$values[e]=t,delete this.$errors[e],$(n?n.el:document).trigger(i),!i.isDefaultPrevented()&&n&&n.onValueChange(i.value),t;$(n?n.el:document).trigger(i)},this.bindOutput=function(e,t){if(!e)throw"Can't bind an element with no ID";if(this.$bindings[e])throw"Duplicate binding for ID "+e;return this.$bindings[e]=t,void 0!==this.$values[e]?t.onValueChange(this.$values[e]):void 0!==this.$errors[e]&&t.onValueError(this.$errors[e]),t},this.unbindOutput=function(e,t){return this.$bindings[e]===t&&(delete this.$bindings[e],!0)},this.$updateConditionals=function(){$(document).trigger({type:"shiny:conditional"});var e={};for(var t in this.$inputValues){if(this.$inputValues.hasOwnProperty(t))e[t.replace(/:.*/,"")]=this.$inputValues[t]}for(var n={input:e,output:this.$values},i=$(document).find("[data-display-if]"),a=0;a<i.length;a++){var r=$(i[a]),o=r.data("data-display-if-func");if(!o)o=scopeExprToFunc(r.attr("data-display-if")),r.data("data-display-if-func",o);var s=o(narrowScope(n,r.attr("data-ns-prefix")));s!==("none"!==r.css("display"))&&(s?(r.trigger("show"),r.show(),r.trigger("shown")):(r.trigger("hide"),r.hide(),r.trigger("hidden")))}};var messageHandlerOrder=[],messageHandlers={},customMessageHandlerOrder=[],customMessageHandlers={};function addMessageHandler(e,t){if(messageHandlers[e])throw'handler for message of type "'+e+'" already added.';if("function"!=typeof t)throw"handler must be a function.";if(1!==t.length)throw"handler must be a function that takes one argument.";messageHandlerOrder.push(e),messageHandlers[e]=t}function addCustomMessageHandler(e,t){if(customMessageHandlers[e]){var n=customMessageHandlerOrder.indexOf(e);-1!==n&&(customMessageHandlerOrder.splice(n,1),delete customMessageHandlers[e])}if("function"!=typeof t)throw"handler must be a function.";if(1!==t.length)throw"handler must be a function that takes one argument.";customMessageHandlerOrder.push(e),customMessageHandlers[e]=t}function getTabset(e){var t=$("#"+$escape(e));if(0===t.length)throw"There is no tabsetPanel (or navbarPage or navlistPanel) with id equal to '"+e+"'";return t}function getTabContent(e){var t=e.attr("data-tabsetid");return $("div.tab-content[data-tabsetid='"+$escape(t)+"']")}function getTargetTabs(e,t,n){var i="[data-value='"+$escape(n)+"']",a=e.find("a"+i),r=a.parent();if(0===r.length)throw"There is no tabPanel (or navbarMenu) with value (or menuName) equal to '"+n+"'";var o=[],s=[];if("dropdown"===a.attr("data-toggle")){var u=a.find("+ ul.dropdown-menu"),l=u.attr("data-tabsetid");u.find("a[data-toggle='tab']").parent("li").each(function(e,t){o.push($(t))});var d="div.tab-pane[id^='tab-"+$escape(l)+"']";t.find(d).each(function(e,t){s.push($(t))})}else s.push(t.find("div"+i));return{$liTag:r,$liTags:o,$divTags:s}}function ensureTabsetHasVisibleTab(e){if(0===e.find("li.active").not(".dropdown").length){var t=getFirstTab(e),n=e.data("shiny-input-binding"),i=jQuery.Event("shiny:updateinput");i.binding=n,e.trigger(i),n.setValue(e[0],t)}}function getFirstTab(e){return e.find("li:visible a[data-toggle='tab']").first().attr("data-value")||null}function tabApplyFunction(e,n){var i=2<arguments.length&&void 0!==arguments[2]&&arguments[2];$.each(e,function(e,t){"$liTag"===e?n(t):"$divTags"===e?$.each(t,function(e,t){n(t)}):i&&"$liTags"===e&&$.each(t,function(e,t){n(t)})})}exports.addCustomMessageHandler=addCustomMessageHandler,this.dispatchMessage=function(e){var t={};if("string"==typeof e)t=JSON.parse(e);else{for(var n=new DataView(e,0,1).getUint8(0),i=new DataView(e,1,n),a=[],r=0;r<n;r++)a.push(String.fromCharCode(i.getUint8(r)));var o=a.join("");e=e.slice(n+1),t.custom={},t.custom[o]=e}var s=jQuery.Event("shiny:message");s.message=t,$(document).trigger(s),s.isDefaultPrevented()||(this._sendMessagesToHandlers(s.message,messageHandlers,messageHandlerOrder),this.$updateConditionals())},this._sendMessagesToHandlers=function(e,t,n){for(var i=0;i<n.length;i++){var a=n[i];e.hasOwnProperty(a)&&t[a].call(this,e[a])}},addMessageHandler("values",function(e){for(var t in this.$bindings)this.$bindings.hasOwnProperty(t)&&this.$bindings[t].showProgress(!1);for(var n in e)e.hasOwnProperty(n)&&this.receiveOutput(n,e[n])}),addMessageHandler("errors",function(e){for(var t in e)e.hasOwnProperty(t)&&this.receiveError(t,e[t])}),addMessageHandler("inputMessages",function(e){for(var t=0;t<e.length;t++){var n=$(".shiny-bound-input#"+$escape(e[t].id)),i=n.data("shiny-input-binding");if(0<n.length){var a=n[0],r=jQuery.Event("shiny:updateinput");r.message=e[t].message,r.binding=i,$(a).trigger(r),r.isDefaultPrevented()||i.receiveMessage(a,r.message)}}}),addMessageHandler("javascript",function(message){eval(message)}),addMessageHandler("console",function(e){for(var t=0;t<e.length;t++)console.log&&console.log(e[t])}),addMessageHandler("progress",function(e){if(e.type&&e.message){var t=progressHandlers[e.type];t&&t.call(this,e.message)}}),addMessageHandler("notification",function(e){if("show"===e.type)exports.notifications.show(e.message);else{if("remove"!==e.type)throw"Unkown notification type: "+e.type;exports.notifications.remove(e.message)}}),addMessageHandler("modal",function(e){if("show"===e.type)exports.modal.show(e.message);else{if("remove"!==e.type)throw"Unkown modal type: "+e.type;exports.modal.remove()}}),addMessageHandler("response",function(e){var t=e.tag,n=this.$activeRequests[t];n&&(delete this.$activeRequests[t],"value"in e?n.onSuccess(e.value):n.onError(e.error))}),addMessageHandler("allowReconnect",function(e){if(!0!==e&&!1!==e&&"force"!==e)throw"Invalid value for allowReconnect: "+e;this.$allowReconnect=e}),addMessageHandler("custom",function(e){exports.oncustommessage&&exports.oncustommessage(e),this._sendMessagesToHandlers(e,customMessageHandlers,customMessageHandlerOrder)}),addMessageHandler("config",function(e){this.config={workerId:e.workerId,sessionId:e.sessionId},e.user&&(exports.user=e.user),$(document).trigger("shiny:sessioninitialized")}),addMessageHandler("busy",function(e){"busy"===e?($(document.documentElement).addClass("shiny-busy"),$(document).trigger("shiny:busy")):"idle"===e&&($(document.documentElement).removeClass("shiny-busy"),$(document).trigger("shiny:idle"))}),addMessageHandler("recalculating",function(e){if(e.hasOwnProperty("name")&&e.hasOwnProperty("status")){var t=this.$bindings[e.name];$(t?t.el:null).trigger({type:"shiny:"+e.status})}}),addMessageHandler("reload",function(e){window.location.reload()}),addMessageHandler("shiny-insert-ui",function(n){var e=$(n.selector);0===e.length?(console.warn('The selector you chose ("'+n.selector+'") could not be found in the DOM.'),exports.renderHtml(n.content.html,$([]),n.content.deps)):e.each(function(e,t){return exports.renderContent(t,n.content,n.where),n.multiple})}),addMessageHandler("shiny-remove-ui",function(n){$(n.selector).each(function(e,t){return exports.unbindAll(t,!0),$(t).remove(),n.multiple})}),addMessageHandler("shiny-insert-tab",function(r){var e=getTabset(r.inputId),t=e,n=getTabContent(t),i=e.attr("data-tabsetid"),a=$(r.divTag.html),o=$(r.liTag.html),s=o.find("> a"),u=null,l=null;null!==r.target&&(u=getTargetTabs(t,n,r.target),l=u.$liTag);var d,c,p=function(){{if(null!==r.menuName){var e=$("a.dropdown-toggle[data-value='"+$escape(r.menuName)+"']");if(0===e.length)throw"There is no navbarMenu with menuName equal to '"+r.menuName+"'";var t=e.find("+ ul.dropdown-menu"),n=t.attr("data-tabsetid");return{$tabset:t,id:n}}if(null!==r.target){var i=l.parent("ul");if(i.hasClass("dropdown-menu")){var a=i.attr("data-tabsetid");return{$tabset:i,id:a}}}}return null}();if(null!==p){if("dropdown"===s.attr("data-toggle"))throw"Cannot insert a navbarMenu inside another one";t=p.$tabset,i=p.id}if("tab"===s.attr("data-toggle")){var h="tab-"+i+"-"+(d=i,c=[0],t.find("> li").each(function(){var e=$(this).find("> a[data-toggle='tab']");if(0<e.length){var t=e.attr("href").replace(/.*(?=#[^\s]+$)/,"").replace("#tab-"+d+"-","");c.push(Number(t))}}),Math.max.apply(null,c)+1);o.find("> a").attr("href","#"+h),a.attr("id",h)}"before"===r.position?l?l.before(o):t.append(o):"after"===r.position&&(l?l.after(o):t.prepend(o)),exports.renderContent(o[0],{html:o.html(),deps:r.liTag.deps}),exports.renderContent(n[0],{html:"",deps:r.divTag.deps},"beforeend"),a.get().forEach(function(e){n[0].appendChild(e),exports.renderContent(e,e.innerHTML||e.textContent)}),r.select&&o.find("a").tab("show")}),addMessageHandler("shiny-remove-tab",function(e){var t=getTabset(e.inputId);tabApplyFunction(getTargetTabs(t,getTabContent(t),e.target),function(e){exports.unbindAll(e,!0),e.remove()}),ensureTabsetHasVisibleTab(t)}),addMessageHandler("shiny-change-tab-visibility",function(t){var e=getTabset(t.inputId);tabApplyFunction(getTargetTabs(e,getTabContent(e),t.target),function(e){"show"===t.type?e.css("display",""):"hide"===t.type&&(e.hide(),e.removeClass("active"))},!0),ensureTabsetHasVisibleTab(e)}),addMessageHandler("updateQueryString",function(e){if("replace"!==e.mode){var t=null;if("#"===e.queryString.charAt(0))t="hash";else{if("?"!==e.queryString.charAt(0))throw"The 'query' string must start with either '?' (to update the query string) or with '#' (to update the hash).";t="query"}var n=window.location.pathname,i=window.location.search,a=window.location.hash,r=n;r+="query"===t?e.queryString:i+e.queryString,window.history.pushState(null,null,r),-1!==e.queryString.indexOf("#")&&(t="hash"),window.location.hash!==a&&(t="hash"),"hash"===t&&$(document).trigger("hashchange")}else window.history.replaceState(null,null,e.queryString)}),addMessageHandler("resetBrush",function(e){exports.resetBrush(e.brushId)});var progressHandlers={binding:function(e){var t=e.id,n=this.$bindings[t];n&&($(n.el).trigger({type:"shiny:outputinvalidated",binding:n,name:t}),n.showProgress&&n.showProgress(!0))},open:function(e){if("notification"===e.style)exports.notifications.show({html:'<div id="shiny-progress-'.concat(e.id,'" class="shiny-progress-notification">')+'<div class="progress active" style="display: none;"><div class="progress-bar"></div></div><div class="progress-text"><span class="progress-message">message</span> <span class="progress-detail"></span></div></div>',id:e.id,duration:null});else if("old"===e.style){var t=$(".shiny-progress-container");0===t.length&&(t=$('<div class="shiny-progress-container"></div>'),$(document.body).append(t));var n=$(".shiny-progress.open").length,i=$('<div class="shiny-progress open"><div class="progress active"><div class="progress-bar bar"></div></div><div class="progress-text"><span class="progress-message">message</span><span class="progress-detail"></span></div></div>');i.attr("id",e.id),t.append(i);var a=i.find(".progress");a.css("top",n*a.height()+"px");var r=i.find(".progress-text");r.css("top",3*a.height()+n*r.outerHeight()+"px"),i.hide()}},update:function(e){if("notification"===e.style){if(0===(t=$("#shiny-progress-"+e.id)).length)return;void 0!==e.message&&t.find(".progress-message").text(e.message),void 0!==e.detail&&t.find(".progress-detail").text(e.detail),void 0!==e.value&&null!==e.value&&(t.find(".progress").show(),t.find(".progress-bar").width(100*e.value+"%"))}else if("old"===e.style){var t=$("#"+e.id+".shiny-progress");void 0!==e.message&&t.find(".progress-message").text(e.message),void 0!==e.detail&&t.find(".progress-detail").text(e.detail),void 0!==e.value&&null!==e.value&&(t.find(".progress").show(),t.find(".bar").width(100*e.value+"%")),t.fadeIn()}},close:function(e){if("notification"===e.style)exports.notifications.remove(e.id);else if("old"===e.style){var t=$("#"+e.id+".shiny-progress");t.removeClass("open"),t.fadeOut({complete:function(){t.remove(),0===$(".shiny-progress").length&&$(".shiny-progress-container").remove()}})}}};exports.progressHandlers=progressHandlers,this.getTestSnapshotBaseUrl=function(){var e=(0<arguments.length&&void 0!==arguments[0]?arguments[0]:{}).fullUrl,t=void 0===e||e,n=window.location,i="";return t&&(i=n.origin+n.pathname.replace(/\/[^/]*$/,"")),i+="/session/"+encodeURIComponent(this.config.sessionId)+"/dataobj/shinytest?w="+encodeURIComponent(this.config.workerId)+"&nonce="+randomId()}}).call(ShinyApp.prototype),exports.showReconnectDialog=(Gg=null,function(e){Gg=(new Date).getTime()+e,0<$("#shiny-reconnect-text").length||(exports.notifications.show({id:"reconnect",html:'<span id="shiny-reconnect-text">Attempting to reconnect</span><span id="shiny-reconnect-time"></span>',action:'<a id="shiny-reconnect-now" href="#" onclick="Shiny.shinyapp.reconnect();">Try now</a>',duration:null,closeButton:!1,type:"warning"}),Hg())}),exports.hideReconnectDialog=function(){exports.notifications.remove("reconnect")},exports.notifications=(Ng=250,{show:function(){var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:{},t=e.html,n=void 0===t?"":t,i=e.action,a=void 0===i?"":i,r=e.deps,o=void 0===r?[]:r,s=e.duration,u=void 0===s?5e3:s,l=e.id,d=void 0===l?null:l,c=e.closeButton,p=void 0===c||c,h=e.type,g=void 0===h?null:h;d=d||randomId(),0<Sg().length||$(document.body).append('<div id="shiny-notification-panel">');var f=Qg(d);0===f.length&&(f=function(t){var e=Qg(t);return 0===e.length&&((e=$('<div id="shiny-notification-'.concat(t,'" class="shiny-notification">')+'<div class="shiny-notification-close">&times;</div><div class="shiny-notification-content"></div></div>')).find(".shiny-notification-close").on("click",function(e){e.preventDefault(),e.stopPropagation(),Pg(t)}),Sg().append(e)),e}(d));var m='<div class="shiny-notification-content-text">'.concat(n,"</div>")+'<div class="shiny-notification-content-action">'.concat(a,"</div>"),v=f.find(".shiny-notification-content");exports.renderContent(v,{html:m,deps:o});var y=f.attr("class").split(/\s+/).filter(function(e){return e.match(/^shiny-notification-/)}).join(" ");f.removeClass(y),g&&"default"!==g&&f.addClass("shiny-notification-"+g);var b=f.find(".shiny-notification-close");return p&&0===b.length?f.append('<div class="shiny-notification-close">&times;</div>'):p||0===b.length||b.remove(),u?function(e,t){Wg(e);var n=setTimeout(function(){Pg(e)},t);Qg(e).data("removalCallback",n)}(d,u):Wg(d),d},remove:Pg}),exports.modal={show:function(e){var t=0<arguments.length&&void 0!==e?e:{},n=t.html,i=void 0===n?"":n,a=t.deps,r=void 0===a?[]:a;$(".modal-backdrop").remove();var o=$("#shiny-modal-wrapper");0===o.length&&(o=$('<div id="shiny-modal-wrapper"></div>'),$(document.body).append(o),o.on("hidden.bs.modal",function(e){e.target===$("#shiny-modal")[0]&&(exports.unbindAll(o),o.remove())})),o.on("keydown.shinymodal",function(e){!1!==$("#shiny-modal").data("keyboard")&&27===e.keyCode&&(e.stopPropagation(),e.preventDefault())}),exports.renderContent(o,{html:i,deps:r})},remove:function(){var e=$("#shiny-modal-wrapper");e.off("keydown.shinymodal"),0<e.find(".modal").length?e.find(".modal").modal("hide"):(exports.unbindAll(e),e.remove())}};var FileProcessor=function(e){this.files=e,this.fileIndex=-1,this.aborted=!1,this.completed=!1,this.$run()};(function(){this.onBegin=function(e,t){setTimeout(t,0)},this.onFile=function(e,t){setTimeout(t,0)},this.onComplete=function(){},this.onAbort=function(){},this.abort=function(){this.completed||this.aborted||(this.aborted=!0,this.onAbort())},this.$getRun=function(){var e=this,t=!1;return function(){t||(t=!0,e.$run())}},this.$run=function(){if(!this.aborted&&!this.completed){if(this.fileIndex<0)return this.fileIndex=0,void this.onBegin(this.files,this.$getRun());if(this.fileIndex===this.files.length)return this.completed=!0,void this.onComplete();var e=this.files[this.fileIndex++];this.onFile(e,this.$getRun())}}}).call(FileProcessor.prototype);var BindingRegistry=function(){this.bindings=[],this.bindingNames={}};(function(){this.register=function(e,t,n){var i={binding:e,priority:n||0};this.bindings.unshift(i),t&&(this.bindingNames[t]=i,e.name=t)},this.setPriority=function(e,t){var n=this.bindingNames[e];if(!n)throw"Tried to set priority on unknown binding "+e;n.priority=t||0},this.getPriority=function(e){var t=this.bindingNames[e];return!!t&&t.priority},this.getBindings=function(){return mergeSort(this.bindings,function(e,t){return t.priority-e.priority})}}).call(BindingRegistry.prototype);var inputBindings=exports.inputBindings=new BindingRegistry,outputBindings=exports.outputBindings=new BindingRegistry,OutputBinding=exports.OutputBinding=function(){};(function(){this.find=function(e){throw"Not implemented"},this.getId=function(e){return e["data-input-id"]||e.id},this.onValueChange=function(e,t){this.clearError(e),this.renderValue(e,t)},this.onValueError=function(e,t){this.renderError(e,t)},this.renderError=function(e,t){if(this.clearError(e),""!==t.message){var n="shiny-output-error";null!==t.type&&(n=n+" "+$.map(asArray(t.type),function(e){return n+"-"+e}).join(" ")),$(e).addClass(n).text(t.message)}else $(e).empty()},this.clearError=function(e){$(e).attr("class",function(e,t){return t.replace(/(^|\s)shiny-output-error\S*/g,"")})},this.showProgress=function(e,t){var n="recalculating";t?$(e).addClass(n):$(e).removeClass(n)}}).call(OutputBinding.prototype);var textOutputBinding=new OutputBinding;$.extend(textOutputBinding,{find:function(e){return $(e).find(".shiny-text-output")},renderValue:function(e,t){$(e).text(t)}}),outputBindings.register(textOutputBinding,"shiny.textOutput");var imageOutputBinding=new OutputBinding;$.extend(imageOutputBinding,{find:function(e){return $(e).find(".shiny-image-output, .shiny-plot-output")},renderValue:function(e,r){var n,o=this.getId(e),s=$(e),u=s.find("img");if(0===u.length?(n=document.createElement("img"),s.append(n),u=$(n)):(n=u[0],u.trigger("reset")),r){var l={clickId:s.data("click-id"),clickClip:a(strToBool(s.data("click-clip")),!0),dblclickId:s.data("dblclick-id"),dblclickClip:a(strToBool(s.data("dblclick-clip")),!0),dblclickDelay:a(s.data("dblclick-delay"),400),hoverId:s.data("hover-id"),hoverClip:a(strToBool(s.data("hover-clip")),!0),hoverDelayType:a(s.data("hover-delay-type"),"debounce"),hoverDelay:a(s.data("hover-delay"),300),hoverNullOutside:a(strToBool(s.data("hover-null-outside")),!1),brushId:s.data("brush-id"),brushClip:a(strToBool(s.data("brush-clip")),!0),brushDelayType:a(s.data("brush-delay-type"),"debounce"),brushDelay:a(s.data("brush-delay"),300),brushFill:a(s.data("brush-fill"),"#666"),brushStroke:a(s.data("brush-stroke"),"#000"),brushOpacity:a(s.data("brush-opacity"),.3),brushDirection:a(s.data("brush-direction"),"xy"),brushResetOnNew:a(strToBool(s.data("brush-reset-on-new")),!1),coordmap:r.coordmap};$.each(r,function(e,t){null!==t&&"coordmap"!==e&&("src"===e&&t===n.getAttribute("src")&&n.removeAttribute("src"),n.setAttribute(e,t))});for(var t=0;t<n.attributes.length;t++){var i=n.attributes[t];i.specified&&!r.hasOwnProperty(i.name)&&n.removeAttribute(i.name)}l.coordmap||(l.coordmap={panels:[],dims:{height:null,width:null}}),s.off(".image_output"),u.off(".image_output"),u.off("load.shiny_image_interaction"),u.one("load.shiny_image_interaction",function(){imageutils.initCoordmap(s,l.coordmap);var e=imageutils.createClickInfo(s,l.dblclickId,l.dblclickDelay);if(s.on("mousedown.image_output",e.mousedown),browser.isIE&&8===browser.IEVersion&&s.on("dblclick.image_output",e.dblclickIE8),l.clickId){imageutils.disableDrag(s,u);var t=imageutils.createClickHandler(l.clickId,l.clickClip,l.coordmap);s.on("mousedown2.image_output",t.mousedown),s.on("resize.image_output",t.onResize),u.on("reset.image_output",t.onResetImg)}if(l.dblclickId){imageutils.disableDrag(s,u);var n=imageutils.createClickHandler(l.dblclickId,l.clickClip,l.coordmap);s.on("dblclick2.image_output",n.mousedown),s.on("resize.image_output",n.onResize),u.on("reset.image_output",n.onResetImg)}if(l.hoverId){imageutils.disableDrag(s,u);var i=imageutils.createHoverHandler(l.hoverId,l.hoverDelay,l.hoverDelayType,l.hoverClip,l.hoverNullOutside,l.coordmap);s.on("mousemove.image_output",i.mousemove),s.on("mouseout.image_output",i.mouseout),s.on("resize.image_output",i.onResize),u.on("reset.image_output",i.onResetImg)}if(l.brushId){imageutils.disableDrag(s,u);var a=imageutils.createBrushHandler(l.brushId,s,l,l.coordmap,o);s.on("mousedown.image_output",a.mousedown),s.on("mousemove.image_output",a.mousemove),s.on("resize.image_output",a.onResize),u.on("reset.image_output",a.onResetImg)}(l.clickId||l.dblclickId||l.hoverId||l.brushId)&&s.addClass("crosshair"),r.error&&console.log("Error on server extracting coordmap: "+r.error)})}else s.empty();function a(e,t){return void 0===e?t:e}},renderError:function(e,t){$(e).find("img").trigger("reset"),OutputBinding.prototype.renderError.call(this,e,t)},clearError:function(e){$(e).contents().filter(function(){return"IMG"!==this.tagName&&this.id!==e.id+"_brush"}).remove(),OutputBinding.prototype.clearError.call(this,e)},resize:function(e){$(e).find("img").trigger("resize")}}),outputBindings.register(imageOutputBinding,"shiny.imageOutput");var imageutils={};function findScalingRatio(e){var t=e[0].getBoundingClientRect();return{x:t.width/e.outerWidth(),y:t.height/e.outerHeight()}}function findOrigin(e){var t=e.offset(),n=findScalingRatio(e),i=parseInt(e.css("border-left-width"))+parseInt(e.css("padding-left")),a=parseInt(e.css("border-top-width"))+parseInt(e.css("padding-top"));return{x:t.left+n.x*i,y:t.top+n.y*a}}function findDims(e){var t=e.width()/e.outerWidth(),n=e.height()/e.outerHeight(),i=e[0].getBoundingClientRect();return{x:t*i.width,y:n*i.height}}imageutils.disableDrag=function(e,t){t.css("-webkit-user-drag","none"),t.off("dragstart.image_output"),t.on("dragstart.image_output",function(){return!1}),e.off("selectstart.image_output"),e.on("selectstart.image_output",function(){return!1})},imageutils.initPanelScales=function(e){function u(e,t,n,i,a,r){var o=(e-t)*((a-i)/(n-t))+i;if(r=r||!0){var s=Math.max(a,i),u=Math.min(a,i);s<o?o=s:o<u&&(o=u)}return o}function s(i,a,r,o,s){return{scale:function(e,t){return s&&(e=Math.log(e)/Math.log(s)),u(e,i,a,r,o,t)},scaleInv:function(e,t){var n=u(e,r,o,i,a,t);return s&&(n=Math.pow(s,n)),n}}}function t(i){var e=i.domain,t=i.range,n=i.log&&i.log.x?i.log.x:null,a=i.log&&i.log.y?i.log.y:null,r=s(e.left,e.right,t.left,t.right,n),o=s(e.bottom,e.top,t.bottom,t.top,a);i.scaleDataToImg=function(e,i){return mapValues(e,function(e,t){var n=t.substring(0,1);return"x"===n?r.scale(e,i):"y"===n?o.scale(e,i):null})},i.scaleImgToData=function(e,i){return mapValues(e,function(e,t){var n=t.substring(0,1);return"x"===n?r.scaleInv(e,i):"y"===n?o.scaleInv(e,i):null})},i.clipImg=function(e){var t={x:e.x,y:e.y},n=i.range;return e.x>n.right?t.x=n.right:e.x<n.left&&(t.x=n.left),e.y>n.bottom?t.y=n.bottom:e.y<n.top&&(t.y=n.top),t}}for(var n=0;n<e.length;n++){t(e[n])}},imageutils.initCoordmap=function(e,f){var n=e.find("img"),t=n[0];if(0===f.panels.length){var i={top:0,left:0,right:t.clientWidth-1,bottom:t.clientHeight-1};f.panels[0]={domain:i,range:i,mapping:{}}}f.dims.height=f.dims.height||t.naturalHeight,f.dims.width=f.dims.width||t.naturalWidth,imageutils.initPanelScales(f.panels),f.mouseOffsetCss=function(e){var t=findOrigin(n);return{x:e.pageX-t.x,y:e.pageY-t.y}},f.scaleCssToImg=function(i){var a=f.imgToCssScalingRatio();return mapValues(i,function(e,t){var n=t.substring(0,1);return"x"===n?i[t]/a.x:"y"===n?i[t]/a.y:null})},f.scaleImgToCss=function(i){var a=f.imgToCssScalingRatio();return mapValues(i,function(e,t){var n=t.substring(0,1);return"x"===n?i[t]*a.x:"y"===n?i[t]*a.y:null})},f.imgToCssScalingRatio=function(){var e=findDims(n);return{x:e.x/f.dims.width,y:e.y/f.dims.height}},f.cssToImgScalingRatio=function(){var e=f.imgToCssScalingRatio();return{x:1/e.x,y:1/e.y}},f.getPanelCss=function(e){for(var t,n=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0,i=f.scaleCssToImg(e),a=i.x,r=i.y,o=f.cssToImgScalingRatio(),s=n*o.x,u=n*o.y,l=[],d=[],c=0;c<f.panels.length;c++)if(a<=(t=f.panels[c].range).right+s&&a>=t.left-s&&r<=t.bottom+u&&r>=t.top-u){l.push(f.panels[c]);var p=0,h=0;a>t.right&&a<=t.right+s?p=a-t.right:a<t.left&&a>=t.left-s&&(p=a-t.left),r>t.bottom&&r<=t.bottom+u?h=r-t.bottom:r<t.top&&r>=t.top-u&&(h=r-t.top),d.push(Math.sqrt(Math.pow(p,2)+Math.pow(h,2)))}if(l.length){var g=Math.min.apply(null,d);for(c=0;c<l.length;c++)if(d[c]===g)return l[c]}return null},f.isInPanelCss=function(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:0;return!!f.getPanelCss(e,t)},f.mouseCoordinateSender=function(o,s,u){return void 0===s&&(s=!0),void 0===u&&(u=!1),function(e){if(null!==e){var t={},n=f.mouseOffsetCss(e);if(!f.isInPanelCss(n)){if(u)return void exports.setInputValue(o,null);if(s)return;return t.coords_css=n,t.coords_img=f.scaleCssToImg(n),void exports.setInputValue(o,t,{priority:"event"})}var i=f.getPanelCss(n),a=f.scaleCssToImg(n),r=i.scaleImgToData(a);t.x=r.x,t.y=r.y,t.coords_css=n,t.coords_img=a,t.img_css_ratio=f.cssToImgScalingRatio(),$.extend(t,i.panel_vars),t.mapping=i.mapping,t.domain=i.domain,t.range=i.range,t.log=i.log,exports.setInputValue(o,t,{priority:"event"})}else exports.setInputValue(o,null)}}},imageutils.findBox=function(e,t){return{xmin:Math.min(e.x,t.x),xmax:Math.max(e.x,t.x),ymin:Math.min(e.y,t.y),ymax:Math.max(e.y,t.y)}},imageutils.shiftToRange=function(e,t,n){e instanceof Array||(e=[e]);var i=Math.max.apply(null,e),a=Math.min.apply(null,e),r=0;n<i?r=n-i:a<t&&(r=t-a);for(var o=[],s=0;s<e.length;s++)o[s]=e[s]+r;return o},imageutils.createClickInfo=function(i,t,n){var a=null,r=null;function o(e,t){var n=$.Event(e,{which:t.which,pageX:t.pageX,pageY:t.pageY});i.trigger(n)}function s(){r&&(o("mousedown2",r),r=null)}function u(e){r=e,a=setTimeout(function(){s()},n)}return{mousedown:function(e){1===e.which&&(t?null===r?u(e):(clearTimeout(a),r&&2<Math.abs(r.pageX-e.pageX)||2<Math.abs(r.pageY-e.pageY)?(s(),u(e)):(r=null,o("dblclick2",e))):o("mousedown2",e))},dblclickIE8:function(e){e.which=1,o("dblclick2",e)}}},imageutils.createClickHandler=function(e,t,n){var i=n.mouseCoordinateSender(e,t);return{mousedown:function(e){1===e.which&&i(e)},onResetImg:function(){i(null)},onResize:null}},imageutils.createHoverHandler=function(e,t,n,i,a,r){var o,s=r.mouseCoordinateSender(e,i,a);return o=new("throttle"===n?Throttler:Debouncer)(null,s,t),{mousemove:function(e){o.normalCall(e)},mouseout:a?function(){o.normalCall(null)}:function(){},onResetImg:function(){o.immediateCall(null)},onResize:null}},imageutils.createBrushHandler=function(n,i,a,r,o){var t,s=imageutils.createBrush(i,a,r,20);function u(e){i.removeClass("crosshair grabbable grabbing ns-resize ew-resize nesw-resize nwse-resize"),e&&i.addClass(e)}function e(){var e=s.boundsData();if(isNaN(e.xmin))return exports.setInputValue(n,null),void imageOutputBinding.find(document).trigger("shiny-internal:brushed",{brushId:n,outputId:null});var t=s.getPanel();$.extend(e,t.panel_vars),e.coords_css=s.boundsCss(),e.coords_img=r.scaleCssToImg(e.coords_css),e.img_css_ratio=r.cssToImgScalingRatio(),e.mapping=t.mapping,e.domain=t.domain,e.range=t.range,e.log=t.log,e.direction=a.brushDirection,e.brushId=n,e.outputId=o,exports.setInputValue(n,e),i.data("mostRecentBrush",!0),imageOutputBinding.find(document).trigger("shiny-internal:brushed",e)}function l(e){s.brushTo(r.mouseOffsetCss(e)),t.normalCall()}function d(e){s.dragTo(r.mouseOffsetCss(e)),t.normalCall()}function c(e){s.resizeTo(r.mouseOffsetCss(e)),t.normalCall()}function p(e){if(1===e.which){if($(document).off("mousemove.image_brush").off("mouseup.image_brush"),s.up(r.mouseOffsetCss(e)),s.stopBrushing(),u("crosshair"),s.down().x===s.up().x&&s.down().y===s.up().y)return s.reset(),void t.immediateCall();t.isPending()&&t.immediateCall()}}function h(e){1===e.which&&($(document).off("mousemove.image_brush").off("mouseup.image_brush"),s.up(r.mouseOffsetCss(e)),s.stopDragging(),u("grabbable"),t.isPending()&&t.immediateCall())}function g(e){1===e.which&&($(document).off("mousemove.image_brush").off("mouseup.image_brush"),s.up(r.mouseOffsetCss(e)),s.stopResizing(),t.isPending()&&t.immediateCall())}return i.on("shiny-internal:brushed.image_output",function(e,t){t.brushId===n&&t.outputId!==o&&(i.data("mostRecentBrush",!1),s.reset())}),t=new("throttle"===a.brushDelayType?Throttler:Debouncer)(null,e,a.brushDelay),a.brushResetOnNew||i.data("mostRecentBrush")&&(s.importOldBrush(),t.immediateCall()),{mousedown:function(e){if(!(s.isBrushing()||s.isDragging()||s.isResizing())&&1===e.which){var t=r.mouseOffsetCss(e);if(!a.brushClip||r.isInPanelCss(t,20))if(s.up({x:NaN,y:NaN}),s.down(t),s.isInResizeArea(t))s.startResizing(t),$(document).on("mousemove.image_brush",c).on("mouseup.image_brush",g);else if(s.isInsideBrush(t))s.startDragging(t),u("grabbing"),$(document).on("mousemove.image_brush",d).on("mouseup.image_brush",h);else{var n=r.getPanelCss(t,20);s.startBrushing(n.clipImg(r.scaleCssToImg(t))),$(document).on("mousemove.image_brush",l).on("mouseup.image_brush",p)}}},mousemove:function(e){var t=r.mouseOffsetCss(e);if(!(s.isBrushing()||s.isDragging()||s.isResizing()))if(s.isInResizeArea(t)){var n=s.whichResizeSides(t);n.left&&n.top||n.right&&n.bottom?u("nwse-resize"):n.left&&n.bottom||n.right&&n.top?u("nesw-resize"):n.left||n.right?u("ew-resize"):(n.top||n.bottom)&&u("ns-resize")}else s.isInsideBrush(t)?u("grabbable"):r.isInPanelCss(t,20)?u("crosshair"):u(null)},onResetImg:function(){a.brushResetOnNew&&i.data("mostRecentBrush")&&(s.reset(),t.immediateCall())},onResize:function(){s.onResize(),t.immediateCall()}}},imageutils.createBrush=function(r,l,o,e){var s=10,u=r[0],d=null,c={},p=o.scaleCssToImg,h=o.scaleImgToCss;function t(){c.brushing=!1,c.dragging=!1,c.resizing=!1,c.down={x:NaN,y:NaN},c.up={x:NaN,y:NaN},c.resizeSides={left:!1,right:!1,top:!1,bottom:!1},c.boundsCss={xmin:NaN,xmax:NaN,ymin:NaN,ymax:NaN},c.boundsData={xmin:NaN,xmax:NaN,ymin:NaN,ymax:NaN},c.panel=null,c.changeStartBounds={xmin:NaN,xmax:NaN,ymin:NaN,ymax:NaN},d&&d.remove()}function n(e){var t=c.boundsCss,n=t.xmin-s,i=t.xmax+s,a=t.ymin-s,r=t.ymax+s,o={left:!1,right:!1,top:!1,bottom:!1};return("xy"===l.brushDirection||"x"===l.brushDirection)&&e.y<=r&&e.y>=a&&(e.x<t.xmin&&e.x>=n?o.left=!0:e.x>t.xmax&&e.x<=i&&(o.right=!0)),("xy"===l.brushDirection||"y"===l.brushDirection)&&e.x<=i&&e.x>=n&&(e.y<t.ymin&&e.y>=a?o.top=!0:e.y>t.ymax&&e.y<=r&&(o.bottom=!0)),o}function g(e){if(void 0===e)return $.extend({},c.boundsCss);var t={x:e.xmin,y:e.ymin},n={x:e.xmax,y:e.ymax},i=c.panel,a=i.range;l.brushClip&&(t=h(i.clipImg(p(t))),n=h(i.clipImg(p(n)))),"xy"===l.brushDirection||("x"===l.brushDirection?(t.y=h({y:a.top}).y,n.y=h({y:a.bottom}).y):"y"===l.brushDirection&&(t.x=h({x:a.left}).x,n.x=h({x:a.right}).x)),c.boundsCss={xmin:t.x,xmax:n.x,ymin:t.y,ymax:n.y};var r=c.panel.scaleImgToData(p(t)),o=c.panel.scaleImgToData(p(n));c.boundsData=imageutils.findBox(r,o),c.boundsData=mapValues(c.boundsData,function(e){return roundSignif(e,14)}),d.data("bounds-data",c.boundsData),d.data("panel",c.panel)}function f(e){if(void 0===e)return $.extend({},c.boundsData);var t=h(c.panel.scaleDataToImg(e));t=mapValues(t,function(e){return roundSignif(e,13)}),g({xmin:Math.min(t.xmin,t.xmax),xmax:Math.max(t.xmin,t.xmax),ymin:Math.min(t.ymin,t.ymax),ymax:Math.max(t.ymin,t.ymax)})}function m(){var e=findOrigin(r.find("img")),t=c.boundsCss;d.offset({top:e.y+t.ymin,left:e.x+t.xmin}).outerWidth(t.xmax-t.xmin+1).outerHeight(t.ymax-t.ymin+1)}return t(),{reset:t,importOldBrush:function(){var e=r.find("#"+u.id+"_brush");if(0!==e.length){var t=e.data("bounds-data"),n=e.data("panel");if(t&&n){for(var i=0;i<o.panels.length;i++){var a=o.panels[i];if(equal(n.mapping,a.mapping)&&equal(n.panel_vars,a.panel_vars)){c.panel=o.panels[i];break}}null!==c.panel?(d=e,f(t),m()):e.remove()}}},isInsideBrush:function(e){var t=c.boundsCss;return e.x<=t.xmax&&e.x>=t.xmin&&e.y<=t.ymax&&e.y>=t.ymin},isInResizeArea:function(e){var t=n(e);return t.left||t.right||t.top||t.bottom},whichResizeSides:n,onResize:function(){var e=f();for(var t in e)if(isnan(e[t]))return;f(e),m()},boundsCss:g,boundsData:f,getPanel:function(){return c.panel},down:function(e){if(void 0===e)return c.down;c.down=e},up:function(e){if(void 0===e)return c.up;c.up=e},isBrushing:function(){return c.brushing},startBrushing:function(){c.brushing=!0,function(){d&&d.remove(),d=$(document.createElement("div")).attr("id",u.id+"_brush").css({"background-color":l.brushFill,opacity:l.brushOpacity,"pointer-events":"none",position:"absolute"}).hide();var e="1px solid "+l.brushStroke;"xy"===l.brushDirection?d.css({border:e}):"x"===l.brushDirection?d.css({"border-left":e,"border-right":e}):"y"===l.brushDirection&&d.css({"border-top":e,"border-bottom":e}),r.append(d),d.offset({x:0,y:0}).width(0).outerHeight(0)}(),c.panel=o.getPanelCss(c.down,e),g(imageutils.findBox(c.down,c.down)),m()},brushTo:function(e){g(imageutils.findBox(c.down,e)),d.show(),m()},stopBrushing:function(){c.brushing=!1,g(imageutils.findBox(c.down,c.up))},isDragging:function(){return c.dragging},startDragging:function(){c.dragging=!0,c.changeStartBounds=$.extend({},c.boundsCss)},dragTo:function(e){var t=e.x-c.down.x,n=e.y-c.down.y,i=c.changeStartBounds,a={xmin:i.xmin+t,xmax:i.xmax+t,ymin:i.ymin+n,ymax:i.ymax+n};if(l.brushClip){var r=c.panel.range,o=p(a),s=[o.xmin,o.xmax],u=[o.ymin,o.ymax];s=imageutils.shiftToRange(s,r.left,r.right),u=imageutils.shiftToRange(u,r.top,r.bottom),a=h({xmin:s[0],xmax:s[1],ymin:u[0],ymax:u[1]})}g(a),m()},stopDragging:function(){c.dragging=!1},isResizing:function(){return c.resizing},startResizing:function(){c.resizing=!0,c.changeStartBounds=$.extend({},c.boundsCss),c.resizeSides=n(c.down)},resizeTo:function(e){var t={x:e.x-c.down.x,y:e.y-c.down.y},n=p(t),i=p(c.changeStartBounds),a=c.panel.range;if(c.resizeSides.left){var r=imageutils.shiftToRange(i.xmin+n.x,a.left,i.xmax)[0];i.xmin=r}else if(c.resizeSides.right){var o=imageutils.shiftToRange(i.xmax+n.x,i.xmin,a.right)[0];i.xmax=o}if(c.resizeSides.top){var s=imageutils.shiftToRange(i.ymin+n.y,a.top,i.ymax)[0];i.ymin=s}else if(c.resizeSides.bottom){var u=imageutils.shiftToRange(i.ymax+n.y,i.ymin,a.bottom)[0];i.ymax=u}g(h(i)),m()},stopResizing:function(){c.resizing=!1}}},exports.resetBrush=function(e){exports.setInputValue(e,null),imageOutputBinding.find(document).trigger("shiny-internal:brushed",{brushId:e,outputId:null})};var htmlOutputBinding=new OutputBinding;$.extend(htmlOutputBinding,{find:function(e){return $(e).find(".shiny-html-output")},onValueError:function(e,t){exports.unbindAll(e),this.renderError(e,t)},renderValue:function(e,t){exports.renderContent(e,t)}}),outputBindings.register(htmlOutputBinding,"shiny.htmlOutput");var renderDependencies=exports.renderDependencies=function(e){e&&$.each(e,function(e,t){renderDependency(t)})};exports.renderContent=function(e,t){var n,i=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"replace";"replace"===i&&exports.unbindAll(e);var a=[];null===t?n="":"string"==typeof t?n=t:"object"===_typeof(t)&&(n=t.html,a=t.deps||[]),exports.renderHtml(n,e,a,i);var r=e;if("replace"===i)exports.initializeInputs(e),exports.bindAll(e);else{var o=$(e).parent();if(0<o.length&&(r=o,"beforeBegin"===i||"afterEnd"===i)){var s=o.parent();0<s.length&&(r=s)}exports.initializeInputs(r),exports.bindAll(r)}},exports.renderHtml=function(e,t,n){var i=3<arguments.length&&void 0!==arguments[3]?arguments[3]:"replace";return renderDependencies(n),singletons.renderHtml(e,t,i)};var htmlDependencies={};function registerDependency(e,t){htmlDependencies[e]=t}function renderDependency(n){if(!htmlDependencies.hasOwnProperty(n.name)){registerDependency(n.name,n.version);var i=n.src.href,e=$("head").first();if(n.meta){var t=$.map(asArray(n.meta),function(e,t){var n=Object.keys(e)[0];return $("<meta>").attr("name",n).attr("content",e[n])});e.append(t)}if(n.stylesheet){var a=$.map(asArray(n.stylesheet),function(e){return $("<link rel='stylesheet' type='text/css'>").attr("href",i+"/"+encodeURI(e))});e.append(a)}if(n.script){var r=$.map(asArray(n.script),function(e){return $("<script>").attr("src",i+"/"+encodeURI(e))});e.append(r)}if(n.attachment){var o=n.attachment;if("string"==typeof o&&(o=[o]),$.isArray(o)){var s={};$.each(o,function(e,t){s[e+1+""]=t}),o=s}var u=$.map(o,function(e,t){return $("<link rel='attachment'>").attr("id",n.name+"-"+t+"-attachment").attr("href",i+"/"+encodeURI(e))});e.append(u)}if(n.head){var l=$("<head></head>");l.html(n.head),e.append(l.children())}return 1}}var singletons={knownSingletons:{},renderHtml:function(e,t,n){var i=this._processHtml(e);return this._addToHead(i.head),this.register(i.singletons),"replace"===n?$(t).html(i.html):t.insertAdjacentHTML(n,i.html),i},register:function(e){$.extend(this.knownSingletons,e)},registerNames:function(e){if("string"==typeof e)this.knownSingletons[e]=!0;else if(e instanceof Array)for(var t=0;t<e.length;t++)this.knownSingletons[e[t]]=!0},_addToHead:function(e){if(0<e.length)for(var t=$("<div>"+e+"</div>")[0],n=$("head");t.hasChildNodes();)n.append(t.firstChild)},_processHtml:function(e){for(var t,a=this,r={},n=function(e,t,n,i){return a.knownSingletons[n]||r[n]?"":(r[n]=!0,i)};t=e.replace(a._reSingleton,n),e.length!==t.length;)e=t;for(var i=[],o=function(e,t){return i.push(t),""};t=e.replace(a._reHead,o),e.length!==t.length;)e=t;return{html:e,head:i.join("\n"),singletons:r}},_reSingleton:/<!--(SHINY.SINGLETON\[([\w]+)\])-->([\s\S]*?)<!--\/\1-->/,_reHead:/<head(?:\s[^>]*)?>([\s\S]*?)<\/head>/},downloadLinkOutputBinding=new OutputBinding;$.extend(downloadLinkOutputBinding,{find:function(e){return $(e).find("a.shiny-download-link")},renderValue:function(e,t){$(e).attr("href",t)}}),outputBindings.register(downloadLinkOutputBinding,"shiny.downloadLink"),$(document).on("click.shinyDownloadLink","a.shiny-download-link",function(e){var t=jQuery.Event("shiny:filedownload");t.name=this.id,t.href=this.href,$(document).trigger(t)});var datatableOutputBinding=new OutputBinding;$.extend(datatableOutputBinding,{find:function(e){return $(e).find(".shiny-datatable-output")},onValueError:function(e,t){exports.unbindAll(e),this.renderError(e,t)},renderValue:function renderValue(el,_data){var $el=$(el).empty();if(_data&&_data.colnames){var colnames=$.makeArray(_data.colnames),header=$.map(colnames,function(e){return"<th>"+e+"</th>"}).join("");header="<thead><tr>"+header+"</tr></thead>";var footer="";null!==_data.options&&!1===_data.options.searching||(footer=$.map(colnames,function(e){return'<th><input type="text" placeholder="'+escapeHTML(e.replace(/(<([^>]+)>)/gi,""))+'" /></th>'}).join(""),footer="<tfoot>"+footer+"</tfoot>");var content='<table class="table table-striped table-hover">'+header+footer+"</table>";$el.append(content),_data.evalOptions&&$.each(_data.evalOptions,function(i,x){_data.options[x]=eval("("+_data.options[x]+")")});var searchCI=null===_data.options||void 0===_data.options.search||!1!==_data.options.search.caseInsensitive,oTable=$(el).children("table").DataTable($.extend({processing:!0,serverSide:!0,order:[],orderClasses:!1,pageLength:25,ajax:{url:_data.action,type:"POST",data:function(e){e.search.caseInsensitive=searchCI,e.escape=_data.escape}}},_data.options));if("string"==typeof _data.callback){var callback=eval("("+_data.callback+")");"function"==typeof callback&&callback(oTable)}$el.find("label input").first().unbind("keyup").keyup(debounce(_data.searchDelay,function(){oTable.search(this.value).draw()}));var searchInputs=$el.find("tfoot input");0<searchInputs.length&&($.each(oTable.settings()[0].aoColumns,function(e,t){t.bSearchable||searchInputs.eq(e).hide()}),searchInputs.keyup(debounce(_data.searchDelay,function(){oTable.column(searchInputs.index(this)).search(this.value).draw()}))),$el.parents(".tab-content").css("overflow","visible")}}}),outputBindings.register(datatableOutputBinding,"shiny.datatableOutput");var OutputBindingAdapter=function(n,i){this.el=n,(this.binding=i).resize&&(this.onResize=makeResizeFilter(n,function(e,t){i.resize(n,e,t)}))};(function(){this.getId=function(){return this.binding.getId(this.el)},this.onValueChange=function(e){this.binding.onValueChange(this.el,e)},this.onValueError=function(e){this.binding.onValueError(this.el,e)},this.showProgress=function(e){this.binding.showProgress(this.el,e)},this.onResize=function(){}}).call(OutputBindingAdapter.prototype);var InputBinding=exports.InputBinding=function(){};(function(){this.find=function(e){throw"Not implemented"},this.getId=function(e){return e["data-input-id"]||e.id},this.getType=function(){return!1},this.getValue=function(e){throw"Not implemented"},this.subscribe=function(e,t){},this.unsubscribe=function(e){},this.receiveMessage=function(e,t){throw"Not implemented"},this.getState=function(e,t){throw"Not implemented"},this.getRatePolicy=function(){return null},this.initialize=function(e){},this.dispose=function(e){}}).call(InputBinding.prototype);var textInputBinding=new InputBinding;$.extend(textInputBinding,{find:function(e){return $(e).find('input[type="text"], input[type="search"], input[type="url"], input[type="email"]').not('input[type="text"][id$="-selectized"]')},getId:function(e){return InputBinding.prototype.getId.call(this,e)||e.name},getValue:function(e){return e.value},setValue:function(e,t){e.value=t},subscribe:function(e,t){$(e).on("keyup.textInputBinding input.textInputBinding",function(e){t(!0)}),$(e).on("change.textInputBinding",function(e){t(!1)})},unsubscribe:function(e){$(e).off(".textInputBinding")},receiveMessage:function(e,t){t.hasOwnProperty("value")&&this.setValue(e,t.value),updateLabel(t.label,this._getLabelNode(e)),t.hasOwnProperty("placeholder")&&(e.placeholder=t.placeholder),$(e).trigger("change")},getState:function(e){return{label:this._getLabelNode(e).text(),value:e.value,placeholder:e.placeholder}},getRatePolicy:function(){return{policy:"debounce",delay:250}},_getLabelNode:function(e){return $(e).parent().find('label[for="'+$escape(e.id)+'"]')}}),inputBindings.register(textInputBinding,"shiny.textInput");var textareaInputBinding={};$.extend(textareaInputBinding,textInputBinding,{find:function(e){return $(e).find("textarea")}}),inputBindings.register(textareaInputBinding,"shiny.textareaInput");var passwordInputBinding={};$.extend(passwordInputBinding,textInputBinding,{find:function(e){return $(e).find('input[type="password"]')},getType:function(){return"shiny.password"}}),inputBindings.register(passwordInputBinding,"shiny.passwordInput");var numberInputBinding={};$.extend(numberInputBinding,textInputBinding,{find:function(e){return $(e).find('input[type="number"]')},getValue:function(e){var t=$(e).val();return/^\s*$/.test(t)?null:isNaN(t)?t:+t},setValue:function(e,t){e.value=t},getType:function(){return"shiny.number"},receiveMessage:function(e,t){t.hasOwnProperty("value")&&(e.value=t.value),t.hasOwnProperty("min")&&(e.min=t.min),t.hasOwnProperty("max")&&(e.max=t.max),t.hasOwnProperty("step")&&(e.step=t.step),updateLabel(t.label,this._getLabelNode(e)),$(e).trigger("change")},getState:function(e){return{label:this._getLabelNode(e).text(),value:this.getValue(e),min:Number(e.min),max:Number(e.max),step:Number(e.step)}},_getLabelNode:function(e){return $(e).parent().find('label[for="'+$escape(e.id)+'"]')}}),inputBindings.register(numberInputBinding,"shiny.numberInput");var checkboxInputBinding=new InputBinding;function forceIonSliderUpdate(e){e.$cache&&e.$cache.input?e.$cache.input.trigger("change"):console.log("Couldn't force ion slider to update")}function getTypePrettifyer(e,t,n){var i;return"date"===e?(i=strftime.utc(),function(e){return i(t,new Date(e))}):"datetime"===e?(i=n?strftime.timezone(n):strftime,function(e){return i(t,new Date(e))}):function(e){return formatNumber(e,this.prettify_separator)}}$.extend(checkboxInputBinding,{find:function(e){return $(e).find('input[type="checkbox"]')},getValue:function(e){return e.checked},setValue:function(e,t){e.checked=t},subscribe:function(e,t){$(e).on("change.checkboxInputBinding",function(e){t(!0)})},unsubscribe:function(e){$(e).off(".checkboxInputBinding")},getState:function(e){return{label:$(e).parent().find("span").text(),value:e.checked}},receiveMessage:function(e,t){t.hasOwnProperty("value")&&(e.checked=t.value),t.hasOwnProperty("label")&&$(e).parent().find("span").text(t.label),$(e).trigger("change")}}),inputBindings.register(checkboxInputBinding,"shiny.checkboxInput");var sliderInputBinding={};function formatNumber(e){var t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:",",n=2<arguments.length&&void 0!==arguments[2]?arguments[2]:".",i=e.toString().split(".");return i[0]=i[0].replace(/(\d{1,3}(?=(?:\d\d\d)+(?!\d)))/g,"$1"+t),1===i.length?i[0]:2===i.length?i[0]+n+i[1]:""}$.extend(sliderInputBinding,textInputBinding,{find:function(e){return $.fn.ionRangeSlider?$(e).find("input.js-range-slider"):[]},getType:function(e){var t=$(e).data("data-type");return"date"===t?"shiny.date":"datetime"===t&&"shiny.datetime"},getValue:function(e){var t,n=$(e),i=$(e).data("ionRangeSlider").result,a=n.data("data-type");return t="date"===a?function(e){return formatDateUTC(new Date(+e))}:"datetime"===a?function(e){return e/1e3}:function(e){return+e},2===this._numValues(e)?[t(i.from),t(i.to)]:t(i.from)},setValue:function(e,t){var n=$(e),i=n.data("ionRangeSlider");n.data("immediate",!0);try{2===this._numValues(e)&&t instanceof Array?i.update({from:t[0],to:t[1]}):i.update({from:t}),forceIonSliderUpdate(i)}finally{n.data("immediate",!1)}},subscribe:function(t,n){$(t).on("change.sliderInputBinding",function(e){n(!$(t).data("immediate")&&!$(t).data("animating"))})},unsubscribe:function(e){$(e).off(".sliderInputBinding")},receiveMessage:function(e,t){var n=$(e),i=n.data("ionRangeSlider"),a={};t.hasOwnProperty("value")&&(2===this._numValues(e)&&t.value instanceof Array?(a.from=t.value[0],a.to=t.value[1]):a.from=t.value);for(var r=["min","max","step"],o=0;o<r.length;o++){var s=r[o];t.hasOwnProperty(s)&&(a[s]=t[s])}updateLabel(t.label,this._getLabelNode(e));var u=["data-type","time-format","timezone"];for(o=0;o<u.length;o++){var l=u[o];t.hasOwnProperty(l)&&n.data(l,t[l])}var d=n.data("data-type"),c=n.data("time-format"),p=n.data("timezone");a.prettify=getTypePrettifyer(d,c,p),n.data("immediate",!0);try{i.update(a),forceIonSliderUpdate(i)}finally{n.data("immediate",!1)}},getRatePolicy:function(){return{policy:"debounce",delay:250}},getState:function(){},initialize:function(e){var t={},n=$(e),i=n.data("data-type"),a=n.data("time-format"),r=n.data("timezone");t.prettify=getTypePrettifyer(i,a,r),n.ionRangeSlider(t)},_getLabelNode:function(e){return $(e).parent().find('label[for="'+$escape(e.id)+'"]')},_numValues:function(e){return"double"===$(e).data("ionRangeSlider").options.type?2:1}}),inputBindings.register(sliderInputBinding,"shiny.sliderInput"),$(document).on("click",".slider-animate-button",function(e){e.preventDefault();var t=$(this),n=$("#"+$escape(t.attr("data-target-id"))),i=void 0!==t.attr("data-loop")&&!/^\s*false\s*$/i.test(t.attr("data-loop")),a=t.attr("data-interval");if(a=isNaN(a)?1500:+a,n.data("animTimer"))clearTimeout(n.data("animTimer")),n.removeData("animTimer"),t.attr("title","Play"),t.removeClass("playing"),n.removeData("animating");else{var r,o;if(n.hasClass("jslider"))(r=n.slider()).canStepNext()||r.resetToStart(),o=setInterval(function(){i&&!r.canStepNext()?r.resetToStart():(r.stepNext(),i||r.canStepNext()||t.click())},a);else{r=n.data("ionRangeSlider");var s=function(){return"double"===r.options.type?r.result.to<r.result.max:r.result.from<r.result.max},u=function(){var e={from:r.result.min};"double"===r.options.type&&(e.to=e.from+(r.result.to-r.result.from)),r.update(e),forceIonSliderUpdate(r)};s()||u(),o=setInterval(function(){var e;i&&!s()?u():(e={from:Math.min(r.result.max,r.result.from+r.options.step)},"double"===r.options.type&&(e.to=Math.min(r.result.max,r.result.to+r.options.step)),r.update(e),forceIonSliderUpdate(r),i||s()||t.click())},a)}n.data("animTimer",o),t.attr("title","Pause"),t.addClass("playing"),n.data("animating",!0)}});var dateInputBinding=new InputBinding;$.extend(dateInputBinding,{find:function(e){return $(e).find(".shiny-date-input")},getType:function(){return"shiny.date"},getValue:function(e){return formatDateUTC($(e).find("input").bsDatepicker("getUTCDate"))},setValue:function(e,t){if(null!==t){var n=this._newDate(t);isNaN(n)||$(e).find("input").bsDatepicker("setUTCDate",n)}else $(e).find("input").val("").bsDatepicker("update")},getState:function(e){var t=$(e).find("input"),n=t.data("datepicker").startDate,i=t.data("datepicker").endDate;n=n===-1/0?null:formatDateUTC(n),i=i===1/0?null:formatDateUTC(i);var a=t.data("datepicker").startViewMode;return 2===a?a="decade":1===a?a="year":0===a&&(a="month"),{label:this._getLabelNode(e).text(),value:this.getValue(e),valueString:t.val(),min:n,max:i,language:t.data("datepicker").language,weekstart:t.data("datepicker").weekStart,format:this._formatToString(t.data("datepicker").format),startview:a}},receiveMessage:function(e,t){var n=$(e).find("input");updateLabel(t.label,this._getLabelNode(e)),t.hasOwnProperty("min")&&this._setMin(n[0],t.min),t.hasOwnProperty("max")&&this._setMax(n[0],t.max),t.hasOwnProperty("value")&&this.setValue(e,t.value),$(e).trigger("change")},subscribe:function(e,t){$(e).on("keyup.dateInputBinding input.dateInputBinding",function(e){t(!0)}),$(e).on("changeDate.dateInputBinding change.dateInputBinding",function(e){t(!1)})},unsubscribe:function(e){$(e).off(".dateInputBinding")},getRatePolicy:function(){return{policy:"debounce",delay:250}},initialize:function(e){var t=$(e).find("input"),n=t.data("initial-date");null==n&&(n=this._dateAsUTC(new Date)),this.setValue(e,n),void 0!==t.data("min-date")&&this._setMin(t[0],t.data("min-date")),void 0!==t.data("max-date")&&this._setMax(t[0],t.data("max-date"))},_getLabelNode:function(e){return $(e).find('label[for="'+$escape(e.id)+'"]')},_formatToString:function(e){for(var t="",n=0;n<e.parts.length;n++)t+=e.separators[n]+e.parts[n];return t+=e.separators[n]},_setMin:function(e,t){if(void 0!==t)if(null!==t){if(null!==(t=this._newDate(t))&&(t=this._UTCDateAsLocal(t),!isNaN(t))){var n=$(e).bsDatepicker("getUTCDate");$(e).bsDatepicker("setStartDate",t),$(e).bsDatepicker("setUTCDate",n),"function"==typeof t.toDateString&&"function"==typeof n.toDateString&&t.toDateString()===n.toDateString()&&($(e).bsDatepicker("setStartDate",null),$(e).bsDatepicker("setUTCDate",n),$(e).bsDatepicker("setStartDate",t))}}else $(e).bsDatepicker("setStartDate",null)},_setMax:function(e,t){if(void 0!==t)if(null!==t){if(null!==(t=this._newDate(t))&&(t=this._UTCDateAsLocal(t),!isNaN(t))){var n=$(e).bsDatepicker("getUTCDate");$(e).bsDatepicker("setEndDate",t),$(e).bsDatepicker("setUTCDate",n),"function"==typeof t.toDateString&&"function"==typeof n.toDateString&&t.toDateString()===n.toDateString()&&($(e).bsDatepicker("setEndDate",null),$(e).bsDatepicker("setUTCDate",n),$(e).bsDatepicker("setEndDate",t))}}else $(e).bsDatepicker("setEndDate",null)},_newDate:function(e){if(e instanceof Date)return e;if(!e)return null;var t=parseDate(e);return isNaN(t)?null:new Date(t.getTime())},_dateAsUTC:function(e){return new Date(e.getTime()-6e4*e.getTimezoneOffset())},_UTCDateAsLocal:function(e){return new Date(e.getTime()+6e4*e.getTimezoneOffset())}}),inputBindings.register(dateInputBinding,"shiny.dateInput");var dateRangeInputBinding={};$.extend(dateRangeInputBinding,dateInputBinding,{find:function(e){return $(e).find(".shiny-date-range-input")},getValue:function(e){var t=$(e).find("input"),n=t.eq(0).bsDatepicker("getUTCDate"),i=t.eq(1).bsDatepicker("getUTCDate");return[formatDateUTC(n),formatDateUTC(i)]},setValue:function(e,t){if(t instanceof Object){var n=$(e).find("input");if(void 0!==t.start)if(null===t.start)n.eq(0).val("").bsDatepicker("update");else{var i=this._newDate(t.start);n.eq(0).bsDatepicker("setUTCDate",i)}if(void 0!==t.end)if(null===t.end)n.eq(1).val("").bsDatepicker("update");else{var a=this._newDate(t.end);n.eq(1).bsDatepicker("setUTCDate",a)}}},getState:function(e){var t=$(e).find("input"),n=t.eq(0),i=t.eq(1),a=n.bsDatepicker("getStartDate"),r=n.bsDatepicker("getEndDate");a=a===-1/0?null:formatDateUTC(a),r=r===1/0?null:formatDateUTC(r);var o=n.data("datepicker").startView;return 2===o?o="decade":1===o?o="year":0===o&&(o="month"),{label:this._getLabelNode(e).text(),value:this.getValue(e),valueString:[n.val(),i.val()],min:a,max:r,weekstart:n.data("datepicker").weekStart,format:this._formatToString(n.data("datepicker").format),language:n.data("datepicker").language,startview:o}},receiveMessage:function(e,t){var n=$(e),i=n.find("input"),a=i.eq(0),r=i.eq(1);updateLabel(t.label,this._getLabelNode(e)),t.hasOwnProperty("min")&&(this._setMin(a[0],t.min),this._setMin(r[0],t.min)),t.hasOwnProperty("max")&&(this._setMax(a[0],t.max),this._setMax(r[0],t.max)),t.hasOwnProperty("value")&&this.setValue(e,t.value),n.trigger("change")},initialize:function(e){var t=$(e).find("input"),n=t.eq(0),i=t.eq(1),a=n.data("initial-date"),r=i.data("initial-date");null==a&&(a=this._dateAsUTC(new Date)),null==r&&(r=this._dateAsUTC(new Date)),this.setValue(e,{start:a,end:r}),this._setMin(n[0],n.data("min-date")),this._setMin(i[0],n.data("min-date")),this._setMax(n[0],i.data("max-date")),this._setMax(i[0],i.data("max-date"))},subscribe:function(e,t){$(e).on("keyup.dateRangeInputBinding input.dateRangeInputBinding",function(e){t(!0)}),$(e).on("changeDate.dateRangeInputBinding change.dateRangeInputBinding",function(e){t(!1)})},unsubscribe:function(e){$(e).off(".dateRangeInputBinding")},_getLabelNode:function(e){return $(e).find('label[for="'+$escape(e.id)+'"]')}}),inputBindings.register(dateRangeInputBinding,"shiny.dateRangeInput");var selectInputBinding=new InputBinding;$.extend(selectInputBinding,{find:function(e){return $(e).find("select")},getType:function(e){var t=$(e);return t.hasClass("symbol")?"multiple"===t.attr("multiple")?"shiny.symbolList":"shiny.symbol":null},getId:function(e){return InputBinding.prototype.getId.call(this,e)||e.name},getValue:function(e){return $(e).val()},setValue:function(e,t){if(this._is_selectize(e)){var n=this._selectize(e);n&&n.setValue(t)}else $(e).val(t)},getState:function(e){for(var t=new Array(e.length),n=0;n<e.length;n++)t[n]={value:e[n].value,label:e[n].label};return{label:this._getLabelNode(e),value:this.getValue(e),options:t}},receiveMessage:function(e,n){var r,t=$(e);if(n.hasOwnProperty("options")&&((r=this._selectize(e))&&r.destroy(),t.empty().append(n.options),this._selectize(e)),n.hasOwnProperty("config")&&(t.parent().find('script[data-for="'+$escape(e.id)+'"]').replaceWith(n.config),this._selectize(e,!0)),n.hasOwnProperty("url")){(r=this._selectize(e)).clearOptions();var i=!1;r.settings.load=function(e,t){var a=r.settings;$.ajax({url:n.url,data:{query:e,field:JSON.stringify([a.searchField]),value:a.valueField,conju:a.searchConjunction,maxop:a.maxOptions},type:"GET",error:function(){t()},success:function(e){$.each(e,function(e,t){var n=t[a.optgroupField||"optgroup"],i={};i[a.optgroupLabelField||"label"]=n,i[a.optgroupValueField||"value"]=n,r.addOptionGroup(n,i)}),t(e),i||(n.hasOwnProperty("value")?r.setValue(n.value):1===a.maxItems&&r.setValue(e[0].value)),i=!0}})},r.load(function(e){r.settings.load.apply(r,["",e])})}else n.hasOwnProperty("value")&&this.setValue(e,n.value);updateLabel(n.label,this._getLabelNode(e)),$(e).trigger("change")},subscribe:function(t,n){var i=this;$(t).on("change.selectInputBinding",function(e){t.nonempty&&""===i.getValue(t)||n()})},unsubscribe:function(e){$(e).off(".selectInputBinding")},initialize:function(e){this._selectize(e)},_getLabelNode:function(e){var t=$escape(e.id);return this._is_selectize(e)&&(t+="-selectized"),$(e).parent().parent().find('label[for="'+t+'"]')},_is_selectize:function(e){return 0<$(e).parent().find('script[data-for="'+$escape(e.id)+'"]').length},_selectize:function _selectize(el,update){if($.fn.selectize){var $el=$(el),config=$el.parent().find('script[data-for="'+$escape(el.id)+'"]');if(0!==config.length){var options=$.extend({labelField:"label",valueField:"value",searchField:["label"]},JSON.parse(config.html()));void 0!==config.data("nonempty")?(el.nonempty=!0,options=$.extend(options,{onItemRemove:function(e){""===this.getValue()&&$("select#"+$escape(el.id)).empty().append($("<option/>",{value:e,selected:!0})).trigger("change")},onDropdownClose:function(){""===this.getValue()&&this.setValue($("select#"+$escape(el.id)).val())}})):el.nonempty=!1,config.data("eval")instanceof Array&&$.each(config.data("eval"),function(i,x){options[x]=eval("("+options[x]+")")});var control=$el.selectize(options)[0].selectize;if(update){var settings=$.extend(control.settings,options);control.destroy(),control=$el.selectize(settings)[0].selectize}return control}}}}),inputBindings.register(selectInputBinding,"shiny.selectInput");var radioInputBinding=new InputBinding;$.extend(radioInputBinding,{find:function(e){return $(e).find(".shiny-input-radiogroup")},getValue:function(e){return $('input:radio[name="'+$escape(e.id)+'"]:checked').val()},setValue:function(e,t){$('input:radio[name="'+$escape(e.id)+'"][value="'+$escape(t)+'"]').prop("checked",!0)},getState:function(e){for(var t=$('input:radio[name="'+$escape(e.id)+'"]'),n=new Array(t.length),i=0;i<n.length;i++)n[i]={value:t[i].value,label:this._getLabel(t[i])};return{label:this._getLabelNode(e).text(),value:this.getValue(e),options:n}},receiveMessage:function(e,t){var n=$(e);t.hasOwnProperty("options")&&(n.find("div.shiny-options-group").remove(),n.find("label.radio").remove(),n.append(t.options)),t.hasOwnProperty("value")&&this.setValue(e,t.value),updateLabel(t.label,this._getLabelNode(e)),$(e).trigger("change")},subscribe:function(e,t){$(e).on("change.radioInputBinding",function(e){t()})},unsubscribe:function(e){$(e).off(".radioInputBinding")},_getLabelNode:function(e){return $(e).parent().find('label[for="'+$escape(e.id)+'"]')},_getLabel:function(e){return"LABEL"===e.parentNode.tagName?$(e.parentNode).find("span").text().trim():null},_setLabel:function(e,t){return"LABEL"===e.parentNode.tagName&&$(e.parentNode).find("span").text(t),null}}),inputBindings.register(radioInputBinding,"shiny.radioInput");var checkboxGroupInputBinding=new InputBinding;$.extend(checkboxGroupInputBinding,{find:function(e){return $(e).find(".shiny-input-checkboxgroup")},getValue:function(e){for(var t=$('input:checkbox[name="'+$escape(e.id)+'"]:checked'),n=new Array(t.length),i=0;i<t.length;i++)n[i]=t[i].value;return n},setValue:function(e,t){if($('input:checkbox[name="'+$escape(e.id)+'"]').prop("checked",!1),t instanceof Array)for(var n=0;n<t.length;n++)$('input:checkbox[name="'+$escape(e.id)+'"][value="'+$escape(t[n])+'"]').prop("checked",!0);else $('input:checkbox[name="'+$escape(e.id)+'"][value="'+$escape(t)+'"]').prop("checked",!0)},getState:function(e){for(var t=$('input:checkbox[name="'+$escape(e.id)+'"]'),n=new Array(t.length),i=0;i<n.length;i++)n[i]={value:t[i].value,label:this._getLabel(t[i])};return{label:this._getLabelNode(e).text(),value:this.getValue(e),options:n}},receiveMessage:function(e,t){var n=$(e);t.hasOwnProperty("options")&&(n.find("div.shiny-options-group").remove(),n.find("label.checkbox").remove(),n.append(t.options)),t.hasOwnProperty("value")&&this.setValue(e,t.value),updateLabel(t.label,this._getLabelNode(e)),$(e).trigger("change")},subscribe:function(e,t){$(e).on("change.checkboxGroupInputBinding",function(e){t()})},unsubscribe:function(e){$(e).off(".checkboxGroupInputBinding")},_getLabelNode:function(e){return $(e).find('label[for="'+$escape(e.id)+'"]')},_getLabel:function(e){return"LABEL"===e.parentNode.tagName?$(e.parentNode).find("span").text().trim():null},_setLabel:function(e,t){return"LABEL"===e.parentNode.tagName&&$(e.parentNode).find("span").text(t),null}}),inputBindings.register(checkboxGroupInputBinding,"shiny.checkboxGroupInput");var actionButtonInputBinding=new InputBinding;$.extend(actionButtonInputBinding,{find:function(e){return $(e).find(".action-button")},getValue:function(e){return $(e).data("val")||0},setValue:function(e,t){$(e).data("val",t)},getType:function(){return"shiny.action"},subscribe:function(e,i){$(e).on("click.actionButtonInputBinding",function(e){var t=$(this),n=t.data("val")||0;t.data("val",n+1),i()})},getState:function(e){return{value:this.getValue(e)}},receiveMessage:function(e,t){var n=$(e),i=n.text(),a="";if(0<n.find("i[class]").length){var r=n.find("i[class]")[0];r===n.children()[0]&&(a=$(r).prop("outerHTML"))}t.hasOwnProperty("label")&&(i=t.label),t.hasOwnProperty("icon")&&0===(a=t.icon).length&&(a=""),n.html(a+" "+i)},unsubscribe:function(e){$(e).off(".actionButtonInputBinding")}}),inputBindings.register(actionButtonInputBinding,"shiny.actionButtonInput"),$(document).on("click","a.action-button",function(e){e.preventDefault()});var bootstrapTabInputBinding=new InputBinding;$.extend(bootstrapTabInputBinding,{find:function(e){return $(e).find("ul.nav.shiny-tab-input")},getValue:function(e){var t=$(e).find("li:not(.dropdown).active").children("a");return 1===t.length?this._getTabName(t):null},setValue:function(e,t){var n=this,i=!1;t&&$(e).find("li:not(.dropdown)").children("a").each(function(){return n._getTabName($(this))!==t||($(this).tab("show"),!(i=!0))});i||$(e).trigger("change")},getState:function(e){return{value:this.getValue(e)}},receiveMessage:function(e,t){t.hasOwnProperty("value")&&this.setValue(e,t.value)},subscribe:function(e,t){$(e).on("change shown.bootstrapTabInputBinding shown.bs.tab.bootstrapTabInputBinding",function(e){t()})},unsubscribe:function(e){$(e).off(".bootstrapTabInputBinding")},_getTabName:function(e){return e.attr("data-value")||e.text()}}),inputBindings.register(bootstrapTabInputBinding,"shiny.bootstrapTabInput");var IE8FileUploader=function(e,t,n){this.shinyapp=e,this.id=t,this.fileEl=n,this.beginUpload()};(function(){this.beginUpload=function(){var e=this,t="shinyupload_iframe_"+this.id;this.iframe=document.createElement("iframe"),this.iframe.id=t,this.iframe.name=t,this.iframe.setAttribute("style","position: fixed; top: 0; left: 0; width: 0; height: 0; border: none"),$(document.body).append(this.iframe);function n(){e.shinyapp.makeRequest("uploadieFinish",[],function(){},function(){}),$(e.iframe).remove(),$(e.fileEl).val("")}this.iframe.attachEvent?this.iframe.attachEvent("onload",n):this.iframe.onload=n,this.form=document.createElement("form"),this.form.method="POST",this.form.setAttribute("enctype","multipart/form-data"),this.form.action="session/"+encodeURI(this.shinyapp.config.sessionId)+"/uploadie/"+encodeURI(this.id),this.form.id="shinyupload_form_"+this.id,this.form.target=t,$(this.form).insertAfter(this.fileEl).append(this.fileEl),this.form.submit()}}).call(IE8FileUploader.prototype);var FileUploader=function(e,t,n,i){this.shinyapp=e,this.id=t,this.el=i,FileProcessor.call(this,n)};function setFileText(e,t){var n=e.closest("div.input-group").find("input[type=text]");1===t.length?n.val(t[0].name):n.val(t.length+" files")}function abortCurrentUpload(e){var t=e.data("currentUploader");t&&t.abort(),e.removeAttr("data-restore")}function uploadDroppedFilesIE10Plus(e,t){var n=$(e);abortCurrentUpload(n),setFileText(n,t),n.data("currentUploader",new FileUploader(exports.shinyapp,fileInputBinding.getId(e),t,e))}function uploadFiles(e){var t=$(e.target);abortCurrentUpload(t);var n=e.target.files,i=void 0===n,a=fileInputBinding.getId(e.target);if(i||0!==n.length){var r=t.closest("div.input-group").find("input[type=text]");i?r.val("[Uploaded file]"):setFileText(t,n),i?new IE8FileUploader(exports.shinyapp,a,e.target):t.data("currentUploader",new FileUploader(exports.shinyapp,a,n,e.target))}}$.extend(FileUploader.prototype,FileProcessor.prototype),function(){this.makeRequest=function(e,t,n,i,a){this.shinyapp.makeRequest(e,t,n,i,a)},this.onBegin=function(e,t){var n=this;this.$setError(null),this.$setActive(!0),this.$setVisible(!0),this.onProgress(null,0),this.totalBytes=0,this.progressBytes=0,$.each(e,function(e,t){n.totalBytes+=t.size});var i=$.map(e,function(e,t){return{name:e.name,size:e.size,type:e.type}});this.makeRequest("uploadInit",[i],function(e){n.jobId=e.jobId,n.uploadUrl=e.uploadUrl,t()},function(e){n.onError(e)})},this.onFile=function(t,e){var n=this;this.onProgress(t,0),$.ajax(this.uploadUrl,{type:"POST",cache:!1,xhr:function(){var e=$.ajaxSettings.xhr();return e.upload&&(e.upload.onprogress=function(e){e.lengthComputable&&n.onProgress(t,(n.progressBytes+e.loaded)/n.totalBytes)}),e},data:t,contentType:"application/octet-stream",processData:!1,success:function(){n.progressBytes+=t.size,e()},error:function(e,t){n.onError(e.responseText||t)}})},this.onComplete=function(){var t=this,e=$.map(this.files,function(e,t){return{name:e.name,size:e.size,type:e.type}}),n=jQuery.Event("shiny:inputchanged");n.name=this.id,n.value=e,n.binding=fileInputBinding,n.el=this.el,n.inputType="shiny.fileupload",$(document).trigger(n),this.makeRequest("uploadEnd",[this.jobId,this.id],function(e){t.$setActive(!1),t.onProgress(null,1),t.$bar().text("Upload complete"),$(n.el).val("")},function(e){t.onError(e)}),this.$bar().text("Finishing upload")},this.onError=function(e){this.$setError(e||""),this.$setActive(!1)},this.onAbort=function(){this.$setVisible(!1)},this.onProgress=function(e,t){this.$bar().width(Math.round(100*t)+"%"),this.$bar().text(e?e.name:"")},this.$container=function(){return $("#"+$escape(this.id)+"_progress.shiny-file-input-progress")},this.$bar=function(){return $("#"+$escape(this.id)+"_progress.shiny-file-input-progress .progress-bar")},this.$setVisible=function(e){this.$container().css("visibility",e?"visible":"hidden")},this.$setError=function(e){this.$bar().toggleClass("progress-bar-danger",null!==e),null!==e&&(this.onProgress(null,1),this.$bar().text(e))},this.$setActive=function(e){this.$container().toggleClass("active",!!e)}}.call(FileUploader.prototype);var $fileInputs=$(),fileInputBinding=new InputBinding;function initShiny(){var c=exports.shinyapp=new ShinyApp;var s,e=new InputBatchSender(c),t=new InputNoResendDecorator(e),n=new InputEventDecorator(t),g=new InputRateDecorator(n),i=new InputDeferDecorator(n);0<$('input[type="submit"], button[type="submit"]').length?(s=i,$('input[type="submit"], button[type="submit"]').each(function(){$(this).click(function(e){e.preventDefault(),i.submit()})})):s=g,s=new InputValidateDecorator(s),exports.setInputValue=exports.onInputChange=function(e,t,n){n=addDefaultInputOpts(n),s.setInput(e,t,n)};var f={};function m(e,t,n){var i=e.getId(t);if(i){var a=e.getValue(t),r=e.getType(t);r&&(i=i+":"+r);var o={priority:n?"deferred":"immediate",binding:e,el:t};s.setInput(i,a,o)}}function a(e){return function(e){var t=0<arguments.length&&void 0!==e?e:document;t=$(t);for(var n=outputBindings.getBindings(),i=0;i<n.length;i++)for(var a=n[i].binding,r=a.find(t)||[],o=0;o<r.length;o++){var s=r[o],u=a.getId(s);if(u&&$.contains(document,s)){var l=$(s);if(!l.hasClass("shiny-bound-output")){var d=new OutputBindingAdapter(s,a);c.bindOutput(u,d),l.data("shiny-output-binding",d),l.addClass("shiny-bound-output"),l.trigger({type:"shiny:bound",binding:a,bindingType:"output"})}}}setTimeout(v,0),setTimeout(x,0)}(e),function(e){for(var t=0<arguments.length&&void 0!==e?e:document,n=inputBindings.getBindings(),i={},a=0;a<n.length;a++)for(var r=n[a].binding,o=r.find(t)||[],s=0;s<o.length;s++){var u=o[s],l=r.getId(u);if(l&&!f[l]){var d=r.getType(u),c=d?l+":"+d:l;i[c]={value:r.getValue(u),opts:{immediate:!0,binding:r,el:u}};var p=function(){var t=r,n=u;return function(e){m(t,n,e)}}();r.subscribe(u,p),$(u).data("shiny-input-binding",r),$(u).addClass("shiny-bound-input");var h=r.getRatePolicy(u);null!==h&&g.setRatePolicy(c,h.policy,h.delay),f[l]={binding:r,node:u},$(u).trigger({type:"shiny:bound",binding:r,bindingType:"input"})}}return i}(e)}function r(){for(var e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:document,t=inputBindings.getBindings(),n=0;n<t.length;n++)for(var i=t[n].binding,a=i.find(e)||[],r=0;r<a.length;r++)a[r]._shiny_initialized||(a[r]._shiny_initialized=!0,i.initialize(a[r]))}function o(e){var t=$(e).data("shiny-output-binding");return t?t.getId():null}exports.bindAll=function(e){var t=a(e);$.each(t,function(e,t){s.setInput(e,t.value,t.opts)}),initDeferredIframes()},exports.unbindAll=function(e){var t=1<arguments.length&&void 0!==arguments[1]&&arguments[1];!function(e,t){var n=0<arguments.length&&void 0!==e?e:document,i=1<arguments.length&&void 0!==t&&t,a=$(n).find(".shiny-bound-input");i&&$(n).hasClass("shiny-bound-input")&&a.push(n);for(var r=0;r<a.length;r++){var o=a[r],s=$(o).data("shiny-input-binding");if(s){var u=s.getId(o);$(o).removeClass("shiny-bound-input"),delete f[u],s.unsubscribe(o),$(o).trigger({type:"shiny:unbound",binding:s,bindingType:"input"})}}}(e,t),function(e,t){var n=0<arguments.length&&void 0!==e?e:document,i=1<arguments.length&&void 0!==t&&t,a=$(n).find(".shiny-bound-output");i&&$(n).hasClass("shiny-bound-output")&&a.push(n);for(var r=0;r<a.length;r++){var o=$(a[r]),s=o.data("shiny-output-binding");if(s){var u=s.binding.getId(a[r]);c.unbindOutput(u,s),o.removeClass("shiny-bound-output"),o.removeData("shiny-output-binding"),o.trigger({type:"shiny:unbound",binding:s.binding,bindingType:"output"})}}setTimeout(v,0),setTimeout(x,0)}(e,t)},(exports.initializeInputs=r)(document);var u=mapValues(a(document),function(e){return e.value});function l(e){if(!e)return null;var t=getStyle(e,"background-color"),n=t.match(/^rgba\(\s*([\d.]+)\s*,\s*([\d.]+)\s*,\s*([\d.]+)\s*,\s*([\d.]+)\s*\)$/);if("transparent"===t||n&&0===parseFloat(n[4])){var i=getStyle(e,"background-image");return i&&"none"!==i?null:l(e.parentElement)}return t}function d(e){var t=document.createElement("a");t.href="/";var n=document.createElement("div");n.style.setProperty("position","absolute","important"),n.style.setProperty("top","-1000px","important"),n.style.setProperty("left","0","important"),n.style.setProperty("width","30px","important"),n.style.setProperty("height","10px","important"),n.appendChild(t),e.appendChild(n);var i=getStyle(t,"color");return e.removeChild(n),i}function p(e){var t=getStyle(e,"font-family"),n=getStyle(e,"font-size");return{families:t.replace(/"/g,"").split(", "),size:n}}$(".shiny-image-output, .shiny-plot-output, .shiny-report-size").each(function(){var e=o(this);0===this.offsetWidth&&0===this.offsetHeight||(u[".clientdata_output_"+e+"_width"]=this.offsetWidth,u[".clientdata_output_"+e+"_height"]=this.offsetHeight)}),$(".shiny-image-output, .shiny-plot-output, .shiny-report-theme").each(function(){var e=o(this);u[".clientdata_output_"+e+"_bg"]=l(this),u[".clientdata_output_"+e+"_fg"]=getStyle(this,"color"),u[".clientdata_output_"+e+"_accent"]=d(this),u[".clientdata_output_"+e+"_font"]=p(this)});var h=new Debouncer(null,function(){$(".shiny-image-output, .shiny-plot-output, .shiny-report-size").each(function(){var e=o(this);0===this.offsetWidth&&0===this.offsetHeight||(s.setInput(".clientdata_output_"+e+"_width",this.offsetWidth),s.setInput(".clientdata_output_"+e+"_height",this.offsetHeight))}),$(".shiny-image-output, .shiny-plot-output, .shiny-report-theme").each(function(){var e=o(this);s.setInput(".clientdata_output_"+e+"_bg",l(this)),s.setInput(".clientdata_output_"+e+"_fg",getStyle(this,"color")),s.setInput(".clientdata_output_"+e+"_accent",d(this)),s.setInput(".clientdata_output_"+e+"_font",p(this))}),$(".shiny-bound-output").each(function(){var e=$(this),t=e.data("shiny-output-binding");e.trigger({type:"shiny:visualchange",visible:!y(this),binding:t}),t.onResize()})},0);function v(){h.normalCall()}function y(e){return null!==e&&0===e.offsetWidth&&0===e.offsetHeight&&("none"===getStyle(e,"display")||y(e.parentNode))}e.lastChanceCallback.push(function(){h.isPending()&&h.immediateCall()});var b={};$(".shiny-bound-output").each(function(){var e=o(this);y(this)?u[".clientdata_output_"+e+"_hidden"]=!0:(b[e]=!0,u[".clientdata_output_"+e+"_hidden"]=!1)});var w=new Debouncer(null,function(){var a={};for(var e in $(".shiny-bound-output").each(function(){var e=o(this);delete b[e];var t=y(this),n={type:"shiny:visualchange",visible:!t};t?s.setInput(".clientdata_output_"+e+"_hidden",!0):(a[e]=!0,s.setInput(".clientdata_output_"+e+"_hidden",!1));var i=$(this);n.binding=i.data("shiny-output-binding"),i.trigger(n)}),b)b.hasOwnProperty(e)&&s.setInput(".clientdata_output_"+e+"_hidden",!0);b=a},0);function x(){w.normalCall()}function I(i,a){return i=i.split("."),function(e){for(var t=e.namespace.split("."),n=0;n<i.length;n++)if(-1===t.indexOf(i[n]))return;a.apply(this,arguments)}}e.lastChanceCallback.push(function(){w.isPending()&&w.immediateCall()}),$(window).resize(debounce(500,v));$.each(["modal","dropdown","tab","tooltip","popover","collapse"],function(e,t){$(document.body).on("shown.bs."+t+".sendImageSize","*",I("bs",v)),$(document.body).on("shown.bs."+t+".sendOutputHiddenState hidden.bs."+t+".sendOutputHiddenState","*",I("bs",x))}),$(document.body).on("shown.sendImageSize","*",v),$(document.body).on("shown.sendOutputHiddenState hidden.sendOutputHiddenState","*",x),u[".clientdata_pixelratio"]=pixelRatio(),$(window).resize(function(){s.setInput(".clientdata_pixelratio",pixelRatio())}),u[".clientdata_url_protocol"]=window.location.protocol,u[".clientdata_url_hostname"]=window.location.hostname,u[".clientdata_url_port"]=window.location.port,u[".clientdata_url_pathname"]=window.location.pathname,u[".clientdata_url_search"]=window.location.search,$(window).on("pushstate",function(e){s.setInput(".clientdata_url_search",window.location.search)}),$(window).on("popstate",function(e){s.setInput(".clientdata_url_search",window.location.search)}),u[".clientdata_url_hash_initial"]=window.location.hash,u[".clientdata_url_hash"]=window.location.hash,$(window).on("hashchange",function(e){s.setInput(".clientdata_url_hash",window.location.hash)});var _=u[".clientdata_singletons"]=$('script[type="application/shiny-singletons"]').text();singletons.registerNames(_.split(/,/));var B=$('script[type="application/html-dependencies"]').text();$.each(B.split(/;/),function(e,t){var n=/\s*^(.+)\[(.+)\]\s*$/.exec(t);n&&registerDependency(n[1],n[2])}),u[".clientdata_allowDataUriScheme"]="undefined"!=typeof WebSocket,t.reset(u),c.connect(u),$(document).one("shiny:connected",function(){initDeferredIframes()})}function initDeferredIframes(){window.Shiny&&window.Shiny.shinyapp&&window.Shiny.shinyapp.isConnected()&&$(".shiny-frame-deferred").each(function(e,t){var n=$(t);n.removeClass("shiny-frame-deferred"),n.attr("src",n.attr("data-deferred-src")),n.attr("data-deferred-src",null)})}$.extend(fileInputBinding,{find:function(e){return $(e).find('input[type="file"]')},getId:function(e){return InputBinding.prototype.getId.call(this,e)||e.name},getValue:function(e){var t=$(e).attr("data-restore");if(t){t=JSON.parse(t);var n=$(e).closest("div.input-group").find("input[type=text]");1===t.name.length?n.val(t.name[0]):n.val(t.name.length+" files");var i=$(e).closest("div.form-group").find(".progress"),a=i.find(".progress-bar");return i.removeClass("active"),a.width("100%"),a.css("visibility","visible"),t}return null},setValue:function(){},getType:function(){return"shiny.file"},_zoneOf:function(e){return $(e).closest("div.input-group")},_enableDraghover:function(e){var t=$(e),n=0;return t.on({"dragenter.draghover":function(e){0==n++&&t.trigger("draghover:enter",e)},"dragleave.draghover":function(e){0==--n&&t.trigger("draghover:leave",e),n<0&&console.error("draghover childCounter is negative somehow")},"dragover.draghover":function(e){e.preventDefault()},"drop.draghover":function(e){n=0,t.trigger("draghover:drop",e),e.preventDefault()}}),t},_disableDraghover:function(e){return $(e).off(".draghover")},_ZoneClass:{ACTIVE:"shiny-file-input-active",OVER:"shiny-file-input-over"},_enableDocumentEvents:function(){var e=this,t=$("html"),n=this._ZoneClass,i=n.ACTIVE,a=n.OVER;this._enableDraghover(t).on({"draghover:enter.draghover":function(){e._zoneOf($fileInputs).addClass(i)},"draghover:leave.draghover":function(){e._zoneOf($fileInputs).removeClass(i)},"draghover:drop.draghover":function(){e._zoneOf($fileInputs).removeClass(a).removeClass(i)}})},_disableDocumentEvents:function(){var e=$("html");e.off(".draghover"),this._disableDraghover(e)},_canSetFiles:function(e){var t=document.createElement("input");t.type="file";try{t.files=e}catch(e){return!1}return!0},_handleDrop:function(e,t){var n=e.originalEvent.dataTransfer.files,i=$(t);null==n?console.log("Dropping files is not supported on this browser. (no FileList)"):this._canSetFiles(n)?(i.val(""),t.files=e.originalEvent.dataTransfer.files,i.trigger("change")):(i.val(""),uploadDroppedFilesIE10Plus(t,n))},_isIE9:function(){try{return!!window.navigator.userAgent.match(/MSIE 9\./)}catch(e){return!1}},subscribe:function(n){var i=this;if($(n).on("change.fileInputBinding",uploadFiles),!this._isIE9()){0===$fileInputs.length&&this._enableDocumentEvents(),$fileInputs=$fileInputs.add(n);var t=this._zoneOf(n),a=this._ZoneClass.OVER;this._enableDraghover(t).on({"draghover:enter.draghover":function(){t.addClass(a)},"draghover:leave.draghover":function(e){t.removeClass(a),e.stopPropagation()},"draghover:drop.draghover":function(e,t){i._handleDrop(t,n)}})}},unsubscribe:function(e){var t=$(e),n=this._zoneOf(e);n.removeClass(this._ZoneClass.OVER).removeClass(this._ZoneClass.ACTIVE),this._disableDraghover(n),t.off(".fileInputBinding"),n.off(".draghover"),0===($fileInputs=$fileInputs.not(e)).length&&this._disableDocumentEvents()}}),inputBindings.register(fileInputBinding,"shiny.fileInputBinding"),$(function(){setTimeout(initShiny,1)}),$(document).on("keydown",function(e){if(114===e.which&&(e.ctrlKey||e.metaKey)&&!e.shiftKey&&!e.altKey){var t="reactlog?w="+window.escape(exports.shinyapp.config.workerId)+"&s="+window.escape(exports.shinyapp.config.sessionId);window.open(t),e.preventDefault()}}),$(document).on("keydown",function(e){if(115===e.which&&(e.ctrlKey||e.metaKey)&&!e.shiftKey&&!e.altKey||114===e.which&&(e.ctrlKey||e.metaKey)&&e.shiftKey&&!e.altKey){var t="reactlog/mark?w="+window.escape(exports.shinyapp.config.workerId)+"&s="+window.escape(exports.shinyapp.config.sessionId);$.get(t,function(e){if("marked"===e){exports.notifications.show({html:'<span id="shiny-reactlog-mark-text">Marked time point in reactlog</span>',closeButton:!0})}}).fail(function(){window.open(t)}),e.preventDefault()}})}();
//# sourceMappingURL=shiny.min.js.map