# Contributing

When contributing to this repository, please first discuss the change you
wish to make via issue, email, or any other method with the owner(s) of
this repository before making a change.

## Submitting Issues

Issues for the RapidDisk project should be filed on the project's GitHub
page: https://github.com/pkoutoupis/rapiddisk/issues.

When submitting an issue, please provide the following information (where
applicable):

1. Linux distribution and distribution version details
2. Linux kernel version and architecture details (uname -a)
3. RapidDisk version (rapiddisk -v)
4. Steps for reproducing the error / issue
5. Relevant system log / dmesg and CLI output

## Pull Requests

All pull requests should have a clear description explaining the submitted
code and the reason for it.

Before submitting code changes, please ensure that the project is able to
build and that the code has been thoroughly tested.

### Code Reviews

All submitted pull requests will undergo a traditional code review process
where reviewers will be assigned or volunteer to review the code submitted
in the pull request. This may be followed by some back and forth dialogue.

During the review process, there may be times when the original submitter
will be asked to modify their code. Upon submitting newly committed code,
the reviewers will review the updated code.

Only when the code looks good, then the project owner(s) will merge the pull
request into the master branch.
