#ifndef _SPECCLASS_H_
#define _SPECCLASS_H_

#include <string>
#include "mathdefs.h"
#include "colors.h"

using std::string;

class SpecClass {
 private:
  string	sSpecstring;	// e.g. "M3.5 V"
  char		sMajor;		// the 'M'
  double	sMinor;		// the 3.5
  double	sMKtype;	// the V
  string	sSpecial;	// extra data, e.g. type of non-stellar objects

  double	lookup(const double table[3][7][2]) const;

 public:
  static int class_to_int(char major);	 // maps "OBAFGKM" -> 0,1,...,6
  static char int_to_class(int classno)  // the reverse
    { static const char classes[] = "OBAFGKM" ; return classes[classno]; }
  
  SpecClass(const string & = "");
  SpecClass(char major, double minor, double MK, string special = "");
  SpecClass(const SpecClass &);
  SpecClass & operator = (const SpecClass &);
  ~SpecClass() { }

  color_t color() const;		// color of a spectral class
					// (may be reset in color.h)
  void initialize();			// set minor type and MK type
  double absmag() const;		// expected absolute magnitude

  // The following two functions are not actually correct as they do
  // not take into account interstellar dust extinction.
  double appmag(double distance) const	// expected apparent mag at given dist.
    { return starmath::get_appmag(absmag(), distance); }
  double distance(double appmag) const	// expected distance given apparent mag
    { return starmath::get_distance(appmag, absmag()); }

  double temperature() const;		// expected temperature in K

  // expected diameter in LY for a given absolute magnitude
  double diameter(double absmag, bool bolometric = false) const;
  double diameter() const { return diameter(absmag()); }
  
  char	 classmajor() const { return sMajor; }
  double classminor() const { return sMinor; }
  double MKtype() const { return sMKtype; }
  string special() const { return sSpecial; }
  string print() const { return sSpecstring; }
};

#endif
