/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *  *          Zhang <zhangyuanyuan1@kylinos.cn>
 *
 */

#ifndef WINDOWTHUMBNAILMANAGER_H
#define WINDOWTHUMBNAILMANAGER_H
#include "ukuitaskgroup.h"
#include <windowmanager/windowmanager.h>
#include "windowThumbnailView.h"

using namespace kdk;

class WindowThumbnailManager : public QObject
{
    Q_OBJECT

public:
    WindowThumbnailManager(QObject *parent = nullptr);
    ~WindowThumbnailManager() override;

    void show(QList<WindowId> winIdList, QString groupName, int x, int y);
    void hide(QString groupName);

private:
    bool isHorizontalPanel();
    QList<WindowId> m_winIdList;
    QString m_groupName;
    ThumbnailView *m_view;
    PanelPositionType m_panelPosition = PanelPositionType::Bottom;
    int m_panelSize = 24;
    int m_x = 0;
    int m_y = 0;
};

#endif //WINDOWTHUMBNAILMANAGER_H
