/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.data.NumUtils;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Axes
extends Drawable {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int CENTER = 4;
    public static final int SMART = 5;
    private int xAxisPosition = 5;
    private int yAxisPosition = 5;
    private Color axesColor = new Color(0, 0, 180);
    private Color lightAxesColor = new Color(180, 180, 255);
    private Color labelColor = Color.black;
    private String xLabel = null;
    private String yLabel = null;
    private transient int[] xTicks;
    private transient int[] yTicks;
    private transient String[] xTickLabels;
    private transient String[] yTickLabels;
    private transient int[][] xTickLabelPos;
    private transient int[][] yTickLabelPos;
    private transient int xAxisPixelPosition;
    private transient int yAxisPixelPosition;
    private transient int xLabel_x;
    private transient int xLabel_y;
    private transient int yLabel_x;
    private transient int yLabel_y;
    private transient Font font;
    private transient int ascent;
    private transient int descent;
    private transient int digitWidth;

    public Axes() {
        this(null, null);
    }

    public Axes(String string, String string2) {
        this.xLabel = string;
        this.yLabel = string2;
    }

    public Color getAxesColor() {
        return this.axesColor;
    }

    public void setAxesColor(Color color) {
        if (color != null && !color.equals(this.axesColor)) {
            this.axesColor = color;
            this.needsRedraw();
        }
    }

    public Color getLightAxesColor() {
        return this.lightAxesColor;
    }

    public void setLightAxesColor(Color color) {
        if (color != null && !color.equals(this.lightAxesColor)) {
            this.lightAxesColor = color;
            this.needsRedraw();
        }
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        if (color != null && !color.equals(this.labelColor)) {
            this.labelColor = color;
            if (this.xLabel != null || this.yLabel != null) {
                this.needsRedraw();
            }
        }
    }

    public int getXAxisPosition() {
        return this.xAxisPosition;
    }

    public void setXAxisPosition(int n) {
        if ((n == 0 || n == 1 || n == 4 || n == 5) && n != this.xAxisPosition) {
            this.xAxisPosition = n;
            this.needsRedraw();
        }
    }

    public int getYAxisPosition() {
        return this.yAxisPosition;
    }

    public void setYAxisPosition(int n) {
        if ((n == 2 || n == 3 || n == 4 || n == 5) && n != this.yAxisPosition) {
            this.yAxisPosition = n;
            this.needsRedraw();
        }
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setXLabel(String string) {
        this.xLabel = string;
        this.needsRedraw();
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setYLabel(String string) {
        this.yLabel = string;
        this.needsRedraw();
    }

    @Override
    public void draw(Graphics graphics, boolean bl) {
        if (this.coords == null) {
            return;
        }
        if (bl || this.xTicks == null || !graphics.getFont().equals(this.font)) {
            this.font = graphics.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            this.setup(fontMetrics, this.coords.getXmin(), this.coords.getXmax(), this.coords.getYmin(), this.coords.getYmax(), this.coords.getLeft(), this.coords.getTop(), this.coords.getWidth(), this.coords.getHeight(), this.coords.getGap());
        }
        this.doDraw(graphics, this.coords.getXmin(), this.coords.getXmax(), this.coords.getYmin(), this.coords.getYmax(), this.coords.getLeft(), this.coords.getTop(), this.coords.getWidth(), this.coords.getHeight(), this.coords.getGap());
    }

    private void doDraw(Graphics graphics, double d, double d2, double d3, double d4, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        if (this.xAxisPosition == 5 && (d4 < 0.0 || d3 > 0.0)) {
            graphics.setColor(this.lightAxesColor);
        } else {
            graphics.setColor(this.axesColor);
        }
        graphics.drawLine(n + n5, this.xAxisPixelPosition, n + n3 - n5 - 1, this.xAxisPixelPosition);
        for (n8 = 0; n8 < this.xTicks.length; ++n8) {
            n7 = this.xAxisPixelPosition - 2 < n2 ? this.xAxisPixelPosition : this.xAxisPixelPosition - 2;
            n6 = this.xAxisPixelPosition + 2 >= n2 + n4 ? this.xAxisPixelPosition : this.xAxisPixelPosition + 2;
            graphics.drawLine(this.xTicks[n8], n7, this.xTicks[n8], n6);
        }
        for (n8 = 0; n8 < this.xTickLabels.length; ++n8) {
            graphics.drawString(this.xTickLabels[n8], this.xTickLabelPos[n8][0], this.xTickLabelPos[n8][1]);
        }
        if (this.yAxisPosition == 5 && (d2 < 0.0 || d > 0.0)) {
            graphics.setColor(this.lightAxesColor);
        } else {
            graphics.setColor(this.axesColor);
        }
        graphics.drawLine(this.yAxisPixelPosition, n2 + n5, this.yAxisPixelPosition, n2 + n4 - n5 - 1);
        for (n8 = 0; n8 < this.yTicks.length; ++n8) {
            n7 = this.yAxisPixelPosition - 2 < n ? this.yAxisPixelPosition : this.yAxisPixelPosition - 2;
            n6 = this.yAxisPixelPosition + 2 >= n + n3 ? this.yAxisPixelPosition : this.yAxisPixelPosition + 2;
            graphics.drawLine(n7, this.yTicks[n8], n6, this.yTicks[n8]);
        }
        for (n8 = 0; n8 < this.yTickLabels.length; ++n8) {
            graphics.drawString(this.yTickLabels[n8], this.yTickLabelPos[n8][0], this.yTickLabelPos[n8][1]);
        }
        graphics.setColor(this.labelColor);
        if (this.xLabel != null) {
            graphics.drawString(this.xLabel, this.xLabel_x, this.xLabel_y);
        }
        if (this.yLabel != null) {
            graphics.drawString(this.yLabel, this.yLabel_x, this.yLabel_y);
        }
    }

    void setup(FontMetrics fontMetrics, double d, double d2, double d3, double d4, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        this.digitWidth = fontMetrics.charWidth('0');
        this.ascent = fontMetrics.getAscent();
        this.descent = fontMetrics.getDescent();
        switch (this.xAxisPosition) {
            case 0: {
                this.xAxisPixelPosition = n2 + n5;
                break;
            }
            case 1: {
                this.xAxisPixelPosition = n2 + n4 - n5 - 1;
                break;
            }
            case 4: {
                this.xAxisPixelPosition = n2 + n4 / 2;
                break;
            }
            case 5: {
                this.xAxisPixelPosition = d4 < 0.0 ? n2 + n5 : (d3 > 0.0 ? n2 + n4 - n5 - 1 : n2 + n5 + (int)((double)(n4 - 2 * n5 - 1) * d4 / (d4 - d3)));
            }
        }
        switch (this.yAxisPosition) {
            case 2: {
                this.yAxisPixelPosition = n + n5;
                break;
            }
            case 1: {
                this.yAxisPixelPosition = n + n3 - n5 - 1;
                break;
            }
            case 4: {
                this.yAxisPixelPosition = n + n3 / 2;
                break;
            }
            case 5: {
                this.yAxisPixelPosition = d2 < 0.0 ? n + n3 - n5 - 1 : (d > 0.0 ? n + n5 : n + n5 - (int)((double)(n3 - 2 * n5 - 1) * d / (d2 - d)));
            }
        }
        if (this.xLabel != null) {
            n7 = fontMetrics.stringWidth(this.xLabel);
            this.xLabel_x = n + n3 - n5 - n7 <= this.yAxisPixelPosition ? n + n5 : n + n3 - n5 - n7;
            this.xLabel_y = this.xAxisPixelPosition + 3 + this.ascent + this.descent + n5 >= n2 + n4 ? this.xAxisPixelPosition - 4 : this.xAxisPixelPosition + 3 + this.ascent;
        }
        if (this.yLabel != null) {
            n7 = fontMetrics.stringWidth(this.yLabel);
            this.yLabel_x = this.yAxisPixelPosition + 3 + n7 + n5 > n + n3 ? this.yAxisPixelPosition - n7 - 3 : this.yAxisPixelPosition + 3;
            this.yLabel_y = n2 + this.ascent + this.descent + n5 > this.xAxisPixelPosition ? n2 + n4 - n5 - this.descent : n2 + this.ascent + n5;
        }
        double d5 = this.fudgeStart((d2 - d) * (double)(this.yAxisPixelPosition - (n + n5)) / (double)(n3 - 2 * n5) + d, 0.05 * (d2 - d));
        int n8 = (n3 - 2 * n5) / (10 * this.digitWidth);
        if (n8 <= 2) {
            n8 = 3;
        } else if (n8 > 20) {
            n8 = 20;
        }
        double d6 = this.fudge((d2 - d) / (double)n8);
        for (double d7 = 1.5; d7 < 4.0 && (double)(fontMetrics.stringWidth(NumUtils.realToString(d6 + d5)) + this.digitWidth) > d6 / (d2 - d) * (double)(n3 - 2 * n5); d7 += 0.5) {
            d6 = this.fudge(d7 * (d2 - d) / (double)n8);
        }
        double[] dArray = new double[50];
        n8 = 0;
        double d8 = d5 + d6;
        double d9 = n + n3;
        if (this.xLabel != null && n + n3 - n5 - fontMetrics.stringWidth(this.xLabel) > this.yAxisPixelPosition) {
            d9 -= (double)(fontMetrics.stringWidth(this.xLabel) + n5 + this.digitWidth);
        }
        while (n8 < 50 && d8 <= d2 && !((double)(n + n5) + (double)(n3 - 2 * n5) * (d8 - d) / (d2 - d) + (double)(fontMetrics.stringWidth(NumUtils.realToString(d8)) / 2) > d9)) {
            dArray[n8] = d8;
            ++n8;
            d8 += d6;
        }
        d8 = d5 - d6;
        d9 = n;
        if (this.xLabel != null && n + n3 - n5 - fontMetrics.stringWidth(this.xLabel) <= this.yAxisPixelPosition) {
            d9 += (double)(fontMetrics.stringWidth(this.xLabel) + this.digitWidth);
        }
        while (n8 < 50 && d8 >= d && !((double)(n + n5) + (double)(n3 - 2 * n5) * (d8 - d) / (d2 - d) - (double)(fontMetrics.stringWidth(NumUtils.realToString(d8)) / 2) < d9)) {
            dArray[n8] = d8;
            ++n8;
            d8 -= d6;
        }
        this.xTicks = new int[n8];
        this.xTickLabels = new String[n8];
        this.xTickLabelPos = new int[n8][2];
        for (int i = 0; i < n8; ++i) {
            this.xTicks[i] = (int)((double)(n + n5) + (double)(n3 - 2 * n5) * (dArray[i] - d) / (d2 - d));
            this.xTickLabels[i] = NumUtils.realToString(dArray[i]);
            this.xTickLabelPos[i][0] = this.xTicks[i] - fontMetrics.stringWidth(this.xTickLabels[i]) / 2;
            this.xTickLabelPos[i][1] = this.xAxisPixelPosition - 4 - this.ascent >= n2 ? this.xAxisPixelPosition - 4 : this.xAxisPixelPosition + 4 + this.ascent;
        }
        d5 = Math.abs(d4 - d3) > 100.0 ? 0.0 : this.fudgeStart(d4 - (d4 - d3) * (double)(this.xAxisPixelPosition - (n2 + n5)) / (double)(n4 - 2 * n5), 0.05 * (d4 - d3));
        n8 = (n4 - 2 * n5) / (5 * (this.ascent + this.descent));
        if (n8 <= 2) {
            n8 = 3;
        } else if (n8 > 20) {
            n8 = 20;
        }
        d6 = this.fudge((d4 - d3) / (double)n8);
        n8 = 0;
        double d10 = d5 + d6;
        d9 = n2 + 8 + n5;
        if (this.yLabel != null && n2 + n5 + this.ascent + this.descent <= this.xAxisPixelPosition) {
            d9 = n2 + n5 + this.ascent + this.descent;
        }
        while (n8 < 50 && d10 <= d4 && !((double)(n2 + n5) + (double)(n4 - 2 * n5) * (d4 - d10) / (d4 - d3) - (double)(this.ascent / 2) < d9)) {
            dArray[n8] = d10;
            ++n8;
            d10 += d6;
        }
        d10 = d5 - d6;
        d9 = n2 + n4 - n5 - 8;
        if (this.yLabel != null && n2 + n5 + this.ascent + this.descent > this.xAxisPixelPosition) {
            d9 = n2 + n4 - n5 - this.ascent - this.descent;
        }
        while (n8 < 50 && d10 >= d3 && !((double)(n2 + n5) + (double)(n4 - 2 * n5) * (d4 - d10) / (d4 - d3) + (double)(this.ascent / 2) > d9)) {
            dArray[n8] = d10;
            ++n8;
            d10 -= d6;
        }
        this.yTicks = new int[n8];
        this.yTickLabels = new String[n8];
        this.yTickLabelPos = new int[n8][2];
        int n9 = 0;
        for (n6 = 0; n6 < n8; ++n6) {
            this.yTickLabels[n6] = NumUtils.realToString(dArray[n6]);
            int n10 = fontMetrics.stringWidth(this.yTickLabels[n6]);
            if (n10 <= n9) continue;
            n9 = n10;
        }
        for (n6 = 0; n6 < n8; ++n6) {
            this.yTicks[n6] = (int)((double)(n2 + n5) + (double)(n4 - 2 * n5) * (d4 - dArray[n6]) / (d4 - d3));
            this.yTickLabelPos[n6][1] = this.yTicks[n6] + this.ascent / 2;
            this.yTickLabelPos[n6][0] = this.yAxisPixelPosition - 4 - n9 < n ? this.yAxisPixelPosition + 4 : this.yAxisPixelPosition - 4 - fontMetrics.stringWidth(this.yTickLabels[n6]);
        }
    }

    double fudge(double d) {
        if (Math.abs(d) < 5.0E-4 || Math.abs(d) > 500000.0) {
            return d;
        }
        if (Math.abs(d) < 0.1 || Math.abs(d) > 5000.0) {
            double d2 = d;
            int n = 0;
            if (Math.abs(d2) >= 1.0) {
                while (Math.abs(d2) >= 8.75) {
                    d2 /= 10.0;
                    ++n;
                }
            } else {
                while (Math.abs(d2) < 1.0) {
                    d2 *= 10.0;
                    --n;
                }
            }
            d2 = Math.round(d2 * 4.0) / 4L;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    d2 *= 10.0;
                }
            } else if (n < 0) {
                for (int i = 0; i < -n; ++i) {
                    d2 /= 10.0;
                }
            }
            return d2;
        }
        if (Math.abs(d) < 0.5) {
            return (double)Math.round(10.0 * d) / 10.0;
        }
        if (Math.abs(d) < 2.5) {
            return (double)Math.round(2.0 * d) / 2.0;
        }
        if (Math.abs(d) < 12.0) {
            return Math.round(d);
        }
        if (Math.abs(d) < 120.0) {
            return (double)Math.round(d / 10.0) * 10.0;
        }
        if (Math.abs(d) < 1200.0) {
            return (double)Math.round(d / 100.0) * 100.0;
        }
        return (double)Math.round(d / 1000.0) * 1000.0;
    }

    private double fudgeStart(double d, double d2) {
        if (Math.abs((double)Math.round(d) - d) < d2) {
            return Math.round(d);
        }
        for (double d3 = 10.0; d3 <= 100000.0; d3 *= 10.0) {
            double d4 = (double)Math.round(d * d3) / d3;
            if (!(Math.abs(d4 - d) < d2)) continue;
            return d4;
        }
        return d;
    }
}

