/*------------------------------------------------------------------------
 *  Copyright 2008-2009 (c) Jeff Brown <spadix@users.sourceforge.net>
 *
 *  This file is part of the ZBar Bar Code Reader.
 *
 *  The ZBar Bar Code Reader is free software; you can redistribute it
 *  and/or modify it under the terms of the GNU Lesser Public License as
 *  published by the Free Software Foundation; either version 2.1 of
 *  the License, or (at your option) any later version.
 *
 *  The ZBar Bar Code Reader is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 *  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser Public License
 *  along with the ZBar Bar Code Reader; if not, write to the Free
 *  Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 *  Boston, MA  02110-1301  USA
 *
 *  http://sourceforge.net/projects/zbar
 *------------------------------------------------------------------------*/
#ifndef _PDF417_ENCODE_H_
#define _PDF417_ENCODE_H_

unsigned long pdf417_encode[929][3] = {
  { 0x31111136, 0x51111125, 0x21111155, }, /* 0 */
  { 0x41111144, 0x61111133, 0x31111163, }, /* 1 */
  { 0x51111152, 0x41111216, 0x11111246, }, /* 2 */
  { 0x31111235, 0x51111224, 0x21111254, }, /* 3 */
  { 0x41111243, 0x61111232, 0x31111262, }, /* 4 */
  { 0x51111251, 0x41111315, 0x11111345, }, /* 5 */
  { 0x21111326, 0x51111323, 0x21111353, }, /* 6 */
  { 0x31111334, 0x61111331, 0x31111361, }, /* 7 */
  { 0x21111425, 0x41111414, 0x11111444, }, /* 8 */
  { 0x11111516, 0x51111422, 0x21111452, }, /* 9 */
  { 0x21111524, 0x41111513, 0x11111543, }, /* 10 */
  { 0x11111615, 0x51111521, 0x61112114, }, /* 11 */
  { 0x21112136, 0x41111612, 0x11112155, }, /* 12 */
  { 0x31112144, 0x41112125, 0x21112163, }, /* 13 */
  { 0x41112152, 0x51112133, 0x61112213, }, /* 14 */
  { 0x21112235, 0x61112141, 0x11112254, }, /* 15 */
  { 0x31112243, 0x31112216, 0x21112262, }, /* 16 */
  { 0x41112251, 0x41112224, 0x61112312, }, /* 17 */
  { 0x11112326, 0x51112232, 0x11112353, }, /* 18 */
  { 0x21112334, 0x31112315, 0x21112361, }, /* 19 */
  { 0x11112425, 0x41112323, 0x61112411, }, /* 20 */
  { 0x11113136, 0x51112331, 0x11112452, }, /* 21 */
  { 0x21113144, 0x31112414, 0x51113114, }, /* 22 */
  { 0x31113152, 0x41112422, 0x61113122, }, /* 23 */
  { 0x11113235, 0x31112513, 0x11113163, }, /* 24 */
  { 0x21113243, 0x41112521, 0x51113213, }, /* 25 */
  { 0x31113251, 0x31112612, 0x61113221, }, /* 26 */
  { 0x11113334, 0x31113125, 0x11113262, }, /* 27 */
  { 0x21113342, 0x41113133, 0x51113312, }, /* 28 */
  { 0x11114144, 0x51113141, 0x11113361, }, /* 29 */
  { 0x21114152, 0x21113216, 0x51113411, }, /* 30 */
  { 0x11114243, 0x31113224, 0x41114114, }, /* 31 */
  { 0x21114251, 0x41113232, 0x51114122, }, /* 32 */
  { 0x11115152, 0x21113315, 0x41114213, }, /* 33 */
  { 0x51116111, 0x31113323, 0x51114221, }, /* 34 */
  { 0x31121135, 0x41113331, 0x41114312, }, /* 35 */
  { 0x41121143, 0x21113414, 0x41114411, }, /* 36 */
  { 0x51121151, 0x31113422, 0x31115114, }, /* 37 */
  { 0x21121226, 0x21113513, 0x41115122, }, /* 38 */
  { 0x31121234, 0x31113521, 0x31115213, }, /* 39 */
  { 0x41121242, 0x21113612, 0x41115221, }, /* 40 */
  { 0x21121325, 0x21114125, 0x31115312, }, /* 41 */
  { 0x31121333, 0x31114133, 0x31115411, }, /* 42 */
  { 0x11121416, 0x41114141, 0x21116114, }, /* 43 */
  { 0x21121424, 0x11114216, 0x31116122, }, /* 44 */
  { 0x31121432, 0x21114224, 0x21116213, }, /* 45 */
  { 0x11121515, 0x31114232, 0x31116221, }, /* 46 */
  { 0x21121523, 0x11114315, 0x21116312, }, /* 47 */
  { 0x11121614, 0x21114323, 0x11121146, }, /* 48 */
  { 0x21122135, 0x31114331, 0x21121154, }, /* 49 */
  { 0x31122143, 0x11114414, 0x31121162, }, /* 50 */
  { 0x41122151, 0x21114422, 0x11121245, }, /* 51 */
  { 0x11122226, 0x11114513, 0x21121253, }, /* 52 */
  { 0x21122234, 0x21114521, 0x31121261, }, /* 53 */
  { 0x31122242, 0x11115125, 0x11121344, }, /* 54 */
  { 0x11122325, 0x21115133, 0x21121352, }, /* 55 */
  { 0x21122333, 0x31115141, 0x11121443, }, /* 56 */
  { 0x31122341, 0x11115224, 0x21121451, }, /* 57 */
  { 0x11122424, 0x21115232, 0x11121542, }, /* 58 */
  { 0x21122432, 0x11115323, 0x61122113, }, /* 59 */
  { 0x11123135, 0x21115331, 0x11122154, }, /* 60 */
  { 0x21123143, 0x11115422, 0x21122162, }, /* 61 */
  { 0x31123151, 0x11116133, 0x61122212, }, /* 62 */
  { 0x11123234, 0x21116141, 0x11122253, }, /* 63 */
  { 0x21123242, 0x11116232, 0x21122261, }, /* 64 */
  { 0x11123333, 0x11116331, 0x61122311, }, /* 65 */
  { 0x21123341, 0x41121116, 0x11122352, }, /* 66 */
  { 0x11124143, 0x51121124, 0x11122451, }, /* 67 */
  { 0x21124151, 0x61121132, 0x51123113, }, /* 68 */
  { 0x11124242, 0x41121215, 0x61123121, }, /* 69 */
  { 0x11124341, 0x51121223, 0x11123162, }, /* 70 */
  { 0x21131126, 0x61121231, 0x51123212, }, /* 71 */
  { 0x31131134, 0x41121314, 0x11123261, }, /* 72 */
  { 0x41131142, 0x51121322, 0x51123311, }, /* 73 */
  { 0x21131225, 0x41121413, 0x41124113, }, /* 74 */
  { 0x31131233, 0x51121421, 0x51124121, }, /* 75 */
  { 0x41131241, 0x41121512, 0x41124212, }, /* 76 */
  { 0x11131316, 0x41121611, 0x41124311, }, /* 77 */
  { 0x21131324, 0x31122116, 0x31125113, }, /* 78 */
  { 0x31131332, 0x41122124, 0x41125121, }, /* 79 */
  { 0x11131415, 0x51122132, 0x31125212, }, /* 80 */
  { 0x21131423, 0x31122215, 0x31125311, }, /* 81 */
  { 0x11131514, 0x41122223, 0x21126113, }, /* 82 */
  { 0x11131613, 0x51122231, 0x31126121, }, /* 83 */
  { 0x11132126, 0x31122314, 0x21126212, }, /* 84 */
  { 0x21132134, 0x41122322, 0x21126311, }, /* 85 */
  { 0x31132142, 0x31122413, 0x11131145, }, /* 86 */
  { 0x11132225, 0x41122421, 0x21131153, }, /* 87 */
  { 0x21132233, 0x31122512, 0x31131161, }, /* 88 */
  { 0x31132241, 0x31122611, 0x11131244, }, /* 89 */
  { 0x11132324, 0x21123116, 0x21131252, }, /* 90 */
  { 0x21132332, 0x31123124, 0x11131343, }, /* 91 */
  { 0x11132423, 0x41123132, 0x21131351, }, /* 92 */
  { 0x11132522, 0x21123215, 0x11131442, }, /* 93 */
  { 0x11133134, 0x31123223, 0x11131541, }, /* 94 */
  { 0x21133142, 0x41123231, 0x61132112, }, /* 95 */
  { 0x11133233, 0x21123314, 0x11132153, }, /* 96 */
  { 0x21133241, 0x31123322, 0x21132161, }, /* 97 */
  { 0x11133332, 0x21123413, 0x61132211, }, /* 98 */
  { 0x11134142, 0x31123421, 0x11132252, }, /* 99 */
  { 0x21141125, 0x21123512, 0x11132351, }, /* 100 */
  { 0x31141133, 0x21123611, 0x51133112, }, /* 101 */
  { 0x41141141, 0x11124116, 0x11133161, }, /* 102 */
  { 0x11141216, 0x21124124, 0x51133211, }, /* 103 */
  { 0x21141224, 0x31124132, 0x41134112, }, /* 104 */
  { 0x31141232, 0x11124215, 0x41134211, }, /* 105 */
  { 0x11141315, 0x21124223, 0x31135112, }, /* 106 */
  { 0x21141323, 0x31124231, 0x31135211, }, /* 107 */
  { 0x31141331, 0x11124314, 0x21136112, }, /* 108 */
  { 0x11141414, 0x21124322, 0x21136211, }, /* 109 */
  { 0x21141422, 0x11124413, 0x11141144, }, /* 110 */
  { 0x11141513, 0x21124421, 0x21141152, }, /* 111 */
  { 0x21141521, 0x11124512, 0x11141243, }, /* 112 */
  { 0x11142125, 0x11125124, 0x21141251, }, /* 113 */
  { 0x21142133, 0x21125132, 0x11141342, }, /* 114 */
  { 0x31142141, 0x11125223, 0x11141441, }, /* 115 */
  { 0x11142224, 0x21125231, 0x61142111, }, /* 116 */
  { 0x21142232, 0x11125322, 0x11142152, }, /* 117 */
  { 0x11142323, 0x11125421, 0x11142251, }, /* 118 */
  { 0x21142331, 0x11126132, 0x51143111, }, /* 119 */
  { 0x11142422, 0x11126231, 0x41144111, }, /* 120 */
  { 0x11142521, 0x41131115, 0x31145111, }, /* 121 */
  { 0x21143141, 0x51131123, 0x11151143, }, /* 122 */
  { 0x11143331, 0x61131131, 0x21151151, }, /* 123 */
  { 0x11151116, 0x41131214, 0x11151242, }, /* 124 */
  { 0x21151124, 0x51131222, 0x11151341, }, /* 125 */
  { 0x31151132, 0x41131313, 0x11152151, }, /* 126 */
  { 0x11151215, 0x51131321, 0x11161142, }, /* 127 */
  { 0x21151223, 0x41131412, 0x11161241, }, /* 128 */
  { 0x31151231, 0x41131511, 0x12111146, }, /* 129 */
  { 0x11151314, 0x31132115, 0x22111154, }, /* 130 */
  { 0x21151322, 0x41132123, 0x32111162, }, /* 131 */
  { 0x11151413, 0x51132131, 0x12111245, }, /* 132 */
  { 0x21151421, 0x31132214, 0x22111253, }, /* 133 */
  { 0x11151512, 0x41132222, 0x32111261, }, /* 134 */
  { 0x11152124, 0x31132313, 0x12111344, }, /* 135 */
  { 0x11152223, 0x41132321, 0x22111352, }, /* 136 */
  { 0x11152322, 0x31132412, 0x12111443, }, /* 137 */
  { 0x11161115, 0x31132511, 0x22111451, }, /* 138 */
  { 0x31161131, 0x21133115, 0x12111542, }, /* 139 */
  { 0x21161222, 0x31133123, 0x62112113, }, /* 140 */
  { 0x21161321, 0x41133131, 0x12112154, }, /* 141 */
  { 0x11161511, 0x21133214, 0x22112162, }, /* 142 */
  { 0x32111135, 0x31133222, 0x62112212, }, /* 143 */
  { 0x42111143, 0x21133313, 0x12112253, }, /* 144 */
  { 0x52111151, 0x31133321, 0x22112261, }, /* 145 */
  { 0x22111226, 0x21133412, 0x62112311, }, /* 146 */
  { 0x32111234, 0x21133511, 0x12112352, }, /* 147 */
  { 0x42111242, 0x11134115, 0x12112451, }, /* 148 */
  { 0x22111325, 0x21134123, 0x52113113, }, /* 149 */
  { 0x32111333, 0x31134131, 0x62113121, }, /* 150 */
  { 0x42111341, 0x11134214, 0x12113162, }, /* 151 */
  { 0x12111416, 0x21134222, 0x52113212, }, /* 152 */
  { 0x22111424, 0x11134313, 0x12113261, }, /* 153 */
  { 0x12111515, 0x21134321, 0x52113311, }, /* 154 */
  { 0x22112135, 0x11134412, 0x42114113, }, /* 155 */
  { 0x32112143, 0x11134511, 0x52114121, }, /* 156 */
  { 0x42112151, 0x11135123, 0x42114212, }, /* 157 */
  { 0x12112226, 0x21135131, 0x42114311, }, /* 158 */
  { 0x22112234, 0x11135222, 0x32115113, }, /* 159 */
  { 0x32112242, 0x11135321, 0x42115121, }, /* 160 */
  { 0x12112325, 0x11136131, 0x32115212, }, /* 161 */
  { 0x22112333, 0x41141114, 0x32115311, }, /* 162 */
  { 0x12112424, 0x51141122, 0x22116113, }, /* 163 */
  { 0x12112523, 0x41141213, 0x32116121, }, /* 164 */
  { 0x12113135, 0x51141221, 0x22116212, }, /* 165 */
  { 0x22113143, 0x41141312, 0x22116311, }, /* 166 */
  { 0x32113151, 0x41141411, 0x21211145, }, /* 167 */
  { 0x12113234, 0x31142114, 0x31211153, }, /* 168 */
  { 0x22113242, 0x41142122, 0x41211161, }, /* 169 */
  { 0x12113333, 0x31142213, 0x11211236, }, /* 170 */
  { 0x12113432, 0x41142221, 0x21211244, }, /* 171 */
  { 0x12114143, 0x31142312, 0x31211252, }, /* 172 */
  { 0x22114151, 0x31142411, 0x11211335, }, /* 173 */
  { 0x12114242, 0x21143114, 0x21211343, }, /* 174 */
  { 0x12115151, 0x31143122, 0x31211351, }, /* 175 */
  { 0x31211126, 0x21143213, 0x11211434, }, /* 176 */
  { 0x41211134, 0x31143221, 0x21211442, }, /* 177 */
  { 0x51211142, 0x21143312, 0x11211533, }, /* 178 */
  { 0x31211225, 0x21143411, 0x21211541, }, /* 179 */
  { 0x41211233, 0x11144114, 0x11211632, }, /* 180 */
  { 0x51211241, 0x21144122, 0x12121145, }, /* 181 */
  { 0x21211316, 0x11144213, 0x22121153, }, /* 182 */
  { 0x31211324, 0x21144221, 0x32121161, }, /* 183 */
  { 0x41211332, 0x11144312, 0x11212145, }, /* 184 */
  { 0x21211415, 0x11144411, 0x12121244, }, /* 185 */
  { 0x31211423, 0x11145122, 0x22121252, }, /* 186 */
  { 0x41211431, 0x11145221, 0x11212244, }, /* 187 */
  { 0x21211514, 0x41151113, 0x21212252, }, /* 188 */
  { 0x31211522, 0x51151121, 0x22121351, }, /* 189 */
  { 0x22121126, 0x41151212, 0x11212343, }, /* 190 */
  { 0x32121134, 0x41151311, 0x12121442, }, /* 191 */
  { 0x42121142, 0x31152113, 0x11212442, }, /* 192 */
  { 0x21212126, 0x41152121, 0x12121541, }, /* 193 */
  { 0x22121225, 0x31152212, 0x11212541, }, /* 194 */
  { 0x32121233, 0x31152311, 0x62122112, }, /* 195 */
  { 0x42121241, 0x21153113, 0x12122153, }, /* 196 */
  { 0x21212225, 0x31153121, 0x22122161, }, /* 197 */
  { 0x31212233, 0x21153212, 0x61213112, }, /* 198 */
  { 0x41212241, 0x21153311, 0x62122211, }, /* 199 */
  { 0x11212316, 0x11154113, 0x11213153, }, /* 200 */
  { 0x12121415, 0x21154121, 0x12122252, }, /* 201 */
  { 0x22121423, 0x11154212, 0x61213211, }, /* 202 */
  { 0x32121431, 0x11154311, 0x11213252, }, /* 203 */
  { 0x11212415, 0x41161112, 0x12122351, }, /* 204 */
  { 0x21212423, 0x41161211, 0x11213351, }, /* 205 */
  { 0x11212514, 0x31162112, 0x52123112, }, /* 206 */
  { 0x12122126, 0x31162211, 0x12123161, }, /* 207 */
  { 0x22122134, 0x21163112, 0x51214112, }, /* 208 */
  { 0x32122142, 0x21163211, 0x52123211, }, /* 209 */
  { 0x11213126, 0x42111116, 0x11214161, }, /* 210 */
  { 0x12122225, 0x52111124, 0x51214211, }, /* 211 */
  { 0x22122233, 0x62111132, 0x42124112, }, /* 212 */
  { 0x32122241, 0x42111215, 0x41215112, }, /* 213 */
  { 0x11213225, 0x52111223, 0x42124211, }, /* 214 */
  { 0x21213233, 0x62111231, 0x41215211, }, /* 215 */
  { 0x31213241, 0x42111314, 0x32125112, }, /* 216 */
  { 0x11213324, 0x52111322, 0x31216112, }, /* 217 */
  { 0x12122423, 0x42111413, 0x32125211, }, /* 218 */
  { 0x11213423, 0x52111421, 0x31216211, }, /* 219 */
  { 0x12123134, 0x42111512, 0x22126112, }, /* 220 */
  { 0x22123142, 0x42111611, 0x22126211, }, /* 221 */
  { 0x11214134, 0x32112116, 0x11221136, }, /* 222 */
  { 0x12123233, 0x42112124, 0x21221144, }, /* 223 */
  { 0x22123241, 0x52112132, 0x31221152, }, /* 224 */
  { 0x11214233, 0x32112215, 0x11221235, }, /* 225 */
  { 0x21214241, 0x42112223, 0x21221243, }, /* 226 */
  { 0x11214332, 0x52112231, 0x31221251, }, /* 227 */
  { 0x12124142, 0x32112314, 0x11221334, }, /* 228 */
  { 0x11215142, 0x42112322, 0x21221342, }, /* 229 */
  { 0x12124241, 0x32112413, 0x11221433, }, /* 230 */
  { 0x11215241, 0x42112421, 0x21221441, }, /* 231 */
  { 0x31221125, 0x32112512, 0x11221532, }, /* 232 */
  { 0x41221133, 0x32112611, 0x11221631, }, /* 233 */
  { 0x51221141, 0x22113116, 0x12131144, }, /* 234 */
  { 0x21221216, 0x32113124, 0x22131152, }, /* 235 */
  { 0x31221224, 0x42113132, 0x11222144, }, /* 236 */
  { 0x41221232, 0x22113215, 0x12131243, }, /* 237 */
  { 0x21221315, 0x32113223, 0x22131251, }, /* 238 */
  { 0x31221323, 0x42113231, 0x11222243, }, /* 239 */
  { 0x41221331, 0x22113314, 0x21222251, }, /* 240 */
  { 0x21221414, 0x32113322, 0x11222342, }, /* 241 */
  { 0x31221422, 0x22113413, 0x12131441, }, /* 242 */
  { 0x21221513, 0x32113421, 0x11222441, }, /* 243 */
  { 0x21221612, 0x22113512, 0x62132111, }, /* 244 */
  { 0x22131125, 0x22113611, 0x12132152, }, /* 245 */
  { 0x32131133, 0x12114116, 0x61223111, }, /* 246 */
  { 0x42131141, 0x22114124, 0x11223152, }, /* 247 */
  { 0x21222125, 0x32114132, 0x12132251, }, /* 248 */
  { 0x22131224, 0x12114215, 0x11223251, }, /* 249 */
  { 0x32131232, 0x22114223, 0x52133111, }, /* 250 */
  { 0x11222216, 0x32114231, 0x51224111, }, /* 251 */
  { 0x12131315, 0x12114314, 0x42134111, }, /* 252 */
  { 0x31222232, 0x22114322, 0x41225111, }, /* 253 */
  { 0x32131331, 0x12114413, 0x32135111, }, /* 254 */
  { 0x11222315, 0x22114421, 0x31226111, }, /* 255 */
  { 0x12131414, 0x12114512, 0x22136111, }, /* 256 */
  { 0x22131422, 0x12115124, 0x11231135, }, /* 257 */
  { 0x11222414, 0x22115132, 0x21231143, }, /* 258 */
  { 0x21222422, 0x12115223, 0x31231151, }, /* 259 */
  { 0x22131521, 0x22115231, 0x11231234, }, /* 260 */
  { 0x12131612, 0x12115322, 0x21231242, }, /* 261 */
  { 0x12132125, 0x12115421, 0x11231333, }, /* 262 */
  { 0x22132133, 0x12116132, 0x21231341, }, /* 263 */
  { 0x32132141, 0x12116231, 0x11231432, }, /* 264 */
  { 0x11223125, 0x51211115, 0x11231531, }, /* 265 */
  { 0x12132224, 0x61211123, 0x12141143, }, /* 266 */
  { 0x22132232, 0x11211164, 0x22141151, }, /* 267 */
  { 0x11223224, 0x51211214, 0x11232143, }, /* 268 */
  { 0x21223232, 0x61211222, 0x12141242, }, /* 269 */
  { 0x22132331, 0x11211263, 0x11232242, }, /* 270 */
  { 0x11223323, 0x51211313, 0x12141341, }, /* 271 */
  { 0x12132422, 0x61211321, 0x11232341, }, /* 272 */
  { 0x12132521, 0x11211362, 0x12142151, }, /* 273 */
  { 0x12133133, 0x51211412, 0x11233151, }, /* 274 */
  { 0x22133141, 0x51211511, 0x11241134, }, /* 275 */
  { 0x11224133, 0x42121115, 0x21241142, }, /* 276 */
  { 0x12133232, 0x52121123, 0x11241233, }, /* 277 */
  { 0x11224232, 0x62121131, 0x21241241, }, /* 278 */
  { 0x12133331, 0x41212115, 0x11241332, }, /* 279 */
  { 0x11224331, 0x42121214, 0x11241431, }, /* 280 */
  { 0x11225141, 0x61212131, 0x12151142, }, /* 281 */
  { 0x21231116, 0x41212214, 0x11242142, }, /* 282 */
  { 0x31231124, 0x51212222, 0x12151241, }, /* 283 */
  { 0x41231132, 0x52121321, 0x11242241, }, /* 284 */
  { 0x21231215, 0x41212313, 0x11251133, }, /* 285 */
  { 0x31231223, 0x42121412, 0x21251141, }, /* 286 */
  { 0x41231231, 0x41212412, 0x11251232, }, /* 287 */
  { 0x21231314, 0x42121511, 0x11251331, }, /* 288 */
  { 0x31231322, 0x41212511, 0x12161141, }, /* 289 */
  { 0x21231413, 0x32122115, 0x11252141, }, /* 290 */
  { 0x31231421, 0x42122123, 0x11261132, }, /* 291 */
  { 0x21231512, 0x52122131, 0x11261231, }, /* 292 */
  { 0x21231611, 0x31213115, 0x13111145, }, /* 293 */
  { 0x12141116, 0x32122214, 0x23111153, }, /* 294 */
  { 0x22141124, 0x42122222, 0x33111161, }, /* 295 */
  { 0x32141132, 0x31213214, 0x13111244, }, /* 296 */
  { 0x11232116, 0x41213222, 0x23111252, }, /* 297 */
  { 0x12141215, 0x42122321, 0x13111343, }, /* 298 */
  { 0x22141223, 0x31213313, 0x23111351, }, /* 299 */
  { 0x32141231, 0x32122412, 0x13111442, }, /* 300 */
  { 0x11232215, 0x31213412, 0x13111541, }, /* 301 */
  { 0x21232223, 0x32122511, 0x63112112, }, /* 302 */
  { 0x31232231, 0x31213511, 0x13112153, }, /* 303 */
  { 0x11232314, 0x22123115, 0x23112161, }, /* 304 */
  { 0x12141413, 0x32123123, 0x63112211, }, /* 305 */
  { 0x22141421, 0x42123131, 0x13112252, }, /* 306 */
  { 0x11232413, 0x21214115, 0x13112351, }, /* 307 */
  { 0x21232421, 0x22123214, 0x53113112, }, /* 308 */
  { 0x11232512, 0x32123222, 0x13113161, }, /* 309 */
  { 0x12142124, 0x21214214, 0x53113211, }, /* 310 */
  { 0x22142132, 0x31214222, 0x43114112, }, /* 311 */
  { 0x11233124, 0x32123321, 0x43114211, }, /* 312 */
  { 0x12142223, 0x21214313, 0x33115112, }, /* 313 */
  { 0x22142231, 0x22123412, 0x33115211, }, /* 314 */
  { 0x11233223, 0x21214412, 0x23116112, }, /* 315 */
  { 0x21233231, 0x22123511, 0x23116211, }, /* 316 */
  { 0x11233322, 0x21214511, 0x12211136, }, /* 317 */
  { 0x12142421, 0x12124115, 0x22211144, }, /* 318 */
  { 0x11233421, 0x22124123, 0x32211152, }, /* 319 */
  { 0x11234132, 0x32124131, 0x12211235, }, /* 320 */
  { 0x11234231, 0x11215115, 0x22211243, }, /* 321 */
  { 0x21241115, 0x12124214, 0x32211251, }, /* 322 */
  { 0x31241123, 0x22124222, 0x12211334, }, /* 323 */
  { 0x41241131, 0x11215214, 0x22211342, }, /* 324 */
  { 0x21241214, 0x21215222, 0x12211433, }, /* 325 */
  { 0x31241222, 0x22124321, 0x22211441, }, /* 326 */
  { 0x21241313, 0x11215313, 0x12211532, }, /* 327 */
  { 0x31241321, 0x12124412, 0x12211631, }, /* 328 */
  { 0x21241412, 0x11215412, 0x13121144, }, /* 329 */
  { 0x21241511, 0x12124511, 0x23121152, }, /* 330 */
  { 0x12151115, 0x12125123, 0x12212144, }, /* 331 */
  { 0x22151123, 0x22125131, 0x13121243, }, /* 332 */
  { 0x32151131, 0x11216123, 0x23121251, }, /* 333 */
  { 0x11242115, 0x12125222, 0x12212243, }, /* 334 */
  { 0x12151214, 0x11216222, 0x22212251, }, /* 335 */
  { 0x22151222, 0x12125321, 0x12212342, }, /* 336 */
  { 0x11242214, 0x11216321, 0x13121441, }, /* 337 */
  { 0x21242222, 0x12126131, 0x12212441, }, /* 338 */
  { 0x22151321, 0x51221114, 0x63122111, }, /* 339 */
  { 0x11242313, 0x61221122, 0x13122152, }, /* 340 */
  { 0x12151412, 0x11221163, 0x62213111, }, /* 341 */
  { 0x11242412, 0x51221213, 0x12213152, }, /* 342 */
  { 0x12151511, 0x61221221, 0x13122251, }, /* 343 */
  { 0x12152123, 0x11221262, 0x12213251, }, /* 344 */
  { 0x11243123, 0x51221312, 0x53123111, }, /* 345 */
  { 0x11243222, 0x11221361, 0x52214111, }, /* 346 */
  { 0x11243321, 0x51221411, 0x43124111, }, /* 347 */
  { 0x31251122, 0x42131114, 0x42215111, }, /* 348 */
  { 0x31251221, 0x52131122, 0x33125111, }, /* 349 */
  { 0x21251411, 0x41222114, 0x32216111, }, /* 350 */
  { 0x22161122, 0x42131213, 0x23126111, }, /* 351 */
  { 0x12161213, 0x52131221, 0x21311135, }, /* 352 */
  { 0x11252213, 0x41222213, 0x31311143, }, /* 353 */
  { 0x11252312, 0x51222221, 0x41311151, }, /* 354 */
  { 0x11252411, 0x41222312, 0x11311226, }, /* 355 */
  { 0x23111126, 0x42131411, 0x21311234, }, /* 356 */
  { 0x33111134, 0x41222411, 0x31311242, }, /* 357 */
  { 0x43111142, 0x32132114, 0x11311325, }, /* 358 */
  { 0x23111225, 0x42132122, 0x21311333, }, /* 359 */
  { 0x33111233, 0x31223114, 0x31311341, }, /* 360 */
  { 0x13111316, 0x32132213, 0x11311424, }, /* 361 */
  { 0x23111324, 0x42132221, 0x21311432, }, /* 362 */
  { 0x33111332, 0x31223213, 0x11311523, }, /* 363 */
  { 0x13111415, 0x41223221, 0x21311531, }, /* 364 */
  { 0x23111423, 0x31223312, 0x11311622, }, /* 365 */
  { 0x13111514, 0x32132411, 0x12221135, }, /* 366 */
  { 0x13111613, 0x31223411, 0x22221143, }, /* 367 */
  { 0x13112126, 0x22133114, 0x32221151, }, /* 368 */
  { 0x23112134, 0x32133122, 0x11312135, }, /* 369 */
  { 0x33112142, 0x21224114, 0x12221234, }, /* 370 */
  { 0x13112225, 0x22133213, 0x22221242, }, /* 371 */
  { 0x23112233, 0x32133221, 0x11312234, }, /* 372 */
  { 0x33112241, 0x21224213, 0x21312242, }, /* 373 */
  { 0x13112324, 0x31224221, 0x22221341, }, /* 374 */
  { 0x23112332, 0x21224312, 0x11312333, }, /* 375 */
  { 0x13112423, 0x22133411, 0x12221432, }, /* 376 */
  { 0x13112522, 0x21224411, 0x11312432, }, /* 377 */
  { 0x13113134, 0x12134114, 0x12221531, }, /* 378 */
  { 0x23113142, 0x22134122, 0x11312531, }, /* 379 */
  { 0x13113233, 0x11225114, 0x13131143, }, /* 380 */
  { 0x23113241, 0x12134213, 0x23131151, }, /* 381 */
  { 0x13113332, 0x22134221, 0x12222143, }, /* 382 */
  { 0x13114142, 0x11225213, 0x13131242, }, /* 383 */
  { 0x13114241, 0x21225221, 0x11313143, }, /* 384 */
  { 0x32211125, 0x11225312, 0x12222242, }, /* 385 */
  { 0x42211133, 0x12134411, 0x13131341, }, /* 386 */
  { 0x52211141, 0x11225411, 0x11313242, }, /* 387 */
  { 0x22211216, 0x12135122, 0x12222341, }, /* 388 */
  { 0x32211224, 0x11226122, 0x11313341, }, /* 389 */
  { 0x42211232, 0x12135221, 0x13132151, }, /* 390 */
  { 0x22211315, 0x11226221, 0x12223151, }, /* 391 */
  { 0x32211323, 0x51231113, 0x11314151, }, /* 392 */
  { 0x42211331, 0x61231121, 0x11321126, }, /* 393 */
  { 0x22211414, 0x11231162, 0x21321134, }, /* 394 */
  { 0x32211422, 0x51231212, 0x31321142, }, /* 395 */
  { 0x22211513, 0x11231261, 0x11321225, }, /* 396 */
  { 0x32211521, 0x51231311, 0x21321233, }, /* 397 */
  { 0x23121125, 0x42141113, 0x31321241, }, /* 398 */
  { 0x33121133, 0x52141121, 0x11321324, }, /* 399 */
  { 0x43121141, 0x41232113, 0x21321332, }, /* 400 */
  { 0x22212125, 0x51232121, 0x11321423, }, /* 401 */
  { 0x23121224, 0x41232212, 0x21321431, }, /* 402 */
  { 0x33121232, 0x42141311, 0x11321522, }, /* 403 */
  { 0x12212216, 0x41232311, 0x11321621, }, /* 404 */
  { 0x13121315, 0x32142113, 0x12231134, }, /* 405 */
  { 0x32212232, 0x42142121, 0x22231142, }, /* 406 */
  { 0x33121331, 0x31233113, 0x11322134, }, /* 407 */
  { 0x12212315, 0x32142212, 0x12231233, }, /* 408 */
  { 0x22212323, 0x31233212, 0x22231241, }, /* 409 */
  { 0x23121422, 0x32142311, 0x11322233, }, /* 410 */
  { 0x12212414, 0x31233311, 0x21322241, }, /* 411 */
  { 0x13121513, 0x22143113, 0x11322332, }, /* 412 */
  { 0x12212513, 0x32143121, 0x12231431, }, /* 413 */
  { 0x13122125, 0x21234113, 0x11322431, }, /* 414 */
  { 0x23122133, 0x31234121, 0x13141142, }, /* 415 */
  { 0x33122141, 0x21234212, 0x12232142, }, /* 416 */
  { 0x12213125, 0x22143311, 0x13141241, }, /* 417 */
  { 0x13122224, 0x21234311, 0x11323142, }, /* 418 */
  { 0x32213141, 0x12144113, 0x12232241, }, /* 419 */
  { 0x12213224, 0x22144121, 0x11323241, }, /* 420 */
  { 0x22213232, 0x11235113, 0x11331125, }, /* 421 */
  { 0x23122331, 0x12144212, 0x21331133, }, /* 422 */
  { 0x12213323, 0x11235212, 0x31331141, }, /* 423 */
  { 0x13122422, 0x12144311, 0x11331224, }, /* 424 */
  { 0x12213422, 0x11235311, 0x21331232, }, /* 425 */
  { 0x13123133, 0x12145121, 0x11331323, }, /* 426 */
  { 0x23123141, 0x11236121, 0x21331331, }, /* 427 */
  { 0x12214133, 0x51241112, 0x11331422, }, /* 428 */
  { 0x13123232, 0x11241161, 0x11331521, }, /* 429 */
  { 0x12214232, 0x51241211, 0x12241133, }, /* 430 */
  { 0x13123331, 0x42151112, 0x22241141, }, /* 431 */
  { 0x13124141, 0x41242112, 0x11332133, }, /* 432 */
  { 0x12215141, 0x42151211, 0x12241232, }, /* 433 */
  { 0x31311116, 0x41242211, 0x11332232, }, /* 434 */
  { 0x41311124, 0x32152112, 0x12241331, }, /* 435 */
  { 0x51311132, 0x31243112, 0x11332331, }, /* 436 */
  { 0x31311215, 0x32152211, 0x13151141, }, /* 437 */
  { 0x41311223, 0x31243211, 0x12242141, }, /* 438 */
  { 0x51311231, 0x22153112, 0x11333141, }, /* 439 */
  { 0x31311314, 0x21244112, 0x11341124, }, /* 440 */
  { 0x41311322, 0x22153211, 0x21341132, }, /* 441 */
  { 0x31311413, 0x21244211, 0x11341223, }, /* 442 */
  { 0x41311421, 0x12154112, 0x21341231, }, /* 443 */
  { 0x31311512, 0x11245112, 0x11341322, }, /* 444 */
  { 0x22221116, 0x12154211, 0x11341421, }, /* 445 */
  { 0x32221124, 0x11245211, 0x12251132, }, /* 446 */
  { 0x42221132, 0x51251111, 0x11342132, }, /* 447 */
  { 0x21312116, 0x42161111, 0x12251231, }, /* 448 */
  { 0x22221215, 0x41252111, 0x11342231, }, /* 449 */
  { 0x41312132, 0x32162111, 0x11351123, }, /* 450 */
  { 0x42221231, 0x31253111, 0x21351131, }, /* 451 */
  { 0x21312215, 0x22163111, 0x11351222, }, /* 452 */
  { 0x31312223, 0x21254111, 0x11351321, }, /* 453 */
  { 0x41312231, 0x43111115, 0x12261131, }, /* 454 */
  { 0x21312314, 0x53111123, 0x11352131, }, /* 455 */
  { 0x22221413, 0x63111131, 0x11361122, }, /* 456 */
  { 0x32221421, 0x43111214, 0x11361221, }, /* 457 */
  { 0x21312413, 0x53111222, 0x14111144, }, /* 458 */
  { 0x31312421, 0x43111313, 0x24111152, }, /* 459 */
  { 0x22221611, 0x53111321, 0x14111243, }, /* 460 */
  { 0x13131116, 0x43111412, 0x24111251, }, /* 461 */
  { 0x23131124, 0x43111511, 0x14111342, }, /* 462 */
  { 0x33131132, 0x33112115, 0x14111441, }, /* 463 */
  { 0x12222116, 0x43112123, 0x14112152, }, /* 464 */
  { 0x13131215, 0x53112131, 0x14112251, }, /* 465 */
  { 0x23131223, 0x33112214, 0x54113111, }, /* 466 */
  { 0x33131231, 0x43112222, 0x44114111, }, /* 467 */
  { 0x11313116, 0x33112313, 0x34115111, }, /* 468 */
  { 0x12222215, 0x43112321, 0x24116111, }, /* 469 */
  { 0x22222223, 0x33112412, 0x13211135, }, /* 470 */
  { 0x32222231, 0x33112511, 0x23211143, }, /* 471 */
  { 0x11313215, 0x23113115, 0x33211151, }, /* 472 */
  { 0x21313223, 0x33113123, 0x13211234, }, /* 473 */
  { 0x31313231, 0x43113131, 0x23211242, }, /* 474 */
  { 0x23131421, 0x23113214, 0x13211333, }, /* 475 */
  { 0x11313314, 0x33113222, 0x23211341, }, /* 476 */
  { 0x12222413, 0x23113313, 0x13211432, }, /* 477 */
  { 0x22222421, 0x33113321, 0x13211531, }, /* 478 */
  { 0x11313413, 0x23113412, 0x14121143, }, /* 479 */
  { 0x13131611, 0x23113511, 0x24121151, }, /* 480 */
  { 0x13132124, 0x13114115, 0x13212143, }, /* 481 */
  { 0x23132132, 0x23114123, 0x14121242, }, /* 482 */
  { 0x12223124, 0x33114131, 0x13212242, }, /* 483 */
  { 0x13132223, 0x13114214, 0x14121341, }, /* 484 */
  { 0x23132231, 0x23114222, 0x13212341, }, /* 485 */
  { 0x11314124, 0x13114313, 0x14122151, }, /* 486 */
  { 0x12223223, 0x23114321, 0x13213151, }, /* 487 */
  { 0x22223231, 0x13114412, 0x12311126, }, /* 488 */
  { 0x11314223, 0x13114511, 0x22311134, }, /* 489 */
  { 0x21314231, 0x13115123, 0x32311142, }, /* 490 */
  { 0x13132421, 0x23115131, 0x12311225, }, /* 491 */
  { 0x12223421, 0x13115222, 0x22311233, }, /* 492 */
  { 0x13133132, 0x13115321, 0x32311241, }, /* 493 */
  { 0x12224132, 0x13116131, 0x12311324, }, /* 494 */
  { 0x13133231, 0x52211114, 0x22311332, }, /* 495 */
  { 0x11315132, 0x62211122, 0x12311423, }, /* 496 */
  { 0x12224231, 0x12211163, 0x22311431, }, /* 497 */
  { 0x31321115, 0x52211213, 0x12311522, }, /* 498 */
  { 0x41321123, 0x62211221, 0x12311621, }, /* 499 */
  { 0x51321131, 0x12211262, 0x13221134, }, /* 500 */
  { 0x31321214, 0x52211312, 0x23221142, }, /* 501 */
  { 0x41321222, 0x12211361, 0x12312134, }, /* 502 */
  { 0x31321313, 0x52211411, 0x13221233, }, /* 503 */
  { 0x41321321, 0x43121114, 0x23221241, }, /* 504 */
  { 0x31321412, 0x53121122, 0x12312233, }, /* 505 */
  { 0x31321511, 0x42212114, 0x13221332, }, /* 506 */
  { 0x22231115, 0x43121213, 0x12312332, }, /* 507 */
  { 0x32231123, 0x53121221, 0x13221431, }, /* 508 */
  { 0x42231131, 0x42212213, 0x12312431, }, /* 509 */
  { 0x21322115, 0x52212221, 0x14131142, }, /* 510 */
  { 0x22231214, 0x42212312, 0x13222142, }, /* 511 */
  { 0x41322131, 0x43121411, 0x14131241, }, /* 512 */
  { 0x21322214, 0x42212411, 0x12313142, }, /* 513 */
  { 0x31322222, 0x33122114, 0x13222241, }, /* 514 */
  { 0x32231321, 0x43122122, 0x12313241, }, /* 515 */
  { 0x21322313, 0x32213114, 0x21411125, }, /* 516 */
  { 0x22231412, 0x33122213, 0x31411133, }, /* 517 */
  { 0x21322412, 0x43122221, 0x41411141, }, /* 518 */
  { 0x22231511, 0x32213213, 0x11411216, }, /* 519 */
  { 0x21322511, 0x42213221, 0x21411224, }, /* 520 */
  { 0x13141115, 0x32213312, 0x31411232, }, /* 521 */
  { 0x23141123, 0x33122411, 0x11411315, }, /* 522 */
  { 0x33141131, 0x32213411, 0x21411323, }, /* 523 */
  { 0x12232115, 0x23123114, 0x31411331, }, /* 524 */
  { 0x13141214, 0x33123122, 0x11411414, }, /* 525 */
  { 0x23141222, 0x22214114, 0x21411422, }, /* 526 */
  { 0x11323115, 0x23123213, 0x11411513, }, /* 527 */
  { 0x12232214, 0x33123221, 0x21411521, }, /* 528 */
  { 0x22232222, 0x22214213, 0x11411612, }, /* 529 */
  { 0x23141321, 0x32214221, 0x12321125, }, /* 530 */
  { 0x11323214, 0x22214312, 0x22321133, }, /* 531 */
  { 0x21323222, 0x23123411, 0x32321141, }, /* 532 */
  { 0x13141412, 0x22214411, 0x11412125, }, /* 533 */
  { 0x11323313, 0x13124114, 0x12321224, }, /* 534 */
  { 0x12232412, 0x23124122, 0x22321232, }, /* 535 */
  { 0x13141511, 0x12215114, 0x11412224, }, /* 536 */
  { 0x12232511, 0x13124213, 0x21412232, }, /* 537 */
  { 0x13142123, 0x23124221, 0x22321331, }, /* 538 */
  { 0x23142131, 0x12215213, 0x11412323, }, /* 539 */
  { 0x12233123, 0x22215221, 0x12321422, }, /* 540 */
  { 0x13142222, 0x12215312, 0x11412422, }, /* 541 */
  { 0x11324123, 0x13124411, 0x12321521, }, /* 542 */
  { 0x12233222, 0x12215411, 0x11412521, }, /* 543 */
  { 0x13142321, 0x13125122, 0x13231133, }, /* 544 */
  { 0x11324222, 0x12216122, 0x23231141, }, /* 545 */
  { 0x12233321, 0x13125221, 0x12322133, }, /* 546 */
  { 0x13143131, 0x12216221, 0x13231232, }, /* 547 */
  { 0x11325131, 0x61311113, 0x11413133, }, /* 548 */
  { 0x31331114, 0x11311154, 0x12322232, }, /* 549 */
  { 0x41331122, 0x21311162, 0x13231331, }, /* 550 */
  { 0x31331213, 0x61311212, 0x11413232, }, /* 551 */
  { 0x41331221, 0x11311253, 0x12322331, }, /* 552 */
  { 0x31331312, 0x21311261, 0x11413331, }, /* 553 */
  { 0x31331411, 0x61311311, 0x14141141, }, /* 554 */
  { 0x22241114, 0x11311352, 0x13232141, }, /* 555 */
  { 0x32241122, 0x11311451, 0x12323141, }, /* 556 */
  { 0x21332114, 0x52221113, 0x11414141, }, /* 557 */
  { 0x22241213, 0x62221121, 0x11421116, }, /* 558 */
  { 0x32241221, 0x12221162, 0x21421124, }, /* 559 */
  { 0x21332213, 0x51312113, 0x31421132, }, /* 560 */
  { 0x31332221, 0x61312121, 0x11421215, }, /* 561 */
  { 0x21332312, 0x11312162, 0x21421223, }, /* 562 */
  { 0x22241411, 0x12221261, 0x31421231, }, /* 563 */
  { 0x21332411, 0x51312212, 0x11421314, }, /* 564 */
  { 0x13151114, 0x52221311, 0x21421322, }, /* 565 */
  { 0x23151122, 0x11312261, 0x11421413, }, /* 566 */
  { 0x12242114, 0x51312311, 0x21421421, }, /* 567 */
  { 0x13151213, 0x43131113, 0x11421512, }, /* 568 */
  { 0x23151221, 0x53131121, 0x11421611, }, /* 569 */
  { 0x11333114, 0x42222113, 0x12331124, }, /* 570 */
  { 0x12242213, 0x43131212, 0x22331132, }, /* 571 */
  { 0x22242221, 0x41313113, 0x11422124, }, /* 572 */
  { 0x11333213, 0x51313121, 0x12331223, }, /* 573 */
  { 0x21333221, 0x43131311, 0x22331231, }, /* 574 */
  { 0x13151411, 0x41313212, 0x11422223, }, /* 575 */
  { 0x11333312, 0x42222311, 0x21422231, }, /* 576 */
  { 0x12242411, 0x41313311, 0x11422322, }, /* 577 */
  { 0x11333411, 0x33132113, 0x12331421, }, /* 578 */
  { 0x12243122, 0x43132121, 0x11422421, }, /* 579 */
  { 0x11334122, 0x32223113, 0x13241132, }, /* 580 */
  { 0x11334221, 0x33132212, 0x12332132, }, /* 581 */
  { 0x41341121, 0x31314113, 0x13241231, }, /* 582 */
  { 0x31341311, 0x32223212, 0x11423132, }, /* 583 */
  { 0x32251121, 0x33132311, 0x12332231, }, /* 584 */
  { 0x22251212, 0x31314212, 0x11423231, }, /* 585 */
  { 0x22251311, 0x32223311, 0x11431115, }, /* 586 */
  { 0x13161113, 0x31314311, 0x21431123, }, /* 587 */
  { 0x12252113, 0x23133113, 0x31431131, }, /* 588 */
  { 0x11343113, 0x33133121, 0x11431214, }, /* 589 */
  { 0x13161311, 0x22224113, 0x21431222, }, /* 590 */
  { 0x12252311, 0x23133212, 0x11431313, }, /* 591 */
  { 0x24111125, 0x21315113, 0x21431321, }, /* 592 */
  { 0x14111216, 0x22224212, 0x11431412, }, /* 593 */
  { 0x24111224, 0x23133311, 0x11431511, }, /* 594 */
  { 0x14111315, 0x21315212, 0x12341123, }, /* 595 */
  { 0x24111323, 0x22224311, 0x22341131, }, /* 596 */
  { 0x34111331, 0x21315311, 0x11432123, }, /* 597 */
  { 0x14111414, 0x13134113, 0x12341222, }, /* 598 */
  { 0x24111422, 0x23134121, 0x11432222, }, /* 599 */
  { 0x14111513, 0x12225113, 0x12341321, }, /* 600 */
  { 0x24111521, 0x13134212, 0x11432321, }, /* 601 */
  { 0x14112125, 0x11316113, 0x13251131, }, /* 602 */
  { 0x24112133, 0x12225212, 0x12342131, }, /* 603 */
  { 0x34112141, 0x13134311, 0x11433131, }, /* 604 */
  { 0x14112224, 0x11316212, 0x11441114, }, /* 605 */
  { 0x24112232, 0x12225311, 0x21441122, }, /* 606 */
  { 0x14112323, 0x11316311, 0x11441213, }, /* 607 */
  { 0x24112331, 0x13135121, 0x21441221, }, /* 608 */
  { 0x14112422, 0x12226121, 0x11441312, }, /* 609 */
  { 0x14112521, 0x61321112, 0x11441411, }, /* 610 */
  { 0x14113133, 0x11321153, 0x12351122, }, /* 611 */
  { 0x24113141, 0x21321161, 0x11442122, }, /* 612 */
  { 0x14113232, 0x61321211, 0x12351221, }, /* 613 */
  { 0x14113331, 0x11321252, 0x11442221, }, /* 614 */
  { 0x14114141, 0x11321351, 0x11451113, }, /* 615 */
  { 0x23211116, 0x52231112, 0x21451121, }, /* 616 */
  { 0x33211124, 0x12231161, 0x11451212, }, /* 617 */
  { 0x43211132, 0x51322112, 0x11451311, }, /* 618 */
  { 0x23211215, 0x52231211, 0x12361121, }, /* 619 */
  { 0x33211223, 0x11322161, 0x11452121, }, /* 620 */
  { 0x23211314, 0x51322211, 0x15111143, }, /* 621 */
  { 0x33211322, 0x43141112, 0x25111151, }, /* 622 */
  { 0x23211413, 0x42232112, 0x15111242, }, /* 623 */
  { 0x33211421, 0x43141211, 0x15111341, }, /* 624 */
  { 0x23211512, 0x41323112, 0x15112151, }, /* 625 */
  { 0x14121116, 0x42232211, 0x14211134, }, /* 626 */
  { 0x24121124, 0x41323211, 0x24211142, }, /* 627 */
  { 0x34121132, 0x33142112, 0x14211233, }, /* 628 */
  { 0x13212116, 0x32233112, 0x24211241, }, /* 629 */
  { 0x14121215, 0x33142211, 0x14211332, }, /* 630 */
  { 0x33212132, 0x31324112, 0x14211431, }, /* 631 */
  { 0x34121231, 0x32233211, 0x15121142, }, /* 632 */
  { 0x13212215, 0x31324211, 0x14212142, }, /* 633 */
  { 0x23212223, 0x23143112, 0x15121241, }, /* 634 */
  { 0x33212231, 0x22234112, 0x14212241, }, /* 635 */
  { 0x13212314, 0x23143211, 0x13311125, }, /* 636 */
  { 0x14121413, 0x21325112, 0x23311133, }, /* 637 */
  { 0x24121421, 0x22234211, 0x33311141, }, /* 638 */
  { 0x13212413, 0x21325211, 0x13311224, }, /* 639 */
  { 0x23212421, 0x13144112, 0x23311232, }, /* 640 */
  { 0x14121611, 0x12235112, 0x13311323, }, /* 641 */
  { 0x14122124, 0x13144211, 0x23311331, }, /* 642 */
  { 0x24122132, 0x11326112, 0x13311422, }, /* 643 */
  { 0x13213124, 0x12235211, 0x13311521, }, /* 644 */
  { 0x14122223, 0x11326211, 0x14221133, }, /* 645 */
  { 0x24122231, 0x61331111, 0x24221141, }, /* 646 */
  { 0x13213223, 0x11331152, 0x13312133, }, /* 647 */
  { 0x23213231, 0x11331251, 0x14221232, }, /* 648 */
  { 0x13213322, 0x52241111, 0x13312232, }, /* 649 */
  { 0x14122421, 0x51332111, 0x14221331, }, /* 650 */
  { 0x14123132, 0x43151111, 0x13312331, }, /* 651 */
  { 0x13214132, 0x42242111, 0x15131141, }, /* 652 */
  { 0x14123231, 0x41333111, 0x14222141, }, /* 653 */
  { 0x13214231, 0x33152111, 0x13313141, }, /* 654 */
  { 0x32311115, 0x32243111, 0x12411116, }, /* 655 */
  { 0x42311123, 0x31334111, 0x22411124, }, /* 656 */
  { 0x52311131, 0x23153111, 0x32411132, }, /* 657 */
  { 0x32311214, 0x22244111, 0x12411215, }, /* 658 */
  { 0x42311222, 0x21335111, 0x22411223, }, /* 659 */
  { 0x32311313, 0x13154111, 0x32411231, }, /* 660 */
  { 0x42311321, 0x12245111, 0x12411314, }, /* 661 */
  { 0x32311412, 0x11336111, 0x22411322, }, /* 662 */
  { 0x32311511, 0x11341151, 0x12411413, }, /* 663 */
  { 0x23221115, 0x44111114, 0x22411421, }, /* 664 */
  { 0x33221123, 0x54111122, 0x12411512, }, /* 665 */
  { 0x22312115, 0x44111213, 0x12411611, }, /* 666 */
  { 0x23221214, 0x54111221, 0x13321124, }, /* 667 */
  { 0x33221222, 0x44111312, 0x23321132, }, /* 668 */
  { 0x22312214, 0x44111411, 0x12412124, }, /* 669 */
  { 0x32312222, 0x34112114, 0x13321223, }, /* 670 */
  { 0x33221321, 0x44112122, 0x23321231, }, /* 671 */
  { 0x22312313, 0x34112213, 0x12412223, }, /* 672 */
  { 0x23221412, 0x44112221, 0x22412231, }, /* 673 */
  { 0x22312412, 0x34112312, 0x12412322, }, /* 674 */
  { 0x23221511, 0x34112411, 0x13321421, }, /* 675 */
  { 0x22312511, 0x24113114, 0x12412421, }, /* 676 */
  { 0x14131115, 0x34113122, 0x14231132, }, /* 677 */
  { 0x24131123, 0x24113213, 0x13322132, }, /* 678 */
  { 0x13222115, 0x34113221, 0x14231231, }, /* 679 */
  { 0x14131214, 0x24113312, 0x12413132, }, /* 680 */
  { 0x33222131, 0x24113411, 0x13322231, }, /* 681 */
  { 0x12313115, 0x14114114, 0x12413231, }, /* 682 */
  { 0x13222214, 0x24114122, 0x21511115, }, /* 683 */
  { 0x23222222, 0x14114213, 0x31511123, }, /* 684 */
  { 0x24131321, 0x24114221, 0x41511131, }, /* 685 */
  { 0x12313214, 0x14114312, 0x21511214, }, /* 686 */
  { 0x22313222, 0x14114411, 0x31511222, }, /* 687 */
  { 0x14131412, 0x14115122, 0x21511313, }, /* 688 */
  { 0x12313313, 0x14115221, 0x31511321, }, /* 689 */
  { 0x13222412, 0x53211113, 0x21511412, }, /* 690 */
  { 0x14131511, 0x63211121, 0x21511511, }, /* 691 */
  { 0x13222511, 0x13211162, 0x12421115, }, /* 692 */
  { 0x14132123, 0x53211212, 0x22421123, }, /* 693 */
  { 0x24132131, 0x13211261, 0x32421131, }, /* 694 */
  { 0x13223123, 0x53211311, 0x11512115, }, /* 695 */
  { 0x14132222, 0x44121113, 0x12421214, }, /* 696 */
  { 0x12314123, 0x54121121, 0x22421222, }, /* 697 */
  { 0x13223222, 0x43212113, 0x11512214, }, /* 698 */
  { 0x14132321, 0x44121212, 0x21512222, }, /* 699 */
  { 0x12314222, 0x43212212, 0x22421321, }, /* 700 */
  { 0x13223321, 0x44121311, 0x11512313, }, /* 701 */
  { 0x14133131, 0x43212311, 0x12421412, }, /* 702 */
  { 0x13224131, 0x34122113, 0x11512412, }, /* 703 */
  { 0x12315131, 0x44122121, 0x12421511, }, /* 704 */
  { 0x41411114, 0x33213113, 0x11512511, }, /* 705 */
  { 0x51411122, 0x34122212, 0x13331123, }, /* 706 */
  { 0x41411213, 0x33213212, 0x23331131, }, /* 707 */
  { 0x51411221, 0x34122311, 0x12422123, }, /* 708 */
  { 0x41411312, 0x33213311, 0x13331222, }, /* 709 */
  { 0x41411411, 0x24123113, 0x11513123, }, /* 710 */
  { 0x32321114, 0x34123121, 0x12422222, }, /* 711 */
  { 0x42321122, 0x23214113, 0x13331321, }, /* 712 */
  { 0x31412114, 0x24123212, 0x11513222, }, /* 713 */
  { 0x41412122, 0x23214212, 0x12422321, }, /* 714 */
  { 0x42321221, 0x24123311, 0x11513321, }, /* 715 */
  { 0x31412213, 0x23214311, 0x14241131, }, /* 716 */
  { 0x41412221, 0x14124113, 0x13332131, }, /* 717 */
  { 0x31412312, 0x24124121, 0x12423131, }, /* 718 */
  { 0x32321411, 0x13215113, 0x11514131, }, /* 719 */
  { 0x31412411, 0x14124212, 0x21521114, }, /* 720 */
  { 0x23231114, 0x13215212, 0x31521122, }, /* 721 */
  { 0x33231122, 0x14124311, 0x21521213, }, /* 722 */
  { 0x22322114, 0x13215311, 0x31521221, }, /* 723 */
  { 0x23231213, 0x14125121, 0x21521312, }, /* 724 */
  { 0x33231221, 0x13216121, 0x21521411, }, /* 725 */
  { 0x21413114, 0x62311112, 0x12431114, }, /* 726 */
  { 0x22322213, 0x12311153, 0x22431122, }, /* 727 */
  { 0x32322221, 0x22311161, 0x11522114, }, /* 728 */
  { 0x21413213, 0x62311211, 0x12431213, }, /* 729 */
  { 0x31413221, 0x12311252, 0x22431221, }, /* 730 */
  { 0x23231411, 0x12311351, 0x11522213, }, /* 731 */
  { 0x21413312, 0x53221112, 0x21522221, }, /* 732 */
  { 0x22322411, 0x13221161, 0x11522312, }, /* 733 */
  { 0x21413411, 0x52312112, 0x12431411, }, /* 734 */
  { 0x14141114, 0x53221211, 0x11522411, }, /* 735 */
  { 0x24141122, 0x12312161, 0x13341122, }, /* 736 */
  { 0x13232114, 0x52312211, 0x12432122, }, /* 737 */
  { 0x14141213, 0x44131112, 0x13341221, }, /* 738 */
  { 0x24141221, 0x43222112, 0x11523122, }, /* 739 */
  { 0x12323114, 0x44131211, 0x12432221, }, /* 740 */
  { 0x13232213, 0x42313112, 0x11523221, }, /* 741 */
  { 0x23232221, 0x43222211, 0x21531113, }, /* 742 */
  { 0x11414114, 0x42313211, 0x31531121, }, /* 743 */
  { 0x12323213, 0x34132112, 0x21531212, }, /* 744 */
  { 0x22323221, 0x33223112, 0x21531311, }, /* 745 */
  { 0x14141411, 0x34132211, 0x12441113, }, /* 746 */
  { 0x11414213, 0x32314112, 0x22441121, }, /* 747 */
  { 0x21414221, 0x33223211, 0x11532113, }, /* 748 */
  { 0x13232411, 0x32314211, 0x12441212, }, /* 749 */
  { 0x11414312, 0x24133112, 0x11532212, }, /* 750 */
  { 0x14142122, 0x23224112, 0x12441311, }, /* 751 */
  { 0x13233122, 0x24133211, 0x11532311, }, /* 752 */
  { 0x14142221, 0x22315112, 0x13351121, }, /* 753 */
  { 0x12324122, 0x23224211, 0x12442121, }, /* 754 */
  { 0x13233221, 0x22315211, 0x11533121, }, /* 755 */
  { 0x11415122, 0x14134112, 0x21541112, }, /* 756 */
  { 0x12324221, 0x13225112, 0x21541211, }, /* 757 */
  { 0x11415221, 0x14134211, 0x12451112, }, /* 758 */
  { 0x41421113, 0x12316112, 0x11542112, }, /* 759 */
  { 0x51421121, 0x13225211, 0x12451211, }, /* 760 */
  { 0x41421212, 0x12316211, 0x11542211, }, /* 761 */
  { 0x41421311, 0x11411144, 0x16111142, }, /* 762 */
  { 0x32331113, 0x21411152, 0x16111241, }, /* 763 */
  { 0x42331121, 0x11411243, 0x15211133, }, /* 764 */
  { 0x31422113, 0x21411251, 0x25211141, }, /* 765 */
  { 0x41422121, 0x11411342, 0x15211232, }, /* 766 */
  { 0x31422212, 0x11411441, 0x15211331, }, /* 767 */
  { 0x32331311, 0x62321111, 0x16121141, }, /* 768 */
  { 0x31422311, 0x12321152, 0x15212141, }, /* 769 */
  { 0x23241113, 0x61412111, 0x14311124, }, /* 770 */
  { 0x33241121, 0x11412152, 0x24311132, }, /* 771 */
  { 0x22332113, 0x12321251, 0x14311223, }, /* 772 */
  { 0x23241212, 0x11412251, 0x24311231, }, /* 773 */
  { 0x21423113, 0x53231111, 0x14311322, }, /* 774 */
  { 0x22332212, 0x52322111, 0x14311421, }, /* 775 */
  { 0x23241311, 0x51413111, 0x15221132, }, /* 776 */
  { 0x21423212, 0x44141111, 0x14312132, }, /* 777 */
  { 0x22332311, 0x43232111, 0x15221231, }, /* 778 */
  { 0x21423311, 0x42323111, 0x14312231, }, /* 779 */
  { 0x14151113, 0x41414111, 0x13411115, }, /* 780 */
  { 0x24151121, 0x34142111, 0x23411123, }, /* 781 */
  { 0x13242113, 0x33233111, 0x33411131, }, /* 782 */
  { 0x23242121, 0x32324111, 0x13411214, }, /* 783 */
  { 0x12333113, 0x31415111, 0x23411222, }, /* 784 */
  { 0x13242212, 0x24143111, 0x13411313, }, /* 785 */
  { 0x14151311, 0x23234111, 0x23411321, }, /* 786 */
  { 0x11424113, 0x22325111, 0x13411412, }, /* 787 */
  { 0x12333212, 0x21416111, 0x13411511, }, /* 788 */
  { 0x13242311, 0x14144111, 0x14321123, }, /* 789 */
  { 0x11424212, 0x13235111, 0x24321131, }, /* 790 */
  { 0x12333311, 0x12326111, 0x13412123, }, /* 791 */
  { 0x11424311, 0x11421143, 0x23412131, }, /* 792 */
  { 0x13243121, 0x21421151, 0x13412222, }, /* 793 */
  { 0x11425121, 0x11421242, 0x14321321, }, /* 794 */
  { 0x41431211, 0x11421341, 0x13412321, }, /* 795 */
  { 0x31432112, 0x12331151, 0x15231131, }, /* 796 */
  { 0x31432211, 0x11422151, 0x14322131, }, /* 797 */
  { 0x22342112, 0x11431142, 0x13413131, }, /* 798 */
  { 0x21433112, 0x11431241, 0x22511114, }, /* 799 */
  { 0x21433211, 0x11441141, 0x32511122, }, /* 800 */
  { 0x13252112, 0x45111113, 0x22511213, }, /* 801 */
  { 0x12343112, 0x45111212, 0x32511221, }, /* 802 */
  { 0x11434112, 0x45111311, 0x22511312, }, /* 803 */
  { 0x11434211, 0x35112113, 0x22511411, }, /* 804 */
  { 0x15111116, 0x45112121, 0x13421114, }, /* 805 */
  { 0x15111215, 0x35112212, 0x23421122, }, /* 806 */
  { 0x25111223, 0x35112311, 0x12512114, }, /* 807 */
  { 0x15111314, 0x25113113, 0x22512122, }, /* 808 */
  { 0x15111413, 0x35113121, 0x23421221, }, /* 809 */
  { 0x15111512, 0x25113212, 0x12512213, }, /* 810 */
  { 0x15112124, 0x25113311, 0x13421312, }, /* 811 */
  { 0x15112223, 0x15114113, 0x12512312, }, /* 812 */
  { 0x15112322, 0x25114121, 0x13421411, }, /* 813 */
  { 0x15112421, 0x15114212, 0x12512411, }, /* 814 */
  { 0x15113132, 0x15114311, 0x14331122, }, /* 815 */
  { 0x15113231, 0x15115121, 0x13422122, }, /* 816 */
  { 0x24211115, 0x54211112, 0x14331221, }, /* 817 */
  { 0x24211214, 0x14211161, 0x12513122, }, /* 818 */
  { 0x34211222, 0x54211211, 0x13422221, }, /* 819 */
  { 0x24211313, 0x45121112, 0x12513221, }, /* 820 */
  { 0x34211321, 0x44212112, 0x31611113, }, /* 821 */
  { 0x24211412, 0x45121211, 0x41611121, }, /* 822 */
  { 0x24211511, 0x44212211, 0x31611212, }, /* 823 */
  { 0x15121115, 0x35122112, 0x31611311, }, /* 824 */
  { 0x25121123, 0x34213112, 0x22521113, }, /* 825 */
  { 0x14212115, 0x35122211, 0x32521121, }, /* 826 */
  { 0x24212123, 0x34213211, 0x21612113, }, /* 827 */
  { 0x25121222, 0x25123112, 0x22521212, }, /* 828 */
  { 0x14212214, 0x24214112, 0x21612212, }, /* 829 */
  { 0x24212222, 0x25123211, 0x22521311, }, /* 830 */
  { 0x14212313, 0x24214211, 0x21612311, }, /* 831 */
  { 0x24212321, 0x15124112, 0x13431113, }, /* 832 */
  { 0x14212412, 0x14215112, 0x23431121, }, /* 833 */
  { 0x15121511, 0x15124211, 0x12522113, }, /* 834 */
  { 0x14212511, 0x14215211, 0x13431212, }, /* 835 */
  { 0x15122123, 0x63311111, 0x11613113, }, /* 836 */
  { 0x25122131, 0x13311152, 0x12522212, }, /* 837 */
  { 0x14213123, 0x13311251, 0x13431311, }, /* 838 */
  { 0x24213131, 0x54221111, 0x11613212, }, /* 839 */
  { 0x14213222, 0x53312111, 0x12522311, }, /* 840 */
  { 0x15122321, 0x45131111, 0x11613311, }, /* 841 */
  { 0x14213321, 0x44222111, 0x14341121, }, /* 842 */
  { 0x15123131, 0x43313111, 0x13432121, }, /* 843 */
  { 0x14214131, 0x35132111, 0x12523121, }, /* 844 */
  { 0x33311114, 0x34223111, 0x11614121, }, /* 845 */
  { 0x33311213, 0x33314111, 0x31621112, }, /* 846 */
  { 0x33311312, 0x25133111, 0x31621211, }, /* 847 */
  { 0x33311411, 0x24224111, 0x22531112, }, /* 848 */
  { 0x24221114, 0x23315111, 0x21622112, }, /* 849 */
  { 0x23312114, 0x15134111, 0x22531211, }, /* 850 */
  { 0x33312122, 0x14225111, 0x21622211, }, /* 851 */
  { 0x34221221, 0x13316111, 0x13441112, }, /* 852 */
  { 0x23312213, 0x12411143, 0x12532112, }, /* 853 */
  { 0x33312221, 0x22411151, 0x13441211, }, /* 854 */
  { 0x23312312, 0x12411242, 0x11623112, }, /* 855 */
  { 0x24221411, 0x12411341, 0x12532211, }, /* 856 */
  { 0x23312411, 0x13321151, 0x11623211, }, /* 857 */
  { 0x15131114, 0x12412151, 0x31631111, }, /* 858 */
  { 0x14222114, 0x11511134, 0x22541111, }, /* 859 */
  { 0x15131213, 0x21511142, 0x21632111, }, /* 860 */
  { 0x25131221, 0x11511233, 0x13451111, }, /* 861 */
  { 0x13313114, 0x21511241, 0x12542111, }, /* 862 */
  { 0x14222213, 0x11511332, 0x11633111, }, /* 863 */
  { 0x15131312, 0x11511431, 0x16211132, }, /* 864 */
  { 0x13313213, 0x12421142, 0x16211231, }, /* 865 */
  { 0x14222312, 0x11512142, 0x15311123, }, /* 866 */
  { 0x15131411, 0x12421241, 0x25311131, }, /* 867 */
  { 0x13313312, 0x11512241, 0x15311222, }, /* 868 */
  { 0x14222411, 0x11521133, 0x15311321, }, /* 869 */
  { 0x15132122, 0x21521141, 0x16221131, }, /* 870 */
  { 0x14223122, 0x11521232, 0x15312131, }, /* 871 */
  { 0x15132221, 0x11521331, 0x14411114, }, /* 872 */
  { 0x13314122, 0x12431141, 0x24411122, }, /* 873 */
  { 0x14223221, 0x11522141, 0x14411213, }, /* 874 */
  { 0x13314221, 0x11531132, 0x24411221, }, /* 875 */
  { 0x42411113, 0x11531231, 0x14411312, }, /* 876 */
  { 0x42411212, 0x11541131, 0x14411411, }, /* 877 */
  { 0x42411311, 0x36112112, 0x15321122, }, /* 878 */
  { 0x33321113, 0x36112211, 0x14412122, }, /* 879 */
  { 0x32412113, 0x26113112, 0x15321221, }, /* 880 */
  { 0x42412121, 0x26113211, 0x14412221, }, /* 881 */
  { 0x32412212, 0x16114112, 0x23511113, }, /* 882 */
  { 0x33321311, 0x16114211, 0x33511121, }, /* 883 */
  { 0x32412311, 0x45212111, 0x23511212, }, /* 884 */
  { 0x24231113, 0x36122111, 0x23511311, }, /* 885 */
  { 0x34231121, 0x35213111, 0x14421113, }, /* 886 */
  { 0x23322113, 0x26123111, 0x24421121, }, /* 887 */
  { 0x33322121, 0x25214111, 0x13512113, }, /* 888 */
  { 0x22413113, 0x16124111, 0x23512121, }, /* 889 */
  { 0x23322212, 0x15215111, 0x13512212, }, /* 890 */
  { 0x24231311, 0x14311151, 0x14421311, }, /* 891 */
  { 0x22413212, 0x13411142, 0x13512311, }, /* 892 */
  { 0x23322311, 0x13411241, 0x15331121, }, /* 893 */
  { 0x22413311, 0x12511133, 0x14422121, }, /* 894 */
  { 0x15141113, 0x22511141, 0x13513121, }, /* 895 */
  { 0x25141121, 0x12511232, 0x32611112, }, /* 896 */
  { 0x14232113, 0x12511331, 0x32611211, }, /* 897 */
  { 0x24232121, 0x13421141, 0x23521112, }, /* 898 */
  { 0x13323113, 0x12512141, 0x22612112, }, /* 899 */
  { 0x14232212, 0x11611124, 0x23521211, }, /* 900 */
  { 0x15141311, 0x21611132, 0x22612211, }, /* 901 */
  { 0x12414113, 0x11611223, 0x14431112, }, /* 902 */
  { 0x13323212, 0x21611231, 0x13522112, }, /* 903 */
  { 0x14232311, 0x11611322, 0x14431211, }, /* 904 */
  { 0x12414212, 0x11611421, 0x12613112, }, /* 905 */
  { 0x13323311, 0x12521132, 0x13522211, }, /* 906 */
  { 0x15142121, 0x11612132, 0x12613211, }, /* 907 */
  { 0x14233121, 0x12521231, 0x32621111, }, /* 908 */
  { 0x13324121, 0x11612231, 0x23531111, }, /* 909 */
  { 0x12415121, 0x11621123, 0x22622111, }, /* 910 */
  { 0x51511112, 0x21621131, 0x14441111, }, /* 911 */
  { 0x51511211, 0x11621222, 0x13532111, }, /* 912 */
  { 0x42421112, 0x11621321, 0x12623111, }, /* 913 */
  { 0x41512112, 0x12531131, 0x16311122, }, /* 914 */
  { 0x42421211, 0x11622131, 0x16311221, }, /* 915 */
  { 0x41512211, 0x11631122, 0x15411113, }, /* 916 */
  { 0x33331112, 0x11631221, 0x25411121, }, /* 917 */
  { 0x32422112, 0x14411141, 0x15411212, }, /* 918 */
  { 0x33331211, 0x13511132, 0x15411311, }, /* 919 */
  { 0x31513112, 0x13511231, 0x16321121, }, /* 920 */
  { 0x32422211, 0x12611123, 0x15412121, }, /* 921 */
  { 0x31513211, 0x22611131, 0x24511112, }, /* 922 */
  { 0x24241112, 0x12611222, 0x24511211, }, /* 923 */
  { 0x23332112, 0x12611321, 0x15421112, }, /* 924 */
  { 0x24241211, 0x13521131, 0x14512112, }, /* 925 */
  { 0x22423112, 0x12612131, 0x15421211, }, /* 926 */
  { 0x23332211, 0x12621122, 0x14512211, }, /* 927 */
  { 0x21514112, 0x12621221, 0x33611111, }, /* 928 */
};

#endif
