/* Generated by JTB 1.4.10 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.syntaxtree.*;
import java.util.*;

/**
 * Provides default methods which visit each node in the tree in depth-first order.<br>
 * In your "VoidArgu" visitors extend this class and override part or all of these methods.
 *
 * @param <A> - The user argument type
 */
public class DepthFirstVoidArguVisitor<A> implements IVoidArguVisitor<A> {


  /*
   * Base nodes classes visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link NodeChoice} node.
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NodeChoice n, final A argu) {
    n.choice.accept(this, argu);
    return;
  }

  /**
   * Visits a {@link NodeList} node.
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NodeList n, final A argu) {
    for (final Iterator<INode> e = n.elements(); e.hasNext();) {
      e.next().accept(this, argu);
    }
    return;
  }

  /**
   * Visits a {@link NodeListOptional} node.
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NodeListOptional n, final A argu) {
    if (n.present()) {
      for (final Iterator<INode> e = n.elements(); e.hasNext();) {
        e.next().accept(this, argu);
        }
      return;
    } else
      return;
  }

  /**
   * Visits a {@link NodeOptional} node.
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NodeOptional n, final A argu) {
    if (n.present()) {
      n.node.accept(this, argu);
      return;
    } else
      return;
  }

  /**
   * Visits a {@link NodeSequence} node.
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NodeSequence n, final A argu) {
    for (final Iterator<INode> e = n.elements(); e.hasNext();) {
      e.next().accept(this, argu);
    }
    return;
  }

  /**
   * Visits a {@link NodeTCF} node.
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NodeTCF n, @SuppressWarnings("unused") final A argu) {
    @SuppressWarnings("unused")
    final String tkIm = n.tokenImage;
    return;
  }

  /**
   * Visits a {@link NodeToken} node.
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NodeToken n, @SuppressWarnings("unused") final A argu) {
    @SuppressWarnings("unused")
    final String tkIm = n.tokenImage;
    return;
  }

  /*
   * User grammar generated visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link JavaCCInput} node, whose children are the following :
   * <p>
   * f0 -> JavaCCOptions()<br>
   * f1 -> "PARSER_BEGIN"<br>
   * f2 -> "("<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> ")"<br>
   * f5 -> CompilationUnit()<br>
   * f6 -> "PARSER_END"<br>
   * f7 -> "("<br>
   * f8 -> IdentifierAsString()<br>
   * f9 -> ")"<br>
   * f10 -> ( Production() )+<br>
   * f11 -> <EOF><br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final JavaCCInput n, final A argu) {
    // f0 -> JavaCCOptions()
    final JavaCCOptions n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> "PARSER_BEGIN"
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> "("
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> IdentifierAsString()
    final IdentifierAsString n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> ")"
    final NodeToken n4 = n.f4;
    n4.accept(this, argu);
    // f5 -> CompilationUnit()
    final CompilationUnit n5 = n.f5;
    n5.accept(this, argu);
    // f6 -> "PARSER_END"
    final NodeToken n6 = n.f6;
    n6.accept(this, argu);
    // f7 -> "("
    final NodeToken n7 = n.f7;
    n7.accept(this, argu);
    // f8 -> IdentifierAsString()
    final IdentifierAsString n8 = n.f8;
    n8.accept(this, argu);
    // f9 -> ")"
    final NodeToken n9 = n.f9;
    n9.accept(this, argu);
    // f10 -> ( Production() )+
    final NodeList n10 = n.f10;
    for (int i = 0; i < n10.size(); i++) {
      final INode n10Ei = n10.elementAt(i);
      n10Ei.accept(this, argu);
    }
    // f11 -> <EOF>
    final NodeToken n11 = n.f11;
    n11.accept(this, argu);
  }

  /**
   * Visits a {@link JavaCCOptions} node, whose child is the following :
   * <p>
   * f0 -> [ #0 "options" #1 "{"<br>
   * .. .. . #2 ( OptionBinding() )*<br>
   * .. .. . #3 "}" ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final JavaCCOptions n, final A argu) {
    // f0 -> [ #0 "options" #1 "{"
    // .. .. . #2 ( OptionBinding() )*
    // .. .. . #3 "}" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeSequence n0S = (NodeSequence) n0.node;
      // #0 "options"
      final INode n0SA0 = n0S.elementAt(0);
      n0SA0.accept(this, argu);
      // #1 "{"
      final INode n0SA1 = n0S.elementAt(1);
      n0SA1.accept(this, argu);
      // #2 ( OptionBinding() )*
      final INode n0SA2 = n0S.elementAt(2);
      final NodeListOptional n0SA2T = (NodeListOptional) n0SA2;
      if (n0SA2T.present()) {
        for (int i = 0; i < n0SA2T.size(); i++) {
          final INode n0SA2TMi = n0SA2T.elementAt(i);
          n0SA2TMi.accept(this, argu);
        }
      }
      // #3 "}"
      final INode n0SA3 = n0S.elementAt(3);
      n0SA3.accept(this, argu);
    }
  }

  /**
   * Visits a {@link OptionBinding} node, whose children are the following :
   * <p>
   * f0 -> ( %0 <IDENTIFIER><br>
   * .. .. | %1 "LOOKAHEAD"<br>
   * .. .. | %2 "IGNORE_CASE"<br>
   * .. .. | %3 "static" )<br>
   * f1 -> "="<br>
   * f2 -> ( %0 IntegerLiteral()<br>
   * .. .. | %1 BooleanLiteral()<br>
   * .. .. | %2 StringLiteral() )<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final OptionBinding n, final A argu) {
    // f0 -> ( %0 <IDENTIFIER>
    // .. .. | %1 "LOOKAHEAD"
    // .. .. | %2 "IGNORE_CASE"
    // .. .. | %3 "static" )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 <IDENTIFIER>
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 "LOOKAHEAD"
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 "IGNORE_CASE"
        n0CH.accept(this, argu);
        break;
      case 3:
        // %3 "static"
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
    // f1 -> "="
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( %0 IntegerLiteral()
    // .. .. | %1 BooleanLiteral()
    // .. .. | %2 StringLiteral() )
    final NodeChoice n2 = n.f2;
    final NodeChoice n2C = n2;
    final INode n2CH = n2C.choice;
    switch (n2C.which) {
      case 0:
        // %0 IntegerLiteral()
        n2CH.accept(this, argu);
        break;
      case 1:
        // %1 BooleanLiteral()
        n2CH.accept(this, argu);
        break;
      case 2:
        // %2 StringLiteral()
        n2CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
    // f3 -> ";"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link Production} node, whose child is the following :
   * <p>
   * f0 -> . %0 JavaCodeProduction()<br>
   * .. .. | %1 RegularExprProduction()<br>
   * .. .. | %2 TokenManagerDecls()<br>
   * .. .. | %3 BNFProduction()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Production n, final A argu) {
    // f0 -> . %0 JavaCodeProduction()
    // .. .. | %1 RegularExprProduction()
    // .. .. | %2 TokenManagerDecls()
    // .. .. | %3 BNFProduction()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 JavaCodeProduction()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 RegularExprProduction()
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 TokenManagerDecls()
        n0CH.accept(this, argu);
        break;
      case 3:
        // %3 BNFProduction()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link JavaCodeProduction} node, whose children are the following :
   * <p>
   * f0 -> "JAVACODE"<br>
   * f1 -> AccessModifier()<br>
   * f2 -> ResultType()<br>
   * f3 -> IdentifierAsString()<br>
   * f4 -> FormalParameters()<br>
   * f5 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f6 -> [ "%" ]<br>
   * f7 -> Block()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final JavaCodeProduction n, final A argu) {
    // f0 -> "JAVACODE"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> AccessModifier()
    final AccessModifier n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ResultType()
    final ResultType n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> IdentifierAsString()
    final IdentifierAsString n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> FormalParameters()
    final FormalParameters n4 = n.f4;
    n4.accept(this, argu);
    // f5 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence n5S = (NodeSequence) n5.node;
      // #0 "throws"
      final INode n5SA0 = n5S.elementAt(0);
      n5SA0.accept(this, argu);
      // #1 Name()
      final INode n5SA1 = n5S.elementAt(1);
      n5SA1.accept(this, argu);
      // #2 ( $0 "," $1 Name() )*
      final INode n5SA2 = n5S.elementAt(2);
      final NodeListOptional n5SA2T = (NodeListOptional) n5SA2;
      if (n5SA2T.present()) {
        for (int i = 0; i < n5SA2T.size(); i++) {
          final INode n5SA2TMi = n5SA2T.elementAt(i);
          final NodeSequence n5SA2TMiS1 = (NodeSequence) n5SA2TMi;
          // $0 ","
          final INode n5SA2TMiS1A0 = n5SA2TMiS1.elementAt(0);
          n5SA2TMiS1A0.accept(this, argu);
          // $1 Name()
          final INode n5SA2TMiS1A1 = n5SA2TMiS1.elementAt(1);
          n5SA2TMiS1A1.accept(this, argu);
        }
      }
    }
    // f6 -> [ "%" ]
    final NodeOptional n6 = n.f6;
    if (n6.present()) {
      n6.accept(this, argu);
    }
    // f7 -> Block()
    final Block n7 = n.f7;
    n7.accept(this, argu);
  }

  /**
   * Visits a {@link BNFProduction} node, whose children are the following :
   * <p>
   * f0 -> AccessModifier()<br>
   * f1 -> ResultType()<br>
   * f2 -> IdentifierAsString()<br>
   * f3 -> FormalParameters()<br>
   * f4 -> [ #0 "throws" #1 Name()<br>
   * .. .. . #2 ( $0 "," $1 Name() )* ]<br>
   * f5 -> [ "!" ]<br>
   * f6 -> ":"<br>
   * f7 -> Block()<br>
   * f8 -> "{"<br>
   * f9 -> ExpansionChoices()<br>
   * f10 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final BNFProduction n, final A argu) {
    // f0 -> AccessModifier()
    final AccessModifier n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ResultType()
    final ResultType n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> IdentifierAsString()
    final IdentifierAsString n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> FormalParameters()
    final FormalParameters n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> [ #0 "throws" #1 Name()
    // .. .. . #2 ( $0 "," $1 Name() )* ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      final NodeSequence n4S = (NodeSequence) n4.node;
      // #0 "throws"
      final INode n4SA0 = n4S.elementAt(0);
      n4SA0.accept(this, argu);
      // #1 Name()
      final INode n4SA1 = n4S.elementAt(1);
      n4SA1.accept(this, argu);
      // #2 ( $0 "," $1 Name() )*
      final INode n4SA2 = n4S.elementAt(2);
      final NodeListOptional n4SA2T = (NodeListOptional) n4SA2;
      if (n4SA2T.present()) {
        for (int i = 0; i < n4SA2T.size(); i++) {
          final INode n4SA2TMi = n4SA2T.elementAt(i);
          final NodeSequence n4SA2TMiS1 = (NodeSequence) n4SA2TMi;
          // $0 ","
          final INode n4SA2TMiS1A0 = n4SA2TMiS1.elementAt(0);
          n4SA2TMiS1A0.accept(this, argu);
          // $1 Name()
          final INode n4SA2TMiS1A1 = n4SA2TMiS1.elementAt(1);
          n4SA2TMiS1A1.accept(this, argu);
        }
      }
    }
    // f5 -> [ "!" ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      n5.accept(this, argu);
    }
    // f6 -> ":"
    final NodeToken n6 = n.f6;
    n6.accept(this, argu);
    // f7 -> Block()
    final Block n7 = n.f7;
    n7.accept(this, argu);
    // f8 -> "{"
    final NodeToken n8 = n.f8;
    n8.accept(this, argu);
    // f9 -> ExpansionChoices()
    final ExpansionChoices n9 = n.f9;
    n9.accept(this, argu);
    // f10 -> "}"
    final NodeToken n10 = n.f10;
    n10.accept(this, argu);
  }

  /**
   * Visits a {@link AccessModifier} node, whose child is the following :
   * <p>
   * f0 -> ( %0 "public"<br>
   * .. .. | %1 "protected"<br>
   * .. .. | %2 "private"<br>
   * .. .. | %3 "final" )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final AccessModifier n, final A argu) {
    // f0 -> ( %0 "public"
    // .. .. | %1 "protected"
    // .. .. | %2 "private"
    // .. .. | %3 "final" )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode n0Mi = n0.elementAt(i);
        final NodeChoice n0MiC = (NodeChoice) n0Mi;
        final INode n0MiCH = n0MiC.choice;
        switch (n0MiC.which) {
          case 0:
            // %0 "public"
            n0MiCH.accept(this, argu);
            break;
          case 1:
            // %1 "protected"
            n0MiCH.accept(this, argu);
            break;
          case 2:
            // %2 "private"
            n0MiCH.accept(this, argu);
            break;
          case 3:
            // %3 "final"
            n0MiCH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
      }
    }
  }

  /**
   * Visits a {@link RegularExprProduction} node, whose children are the following :
   * <p>
   * f0 -> [ %0 #0 "<" #1 "*" #2 ">"<br>
   * .. .. | %1 #0 "<" #1 <IDENTIFIER><br>
   * .. .. . .. #2 ( $0 "," $1 <IDENTIFIER> )*<br>
   * .. .. . .. #3 ">" ]<br>
   * f1 -> RegExprKind()<br>
   * f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]<br>
   * f3 -> ":"<br>
   * f4 -> "{"<br>
   * f5 -> RegExprSpec()<br>
   * f6 -> ( #0 "|" #1 RegExprSpec() )*<br>
   * f7 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final RegularExprProduction n, final A argu) {
    // f0 -> [ %0 #0 "<" #1 "*" #2 ">"
    // .. .. | %1 #0 "<" #1 <IDENTIFIER>
    // .. .. . .. #2 ( $0 "," $1 <IDENTIFIER> )*
    // .. .. . .. #3 ">" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeChoice n0C = (NodeChoice) n0.node;
      final INode n0CH = n0C.choice;
      switch (n0C.which) {
        case 0:
          // %0 #0 "<" #1 "*" #2 ">"
          final NodeSequence n0CHS = (NodeSequence) n0CH;
          // #0 "<"
          final INode n0CHS0A0 = n0CHS.elementAt(0);
          n0CHS0A0.accept(this, argu);
          // #1 "*"
          final INode n0CHS0A1 = n0CHS.elementAt(1);
          n0CHS0A1.accept(this, argu);
          // #2 ">"
          final INode n0CHS0A2 = n0CHS.elementAt(2);
          n0CHS0A2.accept(this, argu);
          break;
        case 1:
          // %1 #0 "<" #1 <IDENTIFIER>
          // .. #2 ( $0 "," $1 <IDENTIFIER> )*
          // .. #3 ">"
          final NodeSequence n0CHS1 = (NodeSequence) n0CH;
          // #0 "<"
          final INode n0CHS11A0 = n0CHS1.elementAt(0);
          n0CHS11A0.accept(this, argu);
          // #1 <IDENTIFIER>
          final INode n0CHS11A1 = n0CHS1.elementAt(1);
          n0CHS11A1.accept(this, argu);
          // #2 ( $0 "," $1 <IDENTIFIER> )*
          final INode n0CHS11A2 = n0CHS1.elementAt(2);
          final NodeListOptional n0CHS11A2T = (NodeListOptional) n0CHS11A2;
          if (n0CHS11A2T.present()) {
            for (int i = 0; i < n0CHS11A2T.size(); i++) {
              final INode n0CHS11A2TMi = n0CHS11A2T.elementAt(i);
              final NodeSequence n0CHS11A2TMiS2 = (NodeSequence) n0CHS11A2TMi;
              // $0 ","
              final INode n0CHS11A2TMiS2A0 = n0CHS11A2TMiS2.elementAt(0);
              n0CHS11A2TMiS2A0.accept(this, argu);
              // $1 <IDENTIFIER>
              final INode n0CHS11A2TMiS2A1 = n0CHS11A2TMiS2.elementAt(1);
              n0CHS11A2TMiS2A1.accept(this, argu);
            }
          }
          // #3 ">"
          final INode n0CHS1A3 = n0CHS1.elementAt(3);
          n0CHS1A3.accept(this, argu);
          break;
        default:
          // should not occur !!!
          break;
      }
    }
    // f1 -> RegExprKind()
    final RegExprKind n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> [ #0 "[" #1 "IGNORE_CASE" #2 "]" ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence n2S3 = (NodeSequence) n2.node;
      // #0 "["
      final INode n2S3A0 = n2S3.elementAt(0);
      n2S3A0.accept(this, argu);
      // #1 "IGNORE_CASE"
      final INode n2S3A1 = n2S3.elementAt(1);
      n2S3A1.accept(this, argu);
      // #2 "]"
      final INode n2S3A2 = n2S3.elementAt(2);
      n2S3A2.accept(this, argu);
    }
    // f3 -> ":"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> "{"
    final NodeToken n4 = n.f4;
    n4.accept(this, argu);
    // f5 -> RegExprSpec()
    final RegExprSpec n5 = n.f5;
    n5.accept(this, argu);
    // f6 -> ( #0 "|" #1 RegExprSpec() )*
    final NodeListOptional n6 = n.f6;
    if (n6.present()) {
      for (int i = 0; i < n6.size(); i++) {
        final INode n6Mi = n6.elementAt(i);
        final NodeSequence n6MiS4 = (NodeSequence) n6Mi;
        // #0 "|"
        final INode n6MiS4A0 = n6MiS4.elementAt(0);
        n6MiS4A0.accept(this, argu);
        // #1 RegExprSpec()
        final INode n6MiS4A1 = n6MiS4.elementAt(1);
        n6MiS4A1.accept(this, argu);
      }
    }
    // f7 -> "}"
    final NodeToken n7 = n.f7;
    n7.accept(this, argu);
  }

  /**
   * Visits a {@link TokenManagerDecls} node, whose children are the following :
   * <p>
   * f0 -> "TOKEN_MGR_DECLS"<br>
   * f1 -> ":"<br>
   * f2 -> ClassOrInterfaceBody()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final TokenManagerDecls n, final A argu) {
    // f0 -> "TOKEN_MGR_DECLS"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ":"
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ClassOrInterfaceBody()
    final ClassOrInterfaceBody n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link RegExprKind} node, whose child is the following :
   * <p>
   * f0 -> . %0 "TOKEN"<br>
   * .. .. | %1 "SPECIAL_TOKEN"<br>
   * .. .. | %2 "SKIP"<br>
   * .. .. | %3 "MORE"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final RegExprKind n, final A argu) {
    // f0 -> . %0 "TOKEN"
    // .. .. | %1 "SPECIAL_TOKEN"
    // .. .. | %2 "SKIP"
    // .. .. | %3 "MORE"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "TOKEN"
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 "SPECIAL_TOKEN"
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 "SKIP"
        n0CH.accept(this, argu);
        break;
      case 3:
        // %3 "MORE"
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link RegExprSpec} node, whose children are the following :
   * <p>
   * f0 -> RegularExpression()<br>
   * f1 -> [ "!" ]<br>
   * f2 -> [ Block() ]<br>
   * f3 -> [ #0 ":" #1 <IDENTIFIER> ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final RegExprSpec n, final A argu) {
    // f0 -> RegularExpression()
    final RegularExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ "!" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this, argu);
    }
    // f2 -> [ Block() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this, argu);
    }
    // f3 -> [ #0 ":" #1 <IDENTIFIER> ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S = (NodeSequence) n3.node;
      // #0 ":"
      final INode n3SA0 = n3S.elementAt(0);
      n3SA0.accept(this, argu);
      // #1 <IDENTIFIER>
      final INode n3SA1 = n3S.elementAt(1);
      n3SA1.accept(this, argu);
    }
  }

  /**
   * Visits a {@link ExpansionChoices} node, whose children are the following :
   * <p>
   * f0 -> Expansion()<br>
   * f1 -> ( #0 "|" #1 Expansion() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ExpansionChoices n, final A argu) {
    // f0 -> Expansion()
    final Expansion n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "|" #1 Expansion() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "|"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 Expansion()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link Expansion} node, whose children are the following :
   * <p>
   * f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?<br>
   * f1 -> ( ExpansionUnit() )+<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Expansion n, final A argu) {
    // f0 -> ( #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")" )?
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      final NodeSequence n0S = (NodeSequence) n0.node;
      // #0 "LOOKAHEAD"
      final INode n0SA0 = n0S.elementAt(0);
      n0SA0.accept(this, argu);
      // #1 "("
      final INode n0SA1 = n0S.elementAt(1);
      n0SA1.accept(this, argu);
      // #2 LocalLookahead()
      final INode n0SA2 = n0S.elementAt(2);
      n0SA2.accept(this, argu);
      // #3 ")"
      final INode n0SA3 = n0S.elementAt(3);
      n0SA3.accept(this, argu);
    }
    // f1 -> ( ExpansionUnit() )+
    final NodeList n1 = n.f1;
    for (int i = 0; i < n1.size(); i++) {
      final INode n1Ei = n1.elementAt(i);
      n1Ei.accept(this, argu);
    }
  }

  /**
   * Visits a {@link LocalLookahead} node, whose children are the following :
   * <p>
   * f0 -> [ IntegerLiteral() ]<br>
   * f1 -> [ "," ]<br>
   * f2 -> [ ExpansionChoices() ]<br>
   * f3 -> [ "," ]<br>
   * f4 -> [ #0 "{" #1 Expression() #2 "}" ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final LocalLookahead n, final A argu) {
    // f0 -> [ IntegerLiteral() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this, argu);
    }
    // f1 -> [ "," ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this, argu);
    }
    // f2 -> [ ExpansionChoices() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this, argu);
    }
    // f3 -> [ "," ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this, argu);
    }
    // f4 -> [ #0 "{" #1 Expression() #2 "}" ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      final NodeSequence n4S = (NodeSequence) n4.node;
      // #0 "{"
      final INode n4SA0 = n4S.elementAt(0);
      n4SA0.accept(this, argu);
      // #1 Expression()
      final INode n4SA1 = n4S.elementAt(1);
      n4SA1.accept(this, argu);
      // #2 "}"
      final INode n4SA2 = n4S.elementAt(2);
      n4SA2.accept(this, argu);
    }
  }

  /**
   * Visits a {@link ExpansionUnit} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"<br>
   * .. .. | %1 Block()<br>
   * .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"<br>
   * .. .. | %3 ExpansionUnitTCF()<br>
   * .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]<br>
   * .. .. . .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()<br>
   * .. .. . .. .. . .. $2 [ "!" ]<br>
   * .. .. . .. .. | &1 $0 RegularExpression()<br>
   * .. .. . .. .. . .. $1 [ ?0 "." ?1 <IDENTIFIER> ]<br>
   * .. .. . .. .. . .. $2 [ "!" ] )<br>
   * .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?" )?<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ExpansionUnit n, final A argu) {
    // f0 -> . %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"
    // .. .. | %1 Block()
    // .. .. | %2 #0 "[" #1 ExpansionChoices() #2 "]"
    // .. .. | %3 ExpansionUnitTCF()
    // .. .. | %4 #0 [ $0 PrimaryExpression() $1 "=" ]
    // .. .. . .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()
    // .. .. . .. .. . .. $2 [ "!" ]
    // .. .. . .. .. | &1 $0 RegularExpression()
    // .. .. . .. .. . .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
    // .. .. . .. .. . .. $2 [ "!" ] )
    // .. .. | %5 #0 "(" #1 ExpansionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?" )?
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "LOOKAHEAD" #1 "(" #2 LocalLookahead() #3 ")"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "LOOKAHEAD"
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 "("
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        n0CHS0A1.accept(this, argu);
        // #2 LocalLookahead()
        final INode n0CHS0A2 = n0CHS.elementAt(2);
        n0CHS0A2.accept(this, argu);
        // #3 ")"
        final INode n0CHS0A3 = n0CHS.elementAt(3);
        n0CHS0A3.accept(this, argu);
        break;
      case 1:
        // %1 Block()
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 #0 "[" #1 ExpansionChoices() #2 "]"
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "["
        final INode n0CHS12A0 = n0CHS1.elementAt(0);
        n0CHS12A0.accept(this, argu);
        // #1 ExpansionChoices()
        final INode n0CHS12A1 = n0CHS1.elementAt(1);
        n0CHS12A1.accept(this, argu);
        // #2 "]"
        final INode n0CHS12A2 = n0CHS1.elementAt(2);
        n0CHS12A2.accept(this, argu);
        break;
      case 3:
        // %3 ExpansionUnitTCF()
        n0CH.accept(this, argu);
        break;
      case 4:
        // %4 #0 [ $0 PrimaryExpression() $1 "=" ]
        // .. #1 ( &0 $0 IdentifierAsString() $1 Arguments()
        // .. .. .. $2 [ "!" ]
        // .. .. | &1 $0 RegularExpression()
        // .. .. .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
        // .. .. .. $2 [ "!" ] )
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 [ $0 PrimaryExpression() $1 "=" ]
        final INode n0CHS24A0 = n0CHS2.elementAt(0);
        final NodeOptional n0CHS24A0P = (NodeOptional) n0CHS24A0;
        if (n0CHS24A0P.present()) {
          final NodeSequence n0CHS24A0PS3 = (NodeSequence) n0CHS24A0P.node;
          // $0 PrimaryExpression()
          final INode n0CHS24A0PS3A0 = n0CHS24A0PS3.elementAt(0);
          n0CHS24A0PS3A0.accept(this, argu);
          // $1 "="
          final INode n0CHS24A0PS3A1 = n0CHS24A0PS3.elementAt(1);
          n0CHS24A0PS3A1.accept(this, argu);
        }
        // #1 ( &0 $0 IdentifierAsString() $1 Arguments()
        // .. .. $2 [ "!" ]
        // .. | &1 $0 RegularExpression()
        // .. .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
        // .. .. $2 [ "!" ] )
        final INode n0CHS2A1 = n0CHS2.elementAt(1);
        final NodeChoice n0CHS2A1C = (NodeChoice) n0CHS2A1;
        final INode n0CHS2A1CH = n0CHS2A1C.choice;
        switch (n0CHS2A1C.which) {
          case 0:
            // &0 $0 IdentifierAsString() $1 Arguments()
            // .. $2 [ "!" ]
            final NodeSequence n0CHS2A1CHS4 = (NodeSequence) n0CHS2A1CH;
            // $0 IdentifierAsString()
            final INode n0CHS2A1CHS40A0 = n0CHS2A1CHS4.elementAt(0);
            n0CHS2A1CHS40A0.accept(this, argu);
            // $1 Arguments()
            final INode n0CHS2A1CHS40A1 = n0CHS2A1CHS4.elementAt(1);
            n0CHS2A1CHS40A1.accept(this, argu);
            // $2 [ "!" ]
            final INode n0CHS2A1CHS40A2 = n0CHS2A1CHS4.elementAt(2);
            final NodeOptional n0CHS2A1CHS40A2P = (NodeOptional) n0CHS2A1CHS40A2;
            if (n0CHS2A1CHS40A2P.present()) {
              n0CHS2A1CHS40A2P.accept(this, argu);
            }
            break;
          case 1:
            // &1 $0 RegularExpression()
            // .. $1 [ ?0 "." ?1 <IDENTIFIER> ]
            // .. $2 [ "!" ]
            final NodeSequence n0CHS2A1CHS5 = (NodeSequence) n0CHS2A1CH;
            // $0 RegularExpression()
            final INode n0CHS2A1CHS51A0 = n0CHS2A1CHS5.elementAt(0);
            n0CHS2A1CHS51A0.accept(this, argu);
            // $1 [ ?0 "." ?1 <IDENTIFIER> ]
            final INode n0CHS2A1CHS51A1 = n0CHS2A1CHS5.elementAt(1);
            final NodeOptional n0CHS2A1CHS51A1P = (NodeOptional) n0CHS2A1CHS51A1;
            if (n0CHS2A1CHS51A1P.present()) {
              final NodeSequence n0CHS2A1CHS51A1PS6 = (NodeSequence) n0CHS2A1CHS51A1P.node;
              // ?0 "."
              final INode n0CHS2A1CHS51A1PS6A0 = n0CHS2A1CHS51A1PS6.elementAt(0);
              n0CHS2A1CHS51A1PS6A0.accept(this, argu);
              // ?1 <IDENTIFIER>
              final INode n0CHS2A1CHS51A1PS6A1 = n0CHS2A1CHS51A1PS6.elementAt(1);
              n0CHS2A1CHS51A1PS6A1.accept(this, argu);
            }
            // $2 [ "!" ]
            final INode n0CHS2A1CHS5A2 = n0CHS2A1CHS5.elementAt(2);
            final NodeOptional n0CHS2A1CHS5A2P = (NodeOptional) n0CHS2A1CHS5A2;
            if (n0CHS2A1CHS5A2P.present()) {
              n0CHS2A1CHS5A2P.accept(this, argu);
            }
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 5:
        // %5 #0 "(" #1 ExpansionChoices() #2 ")"
        // .. #3 ( &0 "+"
        // .. .. | &1 "*"
        // .. .. | &2 "?" )?
        final NodeSequence n0CHS7 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS75A0 = n0CHS7.elementAt(0);
        n0CHS75A0.accept(this, argu);
        // #1 ExpansionChoices()
        final INode n0CHS75A1 = n0CHS7.elementAt(1);
        n0CHS75A1.accept(this, argu);
        // #2 ")"
        final INode n0CHS75A2 = n0CHS7.elementAt(2);
        n0CHS75A2.accept(this, argu);
        // #3 ( &0 "+"
        // .. | &1 "*"
        // .. | &2 "?" )?
        final INode n0CHS75A3 = n0CHS7.elementAt(3);
        final NodeOptional n0CHS75A3P = (NodeOptional) n0CHS75A3;
        if (n0CHS75A3P.present()) {
          final NodeChoice n0CHS75A3PC = (NodeChoice) n0CHS75A3P.node;
          final INode n0CHS75A3PCH = n0CHS75A3PC.choice;
          switch (n0CHS75A3PC.which) {
            case 0:
              // &0 "+"
              n0CHS75A3PCH.accept(this, argu);
              break;
            case 1:
              // &1 "*"
              n0CHS75A3PCH.accept(this, argu);
              break;
            case 2:
              // &2 "?"
              n0CHS75A3PCH.accept(this, argu);
              break;
            default:
              // should not occur !!!
              break;
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ExpansionUnitTCF} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> "{"<br>
   * f2 -> ExpansionChoices()<br>
   * f3 -> "}"<br>
   * f4 -> ( #0 "catch" #1 "(" #2 Name() #3 <IDENTIFIER> #4 ")" #5 Block() )*<br>
   * f5 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ExpansionUnitTCF n, final A argu) {
    // f0 -> "try"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> "{"
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ExpansionChoices()
    final ExpansionChoices n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> "}"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> ( #0 "catch" #1 "(" #2 Name() #3 <IDENTIFIER> #4 ")" #5 Block() )*
    final NodeListOptional n4 = n.f4;
    if (n4.present()) {
      for (int i = 0; i < n4.size(); i++) {
        final INode n4Mi = n4.elementAt(i);
        final NodeSequence n4MiS = (NodeSequence) n4Mi;
        // #0 "catch"
        final INode n4MiSA0 = n4MiS.elementAt(0);
        n4MiSA0.accept(this, argu);
        // #1 "("
        final INode n4MiSA1 = n4MiS.elementAt(1);
        n4MiSA1.accept(this, argu);
        // #2 Name()
        final INode n4MiSA2 = n4MiS.elementAt(2);
        n4MiSA2.accept(this, argu);
        // #3 <IDENTIFIER>
        final INode n4MiSA3 = n4MiS.elementAt(3);
        n4MiSA3.accept(this, argu);
        // #4 ")"
        final INode n4MiSA4 = n4MiS.elementAt(4);
        n4MiSA4.accept(this, argu);
        // #5 Block()
        final INode n4MiSA5 = n4MiS.elementAt(5);
        n4MiSA5.accept(this, argu);
      }
    }
    // f5 -> [ #0 "finally" #1 Block() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence n5S1 = (NodeSequence) n5.node;
      // #0 "finally"
      final INode n5S1A0 = n5S1.elementAt(0);
      n5S1A0.accept(this, argu);
      // #1 Block()
      final INode n5S1A1 = n5S1.elementAt(1);
      n5S1A1.accept(this, argu);
    }
  }

  /**
   * Visits a {@link RegularExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<"<br>
   * .. .. . .. #1 [ $0 [ "#" ]<br>
   * .. .. . .. .. . $1 IdentifierAsString() $2 ":" ]<br>
   * .. .. . .. #2 ComplexRegularExpressionChoices() #3 ">"<br>
   * .. .. | %2 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %3 #0 "<" #1 "EOF" #2 ">"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final RegularExpression n, final A argu) {
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 "<"
    // .. .. . .. #1 [ $0 [ "#" ]
    // .. .. . .. .. . $1 IdentifierAsString() $2 ":" ]
    // .. .. . .. #2 ComplexRegularExpressionChoices() #3 ">"
    // .. .. | %2 #0 "<" #1 IdentifierAsString() #2 ">"
    // .. .. | %3 #0 "<" #1 "EOF" #2 ">"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 StringLiteral()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 #0 "<"
        // .. #1 [ $0 [ "#" ]
        // .. .. . $1 IdentifierAsString() $2 ":" ]
        // .. #2 ComplexRegularExpressionChoices() #3 ">"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "<"
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        n0CHS1A0.accept(this, argu);
        // #1 [ $0 [ "#" ]
        // .. . $1 IdentifierAsString() $2 ":" ]
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        final NodeOptional n0CHS1A1P = (NodeOptional) n0CHS1A1;
        if (n0CHS1A1P.present()) {
          final NodeSequence n0CHS1A1PS1 = (NodeSequence) n0CHS1A1P.node;
          // $0 [ "#" ]
          final INode n0CHS1A1PS1A0 = n0CHS1A1PS1.elementAt(0);
          final NodeOptional n0CHS1A1PS1A0P = (NodeOptional) n0CHS1A1PS1A0;
          if (n0CHS1A1PS1A0P.present()) {
            n0CHS1A1PS1A0P.accept(this, argu);
          }
          // $1 IdentifierAsString()
          final INode n0CHS1A1PS1A1 = n0CHS1A1PS1.elementAt(1);
          n0CHS1A1PS1A1.accept(this, argu);
          // $2 ":"
          final INode n0CHS1A1PS1A2 = n0CHS1A1PS1.elementAt(2);
          n0CHS1A1PS1A2.accept(this, argu);
        }
        // #2 ComplexRegularExpressionChoices()
        final INode n0CHSA2 = n0CHS.elementAt(2);
        n0CHSA2.accept(this, argu);
        // #3 ">"
        final INode n0CHSA3 = n0CHS.elementAt(3);
        n0CHSA3.accept(this, argu);
        break;
      case 2:
        // %2 #0 "<" #1 IdentifierAsString() #2 ">"
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 "<"
        final INode n0CHS22A0 = n0CHS2.elementAt(0);
        n0CHS22A0.accept(this, argu);
        // #1 IdentifierAsString()
        final INode n0CHS22A1 = n0CHS2.elementAt(1);
        n0CHS22A1.accept(this, argu);
        // #2 ">"
        final INode n0CHS22A2 = n0CHS2.elementAt(2);
        n0CHS22A2.accept(this, argu);
        break;
      case 3:
        // %3 #0 "<" #1 "EOF" #2 ">"
        final NodeSequence n0CHS3 = (NodeSequence) n0CH;
        // #0 "<"
        final INode n0CHS33A0 = n0CHS3.elementAt(0);
        n0CHS33A0.accept(this, argu);
        // #1 "EOF"
        final INode n0CHS33A1 = n0CHS3.elementAt(1);
        n0CHS33A1.accept(this, argu);
        // #2 ">"
        final INode n0CHS33A2 = n0CHS3.elementAt(2);
        n0CHS33A2.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ComplexRegularExpressionChoices} node, whose children are the following :
   * <p>
   * f0 -> ComplexRegularExpression()<br>
   * f1 -> ( #0 "|" #1 ComplexRegularExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ComplexRegularExpressionChoices n, final A argu) {
    // f0 -> ComplexRegularExpression()
    final ComplexRegularExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "|" #1 ComplexRegularExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "|"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 ComplexRegularExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link ComplexRegularExpression} node, whose child is the following :
   * <p>
   * f0 -> ( ComplexRegularExpressionUnit() )+<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ComplexRegularExpression n, final A argu) {
    // f0 -> ( ComplexRegularExpressionUnit() )+
    final NodeList n0 = n.f0;
    for (int i = 0; i < n0.size(); i++) {
      final INode n0Ei = n0.elementAt(i);
      n0Ei.accept(this, argu);
    }
  }

  /**
   * Visits a {@link ComplexRegularExpressionUnit} node, whose child is the following :
   * <p>
   * f0 -> . %0 StringLiteral()<br>
   * .. .. | %1 #0 "<" #1 IdentifierAsString() #2 ">"<br>
   * .. .. | %2 CharacterList()<br>
   * .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"<br>
   * .. .. . .. #3 ( &0 "+"<br>
   * .. .. . .. .. | &1 "*"<br>
   * .. .. . .. .. | &2 "?"<br>
   * .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()<br>
   * .. .. . .. .. . .. $2 [ ?0 ","<br>
   * .. .. . .. .. . .. .. . ?1 [ IntegerLiteral() ] ]<br>
   * .. .. . .. .. . .. $3 "}" )?<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ComplexRegularExpressionUnit n, final A argu) {
    // f0 -> . %0 StringLiteral()
    // .. .. | %1 #0 "<" #1 IdentifierAsString() #2 ">"
    // .. .. | %2 CharacterList()
    // .. .. | %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"
    // .. .. . .. #3 ( &0 "+"
    // .. .. . .. .. | &1 "*"
    // .. .. . .. .. | &2 "?"
    // .. .. . .. .. | &3 $0 "{" $1 IntegerLiteral()
    // .. .. . .. .. . .. $2 [ ?0 ","
    // .. .. . .. .. . .. .. . ?1 [ IntegerLiteral() ] ]
    // .. .. . .. .. . .. $3 "}" )?
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 StringLiteral()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 #0 "<" #1 IdentifierAsString() #2 ">"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "<"
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        n0CHS1A0.accept(this, argu);
        // #1 IdentifierAsString()
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        n0CHS1A1.accept(this, argu);
        // #2 ">"
        final INode n0CHS1A2 = n0CHS.elementAt(2);
        n0CHS1A2.accept(this, argu);
        break;
      case 2:
        // %2 CharacterList()
        n0CH.accept(this, argu);
        break;
      case 3:
        // %3 #0 "(" #1 ComplexRegularExpressionChoices() #2 ")"
        // .. #3 ( &0 "+"
        // .. .. | &1 "*"
        // .. .. | &2 "?"
        // .. .. | &3 $0 "{" $1 IntegerLiteral()
        // .. .. .. $2 [ ?0 ","
        // .. .. .. .. . ?1 [ IntegerLiteral() ] ]
        // .. .. .. $3 "}" )?
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS13A0 = n0CHS1.elementAt(0);
        n0CHS13A0.accept(this, argu);
        // #1 ComplexRegularExpressionChoices()
        final INode n0CHS13A1 = n0CHS1.elementAt(1);
        n0CHS13A1.accept(this, argu);
        // #2 ")"
        final INode n0CHS13A2 = n0CHS1.elementAt(2);
        n0CHS13A2.accept(this, argu);
        // #3 ( &0 "+"
        // .. | &1 "*"
        // .. | &2 "?"
        // .. | &3 $0 "{" $1 IntegerLiteral()
        // .. .. $2 [ ?0 ","
        // .. .. .. . ?1 [ IntegerLiteral() ] ]
        // .. .. $3 "}" )?
        final INode n0CHS13A3 = n0CHS1.elementAt(3);
        final NodeOptional n0CHS13A3P = (NodeOptional) n0CHS13A3;
        if (n0CHS13A3P.present()) {
          final NodeChoice n0CHS13A3PC = (NodeChoice) n0CHS13A3P.node;
          final INode n0CHS13A3PCH = n0CHS13A3PC.choice;
          switch (n0CHS13A3PC.which) {
            case 0:
              // &0 "+"
              n0CHS13A3PCH.accept(this, argu);
              break;
            case 1:
              // &1 "*"
              n0CHS13A3PCH.accept(this, argu);
              break;
            case 2:
              // &2 "?"
              n0CHS13A3PCH.accept(this, argu);
              break;
            case 3:
              // &3 $0 "{" $1 IntegerLiteral()
              // .. $2 [ ?0 ","
              // .. .. . ?1 [ IntegerLiteral() ] ]
              // .. $3 "}"
              final NodeSequence n0CHS13A3PCHS2 = (NodeSequence) n0CHS13A3PCH;
              // $0 "{"
              final INode n0CHS13A3PCHS23A0 = n0CHS13A3PCHS2.elementAt(0);
              n0CHS13A3PCHS23A0.accept(this, argu);
              // $1 IntegerLiteral()
              final INode n0CHS13A3PCHS23A1 = n0CHS13A3PCHS2.elementAt(1);
              n0CHS13A3PCHS23A1.accept(this, argu);
              // $2 [ ?0 ","
              // .. . ?1 [ IntegerLiteral() ] ]
              final INode n0CHS13A3PCHS23A2 = n0CHS13A3PCHS2.elementAt(2);
              final NodeOptional n0CHS13A3PCHS23A2P = (NodeOptional) n0CHS13A3PCHS23A2;
              if (n0CHS13A3PCHS23A2P.present()) {
                final NodeSequence n0CHS13A3PCHS23A2PS3 = (NodeSequence) n0CHS13A3PCHS23A2P.node;
                // ?0 ","
                final INode n0CHS13A3PCHS23A2PS3A0 = n0CHS13A3PCHS23A2PS3.elementAt(0);
                n0CHS13A3PCHS23A2PS3A0.accept(this, argu);
                // ?1 [ IntegerLiteral() ]
                final INode n0CHS13A3PCHS23A2PS3A1 = n0CHS13A3PCHS23A2PS3.elementAt(1);
                final NodeOptional n0CHS13A3PCHS23A2PS3A1P = (NodeOptional) n0CHS13A3PCHS23A2PS3A1;
                if (n0CHS13A3PCHS23A2PS3A1P.present()) {
                  n0CHS13A3PCHS23A2PS3A1P.accept(this, argu);
                }
              }
              // $3 "}"
              final INode n0CHS13A3PCHS2A3 = n0CHS13A3PCHS2.elementAt(3);
              n0CHS13A3PCHS2A3.accept(this, argu);
              break;
            default:
              // should not occur !!!
              break;
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link CharacterList} node, whose children are the following :
   * <p>
   * f0 -> [ "~" ]<br>
   * f1 -> "["<br>
   * f2 -> [ #0 CharacterDescriptor()<br>
   * .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]<br>
   * f3 -> "]"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final CharacterList n, final A argu) {
    // f0 -> [ "~" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this, argu);
    }
    // f1 -> "["
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> [ #0 CharacterDescriptor()
    // .. .. . #1 ( $0 "," $1 CharacterDescriptor() )* ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence n2S = (NodeSequence) n2.node;
      // #0 CharacterDescriptor()
      final INode n2SA0 = n2S.elementAt(0);
      n2SA0.accept(this, argu);
      // #1 ( $0 "," $1 CharacterDescriptor() )*
      final INode n2SA1 = n2S.elementAt(1);
      final NodeListOptional n2SA1T = (NodeListOptional) n2SA1;
      if (n2SA1T.present()) {
        for (int i = 0; i < n2SA1T.size(); i++) {
          final INode n2SA1TMi = n2SA1T.elementAt(i);
          final NodeSequence n2SA1TMiS1 = (NodeSequence) n2SA1TMi;
          // $0 ","
          final INode n2SA1TMiS1A0 = n2SA1TMiS1.elementAt(0);
          n2SA1TMiS1A0.accept(this, argu);
          // $1 CharacterDescriptor()
          final INode n2SA1TMiS1A1 = n2SA1TMiS1.elementAt(1);
          n2SA1TMiS1A1.accept(this, argu);
        }
      }
    }
    // f3 -> "]"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link CharacterDescriptor} node, whose children are the following :
   * <p>
   * f0 -> StringLiteral()<br>
   * f1 -> [ #0 "-" #1 StringLiteral() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final CharacterDescriptor n, final A argu) {
    // f0 -> StringLiteral()
    final StringLiteral n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ #0 "-" #1 StringLiteral() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 "-"
      final INode n1SA0 = n1S.elementAt(0);
      n1SA0.accept(this, argu);
      // #1 StringLiteral()
      final INode n1SA1 = n1S.elementAt(1);
      n1SA1.accept(this, argu);
    }
  }

  /**
   * Visits a {@link IdentifierAsString} node, whose child is the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final IdentifierAsString n, final A argu) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
  }

  /**
   * Visits a {@link JavaIdentifier} node, whose child is the following :
   * <p>
   * f0 -> ( %00 <IDENTIFIER><br>
   * .. .. | %01 "LOOKAHEAD"<br>
   * .. .. | %02 "IGNORE_CASE"<br>
   * .. .. | %03 "PARSER_BEGIN"<br>
   * .. .. | %04 "PARSER_END"<br>
   * .. .. | %05 "JAVACODE"<br>
   * .. .. | %06 "TOKEN"<br>
   * .. .. | %07 "SPECIAL_TOKEN"<br>
   * .. .. | %08 "MORE"<br>
   * .. .. | %09 "SKIP"<br>
   * .. .. | %10 "TOKEN_MGR_DECLS"<br>
   * .. .. | %11 "EOF" )<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final JavaIdentifier n, final A argu) {
    // f0 -> ( %00 <IDENTIFIER>
    // .. .. | %01 "LOOKAHEAD"
    // .. .. | %02 "IGNORE_CASE"
    // .. .. | %03 "PARSER_BEGIN"
    // .. .. | %04 "PARSER_END"
    // .. .. | %05 "JAVACODE"
    // .. .. | %06 "TOKEN"
    // .. .. | %07 "SPECIAL_TOKEN"
    // .. .. | %08 "MORE"
    // .. .. | %09 "SKIP"
    // .. .. | %10 "TOKEN_MGR_DECLS"
    // .. .. | %11 "EOF" )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %00 <IDENTIFIER>
        n0CH.accept(this, argu);
        break;
      case 1:
        // %01 "LOOKAHEAD"
        n0CH.accept(this, argu);
        break;
      case 2:
        // %02 "IGNORE_CASE"
        n0CH.accept(this, argu);
        break;
      case 3:
        // %03 "PARSER_BEGIN"
        n0CH.accept(this, argu);
        break;
      case 4:
        // %04 "PARSER_END"
        n0CH.accept(this, argu);
        break;
      case 5:
        // %05 "JAVACODE"
        n0CH.accept(this, argu);
        break;
      case 6:
        // %06 "TOKEN"
        n0CH.accept(this, argu);
        break;
      case 7:
        // %07 "SPECIAL_TOKEN"
        n0CH.accept(this, argu);
        break;
      case 8:
        // %08 "MORE"
        n0CH.accept(this, argu);
        break;
      case 9:
        // %09 "SKIP"
        n0CH.accept(this, argu);
        break;
      case 10:
        // %10 "TOKEN_MGR_DECLS"
        n0CH.accept(this, argu);
        break;
      case 11:
        // %11 "EOF"
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link CompilationUnit} node, whose children are the following :
   * <p>
   * f0 -> [ PackageDeclaration() ]<br>
   * f1 -> ( ImportDeclaration() )*<br>
   * f2 -> ( TypeDeclaration() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final CompilationUnit n, final A argu) {
    // f0 -> [ PackageDeclaration() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this, argu);
    }
    // f1 -> ( ImportDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        n1Mi.accept(this, argu);
      }
    }
    // f2 -> ( TypeDeclaration() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        n2Mi.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link PackageDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "package"<br>
   * f1 -> Name()<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final PackageDeclaration n, final A argu) {
    // f0 -> "package"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Name()
    final Name n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link ImportDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "import"<br>
   * f1 -> [ "static" ]<br>
   * f2 -> Name()<br>
   * f3 -> [ #0 "." #1 "*" ]<br>
   * f4 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ImportDeclaration n, final A argu) {
    // f0 -> "import"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ "static" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this, argu);
    }
    // f2 -> Name()
    final Name n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> [ #0 "." #1 "*" ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S = (NodeSequence) n3.node;
      // #0 "."
      final INode n3SA0 = n3S.elementAt(0);
      n3SA0.accept(this, argu);
      // #1 "*"
      final INode n3SA1 = n3S.elementAt(1);
      n3SA1.accept(this, argu);
    }
    // f4 -> ";"
    final NodeToken n4 = n.f4;
    n4.accept(this, argu);
  }

  /**
   * Visits a {@link Modifiers} node, whose child is the following :
   * <p>
   * f0 -> ( ( %00 "public"<br>
   * .. .. . | %01 "static"<br>
   * .. .. . | %02 "protected"<br>
   * .. .. . | %03 "private"<br>
   * .. .. . | %04 "final"<br>
   * .. .. . | %05 "abstract"<br>
   * .. .. . | %06 "synchronized"<br>
   * .. .. . | %07 "native"<br>
   * .. .. . | %08 "transient"<br>
   * .. .. . | %09 "volatile"<br>
   * .. .. . | %10 "strictfp"<br>
   * .. .. . | %11 Annotation() ) )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Modifiers n, final A argu) {
    // f0 -> ( ( %00 "public"
    // .. .. . | %01 "static"
    // .. .. . | %02 "protected"
    // .. .. . | %03 "private"
    // .. .. . | %04 "final"
    // .. .. . | %05 "abstract"
    // .. .. . | %06 "synchronized"
    // .. .. . | %07 "native"
    // .. .. . | %08 "transient"
    // .. .. . | %09 "volatile"
    // .. .. . | %10 "strictfp"
    // .. .. . | %11 Annotation() ) )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode n0Mi = n0.elementAt(i);
        final NodeChoice n0MiC = (NodeChoice) n0Mi;
        final INode n0MiCH = n0MiC.choice;
        switch (n0MiC.which) {
          case 0:
            // %00 "public"
            n0MiCH.accept(this, argu);
            break;
          case 1:
            // %01 "static"
            n0MiCH.accept(this, argu);
            break;
          case 2:
            // %02 "protected"
            n0MiCH.accept(this, argu);
            break;
          case 3:
            // %03 "private"
            n0MiCH.accept(this, argu);
            break;
          case 4:
            // %04 "final"
            n0MiCH.accept(this, argu);
            break;
          case 5:
            // %05 "abstract"
            n0MiCH.accept(this, argu);
            break;
          case 6:
            // %06 "synchronized"
            n0MiCH.accept(this, argu);
            break;
          case 7:
            // %07 "native"
            n0MiCH.accept(this, argu);
            break;
          case 8:
            // %08 "transient"
            n0MiCH.accept(this, argu);
            break;
          case 9:
            // %09 "volatile"
            n0MiCH.accept(this, argu);
            break;
          case 10:
            // %10 "strictfp"
            n0MiCH.accept(this, argu);
            break;
          case 11:
            // %11 Annotation()
            n0MiCH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
      }
    }
  }

  /**
   * Visits a {@link TypeDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 ";"<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration() )<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final TypeDeclaration n, final A argu) {
    // f0 -> . %0 ";"
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 AnnotationTypeDeclaration() )
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 ";"
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 #0 Modifiers()
        // .. #1 ( &0 ClassOrInterfaceDeclaration()
        // .. .. | &1 EnumDeclaration()
        // .. .. | &2 AnnotationTypeDeclaration() )
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 Modifiers()
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        n0CHS1A0.accept(this, argu);
        // #1 ( &0 ClassOrInterfaceDeclaration()
        // .. | &1 EnumDeclaration()
        // .. | &2 AnnotationTypeDeclaration() )
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        final NodeChoice n0CHS1A1C = (NodeChoice) n0CHS1A1;
        final INode n0CHS1A1CH = n0CHS1A1C.choice;
        switch (n0CHS1A1C.which) {
          case 0:
            // &0 ClassOrInterfaceDeclaration()
            n0CHS1A1CH.accept(this, argu);
            break;
          case 1:
            // &1 EnumDeclaration()
            n0CHS1A1CH.accept(this, argu);
            break;
          case 2:
            // &2 AnnotationTypeDeclaration()
            n0CHS1A1CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ClassOrInterfaceDeclaration} node, whose children are the following :
   * <p>
   * f0 -> ( %0 "class"<br>
   * .. .. | %1 "interface" )<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ TypeParameters() ]<br>
   * f3 -> [ ExtendsList() ]<br>
   * f4 -> [ ImplementsList() ]<br>
   * f5 -> ClassOrInterfaceBody()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ClassOrInterfaceDeclaration n, final A argu) {
    // f0 -> ( %0 "class"
    // .. .. | %1 "interface" )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "class"
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 "interface"
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> [ TypeParameters() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this, argu);
    }
    // f3 -> [ ExtendsList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this, argu);
    }
    // f4 -> [ ImplementsList() ]
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      n4.accept(this, argu);
    }
    // f5 -> ClassOrInterfaceBody()
    final ClassOrInterfaceBody n5 = n.f5;
    n5.accept(this, argu);
  }

  /**
   * Visits a {@link ExtendsList} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ExtendsList n, final A argu) {
    // f0 -> "extends"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 ClassOrInterfaceType()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link ImplementsList} node, whose children are the following :
   * <p>
   * f0 -> "implements"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "," #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ImplementsList n, final A argu) {
    // f0 -> "implements"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( #0 "," #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 ClassOrInterfaceType()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link EnumDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "enum"<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ ImplementsList() ]<br>
   * f3 -> EnumBody()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final EnumDeclaration n, final A argu) {
    // f0 -> "enum"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> [ ImplementsList() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this, argu);
    }
    // f3 -> EnumBody()
    final EnumBody n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link EnumBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 EnumConstant()<br>
   * .. .. . #1 ( $0 "," $1 EnumConstant() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> [ #0 ";"<br>
   * .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]<br>
   * f4 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final EnumBody n, final A argu) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ #0 EnumConstant()
    // .. .. . #1 ( $0 "," $1 EnumConstant() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 EnumConstant()
      final INode n1SA0 = n1S.elementAt(0);
      n1SA0.accept(this, argu);
      // #1 ( $0 "," $1 EnumConstant() )*
      final INode n1SA1 = n1S.elementAt(1);
      final NodeListOptional n1SA1T = (NodeListOptional) n1SA1;
      if (n1SA1T.present()) {
        for (int i = 0; i < n1SA1T.size(); i++) {
          final INode n1SA1TMi = n1SA1T.elementAt(i);
          final NodeSequence n1SA1TMiS1 = (NodeSequence) n1SA1TMi;
          // $0 ","
          final INode n1SA1TMiS1A0 = n1SA1TMiS1.elementAt(0);
          n1SA1TMiS1A0.accept(this, argu);
          // $1 EnumConstant()
          final INode n1SA1TMiS1A1 = n1SA1TMiS1.elementAt(1);
          n1SA1TMiS1A1.accept(this, argu);
        }
      }
    }
    // f2 -> [ "," ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this, argu);
    }
    // f3 -> [ #0 ";"
    // .. .. . #1 ( ClassOrInterfaceBodyDeclaration() )* ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S2 = (NodeSequence) n3.node;
      // #0 ";"
      final INode n3S2A0 = n3S2.elementAt(0);
      n3S2A0.accept(this, argu);
      // #1 ( ClassOrInterfaceBodyDeclaration() )*
      final INode n3S2A1 = n3S2.elementAt(1);
      final NodeListOptional n3S2A1T1 = (NodeListOptional) n3S2A1;
      if (n3S2A1T1.present()) {
        for (int i = 0; i < n3S2A1T1.size(); i++) {
          final INode n3S2A1T1Mi = n3S2A1T1.elementAt(i);
          n3S2A1T1Mi.accept(this, argu);
        }
      }
    }
    // f4 -> "}"
    final NodeToken n4 = n.f4;
    n4.accept(this, argu);
  }

  /**
   * Visits a {@link EnumConstant} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> [ Arguments() ]<br>
   * f3 -> [ ClassOrInterfaceBody() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final EnumConstant n, final A argu) {
    // f0 -> Modifiers()
    final Modifiers n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> [ Arguments() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this, argu);
    }
    // f3 -> [ ClassOrInterfaceBody() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this, argu);
    }
  }

  /**
   * Visits a {@link TypeParameters} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeParameter()<br>
   * f2 -> ( #0 "," #1 TypeParameter() )*<br>
   * f3 -> ">"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final TypeParameters n, final A argu) {
    // f0 -> "<"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> TypeParameter()
    final TypeParameter n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( #0 "," #1 TypeParameter() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 TypeParameter()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
      }
    }
    // f3 -> ">"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link TypeParameter} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> [ TypeBound() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final TypeParameter n, final A argu) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ TypeBound() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this, argu);
    }
  }

  /**
   * Visits a {@link TypeBound} node, whose children are the following :
   * <p>
   * f0 -> "extends"<br>
   * f1 -> ClassOrInterfaceType()<br>
   * f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final TypeBound n, final A argu) {
    // f0 -> "extends"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ClassOrInterfaceType()
    final ClassOrInterfaceType n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( #0 "&" #1 ClassOrInterfaceType() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 "&"
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 ClassOrInterfaceType()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link ClassOrInterfaceBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( ClassOrInterfaceBodyDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ClassOrInterfaceBody n, final A argu) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( ClassOrInterfaceBodyDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        n1Mi.accept(this, argu);
      }
    }
    // f2 -> "}"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link ClassOrInterfaceBodyDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 Initializer()<br>
   * .. .. | %1 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &1 EnumDeclaration()<br>
   * .. .. . .. .. | &2 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &3 ConstructorDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration()<br>
   * .. .. . .. .. | &5 MethodDeclaration() )<br>
   * .. .. | %2 ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ClassOrInterfaceBodyDeclaration n, final A argu) {
    // f0 -> . %0 Initializer()
    // .. .. | %1 #0 Modifiers()
    // .. .. . .. #1 ( &0 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &1 EnumDeclaration()
    // .. .. . .. .. | &2 AnnotationTypeDeclaration()
    // .. .. . .. .. | &3 ConstructorDeclaration()
    // .. .. . .. .. | &4 FieldDeclaration()
    // .. .. . .. .. | &5 MethodDeclaration() )
    // .. .. | %2 ";"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 Initializer()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 #0 Modifiers()
        // .. #1 ( &0 ClassOrInterfaceDeclaration()
        // .. .. | &1 EnumDeclaration()
        // .. .. | &2 AnnotationTypeDeclaration()
        // .. .. | &3 ConstructorDeclaration()
        // .. .. | &4 FieldDeclaration()
        // .. .. | &5 MethodDeclaration() )
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 Modifiers()
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        n0CHS1A0.accept(this, argu);
        // #1 ( &0 ClassOrInterfaceDeclaration()
        // .. | &1 EnumDeclaration()
        // .. | &2 AnnotationTypeDeclaration()
        // .. | &3 ConstructorDeclaration()
        // .. | &4 FieldDeclaration()
        // .. | &5 MethodDeclaration() )
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        final NodeChoice n0CHS1A1C = (NodeChoice) n0CHS1A1;
        final INode n0CHS1A1CH = n0CHS1A1C.choice;
        switch (n0CHS1A1C.which) {
          case 0:
            // &0 ClassOrInterfaceDeclaration()
            n0CHS1A1CH.accept(this, argu);
            break;
          case 1:
            // &1 EnumDeclaration()
            n0CHS1A1CH.accept(this, argu);
            break;
          case 2:
            // &2 AnnotationTypeDeclaration()
            n0CHS1A1CH.accept(this, argu);
            break;
          case 3:
            // &3 ConstructorDeclaration()
            n0CHS1A1CH.accept(this, argu);
            break;
          case 4:
            // &4 FieldDeclaration()
            n0CHS1A1CH.accept(this, argu);
            break;
          case 5:
            // &5 MethodDeclaration()
            n0CHS1A1CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 2:
        // %2 ";"
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link FieldDeclaration} node, whose children are the following :
   * <p>
   * f0 -> Type()<br>
   * f1 -> VariableDeclarator()<br>
   * f2 -> ( #0 "," #1 VariableDeclarator() )*<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final FieldDeclaration n, final A argu) {
    // f0 -> Type()
    final Type n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> VariableDeclarator()
    final VariableDeclarator n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( #0 "," #1 VariableDeclarator() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 VariableDeclarator()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
      }
    }
    // f3 -> ";"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link VariableDeclarator} node, whose children are the following :
   * <p>
   * f0 -> VariableDeclaratorId()<br>
   * f1 -> [ #0 "=" #1 VariableInitializer() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final VariableDeclarator n, final A argu) {
    // f0 -> VariableDeclaratorId()
    final VariableDeclaratorId n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ #0 "=" #1 VariableInitializer() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 "="
      final INode n1SA0 = n1S.elementAt(0);
      n1SA0.accept(this, argu);
      // #1 VariableInitializer()
      final INode n1SA1 = n1S.elementAt(1);
      n1SA1.accept(this, argu);
    }
  }

  /**
   * Visits a {@link VariableDeclaratorId} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final VariableDeclaratorId n, final A argu) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "[" #1 "]" )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "["
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 "]"
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link VariableInitializer} node, whose child is the following :
   * <p>
   * f0 -> . %0 ArrayInitializer()<br>
   * .. .. | %1 Expression()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final VariableInitializer n, final A argu) {
    // f0 -> . %0 ArrayInitializer()
    // .. .. | %1 Expression()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 ArrayInitializer()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 Expression()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> [ #0 VariableInitializer()<br>
   * .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]<br>
   * f2 -> [ "," ]<br>
   * f3 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ArrayInitializer n, final A argu) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ #0 VariableInitializer()
    // .. .. . #1 ( $0 "," $1 VariableInitializer() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 VariableInitializer()
      final INode n1SA0 = n1S.elementAt(0);
      n1SA0.accept(this, argu);
      // #1 ( $0 "," $1 VariableInitializer() )*
      final INode n1SA1 = n1S.elementAt(1);
      final NodeListOptional n1SA1T = (NodeListOptional) n1SA1;
      if (n1SA1T.present()) {
        for (int i = 0; i < n1SA1T.size(); i++) {
          final INode n1SA1TMi = n1SA1T.elementAt(i);
          final NodeSequence n1SA1TMiS1 = (NodeSequence) n1SA1TMi;
          // $0 ","
          final INode n1SA1TMiS1A0 = n1SA1TMiS1.elementAt(0);
          n1SA1TMiS1A0.accept(this, argu);
          // $1 VariableInitializer()
          final INode n1SA1TMiS1A1 = n1SA1TMiS1.elementAt(1);
          n1SA1TMiS1A1.accept(this, argu);
        }
      }
    }
    // f2 -> [ "," ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this, argu);
    }
    // f3 -> "}"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link MethodDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> ResultType()<br>
   * f2 -> MethodDeclarator()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> ( %0 Block()<br>
   * .. .. | %1 ";" )<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final MethodDeclaration n, final A argu) {
    // f0 -> [ TypeParameters() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this, argu);
    }
    // f1 -> ResultType()
    final ResultType n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> MethodDeclarator()
    final MethodDeclarator n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> [ #0 "throws" #1 NameList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S = (NodeSequence) n3.node;
      // #0 "throws"
      final INode n3SA0 = n3S.elementAt(0);
      n3SA0.accept(this, argu);
      // #1 NameList()
      final INode n3SA1 = n3S.elementAt(1);
      n3SA1.accept(this, argu);
    }
    // f4 -> ( %0 Block()
    // .. .. | %1 ";" )
    final NodeChoice n4 = n.f4;
    final NodeChoice n4C = n4;
    final INode n4CH = n4C.choice;
    switch (n4C.which) {
      case 0:
        // %0 Block()
        n4CH.accept(this, argu);
        break;
      case 1:
        // %1 ";"
        n4CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link MethodDeclarator} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> FormalParameters()<br>
   * f2 -> ( #0 "[" #1 "]" )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final MethodDeclarator n, final A argu) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> FormalParameters()
    final FormalParameters n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( #0 "[" #1 "]" )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 "["
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 "]"
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link FormalParameters} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ #0 FormalParameter()<br>
   * .. .. . #1 ( $0 "," $1 FormalParameter() )* ]<br>
   * f2 -> ")"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final FormalParameters n, final A argu) {
    // f0 -> "("
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ #0 FormalParameter()
    // .. .. . #1 ( $0 "," $1 FormalParameter() )* ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 FormalParameter()
      final INode n1SA0 = n1S.elementAt(0);
      n1SA0.accept(this, argu);
      // #1 ( $0 "," $1 FormalParameter() )*
      final INode n1SA1 = n1S.elementAt(1);
      final NodeListOptional n1SA1T = (NodeListOptional) n1SA1;
      if (n1SA1T.present()) {
        for (int i = 0; i < n1SA1T.size(); i++) {
          final INode n1SA1TMi = n1SA1T.elementAt(i);
          final NodeSequence n1SA1TMiS1 = (NodeSequence) n1SA1TMi;
          // $0 ","
          final INode n1SA1TMiS1A0 = n1SA1TMiS1.elementAt(0);
          n1SA1TMiS1A0.accept(this, argu);
          // $1 FormalParameter()
          final INode n1SA1TMiS1A1 = n1SA1TMiS1.elementAt(1);
          n1SA1TMiS1A1.accept(this, argu);
        }
      }
    }
    // f2 -> ")"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link FormalParameter} node, whose children are the following :
   * <p>
   * f0 -> Modifiers()<br>
   * f1 -> Type()<br>
   * f2 -> [ "..." ]<br>
   * f3 -> VariableDeclaratorId()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final FormalParameter n, final A argu) {
    // f0 -> Modifiers()
    final Modifiers n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Type()
    final Type n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> [ "..." ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      n2.accept(this, argu);
    }
    // f3 -> VariableDeclaratorId()
    final VariableDeclaratorId n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link ConstructorDeclaration} node, whose children are the following :
   * <p>
   * f0 -> [ TypeParameters() ]<br>
   * f1 -> <IDENTIFIER><br>
   * f2 -> FormalParameters()<br>
   * f3 -> [ #0 "throws" #1 NameList() ]<br>
   * f4 -> "{"<br>
   * f5 -> [ ExplicitConstructorInvocation() ]<br>
   * f6 -> ( BlockStatement() )*<br>
   * f7 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ConstructorDeclaration n, final A argu) {
    // f0 -> [ TypeParameters() ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this, argu);
    }
    // f1 -> <IDENTIFIER>
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> FormalParameters()
    final FormalParameters n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> [ #0 "throws" #1 NameList() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S = (NodeSequence) n3.node;
      // #0 "throws"
      final INode n3SA0 = n3S.elementAt(0);
      n3SA0.accept(this, argu);
      // #1 NameList()
      final INode n3SA1 = n3S.elementAt(1);
      n3SA1.accept(this, argu);
    }
    // f4 -> "{"
    final NodeToken n4 = n.f4;
    n4.accept(this, argu);
    // f5 -> [ ExplicitConstructorInvocation() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      n5.accept(this, argu);
    }
    // f6 -> ( BlockStatement() )*
    final NodeListOptional n6 = n.f6;
    if (n6.present()) {
      for (int i = 0; i < n6.size(); i++) {
        final INode n6Mi = n6.elementAt(i);
        n6Mi.accept(this, argu);
      }
    }
    // f7 -> "}"
    final NodeToken n7 = n.f7;
    n7.accept(this, argu);
  }

  /**
   * Visits a {@link ExplicitConstructorInvocation} node, whose child is the following :
   * <p>
   * f0 -> ( %0 #0 [ $0 "<" $1 ReferenceType()<br>
   * .. .. . .. .. . $2 ( ?0 "," ?1 ReferenceType() )*<br>
   * .. .. . .. .. . $3 ">" ]<br>
   * .. .. . .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"<br>
   * .. .. . .. .. | &1 $0 "super" $1 Arguments() $2 ";" )<br>
   * .. .. | %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" ) )<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ExplicitConstructorInvocation n, final A argu) {
    // f0 -> ( %0 #0 [ $0 "<" $1 ReferenceType()
    // .. .. . .. .. . $2 ( ?0 "," ?1 ReferenceType() )*
    // .. .. . .. .. . $3 ">" ]
    // .. .. . .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"
    // .. .. . .. .. | &1 $0 "super" $1 Arguments() $2 ";" )
    // .. .. | %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" ) )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 [ $0 "<" $1 ReferenceType()
        // .. .. . $2 ( ?0 "," ?1 ReferenceType() )*
        // .. .. . $3 ">" ]
        // .. #1 ( &0 $0 "this" $1 Arguments() $2 ";"
        // .. .. | &1 $0 "super" $1 Arguments() $2 ";" )
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 [ $0 "<" $1 ReferenceType()
        // .. . $2 ( ?0 "," ?1 ReferenceType() )*
        // .. . $3 ">" ]
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        final NodeOptional n0CHS0A0P = (NodeOptional) n0CHS0A0;
        if (n0CHS0A0P.present()) {
          final NodeSequence n0CHS0A0PS1 = (NodeSequence) n0CHS0A0P.node;
          // $0 "<"
          final INode n0CHS0A0PS1A0 = n0CHS0A0PS1.elementAt(0);
          n0CHS0A0PS1A0.accept(this, argu);
          // $1 ReferenceType()
          final INode n0CHS0A0PS1A1 = n0CHS0A0PS1.elementAt(1);
          n0CHS0A0PS1A1.accept(this, argu);
          // $2 ( ?0 "," ?1 ReferenceType() )*
          final INode n0CHS0A0PS1A2 = n0CHS0A0PS1.elementAt(2);
          final NodeListOptional n0CHS0A0PS1A2T = (NodeListOptional) n0CHS0A0PS1A2;
          if (n0CHS0A0PS1A2T.present()) {
            for (int i = 0; i < n0CHS0A0PS1A2T.size(); i++) {
              final INode n0CHS0A0PS1A2TMi = n0CHS0A0PS1A2T.elementAt(i);
              final NodeSequence n0CHS0A0PS1A2TMiS2 = (NodeSequence) n0CHS0A0PS1A2TMi;
              // ?0 ","
              final INode n0CHS0A0PS1A2TMiS2A0 = n0CHS0A0PS1A2TMiS2.elementAt(0);
              n0CHS0A0PS1A2TMiS2A0.accept(this, argu);
              // ?1 ReferenceType()
              final INode n0CHS0A0PS1A2TMiS2A1 = n0CHS0A0PS1A2TMiS2.elementAt(1);
              n0CHS0A0PS1A2TMiS2A1.accept(this, argu);
            }
          }
          // $3 ">"
          final INode n0CHS0A0PS1A3 = n0CHS0A0PS1.elementAt(3);
          n0CHS0A0PS1A3.accept(this, argu);
        }
        // #1 ( &0 $0 "this" $1 Arguments() $2 ";"
        // .. | &1 $0 "super" $1 Arguments() $2 ";" )
        final INode n0CHSA1 = n0CHS.elementAt(1);
        final NodeChoice n0CHSA1C = (NodeChoice) n0CHSA1;
        final INode n0CHSA1CH = n0CHSA1C.choice;
        switch (n0CHSA1C.which) {
          case 0:
            // &0 $0 "this" $1 Arguments() $2 ";"
            final NodeSequence n0CHSA1CHS3 = (NodeSequence) n0CHSA1CH;
            // $0 "this"
            final INode n0CHSA1CHS30A0 = n0CHSA1CHS3.elementAt(0);
            n0CHSA1CHS30A0.accept(this, argu);
            // $1 Arguments()
            final INode n0CHSA1CHS30A1 = n0CHSA1CHS3.elementAt(1);
            n0CHSA1CHS30A1.accept(this, argu);
            // $2 ";"
            final INode n0CHSA1CHS30A2 = n0CHSA1CHS3.elementAt(2);
            n0CHSA1CHS30A2.accept(this, argu);
            break;
          case 1:
            // &1 $0 "super" $1 Arguments() $2 ";"
            final NodeSequence n0CHSA1CHS4 = (NodeSequence) n0CHSA1CH;
            // $0 "super"
            final INode n0CHSA1CHS41A0 = n0CHSA1CHS4.elementAt(0);
            n0CHSA1CHS41A0.accept(this, argu);
            // $1 Arguments()
            final INode n0CHSA1CHS41A1 = n0CHSA1CHS4.elementAt(1);
            n0CHSA1CHS41A1.accept(this, argu);
            // $2 ";"
            final INode n0CHSA1CHS41A2 = n0CHSA1CHS4.elementAt(2);
            n0CHSA1CHS41A2.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 1:
        // %1 ( #0 PrimaryExpression() #1 "." #2 "super" #3 Arguments() #4 ";" )
        final NodeSequence n0CHS5 = (NodeSequence) n0CH;
        // #0 PrimaryExpression()
        final INode n0CHS5A0 = n0CHS5.elementAt(0);
        n0CHS5A0.accept(this, argu);
        // #1 "."
        final INode n0CHS5A1 = n0CHS5.elementAt(1);
        n0CHS5A1.accept(this, argu);
        // #2 "super"
        final INode n0CHS5A2 = n0CHS5.elementAt(2);
        n0CHS5A2.accept(this, argu);
        // #3 Arguments()
        final INode n0CHS5A3 = n0CHS5.elementAt(3);
        n0CHS5A3.accept(this, argu);
        // #4 ";"
        final INode n0CHS5A4 = n0CHS5.elementAt(4);
        n0CHS5A4.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link Initializer} node, whose children are the following :
   * <p>
   * f0 -> [ "static" ]<br>
   * f1 -> Block()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Initializer n, final A argu) {
    // f0 -> [ "static" ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      n0.accept(this, argu);
    }
    // f1 -> Block()
    final Block n1 = n.f1;
    n1.accept(this, argu);
  }

  /**
   * Visits a {@link Type} node, whose child is the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 PrimitiveType()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Type n, final A argu) {
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 PrimitiveType()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 ReferenceType()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 PrimitiveType()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ReferenceType} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 PrimitiveType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )+<br>
   * .. .. | %1 #0 ClassOrInterfaceType()<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ReferenceType n, final A argu) {
    // f0 -> . %0 #0 PrimitiveType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )+
    // .. .. | %1 #0 ClassOrInterfaceType()
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 PrimitiveType()
        // .. #1 ( $0 "[" $1 "]" )+
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 PrimitiveType()
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 ( $0 "[" $1 "]" )+
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        final NodeList n0CHS0A1L = (NodeList) n0CHS0A1;
        for (int i = 0; i < n0CHS0A1L.size(); i++) {
          final INode n0CHS0A1LEi = n0CHS0A1L.elementAt(i);
          final NodeSequence n0CHS0A1LEiS1 = (NodeSequence) n0CHS0A1LEi;
          // $0 "["
          final INode n0CHS0A1LEiS1A0 = n0CHS0A1LEiS1.elementAt(0);
          n0CHS0A1LEiS1A0.accept(this, argu);
          // $1 "]"
          final INode n0CHS0A1LEiS1A1 = n0CHS0A1LEiS1.elementAt(1);
          n0CHS0A1LEiS1A1.accept(this, argu);
        }
        break;
      case 1:
        // %1 #0 ClassOrInterfaceType()
        // .. #1 ( $0 "[" $1 "]" )*
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 ClassOrInterfaceType()
        final INode n0CHS21A0 = n0CHS2.elementAt(0);
        n0CHS21A0.accept(this, argu);
        // #1 ( $0 "[" $1 "]" )*
        final INode n0CHS21A1 = n0CHS2.elementAt(1);
        final NodeListOptional n0CHS21A1T = (NodeListOptional) n0CHS21A1;
        if (n0CHS21A1T.present()) {
          for (int i = 0; i < n0CHS21A1T.size(); i++) {
            final INode n0CHS21A1TMi = n0CHS21A1T.elementAt(i);
            final NodeSequence n0CHS21A1TMiS3 = (NodeSequence) n0CHS21A1TMi;
            // $0 "["
            final INode n0CHS21A1TMiS3A0 = n0CHS21A1TMiS3.elementAt(0);
            n0CHS21A1TMiS3A0.accept(this, argu);
            // $1 "]"
            final INode n0CHS21A1TMiS3A1 = n0CHS21A1TMiS3.elementAt(1);
            n0CHS21A1TMiS3A1.accept(this, argu);
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ClassOrInterfaceType} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> [ TypeArguments() ]<br>
   * f2 -> ( #0 "." #1 <IDENTIFIER><br>
   * .. .. . #2 [ TypeArguments() ] )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ClassOrInterfaceType n, final A argu) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ TypeArguments() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this, argu);
    }
    // f2 -> ( #0 "." #1 <IDENTIFIER>
    // .. .. . #2 [ TypeArguments() ] )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 "."
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 <IDENTIFIER>
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
        // #2 [ TypeArguments() ]
        final INode n2MiSA2 = n2MiS.elementAt(2);
        final NodeOptional n2MiSA2P = (NodeOptional) n2MiSA2;
        if (n2MiSA2P.present()) {
          n2MiSA2P.accept(this, argu);
        }
      }
    }
  }

  /**
   * Visits a {@link TypeArguments} node, whose children are the following :
   * <p>
   * f0 -> "<"<br>
   * f1 -> TypeArgument()<br>
   * f2 -> ( #0 "," #1 TypeArgument() )*<br>
   * f3 -> ">"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final TypeArguments n, final A argu) {
    // f0 -> "<"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> TypeArgument()
    final TypeArgument n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( #0 "," #1 TypeArgument() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 TypeArgument()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
      }
    }
    // f3 -> ">"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link TypeArgument} node, whose child is the following :
   * <p>
   * f0 -> . %0 ReferenceType()<br>
   * .. .. | %1 #0 "?"<br>
   * .. .. . .. #1 [ WildcardBounds() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final TypeArgument n, final A argu) {
    // f0 -> . %0 ReferenceType()
    // .. .. | %1 #0 "?"
    // .. .. . .. #1 [ WildcardBounds() ]
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 ReferenceType()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 #0 "?"
        // .. #1 [ WildcardBounds() ]
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "?"
        final INode n0CHS1A0 = n0CHS.elementAt(0);
        n0CHS1A0.accept(this, argu);
        // #1 [ WildcardBounds() ]
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        final NodeOptional n0CHS1A1P = (NodeOptional) n0CHS1A1;
        if (n0CHS1A1P.present()) {
          n0CHS1A1P.accept(this, argu);
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link WildcardBounds} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "extends" #1 ReferenceType()<br>
   * .. .. | %1 #0 "super" #1 ReferenceType()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final WildcardBounds n, final A argu) {
    // f0 -> . %0 #0 "extends" #1 ReferenceType()
    // .. .. | %1 #0 "super" #1 ReferenceType()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "extends" #1 ReferenceType()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "extends"
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 ReferenceType()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        n0CHS0A1.accept(this, argu);
        break;
      case 1:
        // %1 #0 "super" #1 ReferenceType()
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "super"
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        n0CHS11A0.accept(this, argu);
        // #1 ReferenceType()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        n0CHS11A1.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PrimitiveType} node, whose child is the following :
   * <p>
   * f0 -> . %0 "boolean"<br>
   * .. .. | %1 "char"<br>
   * .. .. | %2 "byte"<br>
   * .. .. | %3 "short"<br>
   * .. .. | %4 "int"<br>
   * .. .. | %5 "long"<br>
   * .. .. | %6 "float"<br>
   * .. .. | %7 "double"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final PrimitiveType n, final A argu) {
    // f0 -> . %0 "boolean"
    // .. .. | %1 "char"
    // .. .. | %2 "byte"
    // .. .. | %3 "short"
    // .. .. | %4 "int"
    // .. .. | %5 "long"
    // .. .. | %6 "float"
    // .. .. | %7 "double"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "boolean"
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 "char"
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 "byte"
        n0CH.accept(this, argu);
        break;
      case 3:
        // %3 "short"
        n0CH.accept(this, argu);
        break;
      case 4:
        // %4 "int"
        n0CH.accept(this, argu);
        break;
      case 5:
        // %5 "long"
        n0CH.accept(this, argu);
        break;
      case 6:
        // %6 "float"
        n0CH.accept(this, argu);
        break;
      case 7:
        // %7 "double"
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ResultType} node, whose child is the following :
   * <p>
   * f0 -> ( %0 "void"<br>
   * .. .. | %1 Type() )<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ResultType n, final A argu) {
    // f0 -> ( %0 "void"
    // .. .. | %1 Type() )
    final NodeChoice n0 = n.f0;
    final NodeChoice n0C = n0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "void"
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 Type()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link Name} node, whose children are the following :
   * <p>
   * f0 -> JavaIdentifier()<br>
   * f1 -> ( #0 "." #1 JavaIdentifier() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Name n, final A argu) {
    // f0 -> JavaIdentifier()
    final JavaIdentifier n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "." #1 JavaIdentifier() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "."
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 JavaIdentifier()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link NameList} node, whose children are the following :
   * <p>
   * f0 -> Name()<br>
   * f1 -> ( #0 "," #1 Name() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NameList n, final A argu) {
    // f0 -> Name()
    final Name n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "," #1 Name() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ","
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 Name()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link Expression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalExpression()<br>
   * f1 -> [ #0 AssignmentOperator() #1 Expression() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Expression n, final A argu) {
    // f0 -> ConditionalExpression()
    final ConditionalExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ #0 AssignmentOperator() #1 Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 AssignmentOperator()
      final INode n1SA0 = n1S.elementAt(0);
      n1SA0.accept(this, argu);
      // #1 Expression()
      final INode n1SA1 = n1S.elementAt(1);
      n1SA1.accept(this, argu);
    }
  }

  /**
   * Visits a {@link AssignmentOperator} node, whose child is the following :
   * <p>
   * f0 -> . %00 "="<br>
   * .. .. | %01 "*="<br>
   * .. .. | %02 "/="<br>
   * .. .. | %03 "%="<br>
   * .. .. | %04 "+="<br>
   * .. .. | %05 "-="<br>
   * .. .. | %06 "<<="<br>
   * .. .. | %07 ">>="<br>
   * .. .. | %08 ">>>="<br>
   * .. .. | %09 "&="<br>
   * .. .. | %10 "^="<br>
   * .. .. | %11 "|="<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final AssignmentOperator n, final A argu) {
    // f0 -> . %00 "="
    // .. .. | %01 "*="
    // .. .. | %02 "/="
    // .. .. | %03 "%="
    // .. .. | %04 "+="
    // .. .. | %05 "-="
    // .. .. | %06 "<<="
    // .. .. | %07 ">>="
    // .. .. | %08 ">>>="
    // .. .. | %09 "&="
    // .. .. | %10 "^="
    // .. .. | %11 "|="
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %00 "="
        n0CH.accept(this, argu);
        break;
      case 1:
        // %01 "*="
        n0CH.accept(this, argu);
        break;
      case 2:
        // %02 "/="
        n0CH.accept(this, argu);
        break;
      case 3:
        // %03 "%="
        n0CH.accept(this, argu);
        break;
      case 4:
        // %04 "+="
        n0CH.accept(this, argu);
        break;
      case 5:
        // %05 "-="
        n0CH.accept(this, argu);
        break;
      case 6:
        // %06 "<<="
        n0CH.accept(this, argu);
        break;
      case 7:
        // %07 ">>="
        n0CH.accept(this, argu);
        break;
      case 8:
        // %08 ">>>="
        n0CH.accept(this, argu);
        break;
      case 9:
        // %09 "&="
        n0CH.accept(this, argu);
        break;
      case 10:
        // %10 "^="
        n0CH.accept(this, argu);
        break;
      case 11:
        // %11 "|="
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ConditionalExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalOrExpression()<br>
   * f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ConditionalExpression n, final A argu) {
    // f0 -> ConditionalOrExpression()
    final ConditionalOrExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ #0 "?" #1 Expression() #2 ":" #3 Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 "?"
      final INode n1SA0 = n1S.elementAt(0);
      n1SA0.accept(this, argu);
      // #1 Expression()
      final INode n1SA1 = n1S.elementAt(1);
      n1SA1.accept(this, argu);
      // #2 ":"
      final INode n1SA2 = n1S.elementAt(2);
      n1SA2.accept(this, argu);
      // #3 Expression()
      final INode n1SA3 = n1S.elementAt(3);
      n1SA3.accept(this, argu);
    }
  }

  /**
   * Visits a {@link ConditionalOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ConditionalAndExpression()<br>
   * f1 -> ( #0 "||" #1 ConditionalAndExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ConditionalOrExpression n, final A argu) {
    // f0 -> ConditionalAndExpression()
    final ConditionalAndExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "||" #1 ConditionalAndExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "||"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 ConditionalAndExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link ConditionalAndExpression} node, whose children are the following :
   * <p>
   * f0 -> InclusiveOrExpression()<br>
   * f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ConditionalAndExpression n, final A argu) {
    // f0 -> InclusiveOrExpression()
    final InclusiveOrExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "&&" #1 InclusiveOrExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "&&"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 InclusiveOrExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link InclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> ExclusiveOrExpression()<br>
   * f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final InclusiveOrExpression n, final A argu) {
    // f0 -> ExclusiveOrExpression()
    final ExclusiveOrExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "|" #1 ExclusiveOrExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "|"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 ExclusiveOrExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link ExclusiveOrExpression} node, whose children are the following :
   * <p>
   * f0 -> AndExpression()<br>
   * f1 -> ( #0 "^" #1 AndExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ExclusiveOrExpression n, final A argu) {
    // f0 -> AndExpression()
    final AndExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "^" #1 AndExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "^"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 AndExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link AndExpression} node, whose children are the following :
   * <p>
   * f0 -> EqualityExpression()<br>
   * f1 -> ( #0 "&" #1 EqualityExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final AndExpression n, final A argu) {
    // f0 -> EqualityExpression()
    final EqualityExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "&" #1 EqualityExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 "&"
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 EqualityExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link EqualityExpression} node, whose children are the following :
   * <p>
   * f0 -> InstanceOfExpression()<br>
   * f1 -> ( #0 ( %0 "=="<br>
   * .. .. . .. | %1 "!=" )<br>
   * .. .. . #1 InstanceOfExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final EqualityExpression n, final A argu) {
    // f0 -> InstanceOfExpression()
    final InstanceOfExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 ( %0 "=="
    // .. .. . .. | %1 "!=" )
    // .. .. . #1 InstanceOfExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "=="
        // .. | %1 "!=" )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "=="
            n1MiSA0CH.accept(this, argu);
            break;
          case 1:
            // %1 "!="
            n1MiSA0CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 InstanceOfExpression()
        final INode n1MiS1A1 = n1MiS.elementAt(1);
        n1MiS1A1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link InstanceOfExpression} node, whose children are the following :
   * <p>
   * f0 -> RelationalExpression()<br>
   * f1 -> [ #0 "instanceof" #1 Type() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final InstanceOfExpression n, final A argu) {
    // f0 -> RelationalExpression()
    final RelationalExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ #0 "instanceof" #1 Type() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeSequence n1S = (NodeSequence) n1.node;
      // #0 "instanceof"
      final INode n1SA0 = n1S.elementAt(0);
      n1SA0.accept(this, argu);
      // #1 Type()
      final INode n1SA1 = n1S.elementAt(1);
      n1SA1.accept(this, argu);
    }
  }

  /**
   * Visits a {@link RelationalExpression} node, whose children are the following :
   * <p>
   * f0 -> ShiftExpression()<br>
   * f1 -> ( #0 ( %0 "<"<br>
   * .. .. . .. | %1 ">"<br>
   * .. .. . .. | %2 "<="<br>
   * .. .. . .. | %3 ">=" )<br>
   * .. .. . #1 ShiftExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final RelationalExpression n, final A argu) {
    // f0 -> ShiftExpression()
    final ShiftExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 ( %0 "<"
    // .. .. . .. | %1 ">"
    // .. .. . .. | %2 "<="
    // .. .. . .. | %3 ">=" )
    // .. .. . #1 ShiftExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "<"
        // .. | %1 ">"
        // .. | %2 "<="
        // .. | %3 ">=" )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "<"
            n1MiSA0CH.accept(this, argu);
            break;
          case 1:
            // %1 ">"
            n1MiSA0CH.accept(this, argu);
            break;
          case 2:
            // %2 "<="
            n1MiSA0CH.accept(this, argu);
            break;
          case 3:
            // %3 ">="
            n1MiSA0CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 ShiftExpression()
        final INode n1MiS3A1 = n1MiS.elementAt(1);
        n1MiS3A1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link ShiftExpression} node, whose children are the following :
   * <p>
   * f0 -> AdditiveExpression()<br>
   * f1 -> ( #0 ( %0 "<<"<br>
   * .. .. . .. | %1 RUnsignedShift()<br>
   * .. .. . .. | %2 RSignedShift() )<br>
   * .. .. . #1 AdditiveExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ShiftExpression n, final A argu) {
    // f0 -> AdditiveExpression()
    final AdditiveExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 ( %0 "<<"
    // .. .. . .. | %1 RUnsignedShift()
    // .. .. . .. | %2 RSignedShift() )
    // .. .. . #1 AdditiveExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "<<"
        // .. | %1 RUnsignedShift()
        // .. | %2 RSignedShift() )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "<<"
            n1MiSA0CH.accept(this, argu);
            break;
          case 1:
            // %1 RUnsignedShift()
            n1MiSA0CH.accept(this, argu);
            break;
          case 2:
            // %2 RSignedShift()
            n1MiSA0CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 AdditiveExpression()
        final INode n1MiS2A1 = n1MiS.elementAt(1);
        n1MiS2A1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link RSignedShift} node, whose child is the following :
   * <p>
   * f0 -> ">>"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final RSignedShift n, final A argu) {
    // f0 -> ">>"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
  }

  /**
   * Visits a {@link RUnsignedShift} node, whose child is the following :
   * <p>
   * f0 -> ">>>"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final RUnsignedShift n, final A argu) {
    // f0 -> ">>>"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
  }

  /**
   * Visits a {@link AdditiveExpression} node, whose children are the following :
   * <p>
   * f0 -> MultiplicativeExpression()<br>
   * f1 -> ( #0 ( %0 "+"<br>
   * .. .. . .. | %1 "-" )<br>
   * .. .. . #1 MultiplicativeExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final AdditiveExpression n, final A argu) {
    // f0 -> MultiplicativeExpression()
    final MultiplicativeExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 ( %0 "+"
    // .. .. . .. | %1 "-" )
    // .. .. . #1 MultiplicativeExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "+"
        // .. | %1 "-" )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "+"
            n1MiSA0CH.accept(this, argu);
            break;
          case 1:
            // %1 "-"
            n1MiSA0CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 MultiplicativeExpression()
        final INode n1MiS1A1 = n1MiS.elementAt(1);
        n1MiS1A1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link MultiplicativeExpression} node, whose children are the following :
   * <p>
   * f0 -> UnaryExpression()<br>
   * f1 -> ( #0 ( %0 "*"<br>
   * .. .. . .. | %1 "/"<br>
   * .. .. . .. | %2 "%" )<br>
   * .. .. . #1 UnaryExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final MultiplicativeExpression n, final A argu) {
    // f0 -> UnaryExpression()
    final UnaryExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 ( %0 "*"
    // .. .. . .. | %1 "/"
    // .. .. . .. | %2 "%" )
    // .. .. . #1 UnaryExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ( %0 "*"
        // .. | %1 "/"
        // .. | %2 "%" )
        final INode n1MiSA0 = n1MiS.elementAt(0);
        final NodeChoice n1MiSA0C = (NodeChoice) n1MiSA0;
        final INode n1MiSA0CH = n1MiSA0C.choice;
        switch (n1MiSA0C.which) {
          case 0:
            // %0 "*"
            n1MiSA0CH.accept(this, argu);
            break;
          case 1:
            // %1 "/"
            n1MiSA0CH.accept(this, argu);
            break;
          case 2:
            // %2 "%"
            n1MiSA0CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 UnaryExpression()
        final INode n1MiS2A1 = n1MiS.elementAt(1);
        n1MiS2A1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link UnaryExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "+"<br>
   * .. .. . .. .. | &1 "-" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 PreIncrementExpression()<br>
   * .. .. | %2 PreDecrementExpression()<br>
   * .. .. | %3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final UnaryExpression n, final A argu) {
    // f0 -> . %0 #0 ( &0 "+"
    // .. .. . .. .. | &1 "-" )
    // .. .. . .. #1 UnaryExpression()
    // .. .. | %1 PreIncrementExpression()
    // .. .. | %2 PreDecrementExpression()
    // .. .. | %3 UnaryExpressionNotPlusMinus()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 ( &0 "+"
        // .. .. | &1 "-" )
        // .. #1 UnaryExpression()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 ( &0 "+"
        // .. | &1 "-" )
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        final NodeChoice n0CHS0A0C = (NodeChoice) n0CHS0A0;
        final INode n0CHS0A0CH = n0CHS0A0C.choice;
        switch (n0CHS0A0C.which) {
          case 0:
            // &0 "+"
            n0CHS0A0CH.accept(this, argu);
            break;
          case 1:
            // &1 "-"
            n0CHS0A0CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 UnaryExpression()
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        n0CHS1A1.accept(this, argu);
        break;
      case 1:
        // %1 PreIncrementExpression()
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 PreDecrementExpression()
        n0CH.accept(this, argu);
        break;
      case 3:
        // %3 UnaryExpressionNotPlusMinus()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PreIncrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "++"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final PreIncrementExpression n, final A argu) {
    // f0 -> "++"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> PrimaryExpression()
    final PrimaryExpression n1 = n.f1;
    n1.accept(this, argu);
  }

  /**
   * Visits a {@link PreDecrementExpression} node, whose children are the following :
   * <p>
   * f0 -> "--"<br>
   * f1 -> PrimaryExpression()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final PreDecrementExpression n, final A argu) {
    // f0 -> "--"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> PrimaryExpression()
    final PrimaryExpression n1 = n.f1;
    n1.accept(this, argu);
  }

  /**
   * Visits a {@link UnaryExpressionNotPlusMinus} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!" )<br>
   * .. .. . .. #1 UnaryExpression()<br>
   * .. .. | %1 CastExpression()<br>
   * .. .. | %2 PostfixExpression()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final UnaryExpressionNotPlusMinus n, final A argu) {
    // f0 -> . %0 #0 ( &0 "~"
    // .. .. . .. .. | &1 "!" )
    // .. .. . .. #1 UnaryExpression()
    // .. .. | %1 CastExpression()
    // .. .. | %2 PostfixExpression()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 ( &0 "~"
        // .. .. | &1 "!" )
        // .. #1 UnaryExpression()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 ( &0 "~"
        // .. | &1 "!" )
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        final NodeChoice n0CHS0A0C = (NodeChoice) n0CHS0A0;
        final INode n0CHS0A0CH = n0CHS0A0C.choice;
        switch (n0CHS0A0C.which) {
          case 0:
            // &0 "~"
            n0CHS0A0CH.accept(this, argu);
            break;
          case 1:
            // &1 "!"
            n0CHS0A0CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        // #1 UnaryExpression()
        final INode n0CHS1A1 = n0CHS.elementAt(1);
        n0CHS1A1.accept(this, argu);
        break;
      case 1:
        // %1 CastExpression()
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 PostfixExpression()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link CastLookahead} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 PrimitiveType()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"<br>
   * .. .. | %2 #0 "(" #1 Type() #2 ")"<br>
   * .. .. . .. #3 ( &0 "~"<br>
   * .. .. . .. .. | &1 "!"<br>
   * .. .. . .. .. | &2 "("<br>
   * .. .. . .. .. | &3 <IDENTIFIER><br>
   * .. .. . .. .. | &4 "this"<br>
   * .. .. . .. .. | &5 "super"<br>
   * .. .. . .. .. | &6 "new"<br>
   * .. .. . .. .. | &7 Literal() )<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final CastLookahead n, final A argu) {
    // f0 -> . %0 #0 "(" #1 PrimitiveType()
    // .. .. | %1 #0 "(" #1 Type() #2 "[" #3 "]"
    // .. .. | %2 #0 "(" #1 Type() #2 ")"
    // .. .. . .. #3 ( &0 "~"
    // .. .. . .. .. | &1 "!"
    // .. .. . .. .. | &2 "("
    // .. .. . .. .. | &3 <IDENTIFIER>
    // .. .. . .. .. | &4 "this"
    // .. .. . .. .. | &5 "super"
    // .. .. . .. .. | &6 "new"
    // .. .. . .. .. | &7 Literal() )
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "(" #1 PrimitiveType()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 PrimitiveType()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        n0CHS0A1.accept(this, argu);
        break;
      case 1:
        // %1 #0 "(" #1 Type() #2 "[" #3 "]"
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        n0CHS11A0.accept(this, argu);
        // #1 Type()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        n0CHS11A1.accept(this, argu);
        // #2 "["
        final INode n0CHS11A2 = n0CHS1.elementAt(2);
        n0CHS11A2.accept(this, argu);
        // #3 "]"
        final INode n0CHS11A3 = n0CHS1.elementAt(3);
        n0CHS11A3.accept(this, argu);
        break;
      case 2:
        // %2 #0 "(" #1 Type() #2 ")"
        // .. #3 ( &0 "~"
        // .. .. | &1 "!"
        // .. .. | &2 "("
        // .. .. | &3 <IDENTIFIER>
        // .. .. | &4 "this"
        // .. .. | &5 "super"
        // .. .. | &6 "new"
        // .. .. | &7 Literal() )
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS22A0 = n0CHS2.elementAt(0);
        n0CHS22A0.accept(this, argu);
        // #1 Type()
        final INode n0CHS22A1 = n0CHS2.elementAt(1);
        n0CHS22A1.accept(this, argu);
        // #2 ")"
        final INode n0CHS22A2 = n0CHS2.elementAt(2);
        n0CHS22A2.accept(this, argu);
        // #3 ( &0 "~"
        // .. | &1 "!"
        // .. | &2 "("
        // .. | &3 <IDENTIFIER>
        // .. | &4 "this"
        // .. | &5 "super"
        // .. | &6 "new"
        // .. | &7 Literal() )
        final INode n0CHS22A3 = n0CHS2.elementAt(3);
        final NodeChoice n0CHS22A3C = (NodeChoice) n0CHS22A3;
        final INode n0CHS22A3CH = n0CHS22A3C.choice;
        switch (n0CHS22A3C.which) {
          case 0:
            // &0 "~"
            n0CHS22A3CH.accept(this, argu);
            break;
          case 1:
            // &1 "!"
            n0CHS22A3CH.accept(this, argu);
            break;
          case 2:
            // &2 "("
            n0CHS22A3CH.accept(this, argu);
            break;
          case 3:
            // &3 <IDENTIFIER>
            n0CHS22A3CH.accept(this, argu);
            break;
          case 4:
            // &4 "this"
            n0CHS22A3CH.accept(this, argu);
            break;
          case 5:
            // &5 "super"
            n0CHS22A3CH.accept(this, argu);
            break;
          case 6:
            // &6 "new"
            n0CHS22A3CH.accept(this, argu);
            break;
          case 7:
            // &7 Literal()
            n0CHS22A3CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PostfixExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryExpression()<br>
   * f1 -> [ %0 "++"<br>
   * .. .. | %1 "--" ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final PostfixExpression n, final A argu) {
    // f0 -> PrimaryExpression()
    final PrimaryExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ %0 "++"
    // .. .. | %1 "--" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      final NodeChoice n1C = (NodeChoice) n1.node;
      final INode n1CH = n1C.choice;
      switch (n1C.which) {
        case 0:
          // %0 "++"
          n1CH.accept(this, argu);
          break;
        case 1:
          // %1 "--"
          n1CH.accept(this, argu);
          break;
        default:
          // should not occur !!!
          break;
      }
    }
  }

  /**
   * Visits a {@link CastExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()<br>
   * .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final CastExpression n, final A argu) {
    // f0 -> . %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()
    // .. .. | %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "(" #1 Type() #2 ")" #3 UnaryExpression()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 Type()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        n0CHS0A1.accept(this, argu);
        // #2 ")"
        final INode n0CHS0A2 = n0CHS.elementAt(2);
        n0CHS0A2.accept(this, argu);
        // #3 UnaryExpression()
        final INode n0CHS0A3 = n0CHS.elementAt(3);
        n0CHS0A3.accept(this, argu);
        break;
      case 1:
        // %1 #0 "(" #1 Type() #2 ")" #3 UnaryExpressionNotPlusMinus()
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        n0CHS11A0.accept(this, argu);
        // #1 Type()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        n0CHS11A1.accept(this, argu);
        // #2 ")"
        final INode n0CHS11A2 = n0CHS1.elementAt(2);
        n0CHS11A2.accept(this, argu);
        // #3 UnaryExpressionNotPlusMinus()
        final INode n0CHS11A3 = n0CHS1.elementAt(3);
        n0CHS11A3.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PrimaryExpression} node, whose children are the following :
   * <p>
   * f0 -> PrimaryPrefix()<br>
   * f1 -> ( PrimarySuffix() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final PrimaryExpression n, final A argu) {
    // f0 -> PrimaryPrefix()
    final PrimaryPrefix n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( PrimarySuffix() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        n1Mi.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link MemberSelector} node, whose children are the following :
   * <p>
   * f0 -> "."<br>
   * f1 -> TypeArguments()<br>
   * f2 -> <IDENTIFIER><br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final MemberSelector n, final A argu) {
    // f0 -> "."
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> TypeArguments()
    final TypeArguments n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> <IDENTIFIER>
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link PrimaryPrefix} node, whose child is the following :
   * <p>
   * f0 -> . %0 Literal()<br>
   * .. .. | %1 "this"<br>
   * .. .. | %2 #0 "super" #1 "." #2 <IDENTIFIER><br>
   * .. .. | %3 #0 "(" #1 Expression() #2 ")"<br>
   * .. .. | %4 AllocationExpression()<br>
   * .. .. | %5 #0 ResultType() #1 "." #2 "class"<br>
   * .. .. | %6 Name()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final PrimaryPrefix n, final A argu) {
    // f0 -> . %0 Literal()
    // .. .. | %1 "this"
    // .. .. | %2 #0 "super" #1 "." #2 <IDENTIFIER>
    // .. .. | %3 #0 "(" #1 Expression() #2 ")"
    // .. .. | %4 AllocationExpression()
    // .. .. | %5 #0 ResultType() #1 "." #2 "class"
    // .. .. | %6 Name()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 Literal()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 "this"
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 #0 "super" #1 "." #2 <IDENTIFIER>
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "super"
        final INode n0CHS2A0 = n0CHS.elementAt(0);
        n0CHS2A0.accept(this, argu);
        // #1 "."
        final INode n0CHS2A1 = n0CHS.elementAt(1);
        n0CHS2A1.accept(this, argu);
        // #2 <IDENTIFIER>
        final INode n0CHS2A2 = n0CHS.elementAt(2);
        n0CHS2A2.accept(this, argu);
        break;
      case 3:
        // %3 #0 "(" #1 Expression() #2 ")"
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "("
        final INode n0CHS13A0 = n0CHS1.elementAt(0);
        n0CHS13A0.accept(this, argu);
        // #1 Expression()
        final INode n0CHS13A1 = n0CHS1.elementAt(1);
        n0CHS13A1.accept(this, argu);
        // #2 ")"
        final INode n0CHS13A2 = n0CHS1.elementAt(2);
        n0CHS13A2.accept(this, argu);
        break;
      case 4:
        // %4 AllocationExpression()
        n0CH.accept(this, argu);
        break;
      case 5:
        // %5 #0 ResultType() #1 "." #2 "class"
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 ResultType()
        final INode n0CHS25A0 = n0CHS2.elementAt(0);
        n0CHS25A0.accept(this, argu);
        // #1 "."
        final INode n0CHS25A1 = n0CHS2.elementAt(1);
        n0CHS25A1.accept(this, argu);
        // #2 "class"
        final INode n0CHS25A2 = n0CHS2.elementAt(2);
        n0CHS25A2.accept(this, argu);
        break;
      case 6:
        // %6 Name()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link PrimarySuffix} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "." #1 "this"<br>
   * .. .. | %1 #0 "." #1 AllocationExpression()<br>
   * .. .. | %2 MemberSelector()<br>
   * .. .. | %3 #0 "[" #1 Expression() #2 "]"<br>
   * .. .. | %4 #0 "." #1 <IDENTIFIER><br>
   * .. .. | %5 Arguments()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final PrimarySuffix n, final A argu) {
    // f0 -> . %0 #0 "." #1 "this"
    // .. .. | %1 #0 "." #1 AllocationExpression()
    // .. .. | %2 MemberSelector()
    // .. .. | %3 #0 "[" #1 Expression() #2 "]"
    // .. .. | %4 #0 "." #1 <IDENTIFIER>
    // .. .. | %5 Arguments()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "." #1 "this"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "."
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 "this"
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        n0CHS0A1.accept(this, argu);
        break;
      case 1:
        // %1 #0 "." #1 AllocationExpression()
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "."
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        n0CHS11A0.accept(this, argu);
        // #1 AllocationExpression()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        n0CHS11A1.accept(this, argu);
        break;
      case 2:
        // %2 MemberSelector()
        n0CH.accept(this, argu);
        break;
      case 3:
        // %3 #0 "[" #1 Expression() #2 "]"
        final NodeSequence n0CHS2 = (NodeSequence) n0CH;
        // #0 "["
        final INode n0CHS23A0 = n0CHS2.elementAt(0);
        n0CHS23A0.accept(this, argu);
        // #1 Expression()
        final INode n0CHS23A1 = n0CHS2.elementAt(1);
        n0CHS23A1.accept(this, argu);
        // #2 "]"
        final INode n0CHS23A2 = n0CHS2.elementAt(2);
        n0CHS23A2.accept(this, argu);
        break;
      case 4:
        // %4 #0 "." #1 <IDENTIFIER>
        final NodeSequence n0CHS3 = (NodeSequence) n0CH;
        // #0 "."
        final INode n0CHS34A0 = n0CHS3.elementAt(0);
        n0CHS34A0.accept(this, argu);
        // #1 <IDENTIFIER>
        final INode n0CHS34A1 = n0CHS3.elementAt(1);
        n0CHS34A1.accept(this, argu);
        break;
      case 5:
        // %5 Arguments()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link Literal} node, whose child is the following :
   * <p>
   * f0 -> . %0 <INTEGER_LITERAL><br>
   * .. .. | %1 <FLOATING_POINT_LITERAL><br>
   * .. .. | %2 <CHARACTER_LITERAL><br>
   * .. .. | %3 <STRING_LITERAL><br>
   * .. .. | %4 BooleanLiteral()<br>
   * .. .. | %5 NullLiteral()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Literal n, final A argu) {
    // f0 -> . %0 <INTEGER_LITERAL>
    // .. .. | %1 <FLOATING_POINT_LITERAL>
    // .. .. | %2 <CHARACTER_LITERAL>
    // .. .. | %3 <STRING_LITERAL>
    // .. .. | %4 BooleanLiteral()
    // .. .. | %5 NullLiteral()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 <INTEGER_LITERAL>
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 <FLOATING_POINT_LITERAL>
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 <CHARACTER_LITERAL>
        n0CH.accept(this, argu);
        break;
      case 3:
        // %3 <STRING_LITERAL>
        n0CH.accept(this, argu);
        break;
      case 4:
        // %4 BooleanLiteral()
        n0CH.accept(this, argu);
        break;
      case 5:
        // %5 NullLiteral()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link IntegerLiteral} node, whose child is the following :
   * <p>
   * f0 -> <INTEGER_LITERAL><br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final IntegerLiteral n, final A argu) {
    // f0 -> <INTEGER_LITERAL>
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
  }

  /**
   * Visits a {@link BooleanLiteral} node, whose child is the following :
   * <p>
   * f0 -> . %0 "true"<br>
   * .. .. | %1 "false"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final BooleanLiteral n, final A argu) {
    // f0 -> . %0 "true"
    // .. .. | %1 "false"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 "true"
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 "false"
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link StringLiteral} node, whose child is the following :
   * <p>
   * f0 -> <STRING_LITERAL><br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final StringLiteral n, final A argu) {
    // f0 -> <STRING_LITERAL>
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
  }

  /**
   * Visits a {@link NullLiteral} node, whose child is the following :
   * <p>
   * f0 -> "null"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NullLiteral n, final A argu) {
    // f0 -> "null"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
  }

  /**
   * Visits a {@link Arguments} node, whose children are the following :
   * <p>
   * f0 -> "("<br>
   * f1 -> [ ArgumentList() ]<br>
   * f2 -> ")"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Arguments n, final A argu) {
    // f0 -> "("
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ ArgumentList() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this, argu);
    }
    // f2 -> ")"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link ArgumentList} node, whose children are the following :
   * <p>
   * f0 -> Expression()<br>
   * f1 -> ( #0 "," #1 Expression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ArgumentList n, final A argu) {
    // f0 -> Expression()
    final Expression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "," #1 Expression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ","
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 Expression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link AllocationExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()<br>
   * .. .. | %1 #0 "new" #1 ClassOrInterfaceType()<br>
   * .. .. . .. #2 [ TypeArguments() ]<br>
   * .. .. . .. #3 ( &0 ArrayDimsAndInits()<br>
   * .. .. . .. .. | &1 $0 Arguments()<br>
   * .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final AllocationExpression n, final A argu) {
    // f0 -> . %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()
    // .. .. | %1 #0 "new" #1 ClassOrInterfaceType()
    // .. .. . .. #2 [ TypeArguments() ]
    // .. .. . .. #3 ( &0 ArrayDimsAndInits()
    // .. .. . .. .. | &1 $0 Arguments()
    // .. .. . .. .. . .. $1 [ ClassOrInterfaceBody() ] )
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "new" #1 PrimitiveType() #2 ArrayDimsAndInits()
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "new"
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 PrimitiveType()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        n0CHS0A1.accept(this, argu);
        // #2 ArrayDimsAndInits()
        final INode n0CHS0A2 = n0CHS.elementAt(2);
        n0CHS0A2.accept(this, argu);
        break;
      case 1:
        // %1 #0 "new" #1 ClassOrInterfaceType()
        // .. #2 [ TypeArguments() ]
        // .. #3 ( &0 ArrayDimsAndInits()
        // .. .. | &1 $0 Arguments()
        // .. .. .. $1 [ ClassOrInterfaceBody() ] )
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "new"
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        n0CHS11A0.accept(this, argu);
        // #1 ClassOrInterfaceType()
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        n0CHS11A1.accept(this, argu);
        // #2 [ TypeArguments() ]
        final INode n0CHS11A2 = n0CHS1.elementAt(2);
        final NodeOptional n0CHS11A2P = (NodeOptional) n0CHS11A2;
        if (n0CHS11A2P.present()) {
          n0CHS11A2P.accept(this, argu);
        }
        // #3 ( &0 ArrayDimsAndInits()
        // .. | &1 $0 Arguments()
        // .. .. $1 [ ClassOrInterfaceBody() ] )
        final INode n0CHS1A3 = n0CHS1.elementAt(3);
        final NodeChoice n0CHS1A3C = (NodeChoice) n0CHS1A3;
        final INode n0CHS1A3CH = n0CHS1A3C.choice;
        switch (n0CHS1A3C.which) {
          case 0:
            // &0 ArrayDimsAndInits()
            n0CHS1A3CH.accept(this, argu);
            break;
          case 1:
            // &1 $0 Arguments()
            // .. $1 [ ClassOrInterfaceBody() ]
            final NodeSequence n0CHS1A3CHS2 = (NodeSequence) n0CHS1A3CH;
            // $0 Arguments()
            final INode n0CHS1A3CHS21A0 = n0CHS1A3CHS2.elementAt(0);
            n0CHS1A3CHS21A0.accept(this, argu);
            // $1 [ ClassOrInterfaceBody() ]
            final INode n0CHS1A3CHS21A1 = n0CHS1A3CHS2.elementAt(1);
            final NodeOptional n0CHS1A3CHS21A1P = (NodeOptional) n0CHS1A3CHS21A1;
            if (n0CHS1A3CHS21A1P.present()) {
              n0CHS1A3CHS21A1P.accept(this, argu);
            }
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link ArrayDimsAndInits} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+<br>
   * .. .. . .. #1 ( $0 "[" $1 "]" )*<br>
   * .. .. | %1 #0 ( $0 "[" $1 "]" )+<br>
   * .. .. . .. #1 ArrayInitializer()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ArrayDimsAndInits n, final A argu) {
    // f0 -> . %0 #0 ( $0 "[" $1 Expression() $2 "]" )+
    // .. .. . .. #1 ( $0 "[" $1 "]" )*
    // .. .. | %1 #0 ( $0 "[" $1 "]" )+
    // .. .. . .. #1 ArrayInitializer()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 ( $0 "[" $1 Expression() $2 "]" )+
        // .. #1 ( $0 "[" $1 "]" )*
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 ( $0 "[" $1 Expression() $2 "]" )+
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        final NodeList n0CHS0A0L = (NodeList) n0CHS0A0;
        for (int i = 0; i < n0CHS0A0L.size(); i++) {
          final INode n0CHS0A0LEi = n0CHS0A0L.elementAt(i);
          final NodeSequence n0CHS0A0LEiS1 = (NodeSequence) n0CHS0A0LEi;
          // $0 "["
          final INode n0CHS0A0LEiS1A0 = n0CHS0A0LEiS1.elementAt(0);
          n0CHS0A0LEiS1A0.accept(this, argu);
          // $1 Expression()
          final INode n0CHS0A0LEiS1A1 = n0CHS0A0LEiS1.elementAt(1);
          n0CHS0A0LEiS1A1.accept(this, argu);
          // $2 "]"
          final INode n0CHS0A0LEiS1A2 = n0CHS0A0LEiS1.elementAt(2);
          n0CHS0A0LEiS1A2.accept(this, argu);
        }
        // #1 ( $0 "[" $1 "]" )*
        final INode n0CHSA1 = n0CHS.elementAt(1);
        final NodeListOptional n0CHSA1T = (NodeListOptional) n0CHSA1;
        if (n0CHSA1T.present()) {
          for (int i = 0; i < n0CHSA1T.size(); i++) {
            final INode n0CHSA1TMi = n0CHSA1T.elementAt(i);
            final NodeSequence n0CHSA1TMiS2 = (NodeSequence) n0CHSA1TMi;
            // $0 "["
            final INode n0CHSA1TMiS2A0 = n0CHSA1TMiS2.elementAt(0);
            n0CHSA1TMiS2A0.accept(this, argu);
            // $1 "]"
            final INode n0CHSA1TMiS2A1 = n0CHSA1TMiS2.elementAt(1);
            n0CHSA1TMiS2A1.accept(this, argu);
          }
        }
        break;
      case 1:
        // %1 #0 ( $0 "[" $1 "]" )+
        // .. #1 ArrayInitializer()
        final NodeSequence n0CHS3 = (NodeSequence) n0CH;
        // #0 ( $0 "[" $1 "]" )+
        final INode n0CHS31A0 = n0CHS3.elementAt(0);
        final NodeList n0CHS31A0L1 = (NodeList) n0CHS31A0;
        for (int i = 0; i < n0CHS31A0L1.size(); i++) {
          final INode n0CHS31A0L1Ei = n0CHS31A0L1.elementAt(i);
          final NodeSequence n0CHS31A0L1EiS4 = (NodeSequence) n0CHS31A0L1Ei;
          // $0 "["
          final INode n0CHS31A0L1EiS4A0 = n0CHS31A0L1EiS4.elementAt(0);
          n0CHS31A0L1EiS4A0.accept(this, argu);
          // $1 "]"
          final INode n0CHS31A0L1EiS4A1 = n0CHS31A0L1EiS4.elementAt(1);
          n0CHS31A0L1EiS4A1.accept(this, argu);
        }
        // #1 ArrayInitializer()
        final INode n0CHS3A1 = n0CHS3.elementAt(1);
        n0CHS3A1.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link Statement} node, whose child is the following :
   * <p>
   * f0 -> . %00 LabeledStatement()<br>
   * .. .. | %01 AssertStatement()<br>
   * .. .. | %02 Block()<br>
   * .. .. | %03 EmptyStatement()<br>
   * .. .. | %04 #0 StatementExpression() #1 ";"<br>
   * .. .. | %05 SwitchStatement()<br>
   * .. .. | %06 IfStatement()<br>
   * .. .. | %07 WhileStatement()<br>
   * .. .. | %08 DoStatement()<br>
   * .. .. | %09 ForStatement()<br>
   * .. .. | %10 BreakStatement()<br>
   * .. .. | %11 ContinueStatement()<br>
   * .. .. | %12 ReturnStatement()<br>
   * .. .. | %13 ThrowStatement()<br>
   * .. .. | %14 SynchronizedStatement()<br>
   * .. .. | %15 TryStatement()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Statement n, final A argu) {
    // f0 -> . %00 LabeledStatement()
    // .. .. | %01 AssertStatement()
    // .. .. | %02 Block()
    // .. .. | %03 EmptyStatement()
    // .. .. | %04 #0 StatementExpression() #1 ";"
    // .. .. | %05 SwitchStatement()
    // .. .. | %06 IfStatement()
    // .. .. | %07 WhileStatement()
    // .. .. | %08 DoStatement()
    // .. .. | %09 ForStatement()
    // .. .. | %10 BreakStatement()
    // .. .. | %11 ContinueStatement()
    // .. .. | %12 ReturnStatement()
    // .. .. | %13 ThrowStatement()
    // .. .. | %14 SynchronizedStatement()
    // .. .. | %15 TryStatement()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %00 LabeledStatement()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %01 AssertStatement()
        n0CH.accept(this, argu);
        break;
      case 2:
        // %02 Block()
        n0CH.accept(this, argu);
        break;
      case 3:
        // %03 EmptyStatement()
        n0CH.accept(this, argu);
        break;
      case 4:
        // %04 #0 StatementExpression() #1 ";"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 StatementExpression()
        final INode n0CHS4A0 = n0CHS.elementAt(0);
        n0CHS4A0.accept(this, argu);
        // #1 ";"
        final INode n0CHS4A1 = n0CHS.elementAt(1);
        n0CHS4A1.accept(this, argu);
        break;
      case 5:
        // %05 SwitchStatement()
        n0CH.accept(this, argu);
        break;
      case 6:
        // %06 IfStatement()
        n0CH.accept(this, argu);
        break;
      case 7:
        // %07 WhileStatement()
        n0CH.accept(this, argu);
        break;
      case 8:
        // %08 DoStatement()
        n0CH.accept(this, argu);
        break;
      case 9:
        // %09 ForStatement()
        n0CH.accept(this, argu);
        break;
      case 10:
        // %10 BreakStatement()
        n0CH.accept(this, argu);
        break;
      case 11:
        // %11 ContinueStatement()
        n0CH.accept(this, argu);
        break;
      case 12:
        // %12 ReturnStatement()
        n0CH.accept(this, argu);
        break;
      case 13:
        // %13 ThrowStatement()
        n0CH.accept(this, argu);
        break;
      case 14:
        // %14 SynchronizedStatement()
        n0CH.accept(this, argu);
        break;
      case 15:
        // %15 TryStatement()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link AssertStatement} node, whose children are the following :
   * <p>
   * f0 -> "assert"<br>
   * f1 -> Expression()<br>
   * f2 -> [ #0 ":" #1 Expression() ]<br>
   * f3 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final AssertStatement n, final A argu) {
    // f0 -> "assert"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Expression()
    final Expression n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> [ #0 ":" #1 Expression() ]
    final NodeOptional n2 = n.f2;
    if (n2.present()) {
      final NodeSequence n2S = (NodeSequence) n2.node;
      // #0 ":"
      final INode n2SA0 = n2S.elementAt(0);
      n2SA0.accept(this, argu);
      // #1 Expression()
      final INode n2SA1 = n2S.elementAt(1);
      n2SA1.accept(this, argu);
    }
    // f3 -> ";"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link LabeledStatement} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> ":"<br>
   * f2 -> Statement()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final LabeledStatement n, final A argu) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ":"
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> Statement()
    final Statement n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link Block} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( BlockStatement() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Block n, final A argu) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( BlockStatement() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        n1Mi.accept(this, argu);
      }
    }
    // f2 -> "}"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link BlockStatement} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"<br>
   * .. .. | %1 Statement()<br>
   * .. .. | %2 ClassOrInterfaceDeclaration()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final BlockStatement n, final A argu) {
    // f0 -> . %0 #0 LocalVariableDeclaration() #1 ";"
    // .. .. | %1 Statement()
    // .. .. | %2 ClassOrInterfaceDeclaration()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 LocalVariableDeclaration() #1 ";"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 LocalVariableDeclaration()
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 ";"
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        n0CHS0A1.accept(this, argu);
        break;
      case 1:
        // %1 Statement()
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 ClassOrInterfaceDeclaration()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link LocalVariableDeclaration} node, whose children are the following :
   * <p>
   * f0 -> VariableModifiers()<br>
   * f1 -> Type()<br>
   * f2 -> VariableDeclarator()<br>
   * f3 -> ( #0 "," #1 VariableDeclarator() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final LocalVariableDeclaration n, final A argu) {
    // f0 -> VariableModifiers()
    final VariableModifiers n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Type()
    final Type n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> VariableDeclarator()
    final VariableDeclarator n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> ( #0 "," #1 VariableDeclarator() )*
    final NodeListOptional n3 = n.f3;
    if (n3.present()) {
      for (int i = 0; i < n3.size(); i++) {
        final INode n3Mi = n3.elementAt(i);
        final NodeSequence n3MiS = (NodeSequence) n3Mi;
        // #0 ","
        final INode n3MiSA0 = n3MiS.elementAt(0);
        n3MiSA0.accept(this, argu);
        // #1 VariableDeclarator()
        final INode n3MiSA1 = n3MiS.elementAt(1);
        n3MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link VariableModifiers} node, whose child is the following :
   * <p>
   * f0 -> ( ( %0 "final"<br>
   * .. .. . | %1 Annotation() ) )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final VariableModifiers n, final A argu) {
    // f0 -> ( ( %0 "final"
    // .. .. . | %1 Annotation() ) )*
    final NodeListOptional n0 = n.f0;
    if (n0.present()) {
      for (int i = 0; i < n0.size(); i++) {
        final INode n0Mi = n0.elementAt(i);
        final NodeChoice n0MiC = (NodeChoice) n0Mi;
        final INode n0MiCH = n0MiC.choice;
        switch (n0MiC.which) {
          case 0:
            // %0 "final"
            n0MiCH.accept(this, argu);
            break;
          case 1:
            // %1 Annotation()
            n0MiCH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
      }
    }
  }

  /**
   * Visits a {@link EmptyStatement} node, whose child is the following :
   * <p>
   * f0 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final EmptyStatement n, final A argu) {
    // f0 -> ";"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
  }

  /**
   * Visits a {@link StatementExpression} node, whose child is the following :
   * <p>
   * f0 -> . %0 PreIncrementExpression()<br>
   * .. .. | %1 PreDecrementExpression()<br>
   * .. .. | %2 #0 PrimaryExpression()<br>
   * .. .. . .. #1 [ &0 "++"<br>
   * .. .. . .. .. | &1 "--"<br>
   * .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final StatementExpression n, final A argu) {
    // f0 -> . %0 PreIncrementExpression()
    // .. .. | %1 PreDecrementExpression()
    // .. .. | %2 #0 PrimaryExpression()
    // .. .. . .. #1 [ &0 "++"
    // .. .. . .. .. | &1 "--"
    // .. .. . .. .. | &2 $0 AssignmentOperator() $1 Expression() ]
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 PreIncrementExpression()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 PreDecrementExpression()
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 #0 PrimaryExpression()
        // .. #1 [ &0 "++"
        // .. .. | &1 "--"
        // .. .. | &2 $0 AssignmentOperator() $1 Expression() ]
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 PrimaryExpression()
        final INode n0CHS2A0 = n0CHS.elementAt(0);
        n0CHS2A0.accept(this, argu);
        // #1 [ &0 "++"
        // .. | &1 "--"
        // .. | &2 $0 AssignmentOperator() $1 Expression() ]
        final INode n0CHS2A1 = n0CHS.elementAt(1);
        final NodeOptional n0CHS2A1P = (NodeOptional) n0CHS2A1;
        if (n0CHS2A1P.present()) {
          final NodeChoice n0CHS2A1PC = (NodeChoice) n0CHS2A1P.node;
          final INode n0CHS2A1PCH = n0CHS2A1PC.choice;
          switch (n0CHS2A1PC.which) {
            case 0:
              // &0 "++"
              n0CHS2A1PCH.accept(this, argu);
              break;
            case 1:
              // &1 "--"
              n0CHS2A1PCH.accept(this, argu);
              break;
            case 2:
              // &2 $0 AssignmentOperator() $1 Expression()
              final NodeSequence n0CHS2A1PCHS1 = (NodeSequence) n0CHS2A1PCH;
              // $0 AssignmentOperator()
              final INode n0CHS2A1PCHS12A0 = n0CHS2A1PCHS1.elementAt(0);
              n0CHS2A1PCHS12A0.accept(this, argu);
              // $1 Expression()
              final INode n0CHS2A1PCHS12A1 = n0CHS2A1PCHS1.elementAt(1);
              n0CHS2A1PCHS12A1.accept(this, argu);
              break;
            default:
              // should not occur !!!
              break;
          }
        }
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link SwitchStatement} node, whose children are the following :
   * <p>
   * f0 -> "switch"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> "{"<br>
   * f5 -> ( #0 SwitchLabel()<br>
   * .. .. . #1 ( BlockStatement() )* )*<br>
   * f6 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final SwitchStatement n, final A argu) {
    // f0 -> "switch"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> "{"
    final NodeToken n4 = n.f4;
    n4.accept(this, argu);
    // f5 -> ( #0 SwitchLabel()
    // .. .. . #1 ( BlockStatement() )* )*
    final NodeListOptional n5 = n.f5;
    if (n5.present()) {
      for (int i = 0; i < n5.size(); i++) {
        final INode n5Mi = n5.elementAt(i);
        final NodeSequence n5MiS = (NodeSequence) n5Mi;
        // #0 SwitchLabel()
        final INode n5MiSA0 = n5MiS.elementAt(0);
        n5MiSA0.accept(this, argu);
        // #1 ( BlockStatement() )*
        final INode n5MiSA1 = n5MiS.elementAt(1);
        final NodeListOptional n5MiSA1T = (NodeListOptional) n5MiSA1;
        if (n5MiSA1T.present()) {
          for (int i1 = 0; i1 < n5MiSA1T.size(); i1++) {
            final INode n5MiSA1TMi = n5MiSA1T.elementAt(i1);
            n5MiSA1TMi.accept(this, argu);
          }
        }
      }
    }
    // f6 -> "}"
    final NodeToken n6 = n.f6;
    n6.accept(this, argu);
  }

  /**
   * Visits a {@link SwitchLabel} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "case" #1 Expression() #2 ":"<br>
   * .. .. | %1 #0 "default" #1 ":"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final SwitchLabel n, final A argu) {
    // f0 -> . %0 #0 "case" #1 Expression() #2 ":"
    // .. .. | %1 #0 "default" #1 ":"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 "case" #1 Expression() #2 ":"
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 "case"
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 Expression()
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        n0CHS0A1.accept(this, argu);
        // #2 ":"
        final INode n0CHS0A2 = n0CHS.elementAt(2);
        n0CHS0A2.accept(this, argu);
        break;
      case 1:
        // %1 #0 "default" #1 ":"
        final NodeSequence n0CHS1 = (NodeSequence) n0CH;
        // #0 "default"
        final INode n0CHS11A0 = n0CHS1.elementAt(0);
        n0CHS11A0.accept(this, argu);
        // #1 ":"
        final INode n0CHS11A1 = n0CHS1.elementAt(1);
        n0CHS11A1.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link IfStatement} node, whose children are the following :
   * <p>
   * f0 -> "if"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   * f5 -> [ #0 "else" #1 Statement() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final IfStatement n, final A argu) {
    // f0 -> "if"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    n4.accept(this, argu);
    // f5 -> [ #0 "else" #1 Statement() ]
    final NodeOptional n5 = n.f5;
    if (n5.present()) {
      final NodeSequence n5S = (NodeSequence) n5.node;
      // #0 "else"
      final INode n5SA0 = n5S.elementAt(0);
      n5SA0.accept(this, argu);
      // #1 Statement()
      final INode n5SA1 = n5S.elementAt(1);
      n5SA1.accept(this, argu);
    }
  }

  /**
   * Visits a {@link WhileStatement} node, whose children are the following :
   * <p>
   * f0 -> "while"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final WhileStatement n, final A argu) {
    // f0 -> "while"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    n4.accept(this, argu);
  }

  /**
   * Visits a {@link DoStatement} node, whose children are the following :
   * <p>
   * f0 -> "do"<br>
   * f1 -> Statement()<br>
   * f2 -> "while"<br>
   * f3 -> "("<br>
   * f4 -> Expression()<br>
   * f5 -> ")"<br>
   * f6 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final DoStatement n, final A argu) {
    // f0 -> "do"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Statement()
    final Statement n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> "while"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> "("
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> Expression()
    final Expression n4 = n.f4;
    n4.accept(this, argu);
    // f5 -> ")"
    final NodeToken n5 = n.f5;
    n5.accept(this, argu);
    // f6 -> ";"
    final NodeToken n6 = n.f6;
    n6.accept(this, argu);
  }

  /**
   * Visits a {@link ForStatement} node, whose children are the following :
   * <p>
   * f0 -> "for"<br>
   * f1 -> "("<br>
   * f2 -> ( %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()<br>
   * .. .. | %1 #0 [ ForInit() ]<br>
   * .. .. . .. #1 ";"<br>
   * .. .. . .. #2 [ Expression() ]<br>
   * .. .. . .. #3 ";"<br>
   * .. .. . .. #4 [ ForUpdate() ] )<br>
   * f3 -> ")"<br>
   * f4 -> Statement()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ForStatement n, final A argu) {
    // f0 -> "for"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()
    // .. .. | %1 #0 [ ForInit() ]
    // .. .. . .. #1 ";"
    // .. .. . .. #2 [ Expression() ]
    // .. .. . .. #3 ";"
    // .. .. . .. #4 [ ForUpdate() ] )
    final NodeChoice n2 = n.f2;
    final NodeChoice n2C = n2;
    final INode n2CH = n2C.choice;
    switch (n2C.which) {
      case 0:
        // %0 #0 VariableModifiers() #1 Type() #2 <IDENTIFIER> #3 ":" #4 Expression()
        final NodeSequence n2CHS = (NodeSequence) n2CH;
        // #0 VariableModifiers()
        final INode n2CHS0A0 = n2CHS.elementAt(0);
        n2CHS0A0.accept(this, argu);
        // #1 Type()
        final INode n2CHS0A1 = n2CHS.elementAt(1);
        n2CHS0A1.accept(this, argu);
        // #2 <IDENTIFIER>
        final INode n2CHS0A2 = n2CHS.elementAt(2);
        n2CHS0A2.accept(this, argu);
        // #3 ":"
        final INode n2CHS0A3 = n2CHS.elementAt(3);
        n2CHS0A3.accept(this, argu);
        // #4 Expression()
        final INode n2CHS0A4 = n2CHS.elementAt(4);
        n2CHS0A4.accept(this, argu);
        break;
      case 1:
        // %1 #0 [ ForInit() ]
        // .. #1 ";"
        // .. #2 [ Expression() ]
        // .. #3 ";"
        // .. #4 [ ForUpdate() ]
        final NodeSequence n2CHS1 = (NodeSequence) n2CH;
        // #0 [ ForInit() ]
        final INode n2CHS11A0 = n2CHS1.elementAt(0);
        final NodeOptional n2CHS11A0P = (NodeOptional) n2CHS11A0;
        if (n2CHS11A0P.present()) {
          n2CHS11A0P.accept(this, argu);
        }
        // #1 ";"
        final INode n2CHS1A1 = n2CHS1.elementAt(1);
        n2CHS1A1.accept(this, argu);
        // #2 [ Expression() ]
        final INode n2CHS1A2 = n2CHS1.elementAt(2);
        final NodeOptional n2CHS1A2P = (NodeOptional) n2CHS1A2;
        if (n2CHS1A2P.present()) {
          n2CHS1A2P.accept(this, argu);
        }
        // #3 ";"
        final INode n2CHS1A3 = n2CHS1.elementAt(3);
        n2CHS1A3.accept(this, argu);
        // #4 [ ForUpdate() ]
        final INode n2CHS1A4 = n2CHS1.elementAt(4);
        final NodeOptional n2CHS1A4P = (NodeOptional) n2CHS1A4;
        if (n2CHS1A4P.present()) {
          n2CHS1A4P.accept(this, argu);
        }
        break;
      default:
        // should not occur !!!
        break;
    }
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> Statement()
    final Statement n4 = n.f4;
    n4.accept(this, argu);
  }

  /**
   * Visits a {@link ForInit} node, whose child is the following :
   * <p>
   * f0 -> . %0 LocalVariableDeclaration()<br>
   * .. .. | %1 StatementExpressionList()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ForInit n, final A argu) {
    // f0 -> . %0 LocalVariableDeclaration()
    // .. .. | %1 StatementExpressionList()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 LocalVariableDeclaration()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 StatementExpressionList()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link StatementExpressionList} node, whose children are the following :
   * <p>
   * f0 -> StatementExpression()<br>
   * f1 -> ( #0 "," #1 StatementExpression() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final StatementExpressionList n, final A argu) {
    // f0 -> StatementExpression()
    final StatementExpression n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "," #1 StatementExpression() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ","
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 StatementExpression()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link ForUpdate} node, whose child is the following :
   * <p>
   * f0 -> StatementExpressionList()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ForUpdate n, final A argu) {
    // f0 -> StatementExpressionList()
    final StatementExpressionList n0 = n.f0;
    n0.accept(this, argu);
  }

  /**
   * Visits a {@link BreakStatement} node, whose children are the following :
   * <p>
   * f0 -> "break"<br>
   * f1 -> [ <IDENTIFIER> ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final BreakStatement n, final A argu) {
    // f0 -> "break"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ <IDENTIFIER> ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this, argu);
    }
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link ContinueStatement} node, whose children are the following :
   * <p>
   * f0 -> "continue"<br>
   * f1 -> [ <IDENTIFIER> ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ContinueStatement n, final A argu) {
    // f0 -> "continue"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ <IDENTIFIER> ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this, argu);
    }
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link ReturnStatement} node, whose children are the following :
   * <p>
   * f0 -> "return"<br>
   * f1 -> [ Expression() ]<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ReturnStatement n, final A argu) {
    // f0 -> "return"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> [ Expression() ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      n1.accept(this, argu);
    }
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link ThrowStatement} node, whose children are the following :
   * <p>
   * f0 -> "throw"<br>
   * f1 -> Expression()<br>
   * f2 -> ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final ThrowStatement n, final A argu) {
    // f0 -> "throw"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Expression()
    final Expression n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ";"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link SynchronizedStatement} node, whose children are the following :
   * <p>
   * f0 -> "synchronized"<br>
   * f1 -> "("<br>
   * f2 -> Expression()<br>
   * f3 -> ")"<br>
   * f4 -> Block()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final SynchronizedStatement n, final A argu) {
    // f0 -> "synchronized"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> "("
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> Expression()
    final Expression n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> ")"
    final NodeToken n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> Block()
    final Block n4 = n.f4;
    n4.accept(this, argu);
  }

  /**
   * Visits a {@link TryStatement} node, whose children are the following :
   * <p>
   * f0 -> "try"<br>
   * f1 -> Block()<br>
   * f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*<br>
   * f3 -> [ #0 "finally" #1 Block() ]<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final TryStatement n, final A argu) {
    // f0 -> "try"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Block()
    final Block n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( #0 "catch" #1 "(" #2 FormalParameter() #3 ")" #4 Block() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 "catch"
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 "("
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
        // #2 FormalParameter()
        final INode n2MiSA2 = n2MiS.elementAt(2);
        n2MiSA2.accept(this, argu);
        // #3 ")"
        final INode n2MiSA3 = n2MiS.elementAt(3);
        n2MiSA3.accept(this, argu);
        // #4 Block()
        final INode n2MiSA4 = n2MiS.elementAt(4);
        n2MiSA4.accept(this, argu);
      }
    }
    // f3 -> [ #0 "finally" #1 Block() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      final NodeSequence n3S1 = (NodeSequence) n3.node;
      // #0 "finally"
      final INode n3S1A0 = n3S1.elementAt(0);
      n3S1A0.accept(this, argu);
      // #1 Block()
      final INode n3S1A1 = n3S1.elementAt(1);
      n3S1A1.accept(this, argu);
    }
  }

  /**
   * Visits a {@link Annotation} node, whose child is the following :
   * <p>
   * f0 -> . %0 NormalAnnotation()<br>
   * .. .. | %1 SingleMemberAnnotation()<br>
   * .. .. | %2 MarkerAnnotation()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final Annotation n, final A argu) {
    // f0 -> . %0 NormalAnnotation()
    // .. .. | %1 SingleMemberAnnotation()
    // .. .. | %2 MarkerAnnotation()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 NormalAnnotation()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 SingleMemberAnnotation()
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 MarkerAnnotation()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link NormalAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> [ MemberValuePairs() ]<br>
   * f4 -> ")"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final NormalAnnotation n, final A argu) {
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Name()
    final Name n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> "("
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> [ MemberValuePairs() ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this, argu);
    }
    // f4 -> ")"
    final NodeToken n4 = n.f4;
    n4.accept(this, argu);
  }

  /**
   * Visits a {@link MarkerAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final MarkerAnnotation n, final A argu) {
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Name()
    final Name n1 = n.f1;
    n1.accept(this, argu);
  }

  /**
   * Visits a {@link SingleMemberAnnotation} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> Name()<br>
   * f2 -> "("<br>
   * f3 -> MemberValue()<br>
   * f4 -> ")"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final SingleMemberAnnotation n, final A argu) {
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> Name()
    final Name n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> "("
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> MemberValue()
    final MemberValue n3 = n.f3;
    n3.accept(this, argu);
    // f4 -> ")"
    final NodeToken n4 = n.f4;
    n4.accept(this, argu);
  }

  /**
   * Visits a {@link MemberValuePairs} node, whose children are the following :
   * <p>
   * f0 -> MemberValuePair()<br>
   * f1 -> ( #0 "," #1 MemberValuePair() )*<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final MemberValuePairs n, final A argu) {
    // f0 -> MemberValuePair()
    final MemberValuePair n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( #0 "," #1 MemberValuePair() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        final NodeSequence n1MiS = (NodeSequence) n1Mi;
        // #0 ","
        final INode n1MiSA0 = n1MiS.elementAt(0);
        n1MiSA0.accept(this, argu);
        // #1 MemberValuePair()
        final INode n1MiSA1 = n1MiS.elementAt(1);
        n1MiSA1.accept(this, argu);
      }
    }
  }

  /**
   * Visits a {@link MemberValuePair} node, whose children are the following :
   * <p>
   * f0 -> <IDENTIFIER><br>
   * f1 -> "="<br>
   * f2 -> MemberValue()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final MemberValuePair n, final A argu) {
    // f0 -> <IDENTIFIER>
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> "="
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> MemberValue()
    final MemberValue n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link MemberValue} node, whose child is the following :
   * <p>
   * f0 -> . %0 Annotation()<br>
   * .. .. | %1 MemberValueArrayInitializer()<br>
   * .. .. | %2 ConditionalExpression()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final MemberValue n, final A argu) {
    // f0 -> . %0 Annotation()
    // .. .. | %1 MemberValueArrayInitializer()
    // .. .. | %2 ConditionalExpression()
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 Annotation()
        n0CH.accept(this, argu);
        break;
      case 1:
        // %1 MemberValueArrayInitializer()
        n0CH.accept(this, argu);
        break;
      case 2:
        // %2 ConditionalExpression()
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link MemberValueArrayInitializer} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> MemberValue()<br>
   * f2 -> ( #0 "," #1 MemberValue() )*<br>
   * f3 -> [ "," ]<br>
   * f4 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final MemberValueArrayInitializer n, final A argu) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> MemberValue()
    final MemberValue n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> ( #0 "," #1 MemberValue() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode n2Mi = n2.elementAt(i);
        final NodeSequence n2MiS = (NodeSequence) n2Mi;
        // #0 ","
        final INode n2MiSA0 = n2MiS.elementAt(0);
        n2MiSA0.accept(this, argu);
        // #1 MemberValue()
        final INode n2MiSA1 = n2MiS.elementAt(1);
        n2MiSA1.accept(this, argu);
      }
    }
    // f3 -> [ "," ]
    final NodeOptional n3 = n.f3;
    if (n3.present()) {
      n3.accept(this, argu);
    }
    // f4 -> "}"
    final NodeToken n4 = n.f4;
    n4.accept(this, argu);
  }

  /**
   * Visits a {@link AnnotationTypeDeclaration} node, whose children are the following :
   * <p>
   * f0 -> "@"<br>
   * f1 -> "interface"<br>
   * f2 -> <IDENTIFIER><br>
   * f3 -> AnnotationTypeBody()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final AnnotationTypeDeclaration n, final A argu) {
    // f0 -> "@"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> "interface"
    final NodeToken n1 = n.f1;
    n1.accept(this, argu);
    // f2 -> <IDENTIFIER>
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
    // f3 -> AnnotationTypeBody()
    final AnnotationTypeBody n3 = n.f3;
    n3.accept(this, argu);
  }

  /**
   * Visits a {@link AnnotationTypeBody} node, whose children are the following :
   * <p>
   * f0 -> "{"<br>
   * f1 -> ( AnnotationTypeMemberDeclaration() )*<br>
   * f2 -> "}"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final AnnotationTypeBody n, final A argu) {
    // f0 -> "{"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> ( AnnotationTypeMemberDeclaration() )*
    final NodeListOptional n1 = n.f1;
    if (n1.present()) {
      for (int i = 0; i < n1.size(); i++) {
        final INode n1Mi = n1.elementAt(i);
        n1Mi.accept(this, argu);
      }
    }
    // f2 -> "}"
    final NodeToken n2 = n.f2;
    n2.accept(this, argu);
  }

  /**
   * Visits a {@link AnnotationTypeMemberDeclaration} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 Modifiers()<br>
   * .. .. . .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"<br>
   * .. .. . .. .. . .. $4 [ DefaultValue() ]<br>
   * .. .. . .. .. . .. $5 ";"<br>
   * .. .. . .. .. | &1 ClassOrInterfaceDeclaration()<br>
   * .. .. . .. .. | &2 EnumDeclaration()<br>
   * .. .. . .. .. | &3 AnnotationTypeDeclaration()<br>
   * .. .. . .. .. | &4 FieldDeclaration() )<br>
   * .. .. | %1 ";"<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final AnnotationTypeMemberDeclaration n, final A argu) {
    // f0 -> . %0 #0 Modifiers()
    // .. .. . .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
    // .. .. . .. .. . .. $4 [ DefaultValue() ]
    // .. .. . .. .. . .. $5 ";"
    // .. .. . .. .. | &1 ClassOrInterfaceDeclaration()
    // .. .. . .. .. | &2 EnumDeclaration()
    // .. .. . .. .. | &3 AnnotationTypeDeclaration()
    // .. .. . .. .. | &4 FieldDeclaration() )
    // .. .. | %1 ";"
    final NodeChoice n0C = n.f0;
    final INode n0CH = n0C.choice;
    switch (n0C.which) {
      case 0:
        // %0 #0 Modifiers()
        // .. #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
        // .. .. .. $4 [ DefaultValue() ]
        // .. .. .. $5 ";"
        // .. .. | &1 ClassOrInterfaceDeclaration()
        // .. .. | &2 EnumDeclaration()
        // .. .. | &3 AnnotationTypeDeclaration()
        // .. .. | &4 FieldDeclaration() )
        final NodeSequence n0CHS = (NodeSequence) n0CH;
        // #0 Modifiers()
        final INode n0CHS0A0 = n0CHS.elementAt(0);
        n0CHS0A0.accept(this, argu);
        // #1 ( &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
        // .. .. $4 [ DefaultValue() ]
        // .. .. $5 ";"
        // .. | &1 ClassOrInterfaceDeclaration()
        // .. | &2 EnumDeclaration()
        // .. | &3 AnnotationTypeDeclaration()
        // .. | &4 FieldDeclaration() )
        final INode n0CHS0A1 = n0CHS.elementAt(1);
        final NodeChoice n0CHS0A1C = (NodeChoice) n0CHS0A1;
        final INode n0CHS0A1CH = n0CHS0A1C.choice;
        switch (n0CHS0A1C.which) {
          case 0:
            // &0 $0 Type() $1 <IDENTIFIER> $2 "(" $3 ")"
            // .. $4 [ DefaultValue() ]
            // .. $5 ";"
            final NodeSequence n0CHS0A1CHS1 = (NodeSequence) n0CHS0A1CH;
            // $0 Type()
            final INode n0CHS0A1CHS10A0 = n0CHS0A1CHS1.elementAt(0);
            n0CHS0A1CHS10A0.accept(this, argu);
            // $1 <IDENTIFIER>
            final INode n0CHS0A1CHS10A1 = n0CHS0A1CHS1.elementAt(1);
            n0CHS0A1CHS10A1.accept(this, argu);
            // $2 "("
            final INode n0CHS0A1CHS10A2 = n0CHS0A1CHS1.elementAt(2);
            n0CHS0A1CHS10A2.accept(this, argu);
            // $3 ")"
            final INode n0CHS0A1CHS10A3 = n0CHS0A1CHS1.elementAt(3);
            n0CHS0A1CHS10A3.accept(this, argu);
            // $4 [ DefaultValue() ]
            final INode n0CHS0A1CHS10A4 = n0CHS0A1CHS1.elementAt(4);
            final NodeOptional n0CHS0A1CHS10A4P = (NodeOptional) n0CHS0A1CHS10A4;
            if (n0CHS0A1CHS10A4P.present()) {
              n0CHS0A1CHS10A4P.accept(this, argu);
            }
            // $5 ";"
            final INode n0CHS0A1CHS1A5 = n0CHS0A1CHS1.elementAt(5);
            n0CHS0A1CHS1A5.accept(this, argu);
            break;
          case 1:
            // &1 ClassOrInterfaceDeclaration()
            n0CHS0A1CH.accept(this, argu);
            break;
          case 2:
            // &2 EnumDeclaration()
            n0CHS0A1CH.accept(this, argu);
            break;
          case 3:
            // &3 AnnotationTypeDeclaration()
            n0CHS0A1CH.accept(this, argu);
            break;
          case 4:
            // &4 FieldDeclaration()
            n0CHS0A1CH.accept(this, argu);
            break;
          default:
            // should not occur !!!
            break;
        }
        break;
      case 1:
        // %1 ";"
        n0CH.accept(this, argu);
        break;
      default:
        // should not occur !!!
        break;
    }
  }

  /**
   * Visits a {@link DefaultValue} node, whose children are the following :
   * <p>
   * f0 -> "default"<br>
   * f1 -> MemberValue()<br>
   *
   * @param n - the node to visit
   * @param argu - the user argument
   */
  @Override
  public void visit(final DefaultValue n, final A argu) {
    // f0 -> "default"
    final NodeToken n0 = n.f0;
    n0.accept(this, argu);
    // f1 -> MemberValue()
    final MemberValue n1 = n.f1;
    n1.accept(this, argu);
  }

}
