/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef LOGVIEWERDIALOG_H
#define LOGVIEWERDIALOG_H

#include <QtCore/QVector>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtGui/QApplication>

#include <kdialog.h>

#include "ui_logviewerdialogbase4.h"
#include "kvpncconfig.h"

class LogViewerDialog : public KDialog, public Ui_LogViewerDialogBase
{
    Q_OBJECT

public:
    LogViewerDialog(QWidget *parent, QApplication *app, KVpncConfig *GlobalConfig, const QString& caption, int count);
    ~LogViewerDialog();

    void showLogPart(int start, int count, bool parseLogType = true);

public slots:
    void accept();
    void parseLog();
    void updateLineCountClicked();
    void findLogEntryClicked();
    void find(QString what);

private:
    KVpncConfig *GlobalConfig;
    QApplication *app;
    QVector<QString> LogList;
    int linecount;
};

#endif
