/* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

/*! \file paritycommand.h 
	\brief Support for multi segment commands, eg begin..end, if..else, etc
*/

#ifndef __LW_COMMANDSEGMENT_H
#define __LW_COMMANDSEGMENT_H

#include "command.h"

/*! \class LWCommandSegment
	\brief Support for multi segment commands, eg begin..end, if..else, etc
*/

class LWCommandSegment: public LWCommand {
private:
gboolean matched;
protected:
LWCommandSegment();
public:
void match ();
virtual gboolean isSegment ();
virtual gboolean matchNextCondition(LWCommand *cmd);
virtual gboolean matchPrevCondition(LWCommand *cmd);
virtual gboolean matchWith (LWCommand *cmd) = 0;
gboolean isAlreadyMatched ();
virtual void reset1();
};

#endif
