/*
    libodsstream is a library to read and write ODS documents as streams
    Copyright (C) 2013  Olivier Langella <Olivier.Langella@moulon.inra.fr>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#ifndef ODSEXCEPTION_H
#define ODSEXCEPTION_H

#include <exception>
#include <string>
#include <QString>

class OdsException : public std::exception
{
  public:
  OdsException(QString message) throw()
  {
    _message = message;
  }

  /*mcqError(std::string message = "") throw () :
    _message(message.c_str()) {
    }*/


  virtual const char *
  what() const throw() override
  {
    return _message.toStdString().c_str();
  }

  virtual const QString &
  qwhat() const throw()
  {
    return _message;
  }

  virtual ~OdsException() throw()
  {
  }

  private:
  QString _message; // Description de l'erreur
};

#endif // ODSEXCEPTION_H
