/* This file was generated by SableCC (http://www.sablecc.org/). */

/*
 *	PrintWalker.java
 *
 *	This file is part of Tritonus: http://www.tritonus.org/
 */

/*
 *  Copyright (c) 2002 by Matthias Pfisterer
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
|<---            this code is formatted to fit into 80 columns             --->|
*/

package org.tritonus.saol.compiler;

import org.tritonus.saol.sablecc.analysis.DepthFirstAdapter;
import org.tritonus.saol.sablecc.node.*;



/**
 * Simple AST walker. This is simple Abstract Syntax Tree walker
 * which will visit each of the nodes and print on standard output the
 * name of particular node visited. This class can be very usefull while
 * testing the tree structure for a given input. Check PrintTree class.
 *@author Mariusz Nowostawski
 */
public class PrintWalker
extends DepthFirstAdapter
{
	private static final int	INDENT_STEP = 3;

	private int	indent = 0;


	void indent()
	{
		String s = new String ("");
		for (int i = 0; i < indent; i++)
		{
			s += " ";
		}
		System.out.print(s);
	}



	public void defaultIn(Node node)
	{
		indent();
		System.out.print( "in ");
		String  str = getStrippedClassName(node);
		System.out.println(str);
		indent += INDENT_STEP;
	}



	public void defaultOut(Node node)
	{
		indent -= INDENT_STEP;
		indent();
		System.out.print( "out ");
		String str = getStrippedClassName(node);
		System.out.println(str);
	}



	public void defaultCase(Node node)
	{
		indent();
		System.out.print( "case ");
		String	str = getStrippedClassName(node) + ": " + ((Token) node).getText();
		System.out.println(str);
	}


	private static String getStrippedClassName(Node node)
	{
		String	strClassName = node.getClass().getName();
		return stripClassName(strClassName);
	}



	private static String stripClassName(String strClassName)
	{
		int	nLastDotPosition = strClassName.lastIndexOf(".");
		if (nLastDotPosition >= 0)
		{
			strClassName = strClassName.substring(nLastDotPosition + 1);
		}
		return strClassName;
	}
}



/*** PrintWalker.java ***/
