/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2017 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * IQ-Bulb from Mandelbulb 3D and Inigo Quilez
 * @reference http://iquilezles.org/www/articles/mandelbulb/mandelbulb.htm

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "IqBulbIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 IqBulbIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	// extract polar coordinates
	REAL wr = aux->r;
	REAL wo = acos(native_divide(z.y, wr));
	REAL wi = atan2(z.x, z.z);

	// scale and rotate the point
	wr = native_powr(wr, fractal->transformCommon.pwr8 - 1.0f);
	aux->r_dz = mad(wr * aux->r_dz, fractal->transformCommon.pwr8, 1.0f);
	wr *= aux->r;
	wo *= fractal->transformCommon.pwr8;
	wi *= fractal->transformCommon.pwr8a;

	// convert back to cartesian coordinates
	z.x = native_sin(wo) * native_sin(wi);
	z.y = native_cos(wo);
	z.z = native_sin(wo) * native_cos(wi);

	z *= wr; // then add Cpixel constant
	return z;
}