/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvMessageMetaData.h"

#include <algorithm>

void MvMessageMetaData::registerObserver(MvMessageMetaDataObserver* o)
{
    std::vector<MvMessageMetaDataObserver*>::const_iterator it=std::find(observers_.begin(),observers_.end(),o);
    if(it == observers_.end())
        observers_.push_back(o);
}


void MvMessageMetaData::broadcast(IntMethod proc,int n)
{
    for(std::vector<MvMessageMetaDataObserver*>::const_iterator it=observers_.begin(); it != observers_.end(); ++it)
    {
        ((*it)->*proc)(n);
    }
}

void MvMessageMetaData::broadcast(VoidMethod proc)
{
    for(std::vector<MvMessageMetaDataObserver*>::const_iterator it=observers_.begin(); it != observers_.end(); ++it)
    {
        ((*it)->*proc)();
    }
}
