# Artist: the Wailers
# Album: catch a fire
# Song: stir it up

@head { 
	$tempo 160 $time_sig 4/4 $key a
	$title "The Wailers - stir it up"
}

@body {

	%define major { ( a c+ e ) } # A major chord

	%define bass_1 {
		/l4/a2 r c+3 /l8/r c+ /l4/d r c+ /l8/r
		c+ d r f+ r /l4/a /l8/r d e r g+ r /l4/b r 
	}

	%define bass_2 {
		/l8/a2 r b r c+3 r a2 r /r8/r
		d3 r e r f+ r d r /r8/r
	}

	@channel 1 bass {
		$patch bass_fg $volume 48

		%repeat 4 { ~bass_1 }
		%repeat 2 { ~bass_2 }
		%repeat 4 { ~bass_1 }
	}

	@channel 2 "rhythm guitar" {
		$patch guitar_muted $length 16 $octave 4 $volume 32

		%repeat 10 {
			%repeat 4 {
				/r4/r %repeat 2 { ~major r }      # A chords
			}
			%repeat 2 { 
				/r4/r %repeat 2 { ~major/5/ r }   # D chords
			}
			%repeat 2 {
				/r4/r %repeat 2 { ~major/7/ r }   # E chords
			}
		}
	}

	@channel 10 "drums" {
		$volume 127
		$reverb 32
		$attack 104-127

		%repeat 4 {
			%repeat 4 { /l2/r bd }
		}

		/l8:1/r

		%repeat 4 {
			%repeat 4 { /l2/r bd }
		}
	}

	@channel 10 "hats" {
		$attack 80-127

		%choose 16:1 {
			32 /l4/hh_c
			4 /l4/hh_o
			1 /l4/r
		}

		/l8:1/r

		%choose 16:1 {
			32 /l4/hh_c
			6 /l4/hh_p
			1 /l4/r
		}

	}

	@channel 10 "percussion" {
		$attack 64-96

		%choose 16:1 {
			1 /l8/tom_h
			1 /l8/conga_h_mute
			1 /l8/conga_h_open
			1 /l8/conga_l
			20 /l8/r
		}

		/l8:1/r

		%choose 16:1 {
			1 /l8/tom_h
			1 /l8/conga_h_mute
			1 /l8/conga_h_open
			1 /l8/conga_l
			1 /l8/wood_l
			20 /l8/r
		}
	}
}
