eslint-plugin-html
==================

[![Build Status](https://travis-ci.org/BenoitZugmeyer/eslint-plugin-html.svg?branch=master)](https://travis-ci.org/BenoitZugmeyer/eslint-plugin-html)

This [`ESLint`](http://eslint.org) plugin allows linting and fixing inline scripts contained in HTML
files.

Migration to v3
---------------

If you are considering upgrading to v3, please read [this guide](MIGRATION_TO_V3.md).

Usage
-----

Simply install via `npm install --save-dev eslint-plugin-html` and add the plugin to your ESLint
configuration. See
[ESLint documentation](http://eslint.org/docs/user-guide/configuring#configuring-plugins).

Example:

```javascript
{
    "plugins": [
        "html"
    ]
}
```

Note: by default, when executing the `eslint` command on a directory, only `.js` files will be
linted. You will have to specify extra extensions with the `--ext` option. Example: `eslint --ext
.html,.js src` will lint both `.html` and `.js` files in the `src` directory. See [ESLint
documentation](http://eslint.org/docs/user-guide/command-line-interface#ext).

XML support
-----------

This plugin parses HTML and XML markup slightly differently, mainly when considering `CDATA`
sections:
* in XML, any data inside a `CDATA` section will be considered as raw text (not XML) and the `CDATA`
  delimiter will be droped ;
* in HTML, there is no such thing for `<script>` tags: the `CDATA` delimiter is considered as normal
  text and thus, part of the script.


Settings
--------

> Note: all settings can be written either as `"html/key": value` or in a nested object `"html": {
> "key": value }`

### `html/html-extensions`

By default, this plugin will only consider files ending with those extensions as HTML: `.erb`,
`.handlebars`, `.hbs`, `.htm`, `.html`, `.mustache`, `.nunjucks`, `.php`, `.tag`, `.twig`, `.vue`,
`.we`. You can set your own list of HTML extensions by using this setting. Example:

```javascript
{
    "plugins": [ "html" ],
    "settings": {
        "html/html-extensions": [".html", ".we"],  // consider .html and .we files as HTML
    }
}
```


### `html/xml-extensions`

By default, this plugin will only consider files ending with those extensions as XML: `.xhtml`,
`.xml`. You can set your own list of XML extensions by using this setting. Example:

```javascript
{
    "plugins": [ "html" ],
    "settings": {
        "html/xml-extensions": [".html"],  // consider .html files as XML
    }
}
```


### `html/indent`

By default, the code between `<script>` tags is dedented according to the first non-empty line. The
setting `html/indent` allows to ensure that every script tags follow an uniform indentation. Like
the `indent` rule, you can pass a number of spaces, or `"tab"` to indent with one tab. Prefix this
value with a `+` to be relative to the `<script>` tag indentation. Example:

```javascript
{
    "plugins": [ "html" ],
    "settings": {
        "html/indent": "0",   // code should start at the beginning of the line (no initial indentation).
        "html/indent": "+2",  // indentation is the <script> indentation plus two spaces.
        "html/indent": "tab", // indentation is one tab at the beginning of the line.
    }
}
```


### `html/report-bad-indent`

By default, this plugin won't warn if it encounters a problematic indentation (ex: a line is under
indented). If you want to make sure the indentation is correct, use the `html/report-bad-indent` in
conjunction with the `indent` rule. Pass `"warn"` or `1` to display warnings, `"error"` or `2` to
display errors. Example:

```javascript
{
    "plugins": [ "html" ],
    "settings": {
        "html/report-bad-indent": "error",
    }
}
```


### `html/javascript-mime-types`

By default, the code between `<script>` tags is considered as JavaScript code only if there is no
`type` attribute or if its value matches the pattern
`/^(application|text)\/(x-)?(javascript|babel|ecmascript-6)$/i`. You can customize the types that
should be considered as JavaScript by providing one or multiple MIME types. If a MIME type starts
with a `/`, it will be considered as a regular expression. Example:

```javascript
{
    "plugins": [ "html" ],
    "settings": {
        "html/javascript-mime-types": ["text/javascript", "text/jsx"],  // also use script tags with a "text/jsx" type attribute
        "html/javascript-mime-types": "/^text\\/(javascript|jsx)$/",    // same thing
    }
}
```

Troubleshooting
---------------

### Linting templates (or PHP)

`eslint-plugin-html` won't evaluate or remove your template markup.  If you have template markup in
your script tags, the resulting script may not be valid JavaScript, so `ESLint` will fail to parse
it.

One possible hacky workaround to make sure the code is valid JavaScript is to put your template
markup inside a comment.  When the template is rendered, the generated JS code must start with a new
line, so it will be written below the comment.  PHP example:

```html
<script>
var mydata;
// <?= "\n mydata = " . json_encode($var) . ";" ?>
console.log(mydata);
</script>
```


### Linting VUE files

Initially, [`eslint-plugin-vue`](https://github.com/vuejs/eslint-plugin-vue) was using
`eslint-plugin-html` to lint code inside script tags.  Since v3, `eslint-plugin-vue` is using its
own parser, so it is *incompatible* with `eslint-plugin-html`.  You should remove
`eslint-plugin-html` from your dependencies if you still have this.
