% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{edge}
\alias{edge}
\alias{edges}
\title{Helper function for adding and deleting edges}
\usage{
edge(...)

edges(...)
}
\arguments{
\item{...}{See details below.}
}
\value{
A special object that can be used with together with
  igraph graphs and the plus and minus operators.
}
\description{
This is a helper function that simplifies adding and deleting
edges to/from graphs.
}
\details{
\code{edges} is an alias for \code{edge}.


When adding edges via \code{+}, all unnamed arguments of
\code{edge} (or \code{edges}) are concatenated, and then passed to
\code{\link{add_edges}}. They are interpreted as pairs of vertex ids,
and an edge will added between each pair. Named arguments will be
used as edge attributes for the new edges.

When deleting edges via \code{-}, all arguments of \code{edge} (or
\code{edges}) are concatenated via \code{c()} and passed to
\code{\link{delete_edges}}.
}
\examples{
g <- make_ring(10) \%>\%
  set_edge_attr("color", value = "red")

g <- g + edge(1, 5, color = "green") +
  edge(2, 6, color = "blue") -
  edge("8|9")

E(g)[[]]

g \%>\%
  add_layout_(in_circle()) \%>\%
  plot()

g <- make_ring(10) + edges(1:10)
plot(g)
}
\seealso{
Other functions for manipulating graph structure: \code{\link{+.igraph}},
  \code{\link{add_edges}}, \code{\link{add_vertices}},
  \code{\link{delete_edges}},
  \code{\link{delete_vertices}},
  \code{\link{igraph-minus}}, \code{\link{path}},
  \code{\link{vertex}}
}
\concept{functions for manipulating graph structure}
