% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatter.r
\name{ordinal_format}
\alias{ordinal_format}
\alias{ordinal}
\alias{ordinal_english}
\alias{ordinal_french}
\alias{ordinal_spanish}
\title{Ordinal formatter: add ordinal suffixes (-st, -nd, -rd, -th) to numbers.}
\usage{
ordinal_format(prefix = "", suffix = "", big.mark = " ",
  rules = ordinal_english(), ...)

ordinal(x, prefix = "", suffix = "", big.mark = " ",
  rules = ordinal_english(), ...)

ordinal_english()

ordinal_french()

ordinal_spanish()
}
\arguments{
\item{prefix, suffix}{Symbols to display before and after value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{rules}{Named list of regular expressions, match in order. Name gives
suffix, and value specifies which numbers to match.}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}

\item{x}{A numeric vector of positive values to format.}
}
\value{
A function with single parameter \code{x}, a numeric vector, that
returns a character vector
}
\description{
\code{ordinal_english()}, \code{ordinal_french()} and \code{ordinal_spanish()} provide
rules for computing ordinal indicators in English, French and Spanish
respectively.
}
\note{
Values in \code{x} will be rounded before formating.
}
\examples{
ordinal_format()(1:10)
ordinal(1:10)

# Custom rules for French
french <- list(
  er = "^1$",
  nd = "^2$",
  e = "."
)
ordinal(1:20, rules = french)

# You can also use directly
ordinal(1:20, rules = ordinal_french())
}
