% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structure.R
\name{raw_string}
\alias{raw_string}
\alias{print.xfun_raw_string}
\title{Print a character vector in its raw form}
\usage{
raw_string(x)

\method{print}{xfun_raw_string}(x, ...)
}
\arguments{
\item{x}{For \code{raw_string()}, a character vector. For the print method,
the \code{raw_string()} object.}

\item{...}{Other arguments (currently ignored).}
}
\description{
The function \code{raw_string()} assigns the class \code{xfun_raw_string} to
the character vector, and the corresponding printing function
\code{print.xfun_raw_string()} uses \code{cat(x, sep = '\n')} to write the
character vector to the console, which will suppress the leading indices
(such as \code{[1]}) and double quotes, and it may be easier to read the
characters in the raw form (especially when there are escape sequences).
}
\examples{
library(xfun)
raw_string(head(LETTERS))
raw_string(c("a \"b\"", "hello\\tworld!"))
}
