/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_17 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 3750, "epsg", 3750,
        "NAD83(HARN) / UTM zone 4N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 4N\",GEOGCS[\"NAD83(HARN");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-159],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3750\"]]");
    p = add_epsg_def_ex (filter, first, last, 3751, "epsg", 3751,
        "NAD83(HARN) / UTM zone 5N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / UTM zone 5N\",GEOGCS[\"NAD83(HARN");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-153],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"3751\"]]");
    p = add_epsg_def_ex (filter, first, last, 3752, "epsg", 3752,
        "WGS 84 / Mercator 41 (deprecated)", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=100 +lat_ts=-41 +x_0=0 +y_0=0 +datum=W");
    add_proj4text (p, 1,
        "GS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Mercator 41 (deprecated)\",GEOGCS[\"WG");
    add_srs_wkt (p, 1,
        "S 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Mercator_1SP\"],PARAMETER[\"latitude_of_origin\",-41],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",100],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"3752\"]]");
    p = add_epsg_def_ex (filter, first, last, 3753, "epsg", 3753,
        "NAD83(HARN) / Ohio North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=G");
    add_proj4text (p, 2,
        "RS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Ohio North (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",41.7],PARAMETER[\"standard_parallel_2\",40.43");
    add_srs_wkt (p, 10,
        "333333333333],PARAMETER[\"latitude_of_origin\",39.666666");
    add_srs_wkt (p, 11,
        "66666666],PARAMETER[\"central_meridian\",-82.5],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_easting\",1968500],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 13,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 15,
        "AUTHORITY[\"EPSG\",\"3753\"]]");
    p = add_epsg_def_ex (filter, first, last, 3754, "epsg", 3754,
        "NAD83(HARN) / Ohio South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Ohio South (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",40.03333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",38.73333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 11,
        "n\",38],PARAMETER[\"central_meridian\",-82.5],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_easting\",1968500],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 13,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"3754\"]]");
    p = add_epsg_def_ex (filter, first, last, 3755, "epsg", 3755,
        "NAD83(HARN) / Wyoming East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wyoming East (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",40.5],PARAMETER[\"central_meridian\",-105.166666666");
    add_srs_wkt (p, 10,
        "6667],PARAMETER[\"scale_factor\",0.9999375],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",656166.6667],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"3755\"]]");
    p = add_epsg_def_ex (filter, first, last, 3756, "epsg", 3756,
        "NAD83(HARN) / Wyoming East Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wyoming East Central (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referenc");
    add_srs_wkt (p, 2,
        "e_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",40.5],PARAMETER[\"central_meridian\",-107.");
    add_srs_wkt (p, 10,
        "3333333333333],PARAMETER[\"scale_factor\",0.9999375],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",1312333.3333],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",328083.3333],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 13,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3756\"]]");
    p = add_epsg_def_ex (filter, first, last, 3757, "epsg", 3757,
        "NAD83(HARN) / Wyoming West Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0");
    add_proj4text (p, 1,
        "=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 2,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wyoming West Central (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referenc");
    add_srs_wkt (p, 2,
        "e_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",40.5],PARAMETER[\"central_meridian\",-108.");
    add_srs_wkt (p, 10,
        "75],PARAMETER[\"scale_factor\",0.9999375],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",1968500],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"3757\"]]");
    p = add_epsg_def_ex (filter, first, last, 3758, "epsg", 3758,
        "NAD83(HARN) / Wyoming West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9");
    add_proj4text (p, 1,
        "999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +el");
    add_proj4text (p, 2,
        "lps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Wyoming West (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",40.5],PARAMETER[\"central_meridian\",-110.083333333");
    add_srs_wkt (p, 10,
        "3333],PARAMETER[\"scale_factor\",0.9999375],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",2624666.6667],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",328083.3333],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"3758\"]]");
    p = add_epsg_def_ex (filter, first, last, 3759, "epsg", 3759,
        "NAD83 / Hawaii zone 3 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99");
    add_proj4text (p, 1,
        "999 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Hawaii zone 3 (ftUS)\",GEOGCS[\"NAD83\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",21.16666666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-158],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.99999],PARAMETER[\"false_easting\",1640416.6");
    add_srs_wkt (p, 11,
        "667],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"37");
    add_srs_wkt (p, 14,
        "59\"]]");
    p = add_epsg_def_ex (filter, first, last, 3760, "epsg", 3760,
        "NAD83(HARN) / Hawaii zone 3 (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99");
    add_proj4text (p, 1,
        "999 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 2,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Hawaii zone 3 (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",21.16666666666667],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-158],PARAMETER[\"scale_factor\",0.99999],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",1640416.6667],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"3760\"]]");
    p = add_epsg_def_ex (filter, first, last, 3761, "epsg", 3761,
        "NAD83(CSRS) / UTM zone 22N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / UTM zone 22N\",GEOGCS[\"NAD83(CSR");
    add_srs_wkt (p, 1,
        "S)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"3761\"]]");
    p = add_epsg_def_ex (filter, first, last, 3762, "epsg", 3762,
        "WGS 84 / South Georgia Lambert", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-54 +lat_2=-54.75 +lat_0=-55 +lon_0=-37");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / South Georgia Lambert\",GEOGCS[\"WGS 8");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2");
    add_srs_wkt (p, 2,
        "57223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 6,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 8,
        "lel_1\",-54],PARAMETER[\"standard_parallel_2\",-54.75],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"latitude_of_origin\",-55],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-37],PARAMETER[\"false_easting\",0],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"3762\"]]");
    p = add_epsg_def_ex (filter, first, last, 3763, "epsg", 3763,
        "ETRS89 / Portugal TM06", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66825833333333 +lon_0=-8.133108333");
    add_proj4text (p, 1,
        "333334 +k=1 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Portugal TM06\",GEOGCS[\"ETRS89\",DATU");
    add_srs_wkt (p, 1,
        "M[\"European_Terrestrial_Reference_System_1989\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.668");
    add_srs_wkt (p, 9,
        "25833333333],PARAMETER[\"central_meridian\",-8.133108333");
    add_srs_wkt (p, 10,
        "333334],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3763\"]]");
    p = add_epsg_def_ex (filter, first, last, 3764, "epsg", 3764,
        "NZGD2000 / Chatham Island Circuit 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-44 +lon_0=-176.5 +k=1 +x_0=400000 +y");
    add_proj4text (p, 1,
        "_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Chatham Island Circuit 2000\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NZGD2000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",-44],PARAMETER[\"central_meridian\",-176.5],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",400000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",800000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AUTHORITY[\"EPSG\",\"3764\"]]");
    p = add_epsg_def_ex (filter, first, last, 3765, "epsg", 3765,
        "HTRS96 / Croatia TM", 0, 0,
        "GRS 1980", "Greenwich",
        "Croatian_Terrestrial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=16.5 +k=0.9999 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"HTRS96 / Croatia TM\",GEOGCS[\"HTRS96\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Croatian_Terrestrial_Reference_System\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6761\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4761\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "central_meridian\",16.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "99],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"3765\"]]");
    p = add_epsg_def_ex (filter, first, last, 3766, "epsg", 3766,
        "HTRS96 / Croatia LCC", 0, 0,
        "GRS 1980", "Greenwich",
        "Croatian_Terrestrial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.91666666666666 +lat_2=43.08333333333");
    add_proj4text (p, 1,
        "334 +lat_0=0 +lon_0=16.5 +x_0=0 +y_0=0 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"HTRS96 / Croatia LCC\",GEOGCS[\"HTRS96\",DATUM[");
    add_srs_wkt (p, 1,
        "\"Croatian_Terrestrial_Reference_System\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6761\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4761\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 8,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",45.9");
    add_srs_wkt (p, 9,
        "1666666666666],PARAMETER[\"standard_parallel_2\",43.0833");
    add_srs_wkt (p, 10,
        "3333333334],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",16.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"3766\"]]");
    p = add_epsg_def_ex (filter, first, last, 3767, "epsg", 3767,
        "HTRS96 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "Croatian_Terrestrial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"HTRS96 / UTM zone 33N\",GEOGCS[\"HTRS96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Croatian_Terrestrial_Reference_System\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6761\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4761\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",15],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"3767\"]]");
    p = add_epsg_def_ex (filter, first, last, 3768, "epsg", 3768,
        "HTRS96 / UTM zone 34N", 0, 0,
        "GRS 1980", "Greenwich",
        "Croatian_Terrestrial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"HTRS96 / UTM zone 34N\",GEOGCS[\"HTRS96\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Croatian_Terrestrial_Reference_System\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6761\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4761\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",21],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"3768\"]]");
    p = add_epsg_def_ex (filter, first, last, 3769, "epsg", 3769,
        "Bermuda 1957 / UTM zone 20N", 0, 0,
        "Clarke 1866", "Greenwich",
        "Bermuda_1957", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=clrk66 +towgs84=-73,213,296,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bermuda 1957 / UTM zone 20N\",GEOGCS[\"Bermuda ");
    add_srs_wkt (p, 1,
        "1957\",DATUM[\"Bermuda_1957\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-73,213,296,0,0,0,0],AUTHORITY[\"EPSG\",\"6216\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4216\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-63],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"3769\"]]");
    p = add_epsg_def_ex (filter, first, last, 3770, "epsg", 3770,
        "BDA2000 / Bermuda 2000 National Grid", 0, 0,
        "WGS 84", "Greenwich",
        "Bermuda_2000", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=32 +lon_0=-64.75 +k=1 +x_0=550000 +y_");
    add_proj4text (p, 1,
        "0=100000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"BDA2000 / Bermuda 2000 National Grid\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "BDA2000\",DATUM[\"Bermuda_2000\",SPHEROID[\"WGS 84\",637");
    add_srs_wkt (p, 2,
        "8137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6762\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4762\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",32],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-64.75],PARAMETER[\"scale_factor\",1],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",550000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"3770\"]]");
    p = add_epsg_def_ex (filter, first, last, 3771, "epsg", 3771,
        "NAD27 / Alberta 3TM ref merid 111 W", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alberta 3TM ref merid 111 W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-111],PARAMETER[\"scale_factor\",0.9999],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3771\"]]");
    p = add_epsg_def_ex (filter, first, last, 3772, "epsg", 3772,
        "NAD27 / Alberta 3TM ref merid 114 W", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-114 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alberta 3TM ref merid 114 W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-114],PARAMETER[\"scale_factor\",0.9999],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3772\"]]");
    p = add_epsg_def_ex (filter, first, last, 3773, "epsg", 3773,
        "NAD27 / Alberta 3TM ref merid 117 W", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alberta 3TM ref merid 117 W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-117],PARAMETER[\"scale_factor\",0.9999],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3773\"]]");
    p = add_epsg_def_ex (filter, first, last, 3774, "epsg", 3774,
        "NAD27 / Alberta 3TM ref merid 120 W (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alberta 3TM ref merid 120 W (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD27\",DATUM[\"North_American_Datum_1927\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Clarke 1866\",6378206.4,294.9786982138982,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-120],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3774\"]]");
    p = add_epsg_def_ex (filter, first, last, 3775, "epsg", 3775,
        "NAD83 / Alberta 3TM ref merid 111 W", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alberta 3TM ref merid 111 W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-111],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"3775\"]]");
    p = add_epsg_def_ex (filter, first, last, 3776, "epsg", 3776,
        "NAD83 / Alberta 3TM ref merid 114 W", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-114 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alberta 3TM ref merid 114 W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-114],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"3776\"]]");
    p = add_epsg_def_ex (filter, first, last, 3777, "epsg", 3777,
        "NAD83 / Alberta 3TM ref merid 117 W", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alberta 3TM ref merid 117 W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-117],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"3777\"]]");
    p = add_epsg_def_ex (filter, first, last, 3778, "epsg", 3778,
        "NAD83 / Alberta 3TM ref merid 120 W (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alberta 3TM ref merid 120 W (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",-120],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3778\"]]");
    p = add_epsg_def_ex (filter, first, last, 3779, "epsg", 3779,
        "NAD83(CSRS) / Alberta 3TM ref merid 111 W", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Alberta 3TM ref merid 111 W\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-111],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3779\"]]");
    p = add_epsg_def_ex (filter, first, last, 3780, "epsg", 3780,
        "NAD83(CSRS) / Alberta 3TM ref merid 114 W", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-114 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Alberta 3TM ref merid 114 W\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-114],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3780\"]]");
    p = add_epsg_def_ex (filter, first, last, 3781, "epsg", 3781,
        "NAD83(CSRS) / Alberta 3TM ref merid 117 W", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Alberta 3TM ref merid 117 W\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-117],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3781\"]]");
    p = add_epsg_def_ex (filter, first, last, 3782, "epsg", 3782,
        "NAD83(CSRS) / Alberta 3TM ref merid 120 W (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Alberta 3TM ref merid 120 W (depr");
    add_srs_wkt (p, 1,
        "ecated)\",GEOGCS[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"4617\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 10,
        "dian\",-120],PARAMETER[\"scale_factor\",0.9999],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",0],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 13,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"3782\"]]");
    p = add_epsg_def_ex (filter, first, last, 3783, "epsg", 3783,
        "Pitcairn 2006 / Pitcairn TM 2006", 0, 0,
        "WGS 84", "Greenwich",
        "Pitcairn_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-25.06855261111111 +lon_0=-130.112967");
    add_proj4text (p, 1,
        "1111111 +k=1 +x_0=14200 +y_0=15500 +ellps=WGS84 +towgs84");
    add_proj4text (p, 2,
        "=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pitcairn 2006 / Pitcairn TM 2006\",GEOGCS[\"Pit");
    add_srs_wkt (p, 1,
        "cairn 2006\",DATUM[\"Pitcairn_2006\",SPHEROID[\"WGS 84\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6763\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4763\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",-25.06855261111111]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-130.1129671111111],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",14");
    add_srs_wkt (p, 11,
        "200],PARAMETER[\"false_northing\",15500],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3783\"]]");
    p = add_epsg_def_ex (filter, first, last, 3784, "epsg", 3784,
        "Pitcairn 1967 / UTM zone 9S", 0, 0,
        "International 1924", "Greenwich",
        "Pitcairn_1967", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +south +ellps=intl +towgs84=185,165,42");
    add_proj4text (p, 1,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pitcairn 1967 / UTM zone 9S\",GEOGCS[\"Pitcairn");
    add_srs_wkt (p, 1,
        " 1967\",DATUM[\"Pitcairn_1967\",SPHEROID[\"International");
    add_srs_wkt (p, 2,
        " 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[185,165,42,0,0,0,0],AUTHORITY[\"EPSG\",\"6729\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4729\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-129],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"3784\"]]");
    p = add_epsg_def_ex (filter, first, last, 3785, "epsg", 3785,
        "Popular Visualisation CRS / Mercator (deprecated)", 0, 0,
        "Popular Visualisation Sphere", "Greenwich",
        "Popular_Visualisation_Datum", "Mercator_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 ");
    add_proj4text (p, 1,
        "+x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext ");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Popular Visualisation CRS / Mercator (deprecate");
    add_srs_wkt (p, 1,
        "d)\",GEOGCS[\"Popular Visualisation CRS\",DATUM[\"Popula");
    add_srs_wkt (p, 2,
        "r_Visualisation_Datum\",SPHEROID[\"Popular Visualisation");
    add_srs_wkt (p, 3,
        " Sphere\",6378137,0,AUTHORITY[\"EPSG\",\"7059\"]],TOWGS8");
    add_srs_wkt (p, 4,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6055\"]],PRIMEM[\"");
    add_srs_wkt (p, 5,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 6,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 7,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 8,
        "[\"EPSG\",\"4055\"]],PROJECTION[\"Mercator_1SP\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",0],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],EXTENSION[\"PROJ4\",\"");
    add_srs_wkt (p, 13,
        "+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 ");
    add_srs_wkt (p, 14,
        "+x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext ");
    add_srs_wkt (p, 15,
        " +no_defs\"],AUTHORITY[\"EPSG\",\"3785\"]]");
    p = add_epsg_def_ex (filter, first, last, 3786, "epsg", 3786,
        "World Equidistant Cylindrical (Sphere) (deprecated)", 0, 0,
        "GRS 1980 Authalic Sphere", "Greenwich",
        "Not_specified_based_on_GRS_1980_Authalic_Sphere", "Equirectangular", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +a=6");
    add_proj4text (p, 1,
        "371007 +b=6371007 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"World Equidistant Cylindrical (Sphere) (depreca");
    add_srs_wkt (p, 1,
        "ted)\",GEOGCS[\"Unspecified datum based upon the GRS 198");
    add_srs_wkt (p, 2,
        "0 Authalic Sphere\",DATUM[\"Not_specified_based_on_GRS_1");
    add_srs_wkt (p, 3,
        "980_Authalic_Sphere\",SPHEROID[\"GRS 1980 Authalic Spher");
    add_srs_wkt (p, 4,
        "e\",6371007,0,AUTHORITY[\"EPSG\",\"7048\"]],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6047\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 8,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4047\"]],PROJECTI");
    add_srs_wkt (p, 9,
        "ON[\"Equirectangular\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",0],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3786\"]]");
    p = add_epsg_def_ex (filter, first, last, 3787, "epsg", 3787,
        "MGI / Slovene National Grid (deprecated)", 0, 0,
        "Bessel 1841", "Greenwich",
        "Militar_Geographische_Institute", "Transverse_Mercator", "metre",
        "Y", "East", "X", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919");
    add_proj4text (p, 2,
        ",5.137,1.474,5.297,2.4232 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"MGI / Slovene National Grid (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"MGI\",DATUM[\"Militar_Geographische_Institute\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7004\"]],TOWGS84[577.326,90.129,463.919,5.137");
    add_srs_wkt (p, 4,
        ",1.474,5.297,2.4232],AUTHORITY[\"EPSG\",\"6312\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 8,
        "RITY[\"EPSG\",\"4312\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 9,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",15],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",-5000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"Y\",EAST],AXIS[\"X\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"3787\"]]");
    p = add_epsg_def_ex (filter, first, last, 3788, "epsg", 3788,
        "NZGD2000 / Auckland Islands TM 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=166 +k=1 +x_0=3500000 +y_0=1");
    add_proj4text (p, 1,
        "0000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Auckland Islands TM 2000\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NZGD2000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",166],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",3500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"3788\"]]");
    p = add_epsg_def_ex (filter, first, last, 3789, "epsg", 3789,
        "NZGD2000 / Campbell Island TM 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=169 +k=1 +x_0=3500000 +y_0=1");
    add_proj4text (p, 1,
        "0000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Campbell Island TM 2000\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ZGD2000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",169],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1],PARAMETER[\"false_easting\",3500000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AUTHORITY[\"EPSG\",\"3789\"]]");
    p = add_epsg_def_ex (filter, first, last, 3790, "epsg", 3790,
        "NZGD2000 / Antipodes Islands TM 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=179 +k=1 +x_0=3500000 +y_0=1");
    add_proj4text (p, 1,
        "0000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Antipodes Islands TM 2000\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NZGD2000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",179],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",3500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AUTHORITY[\"EPSG\",\"3790\"]]");
    p = add_epsg_def_ex (filter, first, last, 3791, "epsg", 3791,
        "NZGD2000 / Raoul Island TM 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-178 +k=1 +x_0=3500000 +y_0=");
    add_proj4text (p, 1,
        "10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Raoul Island TM 2000\",GEOGCS[\"NZGD");
    add_srs_wkt (p, 1,
        "2000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",-178],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",3500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AUTHORITY[\"EPSG\",\"3791\"]]");
    p = add_epsg_def_ex (filter, first, last, 3793, "epsg", 3793,
        "NZGD2000 / Chatham Islands TM 2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-176.5 +k=1 +x_0=3500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / Chatham Islands TM 2000\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "ZGD2000\",DATUM[\"New_Zealand_Geodetic_Datum_2000\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6167\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-176.5],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1],PARAMETER[\"false_easting\",3500000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AUTHORITY[\"EPSG\",\"3793\"]]");
    p = add_epsg_def_ex (filter, first, last, 3794, "epsg", 3794,
        "Slovenia 1996 / Slovene National Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Slovenia_Geodetic_Datum_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Slovenia 1996 / Slovene National Grid\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Slovenia 1996\",DATUM[\"Slovenia_Geodetic_Datum_1996\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6765\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4765\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.9999],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",-5000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3794\"]]");
    p = add_epsg_def_ex (filter, first, last, 3795, "epsg", 3795,
        "NAD27 / Cuba Norte", 0, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "metre",
        "Y", "North", "X", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=23 +lat_2=21.7 +lat_0=22.35 +lon_0=-81 ");
    add_proj4text (p, 1,
        "+x_0=500000 +y_0=280296.016 +datum=NAD27 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Cuba Norte\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_1\",23],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 9,
        "l_2\",21.7],PARAMETER[\"latitude_of_origin\",22.35],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",-81],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",500000],PARAMETER[\"false_northing\",280296.016],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AXIS[\"X\",EAST],AUTHORITY[\"EPSG\",\"3795\"]]");
    p = add_epsg_def_ex (filter, first, last, 3796, "epsg", 3796,
        "NAD27 / Cuba Sur", 0, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "metre",
        "Y", "North", "X", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=21.3 +lat_2=20.13333333333333 +lat_0=20");
    add_proj4text (p, 1,
        ".71666666666667 +lon_0=-76.83333333333333 +x_0=500000 +y");
    add_proj4text (p, 2,
        "_0=229126.939 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Cuba Sur\",GEOGCS[\"NAD27\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",21.3],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 9,
        "l_2\",20.13333333333333],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",20.71666666666667],PARAMETER[\"central_meridian\",-76.8");
    add_srs_wkt (p, 11,
        "3333333333333],PARAMETER[\"false_easting\",500000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",229126.939],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Y\",NORTH],AXIS[\"X\",");
    add_srs_wkt (p, 14,
        "EAST],AUTHORITY[\"EPSG\",\"3796\"]]");
    p = add_epsg_def_ex (filter, first, last, 3797, "epsg", 3797,
        "NAD27 / MTQ Lambert", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=50 +lat_2=46 +lat_0=44 +lon_0=-70 +x_0=");
    add_proj4text (p, 1,
        "800000 +y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTQ Lambert\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",50],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_2\",46],PARAMETER[\"latitude_of_origin\",44],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"central_meridian\",-70],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "800000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"3797\"]]");
    p = add_epsg_def_ex (filter, first, last, 3798, "epsg", 3798,
        "NAD83 / MTQ Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=50 +lat_2=46 +lat_0=44 +lon_0=-70 +x_0=");
    add_proj4text (p, 1,
        "800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / MTQ Lambert\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"standard_parallel_1\",50],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_2\",46],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",44],PARAMETER[\"central_meridian\",-70],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",800000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3798\"]]");
    p = add_epsg_def_ex (filter, first, last, 3799, "epsg", 3799,
        "NAD83(CSRS) / MTQ Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=50 +lat_2=46 +lat_0=44 +lon_0=-70 +x_0=");
    add_proj4text (p, 1,
        "800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTQ Lambert\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"L");
    add_srs_wkt (p, 8,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",50],PARAMETER[\"standard_parallel_2\",46],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",44],PARAMETER[\"central_merid");
    add_srs_wkt (p, 11,
        "ian\",-70],PARAMETER[\"false_easting\",800000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"3799\"]]");
    p = add_epsg_def_ex (filter, first, last, 3800, "epsg", 3800,
        "NAD27 / Alberta 3TM ref merid 120 W", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alberta 3TM ref merid 120 W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-120],PARAMETER[\"scale_factor\",0.9999],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"3800\"]]");
    p = add_epsg_def_ex (filter, first, last, 3801, "epsg", 3801,
        "NAD83 / Alberta 3TM ref merid 120 W", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Alberta 3TM ref merid 120 W\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-120],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"3801\"]]");
    p = add_epsg_def_ex (filter, first, last, 3802, "epsg", 3802,
        "NAD83(CSRS) / Alberta 3TM ref merid 120 W", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / Alberta 3TM ref merid 120 W\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS)\",DATUM[\"NAD83_Canadian_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",-120],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eas");
    add_srs_wkt (p, 11,
        "ting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3802\"]]");
    p = add_epsg_def_ex (filter, first, last, 3812, "epsg", 3812,
        "ETRS89 / Belgian Lambert 2008", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=50.797815 +lon_0=4.359215833333333 +x_0=64932");
    add_proj4text (p, 2,
        "8 +y_0=665262 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units");
    add_proj4text (p, 3,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / Belgian Lambert 2008\",GEOGCS[\"ETRS89");
    add_srs_wkt (p, 1,
        "\",DATUM[\"European_Terrestrial_Reference_System_1989\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",49.83333333333334],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",51.16666666666666],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 11,
        "n\",50.797815],PARAMETER[\"central_meridian\",4.35921583");
    add_srs_wkt (p, 12,
        "3333333],PARAMETER[\"false_easting\",649328],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",665262],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 15,
        "RITY[\"EPSG\",\"3812\"]]");
    p = add_epsg_def_ex (filter, first, last, 3814, "epsg", 3814,
        "NAD83 / Mississippi TM", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=32.5 +lon_0=-89.75 +k=0.9998335 +x_0=");
    add_proj4text (p, 1,
        "500000 +y_0=1300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Mississippi TM\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",32.5],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-89.75],PARAMETER[\"scale_factor\",0.99983");
    add_srs_wkt (p, 10,
        "35],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",1300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"3814\"]]");
    p = add_epsg_def_ex (filter, first, last, 3815, "epsg", 3815,
        "NAD83(HARN) / Mississippi TM", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=32.5 +lon_0=-89.75 +k=0.9998335 +x_0=");
    add_proj4text (p, 1,
        "500000 +y_0=1300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Mississippi TM\",GEOGCS[\"NAD83(H");
    add_srs_wkt (p, 1,
        "ARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "32.5],PARAMETER[\"central_meridian\",-89.75],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",0.9998335],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",1300000],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3815\"]]");
    p = add_epsg_def_ex (filter, first, last, 3816, "epsg", 3816,
        "NAD83(NSRS2007) / Mississippi TM", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=32.5 +lon_0=-89.75 +k=0.9998335 +x_0=");
    add_proj4text (p, 1,
        "500000 +y_0=1300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Mississippi TM\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference_");
    add_srs_wkt (p, 2,
        "System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722210");
    add_srs_wkt (p, 3,
        "1,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",32.5],PARAMETER[\"central_meridian\",-89");
    add_srs_wkt (p, 10,
        ".75],PARAMETER[\"scale_factor\",0.9998335],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1300");
    add_srs_wkt (p, 12,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3816");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 3819, "epsg", 3819,
        "HD1909", 1, 1,
        "Bessel 1841", "Greenwich",
        "Hungarian_Datum_1909", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=595.48,121.69,515.3");
    add_proj4text (p, 1,
        "5,4.115,-2.9383,0.853,-3.408 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"HD1909\",DATUM[\"Hungarian_Datum_1909\",SPHEROI");
    add_srs_wkt (p, 1,
        "D[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7004\"]],TOWGS84[595.48,121.69,515.35,4.115,-2.93");
    add_srs_wkt (p, 3,
        "83,0.853,-3.408],AUTHORITY[\"EPSG\",\"1024\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"3819\"]]");
    p = add_epsg_def_ex (filter, first, last, 3821, "epsg", 3821,
        "TWD67", 1, 1,
        "GRS 1967 Modified", "Greenwich",
        "Taiwan_Datum_1967", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=aust_SA +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TWD67\",DATUM[\"Taiwan_Datum_1967\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "GRS 1967 Modified\",6378160,298.25,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "7050\"]],AUTHORITY[\"EPSG\",\"1025\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 3,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 4,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 5,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"3821\"]]");
    p = add_epsg_def_ex (filter, first, last, 3824, "epsg", 3824,
        "TWD97", 1, 1,
        "GRS 1980", "Greenwich",
        "Taiwan_Datum_1997", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"TWD97\",DATUM[\"Taiwan_Datum_1997\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1026\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"3824\"]]");
    p = add_epsg_def_ex (filter, first, last, 3825, "epsg", 3825,
        "TWD97 / TM2 zone 119", 0, 0,
        "GRS 1980", "Greenwich",
        "Taiwan_Datum_1997", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=119 +k=0.9999 +x_0=250000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TWD97 / TM2 zone 119\",GEOGCS[\"TWD97\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Taiwan_Datum_1997\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"1026\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "3824\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "19],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",250000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3825\"]]");
    p = add_epsg_def_ex (filter, first, last, 3826, "epsg", 3826,
        "TWD97 / TM2 zone 121", 0, 0,
        "GRS 1980", "Greenwich",
        "Taiwan_Datum_1997", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121 +k=0.9999 +x_0=250000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TWD97 / TM2 zone 121\",GEOGCS[\"TWD97\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Taiwan_Datum_1997\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 2,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"1026\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "3824\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "21],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",250000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 11,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3826\"]]");
    p = add_epsg_def_ex (filter, first, last, 3827, "epsg", 3827,
        "TWD67 / TM2 zone 119", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "Taiwan_Datum_1967", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=119 +k=0.9999 +x_0=250000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=aust_SA +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TWD67 / TM2 zone 119\",GEOGCS[\"TWD67\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Taiwan_Datum_1967\",SPHEROID[\"GRS 1967 Modified\",63781");
    add_srs_wkt (p, 2,
        "60,298.25,AUTHORITY[\"EPSG\",\"7050\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1025\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"3821\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",119],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",250000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3827\"]]");
    p = add_epsg_def_ex (filter, first, last, 3828, "epsg", 3828,
        "TWD67 / TM2 zone 121", 0, 0,
        "GRS 1967 Modified", "Greenwich",
        "Taiwan_Datum_1967", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121 +k=0.9999 +x_0=250000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=aust_SA +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TWD67 / TM2 zone 121\",GEOGCS[\"TWD67\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Taiwan_Datum_1967\",SPHEROID[\"GRS 1967 Modified\",63781");
    add_srs_wkt (p, 2,
        "60,298.25,AUTHORITY[\"EPSG\",\"7050\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"1025\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"3821\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",121],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999],PARAMETER[\"false_easting\",250000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"3828\"]]");
    p = add_epsg_def_ex (filter, first, last, 3829, "epsg", 3829,
        "Hu Tzu Shan 1950 / UTM zone 51N", 0, 0,
        "International 1924", "Greenwich",
        "Hu_Tzu_Shan_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=intl +towgs84=-637,-549,-203,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hu Tzu Shan 1950 / UTM zone 51N\",GEOGCS[\"Hu T");
    add_srs_wkt (p, 1,
        "zu Shan 1950\",DATUM[\"Hu_Tzu_Shan_1950\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-637,-549,-203,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6236\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4236\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",123],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"3829\"]]");
    p = add_epsg_def_ex (filter, first, last, 3832, "epsg", 3832,
        "WGS 84 / PDC Mercator", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / PDC Mercator\",GEOGCS[\"WGS 84\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 6,
        "T],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator_1");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"central_meridian\",150],PARAMETER[\"sc");
    add_srs_wkt (p, 8,
        "ale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 10,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AUTHORITY[\"EPSG\",\"3832\"]]");
    p = add_epsg_def_ex (filter, first, last, 3833, "epsg", 3833,
        "Pulkovo 1942(58) / Gauss-Kruger zone 2", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.8");
    add_proj4text (p, 2,
        "44,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Gauss-Kruger zone 2\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-");
    add_srs_wkt (p, 4,
        "0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4179\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3833\"]]");
    p = add_epsg_def_ex (filter, first, last, 3834, "epsg", 3834,
        "Pulkovo 1942(83) / Gauss-Kruger zone 2", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss-Kruger zone 2\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",9],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1],PARAMETER[\"false_easting\",2500000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"3834\"]]");
    p = add_epsg_def_ex (filter, first, last, 3835, "epsg", 3835,
        "Pulkovo 1942(83) / Gauss-Kruger zone 3", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss-Kruger zone 3\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1],PARAMETER[\"false_easting\",3500000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"3835\"]]");
    p = add_epsg_def_ex (filter, first, last, 3836, "epsg", 3836,
        "Pulkovo 1942(83) / Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / Gauss-Kruger zone 4\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",21],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1],PARAMETER[\"false_easting\",4500000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"3836\"]]");
    p = add_epsg_def_ex (filter, first, last, 3837, "epsg", 3837,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.8");
    add_proj4text (p, 2,
        "44,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 3");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.05");
    add_srs_wkt (p, 4,
        "3,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",3500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3837\"]]");
    p = add_epsg_def_ex (filter, first, last, 3838, "epsg", 3838,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 4");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.05");
    add_srs_wkt (p, 4,
        "3,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",4500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3838\"]]");
    p = add_epsg_def_ex (filter, first, last, 3839, "epsg", 3839,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.");
    add_proj4text (p, 2,
        "844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 9");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.05");
    add_srs_wkt (p, 4,
        "3,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",27],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",9500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3839\"]]");
    p = add_epsg_def_ex (filter, first, last, 3840, "epsg", 3840,
        "Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 10", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0");
    add_proj4text (p, 2,
        ".844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / 3-degree Gauss-Kruger zone 1");
    add_srs_wkt (p, 1,
        "0\",GEOGCS[\"Pulkovo 1942(58)\",DATUM[\"Pulkovo_1942_58\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[33.4,-146.6,-76.3,-0.359,-0.05");
    add_srs_wkt (p, 4,
        "3,0.844,-0.84],AUTHORITY[\"EPSG\",\"6179\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4179\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",30],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",10500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3840\"]]");
    p = add_epsg_def_ex (filter, first, last, 3841, "epsg", 3841,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 6", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 6");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4178\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",18],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1],PARAMETER[\"false_easting\",6500000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 13,
        "T],AUTHORITY[\"EPSG\",\"3841\"]]");
    p = add_epsg_def_ex (filter, first, last, 3842, "epsg", 3842,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 7 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 7");
    add_srs_wkt (p, 1,
        " (deprecated)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulk");
    add_srs_wkt (p, 2,
        "ovo_1942_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "78\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",18");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",6500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3842\"]]");
    p = add_epsg_def_ex (filter, first, last, 3843, "epsg", 3843,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 8 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 8");
    add_srs_wkt (p, 1,
        " (deprecated)\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulk");
    add_srs_wkt (p, 2,
        "ovo_1942_83\",SPHEROID[\"Krassowsky 1940\",6378245,298.3");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[26,-121,-78,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "78\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",18");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",6500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3843\"]]");
    p = add_epsg_def_ex (filter, first, last, 3844, "epsg", 3844,
        "Pulkovo 1942(58) / Stereo70", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_58", "Oblique_Stereographic", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=46 +lon_0=25 +k=0.99975 +x_0=500000 ");
    add_proj4text (p, 1,
        "+y_0=500000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.3");
    add_proj4text (p, 2,
        "59,-0.053,0.844,-0.84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(58) / Stereo70\",GEOGCS[\"Pulkovo ");
    add_srs_wkt (p, 1,
        "1942(58)\",DATUM[\"Pulkovo_1942_58\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6179\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4179\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",46],PARAMETER[\"central_meridian\",25],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.99975],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",500000],PARAMETER[\"false_northing\",500000],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"3844\"]]");
    p = add_epsg_def_ex (filter, first, last, 3845, "epsg", 3845,
        "SWEREF99 / RT90 7.5 gon V emulation", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.30625 +k=1.000006 +x_0=15");
    add_proj4text (p, 1,
        "00025.141 +y_0=-667.282 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SWEREF99 / RT90 7.5 gon V emulation\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "SWEREF99\",DATUM[\"SWEREF99\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6619\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4619\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",11.30625],PARAMETER[\"scale_factor\",1.000006],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",1500025.141],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",-667.282],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"3845\"]]");
    p = add_epsg_def_ex (filter, first, last, 3846, "epsg", 3846,
        "SWEREF99 / RT90 5 gon V emulation", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13.55626666666667 +k=1.00000");
    add_proj4text (p, 1,
        "58 +x_0=1500044.695 +y_0=-667.13 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SWEREF99 / RT90 5 gon V emulation\",GEOGCS[\"SW");
    add_srs_wkt (p, 1,
        "EREF99\",DATUM[\"SWEREF99\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6619\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4619\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",13.55626666666667],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 10,
        "0000058],PARAMETER[\"false_easting\",1500044.695],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",-667.13],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"3846\"]]");
    p = add_epsg_def_ex (filter, first, last, 3847, "epsg", 3847,
        "SWEREF99 / RT90 2.5 gon V emulation", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15.80628452944445 +k=1.00000");
    add_proj4text (p, 1,
        "561024 +x_0=1500064.274 +y_0=-667.711 +ellps=GRS80 +towg");
    add_proj4text (p, 2,
        "s84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SWEREF99 / RT90 2.5 gon V emulation\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "SWEREF99\",DATUM[\"SWEREF99\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6619\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4619\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",15.80628452944445],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 10,
        "00000561024],PARAMETER[\"false_easting\",1500064.274],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",-667.711],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"3847\"]]");
    p = add_epsg_def_ex (filter, first, last, 3848, "epsg", 3848,
        "SWEREF99 / RT90 0 gon emulation", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.0563 +k=1.0000054 +x_0=15");
    add_proj4text (p, 1,
        "00083.521 +y_0=-668.8440000000001 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SWEREF99 / RT90 0 gon emulation\",GEOGCS[\"SWER");
    add_srs_wkt (p, 1,
        "EF99\",DATUM[\"SWEREF99\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 2,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6619\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 6,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 7,
        "G\",\"4619\"]],PROJECTION[\"Transverse_Mercator\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"latitude_of_origin\",0],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",18.0563],PARAMETER[\"scale_factor\",1.0000054],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",1500083.521],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",-668.844],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"3848\"]]");
    p = add_epsg_def_ex (filter, first, last, 3849, "epsg", 3849,
        "SWEREF99 / RT90 2.5 gon O emulation", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20.30631666666667 +k=1.00000");
    add_proj4text (p, 1,
        "52 +x_0=1500102.765 +y_0=-670.706 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SWEREF99 / RT90 2.5 gon O emulation\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "SWEREF99\",DATUM[\"SWEREF99\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6619\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4619\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",20.30631666666667],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 10,
        "0000052],PARAMETER[\"false_easting\",1500102.765],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",-670.706],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 13,
        "T],AUTHORITY[\"EPSG\",\"3849\"]]");
    p = add_epsg_def_ex (filter, first, last, 3850, "epsg", 3850,
        "SWEREF99 / RT90 5 gon O emulation", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=22.55633333333333 +k=1.00000");
    add_proj4text (p, 1,
        "49 +x_0=1500121.846 +y_0=-672.557 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SWEREF99 / RT90 5 gon O emulation\",GEOGCS[\"SW");
    add_srs_wkt (p, 1,
        "EREF99\",DATUM[\"SWEREF99\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6619\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4619\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",22.55633333333333],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 10,
        "0000049],PARAMETER[\"false_easting\",1500121.846],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",-672.557],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAS");
    add_srs_wkt (p, 13,
        "T],AUTHORITY[\"EPSG\",\"3850\"]]");
    p = add_epsg_def_ex (filter, first, last, 3851, "epsg", 3851,
        "NZGD2000 / NZCS2000", 0, 1,
        "GRS 1980", "Greenwich",
        "New_Zealand_Geodetic_Datum_2000", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-37.5 +lat_2=-44.5 +lat_0=-41 +lon_0=17");
    add_proj4text (p, 1,
        "3 +x_0=3000000 +y_0=7000000 +ellps=GRS80 +towgs84=0,0,0,");
    add_proj4text (p, 2,
        "0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NZGD2000 / NZCS2000\",GEOGCS[\"NZGD2000\",DATUM");
    add_srs_wkt (p, 1,
        "[\"New_Zealand_Geodetic_Datum_2000\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6167\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4167\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 8,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",-37.5],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_2\",-44.5],PARAMETER[\"lati");
    add_srs_wkt (p, 10,
        "tude_of_origin\",-41],PARAMETER[\"central_meridian\",173");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",3000000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",7000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 14,
        "ST],AUTHORITY[\"EPSG\",\"3851\"]]");
    p = add_epsg_def_ex (filter, first, last, 3852, "epsg", 3852,
        "RSRGD2000 / DGLC2000", 0, 1,
        "GRS 1980", "Greenwich",
        "Ross_Sea_Region_Geodetic_Datum_2000", "Lambert_Conformal_Conic_2SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.333333333");
    add_proj4text (p, 1,
        "33333 +lat_0=-90 +lon_0=157 +x_0=500000 +y_0=0 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RSRGD2000 / DGLC2000\",GEOGCS[\"RSRGD2000\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6764\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4764\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",-7");
    add_srs_wkt (p, 9,
        "6.66666666666667],PARAMETER[\"standard_parallel_2\",-79.");
    add_srs_wkt (p, 10,
        "33333333333333],PARAMETER[\"latitude_of_origin\",-90],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"central_meridian\",157],PARAMETER[\"false_east");
    add_srs_wkt (p, 12,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 13,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 14,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"3852\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3854, "epsg", 3854,
        "County ST74", 0, 1,
        "GRS 1980", "Greenwich",
        "SWEREF99", "Transverse_Mercator", "metre",
        "x", "North", "y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=18.05787 +k=0.99999506 +x_0=");
    add_proj4text (p, 1,
        "100182.7406 +y_0=-6500620.1207 +ellps=GRS80 +towgs84=0,0");
    add_proj4text (p, 2,
        ",0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"County ST74\",GEOGCS[\"SWEREF99\",DATUM[\"SWERE");
    add_srs_wkt (p, 1,
        "F99\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6619\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4619\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 8,
        "rigin\",0],PARAMETER[\"central_meridian\",18.05787],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.99999506],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",100182.7406],PARAMETER[\"false_northing\",-650062");
    add_srs_wkt (p, 11,
        "0.1207],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"x\",NORTH],AXIS[\"y\",EAST],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 13,
        "854\"]]");
    p = add_epsg_def_ex (filter, first, last, 3857, "epsg", 3857,
        "WGS 84 / Pseudo-Mercator", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Mercator_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 ");
    add_proj4text (p, 1,
        "+x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext ");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Pseudo-Mercator\",GEOGCS[\"WGS 84\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572235");
    add_srs_wkt (p, 2,
        "63,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 3,
        "26\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercato");
    add_srs_wkt (p, 7,
        "r_1SP\"],PARAMETER[\"central_meridian\",0],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "cale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 10,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],EXTENS");
    add_srs_wkt (p, 11,
        "ION[\"PROJ4\",\"+proj=merc +a=6378137 +b=6378137 +lat_ts");
    add_srs_wkt (p, 12,
        "=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrid");
    add_srs_wkt (p, 13,
        "s=@null +wktext  +no_defs\"],AUTHORITY[\"EPSG\",\"3857\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 3873, "epsg", 3873,
        "ETRS89 / GK19FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=19500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK19FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",19],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",19500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3873\"]]");
    p = add_epsg_def_ex (filter, first, last, 3874, "epsg", 3874,
        "ETRS89 / GK20FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=20 +k=1 +x_0=20500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK20FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",20],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",20500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3874\"]]");
    p = add_epsg_def_ex (filter, first, last, 3875, "epsg", 3875,
        "ETRS89 / GK21FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=21500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK21FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",21],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",21500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3875\"]]");
    p = add_epsg_def_ex (filter, first, last, 3876, "epsg", 3876,
        "ETRS89 / GK22FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=22 +k=1 +x_0=22500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK22FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",22],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",22500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3876\"]]");
    p = add_epsg_def_ex (filter, first, last, 3877, "epsg", 3877,
        "ETRS89 / GK23FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=23500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK23FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",23],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",23500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3877\"]]");
    p = add_epsg_def_ex (filter, first, last, 3878, "epsg", 3878,
        "ETRS89 / GK24FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=24500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK24FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",24],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",24500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3878\"]]");
    p = add_epsg_def_ex (filter, first, last, 3879, "epsg", 3879,
        "ETRS89 / GK25FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK25FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",25],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",25500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3879\"]]");
    p = add_epsg_def_ex (filter, first, last, 3880, "epsg", 3880,
        "ETRS89 / GK26FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=26 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK26FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",26],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",26500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3880\"]]");
    p = add_epsg_def_ex (filter, first, last, 3881, "epsg", 3881,
        "ETRS89 / GK27FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK27FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",27],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",27500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3881\"]]");
    p = add_epsg_def_ex (filter, first, last, 3882, "epsg", 3882,
        "ETRS89 / GK28FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK28FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",28],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",28500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3882\"]]");
    p = add_epsg_def_ex (filter, first, last, 3883, "epsg", 3883,
        "ETRS89 / GK29FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK29FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",29],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",29500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3883\"]]");
    p = add_epsg_def_ex (filter, first, last, 3884, "epsg", 3884,
        "ETRS89 / GK30FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK30FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",30],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",30500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3884\"]]");
    p = add_epsg_def_ex (filter, first, last, 3885, "epsg", 3885,
        "ETRS89 / GK31FIN", 0, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ETRS89 / GK31FIN\",GEOGCS[\"ETRS89\",DATUM[\"Eu");
    add_srs_wkt (p, 1,
        "ropean_Terrestrial_Reference_System_1989\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",31],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",31500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"3885\"]]");
    p = add_epsg_def_ex (filter, first, last, 3889, "epsg", 3889,
        "IGRS", 1, 1,
        "GRS 1980", "Greenwich",
        "Iraqi_Geospatial_Reference_System", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"IGRS\",DATUM[\"Iraqi_Geospatial_Reference_Syste");
    add_srs_wkt (p, 1,
        "m\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1029\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 6,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"3889\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

