[comment {-*- tcl -*- doctools manpage}]
[manpage_begin page_util_peg n 1.0]
[keywords page]
[keywords {parser generator}]
[keywords {parsing expression grammar}]
[keywords PEG]
[keywords {text processing}]
[keywords transformation]
[copyright {2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Parser generator tools}]
[titledesc {page PEG transformation utilities}]
[category  {Page Parser Generator}]
[require page::util::peg [opt 0.1]]
[require snit]
[description]
[para]

This package provides a few common operations to PEG transformations.
They assume a [term {Normalized PE Grammar Tree}] as input, see the
package [package page::util::norm::peg], possibly augmented with
attributes coming from transformations not in conflict with the base
definition.

[para]

[section API]

[list_begin definitions]
[call [cmd ::page::util::peg::symbolNodeOf] [arg tree] [arg node]]

Given an arbitrary expression [arg node] in the AST [arg tree] it
determines the node (itself or an ancestor) containing the name of the
nonterminal symbol the node belongs to, and returns its id. The result
is either the root of the tree (for the start expression), or a
definition node.

[call [cmd ::page::util::peg::symbolOf] [arg tree] [arg node]]

As [cmd ::page::util::peg::symbolNodeOf], but returns the symbol name
instead of the node.

[call [cmd ::page::util::peg::updateUndefinedDueRemoval] [arg tree]]

The removal of nodes in the AST [arg tree] can cause symbols to lose
one or more users.

[example {
	A used by B and C,
	B is reachable,
	C is not,

	so A now loses the node in the expression for C calling it,
	or rather, not calling it anymore.
}]

This command updates the cross-references and which nonterminals are
now undefined.

[call [cmd ::page::util::peg::flatten] [arg treequery] [arg tree]]

This commands flattens nested sequence and choice operators in the AST
[arg tree], re-using the [package treeql] object [arg treequery] to
run the query determining which nodes to cut.

[call [cmd ::page::util::peg::getWarnings] [arg tree]]

This command looks at the attributes of the AST [arg tree] for
problems with the grammar and issues warnings. They do not prevent us
from writing the grammar, but still represent problems with it the
user should be made aware of.

[para]

The result of the command is a dictionary mapping nonterminal names to
their associated warnings.

[call [cmd ::page::util::peg::printWarnings] [arg msg]]

The argument of the command is a dictionary mapping nonterminal names
to their associated warnings, as generated by, for example, the
command [cmd ::page::util::peg::getWarnings].

[para]

The warnings contained therein are formatted and then printed via the
log command [cmd page_info]. This means that this command can be used
only from within a plugin managed by the package
[package page::pluginmgr].

[call [cmd ::page::util::peg::peOf] [arg tree] [arg eroot]]

This command converts the parsing expression starting at the node
[arg eroot] in the AST [arg tree] into a nested list. The exact syntax
of this list specified by the package [package grammar::peg].

[call [cmd ::page::util::peg::printTclExpr] [arg pe]]

This command converts the parsing expression contained in the nested
list [arg pe] into a Tcl string which can be placed into a Tcl script.

See the package [package grammar::peg] for the exact syntax of
[arg pe].

[list_end]

[vset CATEGORY page]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
