/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import net.tinyos.mviz.DDocument;
import net.tinyos.mviz.DLayer;
import net.tinyos.mviz.DLinkModel;
import net.tinyos.mviz.DLinkModelListener;

public class DLink
extends JComponent
implements DLinkModelListener {
    protected DLinkModel model;
    protected DDocument document;
    private DLayer layer;
    private int lastX;
    private int lastY;
    private int action;
    private static final int MOVE = 0;

    public DLink(DLinkModel dLinkModel, DDocument dDocument, DLayer dLayer) {
        this.model = dLinkModel;
        this.layer = dLayer;
        this.document = dDocument;
        dLinkModel.addListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DLink.this.selected();
                DLink.this.lastX = mouseEvent.getX() + DLink.this.getX();
                DLink.this.lastY = mouseEvent.getY() + DLink.this.getY();
                if (!(mouseEvent.isControlDown() || mouseEvent.isAltDown() || mouseEvent.isShiftDown())) {
                    DLink.this.DetermineAction(DLink.this.lastX, DLink.this.lastY);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() + DLink.this.getX();
                int n2 = mouseEvent.getY() + DLink.this.getY();
                int n3 = n - DLink.this.lastX;
                int n4 = n2 - DLink.this.lastY;
                DLink.this.lastX = n;
                DLink.this.lastY = n2;
                switch (DLink.this.action) {
                    case 0: {
                        DLink.this.DoAction(n3, n4);
                    }
                }
            }
        });
        this.synchToModel();
    }

    public DLinkModel getModel() {
        return this.model;
    }

    public void shapeChanged(DLinkModel dLinkModel, int n) {
        this.synchToModel();
        this.repaint();
    }

    public void paintShape(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.setColor(Color.BLACK);
        int n = this.model.m1.getLocX() - this.model.m2.getLocX();
        int n2 = this.model.m1.getLocY() - this.model.m2.getLocY();
        if (n == 0 && n2 == 0) {
            return;
        }
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        int n3 = (this.model.m1.getLocX() + this.model.m2.getLocX()) / 2;
        int n4 = (this.model.m1.getLocY() + this.model.m2.getLocY()) / 2;
        n4 += 8;
        n3 += 10;
        if (n * n2 < 0) {
            n4 = (int)((double)n4 + Math.abs((double)n / ((double)Math.abs(n2) + (double)Math.abs(n)) * 10.0));
            n3 = (int)((double)n3 + Math.abs((double)n / ((double)Math.abs(n2) + (double)Math.abs(n)) * 10.0));
        } else {
            n4 = (int)((double)n4 - Math.abs((double)n / ((double)Math.abs(n2) + (double)Math.abs(n)) * 10.0));
            n3 = (int)((double)n3 + Math.abs((double)n / ((double)Math.abs(n2) + (double)Math.abs(n)) * 10.0));
        }
        switch (this.layer.paintMode) {
            case 9: {
                graphics.setColor(Color.BLACK);
                graphics2D.drawString(this.document.sensed_links.elementAt(this.layer.index) + ": " + this.model.getValue(this.layer.index), n3, n4);
            }
            case 7: {
                graphics2D.setStroke(new BasicStroke(3.0f));
                graphics2D.setColor(Color.RED);
                graphics2D.draw(new Line2D.Double(this.model.m1.getLocX(), this.model.m1.getLocY(), this.model.m2.getLocX(), this.model.m2.getLocY()));
                break;
            }
            case 8: {
                graphics.setColor(Color.BLACK);
                graphics2D.drawString(this.document.sensed_links.elementAt(this.layer.index) + ": " + this.model.getValue(this.layer.index), n3, n4);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
    }

    private void DetermineAction(int n, int n2) {
        this.action = 0;
    }

    private void DoAction(int n, int n2) {
    }

    private void synchToModel() {
        this.setBounds(this.model.getTop(), this.model.getLeft(), this.model.getWidth(), this.model.getHeight());
    }

    private void selected() {
    }
}

