/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.util;

public class Crc {
    public static int calcByte(int n, int n2) {
        n ^= n2 << 8;
        for (int i = 0; i < 8; ++i) {
            if ((n & 0x8000) == 32768) {
                n = n << 1 ^ 0x1021;
                continue;
            }
            n <<= 1;
        }
        return n & 0xFFFF;
    }

    public static int calc(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            n3 = Crc.calcByte(n3, byArray[n++]);
            --n2;
        }
        return n3;
    }

    public static int calc(byte[] byArray, int n) {
        return Crc.calc(byArray, 0, n);
    }

    public static void set(byte[] byArray) {
        int n = Crc.calc(byArray, byArray.length - 2);
        byArray[byArray.length - 2] = (byte)(n & 0xFF);
        byArray[byArray.length - 1] = (byte)(n >> 8 & 0xFF);
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                byArray[i] = Integer.decode(stringArray[i]).byteValue();
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.out.println(Integer.toHexString(Crc.calc(byArray, byArray.length)));
    }
}

