// SPDX-FileCopyrightText: 2011 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef WAYLANDCLIPBOARD_H
#define WAYLANDCLIPBOARD_H

#include <string>
#include <map>
#include <sched.h>

using namespace std;
class ClipData;
class SystemClipboard;
class XwlDataBridge;

class WaylandClipboard
{
public:
    explicit WaylandClipboard(SystemClipboard *clipboard, char *path);
    virtual ~WaylandClipboard();

    void setDataToClipboard(ClipData *vClip, bool flag);
    void forkProcessData(ClipData *vClip, bool flag);
    void initConnect();

    void clearClipboard();

    char *getPathDir();
    void *getXwl();
private:
    void initXwl();
private:
    SystemClipboard *m_systemclipboard;
    XwlDataBridge    *m_XwlDataBrige;
    char            *m_pathDir;
    pid_t            m_pid;
    pthread_t        m_xwldispatch;
};

#endif // COPYCLIENT_H
