/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DISPLAYCONTROLLER_H
#define DISPLAYCONTROLLER_H

#include <X11/Xlib.h>
/**
 * 扩展信息链表, 用来存储与不同display关联的插件信息
 */
typedef struct WIExtDisplayInfo {
    struct WIExtDisplayInfo *next; // 链表指针
    Display *display;
    XExtCodes *codes;   // 插件信息
} WIExtDisplayInfo;

/**
 * 用来存储所有display的插件信息的列表
 */
typedef struct WIExtInfo {
    WIExtDisplayInfo *head; // 链表的头部指针
    WIExtDisplayInfo *cur;  // 最近一次使用的信息,用来加速查找。
    int ndisplays;  // 链表大小
} WIExtInfo;


WIExtDisplayInfo *wi_find_display(Display *dpy);

#define WIHasExtension(i) ((i) && ((i)->codes))

#define WICheckExtension(i, val) \
    if (!WIHasExtension(i)) { return val; }

#endif //DISPLAYCONTROLLER_H