/* ----- decode/761x3, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_761x3_checksums[] = {
  "4c0c26f31b56408c408d7cc98224222b70725c2aaa0ea3faa44579acf5c624de",
  "31ec97bfbababd015c022fc21d5f56f772f99978811edb78222560b43668194f",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_761x3_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_761x3_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_761x3_ITEMBYTES

static void *storage_decode_761x3_x;
static unsigned char *test_decode_761x3_x;
static void *storage_decode_761x3_s;
static unsigned char *test_decode_761x3_s;
static void *storage_decode_761x3_x2;
static unsigned char *test_decode_761x3_x2;
static void *storage_decode_761x3_s2;
static unsigned char *test_decode_761x3_s2;

#define precomputed_decode_761x3_NUM 4

static const unsigned char precomputed_decode_761x3_x[precomputed_decode_761x3_NUM][crypto_decode_ITEMS] = {
  {-1,1,1,2,1,2,1,1,2,0,1,0,-1,-1,2,1,0,1,1,0,-1,-1,2,0,1,2,2,0,2,-1,0,1,0,2,1,2,0,2,2,-1,2,1,-1,-1,2,-1,0,1,0,2,1,-1,-1,1,2,2,1,2,-1,1,2,2,0,-1,-1,0,0,1,2,1,0,0,2,1,-1,1,0,2,-1,-1,1,2,0,2,1,1,1,-1,0,0,2,0,0,-1,-1,0,-1,2,1,2,2,1,2,2,1,-1,0,1,-1,2,2,0,-1,-1,2,-1,1,0,2,1,0,0,2,2,2,1,2,1,-1,0,2,2,0,1,1,-1,-1,2,-1,1,0,0,2,0,1,0,0,1,1,0,2,0,-1,0,2,2,1,-1,-1,2,-1,2,0,0,0,-1,1,0,0,-1,0,2,0,0,0,2,2,-1,0,0,-1,1,-1,-1,-1,0,-1,0,1,0,2,1,-1,1,2,-1,-1,-1,-1,0,1,2,0,1,-1,0,1,2,1,-1,-1,0,0,1,0,1,-1,-1,0,2,2,1,0,1,2,0,2,2,2,0,0,1,0,-1,2,2,0,0,2,-1,0,0,-1,0,-1,0,-1,0,2,-1,0,-1,-1,2,1,1,-1,-1,0,2,1,1,1,-1,0,0,2,1,-1,2,0,-1,0,0,1,1,-1,1,-1,2,2,0,-1,1,0,1,2,0,2,2,-1,2,2,0,-1,2,2,-1,1,2,2,-1,2,2,2,0,-1,-1,0,-1,0,1,2,0,2,0,1,0,2,1,0,2,2,-1,-1,1,0,0,0,-1,0,-1,2,2,2,0,-1,1,1,0,0,1,2,-1,2,2,1,-1,0,1,0,-1,1,-1,2,-1,-1,-1,1,2,2,0,2,1,1,2,1,2,0,1,-1,0,0,0,0,1,0,0,-1,0,-1,0,-1,0,1,2,0,1,-1,1,2,-1,-1,1,1,-1,1,2,1,0,-1,2,-1,-1,0,-1,-1,-1,1,2,1,-1,2,0,-1,2,1,2,-1,2,2,-1,2,2,0,1,0,0,2,1,-1,2,-1,1,2,2,-1,-1,2,-1,-1,2,2,-1,1,-1,2,-1,0,-1,1,2,2,1,-1,2,1,-1,1,1,1,2,2,2,1,2,-1,1,2,-1,-1,1,0,0,0,0,0,0,-1,1,2,0,1,2,-1,0,1,2,1,1,1,0,1,-1,1,0,1,1,0,-1,1,1,0,-1,2,1,2,0,-1,0,0,1,2,1,1,0,0,-1,2,2,2,2,0,0,2,0,0,-1,0,2,-1,1,-1,1,0,2,-1,-1,1,-1,-1,-1,1,1,0,2,-1,1,2,-1,0,0,-1,1,2,-1,0,1,0,1,-1,0,-1,-1,1,2,1,2,-1,2,0,-1,-1,0,2,0,-1,0,2,0,2,2,-1,-1,2,2,2,2,-1,0,2,-1,-1,-1,0,2,2,2,1,-1,-1,0,2,1,1,1,1,0,1,2,-1,0,2,2,0,0,2,1,2,0,-1,0,0,1,1,2,-1,-1,1,0,-1,-1,-1,-1,-1,2,1,1,1,1,2,1,1,2,2,0,2,2,0,-1,2,0,2,2,-1,1,2,2,-1,0,0,-1,-1,0,2,1,1,2,-1,-1,0,1,-1,-1,-1,0,1,-1,2,2,0,0,-1,1,0,0,0,1,0,2,1,-1,0,-1,-1,2,2,0,0,1,1,1,0,1,-1,2,2,2,0,0,-1,0,1,0,2,2,2,0,0,2,2,-1,-1,2,1,-1,-1,2,-1,0,-1,-1,2,0,-1,2,2,-1,1,0,-1,2,-1,2,2,0,2,1,1,1,0,0,-1,1,0,1,2,2,-1,0,-1},
  {0,0,2,0,-1,2,-1,0,-1,-1,-1,-1,2,-1,1,-1,0,-1,0,1,0,-1,0,2,-1,0,2,0,0,2,1,-1,1,1,0,2,1,2,1,0,0,1,-1,1,2,2,2,2,1,0,2,2,2,-1,-1,0,-1,0,-1,0,0,0,-1,1,0,-1,2,-1,2,-1,2,-1,2,0,0,-1,1,-1,1,2,2,2,1,2,0,1,-1,1,-1,0,1,1,-1,0,0,1,2,-1,0,2,1,0,1,0,-1,-1,0,1,1,2,2,1,2,1,0,0,1,0,1,0,1,0,2,1,-1,0,-1,-1,2,2,2,1,2,2,2,-1,1,-1,2,0,2,-1,1,2,1,0,0,-1,2,-1,-1,0,1,0,-1,0,2,0,0,0,1,0,-1,0,2,-1,1,0,2,1,-1,2,0,0,-1,1,-1,0,-1,2,-1,0,1,-1,1,-1,1,0,-1,2,1,2,-1,2,-1,0,1,1,2,1,1,-1,1,-1,1,1,2,-1,2,2,0,1,1,0,-1,-1,2,2,-1,0,0,1,0,-1,0,2,0,0,0,-1,1,1,2,-1,-1,2,1,0,-1,1,0,0,1,2,2,2,1,2,-1,0,0,-1,0,2,0,1,2,0,0,0,0,1,-1,0,-1,2,1,-1,0,0,-1,-1,0,0,2,-1,-1,1,2,-1,2,2,0,0,2,0,2,1,-1,-1,0,-1,1,2,2,1,0,1,2,1,2,0,-1,-1,1,-1,1,-1,1,0,1,-1,0,1,-1,2,-1,1,1,1,1,1,-1,-1,0,2,2,-1,1,0,0,2,0,-1,0,0,1,1,0,1,-1,-1,-1,1,1,0,0,1,0,2,2,1,0,-1,0,1,-1,1,2,-1,-1,-1,0,1,1,2,2,0,-1,-1,2,-1,-1,0,0,2,1,2,2,0,-1,1,2,-1,-1,-1,-1,-1,2,-1,2,0,-1,1,0,1,2,0,1,2,-1,0,1,2,1,2,1,-1,2,-1,1,1,2,0,-1,-1,-1,1,2,0,1,2,2,0,0,1,-1,0,-1,-1,-1,1,-1,1,1,1,2,2,0,2,0,1,0,-1,1,-1,0,2,-1,1,1,1,2,-1,1,0,2,-1,1,2,2,1,1,0,2,2,1,1,2,2,0,0,1,2,1,-1,2,0,-1,0,0,-1,1,0,1,1,0,0,1,1,2,2,-1,0,2,-1,2,-1,1,0,-1,2,-1,1,0,2,0,2,-1,0,-1,-1,2,-1,0,2,1,0,1,0,-1,1,1,-1,0,0,1,1,2,0,2,-1,1,1,1,2,1,1,0,1,0,-1,0,1,0,0,-1,-1,1,1,1,1,0,2,2,1,-1,-1,0,-1,2,1,-1,0,-1,0,2,-1,2,2,-1,1,-1,2,2,2,2,0,-1,2,0,-1,2,0,1,-1,-1,2,1,2,2,0,2,0,2,1,0,-1,0,0,2,-1,2,2,-1,1,1,2,0,0,2,2,1,2,2,1,0,1,2,2,-1,-1,0,0,2,2,2,0,0,-1,-1,0,0,2,2,0,-1,2,1,2,0,0,2,0,0,2,0,-1,0,2,2,-1,-1,1,1,-1,0,1,0,2,1,1,2,-1,0,-1,-1,0,-1,0,2,1,1,1,-1,-1,0,-1,2,2,2,1,1,1,1,1,1,2,1,0,2,-1,0,0,0,1,2,-1,2,1,2,2,-1,2,-1,2,2,1,-1,1,0,0,2,1,-1,0,0,1,0,1,2,1,0,1,2,-1,0,-1,2,1,-1,1,1,0,0,-1,-1,0,-1,1,1,1,2,0,0,-1,1,1,1,-1,1,-1,1,0,2,2,1,2,2,-1,1},
  {-1,-1,0,0,0,0,0,-1,1,0,-1,2,-1,0,0,-1,1,0,1,-1,-1,1,-1,2,2,1,1,-1,1,-1,1,2,1,1,2,0,2,1,1,0,1,-1,-1,2,0,-1,1,-1,1,1,1,-1,1,1,-1,0,1,1,0,-1,-1,0,-1,2,2,2,-1,-1,2,0,1,2,0,-1,1,-1,2,1,2,-1,1,0,2,2,2,-1,2,0,1,0,0,0,-1,0,2,1,2,-1,0,1,0,0,1,0,2,1,1,-1,0,-1,1,0,-1,2,0,2,0,-1,0,1,-1,0,1,2,2,-1,-1,-1,1,0,-1,0,0,0,-1,2,-1,-1,1,-1,1,0,2,1,1,0,2,0,1,-1,-1,0,2,2,2,-1,-1,-1,-1,-1,2,0,0,2,2,1,-1,-1,2,-1,0,0,1,2,1,0,2,1,-1,2,0,1,0,1,0,1,1,2,-1,1,0,1,0,0,0,-1,0,-1,0,-1,-1,-1,1,-1,0,-1,1,-1,-1,2,0,1,0,2,2,2,2,-1,2,-1,2,1,-1,-1,1,1,2,-1,-1,0,2,1,0,2,0,2,1,1,1,-1,1,0,0,1,-1,2,1,2,1,2,-1,0,-1,-1,2,-1,-1,0,2,0,2,-1,-1,0,-1,-1,2,-1,2,0,0,-1,1,-1,0,-1,2,-1,2,-1,2,1,2,0,-1,-1,2,-1,2,2,2,2,1,1,0,1,2,2,2,2,-1,0,0,0,0,2,2,2,-1,-1,2,1,2,2,-1,-1,0,1,-1,2,-1,2,2,1,-1,2,0,1,0,-1,2,-1,0,2,2,-1,-1,0,0,2,0,0,0,2,0,-1,-1,0,-1,-1,-1,0,-1,1,-1,-1,-1,-1,-1,2,2,1,2,1,0,1,0,2,2,-1,2,1,0,1,1,-1,0,-1,1,0,2,-1,1,0,-1,-1,2,1,0,1,2,1,1,0,0,1,0,0,0,2,1,-1,0,-1,-1,2,1,2,-1,0,1,1,1,2,1,2,-1,-1,0,2,0,1,2,2,1,-1,1,1,1,0,2,0,2,-1,1,1,0,2,0,1,-1,1,2,1,2,0,0,1,0,-1,-1,-1,0,0,0,1,1,0,2,-1,1,2,-1,-1,0,1,2,2,1,0,-1,-1,0,1,0,2,2,0,2,2,-1,0,0,1,-1,-1,1,1,2,1,2,-1,0,1,0,1,1,-1,-1,-1,1,2,-1,2,2,2,2,2,2,-1,2,1,-1,1,2,-1,2,0,0,-1,2,1,1,2,-1,1,-1,1,1,0,0,1,0,2,2,0,-1,2,1,-1,0,2,-1,0,-1,1,2,1,-1,-1,2,1,1,-1,2,1,0,0,-1,1,-1,0,0,2,0,0,2,1,2,0,0,0,-1,0,-1,2,2,-1,1,2,1,0,0,0,1,1,0,2,-1,-1,0,2,-1,-1,1,0,1,-1,1,1,2,-1,-1,1,2,-1,0,2,-1,-1,2,2,-1,-1,2,2,0,-1,1,2,-1,-1,0,2,2,0,1,2,-1,2,0,1,1,1,2,2,2,-1,-1,-1,1,0,-1,-1,0,0,-1,-1,1,-1,2,2,1,-1,0,1,1,2,2,-1,2,2,0,2,-1,-1,-1,2,2,-1,0,1,2,1,1,1,2,2,-1,2,-1,1,2,1,0,1,0,2,0,-1,0,0,2,0,0,0,2,2,2,-1,1,0,0,2,2,1,1,2,-1,2,2,-1,1,2,2,0,1,2,-1,-1,1,2,0,1,0,-1,0,0,-1,0,1,2,1,-1,2,0,0,0,0,0,-1,0,-1,2,0,0,0,-1,-1,-1,2,0,-1,-1,2,-1,1,2,0,-1,-1},
  {2,0,0,1,1,1,1,0,2,1,1,-1,2,0,2,0,-1,1,0,1,1,1,2,1,1,0,2,-1,-1,1,1,2,0,1,2,1,1,2,2,0,2,0,2,1,-1,1,0,0,1,-1,-1,2,2,1,-1,1,2,2,2,0,2,0,2,0,2,0,0,-1,1,-1,0,2,1,0,2,1,-1,-1,1,2,0,1,0,0,2,-1,-1,1,1,2,-1,0,0,0,0,0,2,0,0,1,-1,-1,1,1,-1,1,1,2,2,0,2,1,-1,-1,-1,0,0,-1,-1,-1,1,-1,1,1,0,2,1,-1,0,0,-1,-1,1,2,1,2,0,2,2,0,2,-1,-1,1,1,0,0,1,2,0,0,-1,-1,1,0,0,2,1,2,2,0,-1,1,0,0,2,1,-1,2,2,-1,1,1,1,-1,1,-1,1,2,0,-1,0,0,2,0,2,-1,0,0,0,-1,2,1,0,-1,0,1,1,-1,0,1,0,0,2,0,-1,-1,-1,0,0,2,-1,1,2,0,2,0,1,2,1,2,1,-1,-1,-1,1,1,0,1,1,-1,1,2,2,-1,1,-1,-1,1,0,0,1,0,0,0,2,1,1,-1,0,0,-1,-1,1,0,-1,0,1,1,2,-1,-1,2,-1,2,2,0,1,2,-1,-1,0,-1,-1,2,2,-1,2,2,0,2,1,1,2,1,1,-1,2,-1,2,1,-1,0,0,1,1,0,2,0,-1,0,1,-1,-1,1,2,1,1,1,1,0,0,1,2,-1,0,1,2,1,0,1,1,1,0,1,-1,0,0,0,0,1,1,1,2,-1,-1,-1,2,1,-1,-1,2,2,-1,1,-1,0,0,0,2,2,2,-1,-1,2,-1,1,2,1,0,2,-1,-1,1,1,1,2,-1,1,2,2,0,0,1,2,1,2,1,1,0,-1,1,0,-1,1,1,1,1,0,-1,-1,2,1,2,-1,2,-1,0,2,0,1,1,0,2,-1,2,1,0,-1,-1,0,-1,-1,-1,-1,-1,1,-1,0,2,1,-1,0,0,0,2,0,1,0,2,0,-1,-1,-1,1,2,1,-1,2,1,-1,2,2,0,2,0,1,1,-1,2,0,0,1,0,1,0,1,2,0,0,2,2,1,0,0,1,0,-1,2,0,1,-1,-1,1,0,-1,2,2,0,2,2,-1,0,2,2,0,-1,1,0,-1,2,0,2,0,-1,-1,-1,-1,-1,0,0,2,1,-1,-1,2,0,0,2,2,0,0,2,-1,0,1,-1,0,0,-1,0,2,0,1,2,1,2,-1,0,0,2,2,-1,-1,2,0,2,1,-1,-1,-1,0,1,0,2,2,1,0,1,1,-1,-1,1,1,-1,0,1,2,0,0,2,-1,2,2,2,1,1,1,1,2,-1,2,1,1,0,-1,1,2,-1,1,0,-1,0,-1,2,2,-1,0,-1,1,-1,1,-1,-1,-1,2,-1,2,1,2,-1,1,0,2,-1,1,0,2,0,1,1,-1,2,2,0,-1,0,2,-1,2,1,0,1,0,2,1,0,-1,-1,-1,1,1,2,1,2,0,2,-1,1,1,1,-1,1,-1,0,0,-1,-1,1,0,1,0,0,1,-1,-1,1,0,0,-1,0,0,0,0,1,1,0,2,-1,-1,-1,2,0,-1,-1,2,-1,2,-1,1,2,-1,-1,2,1,-1,0,1,1,-1,0,1,2,0,0,2,1,2,-1,1,-1,2,0,2,2,-1,0,0,0,0,2,1,-1,0,-1,2,2,-1,-1,2,1,1,2,-1,2,-1,1,-1,1,2,-1,-1,-1,2,0,1,2,0,1,-1,2,0,2,1,1,-1,0,2,-1,-1,0,2,-1,2,0,2,2,2,0,-1,1},
} ;

static const unsigned char precomputed_decode_761x3_s[precomputed_decode_761x3_NUM][crypto_decode_STRBYTES] = {
  {232,174,103,176,105,112,126,147,237,61,11,147,45,248,142,31,148,91,139,13,222,42,117,65,236,251,146,124,48,182,245,187,244,41,140,117,150,118,244,194,92,97,209,213,83,8,68,182,56,64,158,228,66,153,208,155,247,151,241,53,69,68,19,172,208,42,181,28,165,200,135,121,207,199,227,243,7,145,119,182,61,88,17,127,104,57,47,25,50,224,183,238,73,149,69,68,158,56,40,110,12,1,46,199,206,243,89,203,248,48,60,50,225,203,162,254,142,131,85,133,231,228,106,98,26,26,123,148,107,241,95,23,141,216,32,160,141,83,56,153,4,238,28,116,116,15,255,52,208,47,180,106,78,95,123,148,14,6,192,170,235,247,113,143,79,65,235,144,64,242,133,149,45,193,151,154,252,69,246,215,195,194,4,199,99,204,183,90,152,79,20},
  {117,76,0,35,145,209,116,45,218,110,137,255,246,67,68,133,49,51,23,226,239,137,164,148,211,102,144,190,91,102,182,4,191,63,114,227,22,67,70,87,70,99,203,133,196,36,98,236,76,186,34,58,159,6,79,25,93,161,195,134,229,239,20,157,87,73,44,5,53,56,95,183,16,190,185,7,34,38,201,168,10,61,214,81,154,128,150,189,145,56,144,126,48,212,126,56,0,115,152,231,228,46,163,7,120,126,73,128,168,223,25,210,168,99,227,107,175,95,46,71,97,90,250,52,99,140,221,4,211,102,40,165,55,234,154,145,5,170,189,16,75,52,143,252,199,113,194,126,183,81,243,232,245,190,249,80,127,65,125,236,117,29,61,40,217,58,65,180,10,241,171,234,54,149,179,207,188,88,75,153,155,19,139,22,132,122,161,34,246,62,138},
  {80,21,198,20,38,200,43,226,122,107,194,33,42,74,26,196,15,231,33,59,246,115,86,180,147,101,43,97,220,145,228,3,70,197,32,182,118,66,63,0,215,11,83,110,203,153,233,152,21,17,32,33,156,253,51,11,58,180,221,42,150,236,78,48,116,67,48,23,18,51,123,48,255,154,255,84,253,176,15,201,188,156,49,61,212,213,65,64,8,192,187,217,179,41,97,99,176,185,150,213,18,236,164,238,208,249,162,118,163,157,184,151,1,149,54,14,249,6,217,247,148,160,59,153,2,206,255,179,56,23,235,136,150,125,44,77,184,176,178,133,212,181,87,196,227,86,218,208,96,162,131,211,240,240,225,208,231,156,250,3,6,5,242,146,62,223,192,147,171,207,184,217,81,87,63,214,235,60,126,14,158,81,228,114,85,196,21,112,48,30,156},
  {151,106,43,119,152,186,54,232,185,126,183,88,194,139,127,119,23,210,182,224,89,131,78,85,151,160,232,183,64,1,162,45,5,238,125,131,150,23,88,251,97,45,143,138,120,212,77,197,70,74,214,1,53,222,185,11,104,138,143,96,89,173,20,24,233,48,159,67,240,124,235,202,44,165,29,9,174,90,78,110,106,82,165,14,44,60,82,253,48,110,131,58,126,185,107,24,170,193,206,116,218,108,16,0,210,82,157,29,224,178,124,167,92,102,94,111,25,39,24,223,211,135,113,7,64,45,92,95,147,20,157,59,245,112,11,100,111,10,74,94,243,171,206,26,142,17,79,136,192,236,216,216,41,31,205,102,27,160,123,163,34,5,102,9,22,85,218,192,193,140,195,146,146,215,142,220,83,181,196,195,58,35,14,156,39,183,210,208,220,31,114},
} ;

static void test_decode_761x3_impl(long long impl)
{
  unsigned char *x = test_decode_761x3_x;
  unsigned char *s = test_decode_761x3_s;
  unsigned char *x2 = test_decode_761x3_x2;
  unsigned char *s2 = test_decode_761x3_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_761x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_761x3(impl);
    printf("decode_761x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_761x3_implementation(impl),ntruprime_dispatch_decode_761x3_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_761x3;
    printf("decode_761x3 selected implementation %s compiler %s\n",ntruprime_decode_761x3_implementation(),ntruprime_decode_761x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_761x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_761x3_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_761x3_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_761x3_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_761x3_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_761x3_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_761x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"761x3")) return;
  storage_decode_761x3_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_761x3_x = aligned(storage_decode_761x3_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_761x3_s = callocplus(crypto_decode_STRBYTES);
  test_decode_761x3_s = aligned(storage_decode_761x3_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_761x3_x2 = callocplus(maxalloc);
  test_decode_761x3_x2 = aligned(storage_decode_761x3_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_761x3_s2 = callocplus(maxalloc);
  test_decode_761x3_s2 = aligned(storage_decode_761x3_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_761x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_761x3();++impl)
      forked(test_decode_761x3_impl,impl);
    ++test_decode_761x3_x;
    ++test_decode_761x3_s;
    ++test_decode_761x3_x2;
    ++test_decode_761x3_s2;
  }
  free(storage_decode_761x3_s2);
  free(storage_decode_761x3_x2);
  free(storage_decode_761x3_s);
  free(storage_decode_761x3_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

