/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.DockKey;
import com.vldocking.swing.docking.DockView;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableActionCustomizer;
import com.vldocking.swing.docking.DockableDragSource;
import com.vldocking.swing.docking.DockableState;
import com.vldocking.swing.docking.DockingDesktop;
import com.vldocking.swing.docking.DockingUtilities;
import com.vldocking.swing.docking.SingleDockableContainer;
import com.vldocking.swing.tabbedpane.JTabbedPaneSmartIcon;
import com.vldocking.swing.tabbedpane.JTabbedPaneSmartIconManager;
import com.vldocking.swing.tabbedpane.SmartIconJButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class DockViewAsTab
extends DockView
implements SingleDockableContainer {
    private static final long serialVersionUID = 1L;
    private static final String CLOSE_TEXT = UIManager.getString("DockViewTitleBar.closeButtonText");
    private static final String ICONIFY_TEXT = UIManager.getString("DockViewTitleBar.minimizeButtonText");
    private static final String RESTORE_TEXT = UIManager.getString("DockViewTitleBar.restoreButtonText");
    private static final String MAXIMIZE_TEXT = UIManager.getString("DockViewTitleBar.maximizeButtonText");
    private static final String FLOAT_TEXT = UIManager.getString("DockViewTitleBar.floatButtonText");
    private static final String ATTACH_TEXT = UIManager.getString("DockViewTitleBar.attachButtonText");
    private static Icon closeIcon = UIManager.getIcon("DockViewTitleBar.menu.close");
    private static Icon maximizeIcon = UIManager.getIcon("DockViewTitleBar.menu.maximize");
    private static Icon restoreIcon = UIManager.getIcon("DockViewTitleBar.menu.restore");
    private static Icon hideIcon = UIManager.getIcon("DockViewTitleBar.menu.hide");
    private static Icon dockIcon = UIManager.getIcon("DockViewTitleBar.menu.dock");
    private static Icon floatIcon = UIManager.getIcon("DockViewTitleBar.menu.float");
    private static Icon attachIcon = UIManager.getIcon("DockViewTitleBar.menu.attach");
    protected TabHeader tabHeader = this.createTabHeader();
    protected JTabbedPaneSmartIconManager tpManager = new JTabbedPaneSmartIconManager(this.tabHeader);
    protected JTabbedPaneSmartIcon smartIcon = new JTabbedPaneSmartIcon(null, " ", null);
    protected AbstractAction closeAction = new AbstractAction("Close"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DockViewAsTab.this.desktop.close(DockViewAsTab.this.getDockable());
        }
    };
    protected SmartIconJButton closeSmartIcon = new SmartIconJButton(this.closeAction);
    protected AbstractAction maximizeAction = new AbstractAction("Maximize"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DockViewAsTab.this.maximizeAction();
        }
    };
    protected SmartIconJButton maximizeSmartIcon = new SmartIconJButton(this.maximizeAction);
    protected AbstractAction hideAction = new AbstractAction("Hide"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DockViewAsTab.this.desktop.setAutoHide(DockViewAsTab.this.getDockable(), true);
        }
    };
    protected SmartIconJButton hideSmartIcon = new SmartIconJButton(this.hideAction);
    protected AbstractAction floatAction = new AbstractAction("Float"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DockViewAsTab.this.desktop.setFloating(DockViewAsTab.this.getDockable(), true);
        }
    };
    protected SmartIconJButton floatSmartIcon = new SmartIconJButton(this.floatAction);
    protected boolean isCloseButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isCloseButtonDisplayed");
    protected boolean isHideButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isHideButtonDisplayed");
    protected boolean isDockButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isDockButtonDisplayed");
    protected boolean isMaximizeButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isMaximizeButtonDisplayed");
    protected boolean isRestoreButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isRestoreButtonDisplayed");
    protected boolean isFloatButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isFloatButtonDisplayed");
    protected boolean isAttachButtonDisplayed = UIManager.getBoolean("DockViewTitleBar.isAttachButtonDisplayed");
    private PropertyChangeListener keyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String pName = e.getPropertyName();
            if (pName.equals("icon")) {
                DockViewAsTab.this.smartIcon.setIcon((Icon)e.getNewValue());
            } else if (pName.equals("name")) {
                DockViewAsTab.this.smartIcon.setLabel((String)e.getNewValue());
                DockViewAsTab.this.revalidate();
            } else if (pName.equals("tooltip")) {
                DockViewAsTab.this.smartIcon.setTooltipText((String)e.getNewValue());
            } else if (pName.equals("autohide")) {
                DockViewAsTab.this.resetTabIcons();
            } else if (pName.equals("close")) {
                DockViewAsTab.this.resetTabIcons();
            } else if (pName.equals("floatable")) {
                DockViewAsTab.this.resetTabIcons();
            } else if (pName.equals("maximizable")) {
                DockViewAsTab.this.resetTabIcons();
            }
        }
    };
    private JPopupMenu currentPopUp = null;
    private MouseListener titleMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                DockViewAsTab.this.maximizeAction();
            } else {
                DockViewAsTab.this.getDockable().getComponent().requestFocus();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DockViewAsTab.this.checkForPopUp(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DockViewAsTab.this.checkForPopUp(e);
            }
        }
    };
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("dock")) {
                DockViewAsTab.this.dockAction();
            } else if (e.getActionCommand().equals("close")) {
                DockViewAsTab.this.closeAction();
            } else if (e.getActionCommand().equals("maximize")) {
                DockViewAsTab.this.maximizeAction();
            } else if (e.getActionCommand().equals("float")) {
                DockViewAsTab.this.floatAction();
            }
        }
    };

    public DockViewAsTab(Dockable dockable) {
        super(dockable, false);
        this.add((Component)this.tabHeader, "Center");
        this.tabHeader.addMouseListener(this.titleMouseListener);
        this.configureCloseButton();
        this.configureHideButton();
        this.configureMaximizeButton();
        this.configureFloatButton();
        this.setDockableAsTab(dockable);
    }

    private void checkForPopUp(MouseEvent e) {
        Dockable target = this.getDockable();
        JPopupMenu popup = new JPopupMenu(target.getDockKey().getName());
        DockKey key = target.getDockKey();
        switch (key.getLocation()) {
            case DOCKED: {
                this.initDockedPopUp(popup);
                break;
            }
            case HIDDEN: {
                break;
            }
            case MAXIMIZED: {
                this.initMaximizedPopUp(popup);
                break;
            }
            case FLOATING: {
                this.initFloatingPopUp(popup);
                break;
            }
        }
        DockableActionCustomizer customizer = target.getDockKey().getActionCustomizer();
        if (customizer != null && customizer.isSingleDockableTitleBarPopUpCustomizer()) {
            if (popup.getComponentCount() > 0) {
                popup.addSeparator();
            }
            customizer.visitSingleDockableTitleBarPopUp(popup, target);
        }
        if (popup.getComponentCount() > 0) {
            popup.show(this.tabHeader, e.getX(), e.getY());
            this.currentPopUp = popup;
        }
    }

    private JMenuItem createPopUpItem(String text, Icon icon, String tooltip, String actionCommand, KeyStroke accelerator) {
        JMenuItem menuItem = new JMenuItem(text, icon);
        menuItem.setActionCommand(actionCommand);
        menuItem.addActionListener(this.actionListener);
        if (accelerator != null) {
            menuItem.setAccelerator(accelerator);
        }
        return menuItem;
    }

    protected void initMaximizedPopUp(JPopupMenu popup) {
        popup.add(this.createPopUpItem(RESTORE_TEXT, restoreIcon, RESTORE_TEXT, "maximize", (KeyStroke)UIManager.get("DockingDesktop.maximizeActionAccelerator")));
    }

    protected void initAutoHidePopUp(JPopupMenu popup) {
        if (!DockingUtilities.isChildOfCompoundDockable(this.getDockable())) {
            popup.add(this.createPopUpItem(RESTORE_TEXT, dockIcon, RESTORE_TEXT, "dock", (KeyStroke)UIManager.get("DockingDesktop.dockActionAccelerator")));
        }
        if (this.getDockable().getDockKey().isCloseEnabled()) {
            popup.add(this.createPopUpItem(CLOSE_TEXT, this.closeSmartIcon, CLOSE_TEXT, "close", (KeyStroke)UIManager.get("DockingDesktop.closeActionAccelerator")));
        }
    }

    protected void initDockedPopUp(JPopupMenu popup) {
        DockKey key = this.getDockable().getDockKey();
        if (key.isAutoHideEnabled()) {
            popup.add(this.createPopUpItem(ICONIFY_TEXT, this.hideSmartIcon, ICONIFY_TEXT, "dock", (KeyStroke)UIManager.get("DockingDesktop.dockActionAccelerator")));
        }
        if (key.isFloatEnabled()) {
            popup.add(this.createPopUpItem(FLOAT_TEXT, this.floatSmartIcon, FLOAT_TEXT, "float", (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator")));
        }
        if (key.isMaximizeEnabled()) {
            popup.add(this.createPopUpItem(MAXIMIZE_TEXT, this.maximizeSmartIcon, MAXIMIZE_TEXT, "maximize", (KeyStroke)UIManager.get("DockingDesktop.maximizeActionAccelerator")));
        }
        if (key.isCloseEnabled()) {
            popup.add(this.createPopUpItem(CLOSE_TEXT, this.closeSmartIcon, CLOSE_TEXT, "close", (KeyStroke)UIManager.get("DockingDesktop.closeActionAccelerator")));
        }
    }

    protected void initFloatingPopUp(JPopupMenu popup) {
        if (!DockingUtilities.isChildOfCompoundDockable(this.getDockable())) {
            popup.add(this.createPopUpItem(ATTACH_TEXT, attachIcon, ATTACH_TEXT, "float", (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator")));
        }
    }

    public void closePopUp() {
        if (this.currentPopUp != null) {
            this.currentPopUp.setVisible(false);
            this.currentPopUp = null;
        }
    }

    private void dockAction() {
        if (this.isAutoHide()) {
            this.desktop.setAutoHide(this.getDockable(), false);
        } else {
            this.desktop.setAutoHide(this.getDockable(), true);
        }
    }

    protected void maximizeAction() {
        if (this.isMaximized()) {
            this.desktop.restore(this.getDockable());
        } else {
            this.desktop.maximize(this.getDockable());
        }
    }

    private void closeAction() {
        this.desktop.close(this.getDockable());
    }

    private void floatAction() {
        if (this.getDockable().getDockKey().getLocation() == DockableState.Location.FLOATING) {
            this.desktop.setFloating(this.getDockable(), true);
        } else {
            this.desktop.setFloating(this.getDockable(), false);
        }
    }

    private boolean isAutoHide() {
        return this.getDockable().getDockKey().getLocation() == DockableState.Location.HIDDEN;
    }

    private boolean isMaximized() {
        return this.getDockable().getDockKey().getLocation() == DockableState.Location.MAXIMIZED;
    }

    protected void configureFloatButton() {
        if (this.isFloatButtonDisplayed) {
            this.floatSmartIcon.setIcon(UIManager.getIcon("DockViewTitleBar.float"));
            this.floatSmartIcon.setPressedIcon(UIManager.getIcon("DockViewTitleBar.float.pressed"));
            this.floatSmartIcon.setRolloverIcon(UIManager.getIcon("DockViewTitleBar.float.rollover"));
            this.floatAction.putValue("ShortDescription", UIManager.get("DockViewTitleBar.floatButtonText"));
        }
    }

    protected void configureMaximizeButton() {
        if (this.isMaximizeButtonDisplayed) {
            this.maximizeSmartIcon.setIcon(UIManager.getIcon("DockViewTitleBar.maximize"));
            this.maximizeSmartIcon.setPressedIcon(UIManager.getIcon("DockViewTitleBar.maximize.pressed"));
            this.maximizeSmartIcon.setRolloverIcon(UIManager.getIcon("DockViewTitleBar.maximize.rollover"));
            this.maximizeAction.putValue("ShortDescription", UIManager.get("DockViewTitleBar.maximizeButtonText"));
        }
    }

    protected void configureHideButton() {
        if (this.isHideButtonDisplayed) {
            this.hideSmartIcon.setIcon(UIManager.getIcon("DockViewTitleBar.hide"));
            this.hideSmartIcon.setPressedIcon(UIManager.getIcon("DockViewTitleBar.hide.pressed"));
            this.hideSmartIcon.setRolloverIcon(UIManager.getIcon("DockViewTitleBar.hide.rollover"));
            this.hideAction.putValue("ShortDescription", UIManager.get("DockViewTitleBar.minimizeButtonText"));
        }
    }

    protected void configureCloseButton() {
        if (this.isCloseButtonDisplayed) {
            this.closeSmartIcon.setIcon(UIManager.getIcon("DockTabbedPane.close"));
            this.closeSmartIcon.setPressedIcon(UIManager.getIcon("DockTabbedPane.close.pressed"));
            this.closeSmartIcon.setRolloverIcon(UIManager.getIcon("DockTabbedPane.close.rollover"));
            this.closeAction.putValue("ShortDescription", UIManager.get("DockTabbedPane.closeButtonText"));
        }
    }

    @Override
    public void setDockable(Dockable d) {
    }

    public void setDockableAsTab(Dockable d) {
        this.dockable = d;
        if (this.title != null) {
            this.title.setDockable(this.dockable);
        }
        this.resetTabIcons();
        this.setMinimumSize(new Dimension(30, 30));
    }

    public void resetTabIcons() {
        ArrayList<SmartIconJButton> icons = new ArrayList<SmartIconJButton>();
        DockKey k = this.getDockable().getDockKey();
        if (k.isCloseEnabled() && this.isCloseButtonDisplayed) {
            icons.add(this.closeSmartIcon);
        }
        if (k.isMaximizeEnabled() && this.isMaximizeButtonDisplayed) {
            icons.add(this.maximizeSmartIcon);
        }
        if (k.isAutoHideEnabled() && this.isHideButtonDisplayed) {
            icons.add(this.hideSmartIcon);
        }
        if (k.isFloatEnabled() && this.isFloatButtonDisplayed) {
            icons.add(this.floatSmartIcon);
        }
        if (icons.size() > 0) {
            SmartIconJButton[] iconsArray = icons.toArray(new SmartIconJButton[0]);
            this.smartIcon = new JTabbedPaneSmartIcon(k.getIcon(), k.getName(), iconsArray);
            this.smartIcon.setIconForTabbedPane(this.tabHeader);
            this.tabHeader.addTab("", this.smartIcon, this.getDockable().getComponent());
        } else {
            this.tabHeader.addTab(k.getName(), k.getIcon(), this.getDockable().getComponent());
        }
    }

    @Override
    public void installDocking(DockingDesktop desktop) {
        this.desktop = desktop;
        desktop.installDockableDragSource(this.tabHeader);
        this.dockable.getDockKey().addPropertyChangeListener(this.keyListener);
    }

    @Override
    public void uninstallDocking(DockingDesktop desktop) {
        desktop.uninstallDockableDragSource(this.tabHeader);
        this.dockable.getDockKey().removePropertyChangeListener(this.keyListener);
    }

    @Override
    public String getUIClassID() {
        return "PanelUI";
    }

    protected TabHeader createTabHeader() {
        return new TabHeader();
    }

    protected class TabHeader
    extends JTabbedPane
    implements DockableDragSource {
        private static final long serialVersionUID = 1L;

        protected TabHeader() {
        }

        @Override
        public boolean startDragComponent(Point p) {
            Rectangle bounds = this.getBoundsAt(0);
            return bounds.contains(p);
        }

        @Override
        public Container getDockableContainer() {
            return DockViewAsTab.this;
        }

        @Override
        public Dockable getDockable() {
            return DockViewAsTab.this.dockable;
        }

        @Override
        public void endDragComponent(boolean dropped) {
        }
    }
}

