/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking;

import com.vldocking.swing.docking.AutoHideButton;
import com.vldocking.swing.docking.AutoHideButtonPanel;
import com.vldocking.swing.docking.AutoHideExpandPanel;
import com.vldocking.swing.docking.AutoHidePolicy;
import com.vldocking.swing.docking.CompoundDockable;
import com.vldocking.swing.docking.CompoundDockingPanel;
import com.vldocking.swing.docking.DockKey;
import com.vldocking.swing.docking.Dockable;
import com.vldocking.swing.docking.DockableContainer;
import com.vldocking.swing.docking.DockableContainerFactory;
import com.vldocking.swing.docking.DockableDragSource;
import com.vldocking.swing.docking.DockableState;
import com.vldocking.swing.docking.DockingBorderLayout;
import com.vldocking.swing.docking.DockingConstants;
import com.vldocking.swing.docking.DockingContext;
import com.vldocking.swing.docking.DockingPanel;
import com.vldocking.swing.docking.DockingPreferences;
import com.vldocking.swing.docking.DockingUtilities;
import com.vldocking.swing.docking.DragControler;
import com.vldocking.swing.docking.DragControlerFactory;
import com.vldocking.swing.docking.FloatingDockableContainer;
import com.vldocking.swing.docking.MaximizedComponentReplacer;
import com.vldocking.swing.docking.RelativeDockablePosition;
import com.vldocking.swing.docking.RelativeDockingUtilities;
import com.vldocking.swing.docking.SingleDockableContainer;
import com.vldocking.swing.docking.SplitContainer;
import com.vldocking.swing.docking.SplitResizer;
import com.vldocking.swing.docking.TabbedDockableContainer;
import com.vldocking.swing.docking.event.DockableSelectionEvent;
import com.vldocking.swing.docking.event.DockableSelectionListener;
import com.vldocking.swing.docking.event.DockableStateChangeEvent;
import com.vldocking.swing.docking.event.DockableStateChangeListener;
import com.vldocking.swing.docking.event.DockableStateWillChangeEvent;
import com.vldocking.swing.docking.event.DockableStateWillChangeListener;
import com.vldocking.swing.docking.event.DockingActionAddDockableEvent;
import com.vldocking.swing.docking.event.DockingActionCloseEvent;
import com.vldocking.swing.docking.event.DockingActionCreateTabEvent;
import com.vldocking.swing.docking.event.DockingActionEvent;
import com.vldocking.swing.docking.event.DockingActionListener;
import com.vldocking.swing.docking.event.DockingActionSimpleStateChangeEvent;
import com.vldocking.swing.docking.event.DockingActionSplitComponentEvent;
import com.vldocking.swing.docking.event.DockingActionSplitDockableEvent;
import com.vldocking.swing.docking.ui.DockingUISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class DockingDesktop
extends JLayeredPane {
    private static final long serialVersionUID = 1L;
    private static final String CURRENT_VERSION_NUMBER = "2.1.5";
    private static final String BUILD_DATE = "2008/07/05";
    private DockingContext context;
    private JPanel contentPane = new JPanel(new DockingBorderLayout());
    protected DockingPanel dockingPanel = new DockingPanel();
    protected AutoHideExpandPanel expandPanel = this.createAutoHideExpandPanel();
    protected AutoHideButtonPanel topBorderPane = new AutoHideButtonPanel(this.expandPanel, 0);
    protected AutoHideButtonPanel leftBorderPane = new AutoHideButtonPanel(this.expandPanel, 1);
    protected AutoHideButtonPanel bottomBorderPane = new AutoHideButtonPanel(this.expandPanel, 2);
    protected AutoHideButtonPanel rightBorderPane = new AutoHideButtonPanel(this.expandPanel, 3);
    protected AutoHideButtonPanel[] borderPanes = new AutoHideButtonPanel[]{this.topBorderPane, this.leftBorderPane, this.bottomBorderPane, this.rightBorderPane};
    private HashMap<DockKey, AutoHideButton> autoHideButtons = new HashMap();
    private DragControler dragControler;
    private MaximizedComponentReplacer dummyMaximedReplacer = new MaximizedComponentReplacer();
    private Component maximizedComponent;
    private boolean currentMaximizedComponentIsHeavyWeight = false;
    private JComponent mouseMotionGrabber = new JComponent(){
        private static final long serialVersionUID = 1L;
    };
    private Timer mouseOutOfExpandedPanelTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DockingDesktop.this.expandPanel.isActive() && DockingDesktop.this.expandPanel.shouldCollapse()) {
                DockingDesktop.this.expandPanel.collapse();
            }
        }
    });
    protected HashMap<Dockable, LinkedList<Dockable>> tabbedGroups = new HashMap();
    private FocusHandler focusHandler = new FocusHandler();
    protected HashMap<Dockable, DockableState> previousFloatingDockableStates = new HashMap();
    private String desktopName;
    private Point lastWindowLocation = null;
    private ComponentAdapter windowMovementListener = new ComponentAdapter(){

        @Override
        public void componentMoved(ComponentEvent e) {
            DockingDesktop.this.moveFloatingWindows();
        }
    };
    WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent e) {
            DockingDesktop.this.context.windowActivated(e);
        }
    };
    private AbstractAction closeAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DockableState.Location location;
            Dockable d = DockingDesktop.this.focusHandler.getCurrentDockable();
            if (d != null && d.getDockKey().isCloseEnabled() && ((location = d.getDockKey().getLocation()) == DockableState.Location.DOCKED || location == DockableState.Location.FLOATING || location == DockableState.Location.HIDDEN)) {
                DockingDesktop.this.close(d);
            }
        }
    };
    private AbstractAction maximizeAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Dockable d = DockingDesktop.this.focusHandler.getCurrentDockable();
            if (d != null && d.getDockKey().isMaximizeEnabled()) {
                DockableState.Location location = d.getDockKey().getLocation();
                if (location == DockableState.Location.DOCKED) {
                    DockingDesktop.this.maximize(d);
                } else if (location == DockableState.Location.MAXIMIZED) {
                    DockingDesktop.this.restore(d);
                }
            }
        }
    };
    private AbstractAction dockAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Dockable d = DockingDesktop.this.focusHandler.getCurrentDockable();
            if (d != null && d.getDockKey().isAutoHideEnabled()) {
                DockableState.Location location = d.getDockKey().getLocation();
                if (location == DockableState.Location.DOCKED) {
                    DockingDesktop.this.setAutoHide(d, true);
                } else if (location == DockableState.Location.HIDDEN) {
                    DockingDesktop.this.setAutoHide(d, false);
                }
            }
        }
    };
    private AbstractAction floatAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Dockable d = DockingDesktop.this.focusHandler.getCurrentDockable();
            if (d != null && d.getDockKey().isFloatEnabled()) {
                DockableState.Location location = d.getDockKey().getLocation();
                if (location == DockableState.Location.DOCKED) {
                    DockingDesktop.this.setFloating(d, true);
                } else if (location == DockableState.Location.FLOATING) {
                    DockingDesktop.this.setFloating(d, false);
                }
            }
        }
    };
    private AbstractAction cancelAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DockingDesktop.this.dragControler.cancelDrag();
        }
    };

    public DockingDesktop() {
        this("", null);
    }

    public DockingDesktop(String desktopName) {
        this(desktopName, null);
    }

    public DockingDesktop(String desktopName, DockingContext context) {
        this.setDesktopName(desktopName);
        this.context = context == null ? new DockingContext() : context;
        this.context.addDesktop(this);
        this.dragControler = DragControlerFactory.getInstance().createDragControler(this);
        this.topBorderPane.setVisible(false);
        this.leftBorderPane.setVisible(false);
        this.bottomBorderPane.setVisible(false);
        this.rightBorderPane.setVisible(false);
        this.contentPane.add((Component)this.topBorderPane, "North");
        this.contentPane.add((Component)this.leftBorderPane, "West");
        this.contentPane.add((Component)this.bottomBorderPane, "South");
        this.contentPane.add((Component)this.rightBorderPane, "East");
        this.contentPane.add((Component)this.dockingPanel, "Center");
        this.add((Component)this.contentPane, DEFAULT_LAYER);
        this.mouseMotionGrabber.setVisible(false);
        this.mouseMotionGrabber.addMouseListener(new MouseAdapter(){
            boolean canUseMouseInfo = DockingUtilities.canUseMouseInfo();

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!this.canUseMouseInfo) {
                    DockingDesktop.this.mouseOutOfExpandedPanelTimer.restart();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!this.canUseMouseInfo) {
                    DockingDesktop.this.mouseOutOfExpandedPanelTimer.stop();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DockingDesktop.this.expandPanel.collapse();
                Window w = SwingUtilities.getWindowAncestor(DockingDesktop.this);
                if (w != null) {
                    w.dispatchEvent(e);
                }
            }
        });
        this.expandPanel.installDocking(this);
        this.expandPanel.setVisible(false);
        this.add((Component)this.mouseMotionGrabber, new Integer(MODAL_LAYER - 1));
        this.add((Component)this.expandPanel, MODAL_LAYER);
        ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                int w = DockingDesktop.this.getWidth();
                int h = DockingDesktop.this.getHeight();
                Insets i = DockingDesktop.this.getDockingPanelInsets();
                if (event.getComponent() == DockingDesktop.this) {
                    DockingDesktop.this.expandPanel.collapse();
                    DockingDesktop.this.contentPane.setBounds(0, 0, w, h);
                    DockingDesktop.this.revalidate();
                } else if (event.getComponent() == DockingDesktop.this.dockingPanel) {
                    if (DockingDesktop.this.maximizedComponent != null) {
                        if (DockingPreferences.isLightWeightUsageEnabled()) {
                            DockingDesktop.this.maximizedComponent.setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                        } else if (DockingPreferences.isSingleHeavyWeightComponent()) {
                            if (DockingUtilities.isHeavyWeightComponent(DockingDesktop.this.maximizedComponent)) {
                                DockingDesktop.this.maximizedComponent.setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                            } else {
                                DockingDesktop.this.maximizedComponent.getParent().setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                            }
                        } else {
                            DockingDesktop.this.maximizedComponent.getParent().setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                        }
                    }
                    DockingDesktop.this.mouseMotionGrabber.setBounds(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
                    DockingDesktop.this.dockingPanel.revalidate();
                }
            }
        };
        this.addComponentListener(resizeListener);
        this.dockingPanel.addComponentListener(resizeListener);
        this.expandPanel.addPropertyChangeListener("AutoHideExpanded", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getNewValue().equals(Boolean.TRUE)) {
                    DockingDesktop.this.mouseMotionGrabber.setVisible(true);
                } else {
                    DockingDesktop.this.mouseMotionGrabber.setVisible(false);
                }
            }
        });
        this.mouseOutOfExpandedPanelTimer.setRepeats(false);
        this.installKeyboardBindings();
        final boolean floatingContainerFollowParentWindow = UIManager.getBoolean("FloatingContainer.followParentWindow");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", DockingDesktop.this.focusHandler);
                Window w = SwingUtilities.getWindowAncestor(DockingDesktop.this);
                w.addWindowListener(DockingDesktop.this.windowListener);
                DockingDesktop.this.context.registerWindow(w);
                if (floatingContainerFollowParentWindow) {
                    w.addComponentListener(DockingDesktop.this.windowMovementListener);
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", DockingDesktop.this.focusHandler);
                if (event == null || event.getAncestorParent() == null) {
                    return;
                }
                Window w = SwingUtilities.getWindowAncestor(event.getAncestorParent());
                if (w != null) {
                    w.removeWindowListener(DockingDesktop.this.windowListener);
                    if (floatingContainerFollowParentWindow) {
                        w.removeComponentListener(DockingDesktop.this.windowMovementListener);
                    }
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void installKeyboardBindings() {
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.closeActionAccelerator");
        if (ks != null) {
            this.getInputMap(1).put(ks, "close");
            this.getActionMap().put("close", this.closeAction);
        }
        if ((ks = (KeyStroke)UIManager.get("DockingDesktop.maximizeActionAccelerator")) != null) {
            this.getInputMap(1).put(ks, "maximize");
            this.getActionMap().put("maximize", this.maximizeAction);
        }
        if ((ks = (KeyStroke)UIManager.get("DockingDesktop.dockActionAccelerator")) != null) {
            this.getInputMap(1).put(ks, "dock");
            this.getActionMap().put("dock", this.dockAction);
        }
        if ((ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator")) != null) {
            this.getInputMap(1).put(ks, "float");
            this.getActionMap().put("float", this.floatAction);
        }
        ks = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(2).put(ks, "cancel");
        this.getActionMap().put("cancel", this.cancelAction);
    }

    public Dockable getSelectedDockable() {
        return this.focusHandler.currentDockable;
    }

    public void setOpaqueContents(boolean opaque) {
        this.contentPane.setOpaque(opaque);
        this.dockingPanel.setOpaque(opaque);
    }

    public boolean isOpaqueContents() {
        return this.contentPane.isOpaque();
    }

    DockingPanel getDockingPanel() {
        return this.dockingPanel;
    }

    public void registerDockable(Dockable dockable) {
        this.context.registerDockable(dockable);
    }

    public void unregisterDockable(Dockable dockable) {
        this.context.unregisterDockable(dockable);
    }

    public static String getDockingFrameworkVersion() {
        return CURRENT_VERSION_NUMBER;
    }

    public static String getDockingFrameworkBuildDate() {
        return BUILD_DATE;
    }

    public void createTab(Dockable base, Dockable dockable, int order) {
        this.createTab(base, dockable, order, false);
    }

    public void createTab(Dockable base, Dockable dockable, int order, boolean select) {
        this.createTab(base, dockable, order, select, true);
    }

    private void createTab(Dockable base, Dockable dockable, int order, boolean select, boolean triggerEvents) {
        if (base == null) {
            throw new NullPointerException("base must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        this.context.registerDockable(dockable);
        if (this.getMaximizedDockable() == base) {
            this.restore(this.getMaximizedDockable());
        }
        DockableState currentState = this.getDockableState(dockable);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        DockableState newState = null;
        if (base.getDockKey().getLocation() == DockableState.Location.FLOATING) {
            RelativeDockablePosition position = new RelativeDockablePosition(this.dockingPanel, dockable);
            newState = new DockableState(this, dockable, base.getDockKey().getLocation(), position);
        } else {
            newState = new DockableState(this, dockable, base.getDockKey().getLocation());
        }
        DockableStateWillChangeEvent dswe = new DockableStateWillChangeEvent(currentState, newState);
        DockingActionCreateTabEvent dae = new DockingActionCreateTabEvent(this, dockable, currentLocation, newState.getLocation(), base, order);
        if (triggerEvents && !this.isDockingActionAccepted(dae, dswe)) {
            return;
        }
        TabbedDockableContainer dockableTab = null;
        if (currentLocation != DockableState.Location.CLOSED) {
            dockableTab = DockingUtilities.findTabbedDockableContainer(dockable);
        }
        TabbedDockableContainer baseTab = DockingUtilities.findTabbedDockableContainer(base);
        if (dockableTab != null && dockableTab != baseTab) {
            this.remove(dockable);
        }
        if (currentState != null && currentState.isFloating() && newState.isFloating()) {
            Window w = SwingUtilities.getWindowAncestor(dockable.getComponent());
            Window w2 = SwingUtilities.getWindowAncestor(base.getComponent());
            if (w != null) {
                if (w != w2) {
                    this.remove(dockable);
                } else {
                    this.remove(dockable);
                }
            }
        } else if (currentState != null && !currentState.isFloating() && newState.isFloating()) {
            this.remove(dockable);
        }
        if (!newState.isFloating()) {
            this.removeFromTabbedGroup(dockable);
        }
        if (baseTab != null) {
            baseTab.addDockable(dockable, order);
        } else {
            SingleDockableContainer baseOldContainer = DockingUtilities.findSingleDockableContainer(base);
            baseOldContainer.uninstallDocking(this);
            baseTab = DockableContainerFactory.getFactory().createTabbedDockableContainer();
            baseTab.installDocking(this);
            baseTab.addDockable(base, 0);
            baseTab.addDockable(dockable, 1);
            ((JTabbedPane)((Object)baseTab)).addChangeListener(this.focusHandler);
            DockingUtilities.replaceChild(((Component)((Object)baseOldContainer)).getParent(), (Component)((Object)baseOldContainer), (Component)((Object)baseTab));
        }
        if (select) {
            baseTab.setSelectedDockable(dockable);
        }
        this.context.setDockableState(dockable, newState);
        if (newState.isFloating() && !currentState.isFloating()) {
            this.storePreviousFloatingState(dockable, currentState);
        }
        if (triggerEvents) {
            dockable.getDockKey().setLocation(base.getDockKey().getLocation());
            this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
        }
        if (!newState.isFloating()) {
            this.addToTabbedGroup(base, dockable);
        }
        DockingUtilities.updateResizeWeights(this.dockingPanel);
    }

    public void split(Dockable base, Dockable newDockable, DockingConstants.Split position, double proportion) {
        Component right;
        Component left;
        DockableStateWillChangeEvent event;
        if (base == null) {
            throw new NullPointerException("base must not be null");
        }
        if (newDockable == null) {
            throw new NullPointerException("newDockable must not be null");
        }
        DockableState currentState = this.getDockableState(newDockable);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        boolean stateChange = currentState == null || !currentState.isDocked();
        DockableState newState = new DockableState(this, newDockable, DockableState.Location.DOCKED);
        DockingActionSplitDockableEvent dae = new DockingActionSplitDockableEvent(this, newDockable, currentLocation, newState.getLocation(), base, position, 0.5f);
        if (!this.isDockingActionAccepted(dae, event = new DockableStateWillChangeEvent(currentState, newState))) {
            return;
        }
        TabbedDockableContainer baseTab = DockingUtilities.findTabbedDockableContainer(base);
        SingleDockableContainer dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(newDockable, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
        dockableContainer.installDocking(this);
        SplitContainer split = position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_BOTTOM ? new SplitContainer(0) : new SplitContainer(1);
        if (baseTab != null) {
            DockingUtilities.replaceChild(((Component)((Object)baseTab)).getParent(), (Component)((Object)baseTab), split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                left = (Component)((Object)dockableContainer);
                right = (Component)((Object)baseTab);
            } else {
                left = (Component)((Object)baseTab);
                right = (Component)((Object)dockableContainer);
            }
        } else {
            SingleDockableContainer baseContainer = DockingUtilities.findSingleDockableContainer(base);
            assert (baseContainer != null);
            DockingUtilities.replaceChild(((Component)((Object)baseContainer)).getParent(), (Component)((Object)baseContainer), split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                left = (Component)((Object)dockableContainer);
                right = (Component)((Object)baseContainer);
            } else {
                left = (Component)((Object)baseContainer);
                right = (Component)((Object)dockableContainer);
            }
        }
        split.setLeftComponent(left);
        split.setRightComponent(right);
        this.context.registerDockable(newDockable);
        this.context.setDockableState(newDockable, newState);
        newDockable.getDockKey().setLocation(DockableState.Location.DOCKED);
        this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
        this.removeFromTabbedGroup(newDockable);
        DockingUtilities.updateResizeWeights(this.dockingPanel);
        if (proportion >= 0.0) {
            SwingUtilities.invokeLater(new SplitResizer(split, proportion));
        }
    }

    public void split(Dockable base, Dockable newDockable, DockingConstants.Split position) {
        this.split(base, newDockable, position, -1.0);
    }

    public void splitComponent(Component base, Dockable dockable, DockingConstants.Split position) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable");
        }
        this.context.registerDockable(dockable);
        DockableState.Location futureLocation = DockingUtilities.getDockableLocationFromHierarchy(base);
        DockableState currentState = this.getDockableState(dockable);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        boolean stateChange = false;
        if (currentState == null) {
            stateChange = true;
        } else if (currentState.getLocation() != futureLocation) {
            stateChange = true;
        }
        DockableState newState = new DockableState(this, dockable, futureLocation);
        DockableStateWillChangeEvent dswe = new DockableStateWillChangeEvent(currentState, newState);
        DockingActionSplitComponentEvent dae = new DockingActionSplitComponentEvent(this, dockable, currentLocation, newState.getLocation(), base, position, 0.5f);
        if (!this.isDockingActionAccepted(dae, dswe)) {
            return;
        }
        if (stateChange && currentState.isFloating()) {
            this.removePreviousFloatingState(dockable);
        }
        Container oldContainer = (Container)((Object)DockingUtilities.findSingleDockableContainer(dockable));
        int oldWidth = 0;
        int oldHeight = 0;
        if (oldContainer != null) {
            oldWidth = oldContainer.getWidth();
            oldHeight = oldContainer.getHeight();
        } else {
            oldWidth = base.getWidth() / 2;
            oldHeight = base.getHeight() / 2;
        }
        SingleDockableContainer dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
        dockableContainer.installDocking(this);
        SplitContainer split = position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_BOTTOM ? new SplitContainer(0) : new SplitContainer(1);
        if (base != this.dockingPanel) {
            DockingUtilities.replaceChild(base.getParent(), base, split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent((Component)((Object)dockableContainer));
                split.setRightComponent(base);
            } else {
                split.setRightComponent((Component)((Object)dockableContainer));
                split.setLeftComponent(base);
            }
        } else if (this.dockingPanel.getComponentCount() != 0) {
            Component dockingPanelChild = this.dockingPanel.getComponent(0);
            DockingUtilities.replaceChild(this.dockingPanel, dockingPanelChild, split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent((Component)((Object)dockableContainer));
                split.setRightComponent(dockingPanelChild);
            } else {
                split.setRightComponent((Component)((Object)dockableContainer));
                split.setLeftComponent(dockingPanelChild);
            }
        } else {
            this.dockingPanel.add((Component)((Object)dockableContainer));
        }
        if (position == DockingConstants.SPLIT_TOP) {
            SwingUtilities.invokeLater(new SplitResizer(split, oldHeight));
        } else if (position == DockingConstants.SPLIT_BOTTOM) {
            SwingUtilities.invokeLater(new SplitResizer(split, -oldHeight));
        } else if (position == DockingConstants.SPLIT_LEFT) {
            SwingUtilities.invokeLater(new SplitResizer(split, oldWidth));
        } else if (position == DockingConstants.SPLIT_RIGHT) {
            SwingUtilities.invokeLater(new SplitResizer(split, -oldWidth));
        }
        this.context.setDockableState(dockable, newState);
        if (stateChange && futureLocation == DockableState.Location.FLOATING) {
            this.storePreviousFloatingState(dockable, currentState);
        }
        dockable.getDockKey().setLocation(futureLocation);
        this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
        this.removeFromTabbedGroup(dockable);
        DockingUtilities.updateResizeWeights(this.dockingPanel);
    }

    public void splitComponent(Component base, Container dockablesContainer, DockingConstants.Split position) {
        if (dockablesContainer instanceof SingleDockableContainer) {
            this.splitComponent(base, ((SingleDockableContainer)((Object)dockablesContainer)).getDockable(), position);
        } else if (dockablesContainer instanceof TabbedDockableContainer) {
            this.splitTab(base, (TabbedDockableContainer)((Object)dockablesContainer), position);
        } else {
            System.err.println("unknow split request !" + dockablesContainer);
        }
    }

    private void splitTab(Component base, TabbedDockableContainer tdc, DockingConstants.Split position) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        Dockable firstDockable = tdc.getDockableAt(0);
        DockableState currentState = this.getDockableState(firstDockable);
        boolean stateChange = false;
        if (currentState.isFloating()) {
            this.removePreviousFloatingStates(tdc);
            stateChange = true;
        }
        Container oldContainer = (Container)((Object)tdc);
        int oldWidth = 0;
        int oldHeight = 0;
        if (oldContainer != null) {
            oldWidth = oldContainer.getWidth();
            oldHeight = oldContainer.getHeight();
        } else {
            oldWidth = base.getWidth() / 2;
            oldHeight = base.getHeight() / 2;
        }
        TabbedDockableContainer dockableContainer = tdc;
        SplitContainer split = position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_BOTTOM ? new SplitContainer(0) : new SplitContainer(1);
        if (base != this.dockingPanel) {
            DockingUtilities.replaceChild(base.getParent(), base, split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent((Component)((Object)dockableContainer));
                split.setRightComponent(base);
            } else {
                split.setRightComponent((Component)((Object)dockableContainer));
                split.setLeftComponent(base);
            }
        } else if (this.dockingPanel.getComponentCount() != 0) {
            Component dockingPanelChild = this.dockingPanel.getComponent(0);
            DockingUtilities.replaceChild(this.dockingPanel, dockingPanelChild, split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent((Component)((Object)dockableContainer));
                split.setRightComponent(dockingPanelChild);
            } else {
                split.setRightComponent((Component)((Object)dockableContainer));
                split.setLeftComponent(dockingPanelChild);
            }
        } else {
            this.dockingPanel.add((Component)((Object)dockableContainer));
        }
        if (position == DockingConstants.SPLIT_TOP) {
            SwingUtilities.invokeLater(new SplitResizer(split, oldHeight));
        } else if (position == DockingConstants.SPLIT_BOTTOM) {
            SwingUtilities.invokeLater(new SplitResizer(split, -oldHeight));
        } else if (position == DockingConstants.SPLIT_LEFT) {
            SwingUtilities.invokeLater(new SplitResizer(split, oldWidth));
        } else if (position == DockingConstants.SPLIT_RIGHT) {
            SwingUtilities.invokeLater(new SplitResizer(split, -oldWidth));
        }
        if (stateChange) {
            for (int i = 0; i < tdc.getTabCount(); ++i) {
                Dockable d = tdc.getDockableAt(i);
                DockableState newState = new DockableState(this, d, DockableState.Location.DOCKED);
                this.context.setDockableState(d, newState);
            }
        }
    }

    public void move(Dockable base, Dockable dockable, DockingConstants.Split position) {
        if (base == null) {
            throw new NullPointerException("base must not be null");
        }
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (dockable == base) {
            return;
        }
        this.remove(dockable);
        this.removeFromTabbedGroup(dockable);
        this.split(base, dockable, position);
    }

    private void show(Dockable dockable, DockingActionEvent action) {
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        DockableState state = this.context.getDockableState(dockable);
        RelativeDockablePosition position = state.getPosition();
        if (position == null) {
            throw new NullPointerException("trying to show a view that was not hidden");
        }
        LinkedList<Dockable> group = this.tabbedGroups.get(dockable);
        boolean tabbed = false;
        if (group != null) {
            Iterator it = group.iterator();
            while (it.hasNext() && !tabbed) {
                Dockable d = (Dockable)it.next();
                if (d == dockable || !this.getDockableState(d).isDocked()) continue;
                this.createTab(d, dockable, Integer.MAX_VALUE, true, false);
                tabbed = true;
            }
        }
        if (!tabbed) {
            SingleDockableContainer sdc = RelativeDockingUtilities.applyDockingAction(dockable, action);
            sdc.installDocking(this);
        }
    }

    public void remove(Dockable dockable) {
        DockableState.Location dockLocation = dockable.getDockKey().getLocation();
        SingleDockableContainer dockableContainer = null;
        Container parentOfSdc = null;
        boolean isChildOfCompoundDockable = false;
        if (dockLocation == DockableState.Location.DOCKED || dockLocation == DockableState.Location.FLOATING) {
            isChildOfCompoundDockable = DockingUtilities.isChildOfCompoundDockable(dockable);
            dockableContainer = DockingUtilities.findSingleDockableContainer(dockable);
            parentOfSdc = ((JComponent)((Object)dockableContainer)).getParent();
            this.removeContainer(dockableContainer);
        }
        if (dockLocation == DockableState.Location.FLOATING) {
            FloatingDockableContainer fdc = (FloatingDockableContainer)((Object)SwingUtilities.getWindowAncestor(dockable.getComponent()));
            if (!(parentOfSdc instanceof TabbedDockableContainer) && !isChildOfCompoundDockable) {
                DockingUtilities.dispose(fdc);
            }
        } else if (dockLocation == DockableState.Location.HIDDEN) {
            AutoHideButton btn = this.autoHideButtons.get(dockable.getDockKey());
            if (btn == null) {
                dockableContainer = DockingUtilities.findSingleDockableContainer(dockable);
                parentOfSdc = ((JComponent)((Object)dockableContainer)).getParent();
                this.removeContainer(dockableContainer);
            } else {
                btn.setVisible(false);
                this.expandPanel.remove(dockable);
            }
            this.revalidate();
        }
    }

    public void dropRemove(DockableDragSource dragSource) {
        Container dockableContainer;
        Dockable d = dragSource.getDockable();
        DockableState state = this.context.getDockableState(d);
        if (state != null) {
            DockableState updatedState = new DockableState(state, new RelativeDockablePosition(this.getRelativeAncestorContainer(d), d));
            this.context.setDockableState(dragSource.getDockable(), updatedState);
        }
        if ((dockableContainer = dragSource.getDockableContainer()) instanceof TabbedDockableContainer) {
            this.remove((TabbedDockableContainer)((Object)dockableContainer));
        } else {
            this.remove(dragSource.getDockable());
        }
    }

    private void remove(TabbedDockableContainer tdc) {
        Dockable firstDockable = tdc.getDockableAt(0);
        DockableState.Location dockLocation = firstDockable.getDockKey().getLocation();
        if (dockLocation == DockableState.Location.FLOATING) {
            FloatingDockableContainer fdc = (FloatingDockableContainer)((Object)SwingUtilities.getWindowAncestor((Container)((Object)tdc)));
            DockingUtilities.dispose(fdc);
        }
        boolean invalidateDesktop = true;
        Container parent = ((Component)((Object)tdc)).getParent();
        if (parent != null) {
            if (parent instanceof SplitContainer) {
                SplitContainer viewParent = (SplitContainer)parent;
                if (viewParent.getLeftComponent() == tdc) {
                    viewParent.remove((Component)((Object)tdc));
                    Component other = viewParent.getRightComponent();
                    Container viewGParent = viewParent.getParent();
                    DockingUtilities.replaceChild(viewGParent, viewParent, other);
                } else {
                    viewParent.remove((Component)((Object)tdc));
                    Component other = viewParent.getLeftComponent();
                    Container viewGParent = viewParent.getParent();
                    DockingUtilities.replaceChild(viewGParent, viewParent, other);
                }
            } else if (parent == this.dockingPanel) {
                this.dockingPanel.remove(0);
            } else if (SwingUtilities.getWindowAncestor(parent) instanceof FloatingDockableContainer) {
                invalidateDesktop = false;
            } else {
                throw new IllegalStateException("View is not contained in desktop hierarchy " + parent);
            }
            if (invalidateDesktop) {
                this.dockingPanel.invalidate();
                this.dockingPanel.validate();
                this.dockingPanel.repaint();
            }
        }
    }

    public void maximize(Dockable dockable) {
        DockableStateWillChangeEvent dswe;
        if (dockable.getDockKey().getLocation() != DockableState.Location.DOCKED) {
            throw new IllegalArgumentException("Dockable isn't currently in the DOCKED state : " + dockable);
        }
        DockableState currentState = this.getDockableState(dockable);
        boolean stateChange = currentState == null || !currentState.isMaximized();
        DockableState newState = new DockableState(this, dockable, DockableState.Location.MAXIMIZED);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        DockingActionSimpleStateChangeEvent dae = new DockingActionSimpleStateChangeEvent(this, dockable, currentLocation, DockableState.Location.MAXIMIZED);
        if (!this.isDockingActionAccepted(dae, dswe = new DockableStateWillChangeEvent(currentState, newState))) {
            return;
        }
        SingleDockableContainer currentMaximizedContainer = (SingleDockableContainer)((Object)this.maximizedComponent);
        if (currentMaximizedContainer != null && currentMaximizedContainer.getDockable() != dockable) {
            this.restore(currentMaximizedContainer.getDockable());
        }
        SingleDockableContainer sdc = DockingUtilities.findSingleDockableContainer(dockable);
        Component dockableContainer = (Component)((Object)sdc);
        DockingUtilities.replaceChild(dockableContainer.getParent(), dockableContainer, this.dummyMaximedReplacer);
        SingleDockableContainer maxDockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_DESKTOP);
        maxDockableContainer.installDocking(this);
        this.maximizedComponent = (Component)((Object)maxDockableContainer);
        Insets i = this.getDockingPanelInsets();
        if (DockingPreferences.isLightWeightUsageEnabled()) {
            this.maximizedComponent.setBounds(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
            this.add(this.maximizedComponent, JLayeredPane.PALETTE_LAYER);
        } else {
            this.currentMaximizedComponentIsHeavyWeight = false;
            if (DockingPreferences.isSingleHeavyWeightComponent()) {
                Component comp = dockable.getComponent();
                if (DockingUtilities.isHeavyWeightComponent(comp)) {
                    this.maximizedComponent.setBounds(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
                    this.add(this.maximizedComponent, JLayeredPane.PALETTE_LAYER);
                    this.currentMaximizedComponentIsHeavyWeight = true;
                } else {
                    Panel awtPanel = new Panel(new BorderLayout());
                    awtPanel.setBounds(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
                    awtPanel.add(this.maximizedComponent, "Center");
                    awtPanel.validate();
                    this.add((Component)awtPanel, JLayeredPane.PALETTE_LAYER);
                }
            } else {
                Panel awtPanel = new Panel(new BorderLayout());
                awtPanel.setBounds(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
                awtPanel.add(this.maximizedComponent, "Center");
                awtPanel.validate();
                this.add((Component)awtPanel, JLayeredPane.PALETTE_LAYER);
            }
        }
        this.context.setDockableState(dockable, newState);
        dockable.getDockKey().setLocation(DockableState.Location.MAXIMIZED);
        this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
        dockable.getComponent().requestFocus();
        this.repaint();
    }

    public void restore(final Dockable dockable) {
        DockableStateWillChangeEvent dswe;
        if (dockable.getDockKey().getLocation() != DockableState.Location.MAXIMIZED) {
            throw new IllegalArgumentException("Dockable isn't currently in the MAXIMIZED state : " + dockable);
        }
        DockableState currentState = this.getDockableState(dockable);
        boolean stateChange = currentState != null || currentState.isMaximized();
        DockableState newState = new DockableState(this, dockable, DockableState.Location.DOCKED);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        DockingActionSimpleStateChangeEvent dae = new DockingActionSimpleStateChangeEvent(this, dockable, currentLocation, DockableState.Location.DOCKED);
        if (!this.isDockingActionAccepted(dae, dswe = new DockableStateWillChangeEvent(currentState, newState))) {
            return;
        }
        if (!DockingPreferences.isLightWeightUsageEnabled()) {
            if (DockingPreferences.isSingleHeavyWeightComponent() && this.currentMaximizedComponentIsHeavyWeight) {
                this.remove(this.maximizedComponent);
            } else {
                this.remove(this.maximizedComponent.getParent());
            }
        } else {
            this.remove(this.maximizedComponent);
        }
        ((SingleDockableContainer)((Object)this.maximizedComponent)).uninstallDocking(this);
        SingleDockableContainer sdc = null;
        sdc = this.dummyMaximedReplacer.getParent() instanceof TabbedDockableContainer ? DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_TABBED_CONTAINER) : DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
        DockingUtilities.replaceChild(this.dummyMaximedReplacer.getParent(), this.dummyMaximedReplacer, (Component)((Object)sdc));
        this.context.setDockableState(dockable, newState);
        dockable.getDockKey().setLocation(DockableState.Location.DOCKED);
        this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dockable.getComponent().requestFocus();
            }
        });
        sdc.installDocking(this);
        this.maximizedComponent = null;
        this.repaint();
    }

    public void setFloating(Dockable dockable, boolean floating) {
        this.setFloating(dockable, floating, null);
    }

    private Container getRelativeAncestorContainer(Dockable dockable) {
        Container compoundAncestor = DockingUtilities.findCompoundAncestorContainer(dockable);
        if (compoundAncestor != null) {
            return compoundAncestor;
        }
        return this.dockingPanel;
    }

    public void setFloating(Dockable dockable, boolean floating, Point screenPosition) {
        if (dockable == null) {
            throw new NullPointerException("dockable");
        }
        DockableState currentState = this.getDockableState(dockable);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        SingleDockableContainer dockableContainer = DockingUtilities.findSingleDockableContainer(dockable);
        if (floating) {
            DockingActionSimpleStateChangeEvent dae;
            DockableState.Location location = dockable.getDockKey().getLocation();
            RelativeDockablePosition position = null;
            switch (location) {
                case DOCKED: {
                    position = new RelativeDockablePosition(this.getRelativeAncestorContainer(dockable), dockable);
                    break;
                }
                case HIDDEN: {
                    position = currentState.getPosition();
                    break;
                }
                case FLOATING: {
                    if (DockingUtilities.findTabbedDockableContainer(dockable) != null) break;
                    throw new IllegalArgumentException("floating not tabbed");
                }
                case CLOSED: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not docked " + (Object)((Object)location));
                }
            }
            DockableState newState = new DockableState(this, dockable, DockableState.Location.FLOATING, position);
            DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
            if (location == DockableState.Location.FLOATING) {
                Dimension previousSize = null;
                this.remove(dockable);
                if (dockableContainer != null) {
                    previousSize = ((Component)((Object)dockableContainer)).getSize();
                }
                FloatingDockableContainer fdc = this.createFloatingDockableContainer(dockable);
                if (previousSize != null) {
                    DockingUtilities.setSize(fdc, previousSize);
                    DockingUtilities.validate(fdc);
                } else {
                    DockingUtilities.pack(fdc);
                }
                if (screenPosition == null) {
                    DockingUtilities.setLocationRelativeTo(fdc, this);
                } else {
                    DockingUtilities.setLocation(fdc, screenPosition);
                }
                DockingUtilities.setVisible(fdc, true);
            } else if (currentState != null && this.isDockingActionAccepted(dae = new DockingActionSimpleStateChangeEvent(this, dockable, currentLocation, DockableState.Location.FLOATING), event)) {
                Dimension previousSize = null;
                if (dockableContainer != null) {
                    previousSize = ((Component)((Object)dockableContainer)).getSize();
                }
                this.remove(dockable);
                this.storePreviousFloatingState(dockable, new DockableState(currentState, position));
                FloatingDockableContainer fdc = this.createFloatingDockableContainer(dockable);
                if (previousSize != null) {
                    DockingUtilities.setSize(fdc, previousSize);
                    DockingUtilities.validate(fdc);
                } else {
                    DockingUtilities.pack(fdc);
                }
                if (screenPosition == null) {
                    DockingUtilities.setLocationRelativeTo(fdc, this);
                } else {
                    DockingUtilities.setLocation(fdc, screenPosition);
                }
                DockingUtilities.setVisible(fdc, true);
                this.context.setDockableState(dockable, newState);
                dockable.getDockKey().setLocation(DockableState.Location.FLOATING);
                this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
                if (dockable instanceof CompoundDockable) {
                    this.updateCompoundChildrenState((CompoundDockable)dockable, DockableState.Location.FLOATING);
                }
                DockingUtilities.updateResizeWeights(this.dockingPanel);
                this.revalidate();
            }
        } else {
            DockableState previousState = this.getPreviousDockableState(dockable);
            DockableState newState = new DockableState(this, dockable, previousState.getLocation(), previousState.getPosition());
            DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
            if (currentState != null && currentState.isFloating()) {
                DockingActionEvent dae;
                if (previousState.isDocked()) {
                    RelativeDockablePosition prevPos = previousState.getPosition();
                    Container relativeAncestor = prevPos.getRelativeAncestorContainer();
                    if (relativeAncestor == null) {
                        relativeAncestor = this.dockingPanel;
                    }
                    dae = RelativeDockingUtilities.getInsertionDockingAction(relativeAncestor, dockable, currentState, newState);
                } else if (previousState.isHidden()) {
                    dae = new DockingActionSimpleStateChangeEvent(this, dockable, DockableState.Location.FLOATING, DockableState.Location.HIDDEN);
                } else {
                    throw new RuntimeException();
                }
                if (this.isDockingActionAccepted(dae, event)) {
                    this.removePreviousFloatingState(dockable);
                    Container parentOfSdc = null;
                    parentOfSdc = ((JComponent)((Object)dockableContainer)).getParent();
                    this.removeContainer(dockableContainer);
                    FloatingDockableContainer fdc = (FloatingDockableContainer)((Object)SwingUtilities.getWindowAncestor(dockable.getComponent()));
                    if (!(parentOfSdc instanceof TabbedDockableContainer)) {
                        DockingUtilities.dispose(fdc);
                    }
                    this.context.setDockableState(dockable, newState);
                    if (previousState.isDocked()) {
                        this.show(dockable, dae);
                    } else if (previousState.isHidden()) {
                        this.floatingToHide(dockable, previousState.getPosition());
                    } else {
                        throw new RuntimeException();
                    }
                    dockable.getDockKey().setLocation(previousState.getLocation());
                    this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
                    dockable.getComponent().requestFocus();
                    if (dockable instanceof CompoundDockable) {
                        this.updateCompoundChildrenState((CompoundDockable)dockable, newState.getLocation());
                    }
                    DockingUtilities.updateResizeWeights(this.dockingPanel);
                    this.revalidate();
                }
            }
        }
    }

    void setFloating(TabbedDockableContainer tdc, Point screenPosition) {
        Dockable firstDockable = tdc.getDockableAt(0);
        DockableState currentState = this.getDockableState(firstDockable);
        if (!currentState.isDocked()) {
            throw new IllegalArgumentException("not docked");
        }
        if (this.checkDockableStateWillChange(tdc, DockableState.Location.FLOATING)) {
            RelativeDockablePosition position = new RelativeDockablePosition(this.dockingPanel, firstDockable);
            Dimension previousSize = ((Component)((Object)tdc)).getSize();
            this.remove(tdc);
            this.storePreviousFloatingStates(tdc);
            FloatingDockableContainer fdc = this.createFloatingDockableContainer(tdc);
            DockingUtilities.setSize(fdc, previousSize);
            DockingUtilities.validate(fdc);
            if (screenPosition == null) {
                DockingUtilities.setLocationRelativeTo(fdc, this);
            } else {
                DockingUtilities.setLocation(fdc, screenPosition);
            }
            DockingUtilities.setVisible(fdc, true);
            this.fireStateChanged(tdc, DockableState.Location.FLOATING, position);
            DockingUtilities.updateResizeWeights(this.dockingPanel);
            this.revalidate();
        }
    }

    private void storePreviousFloatingStates(TabbedDockableContainer tdc) {
        for (int i = 0; i < tdc.getTabCount(); ++i) {
            Dockable d = tdc.getDockableAt(i);
            DockableState current = this.getDockableState(d);
            this.storePreviousFloatingState(d, current);
        }
    }

    private boolean checkDockableStateWillChange(TabbedDockableContainer tdc, DockableState.Location futureLocation) {
        for (int i = 0; i < tdc.getTabCount(); ++i) {
            Dockable d = tdc.getDockableAt(i);
            DockableState currentState = this.getDockableState(d);
            DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
            DockableState newState = new DockableState(this, d, futureLocation, null);
            DockableStateWillChangeEvent event = new DockableStateWillChangeEvent(currentState, newState);
            DockingActionSimpleStateChangeEvent dae = new DockingActionSimpleStateChangeEvent(this, d, currentLocation, newState.getLocation());
            if (this.isDockingActionAccepted(dae, event)) continue;
            return false;
        }
        return true;
    }

    private void fireStateChanged(TabbedDockableContainer tdc, DockableState.Location futureLocation, RelativeDockablePosition position) {
        for (int i = 0; i < tdc.getTabCount(); ++i) {
            Dockable d = tdc.getDockableAt(i);
            DockableState currentState = this.getDockableState(d);
            DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
            DockableState newState = new DockableState(this, d, futureLocation, position);
            this.context.setDockableState(d, newState);
            d.getDockKey().setLocation(DockableState.Location.FLOATING);
            DockingActionSimpleStateChangeEvent dae = new DockingActionSimpleStateChangeEvent(this, d, currentLocation, newState.getLocation());
            this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
        }
    }

    private DockableState removePreviousFloatingStates(TabbedDockableContainer tdc) {
        DockableState first = this.removePreviousFloatingState(tdc.getDockableAt(0));
        for (int i = 1; i < tdc.getTabCount(); ++i) {
            Dockable d = tdc.getDockableAt(i);
            this.removePreviousFloatingState(d);
        }
        return first;
    }

    public DockableState getPreviousDockableState(Dockable dockable) {
        return this.previousFloatingDockableStates.get(dockable);
    }

    private DockableState removePreviousFloatingState(Dockable dockable) {
        if (dockable instanceof CompoundDockable) {
            ArrayList<Dockable> children = DockingUtilities.findCompoundDockableChildren((CompoundDockable)dockable);
            for (int i = 0; i < children.size(); ++i) {
                Dockable d = children.get(i);
                this.previousFloatingDockableStates.remove(d);
            }
        }
        return this.previousFloatingDockableStates.remove(dockable);
    }

    private void storePreviousFloatingState(Dockable dockable, DockableState state) {
        RelativeDockablePosition pos = state.getPosition();
        if (pos.getRelativeAncestorContainer() == null) {
            Container c = DockingUtilities.findCompoundAncestorContainer(dockable);
            if (c != null) {
                pos.resetRelativePosition(c, dockable);
            } else {
                pos.resetRelativePosition(this.dockingPanel, dockable);
            }
        }
        this.previousFloatingDockableStates.put(dockable, state);
        if (dockable instanceof CompoundDockable) {
            ArrayList<Dockable> children = DockingUtilities.findCompoundDockableChildren((CompoundDockable)dockable);
            for (int i = 0; i < children.size(); ++i) {
                Dockable d = children.get(i);
                this.previousFloatingDockableStates.put(d, new DockableState(this, d, state.getLocation(), state.getPosition()));
            }
        }
    }

    private void floatingToHide(Dockable dockable, RelativeDockablePosition position) {
        DockKey k = dockable.getDockKey();
        AutoHideButton btn = this.autoHideButtons.get(k);
        if (btn == null) {
            btn = new AutoHideButton();
            this.autoHideButtons.put(k, btn);
            int zone = k.getAutoHideBorder() == null ? AutoHidePolicy.getPolicy().getDefaultHideBorder().value() : k.getAutoHideBorder().value();
            btn.init(dockable, zone);
            this.borderPanes[zone].setVisible(true);
            this.borderPanes[zone].add(btn);
            this.borderPanes[zone].revalidate();
        } else {
            int zone = btn.getZone();
            this.borderPanes[zone].setVisible(true);
            btn.setVisible(true);
            this.borderPanes[zone].revalidate();
        }
    }

    private void moveFloatingWindows() {
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w == null) {
            return;
        }
        Point newLocation = w.getLocation();
        if (this.lastWindowLocation != null) {
            int dx = newLocation.x - this.lastWindowLocation.x;
            int dy = newLocation.y - this.lastWindowLocation.y;
            Window[] childWindow = w.getOwnedWindows();
            for (int i = 0; i < childWindow.length; ++i) {
                if (!(childWindow[i] instanceof FloatingDockableContainer) || !childWindow[i].isVisible()) continue;
                Point p = childWindow[i].getLocation();
                childWindow[i].setLocation(p.x + dx, p.y + dy);
            }
        }
        this.lastWindowLocation = newLocation;
    }

    protected FloatingDockableContainer createFloatingDockableContainer(Dockable dockable) {
        Window ownerWindow = SwingUtilities.getWindowAncestor(this);
        FloatingDockableContainer fdc = DockableContainerFactory.getFactory().createFloatingDockableContainer(ownerWindow);
        fdc.installDocking(this);
        fdc.setInitialDockable(dockable);
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator");
        if (ks != null) {
            JRootPane root = DockingUtilities.getRootPane(fdc);
            root.getInputMap(2).put(ks, "float");
            root.getActionMap().put("float", this.floatAction);
        }
        return fdc;
    }

    protected FloatingDockableContainer createFloatingDockableContainer(TabbedDockableContainer tdc) {
        Window ownerWindow = SwingUtilities.getWindowAncestor(this);
        FloatingDockableContainer fdc = DockableContainerFactory.getFactory().createFloatingDockableContainer(ownerWindow);
        fdc.installDocking(this);
        fdc.setInitialTabbedDockableContainer(tdc);
        KeyStroke ks = (KeyStroke)UIManager.get("DockingDesktop.floatActionAccelerator");
        if (ks != null) {
            JRootPane root = DockingUtilities.getRootPane(fdc);
            root.getInputMap(2).put(ks, "float");
            root.getActionMap().put("float", this.floatAction);
        }
        return fdc;
    }

    protected void removeContainer(SingleDockableContainer dc) {
        dc.uninstallDocking(this);
        boolean invalidateDesktop = true;
        Container parent = ((Component)((Object)dc)).getParent();
        if (parent != null) {
            try {
                if (parent instanceof SplitContainer) {
                    SplitContainer viewParent = (SplitContainer)parent;
                    if (viewParent.getLeftComponent() == dc) {
                        viewParent.remove((Component)((Object)dc));
                        Component other = viewParent.getRightComponent();
                        Container viewGParent = viewParent.getParent();
                        DockingUtilities.replaceChild(viewGParent, viewParent, other);
                    } else {
                        viewParent.remove((Component)((Object)dc));
                        Component other = viewParent.getLeftComponent();
                        Container viewGParent = viewParent.getParent();
                        DockingUtilities.replaceChild(viewGParent, viewParent, other);
                    }
                } else if (parent instanceof TabbedDockableContainer) {
                    TabbedDockableContainer tparent = (TabbedDockableContainer)((Object)parent);
                    tparent.removeDockable(dc.getDockable());
                    if (tparent.getTabCount() == 1) {
                        Dockable last = tparent.getDockableAt(0);
                        this.remove(last);
                        tparent.uninstallDocking(this);
                        ((JTabbedPane)((Object)tparent)).removeChangeListener(this.focusHandler);
                        boolean floating = last.getDockKey().getLocation() == DockableState.Location.FLOATING;
                        SingleDockableContainer lastContainer = null;
                        lastContainer = floating ? DockableContainerFactory.getFactory().createDockableContainer(last, DockableContainerFactory.ParentType.PARENT_DETACHED_WINDOW) : DockableContainerFactory.getFactory().createDockableContainer(last, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
                        lastContainer.installDocking(this);
                        DockingUtilities.replaceChild(((Component)((Object)tparent)).getParent(), (Component)((Object)tparent), (Component)((Object)lastContainer));
                    }
                } else if (parent == this.dockingPanel) {
                    this.dockingPanel.remove(0);
                } else if (SwingUtilities.getWindowAncestor(parent) instanceof FloatingDockableContainer) {
                    invalidateDesktop = false;
                } else {
                    parent.remove((Component)((Object)dc));
                }
                if (invalidateDesktop) {
                    this.dockingPanel.invalidate();
                    this.dockingPanel.validate();
                    this.dockingPanel.repaint();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public DockableState getDockableState(Dockable dockable) {
        return this.context.getDockableState(dockable);
    }

    public void close(Dockable dockable) {
        DockableState currentState = this.getDockableState(dockable);
        if (currentState == null || currentState.isClosed()) {
            return;
        }
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        RelativeDockablePosition position = new RelativeDockablePosition(this.dockingPanel, dockable);
        DockableState newState = new DockableState(this, dockable, DockableState.Location.CLOSED, position);
        DockableStateWillChangeEvent dswe = new DockableStateWillChangeEvent(currentState, newState);
        DockingActionCloseEvent dae = new DockingActionCloseEvent(this, dockable, currentLocation);
        if (this.dockingPanel.isAncestorOf(dockable.getComponent())) {
            if (this.isDockingActionAccepted(dae, dswe)) {
                if (dockable instanceof CompoundDockable) {
                    this.updateCompoundChildrenState((CompoundDockable)dockable, DockableState.Location.CLOSED);
                }
                this.remove(dockable);
                this.removeFromTabbedGroup(dockable);
                this.context.setDockableState(dockable, newState);
                dockable.getDockKey().setLocation(DockableState.Location.CLOSED);
                this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
                DockingUtilities.updateResizeWeights(this.dockingPanel);
            }
        } else if (currentState.isHidden()) {
            if (this.isDockingActionAccepted(dae, dswe)) {
                if (dockable instanceof CompoundDockable) {
                    this.updateCompoundChildrenState((CompoundDockable)dockable, DockableState.Location.CLOSED);
                }
                this.remove(dockable);
                this.removeFromTabbedGroup(dockable);
                this.context.setDockableState(dockable, new DockableState(this, dockable, DockableState.Location.CLOSED, currentState.getPosition()));
                dockable.getDockKey().setLocation(DockableState.Location.CLOSED);
                this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
            }
        } else if (currentState.isFloating()) {
            if (this.isDockingActionAccepted(dae, dswe)) {
                if (dockable instanceof CompoundDockable) {
                    this.updateCompoundChildrenState((CompoundDockable)dockable, DockableState.Location.CLOSED);
                }
                this.remove(dockable);
                this.removeFromTabbedGroup(dockable);
                this.context.setDockableState(dockable, newState);
                dockable.getDockKey().setLocation(DockableState.Location.CLOSED);
                this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
            }
        } else if (currentState.isMaximized()) {
            this.restore(dockable);
            if (this.getDockableState(dockable).isDocked()) {
                this.close(dockable);
            }
        }
    }

    private void updateCompoundChildrenState(CompoundDockable cDockable, DockableState.Location state) {
        ArrayList<Dockable> children = DockingUtilities.findCompoundDockableChildren(cDockable);
        for (int i = 0; i < children.size(); ++i) {
            Dockable d = children.get(i);
            d.getDockKey().setLocation(state);
            DockableState childState = this.getDockableState(d);
            DockableState childNewState = new DockableState(this, d, state);
            this.context.setDockableState(d, childNewState);
            this.context.fireDockableStateChange(new DockableStateChangeEvent(childState, childNewState));
        }
    }

    public void closeAllOtherDockablesInTab(Dockable exception) {
        TabbedDockableContainer tabContainer = DockingUtilities.findTabbedDockableContainer(exception);
        if (tabContainer != null) {
            int i;
            ArrayList<Dockable> dockables = new ArrayList<Dockable>(tabContainer.getTabCount() - 1);
            for (i = 0; i < tabContainer.getTabCount(); ++i) {
                if (tabContainer.getDockableAt(i) == exception) continue;
                dockables.add(tabContainer.getDockableAt(i));
            }
            for (i = 0; i < dockables.size(); ++i) {
                Dockable d = (Dockable)dockables.get(i);
                if (!d.getDockKey().isCloseEnabled()) continue;
                this.close(d);
            }
        }
    }

    public void closeAllDockablesInTab(Dockable base) {
        TabbedDockableContainer tabContainer = DockingUtilities.findTabbedDockableContainer(base);
        if (tabContainer != null) {
            int i;
            ArrayList<Dockable> dockables = new ArrayList<Dockable>(tabContainer.getTabCount());
            for (i = 0; i < tabContainer.getTabCount(); ++i) {
                dockables.add(tabContainer.getDockableAt(i));
            }
            for (i = 0; i < dockables.size(); ++i) {
                Dockable d = (Dockable)dockables.get(i);
                if (!d.getDockKey().isCloseEnabled()) continue;
                this.close(d);
            }
        }
    }

    public void setAutoHide(Dockable dockable, boolean hide) {
        DockKey k = dockable.getDockKey();
        DockableState currentState = this.getDockableState(dockable);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        if (hide) {
            RelativeDockablePosition position = new RelativeDockablePosition(this.getRelativeAncestorContainer(dockable), dockable);
            DockableState newState = new DockableState(this, dockable, DockableState.Location.HIDDEN, position);
            DockableStateWillChangeEvent dswe = new DockableStateWillChangeEvent(currentState, newState);
            DockingActionSimpleStateChangeEvent dae = new DockingActionSimpleStateChangeEvent(this, dockable, currentLocation, DockableState.Location.HIDDEN);
            if (currentLocation != DockableState.Location.HIDDEN && this.isDockingActionAccepted(dae, dswe)) {
                AutoHideButton btn = this.autoHideButtons.get(k);
                if (btn == null) {
                    btn = new AutoHideButton();
                    this.autoHideButtons.put(k, btn);
                    int zone = k.getAutoHideBorder() == null ? AutoHidePolicy.getPolicy().getDefaultHideBorder().value() : k.getAutoHideBorder().value();
                    btn.init(dockable, zone);
                    this.borderPanes[zone].setVisible(true);
                    this.borderPanes[zone].add(btn);
                    this.borderPanes[zone].revalidate();
                } else {
                    int zone = btn.getZone();
                    this.borderPanes[zone].setVisible(true);
                    btn.setVisible(true);
                    this.borderPanes[zone].revalidate();
                }
                this.hide(dockable);
                this.context.setDockableState(dockable, newState);
                k.setLocation(DockableState.Location.HIDDEN);
                this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
                if (dockable instanceof CompoundDockable) {
                    this.updateCompoundChildrenState((CompoundDockable)dockable, DockableState.Location.HIDDEN);
                }
                DockingUtilities.updateResizeWeights(this.dockingPanel);
                this.revalidate();
            }
        } else {
            DockableState newState = new DockableState(this, dockable, DockableState.Location.DOCKED);
            DockableStateWillChangeEvent dswe = new DockableStateWillChangeEvent(currentState, newState);
            RelativeDockablePosition pos = currentState.getPosition();
            Container relativeContainer = pos.getRelativeAncestorContainer();
            if (relativeContainer == null) {
                relativeContainer = this.dockingPanel;
            }
            DockingActionEvent dae = RelativeDockingUtilities.getInsertionDockingAction(relativeContainer, dockable, currentState, newState);
            if (!currentState.isDocked() && this.isDockingActionAccepted(dae, dswe)) {
                AutoHideButton btn = this.autoHideButtons.get(k);
                assert (btn != null);
                int zone = btn.getZone();
                btn.setVisible(false);
                this.expandPanel.collapse();
                if (this.borderPanes[zone].getVisibleButtonCount() == 0) {
                    this.borderPanes[zone].setVisible(false);
                    this.revalidate();
                }
                this.expandPanel.remove(dockable);
                this.show(dockable, dae);
                this.context.setDockableState(dockable, newState);
                k.setLocation(DockableState.Location.DOCKED);
                this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
                if (dockable instanceof CompoundDockable) {
                    this.updateCompoundChildrenState((CompoundDockable)dockable, DockableState.Location.DOCKED);
                }
                DockingUtilities.updateResizeWeights(this.dockingPanel);
                this.revalidate();
            }
        }
    }

    private void hide(Dockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable");
        }
        SingleDockableContainer dockableContainer = DockingUtilities.findSingleDockableContainer(dockable);
        if (dockableContainer == null) {
            throw new IllegalArgumentException("not docked");
        }
        this.remove(dockable);
    }

    public Insets getDockingPanelInsets() {
        Insets i = new Insets(0, 0, 0, 0);
        if (this.topBorderPane != null && this.topBorderPane.isVisible()) {
            i.top += this.topBorderPane.getHeight();
        }
        if (this.leftBorderPane != null && this.leftBorderPane.isVisible()) {
            i.left += this.leftBorderPane.getWidth();
        }
        if (this.bottomBorderPane != null && this.bottomBorderPane.isVisible()) {
            i.bottom += this.bottomBorderPane.getHeight();
        }
        if (this.rightBorderPane != null && this.rightBorderPane.isVisible()) {
            i.right += this.rightBorderPane.getWidth();
        }
        return i;
    }

    public DockableState[] getDockables() {
        return this.context.getDockables();
    }

    public void installDockableDragSources(DockableDragSource[] sources) {
        if (sources != null) {
            for (int i = 0; i < sources.length; ++i) {
                this.installDockableDragSource(sources[i]);
            }
        }
    }

    public void uninstallDockableDragSources(DockableDragSource[] sources) {
        if (sources != null) {
            for (int i = 0; i < sources.length; ++i) {
                this.uninstallDockableDragSource(sources[i]);
            }
        }
    }

    public void installDockableDragSource(DockableDragSource source) {
        ((Component)((Object)source)).addMouseListener(this.dragControler);
        ((Component)((Object)source)).addMouseMotionListener(this.dragControler);
    }

    public void uninstallDockableDragSource(DockableDragSource source) {
        ((Component)((Object)source)).removeMouseListener(this.dragControler);
        ((Component)((Object)source)).removeMouseMotionListener(this.dragControler);
    }

    public void resetToPreferredSize() {
        this.dockingPanel.resetToPreferredSize();
    }

    public void writeXML(OutputStream stream) throws IOException {
        this.context.writeXML(stream);
    }

    void writeDesktopNode(PrintWriter out) throws IOException {
        Dockable max;
        out.println("<DockingDesktop name=\"" + this.desktopName + "\">");
        out.println("<DockingPanel>");
        if (this.dockingPanel.getComponentCount() > 0) {
            this.xmlWriteComponent(this.dockingPanel.getComponent(0), out);
        }
        if ((max = this.getMaximizedDockable()) != null) {
            out.println("<MaximizedDockable>");
            DockKey key = max.getDockKey();
            out.println("<Key dockName=\"" + key.getKey() + "\"/>");
            out.println("</MaximizedDockable>");
        }
        out.println("</DockingPanel>");
        for (int i = 0; i < this.borderPanes.length; ++i) {
            this.xmlWriteBorder(this.borderPanes[i], out);
        }
        this.xmlWriteFloating(out);
        this.xmlWriteTabGroups(out);
        out.println("</DockingDesktop>");
    }

    private void xmlWriteBorder(AutoHideButtonPanel borderPanel, PrintWriter out) throws IOException {
        if (borderPanel.isVisible()) {
            out.println("<Border zone=\"" + borderPanel.getBorderZone() + "\">");
            Component[] comps = borderPanel.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof AutoHideButton)) continue;
                this.xmlWriteBorderDockable((AutoHideButton)comps[i], out);
            }
            out.println("</Border>");
        }
    }

    private void xmlWriteFloating(PrintWriter out) throws IOException {
        ArrayList<Dockable> processedDockables = new ArrayList<Dockable>();
        Window desktopWindow = SwingUtilities.getWindowAncestor(this);
        Point windowLocation = desktopWindow != null ? desktopWindow.getLocation() : new Point();
        ArrayList<Dockable> floatingDockables = this.context.getDockablesByState(this, DockableState.Location.FLOATING);
        for (int i = 0; i < floatingDockables.size(); ++i) {
            Dockable d = floatingDockables.get(i);
            if (processedDockables.contains(d)) continue;
            Window w = SwingUtilities.getWindowAncestor(d.getComponent());
            Rectangle r = w.getBounds();
            out.println("<Floating x=\"" + (r.x - windowLocation.x) + "\" y=\"" + (r.y - windowLocation.y) + "\" width=\"" + r.width + "\" height=\"" + r.height + "\">");
            TabbedDockableContainer tabContainer = DockingUtilities.findTabbedDockableContainer(d);
            if (tabContainer != null) {
                for (int t = 0; t < tabContainer.getTabCount(); ++t) {
                    Dockable tabDockable = tabContainer.getDockableAt(t);
                    processedDockables.add(tabDockable);
                    this.xmlWriteFloatingDockable(tabDockable, out);
                }
            } else {
                processedDockables.add(d);
                this.xmlWriteFloatingDockable(d, out);
            }
            out.println("</Floating>");
        }
    }

    private void xmlWriteComponent(Component comp, PrintWriter out) throws IOException {
        if (comp instanceof SplitContainer) {
            this.xmlWriteSplit((SplitContainer)comp, out);
        } else if (comp instanceof TabbedDockableContainer) {
            this.xmlWriteTab((TabbedDockableContainer)((Object)comp), out);
        } else if (comp instanceof SingleDockableContainer) {
            Dockable d = ((SingleDockableContainer)((Object)comp)).getDockable();
            this.xmlWriteDockable(d, out);
        } else if (comp == this.dummyMaximedReplacer) {
            SingleDockableContainer maxContainer = (SingleDockableContainer)((Object)this.maximizedComponent);
            Dockable d = maxContainer.getDockable();
            this.xmlWriteDockable(d, out);
        }
    }

    private void xmlWriteTab(TabbedDockableContainer tpane, PrintWriter out) throws IOException {
        out.println("<TabbedDockable>");
        for (int i = 0; i < tpane.getTabCount(); ++i) {
            Dockable d = tpane.getDockableAt(i);
            if (d == null) {
                SingleDockableContainer maxContainer = (SingleDockableContainer)((Object)this.maximizedComponent);
                d = maxContainer.getDockable();
                this.xmlWriteDockable(d, out);
                continue;
            }
            this.xmlWriteDockable(d, out);
        }
        out.println("</TabbedDockable>");
    }

    private void xmlWriteDockable(Dockable dockable, PrintWriter out) throws IOException {
        CompoundDockable d;
        CompoundDockingPanel cdp;
        boolean isCompound = dockable instanceof CompoundDockable;
        if (isCompound) {
            out.println("<Dockable compound=\"true\">");
        } else {
            out.println("<Dockable>");
        }
        DockKey key = dockable.getDockKey();
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        if (isCompound && (cdp = (CompoundDockingPanel)(d = (CompoundDockable)dockable).getComponent()).getComponentCount() > 0) {
            Component child = cdp.getComponent(0);
            this.xmlWriteComponent(child, out);
        }
        out.println("</Dockable>");
    }

    private void xmlWriteCompoundDockable(CompoundDockable dockable, PrintWriter out) throws IOException {
        out.println("<Dockable compound=\"true\">");
        DockKey key = dockable.getDockKey();
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        CompoundDockingPanel cdp = (CompoundDockingPanel)dockable.getComponent();
        if (cdp.getComponentCount() > 0) {
            Component child = cdp.getComponent(0);
            this.xmlWriteComponent(child, out);
        }
        out.println("</Dockable>");
    }

    private void xmlWriteBorderDockable(AutoHideButton btn, PrintWriter out) throws IOException {
        if (btn.isVisible()) {
            Dockable dockable = btn.getDockable();
            this.xmlWriteDockableWithRelativePosition(dockable, out);
        }
    }

    private void xmlWriteDockableWithRelativePosition(Dockable dockable, PrintWriter out) throws IOException {
        CompoundDockable d;
        CompoundDockingPanel cdp;
        DockableState state = this.context.getDockableState(dockable);
        RelativeDockablePosition position = state.getPosition();
        boolean isCompound = dockable instanceof CompoundDockable;
        if (isCompound) {
            out.println("<Dockable compound=\"true\">");
        } else {
            out.println("<Dockable>");
        }
        DockKey key = dockable.getDockKey();
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("<RelativePosition x=\"" + position.getX() + "\" y=\"" + position.getY() + "\" w=\"" + position.getWidth() + "\" h=\"" + position.getHeight() + "\" />");
        if (isCompound && (cdp = (CompoundDockingPanel)(d = (CompoundDockable)dockable).getComponent()).getComponentCount() > 0) {
            Component child = cdp.getComponent(0);
            this.xmlWriteComponent(child, out);
        }
        out.println("</Dockable>");
    }

    private void xmlWriteCompoundDockableWithRelativePosition(CompoundDockable dockable, PrintWriter out) {
        DockableState state = this.context.getDockableState(dockable);
        RelativeDockablePosition position = state.getPosition();
        DockKey key = dockable.getDockKey();
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("<RelativePosition x=\"" + position.getX() + "\" y=\"" + position.getY() + "\" w=\"" + position.getWidth() + "\" h=\"" + position.getHeight() + "\" />");
        out.println("</Dockable>");
    }

    private void xmlWriteFloatingDockable(Dockable dockable, PrintWriter out) throws IOException {
        CompoundDockable d;
        CompoundDockingPanel cdp;
        DockableState state = this.context.getDockableState(dockable);
        RelativeDockablePosition position = state.getPosition();
        boolean isCompound = dockable instanceof CompoundDockable;
        if (isCompound) {
            out.println("<Dockable compound=\"true\">");
        } else {
            out.println("<Dockable>");
        }
        DockKey key = dockable.getDockKey();
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("<RelativePosition x=\"" + position.getX() + "\" y=\"" + position.getY() + "\" w=\"" + position.getWidth() + "\" h=\"" + position.getHeight() + "\" />");
        DockableState prev = this.previousFloatingDockableStates.get(dockable);
        out.println("<PreviousState state=\"" + prev.getLocation().ordinal() + "\"/>");
        if (isCompound && (cdp = (CompoundDockingPanel)(d = (CompoundDockable)dockable).getComponent()).getComponentCount() > 0) {
            Component child = cdp.getComponent(0);
            this.xmlWriteComponent(child, out);
        }
        out.println("</Dockable>");
    }

    private void xmlWriteSplit(SplitContainer split, PrintWriter out) throws IOException {
        double location = split.getOrientation() == 1 ? (double)split.getLeftComponent().getWidth() / (double)(split.getWidth() - split.getDividerSize()) : (double)split.getTopComponent().getHeight() / (double)(split.getHeight() - split.getDividerSize());
        out.println("<Split orientation=\"" + split.getOrientation() + "\" location=\"" + location + "\">");
        this.xmlWriteComponent(split.getLeftComponent(), out);
        this.xmlWriteComponent(split.getRightComponent(), out);
        out.println("</Split>");
    }

    private void xmlWriteTabGroups(PrintWriter out) throws IOException {
        ArrayList<LinkedList<Dockable>> uniqueGroups = new ArrayList<LinkedList<Dockable>>();
        ArrayList<Dockable> processedDockables = new ArrayList<Dockable>();
        for (Dockable d : this.tabbedGroups.keySet()) {
            if (processedDockables.contains(d)) continue;
            processedDockables.add(d);
            LinkedList<Dockable> tabList = this.tabbedGroups.get(d);
            for (Dockable d2 : tabList) {
                if (processedDockables.contains(d2)) continue;
                processedDockables.add(d2);
            }
            uniqueGroups.add(tabList);
        }
        out.println("<TabGroups>");
        for (int i = 0; i < uniqueGroups.size(); ++i) {
            out.println("<TabGroup>");
            LinkedList group = (LinkedList)uniqueGroups.get(i);
            for (Dockable d : group) {
                this.xmlWriteDockableTab(d, out);
            }
            out.println("</TabGroup>");
        }
        out.println("</TabGroups>");
    }

    private void xmlWriteDockableTab(Dockable dockable, PrintWriter out) throws IOException {
        out.println("<Dockable>");
        DockKey key = dockable.getDockKey();
        out.println("<Key dockName=\"" + key.getKey() + "\"/>");
        out.println("</Dockable>");
    }

    public void readXML(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        this.context.readXML(in);
    }

    public void clear() {
        this.dockingPanel.removeAll();
        for (int i = 0; i < this.borderPanes.length; ++i) {
            this.borderPanes[i].removeAll();
            this.borderPanes[i].setVisible(false);
        }
        boolean wasHeavyMaximized = false;
        if (this.maximizedComponent != null) {
            if (DockingPreferences.isLightWeightUsageEnabled()) {
                this.remove(this.maximizedComponent);
            } else {
                this.remove(this.maximizedComponent.getParent());
                wasHeavyMaximized = true;
            }
            this.maximizedComponent = null;
        }
        this.autoHideButtons.clear();
        this.expandPanel.collapse();
        this.expandPanel.clear();
        this.previousFloatingDockableStates.clear();
        this.tabbedGroups.clear();
        ArrayList<Dockable> floatingDockables = this.context.getDockablesByState(this, DockableState.Location.FLOATING);
        for (int i = 0; i < floatingDockables.size(); ++i) {
            Dockable d = floatingDockables.get(i);
            this.remove(d);
        }
    }

    void readDesktopNode(Element desktopElement) throws SAXException {
        NodeList children = desktopElement.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            this.xmlBuildRootNode(child);
        }
        DockingUtilities.updateResizeWeights(this.dockingPanel);
        this.revalidate();
    }

    private void xmlBuildRootNode(Node node) throws SAXException {
        if (node.getNodeType() == 1) {
            Element elt = (Element)node;
            String name = elt.getNodeName();
            if (name.equals("DockingPanel")) {
                NodeList children = elt.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.xmlBuildDockingPanelNode(elt.getChildNodes().item(i));
                }
            } else if (name.equals("Border")) {
                int zone = Integer.parseInt(elt.getAttribute("zone"));
                AutoHideButtonPanel borderPanel = this.borderPanes[zone];
                borderPanel.setVisible(true);
                NodeList children = elt.getElementsByTagName("Dockable");
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.xmlBuildAutoHideNode(borderPanel, (Element)children.item(i));
                }
                borderPanel.revalidate();
            } else if (name.equals("Floating")) {
                int x = Integer.parseInt(elt.getAttribute("x"));
                int y = Integer.parseInt(elt.getAttribute("y"));
                int width = Integer.parseInt(elt.getAttribute("width"));
                int height = Integer.parseInt(elt.getAttribute("height"));
                NodeList children = elt.getElementsByTagName("Dockable");
                this.xmlBuildFloatingNode(children, new Rectangle(x, y, width, height));
            } else if (name.equals("TabGroups")) {
                NodeList children = elt.getElementsByTagName("TabGroup");
                this.xmlBuildTabGroup(children);
            } else {
                throw new SAXNotRecognizedException(name);
            }
        }
    }

    private void xmlBuildAutoHideNode(AutoHideButtonPanel borderPanel, Element dockableElt) throws SAXException {
        Element hideElt = (Element)dockableElt.getElementsByTagName("RelativePosition").item(0);
        float x = Float.parseFloat(hideElt.getAttribute("x"));
        float y = Float.parseFloat(hideElt.getAttribute("y"));
        float w = Float.parseFloat(hideElt.getAttribute("w"));
        float h = Float.parseFloat(hideElt.getAttribute("h"));
        RelativeDockablePosition position = new RelativeDockablePosition(x, y, w, h);
        AutoHideButton btn = new AutoHideButton();
        Dockable dockable = this.xmlGetDockable(dockableElt);
        this.autoHideButtons.put(dockable.getDockKey(), btn);
        this.context.setDockableState(dockable, new DockableState(this, dockable, DockableState.Location.HIDDEN, position));
        dockable.getDockKey().setLocation(DockableState.Location.HIDDEN);
        btn.init(dockable, borderPanel.getBorderZone());
        borderPanel.add(btn);
        if (dockable instanceof CompoundDockable) {
            this.xmlBuildCompoundDockable((CompoundDockable)dockable, dockableElt, DockableState.Location.HIDDEN);
        }
    }

    private void xmlBuildFloatingNode(NodeList dockables, Rectangle bounds) throws SAXException {
        Window desktopWindow = SwingUtilities.getWindowAncestor(this);
        if (desktopWindow != null) {
            Point windowLocation = desktopWindow.getLocation();
            bounds.x += windowLocation.x;
            bounds.y += windowLocation.y;
        }
        FloatingDockableContainer fdc = null;
        TabbedDockableContainer tdc = null;
        if (dockables.getLength() > 1) {
            tdc = DockableContainerFactory.getFactory().createTabbedDockableContainer();
            tdc.installDocking(this);
            ((JTabbedPane)((Object)tdc)).addChangeListener(this.focusHandler);
        }
        Dockable baseDockable = null;
        for (int i = 0; i < dockables.getLength(); ++i) {
            Element dockableElt = (Element)dockables.item(i);
            Element hideElt = (Element)dockableElt.getElementsByTagName("RelativePosition").item(0);
            float x = Float.parseFloat(hideElt.getAttribute("x"));
            float y = Float.parseFloat(hideElt.getAttribute("y"));
            float w = Float.parseFloat(hideElt.getAttribute("w"));
            float h = Float.parseFloat(hideElt.getAttribute("h"));
            RelativeDockablePosition position = new RelativeDockablePosition(this.dockingPanel, x, y, w, h);
            Dockable dockable = this.xmlGetDockable(dockableElt);
            if (i == 0) {
                baseDockable = dockable;
            }
            Element previousState = (Element)dockableElt.getElementsByTagName("PreviousState").item(0);
            int istate = Integer.parseInt(previousState.getAttribute("state"));
            DockableState state = new DockableState(this, dockable, DockableState.getLocationFromInt(istate), position);
            this.storePreviousFloatingState(dockable, state);
            if (fdc == null) {
                fdc = this.createFloatingDockableContainer(dockable);
            } else {
                if (tdc.getTabCount() == 0) {
                    DockableContainer base = DockingUtilities.findDockableContainer(baseDockable);
                    DockingUtilities.replaceChild(((Component)((Object)base)).getParent(), (Component)((Object)base), (Component)((Object)tdc));
                    tdc.addDockable(baseDockable, 0);
                }
                tdc.addDockable(dockable, tdc.getTabCount());
            }
            this.context.setDockableState(dockable, new DockableState(this, dockable, DockableState.Location.FLOATING, position));
            dockable.getDockKey().setLocation(DockableState.Location.FLOATING);
            if (!(dockable instanceof CompoundDockable)) continue;
            this.xmlBuildCompoundDockable((CompoundDockable)dockable, dockableElt, DockableState.Location.FLOATING);
        }
        DockingUtilities.setBounds(fdc, bounds);
        DockingUtilities.validate(fdc);
        DockingUtilities.setVisible(fdc, true);
    }

    private void xmlBuildDockingPanelNode(Node node) throws SAXException {
        Component comp;
        if (node.getNodeType() == 1 && (comp = this.xmlCreateComponent((Element)node, DockableState.Location.DOCKED)) != null) {
            this.dockingPanel.add(comp, "Center");
        }
    }

    private Component xmlCreateComponent(Element elt, DockableState.Location dockableLocation) throws SAXException {
        if (elt.getNodeName().equals("Split")) {
            SplitContainer split = this.xmlBuildSplitContainer(elt, dockableLocation);
            return split;
        }
        if (elt.getNodeName().equals("Dockable")) {
            Dockable d = this.xmlGetDockable(elt);
            SingleDockableContainer sdc = DockableContainerFactory.getFactory().createDockableContainer(d, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
            this.context.setDockableState(d, new DockableState(this, d, dockableLocation));
            d.getDockKey().setLocation(dockableLocation);
            sdc.installDocking(this);
            if (d instanceof CompoundDockable) {
                this.xmlBuildCompoundDockable((CompoundDockable)d, elt, dockableLocation);
            }
            return (Component)((Object)sdc);
        }
        if (elt.getNodeName().equals("TabbedDockable")) {
            TabbedDockableContainer tdc = this.xmlBuildTabbedDockableContainer(elt, dockableLocation);
            return (Component)((Object)tdc);
        }
        if (elt.getNodeName().equals("MaximizedDockable")) {
            Dockable d = this.xmlGetDockable(elt);
            this.maximize(d);
            return null;
        }
        throw new SAXNotRecognizedException(elt.getNodeName());
    }

    private void xmlBuildCompoundDockable(CompoundDockable dockable, Element compoundElt, DockableState.Location dockableLocation) throws SAXException {
        CompoundDockingPanel compoundPanel = (CompoundDockingPanel)dockable.getComponent();
        compoundPanel.removeAll();
        NodeList children = compoundElt.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Element elt;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || (elt = (Element)node).getNodeName().equals("Key")) continue;
            Component comp = this.xmlCreateComponent(elt, dockableLocation);
            compoundPanel.add(comp, "Center");
            return;
        }
    }

    private SplitContainer xmlBuildSplitContainer(Node node, DockableState.Location dockableLocation) throws SAXException {
        Element elt = (Element)node;
        int orientation = Integer.parseInt(elt.getAttribute("orientation"));
        String loc = elt.getAttribute("location");
        double location = 0.5;
        if (loc != null && !loc.equals("")) {
            location = Double.parseDouble(loc);
        }
        SplitContainer split = new SplitContainer(orientation);
        split.setDividerLocation(location);
        boolean left = true;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (child.getNodeType() != 1) continue;
            Component comp = this.xmlCreateComponent((Element)child, dockableLocation);
            if (left) {
                split.setLeftComponent(comp);
                left = false;
                continue;
            }
            split.setRightComponent(comp);
        }
        return split;
    }

    private TabbedDockableContainer xmlBuildTabbedDockableContainer(Element elt, DockableState.Location dockableLocation) throws SAXException {
        TabbedDockableContainer tdc = DockableContainerFactory.getFactory().createTabbedDockableContainer();
        tdc.installDocking(this);
        ((JTabbedPane)((Object)tdc)).addChangeListener(this.focusHandler);
        Dockable base = null;
        for (int i = 0; i < elt.getChildNodes().getLength(); ++i) {
            Node child = elt.getChildNodes().item(i);
            if (child.getNodeType() != 1) continue;
            Dockable d = this.xmlGetDockable((Element)child);
            if (base == null) {
                base = d;
            }
            this.context.setDockableState(d, new DockableState(this, d, dockableLocation));
            d.getDockKey().setLocation(dockableLocation);
            tdc.addDockable(d, tdc.getTabCount());
            if (base != d) {
                this.addToTabbedGroup(base, d);
            }
            if (!(d instanceof CompoundDockable)) continue;
            this.xmlBuildCompoundDockable((CompoundDockable)d, (Element)child, dockableLocation);
        }
        return tdc;
    }

    private Dockable xmlGetDockable(Element dockableElt) {
        Element key = (Element)dockableElt.getElementsByTagName("Key").item(0);
        String name = key.getAttribute("dockName");
        Dockable dockable = this.context.getDockableByKey(name);
        if (dockable == null) {
            throw new NullPointerException("Dockable " + name + " not registered");
        }
        return dockable;
    }

    private void xmlBuildTabGroup(NodeList group) {
        for (int i = 0; i < group.getLength(); ++i) {
            Element groupElt = (Element)group.item(i);
            NodeList dockables = groupElt.getElementsByTagName("Dockable");
            Dockable base = null;
            for (int j = 0; j < dockables.getLength(); ++j) {
                Element dockableElt = (Element)dockables.item(j);
                Dockable d = this.xmlGetDockable(dockableElt);
                if (j == 0) {
                    base = d;
                    continue;
                }
                this.addToTabbedGroup(base, d);
            }
        }
    }

    public void addDockable(Dockable dockable) {
        this.addDockable(dockable, new RelativeDockablePosition(0.0, 0.8, 0.5, 0.2));
    }

    public void addDockable(Dockable dockable, RelativeDockablePosition position) {
        if (this.isAncestorOf(dockable.getComponent())) {
            throw new IllegalArgumentException("Dockable is already contained in the desktop");
        }
        this.registerDockable(dockable);
        if (DockingUtilities.findSingleDockableContainer(dockable) != null) {
            this.remove(dockable);
        }
        DockableState newState = new DockableState(this, dockable, DockableState.Location.DOCKED, position);
        DockableState currentState = this.getDockableState(dockable);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        DockableStateWillChangeEvent dswe = new DockableStateWillChangeEvent(currentState, newState);
        DockingActionAddDockableEvent dae = new DockingActionAddDockableEvent(this, dockable, currentLocation, newState.getLocation(), this.dockingPanel);
        if (this.isDockingActionAccepted(dae, dswe)) {
            SingleDockableContainer sdc = RelativeDockingUtilities.insertDockable(this.dockingPanel, dockable, position);
            sdc.installDocking(this);
            this.context.setDockableState(dockable, newState);
            dockable.getDockKey().setLocation(DockableState.Location.DOCKED);
            DockableStateChangeEvent dse = new DockableStateChangeEvent(currentState, newState);
            this.fireDockingAction(dae, dse);
            DockingUtilities.updateResizeWeights(this.dockingPanel);
        }
    }

    public void replace(Dockable base, Dockable replacer) {
        DockableState baseState = this.context.getDockableState(base);
        DockableState replacerState = this.context.getDockableState(replacer);
        DockableState newBaseState = new DockableState(replacerState.getDesktop(), base, replacerState.getLocation());
        DockableState newReplacerState = new DockableState(baseState.getDesktop(), replacer, baseState.getLocation());
        TabbedDockableContainer tdcBase = DockingUtilities.findTabbedDockableContainer(base);
        if (!replacerState.isClosed()) {
            throw new IllegalArgumentException("replacer isn't closed");
        }
        if (base instanceof CompoundDockable) {
            throw new IllegalArgumentException("base cannot be a compound dockable");
        }
        if (tdcBase != null) {
            int iBase = tdcBase.indexOfDockable(base);
            tdcBase.removeDockable(base);
            tdcBase.addDockable(replacer, iBase);
        } else {
            SingleDockableContainer sdcBase = DockingUtilities.findSingleDockableContainer(base);
            Container sdcBaseParent = ((Component)((Object)sdcBase)).getParent();
            if (sdcBaseParent instanceof SplitContainer) {
                SplitContainer split = (SplitContainer)sdcBaseParent;
                boolean isLeft = split.getLeftComponent() == sdcBase;
                SingleDockableContainer sdc = DockableContainerFactory.getFactory().createDockableContainer(replacer, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
                sdc.installDocking(this);
                if (isLeft) {
                    split.setLeftComponent((Component)((Object)sdc));
                } else {
                    split.setRightComponent((Component)((Object)sdc));
                }
                split.revalidate();
            } else if (sdcBaseParent instanceof DockingPanel) {
                DockingPanel dp = (DockingPanel)sdcBaseParent;
                dp.remove(0);
                SingleDockableContainer sdc = DockableContainerFactory.getFactory().createDockableContainer(replacer, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
                sdc.installDocking(this);
                dp.add((Component)((Object)sdc), "Center");
                dp.revalidate();
            } else if (sdcBaseParent instanceof CompoundDockingPanel) {
                CompoundDockingPanel cdp = (CompoundDockingPanel)sdcBaseParent;
                cdp.remove(0);
                SingleDockableContainer sdc = DockableContainerFactory.getFactory().createDockableContainer(replacer, DockableContainerFactory.ParentType.PARENT_SPLIT_CONTAINER);
                sdc.installDocking(this);
                cdp.add((Component)((Object)sdc), "Center");
                cdp.revalidate();
            } else {
                throw new RuntimeException("Wrong container hierarchy : " + sdcBaseParent);
            }
        }
        this.context.setDockableState(base, newBaseState);
        this.context.setDockableState(replacer, newReplacerState);
    }

    private static DockableState.Location getLocation(DockableState state) {
        if (state == null) {
            return DockableState.Location.CLOSED;
        }
        return state.getLocation();
    }

    public void addDockable(CompoundDockable base, Dockable dockable) {
        this.registerDockable(dockable);
        DockableState currentState = this.getDockableState(dockable);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        DockableState newState = new DockableState(this, dockable, DockableState.Location.DOCKED);
        DockableStateWillChangeEvent dswe = new DockableStateWillChangeEvent(currentState, newState);
        CompoundDockingPanel panel = (CompoundDockingPanel)base.getComponent();
        DockingActionAddDockableEvent dae = new DockingActionAddDockableEvent(this, dockable, currentLocation, newState.getLocation(), panel);
        if (this.isDockingActionAccepted(dae, dswe)) {
            SingleDockableContainer dockableContainer = DockableContainerFactory.getFactory().createDockableContainer(dockable, DockableContainerFactory.ParentType.PARENT_DESKTOP);
            dockableContainer.installDocking(this);
            panel.add((Component)((JComponent)((Object)dockableContainer)), "Center");
            this.context.setDockableState(dockable, newState);
            dockable.getDockKey().setLocation(DockableState.Location.DOCKED);
            this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets i = this.getDockingPanelInsets();
        Dimension dim = this.dockingPanel.getPreferredSize();
        dim.width += i.left + i.right;
        dim.height += i.top + i.bottom;
        return dim;
    }

    public void addDockableStateChangeListener(DockableStateChangeListener listener) {
        this.context.addDockableStateChangeListener(listener);
    }

    public void removeDockableStateChangeListener(DockableStateChangeListener listener) {
        this.context.removeDockableStateChangeListener(listener);
    }

    public void addDockableStateWillChangeListener(DockableStateWillChangeListener listener) {
        this.context.addDockableStateWillChangeListener(listener);
    }

    public void removeDockableStateWillChangeListener(DockableStateWillChangeListener listener) {
        this.context.removeDockableStateWillChangeListener(listener);
    }

    public void addDockingActionListener(DockingActionListener listener) {
        this.context.addDockingActionListener(listener);
    }

    public void removeDockingActionListener(DockingActionListener listener) {
        this.context.removeDockingActionListener(listener);
    }

    public void addDockableSelectionListener(DockableSelectionListener listener) {
        this.context.addDockableSelectionListener(listener);
    }

    public void removeDockableSelectionListener(DockableSelectionListener listener) {
        this.context.removeDockableSelectionListener(listener);
    }

    public void addHiddenDockable(Dockable dockable, RelativeDockablePosition dockedPosition) {
        DockableState currentState = this.getDockableState(dockable);
        if (currentState != null && !currentState.isClosed()) {
            if (currentState.isHidden()) {
                return;
            }
            if (currentState.isDocked()) {
                this.setAutoHide(dockable, true);
                return;
            }
        }
        this.registerDockable(dockable);
        currentState = this.getDockableState(dockable);
        DockableState.Location currentLocation = DockingDesktop.getLocation(currentState);
        DockableState newState = new DockableState(this, dockable, DockableState.Location.HIDDEN, dockedPosition);
        DockableStateWillChangeEvent dswe = new DockableStateWillChangeEvent(currentState, newState);
        DockingActionSimpleStateChangeEvent dae = new DockingActionSimpleStateChangeEvent(this, dockable, currentLocation, DockableState.Location.HIDDEN);
        DockKey k = dockable.getDockKey();
        if (currentLocation != DockableState.Location.HIDDEN && this.isDockingActionAccepted(dae, dswe)) {
            AutoHideButton btn = this.autoHideButtons.get(k);
            if (btn == null) {
                btn = new AutoHideButton();
                this.autoHideButtons.put(k, btn);
                int zone = k.getAutoHideBorder() == null ? AutoHidePolicy.getPolicy().getDefaultHideBorder().value() : k.getAutoHideBorder().value();
                btn.init(dockable, zone);
                this.borderPanes[zone].setVisible(true);
                this.borderPanes[zone].add(btn);
                this.borderPanes[zone].revalidate();
            } else {
                int zone = btn.getZone();
                this.borderPanes[zone].setVisible(true);
                btn.setVisible(true);
                this.borderPanes[zone].revalidate();
            }
            this.context.setDockableState(dockable, newState);
            dockable.getDockKey().setLocation(DockableState.Location.HIDDEN);
            this.fireDockingAction(dae, new DockableStateChangeEvent(currentState, newState));
            this.revalidate();
        }
    }

    public void setDockableWidth(Dockable dockable, double width) {
        SplitContainer split = DockingUtilities.getSplitPane(dockable, 1);
        if (split == null) {
            return;
        }
        if (((Container)split.getLeftComponent()).isAncestorOf(dockable.getComponent())) {
            split.setDividerLocation(width);
        } else {
            split.setDividerLocation(1.0 - width);
        }
    }

    public void setDockableHeight(Dockable dockable, double height) {
        SplitContainer split = DockingUtilities.getSplitPane(dockable, 0);
        if (split == null) {
            return;
        }
        if (((Container)split.getTopComponent()).isAncestorOf(dockable.getComponent())) {
            split.setDividerLocation(height);
        } else {
            split.setDividerLocation(1.0 - height);
        }
    }

    public void setAutoResizableDockable(Dockable dockable) {
        DockingUtilities.updateResizeWeights(this.dockingPanel);
    }

    public void addToTabbedGroup(Dockable base, Dockable newTab) {
        LinkedList<Dockable> group = this.tabbedGroups.get(base);
        if (group == null) {
            group = new LinkedList();
            group.add(base);
            this.tabbedGroups.put(base, group);
        }
        if (!group.contains(newTab)) {
            group.add(newTab);
            this.tabbedGroups.put(newTab, group);
        }
    }

    public void removeFromTabbedGroup(Dockable dockable) {
        LinkedList<Dockable> group = this.tabbedGroups.get(dockable);
        if (group != null) {
            this.tabbedGroups.remove(dockable);
            group.remove(dockable);
            if (group.size() == 1) {
                Dockable d = group.removeFirst();
                this.tabbedGroups.remove(d);
            }
        }
    }

    protected AutoHideExpandPanel createAutoHideExpandPanel() {
        return new AutoHideExpandPanel();
    }

    public String getDesktopName() {
        return this.desktopName;
    }

    public void setDesktopName(String desktopName) {
        this.desktopName = desktopName;
    }

    public DockingContext getContext() {
        return this.context;
    }

    public void setContext(DockingContext context) {
        this.context = context;
    }

    public Dockable getMaximizedDockable() {
        if (this.maximizedComponent == null) {
            return null;
        }
        SingleDockableContainer maxContainer = (SingleDockableContainer)((Object)this.maximizedComponent);
        return maxContainer.getDockable();
    }

    private boolean isDockingActionAccepted(DockingActionEvent dae, DockableStateWillChangeEvent dse) {
        boolean accepted = this.context.fireAcceptDockingAction(dae);
        if (accepted) {
            if (dse != null && dae.getInitialLocation() != dae.getNextLocation()) {
                return this.context.fireDockableStateWillChange(dse);
            }
            return true;
        }
        return false;
    }

    private void fireDockingAction(DockingActionEvent dae, DockableStateChangeEvent dse) {
        this.context.fireDockingActionPerformed(dae);
        if (dse != null && dae.getInitialLocation() != dae.getNextLocation()) {
            this.context.fireDockableStateChange(dse);
        }
    }

    static {
        DockingUISettings.getInstance().installUI();
    }

    private class FocusHandler
    implements PropertyChangeListener,
    ChangeListener {
        Dockable lastFocusedDockable;
        Dockable currentDockable;

        private FocusHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Component c;
            for (c = (Component)e.getNewValue(); c != null && !(c instanceof SingleDockableContainer); c = c.getParent()) {
            }
            if (c instanceof SingleDockableContainer) {
                SingleDockableContainer sdc = (SingleDockableContainer)((Object)c);
                this.currentDockable = sdc.getDockable();
                if (sdc.getDockable() != this.lastFocusedDockable) {
                    DockingDesktop.this.context.fireDockableSelectionChange(new DockableSelectionEvent(sdc.getDockable()));
                }
                this.lastFocusedDockable = sdc.getDockable();
            } else {
                this.currentDockable = null;
            }
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            JTabbedPane pane = (JTabbedPane)evt.getSource();
            TabbedDockableContainer tdc = (TabbedDockableContainer)((Object)pane);
            Dockable selDockable = tdc.getSelectedDockable();
            if (selDockable != null) {
                this.currentDockable = selDockable;
                if (selDockable != this.lastFocusedDockable) {
                    this.lastFocusedDockable = selDockable;
                    DockingDesktop.this.context.fireDockableSelectionChange(new DockableSelectionEvent(selDockable));
                }
            }
        }

        Dockable getCurrentDockable() {
            return this.currentDockable;
        }
    }
}

