# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementDisksOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.disks.begin_create_or_update(
                resource_group_name=resource_group.name,
                disk_name="str",
                disk={
                    "location": "str",
                    "accountType": "str",
                    "creationData": {
                        "createOption": "str",
                        "imageReference": {"id": "str", "lun": 0},
                        "sourceResourceId": "str",
                        "sourceUri": "str",
                        "storageAccountId": "str",
                    },
                    "diskSizeGB": 0,
                    "encryptionSettings": {
                        "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                        "enabled": bool,
                        "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                    },
                    "id": "str",
                    "name": "str",
                    "osType": "str",
                    "ownerId": "str",
                    "provisioningState": "str",
                    "tags": {"str": "str"},
                    "timeCreated": "2020-02-20 00:00:00",
                    "type": "str",
                },
                api_version="2016-04-30-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.disks.begin_update(
                resource_group_name=resource_group.name,
                disk_name="str",
                disk={
                    "accountType": "str",
                    "creationData": {
                        "createOption": "str",
                        "imageReference": {"id": "str", "lun": 0},
                        "sourceResourceId": "str",
                        "sourceUri": "str",
                        "storageAccountId": "str",
                    },
                    "diskSizeGB": 0,
                    "encryptionSettings": {
                        "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                        "enabled": bool,
                        "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                    },
                    "osType": "str",
                    "tags": {"str": "str"},
                },
                api_version="2016-04-30-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.disks.get(
            resource_group_name=resource_group.name,
            disk_name="str",
            api_version="2016-04-30-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.disks.begin_delete(
                resource_group_name=resource_group.name,
                disk_name="str",
                api_version="2016-04-30-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.disks.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2016-04-30-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.disks.list(
            api_version="2016-04-30-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_grant_access(self, resource_group):
        response = await (
            await self.client.disks.begin_grant_access(
                resource_group_name=resource_group.name,
                disk_name="str",
                grant_access_data={"access": "str", "durationInSeconds": 0},
                api_version="2016-04-30-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_revoke_access(self, resource_group):
        response = await (
            await self.client.disks.begin_revoke_access(
                resource_group_name=resource_group.name,
                disk_name="str",
                api_version="2016-04-30-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
