// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef MODELINFO_H
#define MODELINFO_H

#include "global_header.h"

#include <QString>
#include <QSharedPointer>

GLOBAL_BEGIN_NAMESPACE

class ModelInfo
{
public:
    explicit ModelInfo(const QString &path);
    QString name() const;
    QString path() const ;
    QStringList formats() const;
    QStringList architectures(const QString &format) const;
    QString imagePath(const QString &format) const;
    QString chatTemplate(const QString &format) const;
private:
    QString rootPath;
};

using ModelInfoPointer = QSharedPointer<ModelInfo>;

GLOBAL_END_NAMESPACE

#endif // MODELINFO_H
