# C API client for linglong

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project. By using the [OpenAPI spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 
- Generator version: 7.8.0
- Build package: org.openapitools.codegen.languages.CLibcurlClientCodegen
For more information, please visit [https://linglong.dev](https://linglong.dev)

## Installation
You'll need the `curl 7.58.0` package in order to build the API. To have code formatted nicely, you also need to have uncrustify version 0.67 or later.

# Prerequisites

## Install the `curl 7.58.0` package with the following command on Linux.
```bash
sudo apt remove curl
wget http://curl.haxx.se/download/curl-7.58.0.tar.gz
tar -xvf curl-7.58.0.tar.gz
cd curl-7.58.0/
./configure
make
sudo make install
```
## Install the `uncrustify 0.67` package with the following command on Linux.
```bash
git clone https://github.com/uncrustify/uncrustify.git
cd uncrustify
mkdir build
cd build
cmake ..
make
sudo make install
```

## Compile the sample:
This will compile the generated code and create a library in the build folder which has to be linked to the codes where API will be used.
```bash
mkdir build
cd build
// To install library to specific location, use following commands
cmake -DCMAKE_INSTALL_PREFIX=/pathtolocation ..
// for normal install use following command
cmake ..
make
sudo make install
```
## How to use compiled library
Considering the test/source code which uses the API is written in main.c(respective api include is written and all objects necessary are defined and created)

To compile main.c(considering the file is present in build folder) use following command
-L - location of the library(not required if cmake with normal installation is performed)
-l library name
```bash
gcc main.c -L. -llinglong -o main
```
Once compiled, you can run it with ``` ./main ```

Note: You don't need to specify includes for models and include folder separately as they are path linked. You just have to import the api.h file in your code, the include linking will work.

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Category | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ClientAPI* | [**ClientAPI_fuzzySearchApp**](docs/ClientAPI.md#ClientAPI_fuzzySearchApp) | **POST** /api/v0/apps/fuzzysearchapp | 模糊查找App
*ClientAPI* | [**ClientAPI_getRepo**](docs/ClientAPI.md#ClientAPI_getRepo) | **GET** /api/v1/repos/{repo} | 查看仓库信息
*ClientAPI* | [**ClientAPI_newUploadTaskID**](docs/ClientAPI.md#ClientAPI_newUploadTaskID) | **POST** /api/v1/upload-tasks | generate a new upload task id
*ClientAPI* | [**ClientAPI_signIn**](docs/ClientAPI.md#ClientAPI_signIn) | **POST** /api/v1/sign-in | 登陆帐号
*ClientAPI* | [**ClientAPI_uploadTaskFile**](docs/ClientAPI.md#ClientAPI_uploadTaskFile) | **PUT** /api/v1/upload-tasks/{task_id}/tar | upload tgz file to upload task
*ClientAPI* | [**ClientAPI_uploadTaskInfo**](docs/ClientAPI.md#ClientAPI_uploadTaskInfo) | **GET** /api/v1/upload-tasks/{task_id}/status | get upload task status
*ClientAPI* | [**ClientAPI_uploadTaskLayerFile**](docs/ClientAPI.md#ClientAPI_uploadTaskLayerFile) | **PUT** /api/v1/upload-tasks/{task_id}/layer | upload layer file to upload task


## Documentation for Models

 - [api_json_result_t](docs/api_json_result.md)
 - [api_upload_task_file_resp_t](docs/api_upload_task_file_resp.md)
 - [api_upload_task_layer_file_resp_t](docs/api_upload_task_layer_file_resp.md)
 - [fuzzy_search_app_200_response_t](docs/fuzzy_search_app_200_response.md)
 - [get_repo_200_response_t](docs/get_repo_200_response.md)
 - [new_upload_task_id_200_response_t](docs/new_upload_task_id_200_response.md)
 - [request_auth_t](docs/request_auth.md)
 - [request_fuzzy_search_req_t](docs/request_fuzzy_search_req.md)
 - [request_register_struct_t](docs/request_register_struct.md)
 - [response_new_upload_task_resp_t](docs/response_new_upload_task_resp.md)
 - [response_sign_in_t](docs/response_sign_in.md)
 - [response_upload_task_resp_t](docs/response_upload_task_resp.md)
 - [response_upload_task_status_info_t](docs/response_upload_task_status_info.md)
 - [schema_new_upload_task_req_t](docs/schema_new_upload_task_req.md)
 - [schema_repo_info_t](docs/schema_repo_info.md)
 - [sign_in_200_response_t](docs/sign_in_200_response.md)
 - [upload_task_info_200_response_t](docs/upload_task_info_200_response.md)


## Documentation for Authorization


Authentication schemes defined for the API:
### Token

- **Type**: API key

- **API key parameter name**: X-Token
- **Location**: HTTP header


## Author

wurongjie@deepin.org

