/* propertyaccessor.c generated by valac, the Vala compiler
 * generated from propertyaccessor.vala, do not modify */

/* propertyaccessor.vala
 *
 * Copyright (C) 2008-2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valacodegen.h>

enum  {
	VALADOC_API_PROPERTY_ACCESSOR_0_PROPERTY,
	VALADOC_API_PROPERTY_ACCESSOR_NODE_TYPE_PROPERTY,
	VALADOC_API_PROPERTY_ACCESSOR_IS_CONSTRUCT_PROPERTY,
	VALADOC_API_PROPERTY_ACCESSOR_IS_SET_PROPERTY,
	VALADOC_API_PROPERTY_ACCESSOR_IS_GET_PROPERTY,
	VALADOC_API_PROPERTY_ACCESSOR_IS_OWNED_PROPERTY,
	VALADOC_API_PROPERTY_ACCESSOR_NUM_PROPERTIES
};
static GParamSpec* valadoc_api_property_accessor_properties[VALADOC_API_PROPERTY_ACCESSOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _valadoc_api_signature_builder_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_signature_builder_unref (var), NULL)))

struct _ValadocApiPropertyAccessorPrivate {
	ValadocApiOwnership ownership;
	gchar* cname;
};

static gint ValadocApiPropertyAccessor_private_offset;
static gpointer valadoc_api_property_accessor_parent_class = NULL;

static ValadocApiOwnership valadoc_api_property_accessor_get_property_ownership (ValadocApiPropertyAccessor* self,
                                                                          ValaPropertyAccessor* element);
static void valadoc_api_property_accessor_real_accept (ValadocApiNode* base,
                                                ValadocApiVisitor* visitor);
static ValadocContentInline* valadoc_api_property_accessor_real_build_signature (ValadocApiItem* base);
static void valadoc_api_property_accessor_finalize (GObject * obj);
static GType valadoc_api_property_accessor_get_type_once (void);
static void _vala_valadoc_api_property_accessor_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
valadoc_api_property_accessor_get_instance_private (ValadocApiPropertyAccessor* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocApiPropertyAccessor_private_offset);
}

ValadocApiPropertyAccessor*
valadoc_api_property_accessor_construct (GType object_type,
                                         ValadocApiProperty* parent,
                                         ValadocApiSourceFile* file,
                                         const gchar* name,
                                         ValaSymbolAccessibility accessibility,
                                         ValaPropertyAccessor* data)
{
	ValadocApiPropertyAccessor * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	self = (ValadocApiPropertyAccessor*) valadoc_api_symbol_construct (object_type, (ValadocApiNode*) parent, file, name, accessibility, NULL, (ValaSymbol*) data);
	self->priv->ownership = valadoc_api_property_accessor_get_property_ownership (self, data);
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) data);
	_g_free0 (self->priv->cname);
	self->priv->cname = _tmp0_;
	return self;
}

ValadocApiPropertyAccessor*
valadoc_api_property_accessor_new (ValadocApiProperty* parent,
                                   ValadocApiSourceFile* file,
                                   const gchar* name,
                                   ValaSymbolAccessibility accessibility,
                                   ValaPropertyAccessor* data)
{
	return valadoc_api_property_accessor_construct (VALADOC_API_TYPE_PROPERTY_ACCESSOR, parent, file, name, accessibility, data);
}

static ValadocApiOwnership
valadoc_api_property_accessor_get_property_ownership (ValadocApiPropertyAccessor* self,
                                                      ValaPropertyAccessor* element)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ValadocApiOwnership result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (element != NULL, 0);
	_tmp0_ = vala_property_accessor_get_value_type (element);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_get_value_owned (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = VALADOC_API_OWNERSHIP_OWNED;
		return result;
	}
	result = VALADOC_API_OWNERSHIP_UNOWNED;
	return result;
}

static ValadocApiNodeType
valadoc_api_property_accessor_real_get_node_type (ValadocApiNode* base)
{
	ValadocApiNodeType result;
	ValadocApiPropertyAccessor* self;
	self = (ValadocApiPropertyAccessor*) base;
	result = VALADOC_API_NODE_TYPE_PROPERTY_ACCESSOR;
	return result;
}

/**
 * Returns the name of this property accessor as it is used in C.
 */
gchar*
valadoc_api_property_accessor_get_cname (ValadocApiPropertyAccessor* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cname;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * {@inheritDoc}
 */
static void
valadoc_api_property_accessor_real_accept (ValadocApiNode* base,
                                           ValadocApiVisitor* visitor)
{
	ValadocApiPropertyAccessor * self;
	self = (ValadocApiPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
}

gboolean
valadoc_api_property_accessor_get_is_construct (ValadocApiPropertyAccessor* self)
{
	gboolean result;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = valadoc_api_item_get_data ((ValadocApiItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_property_accessor_get_construction (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor));
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

gboolean
valadoc_api_property_accessor_get_is_set (ValadocApiPropertyAccessor* self)
{
	gboolean result;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = valadoc_api_item_get_data ((ValadocApiItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_property_accessor_get_writable (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor));
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

gboolean
valadoc_api_property_accessor_get_is_get (ValadocApiPropertyAccessor* self)
{
	gboolean result;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = valadoc_api_item_get_data ((ValadocApiItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_property_accessor_get_readable (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor));
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

gboolean
valadoc_api_property_accessor_get_is_owned (ValadocApiPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->ownership == VALADOC_API_OWNERSHIP_OWNED;
	return result;
}

/**
 * {@inheritDoc}
 */
static ValadocContentInline*
valadoc_api_property_accessor_real_build_signature (ValadocApiItem* base)
{
	ValadocApiPropertyAccessor * self;
	ValadocApiSignatureBuilder* signature = NULL;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiItem* _tmp3_;
	ValadocApiItem* _tmp4_;
	ValaSymbolAccessibility _tmp5_;
	ValaSymbolAccessibility _tmp6_;
	ValaSymbolAccessibility _tmp7_;
	ValaSymbolAccessibility _tmp8_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ValadocApiSignatureBuilder* _tmp33_;
	ValadocApiSignatureBuilder* _tmp34_;
	ValadocContentRun* _tmp35_;
	ValadocContentInline* result;
	self = (ValadocApiPropertyAccessor*) base;
	_tmp0_ = valadoc_api_signature_builder_new ();
	signature = _tmp0_;
	if (!((ValadocApiNode*) self)->do_document) {
		ValadocApiSignatureBuilder* _tmp1_;
		ValadocContentRun* _tmp2_;
		_tmp1_ = signature;
		_tmp2_ = valadoc_api_signature_builder_get (_tmp1_);
		result = (ValadocContentInline*) _tmp2_;
		_valadoc_api_signature_builder_unref0 (signature);
		return result;
	}
	_tmp3_ = valadoc_api_item_get_parent ((ValadocApiItem*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = valadoc_api_symbol_get_accessibility ((ValadocApiSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_api_symbol_get_accessibility ((ValadocApiSymbol*) self);
	_tmp8_ = _tmp7_;
	if (_tmp6_ != _tmp8_) {
		ValadocApiSignatureBuilder* _tmp9_;
		ValaSymbolAccessibility _tmp10_;
		ValaSymbolAccessibility _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = signature;
		_tmp10_ = valadoc_api_symbol_get_accessibility ((ValadocApiSymbol*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_accessibility_to_string (_tmp11_);
		valadoc_api_signature_builder_append_keyword (_tmp9_, _tmp12_, TRUE);
	}
	_tmp14_ = valadoc_api_property_accessor_get_is_set (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp16_ = valadoc_api_property_accessor_get_is_construct (self);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_;
	}
	if (_tmp13_) {
		gboolean _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp24_;
		gboolean _tmp25_;
		_tmp18_ = valadoc_api_property_accessor_get_is_owned (self);
		_tmp19_ = _tmp18_;
		if (_tmp19_) {
			ValadocApiSignatureBuilder* _tmp20_;
			_tmp20_ = signature;
			valadoc_api_signature_builder_append_keyword (_tmp20_, "owned", TRUE);
		}
		_tmp21_ = valadoc_api_property_accessor_get_is_set (self);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			ValadocApiSignatureBuilder* _tmp23_;
			_tmp23_ = signature;
			valadoc_api_signature_builder_append_keyword (_tmp23_, "set", TRUE);
		}
		_tmp24_ = valadoc_api_property_accessor_get_is_construct (self);
		_tmp25_ = _tmp24_;
		if (_tmp25_) {
			ValadocApiSignatureBuilder* _tmp26_;
			_tmp26_ = signature;
			valadoc_api_signature_builder_append_keyword (_tmp26_, "construct", TRUE);
		}
	} else {
		gboolean _tmp27_;
		gboolean _tmp28_;
		_tmp27_ = valadoc_api_property_accessor_get_is_get (self);
		_tmp28_ = _tmp27_;
		if (_tmp28_) {
			gboolean _tmp29_;
			gboolean _tmp30_;
			ValadocApiSignatureBuilder* _tmp32_;
			_tmp29_ = valadoc_api_property_accessor_get_is_owned (self);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				ValadocApiSignatureBuilder* _tmp31_;
				_tmp31_ = signature;
				valadoc_api_signature_builder_append_keyword (_tmp31_, "owned", TRUE);
			}
			_tmp32_ = signature;
			valadoc_api_signature_builder_append_keyword (_tmp32_, "get", TRUE);
		}
	}
	_tmp33_ = signature;
	valadoc_api_signature_builder_append (_tmp33_, ";", FALSE);
	_tmp34_ = signature;
	_tmp35_ = valadoc_api_signature_builder_get (_tmp34_);
	result = (ValadocContentInline*) _tmp35_;
	_valadoc_api_signature_builder_unref0 (signature);
	return result;
}

static void
valadoc_api_property_accessor_class_init (ValadocApiPropertyAccessorClass * klass,
                                          gpointer klass_data)
{
	valadoc_api_property_accessor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocApiPropertyAccessor_private_offset);
	((ValadocApiNodeClass *) klass)->accept = (void (*) (ValadocApiNode*, ValadocApiVisitor*)) valadoc_api_property_accessor_real_accept;
	((ValadocApiItemClass *) klass)->build_signature = (ValadocContentInline* (*) (ValadocApiItem*)) valadoc_api_property_accessor_real_build_signature;
	VALADOC_API_NODE_CLASS (klass)->get_node_type = (ValadocApiNodeType (*) (ValadocApiNode*)) valadoc_api_property_accessor_real_get_node_type;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_api_property_accessor_get_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_api_property_accessor_finalize;
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_PROPERTY_ACCESSOR_NODE_TYPE_PROPERTY, valadoc_api_property_accessor_properties[VALADOC_API_PROPERTY_ACCESSOR_NODE_TYPE_PROPERTY] = g_param_spec_enum ("node-type", "node-type", "node-type", VALADOC_API_TYPE_NODE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies whether this accessor may be used to construct the property.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_PROPERTY_ACCESSOR_IS_CONSTRUCT_PROPERTY, valadoc_api_property_accessor_properties[VALADOC_API_PROPERTY_ACCESSOR_IS_CONSTRUCT_PROPERTY] = g_param_spec_boolean ("is-construct", "is-construct", "is-construct", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies whether this accessor is a setter.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_PROPERTY_ACCESSOR_IS_SET_PROPERTY, valadoc_api_property_accessor_properties[VALADOC_API_PROPERTY_ACCESSOR_IS_SET_PROPERTY] = g_param_spec_boolean ("is-set", "is-set", "is-set", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies whether this accessor is a getter.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_PROPERTY_ACCESSOR_IS_GET_PROPERTY, valadoc_api_property_accessor_properties[VALADOC_API_PROPERTY_ACCESSOR_IS_GET_PROPERTY] = g_param_spec_boolean ("is-get", "is-get", "is-get", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies whether the property is owned.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_PROPERTY_ACCESSOR_IS_OWNED_PROPERTY, valadoc_api_property_accessor_properties[VALADOC_API_PROPERTY_ACCESSOR_IS_OWNED_PROPERTY] = g_param_spec_boolean ("is-owned", "is-owned", "is-owned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
valadoc_api_property_accessor_instance_init (ValadocApiPropertyAccessor * self,
                                             gpointer klass)
{
	self->priv = valadoc_api_property_accessor_get_instance_private (self);
}

static void
valadoc_api_property_accessor_finalize (GObject * obj)
{
	ValadocApiPropertyAccessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_PROPERTY_ACCESSOR, ValadocApiPropertyAccessor);
	_g_free0 (self->priv->cname);
	G_OBJECT_CLASS (valadoc_api_property_accessor_parent_class)->finalize (obj);
}

/**
 * Represents a get or set accessor of a property.
 */
static GType
valadoc_api_property_accessor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocApiPropertyAccessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_property_accessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiPropertyAccessor), 0, (GInstanceInitFunc) valadoc_api_property_accessor_instance_init, NULL };
	GType valadoc_api_property_accessor_type_id;
	valadoc_api_property_accessor_type_id = g_type_register_static (VALADOC_API_TYPE_SYMBOL, "ValadocApiPropertyAccessor", &g_define_type_info, 0);
	ValadocApiPropertyAccessor_private_offset = g_type_add_instance_private (valadoc_api_property_accessor_type_id, sizeof (ValadocApiPropertyAccessorPrivate));
	return valadoc_api_property_accessor_type_id;
}

GType
valadoc_api_property_accessor_get_type (void)
{
	static volatile gsize valadoc_api_property_accessor_type_id__once = 0;
	if (g_once_init_enter (&valadoc_api_property_accessor_type_id__once)) {
		GType valadoc_api_property_accessor_type_id;
		valadoc_api_property_accessor_type_id = valadoc_api_property_accessor_get_type_once ();
		g_once_init_leave (&valadoc_api_property_accessor_type_id__once, valadoc_api_property_accessor_type_id);
	}
	return valadoc_api_property_accessor_type_id__once;
}

static void
_vala_valadoc_api_property_accessor_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	ValadocApiPropertyAccessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_PROPERTY_ACCESSOR, ValadocApiPropertyAccessor);
	switch (property_id) {
		case VALADOC_API_PROPERTY_ACCESSOR_NODE_TYPE_PROPERTY:
		g_value_set_enum (value, valadoc_api_node_get_node_type ((ValadocApiNode*) self));
		break;
		case VALADOC_API_PROPERTY_ACCESSOR_IS_CONSTRUCT_PROPERTY:
		g_value_set_boolean (value, valadoc_api_property_accessor_get_is_construct (self));
		break;
		case VALADOC_API_PROPERTY_ACCESSOR_IS_SET_PROPERTY:
		g_value_set_boolean (value, valadoc_api_property_accessor_get_is_set (self));
		break;
		case VALADOC_API_PROPERTY_ACCESSOR_IS_GET_PROPERTY:
		g_value_set_boolean (value, valadoc_api_property_accessor_get_is_get (self));
		break;
		case VALADOC_API_PROPERTY_ACCESSOR_IS_OWNED_PROPERTY:
		g_value_set_boolean (value, valadoc_api_property_accessor_get_is_owned (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

