/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-11 20:09
 */

#ifndef BTTASK_H_
#define BTTASK_H_

#include <pthread.h>
#include <string>
#include <list>
#include "BitStorm.h"

typedef std::list<unsigned int>  TSpeedList;

class CBTTask : 
	public IBTTask,
	public ITimerCallback
{
public:
	CBTTask();
	virtual ~CBTTask();
private:
	std::string _torrentFilePath;
	std::string _destPath;
	ITorrentFile* _torrentFile;
	ITrackerManager* _trackerManager;
	IPeerManager* _peerManager;	
	ISocketReactor* _socketReactor;
	IStorage* _storage;
	IPeerAcceptor* _acceptor;
	IUPnpNAT* _upnpNat;
	IRateMeasure* _rateMeasure;
	
	std::string _peerID;
	std::string _errorMessage;
	
	int64_t _downloadCount;
	int64_t _uploadCount;
	unsigned int _uploadSpeed;
	unsigned int _downloadSpeed;
	unsigned int _lastCheckSpeedTick;
	int64_t _lastUploadCount;
	int64_t _lastDownloadCount;	
	TSpeedList _uploadSpeedList;
	TSpeedList _downloadSpeedList;
	
	unsigned int _speedTimerID;
	
	unsigned int _peerLinkMax;
	unsigned int _uploadPeerLinkMax;
	unsigned int _cacheSize;
	
	TBanedFileList _bandFileList;
	
	bool _toExit;
	pthread_t _threadHandle;
private:
	unsigned int checkDownloadSpeed();
	unsigned int checkUploadSpeed();	
public:	
	int svc();
	
	void setTorrentFilePath(const char* path);
	void setDestPath(const char* path);
	std::string getDestPath();
	std::string getTaskName();
	bool start();
	void stop();
	std::string getErrorMessage();
	std::string getPeerID();
	
	bool loadTorrentFile();
	ITorrentFile* getTorrentFile();	
	void setBanedFileList(TBanedFileList bandFileList);
	ITrackerManager* getTrackerManager();
	ISocketReactor* getSocketReactor();
	IRateMeasure* getRateMeasure();
	IPeerManager* getPeerManager();	
	IStorage* getStorage();
	IPeerAcceptor* getAcceptor();
	IUPnpNAT* getUPnpNat();
	
	void onTimer(unsigned int id);

	void incDownlaodCount(unsigned int count);
	void incUploadCount(unsigned int count);	
	int64_t getDownlaodCount();
	int64_t getUploadCount();	
		
	unsigned int getPeerLinkMax();
	void setPeerLinkMax(unsigned int count);
	unsigned int getUploadPeerLinkMax();
	void setUploadPeerLinkMax(unsigned int count);
	unsigned int getCacheSize();
	void setCacheSize(unsigned int count);	
	unsigned int getConnectingPeerLinkMax();	
	unsigned int getUploadSpeed();
	unsigned int getDownloadSpeed();	
};

#endif /*BTTASK_H_*/
