# -*- coding: utf-8 -*-
info = {
    "name": "pt",
    "date_order": "DMY",
    "january": [
        "janeiro",
        "jan"
    ],
    "february": [
        "fevereiro",
        "fev"
    ],
    "march": [
        "março",
        "mar"
    ],
    "april": [
        "abril",
        "abr"
    ],
    "may": [
        "maio",
        "mai"
    ],
    "june": [
        "junho",
        "jun"
    ],
    "july": [
        "julho",
        "jul"
    ],
    "august": [
        "agosto",
        "ago"
    ],
    "september": [
        "setembro",
        "set",
        "Septembro"
    ],
    "october": [
        "outubro",
        "out"
    ],
    "november": [
        "novembro",
        "nov"
    ],
    "december": [
        "dezembro",
        "dez"
    ],
    "monday": [
        "segunda-feira",
        "seg",
        "Segunda"
    ],
    "tuesday": [
        "terça-feira",
        "ter",
        "Terça"
    ],
    "wednesday": [
        "quarta-feira",
        "qua",
        "Quarta"
    ],
    "thursday": [
        "quinta-feira",
        "qui",
        "Quinta"
    ],
    "friday": [
        "sexta-feira",
        "sex",
        "Sexta"
    ],
    "saturday": [
        "sábado",
        "sáb",
        "Sab"
    ],
    "sunday": [
        "domingo",
        "dom"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "ano",
        "anos"
    ],
    "month": [
        "mês",
        "meses"
    ],
    "week": [
        "semana",
        "sem",
        "semanas"
    ],
    "day": [
        "dia",
        "dias"
    ],
    "hour": [
        "hora",
        "h",
        "horas"
    ],
    "minute": [
        "minuto",
        "min",
        "m",
        "minutos"
    ],
    "second": [
        "segundo",
        "seg",
        "s",
        "segundos"
    ],
    "relative-type": {
        "1 year ago": [
            "ano passado"
        ],
        "0 year ago": [
            "este ano"
        ],
        "in 1 year": [
            "próximo ano"
        ],
        "1 month ago": [
            "mês passado"
        ],
        "0 month ago": [
            "este mês"
        ],
        "in 1 month": [
            "próximo mês"
        ],
        "1 week ago": [
            "semana passada"
        ],
        "0 week ago": [
            "esta semana"
        ],
        "in 1 week": [
            "próxima semana"
        ],
        "1 day ago": [
            "ontem"
        ],
        "0 day ago": [
            "hoje"
        ],
        "in 1 day": [
            "amanhã"
        ],
        "0 hour ago": [
            "esta hora"
        ],
        "0 minute ago": [
            "este minuto"
        ],
        "0 second ago": [
            "agora"
        ],
        "2 day ago": [
            "anteontem"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "em (\\d+) ano",
            "em (\\d+) anos"
        ],
        "\\1 year ago": [
            "há (\\d+) ano",
            "há (\\d+) anos"
        ],
        "in \\1 month": [
            "em (\\d+) mês",
            "em (\\d+) meses"
        ],
        "\\1 month ago": [
            "há (\\d+) mês",
            "há (\\d+) meses"
        ],
        "in \\1 week": [
            "em (\\d+) semana",
            "em (\\d+) semanas",
            "em (\\d+) sem"
        ],
        "\\1 week ago": [
            "há (\\d+) semana",
            "há (\\d+) semanas",
            "há (\\d+) sem"
        ],
        "in \\1 day": [
            "em (\\d+) dia",
            "em (\\d+) dias"
        ],
        "\\1 day ago": [
            "há (\\d+) dia",
            "há (\\d+) dias"
        ],
        "in \\1 hour": [
            "em (\\d+) hora",
            "em (\\d+) horas",
            "em (\\d+) h"
        ],
        "\\1 hour ago": [
            "há (\\d+) hora",
            "há (\\d+) horas",
            "há (\\d+) h"
        ],
        "in \\1 minute": [
            "em (\\d+) minuto",
            "em (\\d+) minutos",
            "em (\\d+) min",
            "em (\\d+) mins"
        ],
        "\\1 minute ago": [
            "há (\\d+) minuto",
            "há (\\d+) minutos",
            "há (\\d+) min",
            "há (\\d+) mins"
        ],
        "in \\1 second": [
            "em (\\d+) segundo",
            "em (\\d+) segundos",
            "em (\\d+) seg",
            "em (\\d+) segs"
        ],
        "\\1 second ago": [
            "há (\\d+) segundo",
            "há (\\d+) segundos",
            "há (\\d+) seg"
        ]
    },
    "locale_specific": {
        "pt-CH": {
            "name": "pt-CH",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-GW": {
            "name": "pt-GW",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-MZ": {
            "name": "pt-MZ",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-CV": {
            "name": "pt-CV",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-LU": {
            "name": "pt-LU",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-MO": {
            "name": "pt-MO",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-GQ": {
            "name": "pt-GQ",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-ST": {
            "name": "pt-ST",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-PT": {
            "name": "pt-PT",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-AO": {
            "name": "pt-AO",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        },
        "pt-TL": {
            "name": "pt-TL",
            "monday": [
                "segunda"
            ],
            "tuesday": [
                "terça"
            ],
            "wednesday": [
                "quarta"
            ],
            "thursday": [
                "quinta"
            ],
            "friday": [
                "sexta"
            ],
            "am": [
                "manhã",
                "da manhã"
            ],
            "pm": [
                "tarde",
                "da tarde"
            ],
            "relative-type-regex": {
                "in \\1 year": [
                    "dentro de (\\d+) ano",
                    "dentro de (\\d+) anos"
                ],
                "in \\1 month": [
                    "dentro de (\\d+) meses",
                    "dentro de (\\d+) mês"
                ],
                "in \\1 week": [
                    "dentro de (\\d+) sem",
                    "dentro de (\\d+) semana",
                    "dentro de (\\d+) semanas"
                ],
                "in \\1 day": [
                    "dentro de (\\d+) dias",
                    "dentro de (\\d+) dia"
                ],
                "in \\1 hour": [
                    "dentro de (\\d+) h",
                    "dentro de (\\d+) hora",
                    "dentro de (\\d+) horas"
                ],
                "in \\1 minute": [
                    "dentro de (\\d+) min",
                    "dentro de (\\d+) minuto",
                    "dentro de (\\d+) minutos"
                ],
                "in \\1 second": [
                    "dentro de (\\d+) segundo",
                    "dentro de (\\d+) segundos",
                    "dentro de (\\d+) s"
                ],
                "\\1 second ago": [
                    "há (\\d+) s"
                ]
            }
        }
    },
    "skip": [
        "de",
        "cerca",
        "e",
        "às",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "pertain": [
        "de"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "atrás",
        "há"
    ],
    "in": [
        "em"
    ],
    "simplifications": [
        {
            "uma": "1"
        },
        {
            "um": "1"
        },
        {
            "alguns segundos": "44 segundos"
        }
    ]
}