#!/bin/sh
# SPDX-FileCopyrightText: 2022 UnionTech Software Technology Co., Ltd.
#
# SPDX-License-Identifier: GPL-3.0-or-later

readonly PREREQ="plymouth"

prereqs() {
	echo "${PREREQ}"
}

case "${1}" in
prereqs)
	prereqs
	exit 0
	;;
esac

if [ -n "$break" ]; then
        # 因为启动参数 break 而执行 panic 函数，立即退出
        exit 0
fi

if [ "$BOOT" != local ]; then
        log_info 'boot is not local, exit'
        exit 0
fi

unset IFS
read -r console rest </proc/consoles
if [ "${console}" = "tty0" ]; then
        # Need to choose a specific VT
        console="tty1"
fi

mkdir -p /usr/lib/locale/
if [ -f /usr/share/locale/fix-init-locale-archive ]; then
	mv /usr/share/locale/fix-init-locale-archive /usr/lib/locale/locale-archive
fi

if [ -f /etc/default/locale ]; then
	. /etc/default/locale
else
	LANG=en_US
	LANGUAGE=en_US.UTF-8
fi
export LANG
export LANGUAGE

sh -c "exec fbterm -s 20 -n unifont -- deepin-fix-init <> /dev/${console} 1>&0 2>&1"
#/bin/deepin-fix-init -u ${root_uuid}

EXIT_FILE="/tmp/deepin-fix-init.txt"
if [ -f ${EXIT_FILE} ]; then
        touch "/tmp/panic_continue_boot"
	exit
fi
