/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#ifndef __FADER
#define __FADER

#include <string>

struct fader {

  int on; // on?

  float start;
  float end;
  float delta;

  float alpha;

  int flip; // end > start? 1:0

  float amount; // output

  float start_time, delta_time;

  std::string post; // post command excecuted on console
  void set_post (const std::string& pst);

  fader (float vs = 0, float ve = 1);
  void set (float vs, float ve, int _on = 1, float dt = 1.5);
  int eval ();
  void restart ();
  float value ();

};

#endif
