﻿/* Jerry - A Chess Graphical User Interface
 * Copyright (C) 2014-2016 Dominik Klein
 * Copyright (C) 2015-2016 Karl Josef Klein
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#include <QString>
#include <QList>
#include <QDebug>
#include <QStringList>
#include "board.h"
#include <iostream>
#include <bitset>
#include <exception>
#include <algorithm>
#include <assert.h>
#include "move.h"

using namespace std;

namespace chess {

quint64 POLYGLOT_RANDOM_64[781] = {
  Q_UINT64_C(0x9D39247E33776D41), Q_UINT64_C(0x2AF7398005AAA5C7), Q_UINT64_C(0x44DB015024623547),
  Q_UINT64_C(0x9C15F73E62A76AE2), Q_UINT64_C(0x75834465489C0C89), Q_UINT64_C(0x3290AC3A203001BF),
  Q_UINT64_C(0x0FBBAD1F61042279), Q_UINT64_C(0xE83A908FF2FB60CA), Q_UINT64_C(0x0D7E765D58755C10),
  Q_UINT64_C(0x1A083822CEAFE02D), Q_UINT64_C(0x9605D5F0E25EC3B0), Q_UINT64_C(0xD021FF5CD13A2ED5),
  Q_UINT64_C(0x40BDF15D4A672E32), Q_UINT64_C(0x011355146FD56395), Q_UINT64_C(0x5DB4832046F3D9E5),
  Q_UINT64_C(0x239F8B2D7FF719CC), Q_UINT64_C(0x05D1A1AE85B49AA1), Q_UINT64_C(0x679F848F6E8FC971),
  Q_UINT64_C(0x7449BBFF801FED0B), Q_UINT64_C(0x7D11CDB1C3B7ADF0), Q_UINT64_C(0x82C7709E781EB7CC),
  Q_UINT64_C(0xF3218F1C9510786C), Q_UINT64_C(0x331478F3AF51BBE6), Q_UINT64_C(0x4BB38DE5E7219443),
  Q_UINT64_C(0xAA649C6EBCFD50FC), Q_UINT64_C(0x8DBD98A352AFD40B), Q_UINT64_C(0x87D2074B81D79217),
  Q_UINT64_C(0x19F3C751D3E92AE1), Q_UINT64_C(0xB4AB30F062B19ABF), Q_UINT64_C(0x7B0500AC42047AC4),
  Q_UINT64_C(0xC9452CA81A09D85D), Q_UINT64_C(0x24AA6C514DA27500), Q_UINT64_C(0x4C9F34427501B447),
  Q_UINT64_C(0x14A68FD73C910841), Q_UINT64_C(0xA71B9B83461CBD93), Q_UINT64_C(0x03488B95B0F1850F),
  Q_UINT64_C(0x637B2B34FF93C040), Q_UINT64_C(0x09D1BC9A3DD90A94), Q_UINT64_C(0x3575668334A1DD3B),
  Q_UINT64_C(0x735E2B97A4C45A23), Q_UINT64_C(0x18727070F1BD400B), Q_UINT64_C(0x1FCBACD259BF02E7),
  Q_UINT64_C(0xD310A7C2CE9B6555), Q_UINT64_C(0xBF983FE0FE5D8244), Q_UINT64_C(0x9F74D14F7454A824),
  Q_UINT64_C(0x51EBDC4AB9BA3035), Q_UINT64_C(0x5C82C505DB9AB0FA), Q_UINT64_C(0xFCF7FE8A3430B241),
  Q_UINT64_C(0x3253A729B9BA3DDE), Q_UINT64_C(0x8C74C368081B3075), Q_UINT64_C(0xB9BC6C87167C33E7),
  Q_UINT64_C(0x7EF48F2B83024E20), Q_UINT64_C(0x11D505D4C351BD7F), Q_UINT64_C(0x6568FCA92C76A243),
  Q_UINT64_C(0x4DE0B0F40F32A7B8), Q_UINT64_C(0x96D693460CC37E5D), Q_UINT64_C(0x42E240CB63689F2F),
  Q_UINT64_C(0x6D2BDCDAE2919661), Q_UINT64_C(0x42880B0236E4D951), Q_UINT64_C(0x5F0F4A5898171BB6),
  Q_UINT64_C(0x39F890F579F92F88), Q_UINT64_C(0x93C5B5F47356388B), Q_UINT64_C(0x63DC359D8D231B78),
  Q_UINT64_C(0xEC16CA8AEA98AD76), Q_UINT64_C(0x5355F900C2A82DC7), Q_UINT64_C(0x07FB9F855A997142),
  Q_UINT64_C(0x5093417AA8A7ED5E), Q_UINT64_C(0x7BCBC38DA25A7F3C), Q_UINT64_C(0x19FC8A768CF4B6D4),
  Q_UINT64_C(0x637A7780DECFC0D9), Q_UINT64_C(0x8249A47AEE0E41F7), Q_UINT64_C(0x79AD695501E7D1E8),
  Q_UINT64_C(0x14ACBAF4777D5776), Q_UINT64_C(0xF145B6BECCDEA195), Q_UINT64_C(0xDABF2AC8201752FC),
  Q_UINT64_C(0x24C3C94DF9C8D3F6), Q_UINT64_C(0xBB6E2924F03912EA), Q_UINT64_C(0x0CE26C0B95C980D9),
  Q_UINT64_C(0xA49CD132BFBF7CC4), Q_UINT64_C(0xE99D662AF4243939), Q_UINT64_C(0x27E6AD7891165C3F),
  Q_UINT64_C(0x8535F040B9744FF1), Q_UINT64_C(0x54B3F4FA5F40D873), Q_UINT64_C(0x72B12C32127FED2B),
  Q_UINT64_C(0xEE954D3C7B411F47), Q_UINT64_C(0x9A85AC909A24EAA1), Q_UINT64_C(0x70AC4CD9F04F21F5),
  Q_UINT64_C(0xF9B89D3E99A075C2), Q_UINT64_C(0x87B3E2B2B5C907B1), Q_UINT64_C(0xA366E5B8C54F48B8),
  Q_UINT64_C(0xAE4A9346CC3F7CF2), Q_UINT64_C(0x1920C04D47267BBD), Q_UINT64_C(0x87BF02C6B49E2AE9),
  Q_UINT64_C(0x092237AC237F3859), Q_UINT64_C(0xFF07F64EF8ED14D0), Q_UINT64_C(0x8DE8DCA9F03CC54E),
  Q_UINT64_C(0x9C1633264DB49C89), Q_UINT64_C(0xB3F22C3D0B0B38ED), Q_UINT64_C(0x390E5FB44D01144B),
  Q_UINT64_C(0x5BFEA5B4712768E9), Q_UINT64_C(0x1E1032911FA78984), Q_UINT64_C(0x9A74ACB964E78CB3),
  Q_UINT64_C(0x4F80F7A035DAFB04), Q_UINT64_C(0x6304D09A0B3738C4), Q_UINT64_C(0x2171E64683023A08),
  Q_UINT64_C(0x5B9B63EB9CEFF80C), Q_UINT64_C(0x506AACF489889342), Q_UINT64_C(0x1881AFC9A3A701D6),
  Q_UINT64_C(0x6503080440750644), Q_UINT64_C(0xDFD395339CDBF4A7), Q_UINT64_C(0xEF927DBCF00C20F2),
  Q_UINT64_C(0x7B32F7D1E03680EC), Q_UINT64_C(0xB9FD7620E7316243), Q_UINT64_C(0x05A7E8A57DB91B77),
  Q_UINT64_C(0xB5889C6E15630A75), Q_UINT64_C(0x4A750A09CE9573F7), Q_UINT64_C(0xCF464CEC899A2F8A),
  Q_UINT64_C(0xF538639CE705B824), Q_UINT64_C(0x3C79A0FF5580EF7F), Q_UINT64_C(0xEDE6C87F8477609D),
  Q_UINT64_C(0x799E81F05BC93F31), Q_UINT64_C(0x86536B8CF3428A8C), Q_UINT64_C(0x97D7374C60087B73),
  Q_UINT64_C(0xA246637CFF328532), Q_UINT64_C(0x043FCAE60CC0EBA0), Q_UINT64_C(0x920E449535DD359E),
  Q_UINT64_C(0x70EB093B15B290CC), Q_UINT64_C(0x73A1921916591CBD), Q_UINT64_C(0x56436C9FE1A1AA8D),
  Q_UINT64_C(0xEFAC4B70633B8F81), Q_UINT64_C(0xBB215798D45DF7AF), Q_UINT64_C(0x45F20042F24F1768),
  Q_UINT64_C(0x930F80F4E8EB7462), Q_UINT64_C(0xFF6712FFCFD75EA1), Q_UINT64_C(0xAE623FD67468AA70),
  Q_UINT64_C(0xDD2C5BC84BC8D8FC), Q_UINT64_C(0x7EED120D54CF2DD9), Q_UINT64_C(0x22FE545401165F1C),
  Q_UINT64_C(0xC91800E98FB99929), Q_UINT64_C(0x808BD68E6AC10365), Q_UINT64_C(0xDEC468145B7605F6),
  Q_UINT64_C(0x1BEDE3A3AEF53302), Q_UINT64_C(0x43539603D6C55602), Q_UINT64_C(0xAA969B5C691CCB7A),
  Q_UINT64_C(0xA87832D392EFEE56), Q_UINT64_C(0x65942C7B3C7E11AE), Q_UINT64_C(0xDED2D633CAD004F6),
  Q_UINT64_C(0x21F08570F420E565), Q_UINT64_C(0xB415938D7DA94E3C), Q_UINT64_C(0x91B859E59ECB6350),
  Q_UINT64_C(0x10CFF333E0ED804A), Q_UINT64_C(0x28AED140BE0BB7DD), Q_UINT64_C(0xC5CC1D89724FA456),
  Q_UINT64_C(0x5648F680F11A2741), Q_UINT64_C(0x2D255069F0B7DAB3), Q_UINT64_C(0x9BC5A38EF729ABD4),
  Q_UINT64_C(0xEF2F054308F6A2BC), Q_UINT64_C(0xAF2042F5CC5C2858), Q_UINT64_C(0x480412BAB7F5BE2A),
  Q_UINT64_C(0xAEF3AF4A563DFE43), Q_UINT64_C(0x19AFE59AE451497F), Q_UINT64_C(0x52593803DFF1E840),
  Q_UINT64_C(0xF4F076E65F2CE6F0), Q_UINT64_C(0x11379625747D5AF3), Q_UINT64_C(0xBCE5D2248682C115),
  Q_UINT64_C(0x9DA4243DE836994F), Q_UINT64_C(0x066F70B33FE09017), Q_UINT64_C(0x4DC4DE189B671A1C),
  Q_UINT64_C(0x51039AB7712457C3), Q_UINT64_C(0xC07A3F80C31FB4B4), Q_UINT64_C(0xB46EE9C5E64A6E7C),
  Q_UINT64_C(0xB3819A42ABE61C87), Q_UINT64_C(0x21A007933A522A20), Q_UINT64_C(0x2DF16F761598AA4F),
  Q_UINT64_C(0x763C4A1371B368FD), Q_UINT64_C(0xF793C46702E086A0), Q_UINT64_C(0xD7288E012AEB8D31),
  Q_UINT64_C(0xDE336A2A4BC1C44B), Q_UINT64_C(0x0BF692B38D079F23), Q_UINT64_C(0x2C604A7A177326B3),
  Q_UINT64_C(0x4850E73E03EB6064), Q_UINT64_C(0xCFC447F1E53C8E1B), Q_UINT64_C(0xB05CA3F564268D99),
  Q_UINT64_C(0x9AE182C8BC9474E8), Q_UINT64_C(0xA4FC4BD4FC5558CA), Q_UINT64_C(0xE755178D58FC4E76),
  Q_UINT64_C(0x69B97DB1A4C03DFE), Q_UINT64_C(0xF9B5B7C4ACC67C96), Q_UINT64_C(0xFC6A82D64B8655FB),
  Q_UINT64_C(0x9C684CB6C4D24417), Q_UINT64_C(0x8EC97D2917456ED0), Q_UINT64_C(0x6703DF9D2924E97E),
  Q_UINT64_C(0xC547F57E42A7444E), Q_UINT64_C(0x78E37644E7CAD29E), Q_UINT64_C(0xFE9A44E9362F05FA),
  Q_UINT64_C(0x08BD35CC38336615), Q_UINT64_C(0x9315E5EB3A129ACE), Q_UINT64_C(0x94061B871E04DF75),
  Q_UINT64_C(0xDF1D9F9D784BA010), Q_UINT64_C(0x3BBA57B68871B59D), Q_UINT64_C(0xD2B7ADEEDED1F73F),
  Q_UINT64_C(0xF7A255D83BC373F8), Q_UINT64_C(0xD7F4F2448C0CEB81), Q_UINT64_C(0xD95BE88CD210FFA7),
  Q_UINT64_C(0x336F52F8FF4728E7), Q_UINT64_C(0xA74049DAC312AC71), Q_UINT64_C(0xA2F61BB6E437FDB5),
  Q_UINT64_C(0x4F2A5CB07F6A35B3), Q_UINT64_C(0x87D380BDA5BF7859), Q_UINT64_C(0x16B9F7E06C453A21),
  Q_UINT64_C(0x7BA2484C8A0FD54E), Q_UINT64_C(0xF3A678CAD9A2E38C), Q_UINT64_C(0x39B0BF7DDE437BA2),
  Q_UINT64_C(0xFCAF55C1BF8A4424), Q_UINT64_C(0x18FCF680573FA594), Q_UINT64_C(0x4C0563B89F495AC3),
  Q_UINT64_C(0x40E087931A00930D), Q_UINT64_C(0x8CFFA9412EB642C1), Q_UINT64_C(0x68CA39053261169F),
  Q_UINT64_C(0x7A1EE967D27579E2), Q_UINT64_C(0x9D1D60E5076F5B6F), Q_UINT64_C(0x3810E399B6F65BA2),
  Q_UINT64_C(0x32095B6D4AB5F9B1), Q_UINT64_C(0x35CAB62109DD038A), Q_UINT64_C(0xA90B24499FCFAFB1),
  Q_UINT64_C(0x77A225A07CC2C6BD), Q_UINT64_C(0x513E5E634C70E331), Q_UINT64_C(0x4361C0CA3F692F12),
  Q_UINT64_C(0xD941ACA44B20A45B), Q_UINT64_C(0x528F7C8602C5807B), Q_UINT64_C(0x52AB92BEB9613989),
  Q_UINT64_C(0x9D1DFA2EFC557F73), Q_UINT64_C(0x722FF175F572C348), Q_UINT64_C(0x1D1260A51107FE97),
  Q_UINT64_C(0x7A249A57EC0C9BA2), Q_UINT64_C(0x04208FE9E8F7F2D6), Q_UINT64_C(0x5A110C6058B920A0),
  Q_UINT64_C(0x0CD9A497658A5698), Q_UINT64_C(0x56FD23C8F9715A4C), Q_UINT64_C(0x284C847B9D887AAE),
  Q_UINT64_C(0x04FEABFBBDB619CB), Q_UINT64_C(0x742E1E651C60BA83), Q_UINT64_C(0x9A9632E65904AD3C),
  Q_UINT64_C(0x881B82A13B51B9E2), Q_UINT64_C(0x506E6744CD974924), Q_UINT64_C(0xB0183DB56FFC6A79),
  Q_UINT64_C(0x0ED9B915C66ED37E), Q_UINT64_C(0x5E11E86D5873D484), Q_UINT64_C(0xF678647E3519AC6E),
  Q_UINT64_C(0x1B85D488D0F20CC5), Q_UINT64_C(0xDAB9FE6525D89021), Q_UINT64_C(0x0D151D86ADB73615),
  Q_UINT64_C(0xA865A54EDCC0F019), Q_UINT64_C(0x93C42566AEF98FFB), Q_UINT64_C(0x99E7AFEABE000731),
  Q_UINT64_C(0x48CBFF086DDF285A), Q_UINT64_C(0x7F9B6AF1EBF78BAF), Q_UINT64_C(0x58627E1A149BBA21),
  Q_UINT64_C(0x2CD16E2ABD791E33), Q_UINT64_C(0xD363EFF5F0977996), Q_UINT64_C(0x0CE2A38C344A6EED),
  Q_UINT64_C(0x1A804AADB9CFA741), Q_UINT64_C(0x907F30421D78C5DE), Q_UINT64_C(0x501F65EDB3034D07),
  Q_UINT64_C(0x37624AE5A48FA6E9), Q_UINT64_C(0x957BAF61700CFF4E), Q_UINT64_C(0x3A6C27934E31188A),
  Q_UINT64_C(0xD49503536ABCA345), Q_UINT64_C(0x088E049589C432E0), Q_UINT64_C(0xF943AEE7FEBF21B8),
  Q_UINT64_C(0x6C3B8E3E336139D3), Q_UINT64_C(0x364F6FFA464EE52E), Q_UINT64_C(0xD60F6DCEDC314222),
  Q_UINT64_C(0x56963B0DCA418FC0), Q_UINT64_C(0x16F50EDF91E513AF), Q_UINT64_C(0xEF1955914B609F93),
  Q_UINT64_C(0x565601C0364E3228), Q_UINT64_C(0xECB53939887E8175), Q_UINT64_C(0xBAC7A9A18531294B),
  Q_UINT64_C(0xB344C470397BBA52), Q_UINT64_C(0x65D34954DAF3CEBD), Q_UINT64_C(0xB4B81B3FA97511E2),
  Q_UINT64_C(0xB422061193D6F6A7), Q_UINT64_C(0x071582401C38434D), Q_UINT64_C(0x7A13F18BBEDC4FF5),
  Q_UINT64_C(0xBC4097B116C524D2), Q_UINT64_C(0x59B97885E2F2EA28), Q_UINT64_C(0x99170A5DC3115544),
  Q_UINT64_C(0x6F423357E7C6A9F9), Q_UINT64_C(0x325928EE6E6F8794), Q_UINT64_C(0xD0E4366228B03343),
  Q_UINT64_C(0x565C31F7DE89EA27), Q_UINT64_C(0x30F5611484119414), Q_UINT64_C(0xD873DB391292ED4F),
  Q_UINT64_C(0x7BD94E1D8E17DEBC), Q_UINT64_C(0xC7D9F16864A76E94), Q_UINT64_C(0x947AE053EE56E63C),
  Q_UINT64_C(0xC8C93882F9475F5F), Q_UINT64_C(0x3A9BF55BA91F81CA), Q_UINT64_C(0xD9A11FBB3D9808E4),
  Q_UINT64_C(0x0FD22063EDC29FCA), Q_UINT64_C(0xB3F256D8ACA0B0B9), Q_UINT64_C(0xB03031A8B4516E84),
  Q_UINT64_C(0x35DD37D5871448AF), Q_UINT64_C(0xE9F6082B05542E4E), Q_UINT64_C(0xEBFAFA33D7254B59),
  Q_UINT64_C(0x9255ABB50D532280), Q_UINT64_C(0xB9AB4CE57F2D34F3), Q_UINT64_C(0x693501D628297551),
  Q_UINT64_C(0xC62C58F97DD949BF), Q_UINT64_C(0xCD454F8F19C5126A), Q_UINT64_C(0xBBE83F4ECC2BDECB),
  Q_UINT64_C(0xDC842B7E2819E230), Q_UINT64_C(0xBA89142E007503B8), Q_UINT64_C(0xA3BC941D0A5061CB),
  Q_UINT64_C(0xE9F6760E32CD8021), Q_UINT64_C(0x09C7E552BC76492F), Q_UINT64_C(0x852F54934DA55CC9),
  Q_UINT64_C(0x8107FCCF064FCF56), Q_UINT64_C(0x098954D51FFF6580), Q_UINT64_C(0x23B70EDB1955C4BF),
  Q_UINT64_C(0xC330DE426430F69D), Q_UINT64_C(0x4715ED43E8A45C0A), Q_UINT64_C(0xA8D7E4DAB780A08D),
  Q_UINT64_C(0x0572B974F03CE0BB), Q_UINT64_C(0xB57D2E985E1419C7), Q_UINT64_C(0xE8D9ECBE2CF3D73F),
  Q_UINT64_C(0x2FE4B17170E59750), Q_UINT64_C(0x11317BA87905E790), Q_UINT64_C(0x7FBF21EC8A1F45EC),
  Q_UINT64_C(0x1725CABFCB045B00), Q_UINT64_C(0x964E915CD5E2B207), Q_UINT64_C(0x3E2B8BCBF016D66D),
  Q_UINT64_C(0xBE7444E39328A0AC), Q_UINT64_C(0xF85B2B4FBCDE44B7), Q_UINT64_C(0x49353FEA39BA63B1),
  Q_UINT64_C(0x1DD01AAFCD53486A), Q_UINT64_C(0x1FCA8A92FD719F85), Q_UINT64_C(0xFC7C95D827357AFA),
  Q_UINT64_C(0x18A6A990C8B35EBD), Q_UINT64_C(0xCCCB7005C6B9C28D), Q_UINT64_C(0x3BDBB92C43B17F26),
  Q_UINT64_C(0xAA70B5B4F89695A2), Q_UINT64_C(0xE94C39A54A98307F), Q_UINT64_C(0xB7A0B174CFF6F36E),
  Q_UINT64_C(0xD4DBA84729AF48AD), Q_UINT64_C(0x2E18BC1AD9704A68), Q_UINT64_C(0x2DE0966DAF2F8B1C),
  Q_UINT64_C(0xB9C11D5B1E43A07E), Q_UINT64_C(0x64972D68DEE33360), Q_UINT64_C(0x94628D38D0C20584),
  Q_UINT64_C(0xDBC0D2B6AB90A559), Q_UINT64_C(0xD2733C4335C6A72F), Q_UINT64_C(0x7E75D99D94A70F4D),
  Q_UINT64_C(0x6CED1983376FA72B), Q_UINT64_C(0x97FCAACBF030BC24), Q_UINT64_C(0x7B77497B32503B12),
  Q_UINT64_C(0x8547EDDFB81CCB94), Q_UINT64_C(0x79999CDFF70902CB), Q_UINT64_C(0xCFFE1939438E9B24),
  Q_UINT64_C(0x829626E3892D95D7), Q_UINT64_C(0x92FAE24291F2B3F1), Q_UINT64_C(0x63E22C147B9C3403),
  Q_UINT64_C(0xC678B6D860284A1C), Q_UINT64_C(0x5873888850659AE7), Q_UINT64_C(0x0981DCD296A8736D),
  Q_UINT64_C(0x9F65789A6509A440), Q_UINT64_C(0x9FF38FED72E9052F), Q_UINT64_C(0xE479EE5B9930578C),
  Q_UINT64_C(0xE7F28ECD2D49EECD), Q_UINT64_C(0x56C074A581EA17FE), Q_UINT64_C(0x5544F7D774B14AEF),
  Q_UINT64_C(0x7B3F0195FC6F290F), Q_UINT64_C(0x12153635B2C0CF57), Q_UINT64_C(0x7F5126DBBA5E0CA7),
  Q_UINT64_C(0x7A76956C3EAFB413), Q_UINT64_C(0x3D5774A11D31AB39), Q_UINT64_C(0x8A1B083821F40CB4),
  Q_UINT64_C(0x7B4A38E32537DF62), Q_UINT64_C(0x950113646D1D6E03), Q_UINT64_C(0x4DA8979A0041E8A9),
  Q_UINT64_C(0x3BC36E078F7515D7), Q_UINT64_C(0x5D0A12F27AD310D1), Q_UINT64_C(0x7F9D1A2E1EBE1327),
  Q_UINT64_C(0xDA3A361B1C5157B1), Q_UINT64_C(0xDCDD7D20903D0C25), Q_UINT64_C(0x36833336D068F707),
  Q_UINT64_C(0xCE68341F79893389), Q_UINT64_C(0xAB9090168DD05F34), Q_UINT64_C(0x43954B3252DC25E5),
  Q_UINT64_C(0xB438C2B67F98E5E9), Q_UINT64_C(0x10DCD78E3851A492), Q_UINT64_C(0xDBC27AB5447822BF),
  Q_UINT64_C(0x9B3CDB65F82CA382), Q_UINT64_C(0xB67B7896167B4C84), Q_UINT64_C(0xBFCED1B0048EAC50),
  Q_UINT64_C(0xA9119B60369FFEBD), Q_UINT64_C(0x1FFF7AC80904BF45), Q_UINT64_C(0xAC12FB171817EEE7),
  Q_UINT64_C(0xAF08DA9177DDA93D), Q_UINT64_C(0x1B0CAB936E65C744), Q_UINT64_C(0xB559EB1D04E5E932),
  Q_UINT64_C(0xC37B45B3F8D6F2BA), Q_UINT64_C(0xC3A9DC228CAAC9E9), Q_UINT64_C(0xF3B8B6675A6507FF),
  Q_UINT64_C(0x9FC477DE4ED681DA), Q_UINT64_C(0x67378D8ECCEF96CB), Q_UINT64_C(0x6DD856D94D259236),
  Q_UINT64_C(0xA319CE15B0B4DB31), Q_UINT64_C(0x073973751F12DD5E), Q_UINT64_C(0x8A8E849EB32781A5),
  Q_UINT64_C(0xE1925C71285279F5), Q_UINT64_C(0x74C04BF1790C0EFE), Q_UINT64_C(0x4DDA48153C94938A),
  Q_UINT64_C(0x9D266D6A1CC0542C), Q_UINT64_C(0x7440FB816508C4FE), Q_UINT64_C(0x13328503DF48229F),
  Q_UINT64_C(0xD6BF7BAEE43CAC40), Q_UINT64_C(0x4838D65F6EF6748F), Q_UINT64_C(0x1E152328F3318DEA),
  Q_UINT64_C(0x8F8419A348F296BF), Q_UINT64_C(0x72C8834A5957B511), Q_UINT64_C(0xD7A023A73260B45C),
  Q_UINT64_C(0x94EBC8ABCFB56DAE), Q_UINT64_C(0x9FC10D0F989993E0), Q_UINT64_C(0xDE68A2355B93CAE6),
  Q_UINT64_C(0xA44CFE79AE538BBE), Q_UINT64_C(0x9D1D84FCCE371425), Q_UINT64_C(0x51D2B1AB2DDFB636),
  Q_UINT64_C(0x2FD7E4B9E72CD38C), Q_UINT64_C(0x65CA5B96B7552210), Q_UINT64_C(0xDD69A0D8AB3B546D),
  Q_UINT64_C(0x604D51B25FBF70E2), Q_UINT64_C(0x73AA8A564FB7AC9E), Q_UINT64_C(0x1A8C1E992B941148),
  Q_UINT64_C(0xAAC40A2703D9BEA0), Q_UINT64_C(0x764DBEAE7FA4F3A6), Q_UINT64_C(0x1E99B96E70A9BE8B),
  Q_UINT64_C(0x2C5E9DEB57EF4743), Q_UINT64_C(0x3A938FEE32D29981), Q_UINT64_C(0x26E6DB8FFDF5ADFE),
  Q_UINT64_C(0x469356C504EC9F9D), Q_UINT64_C(0xC8763C5B08D1908C), Q_UINT64_C(0x3F6C6AF859D80055),
  Q_UINT64_C(0x7F7CC39420A3A545), Q_UINT64_C(0x9BFB227EBDF4C5CE), Q_UINT64_C(0x89039D79D6FC5C5C),
  Q_UINT64_C(0x8FE88B57305E2AB6), Q_UINT64_C(0xA09E8C8C35AB96DE), Q_UINT64_C(0xFA7E393983325753),
  Q_UINT64_C(0xD6B6D0ECC617C699), Q_UINT64_C(0xDFEA21EA9E7557E3), Q_UINT64_C(0xB67C1FA481680AF8),
  Q_UINT64_C(0xCA1E3785A9E724E5), Q_UINT64_C(0x1CFC8BED0D681639), Q_UINT64_C(0xD18D8549D140CAEA),
  Q_UINT64_C(0x4ED0FE7E9DC91335), Q_UINT64_C(0xE4DBF0634473F5D2), Q_UINT64_C(0x1761F93A44D5AEFE),
  Q_UINT64_C(0x53898E4C3910DA55), Q_UINT64_C(0x734DE8181F6EC39A), Q_UINT64_C(0x2680B122BAA28D97),
  Q_UINT64_C(0x298AF231C85BAFAB), Q_UINT64_C(0x7983EED3740847D5), Q_UINT64_C(0x66C1A2A1A60CD889),
  Q_UINT64_C(0x9E17E49642A3E4C1), Q_UINT64_C(0xEDB454E7BADC0805), Q_UINT64_C(0x50B704CAB602C329),
  Q_UINT64_C(0x4CC317FB9CDDD023), Q_UINT64_C(0x66B4835D9EAFEA22), Q_UINT64_C(0x219B97E26FFC81BD),
  Q_UINT64_C(0x261E4E4C0A333A9D), Q_UINT64_C(0x1FE2CCA76517DB90), Q_UINT64_C(0xD7504DFA8816EDBB),
  Q_UINT64_C(0xB9571FA04DC089C8), Q_UINT64_C(0x1DDC0325259B27DE), Q_UINT64_C(0xCF3F4688801EB9AA),
  Q_UINT64_C(0xF4F5D05C10CAB243), Q_UINT64_C(0x38B6525C21A42B0E), Q_UINT64_C(0x36F60E2BA4FA6800),
  Q_UINT64_C(0xEB3593803173E0CE), Q_UINT64_C(0x9C4CD6257C5A3603), Q_UINT64_C(0xAF0C317D32ADAA8A),
  Q_UINT64_C(0x258E5A80C7204C4B), Q_UINT64_C(0x8B889D624D44885D), Q_UINT64_C(0xF4D14597E660F855),
  Q_UINT64_C(0xD4347F66EC8941C3), Q_UINT64_C(0xE699ED85B0DFB40D), Q_UINT64_C(0x2472F6207C2D0484),
  Q_UINT64_C(0xC2A1E7B5B459AEB5), Q_UINT64_C(0xAB4F6451CC1D45EC), Q_UINT64_C(0x63767572AE3D6174),
  Q_UINT64_C(0xA59E0BD101731A28), Q_UINT64_C(0x116D0016CB948F09), Q_UINT64_C(0x2CF9C8CA052F6E9F),
  Q_UINT64_C(0x0B090A7560A968E3), Q_UINT64_C(0xABEEDDB2DDE06FF1), Q_UINT64_C(0x58EFC10B06A2068D),
  Q_UINT64_C(0xC6E57A78FBD986E0), Q_UINT64_C(0x2EAB8CA63CE802D7), Q_UINT64_C(0x14A195640116F336),
  Q_UINT64_C(0x7C0828DD624EC390), Q_UINT64_C(0xD74BBE77E6116AC7), Q_UINT64_C(0x804456AF10F5FB53),
  Q_UINT64_C(0xEBE9EA2ADF4321C7), Q_UINT64_C(0x03219A39EE587A30), Q_UINT64_C(0x49787FEF17AF9924),
  Q_UINT64_C(0xA1E9300CD8520548), Q_UINT64_C(0x5B45E522E4B1B4EF), Q_UINT64_C(0xB49C3B3995091A36),
  Q_UINT64_C(0xD4490AD526F14431), Q_UINT64_C(0x12A8F216AF9418C2), Q_UINT64_C(0x001F837CC7350524),
  Q_UINT64_C(0x1877B51E57A764D5), Q_UINT64_C(0xA2853B80F17F58EE), Q_UINT64_C(0x993E1DE72D36D310),
  Q_UINT64_C(0xB3598080CE64A656), Q_UINT64_C(0x252F59CF0D9F04BB), Q_UINT64_C(0xD23C8E176D113600),
  Q_UINT64_C(0x1BDA0492E7E4586E), Q_UINT64_C(0x21E0BD5026C619BF), Q_UINT64_C(0x3B097ADAF088F94E),
  Q_UINT64_C(0x8D14DEDB30BE846E), Q_UINT64_C(0xF95CFFA23AF5F6F4), Q_UINT64_C(0x3871700761B3F743),
  Q_UINT64_C(0xCA672B91E9E4FA16), Q_UINT64_C(0x64C8E531BFF53B55), Q_UINT64_C(0x241260ED4AD1E87D),
  Q_UINT64_C(0x106C09B972D2E822), Q_UINT64_C(0x7FBA195410E5CA30), Q_UINT64_C(0x7884D9BC6CB569D8),
  Q_UINT64_C(0x0647DFEDCD894A29), Q_UINT64_C(0x63573FF03E224774), Q_UINT64_C(0x4FC8E9560F91B123),
  Q_UINT64_C(0x1DB956E450275779), Q_UINT64_C(0xB8D91274B9E9D4FB), Q_UINT64_C(0xA2EBEE47E2FBFCE1),
  Q_UINT64_C(0xD9F1F30CCD97FB09), Q_UINT64_C(0xEFED53D75FD64E6B), Q_UINT64_C(0x2E6D02C36017F67F),
  Q_UINT64_C(0xA9AA4D20DB084E9B), Q_UINT64_C(0xB64BE8D8B25396C1), Q_UINT64_C(0x70CB6AF7C2D5BCF0),
  Q_UINT64_C(0x98F076A4F7A2322E), Q_UINT64_C(0xBF84470805E69B5F), Q_UINT64_C(0x94C3251F06F90CF3),
  Q_UINT64_C(0x3E003E616A6591E9), Q_UINT64_C(0xB925A6CD0421AFF3), Q_UINT64_C(0x61BDD1307C66E300),
  Q_UINT64_C(0xBF8D5108E27E0D48), Q_UINT64_C(0x240AB57A8B888B20), Q_UINT64_C(0xFC87614BAF287E07),
  Q_UINT64_C(0xEF02CDD06FFDB432), Q_UINT64_C(0xA1082C0466DF6C0A), Q_UINT64_C(0x8215E577001332C8),
  Q_UINT64_C(0xD39BB9C3A48DB6CF), Q_UINT64_C(0x2738259634305C14), Q_UINT64_C(0x61CF4F94C97DF93D),
  Q_UINT64_C(0x1B6BACA2AE4E125B), Q_UINT64_C(0x758F450C88572E0B), Q_UINT64_C(0x959F587D507A8359),
  Q_UINT64_C(0xB063E962E045F54D), Q_UINT64_C(0x60E8ED72C0DFF5D1), Q_UINT64_C(0x7B64978555326F9F),
  Q_UINT64_C(0xFD080D236DA814BA), Q_UINT64_C(0x8C90FD9B083F4558), Q_UINT64_C(0x106F72FE81E2C590),
  Q_UINT64_C(0x7976033A39F7D952), Q_UINT64_C(0xA4EC0132764CA04B), Q_UINT64_C(0x733EA705FAE4FA77),
  Q_UINT64_C(0xB4D8F77BC3E56167), Q_UINT64_C(0x9E21F4F903B33FD9), Q_UINT64_C(0x9D765E419FB69F6D),
  Q_UINT64_C(0xD30C088BA61EA5EF), Q_UINT64_C(0x5D94337FBFAF7F5B), Q_UINT64_C(0x1A4E4822EB4D7A59),
  Q_UINT64_C(0x6FFE73E81B637FB3), Q_UINT64_C(0xDDF957BC36D8B9CA), Q_UINT64_C(0x64D0E29EEA8838B3),
  Q_UINT64_C(0x08DD9BDFD96B9F63), Q_UINT64_C(0x087E79E5A57D1D13), Q_UINT64_C(0xE328E230E3E2B3FB),
  Q_UINT64_C(0x1C2559E30F0946BE), Q_UINT64_C(0x720BF5F26F4D2EAA), Q_UINT64_C(0xB0774D261CC609DB),
  Q_UINT64_C(0x443F64EC5A371195), Q_UINT64_C(0x4112CF68649A260E), Q_UINT64_C(0xD813F2FAB7F5C5CA),
  Q_UINT64_C(0x660D3257380841EE), Q_UINT64_C(0x59AC2C7873F910A3), Q_UINT64_C(0xE846963877671A17),
  Q_UINT64_C(0x93B633ABFA3469F8), Q_UINT64_C(0xC0C0F5A60EF4CDCF), Q_UINT64_C(0xCAF21ECD4377B28C),
  Q_UINT64_C(0x57277707199B8175), Q_UINT64_C(0x506C11B9D90E8B1D), Q_UINT64_C(0xD83CC2687A19255F),
  Q_UINT64_C(0x4A29C6465A314CD1), Q_UINT64_C(0xED2DF21216235097), Q_UINT64_C(0xB5635C95FF7296E2),
  Q_UINT64_C(0x22AF003AB672E811), Q_UINT64_C(0x52E762596BF68235), Q_UINT64_C(0x9AEBA33AC6ECC6B0),
  Q_UINT64_C(0x944F6DE09134DFB6), Q_UINT64_C(0x6C47BEC883A7DE39), Q_UINT64_C(0x6AD047C430A12104),
  Q_UINT64_C(0xA5B1CFDBA0AB4067), Q_UINT64_C(0x7C45D833AFF07862), Q_UINT64_C(0x5092EF950A16DA0B),
  Q_UINT64_C(0x9338E69C052B8E7B), Q_UINT64_C(0x455A4B4CFE30E3F5), Q_UINT64_C(0x6B02E63195AD0CF8),
  Q_UINT64_C(0x6B17B224BAD6BF27), Q_UINT64_C(0xD1E0CCD25BB9C169), Q_UINT64_C(0xDE0C89A556B9AE70),
  Q_UINT64_C(0x50065E535A213CF6), Q_UINT64_C(0x9C1169FA2777B874), Q_UINT64_C(0x78EDEFD694AF1EED),
  Q_UINT64_C(0x6DC93D9526A50E68), Q_UINT64_C(0xEE97F453F06791ED), Q_UINT64_C(0x32AB0EDB696703D3),
  Q_UINT64_C(0x3A6853C7E70757A7), Q_UINT64_C(0x31865CED6120F37D), Q_UINT64_C(0x67FEF95D92607890),
  Q_UINT64_C(0x1F2B1D1F15F6DC9C), Q_UINT64_C(0xB69E38A8965C6B65), Q_UINT64_C(0xAA9119FF184CCCF4),
  Q_UINT64_C(0xF43C732873F24C13), Q_UINT64_C(0xFB4A3D794A9A80D2), Q_UINT64_C(0x3550C2321FD6109C),
  Q_UINT64_C(0x371F77E76BB8417E), Q_UINT64_C(0x6BFA9AAE5EC05779), Q_UINT64_C(0xCD04F3FF001A4778),
  Q_UINT64_C(0xE3273522064480CA), Q_UINT64_C(0x9F91508BFFCFC14A), Q_UINT64_C(0x049A7F41061A9E60),
  Q_UINT64_C(0xFCB6BE43A9F2FE9B), Q_UINT64_C(0x08DE8A1C7797DA9B), Q_UINT64_C(0x8F9887E6078735A1),
  Q_UINT64_C(0xB5B4071DBFC73A66), Q_UINT64_C(0x230E343DFBA08D33), Q_UINT64_C(0x43ED7F5A0FAE657D),
  Q_UINT64_C(0x3A88A0FBBCB05C63), Q_UINT64_C(0x21874B8B4D2DBC4F), Q_UINT64_C(0x1BDEA12E35F6A8C9),
  Q_UINT64_C(0x53C065C6C8E63528), Q_UINT64_C(0xE34A1D250E7A8D6B), Q_UINT64_C(0xD6B04D3B7651DD7E),
  Q_UINT64_C(0x5E90277E7CB39E2D), Q_UINT64_C(0x2C046F22062DC67D), Q_UINT64_C(0xB10BB459132D0A26),
  Q_UINT64_C(0x3FA9DDFB67E2F199), Q_UINT64_C(0x0E09B88E1914F7AF), Q_UINT64_C(0x10E8B35AF3EEAB37),
  Q_UINT64_C(0x9EEDECA8E272B933), Q_UINT64_C(0xD4C718BC4AE8AE5F), Q_UINT64_C(0x81536D601170FC20),
  Q_UINT64_C(0x91B534F885818A06), Q_UINT64_C(0xEC8177F83F900978), Q_UINT64_C(0x190E714FADA5156E),
  Q_UINT64_C(0xB592BF39B0364963), Q_UINT64_C(0x89C350C893AE7DC1), Q_UINT64_C(0xAC042E70F8B383F2),
  Q_UINT64_C(0xB49B52E587A1EE60), Q_UINT64_C(0xFB152FE3FF26DA89), Q_UINT64_C(0x3E666E6F69AE2C15),
  Q_UINT64_C(0x3B544EBE544C19F9), Q_UINT64_C(0xE805A1E290CF2456), Q_UINT64_C(0x24B33C9D7ED25117),
  Q_UINT64_C(0xE74733427B72F0C1), Q_UINT64_C(0x0A804D18B7097475), Q_UINT64_C(0x57E3306D881EDB4F),
  Q_UINT64_C(0x4AE7D6A36EB5DBCB), Q_UINT64_C(0x2D8D5432157064C8), Q_UINT64_C(0xD1E649DE1E7F268B),
  Q_UINT64_C(0x8A328A1CEDFE552C), Q_UINT64_C(0x07A3AEC79624C7DA), Q_UINT64_C(0x84547DDC3E203C94),
  Q_UINT64_C(0x990A98FD5071D263), Q_UINT64_C(0x1A4FF12616EEFC89), Q_UINT64_C(0xF6F7FD1431714200),
  Q_UINT64_C(0x30C05B1BA332F41C), Q_UINT64_C(0x8D2636B81555A786), Q_UINT64_C(0x46C9FEB55D120902),
  Q_UINT64_C(0xCCEC0A73B49C9921), Q_UINT64_C(0x4E9D2827355FC492), Q_UINT64_C(0x19EBB029435DCB0F),
  Q_UINT64_C(0x4659D2B743848A2C), Q_UINT64_C(0x963EF2C96B33BE31), Q_UINT64_C(0x74F85198B05A2E7D),
  Q_UINT64_C(0x5A0F544DD2B1FB18), Q_UINT64_C(0x03727073C2E134B1), Q_UINT64_C(0xC7F6AA2DE59AEA61),
  Q_UINT64_C(0x352787BAA0D7C22F), Q_UINT64_C(0x9853EAB63B5E0B35), Q_UINT64_C(0xABBDCDD7ED5C0860),
  Q_UINT64_C(0xCF05DAF5AC8D77B0), Q_UINT64_C(0x49CAD48CEBF4A71E), Q_UINT64_C(0x7A4C10EC2158C4A6),
  Q_UINT64_C(0xD9E92AA246BF719E), Q_UINT64_C(0x13AE978D09FE5557), Q_UINT64_C(0x730499AF921549FF),
  Q_UINT64_C(0x4E4B705B92903BA4), Q_UINT64_C(0xFF577222C14F0A3A), Q_UINT64_C(0x55B6344CF97AAFAE),
  Q_UINT64_C(0xB862225B055B6960), Q_UINT64_C(0xCAC09AFBDDD2CDB4), Q_UINT64_C(0xDAF8E9829FE96B5F),
  Q_UINT64_C(0xB5FDFC5D3132C498), Q_UINT64_C(0x310CB380DB6F7503), Q_UINT64_C(0xE87FBB46217A360E),
  Q_UINT64_C(0x2102AE466EBB1148), Q_UINT64_C(0xF8549E1A3AA5E00D), Q_UINT64_C(0x07A69AFDCC42261A),
  Q_UINT64_C(0xC4C118BFE78FEAAE), Q_UINT64_C(0xF9F4892ED96BD438), Q_UINT64_C(0x1AF3DBE25D8F45DA),
  Q_UINT64_C(0xF5B4B0B0D2DEEEB4), Q_UINT64_C(0x962ACEEFA82E1C84), Q_UINT64_C(0x046E3ECAAF453CE9),
  Q_UINT64_C(0xF05D129681949A4C), Q_UINT64_C(0x964781CE734B3C84), Q_UINT64_C(0x9C2ED44081CE5FBD),
  Q_UINT64_C(0x522E23F3925E319E), Q_UINT64_C(0x177E00F9FC32F791), Q_UINT64_C(0x2BC60A63A6F3B3F2),
  Q_UINT64_C(0x222BBFAE61725606), Q_UINT64_C(0x486289DDCC3D6780), Q_UINT64_C(0x7DC7785B8EFDFC80),
  Q_UINT64_C(0x8AF38731C02BA980), Q_UINT64_C(0x1FAB64EA29A2DDF7), Q_UINT64_C(0xE4D9429322CD065A),
  Q_UINT64_C(0x9DA058C67844F20C), Q_UINT64_C(0x24C0E332B70019B0), Q_UINT64_C(0x233003B5A6CFE6AD),
  Q_UINT64_C(0xD586BD01C5C217F6), Q_UINT64_C(0x5E5637885F29BC2B), Q_UINT64_C(0x7EBA726D8C94094B),
  Q_UINT64_C(0x0A56A5F0BFE39272), Q_UINT64_C(0xD79476A84EE20D06), Q_UINT64_C(0x9E4C1269BAA4BF37),
  Q_UINT64_C(0x17EFEE45B0DEE640), Q_UINT64_C(0x1D95B0A5FCF90BC6), Q_UINT64_C(0x93CBE0B699C2585D),
  Q_UINT64_C(0x65FA4F227A2B6D79), Q_UINT64_C(0xD5F9E858292504D5), Q_UINT64_C(0xC2B5A03F71471A6F),
  Q_UINT64_C(0x59300222B4561E00), Q_UINT64_C(0xCE2F8642CA0712DC), Q_UINT64_C(0x7CA9723FBB2E8988),
  Q_UINT64_C(0x2785338347F2BA08), Q_UINT64_C(0xC61BB3A141E50E8C), Q_UINT64_C(0x150F361DAB9DEC26),
  Q_UINT64_C(0x9F6A419D382595F4), Q_UINT64_C(0x64A53DC924FE7AC9), Q_UINT64_C(0x142DE49FFF7A7C3D),
  Q_UINT64_C(0x0C335248857FA9E7), Q_UINT64_C(0x0A9C32D5EAE45305), Q_UINT64_C(0xE6C42178C4BBB92E),
  Q_UINT64_C(0x71F1CE2490D20B07), Q_UINT64_C(0xF1BCC3D275AFE51A), Q_UINT64_C(0xE728E8C83C334074),
  Q_UINT64_C(0x96FBF83A12884624), Q_UINT64_C(0x81A1549FD6573DA5), Q_UINT64_C(0x5FA7867CAF35E149),
  Q_UINT64_C(0x56986E2EF3ED091B), Q_UINT64_C(0x917F1DD5F8886C61), Q_UINT64_C(0xD20D8C88C8FFE65F),
  Q_UINT64_C(0x31D71DCE64B2C310), Q_UINT64_C(0xF165B587DF898190), Q_UINT64_C(0xA57E6339DD2CF3A0),
  Q_UINT64_C(0x1EF6E6DBB1961EC9), Q_UINT64_C(0x70CC73D90BC26E24), Q_UINT64_C(0xE21A6B35DF0C3AD7),
  Q_UINT64_C(0x003A93D8B2806962), Q_UINT64_C(0x1C99DED33CB890A1), Q_UINT64_C(0xCF3145DE0ADD4289),
  Q_UINT64_C(0xD0E4427A5514FB72), Q_UINT64_C(0x77C621CC9FB3A483), Q_UINT64_C(0x67A34DAC4356550B),
  Q_UINT64_C(0xF8D626AAAF278509)
};

//const int RANDOM_PIECE = 0xFE;
const int RANDOM_CASTLE = 768;
const int RANDOM_EN_PASSENT = 772;
const int RANDOM_TURN = 780;

typedef std::bitset<sizeof(uint8_t)*8> IntBits;

Board::Board() {

    //qDebug() << "MAIN cons";
    this->turn = WHITE;
    for(int i=0;i<120;i++) {
        this->board[i] = EMPTY_POS[i];
        this->old_board[i] = 0xFF;
    }
    this->castling_rights = 0;
    this->en_passent_target = 0;
    this->halfmove_clock = 0;
    this->fullmove_number = 1;
    this->undo_available = false;
    this->last_was_null = false;
    this->prev_halfmove_clock = 0;
    this->transpositionTable = QMap<quint64, int>();
    this->update_transposition_table();
}

/*
Board::Board(Board *b) {
    this->turn = b->turn;
    this->castling_rights = 0;
    this->en_passent_target = 0;
    this->halfmove_clock = 0;
    this->fullmove_number = 1;
    this->undo_available = false;
    for(int i=0;i<120;i++) {
        this->board[i] = b->board[i];
    }
    this->last_was_null = false;
    this->prev_halfmove_clock = 0;
    this->transpositionTable = QMap<quint64, int>();
    this->update_transposition_table();
}*/

Board::Board(bool initial_position) {
    //qDebug() << "bool cons";
    this->turn = WHITE;
    if(initial_position) {
        for(int i=0;i<120;i++) {
            this->board[i] = chess::INIT_POS[i];
            this->old_board[i] = 0xFF;
        }
        this->castling_rights = 0x0F;
    } else {
        for(int i=0;i<120;i++) {
            this->board[i] = EMPTY_POS[i];
        }
        this->castling_rights = 0;
    }
    this->en_passent_target = 0;
    this->halfmove_clock = 0;
    this->fullmove_number = 1;
    this->undo_available = false;
    this->last_was_null = false;
    this->prev_halfmove_clock = 0;
    this->transpositionTable = QMap<quint64, int>();
    this->update_transposition_table();
}

bool Board::is_initial_position() {
    if(!this->turn == WHITE) {
        return false;
    }
    for(int i=0;i<120;i++) {
        if(this->board[i] != chess::INIT_POS[i]) {
            return false;
        }
    }
    if(this->castling_rights != 0x0F) {
        return false;
    }
    if(this->en_passent_target != 0) {
        return false;
    }
    if(this->halfmove_clock != 0) {
        return false;
    }
    if(this->fullmove_number != 1) {
        return false;
    }
    if(this->undo_available) {
        return false;
    }
    return true;
}

// returns 0 if no e.p. field in current position
uint8_t Board::get_ep_target() {
    return this->en_passent_target;
}


// returns 'empty' if c is no valid piece symbol in
// fen notation
uint8_t Board::piece_from_symbol(QChar c) {
    if(c == QChar('K')) {
        return 0x06;
    }
    if(c == QChar('Q')) {
        return 0x05;
    }
    if(c == QChar('R')) {
        return 0x04;
    }
    if(c == QChar('B')) {
        return 0x03;
    }
    if(c == QChar('N')) {
        return 0x02;
    }
    if(c == QChar('P')) {
        return 0x01;
    }
    if(c == QChar('k')) {
        return 0x86;
    }
    if(c == QChar('q')) {
        return 0x85;
    }
    if(c == QChar('r')) {
        return 0x84;
    }
    if(c == QChar('b')) {
        return 0x83;
    }
    if(c == QChar('n')) {
        return 0x82;
    }
    if(c == QChar('p')) {
        return 0x81;
    }
    return 0x00;
}

void Board::set_piece_at(int x, int y, uint8_t piece) {
    // check wether x,y is a valid location on chess board
    // and wether piece is a valid piece
    if(x>=0 && x<8 && y>=0 && y <8 &&
            ((piece >= 0x01 && piece <= 0x07) ||  // white piece
             (piece >= 0x81 && piece <= 0x87) || (piece == 0x00))) { // black piece or empty
        int idx = ((y+2)*10) + (x+1);
        this->board[idx] = piece;
    } else {
        throw std::invalid_argument("called set_piece_at with invalid paramters");
    }
}

uint8_t Board::get_piece_at(int x, int y) {
    if(x>=0 && x<8 && y>=0 && y <8) {
        int idx = ((y+2)*10) + (x+1);
        return this->board[idx];
    } else {
        throw std::invalid_argument("called get_piece_at with invalid paramters");
    }
}

uint8_t Board::get_piece_type_at(int x, int y) {
    if(x>=0 && x<8 && y>=0 && y <8) {
        int idx = ((y+2)*10) + (x+1);
        uint8_t piece = this->board[idx];
        if(piece >= 0x80) {
            return piece - 0x80;
        } else {
            return piece;
        }
    } else {
        throw std::invalid_argument("called get_piece_type_at with invalid paramters");
    }
}

bool Board::get_piece_color_at(int x, int y) {
    if(x>=0 && x<8 && y>=0 && y <8) {
        int idx = ((y+2)*10) + (x+1);
        return this->piece_color(idx);
    } else {
        throw std::invalid_argument("called get_piece_color_at with invalid paramters");
    }
}


// returns 'empty' if c is no valid piece symbol in
// fen notation
QChar Board::piece_to_symbol(uint8_t piece) {
    if(piece == 0x06) {
        return QChar('K');
    }
    if(piece == 0x05) {
        return QChar('Q');
    }
    if(piece == 0x04) {
        return QChar('R');
    }
    if(piece == 0x03) {
        return QChar('B');
    }
    if(piece == 0x02) {
        return QChar('N');
    }
    if(piece == 0x01) {
        return QChar('P');
    }
    if(piece == 0x86) {
        return QChar('k');
    }
    if(piece == 0x85) {
        return QChar('q');
    }
    if(piece == 0x84) {
        return QChar('r');
    }
    if(piece == 0x83) {
        return QChar('b');
    }
    if(piece == 0x82) {
        return QChar('n');
    }
    if(piece == 0x81) {
        return  QChar('p');
    }
    throw std::invalid_argument("called piece to symbol, but square contains no piece!");
}

Board::Board(const QString &fen_string) {
    //qDebug() << "FEN cons";
    for(int i=0;i<120;i++) {
        this->board[i] = EMPTY_POS[i];
        this->old_board[i] = 0xFF;
    }

    // check that we have six parts in fen, each separated by space
    // if last two parts are missing (fullmove no. + halfmove clock)
    // try to still parse the game
    QStringList fen_parts = fen_string.split(QChar(' '));
    //qDebug() << fen_parts.join(" <> ");
    if(fen_parts.size() < 4) {
        throw std::invalid_argument("fen: parts missing 6 fen parts");
    }
    // check that the first part consists of 8 rows, each sep. by /
    QStringList rows = fen_parts.at(0).split(QChar('/'));
    if(rows.size() != 8) {
        throw std::invalid_argument("fen: not 8 rows in 0th part");
    }
    // check that in each row, there are no two consecutive digits
    for(int i=0;i<rows.size();i++) {
        QString row = rows.at(i);
        int field_sum = 0;
        bool previous_was_digit = false;
        for(int j=0;j<row.size();j++) {
            QChar rj = row.at(j);
            QChar rjl = rj.toLower();
            if(rj == QChar('1') || rj == QChar('2') || rj == QChar('3') || rj == QChar('4')
                    || rj == QChar('5') || rj == QChar('6') || rj == QChar('7') || rj == QChar('8')) {
                if(previous_was_digit) {
                    throw std::invalid_argument("fen: two consecutive digits in rows");
                } else {
                    field_sum += rj.digitValue();
                    previous_was_digit = true;
                }
            } else if(rjl == QChar('p') || rjl == QChar('n') || rjl == QChar('b')
                      || rjl == QChar('r') || rjl == QChar('q') || rjl == QChar('k')) {
                field_sum += 1;
                previous_was_digit = false;
            } else {
                throw std::invalid_argument("fen: two consecutive chars in rows");
            }
        }
        // validate that there are 8 alphanums in each row
        if(field_sum != 8) {
            throw std::invalid_argument("fen: field sum is not 8");
        }
    }
    // check that turn part is valid
    if(!(fen_parts.at(1) == QString("w") || fen_parts.at(1) == QString("b"))) {
        throw std::invalid_argument("turn part is invalid");
    }
    // check that castles part in correctly encoded using regex
    QRegularExpressionMatch match = FEN_CASTLES_REGEX.match(fen_parts[2]);
    if(!match.hasMatch()) {
        throw std::invalid_argument("castles encoding is invalid");
    }
    // check correct encoding of en passent squares
    if(fen_parts.at(3) != QChar('-')) {
        if(fen_parts.at(1) == QChar('w')) {
            // should be something like "e6" etc. if white is to move
            // check that int value part is sixth rank
            if(fen_parts.at(3).size() != 2 || fen_parts.at(3).at(1) != QChar('6')) {
                throw std::invalid_argument("invalid e.p. encoding (white to move)");
            }
        } else {
            if(fen_parts.at(3).size() != 2 || fen_parts.at(3).at(1) != QChar('3')) {
                throw std::invalid_argument("invalid e.p. encoding (black to move)");
            }
        }
    }
    // half-move counter validity (if half-move is present)
    if((fen_parts.size() >= 5) && fen_parts.at(4).toInt() < 0) {
        throw std::invalid_argument("negative half move clock or not a number");
    }
    // full move number validity (if full move number is present)
    if((fen_parts.size() >= 6) && fen_parts.at(5).toInt() < 0) {
        throw std::invalid_argument("fullmove number not positive");
    }
    // set pieces
    for(int i=0;i<rows.size();i++) {
        int square_index = 91 - (i*10);
        QString row = rows.at(i);
        for(int j=0;j<row.size();j++) {
            QChar rj = row.at(j);
            QChar rjl = rj.toLower();
            if(rj == QChar('1') || rj == QChar('2') || rj == QChar('3') || rj == QChar('4')
                    || rj == QChar('5') || rj == QChar('6') || rj == QChar('7') || rj == QChar('8')) {
                square_index += rj.digitValue();
            } else if(rjl == QChar('p') || rjl == QChar('n') || rjl == QChar('b')
                      || rjl == QChar('r') || rjl == QChar('q') || rjl == QChar('k')) {
                uint8_t piece = this->piece_from_symbol(rj);
                this->board[square_index] = piece;
                square_index += 1;
            }
        }
    }
    // set turn
    if(fen_parts.at(1) == QString("w")) {
        this->turn = WHITE;
    }
    if(fen_parts.at(1) == QString("b")) {
        this->turn = BLACK;
    }
    this->castling_rights = 0x00;
    for(int i=0;i<fen_parts.at(2).size();i++) {
        QChar ci = fen_parts.at(2).at(i);
        if(ci == QChar('K')) {
            this->set_castle_wking(true);
        }
        if(ci == QChar('Q')) {
            this->set_castle_wqueen(true);
        }
        if(ci == QChar('k')) {
            this->set_castle_bking(true);
        }
        if(ci == QChar('q')) {
            this->set_castle_bqueen(true);
        }
    }
    // set en passent square
    if(fen_parts.at(3) == QString('-')) {
        this->en_passent_target = 0;
    } else {
        int row = 10 + (fen_parts.at(3).at(1).digitValue() * 10);
        int col = 0;
        QChar c = fen_parts.at(3).at(0).toLower();
        if(c == 'a') {
            col = 1;
        }
        if(c == 'b') {
            col = 2;
        }
        if(c == 'c') {
            col = 3;
        }
        if(c == 'd') {
            col = 4;
        }
        if(c == 'e') {
            col = 5;
        }
        if(c == 'f') {
            col = 6;
        }
        if(c == 'g') {
            col = 7;
        }
        if(c == 'h') {
            col = 8;
        }
        this->en_passent_target = row + col;
    }
    if(fen_parts.size() >= 5) {
        this->halfmove_clock = fen_parts.at(4).toInt();
    } else {
        this->halfmove_clock = 0;
    }
    if(fen_parts.size() >= 6) {
        this->fullmove_number = fen_parts.at(5).toInt();
    } else {
        this->fullmove_number = 1;
    }
    this->undo_available = false;
    this->last_was_null = false;
    if(!this->is_consistent()) {
        throw std::invalid_argument("board position from supplied fen is inconsistent");
    }
    this->transpositionTable = QMap<quint64, int>();
    this->update_transposition_table();
}

QString Board::idx_to_str(int idx) {
    if(idx<21 || idx>98) {
        throw std::invalid_argument("called idx_to_str but idx is in fringe!");
    } else {
        QChar row = QChar ((idx / 10) + 47);
        QChar col = QChar ((idx % 10) + 96);
        QString str = "";
        str.append(col);
        str.append(row);
        return str;
    }
}

QString Board::fen() {
    // first build board
    QString fen_string = QString("");
    for(int i=90;i>=20;i-=10) {
        int square_counter = 0;
        for(int j=1;j<9;j++) {
            if(this->board[i+j] != 0x00) {
                uint8_t piece = this->board[i+j];
                fen_string.append(this->piece_to_symbol(piece));
                square_counter = 0;
            } else {
                square_counter += 1;
                if(j==8) {
                    fen_string.append(QChar((char) (48+square_counter)));
                } else {
                    if(this->board[i+j+1] != 0x00) {
                        fen_string.append(QChar((char) (48+square_counter)));
                    }
                }
            }
        }
        if(i!=20) {
            fen_string.append(QChar('/'));
        }
    }
    // write turn
    if(this->turn == WHITE) {
        fen_string.append(" w");
    } else {
        fen_string.append(" b");
    }
    // write castling rights
    if(this->castling_rights == 0x00) {
        fen_string.append(" -");
    } else {
        fen_string.append(' ');
        if(this->can_castle_wking()) {
            fen_string.append(('K'));
        }
        if(this->can_castle_wqueen()) {
            fen_string.append(('Q'));
        }
        if(this->can_castle_bking()) {
            fen_string.append(('k'));
        }
        if(this->can_castle_bqueen()) {
            fen_string.append(('q'));
        }
    }
    // write ep target if exists
    if(this->en_passent_target != 0x00) {
        fen_string.append(" "+this->idx_to_str(this->en_passent_target));
    } else {
        fen_string.append(" -");
    }
    // add halfmove clock and fullmove counter
    fen_string.append(" ").append(QString::number(this->halfmove_clock));
    fen_string.append(" ").append(QString::number(this->fullmove_number));
    return fen_string;
}


bool Board::can_castle_wking() {
    IntBits cstle = IntBits(this->castling_rights);
    if(cstle.test(CASTLE_WKING_POS)) {
        return true;
    } else {
        return false;
    }
}

bool Board::can_castle_bking() {
    IntBits cstle = IntBits(this->castling_rights);
    if(cstle.test(CASTLE_BKING_POS)) {
        return true;
    } else {
        return false;
    }
}

bool Board::can_castle_wqueen() {
    IntBits cstle = IntBits(this->castling_rights);
    if(cstle.test(CASTLE_WQUEEN_POS)) {
        return true;
    } else {
        return false;
    }
}

bool Board::can_castle_bqueen() {
    IntBits cstle = IntBits(this->castling_rights);
    if(cstle.test(CASTLE_BQUEEN_POS)) {
        return true;
    } else {
        return false;
    }
}

void Board::set_castle_wking(bool can_do) {
    IntBits cstle = IntBits(this->castling_rights);
    if(can_do) {
        cstle.set(CASTLE_WKING_POS);
    } else {
        cstle.reset(CASTLE_WKING_POS);
    }
    this->castling_rights = static_cast<uint8_t>(cstle.to_ulong());
}

void Board::set_castle_bking(bool can_do) {
    IntBits cstle = IntBits(this->castling_rights);
    if(can_do) {
        cstle.set(CASTLE_BKING_POS);
    } else {
        cstle.reset(CASTLE_BKING_POS);
    }
    this->castling_rights = static_cast<uint8_t>(cstle.to_ulong());
}

void Board::set_castle_wqueen(bool can_do) {
    IntBits cstle = IntBits(this->castling_rights);
    if(can_do) {
        cstle.set(CASTLE_WQUEEN_POS);
    } else {
        cstle.reset(CASTLE_WQUEEN_POS);
    }
    this->castling_rights = static_cast<uint8_t>(cstle.to_ulong());
}

void Board::set_castle_bqueen(bool can_do) {
    IntBits cstle = IntBits(this->castling_rights);
    if(can_do) {
        cstle.set(CASTLE_BQUEEN_POS);
    } else {
        cstle.reset(CASTLE_BQUEEN_POS);
    }
    this->castling_rights = static_cast<uint8_t>(cstle.to_ulong());
}

QVector<Move> Board::pseudo_legal_moves() {
    return this->pseudo_legal_moves_from(0,true,this->turn);
}

QVector<Move> Board::pseudo_legal_moves(uint8_t to_square, uint8_t piece_type) {
    if(piece_type == KING) {
        return this->pseudo_legal_moves_from_pt(0, to_square, piece_type, true,this->turn);
    } else {
        return this->pseudo_legal_moves_from_pt(0, to_square, piece_type, false,this->turn);
    }
}

bool Board::castles_wking(const Move &m) {
    if(this->piece_type(m.from) == KING && this->piece_color(m.from) == WHITE &&
            m.from == E1 && m.to == G1) {
        return true;
    } else {
        return false;
    }
}


bool Board::castles_wqueen(const Move &m) {
    if(this->piece_type(m.from) == KING && this->piece_color(m.from) == WHITE &&
            m.from == E1 && m.to == C1) {
        return true;
    } else {
        return false;
    }
}


bool Board::castles_bking(const Move &m) {
    if(this->piece_type(m.from) == KING && this->piece_color(m.from) == BLACK &&
            m.from == E8 && m.to == G8) {
        return true;
    } else {
        return false;
    }
}

bool Board::castles_bqueen(const Move &m) {
    if(this->piece_type(m.from) == KING && this->piece_color(m.from) == BLACK &&
            m.from == E8 && m.to == C8) {
        return true;
    } else {
        return false;
    }
}

// to get legal moves, just get list of pseudo
// legals and then filter by checking each move's
// legality
QVector<Move> Board::legal_moves() {
    QVector<Move> pseudo_legals = this->pseudo_legal_moves();
    QVector<Move> legals; // approx 40 legal moves in every pos?!
    for(int i=0;i<pseudo_legals.size();i++) {
        Move m = pseudo_legals.at(i);
        if(this->pseudo_is_legal_move(m)) {
            legals.append(m);
        }
    }
    return legals;
}

// to speed up san parsing, check here
// only moves where destination is hit.
QVector<Move> Board::legal_moves(uint8_t to_square, uint8_t piece_type) {
    QVector<Move> pseudo_legals = this->pseudo_legal_moves(to_square, piece_type);
    QVector<Move> legals;
    for(int i=0;i<pseudo_legals.size();i++) {
        Move m = pseudo_legals.at(i);
        if(m.to == to_square) {
            if(this->pseudo_is_legal_move(m)) {
                legals.append(m);
            }
        }
    }
    return legals;
}

QVector<Move> Board::legal_moves_from(int from_square) {
    QVector<Move> pseudo_legals = this->pseudo_legal_moves_from(from_square, true,this->turn);
    QVector<Move> legals;
    for(int i=0;i<pseudo_legals.size();i++) {
        Move m = pseudo_legals.at(i);
        if(this->pseudo_is_legal_move(m)) {
            legals.append(m);
        }
    }
    return legals;
}

bool Board::is_legal_and_promotes(const Move &m) {
    QVector<Move> legals = this->legal_moves_from(m.from);
    for(int i=0;i<legals.size();i++) {
        Move mi = legals.at(i);
        if(mi.from == m.from && mi.to == m.to && mi.promotion_piece != 0) {
            return true;
        }
    }
    return false;
}

bool Board::is_legal_move(const Move &m) {
    QVector<Move> pseudo_legals = this->pseudo_legal_moves_from(m.from, true,this->turn);
    for(int i=0;i<pseudo_legals.size();i++) {
        Move mi = pseudo_legals.at(i);
        if(mi == m && this->pseudo_is_legal_move(m)) {
            return true;
        }
    }
    return false;
}

bool Board::pseudo_is_legal_move(const Move &m) {
    // a pseudo legal move is a legal move if
    // a) doesn't put king in check
    // b) if castle, must ensure that 1) king is not currently in check
    //                                2) castle over squares are not in check
    //                                3) doesn't castle into check
    // first find color of mover
    bool color = this->piece_color(m.from);
    // find king with that color
    for(int i= 21;i<99;i++) {
        if(this->piece_type(i) == KING && this->piece_color(i) == color) {
            // if the move is not by the king
            if(i!=m.from) {
                // apply the move, check if king is attacked, and decide
                bool legal = false;
                this->apply(m);
                legal = !this->is_attacked(i,!color);
                this->undo();
                return legal;
            } else {
                // means we move the king
                // first check castle cases
                if(this->castles_wking(m)) {
                    if(!this->is_attacked(E1,BLACK) && !this->is_attacked(F1,BLACK)
                            && !this->is_attacked(G1,BLACK)) {
                        bool legal = false;
                        this->apply(m);
                        legal = !this->is_attacked(G1,BLACK);
                        this->undo();
                        return legal;
                    } else {
                        return false;
                    }
                }
                if(this->castles_bking(m)) {
                    if(!this->is_attacked(E8,WHITE) && !this->is_attacked(F8,WHITE)
                            && !this->is_attacked(G8,WHITE)) {
                        bool legal = false;
                        this->apply(m);
                        legal = !this->is_attacked(G8,WHITE);
                        this->undo();
                        return legal;
                    } else {
                        return false;
                    }
                }
                if(this->castles_wqueen(m)) {
                    if(!this->is_attacked(E1,BLACK) && !this->is_attacked(D1,BLACK)
                            && !this->is_attacked(C1,BLACK) ) {
                        bool legal = false;
                        this->apply(m);
                        legal = !this->is_attacked(C1,BLACK);
                        this->undo();
                        return legal;
                    } else {
                        return false;
                    }
                }
                if(this->castles_bqueen(m)) {
                    if(!this->is_attacked(E8,WHITE) && !this->is_attacked(D8,WHITE)
                            && !this->is_attacked(C8,WHITE) ) {
                        bool legal = false;
                        this->apply(m);
                        legal = !this->is_attacked(C8,WHITE);
                        this->undo();
                        return legal;
                    } else {
                        return false;
                    }
                }
                // if none of the castles cases triggered, we have a standard king move
                // just check if king isn't attacked after applying the move
                bool legal = false;
                this->apply(m);
                legal = !this->is_attacked(m.to,!color);
                this->undo();
                return legal;
            }
        }
    }
    return false;
}

// doesn't account for attacks via en-passent
bool Board::is_attacked(int idx, bool attacker_color) {
    // first check for potential pawn attackers
    // attacker color white, pawn must be white.
    // lower left
    if(attacker_color == WHITE && (this->board[idx-9]!=0xFF)
            && (this->piece_color(idx-9)==WHITE) && (this->piece_type(idx-9)==PAWN)) {
        return true;
    }
    // lower right
    if(attacker_color == WHITE && (this->board[idx-11]!=0xFF)
            && (this->piece_color(idx-11)==WHITE) && (this->piece_type(idx-11)==PAWN)) {
        return true;
    }
    // check black, upper right
    if(attacker_color == BLACK && (this->board[idx+11]!=0xFF)
            && (this->piece_color(idx+11)==BLACK) && (this->piece_type(idx+11)==PAWN)) {
        return true;
    }
    // check black, upper left
    if(attacker_color == BLACK && (this->board[idx+9]!=0xFF)
            && (this->piece_color(idx+9)==BLACK) && (this->piece_type(idx+9)==PAWN)) {
        return true;
    }
    // check all squares (except idx itself)
    // for potential attackers
    for(int i=21;i<99;i++) {
        // skip empty squares
        if(i!=idx && this->board[i] != 0x00) {
            // can't attack yourself
            if(this->piece_color(i) == attacker_color) {
                uint8_t piece = this->piece_type(i);
                int distance = idx - i;
                if(distance < 0) {
                    distance = -distance;
                }
                IntBits pot_attackers = IntBits(ATTACK_TABLE[distance]);
                if((piece == KNIGHT && pot_attackers.test(0)) ||
                        (piece == BISHOP && pot_attackers.test(1)) ||
                        (piece == ROOK && pot_attackers.test(2)) ||
                        (piece == QUEEN && pot_attackers.test(3)) ||
                        (piece == KING && pot_attackers.test(4))) {
                    // the target could be a potential attacker
                    // now just get all pseudo legal moves from i,
                    // excluding castling. If a move contains
                    // target idx, then we have an attacker
                    QVector<Move> targets = this->pseudo_legal_moves_from(i,false,attacker_color);
                    for(int j=0;j<targets.size();j++) {
                        if(targets.at(j).to == idx) {
                            return true;
                        }
                    }
                }
            }
        }
    }
    return false;
}

// calling with from_square = 0 means all possible moves
// will find all pseudo legal move for supplied player (turn must be
// either WHITE or BLACK)
QVector<Move> Board::pseudo_legal_moves_from(int from_square, bool with_castles, bool turn) {

    QVector<Move> moves;

    for(int i=21;i<99;i++) {
        if(from_square == 0 || from_square == i) {
            // skip offboard's left and right
            if(!(this->board[i] == 0xFF)) {
                // get piece type & color
                bool color = this->piece_color(i);
                if(color == turn) {
                    uint8_t piece = this->piece_type(i);
                    // handle case of PAWN
                    if(piece == PAWN) {
                        uint8_t piece_idx = IDX_WPAWN;
                        if(color == BLACK) {
                            piece_idx = IDX_BPAWN;
                        }
                        // take up right, or up left
                        for(int j=3;j<=4;j++) {
                            uint8_t idx = i + DIR_TABLE[piece_idx][j];
                            if(!this->is_offside(idx)) {
                                if((!this->is_empty(idx) && color==BLACK && this->is_white_at(idx)) ||
                                        (!this->is_empty(idx) && color==WHITE && !this->is_white_at(idx))) {
                                    // if it's a promotion square, add four moves
                                    if((color==WHITE && (idx / 10 == 9)) || (color==BLACK && (idx / 10 == 2))) {
                                        moves.append(Move(i,idx,QUEEN));
                                        moves.append(Move(i,idx,ROOK));
                                        moves.append(Move(i,idx,BISHOP));
                                        moves.append(Move(i,idx,KNIGHT));
                                    } else {
                                        moves.append(Move(i,idx));
                                    }
                                }
                            }
                        }
                        // move one (j=1) or two (j=2) up (or down in the case of black)
                        for(int j=1;j<=2;j++) {
                            uint8_t idx = i + DIR_TABLE[piece_idx][j];
                            if(!this->is_offside(idx)) {
                                if(j==2 && ((color == WHITE && (i/10==3)) || (color==BLACK && (i/10==8)))) {
                                    // means we have a white/black pawn in inital position, direct square
                                    // in front is empty => allow to move two forward
                                    if(this->is_empty(idx)) {
                                        moves.append(Move(i,idx));
                                    }
                                }
                                else if(j==1) {
                                    // case of one-step move forward
                                    if(!this->is_empty(idx)) {
                                        break;
                                    } else {
                                        // if it's a promotion square, add four moves
                                        if((color==WHITE && (idx / 10 == 9)) || (color==BLACK && (idx / 10 == 2))) {
                                            moves.append(Move(i,idx,QUEEN));
                                            moves.append(Move(i,idx,ROOK));
                                            moves.append(Move(i,idx,BISHOP));
                                            moves.append(Move(i,idx,KNIGHT));
                                        } else {
                                            moves.append(Move(i,idx));
                                        }
                                    }
                                }
                            }
                        }
                        // finally, potential en-passent capture is handled
                        // left up
                        if(color == WHITE && (this->en_passent_target - i)==9) {
                            Move m = (Move(i,this->en_passent_target));
                            moves.append(m);
                        }
                        // right up
                        if(color == WHITE && (this->en_passent_target - i)==11) {
                            Move m = (Move(i,this->en_passent_target));
                            moves.append(m);
                        }
                        // left down
                        if(color == BLACK && (this->en_passent_target - i)==-9) {
                            Move m = (Move(i,this->en_passent_target));
                            moves.append(m);
                        }
                        if(color == BLACK && (this->en_passent_target - i)==-11) {
                            Move m = (Move(i,this->en_passent_target));
                            moves.append(m);
                        }
                    }
                    // handle case of knight
                    if(piece == KNIGHT || piece == KING) {
                        int lookup_idx;
                        if(piece == KNIGHT) {
                            lookup_idx = IDX_KNIGHT;
                        } else {
                            lookup_idx = IDX_KING;
                        }
                        for(int j=1;j<=DIR_TABLE[lookup_idx][0];j++) {
                            uint8_t idx = i + DIR_TABLE[lookup_idx][j];
                            if(!this->is_offside(idx)) {
                                if(this->is_empty(idx) ||
                                        (this->piece_color(idx) != color)) {
                                    moves.append(Move(i,idx));
                                }
                            }
                        }
                    }
                    // handle case of bishop, rook, queen
                    if(piece == ROOK || piece == BISHOP || piece == QUEEN) {
                        int lookup_idx = IDX_ROOK;
                        if(piece == QUEEN) {
                            lookup_idx = IDX_QUEEN;
                        }
                        if(piece == BISHOP) {
                            lookup_idx = IDX_BISHOP;
                        }
                        for(int j=1;j<=DIR_TABLE[lookup_idx][0] ;j++) {
                            uint8_t idx = i + DIR_TABLE[lookup_idx][j];
                            bool stop = false;
                            while(!stop) {
                                if(!this->is_offside(idx)) {
                                    if(this->is_empty(idx)) {
                                        moves.append(Move(i,idx));
                                    } else {
                                        stop = true;
                                        if(this->piece_color(idx) != color) {
                                            moves.append(Move(i,idx));
                                        }
                                    }
                                    idx = idx + DIR_TABLE[lookup_idx][j];
                                } else {
                                    stop = true;
                                }
                            }
                        }
                    }
                }
            }
            if(with_castles) {
                if(this->turn == WHITE) {
                    // check for castling
                    // white kingside
                    if(i==E1 && !this->is_empty(E1) && this->can_castle_wking() &&
                            this->piece_color(E1) == WHITE && this->piece_color(H1) == WHITE
                            && this->piece_type(E1) == KING && this->piece_type(H1) == ROOK
                            && this->is_empty(F1) && this->is_empty(G1)) {
                        moves.append(Move(E1,G1));
                    }
                    // white queenside
                    if(i==E1 && !this->is_empty(E1) && this->can_castle_wqueen() &&
                            this->piece_color(E1) == WHITE && this->piece_color(A1) == WHITE
                            && this->piece_type(E1) == KING && this->piece_type(A1) == ROOK
                            && this->is_empty(D1) && this->is_empty(C1) && this->is_empty(B1)) {
                        moves.append(Move(E1,C1));
                    }
                }
                if(this->turn == BLACK) {
                    // black kingside
                    if(i==E8 && !this->is_empty(E8) && this->can_castle_bking() &&
                            this->piece_color(E8) == BLACK && this->piece_color(H8) == BLACK
                            && this->piece_type(E8) == KING && this->piece_type(H8) == ROOK
                            && this->is_empty(F8) && this->is_empty(G8)) {
                        moves.append(Move(E8,G8));
                    }
                    // black queenside
                    if(i==E8 && !this->is_empty(E8) && this->can_castle_bqueen() &&
                            this->piece_color(E8) == BLACK && this->piece_color(A8) == BLACK
                            && this->piece_type(E8) == KING && this->piece_type(A8) == ROOK
                            && this->is_empty(D8) && this->is_empty(C8) && this->is_empty(B8)) {
                        moves.append(Move(E8,C8));
                    }
                }
            }
        }
    }
    return moves;
}

// calling with from_square = 0 means all possible moves
// will find all pseudo legal move for supplied player (turn must be
// either WHITE or BLACK)
QVector<Move> Board::pseudo_legal_moves_from_pt(int from_square, uint8_t to_square,
                                         uint8_t piece_type, bool with_castles, bool turn) {
    QVector<Move> moves;

    for(int i=21;i<99;i++) {
        if(from_square == 0 || from_square == i) {
            // skip offboard's left and right
            if(!(this->board[i] == 0xFF)) {
                // get piece type & color
                bool color = this->piece_color(i);
                if(color == turn) {
                    uint8_t piece = this->piece_type(i);
                    // handle case of PAWN
                    if(piece == PAWN && piece_type == PAWN) {
                        uint8_t piece_idx = IDX_WPAWN;
                        if(color == BLACK) {
                            piece_idx = IDX_BPAWN;
                        }
                        // take up right, or up left
                        for(int j=3;j<=4;j++) {
                            uint8_t idx = i + DIR_TABLE[piece_idx][j];
                            if(idx == to_square && !this->is_offside(idx)) {
                                if((!this->is_empty(idx) && color==BLACK && this->is_white_at(idx)) ||
                                        (!this->is_empty(idx) && color==WHITE && !this->is_white_at(idx))) {
                                    // if it's a promotion square, add four moves
                                    if((color==WHITE && (idx / 10 == 9)) || (color==BLACK && (idx / 10 == 2))) {
                                        moves.append(Move(i,idx,QUEEN));
                                        moves.append(Move(i,idx,ROOK));
                                        moves.append(Move(i,idx,BISHOP));
                                        moves.append(Move(i,idx,KNIGHT));
                                    } else {
                                        moves.append(Move(i,idx));
                                    }
                                }
                            }
                        }
                        // move one (j=1) or two (j=2) up (or down in the case of black)
                        for(int j=1;j<=2;j++) {
                            uint8_t idx = i + DIR_TABLE[piece_idx][j];
                            if(!this->is_offside(idx)) {
                                if(j==2 && ((color == WHITE && (i/10==3)) || (color==BLACK && (i/10==8)))) {
                                    // means we have a white/black pawn in inital position, direct square
                                    // in front is empty => allow to move two forward
                                    if(this->is_empty(idx)) {
                                        moves.append(Move(i,idx));
                                    }
                                }
                                else if(j==1) {
                                    // case of one-step move forward
                                    if(!this->is_empty(idx)) {
                                        break;
                                    } else {
                                        // if it's a promotion square, add four moves
                                        if((color==WHITE && (idx / 10 == 9)) || (color==BLACK && (idx / 10 == 2))) {
                                            moves.append(Move(i,idx,QUEEN));
                                            moves.append(Move(i,idx,ROOK));
                                            moves.append(Move(i,idx,BISHOP));
                                            moves.append(Move(i,idx,KNIGHT));
                                        } else {
                                            moves.append(Move(i,idx));
                                        }
                                    }
                                }
                            }
                        }
                        // finally, potential en-passent capture is handled
                        // left up
                        if(color == WHITE && (this->en_passent_target - i)==9) {
                            Move m = (Move(i,this->en_passent_target));
                            moves.append(m);
                        }
                        // right up
                        if(color == WHITE && (this->en_passent_target - i)==11) {
                            Move m = (Move(i,this->en_passent_target));
                            moves.append(m);
                        }
                        // left down
                        if(color == BLACK && (this->en_passent_target - i)==-9) {
                            Move m = (Move(i,this->en_passent_target));
                            moves.append(m);
                        }
                        if(color == BLACK && (this->en_passent_target - i)==-11) {
                            Move m = (Move(i,this->en_passent_target));
                            moves.append(m);
                        }
                    }
                    // handle case of knight
                    if((piece == KNIGHT && piece_type == KNIGHT)|| (piece == KING && piece_type == KING)) {
                        int lookup_idx;
                        if(piece == KNIGHT) {
                            lookup_idx = IDX_KNIGHT;
                        } else {
                            lookup_idx = IDX_KING;
                        }
                        for(int j=1;j<=DIR_TABLE[lookup_idx][0];j++) {
                            uint8_t idx = i + DIR_TABLE[lookup_idx][j];
                            if(idx == to_square && !this->is_offside(idx)) {
                                if(this->is_empty(idx) ||
                                        (this->piece_color(idx) != color)) {
                                    moves.append(Move(i,idx));
                                }
                            }
                        }
                    }
                    // handle case of bishop, rook, queen
                    if((piece == ROOK && piece_type == ROOK) || (piece == BISHOP && piece_type == BISHOP)
                            || (piece == QUEEN && piece_type == QUEEN)) {
                        int lookup_idx = IDX_ROOK;
                        if(piece == QUEEN) {
                            lookup_idx = IDX_QUEEN;
                        }
                        if(piece == BISHOP) {
                            lookup_idx = IDX_BISHOP;
                        }
                        for(int j=1;j<=DIR_TABLE[lookup_idx][0] ;j++) {
                            uint8_t idx = i + DIR_TABLE[lookup_idx][j];
                            bool stop = false;
                            while(!stop) {
                                if(!this->is_offside(idx)) {
                                    if(this->is_empty(idx)) {
                                        if(to_square == idx) {
                                            moves.append(Move(i,idx));
                                        }
                                    } else {
                                        stop = true;
                                        if(this->piece_color(idx) != color) {
                                            if(to_square == idx) {
                                                moves.append(Move(i,idx));
                                            }
                                        }
                                    }
                                    idx = idx + DIR_TABLE[lookup_idx][j];
                                } else {
                                    stop = true;
                                }
                            }
                        }
                    }
                }
            }
            if(with_castles) {
                if(this->turn == WHITE) {
                    // check for castling
                    // white kingside
                    if(i==E1 && !this->is_empty(E1) && this->can_castle_wking() &&
                            this->piece_color(E1) == WHITE && this->piece_color(H1) == WHITE
                            && this->piece_type(E1) == KING && this->piece_type(H1) == ROOK
                            && this->is_empty(F1) && this->is_empty(G1)) {
                        moves.append(Move(E1,G1));
                    }
                    // white queenside
                    if(i==E1 && !this->is_empty(E1) && this->can_castle_wqueen() &&
                            this->piece_color(E1) == WHITE && this->piece_color(A1) == WHITE
                            && this->piece_type(E1) == KING && this->piece_type(A1) == ROOK
                            && this->is_empty(D1) && this->is_empty(C1) && this->is_empty(B1)) {
                        moves.append(Move(E1,C1));
                    }
                }
                if(this->turn == BLACK) {
                    // black kingside
                    if(i==E8 && !this->is_empty(E8) && this->can_castle_bking() &&
                            this->piece_color(E8) == BLACK && this->piece_color(H8) == BLACK
                            && this->piece_type(E8) == KING && this->piece_type(H8) == ROOK
                            && this->is_empty(F8) && this->is_empty(G8)) {
                        moves.append(Move(E8,G8));
                    }
                    // black queenside
                    if(i==E8 && !this->is_empty(E8) && this->can_castle_bqueen() &&
                            this->piece_color(E8) == BLACK && this->piece_color(A8) == BLACK
                            && this->piece_type(E8) == KING && this->piece_type(A8) == ROOK
                            && this->is_empty(D8) && this->is_empty(C8) && this->is_empty(B8)) {
                        moves.append(Move(E8,C8));
                    }
                }
            }
        }
    }
    return moves;
}

bool Board::movePromotes(const Move&m) {
    if(this->piece_type(m.from) == chess::PAWN) {
        if(this->piece_color(m.from) == chess::WHITE && ((m.to / 10)==9)) {
            return true;
        }
        if(this->piece_color(m.from) == chess::BLACK && ((m.to / 10)==2)) {
            return true;
        }
    }
    return false;
}


bool Board::piece_color(uint8_t idx) {
    IntBits piece = IntBits(this->board[idx]);
    if(piece.test(COLOR_FLAG) == WHITE) {
        return WHITE;
    } else {
        return BLACK;
    }
}

uint8_t Board::piece_type(uint8_t idx) {
    IntBits piece = IntBits(this->board[idx]);
    piece.set(7,0);
    return static_cast<uint8_t>(piece.to_ulong());
}

uint8_t Board::piece_at(uint8_t idx) {
    if(idx >= 21 && idx <= 98) {
        return this->board[idx];
    } else {
        throw std::invalid_argument("called get_piece_at with invalid paramters");
    }
}

// returns true if square is not empty
bool Board::is_empty(uint8_t idx) {
    if(this->board[idx] == 0x00) {
        return true;
    } else {
        return false;
    }
}


// returns true if square is in fringe
bool Board::is_offside(uint8_t idx) {
    if(this->board[idx] == 0xFF) {
        return true;
    } else {
        return false;
    }
}

bool Board::can_claim_fifty_moves() {
    return this->halfmove_clock >= 100;
}



// returns true (== Black) if not occupied!
bool Board::is_white_at(uint8_t idx) {
    IntBits square = IntBits(this->board[idx]);
    if(square.test(COLOR_FLAG)) {
        return false;
    } else {
        return true;
    }
}


// doesn't check legality
void Board::apply(const Move &m) {
    assert(m.promotion_piece <= 5);
    if(m.is_null) {
        //std::cout << "applying null move: " << m.uci_string.toStdString() << std::endl;
        //std::cout << (*this) << std::endl;
        this->turn = !this->turn;
        this->prev_en_passent_target = this->en_passent_target;
        this->en_passent_target = 0;
        this->last_was_null = true;
        this->undo_available = true;
    } else {
        this->last_was_null = false;
    this->turn = !this->turn;
    this->prev_en_passent_target = this->en_passent_target;
    this->prev_castling_rights = this->castling_rights;
    this->en_passent_target = 0;
    if(this->turn == WHITE) {
        this->fullmove_number++;
    }
    for(int i=0;i<120;i++) {
        this->old_board[i] = this->board[i];
    }
    uint8_t old_piece_type = this->piece_type(m.from);
    bool color = this->piece_color(m.from);
    // increase halfmove clock only if no capture or pawn advance
    // happended
    this->prev_halfmove_clock = this->halfmove_clock;
    if(old_piece_type == PAWN || this->board[m.to] != EMPTY) {
        this->halfmove_clock = 0;
    } else {
        this->halfmove_clock++;
    }
    // if we move a pawn two steps up, set the en_passent field
    if(old_piece_type == PAWN) {
        // white pawn moved two steps up
        if((m.to - m.from) == 20) {
            this->en_passent_target = m.from + 10;
        }
        // black pawn moved two steps up (down)
        if((m.to - m.from == -20)) {
            this->en_passent_target = m.from - 10;
        }
    }
    // if the move is an en-passent capture,
    // remove the (non-target) corresponding pawn
    // move is an en passent move, if
    // a) color is white, piece type is pawn, target
    // is up left or upright and empty
    // b) color is black, piece type is pawn, target
    // is down right or down left and empty
    // also set last_move_was_ep to true
    if(old_piece_type == PAWN) {
        if(this->board[m.to] == EMPTY) {
            if(color == WHITE && ((m.to-m.from == 9) || (m.to-m.from)==11)) {
                // remove captured pawn
                this->board[m.to-10] = 0x00;
            }
            if(color == BLACK && ((m.from -m.to == 9) || (m.from - m.to)==11)) {
                // remove captured pawn
                this->board[m.to+10] = 0x00;
            }
        }
    }
    // if the move is a promotion, the target
    // field becomes the promotion choice
    if(m.promotion_piece != EMPTY) {
        // true means black
        if(color == BLACK) {
            // +128 sets 7th bit to true (means black)
            this->board[m.to] = m.promotion_piece +128;
        }
        else {
            this->board[m.to] = m.promotion_piece;
        }
    } else {
        // otherwise the target is the piece on the from field
        this->board[m.to] = this->board[m.from];
    }
    this->board[m.from] = EMPTY;
    // check if the move is castles, i.e. 0-0 or 0-0-0
    // then we also need to move the rook
    // white kingside
    if(old_piece_type == KING) {
        if(color==WHITE) {
            if(m.from == E1 && m.to == G1) {
                this->board[F1] = this->board[H1];
                this->board[H1] = EMPTY;
                this->set_castle_wking(false);
            }
            // white queenside
            if(m.from == E1 && m.to == C1) {
                this->board[D1] = this->board[A1];
                this->board[A1] = EMPTY;
                this->set_castle_wqueen(false);
            } }
        else if(color==BLACK) {
            // black kingside
            if(m.from == E8 && m.to == G8) {
                this->board[F8] = this->board[H8];
                this->board[H8] = EMPTY;
                this->set_castle_bking(false);
            }
            // black queenside
            if(m.from == E8 && m.to == C8) {
                this->board[D8] = this->board[A8];
                this->board[A8] = EMPTY;
                this->set_castle_bqueen(false);
            }
        }
    }
    // check if someone loses castling rights
    // by moving king or by moving rook
    // or if one of the rooks is captured by the
    // opposite side
    if(color == WHITE) {
        if(old_piece_type == KING) {
            if(m.from == E1 && m.to !=G1) {
                this->set_castle_wking(false);
            }
            if(m.from == E1 && m.to != C1) {
                this->set_castle_wqueen(false);
            }
        }
        if(old_piece_type == ROOK) {
            if(m.from == A1) {
                this->set_castle_wqueen(false);
            }
            if(m.from == H1) {
                this->set_castle_wking(false);
            }
        }
        // white moves a piece to H8 or A8
        // means either white captures rook
        // or black has moved rook prev.
        // [even though: in the latter case, should be already
        // done by check above in prev. moves]
        if(m.to == H8) {
            this->set_castle_bking(false);
        }
        if(m.to == A8) {
            this->set_castle_bqueen(false);
        }
    }
    // same for black
    if(color == BLACK) {
        if(old_piece_type == KING) {
            if(m.from == E8 && m.to !=G8) {
                this->set_castle_bking(false);
            }
            if(m.from == E8 && m.to != C8) {
                this->set_castle_bqueen(false);
            }
        }
        if(old_piece_type == ROOK) {
            if(m.from == A8) {
                this->set_castle_bqueen(false);
            }
            if(m.from == H8) {
                this->set_castle_bking(false);
            }
        }
        // black moves piece to A1 or H1
        if(m.to == H1) {
            this->set_castle_wking(false);
        }
        if(m.to == A1) {
            this->set_castle_wqueen(false);
        }
    }
    // after move is applied, can revert to the previous position
    this->undo_available = true;
    // also update transposition table for 3fold repition detection
    //this->update_transposition_table();
    }
}

void Board::undo() {
    if(!this->undo_available) {
        throw std::logic_error("must call board.apply(move) each time before calling undo() ");

    } else {
        if(this->last_was_null) {
            this->turn = !this->turn;
            this->en_passent_target = this->prev_en_passent_target;
            this->prev_en_passent_target = 0;
            this->last_was_null = false;
            this->undo_available = true;
        } else {
            for(int i=0;i<120;i++) {
                this->board[i] = this->old_board[i];
            }
            this->undo_available = false;
            this->en_passent_target = this->prev_en_passent_target;
            this->prev_en_passent_target = 0;
            this->castling_rights = this->prev_castling_rights;
            this->turn = !this->turn;
            this->halfmove_clock = this->prev_halfmove_clock;
            this->prev_halfmove_clock = 0;
            if(this->turn == BLACK) {
                this->fullmove_number--;
            }
        }
    }
}

// doesn't check legality
/*
Board* Board::copy_and_apply(const Move &m) {
    Board *b = new Board();
    b->turn = this->turn;
    b->castling_rights = this->castling_rights;
    b->turn = this->turn;
    b->en_passent_target = this->en_passent_target;
    b->halfmove_clock = this->halfmove_clock;
    b->fullmove_number = this->fullmove_number;
    b->undo_available = this->undo_available;
    b->last_was_null = this->last_was_null;
    b->prev_halfmove_clock = this->prev_halfmove_clock;
    b->transpositionTable = QMap<quint64, int>(this->transpositionTable);
    for(int i=0;i<120;i++) {
        b->board[i] = this->board[i];
        b->old_board[i] = this->old_board[i];
    }
    b->apply(m);
    return b;
}
*/


Board::Board(const Board &other) {
    turn = other.turn;
    castling_rights = other.castling_rights;
    //turn = this->turn; ???
    en_passent_target = other.en_passent_target;
    halfmove_clock = other.halfmove_clock;
    fullmove_number = other.fullmove_number;
    undo_available = other.undo_available;
    last_was_null = other.last_was_null;
    prev_halfmove_clock = other.prev_halfmove_clock;
    transpositionTable = QMap<quint64, int>(other.transpositionTable);
    for(int i=0;i<120;i++) {
        board[i] = other.board[i];
        old_board[i] = other.old_board[i];
    }
    //qDebug() << "copy constructor called";
    //qDebug() << "copy constructor called; old board has nr: " << other.fullmove_number;
    //qDebug() << "copy constructor called; new board has nr: " << fullmove_number;
}

bool Board::is_stalemate() {
    // search for king of player with current turn
    // check whether king is attacked
    for(int i=21;i<99;i++) {
        if((this->piece_type(i)==KING) && (this->piece_color(i)==this->turn)){
            if(!this->is_attacked(i,!this->turn)) {
                QVector<Move> legals = this->legal_moves();
                int c = legals.count();
                if(c==0) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }
    return false;
}

bool Board::is_threefold_repetition() {
    quint64 current_zobrist = this->zobrist();
    if(this->transpositionTable.contains(current_zobrist)) {
        int cnt = this->transpositionTable.value(current_zobrist);
        return cnt >= 3;
    } else {
        return false;
    }
}

bool Board::is_checkmate() {
    // search for king of player with current turn
    // check whether king is attacked
    for(int i=21;i<99;i++) {
        if((this->piece_type(i)==KING) && (this->piece_color(i)==this->turn)){
            if(this->is_attacked(i,!this->turn)) {
                QVector<Move> legals = this->legal_moves();
                int c = legals.count();
                if(c==0) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }
    return false;
}

bool Board::is_check() {
    for(int i=21;i<99;i++) {
        if((this->piece_type(i)==KING) && (this->piece_color(i)==this->turn)){
            if(this->is_attacked(i,!this->turn)) {
                return true;
            } else {
                return false;
            }
        }
    }
    return false;
}


uint8_t Board::alpha_to_pos(QChar alpha) {
    if(alpha == QChar('A')) {
        return 1;
    } else if(alpha == QChar('B')) {
        return 2;
    } else if(alpha == QChar('C')) {
        return 3;
    } else if(alpha == QChar('D')) {
        return 4;
    } else if(alpha == QChar('E')) {
        return 5;
    } else if(alpha == QChar('F')) {
        return 6;
    } else if(alpha == QChar('G')) {
        return 7;
    } else if(alpha == QChar('H')) {
        return 8;
    }
    return 0;
}

// assumes supplied move is correct
// otherwise might mess up the whole
// current board
QString Board::san(const Move &m) {

    QString san = QString("");
    // first check for null move
    if(m.is_null) {
        san = QString("--");
        return san;
    }

    // first test for checkmate and check (to be appended later)
    // create temp board, since appyling move and
    // testing for checkmate (which again needs
    // application of a move) makes it impossible
    // to undo (undo can only be done once, not twice in a row)

    /*
    Board* b_temp = this->copy_and_apply(m);
    bool is_check = b_temp->is_check();
    bool is_checkmate = b_temp->is_checkmate();
    delete b_temp;
    */
    Board b_temp = Board(this);
    bool is_check = b_temp.is_check();
    bool is_checkmate = b_temp.is_checkmate();

    if(this->castles_wking(m) || this->castles_bking(m)) {
        san.append("O-O");
        if(is_checkmate) {
            san.append("#");
        }
        if(is_check) {
            san.append("+");
        }
        return san;
    } else if(this->castles_wqueen(m) || this->castles_bqueen(m)) {
        san.append("O-O-O");
        if(is_checkmate) {
            san.append("#");
        } else if(is_check) {
            san.append("+");
        }
        return san;
    } else {
        uint8_t piece_type = this->piece_type(m.from);
        QVector<Move> legals = this->legal_moves(m.to, piece_type);
        if(piece_type == KNIGHT) {
            san.append("N");
        }
        if(piece_type == BISHOP) {
            san.append("B");
        }
        if(piece_type == ROOK) {
            san.append("R");
        }
        if(piece_type == QUEEN) {
            san.append("Q");
        }
        if(piece_type == KING) {
            san.append("K");
        }
        QVector<Move> col_disambig;
        QVector<Move> row_disambig;
        int this_row = (m.from / 10) - 1;
        int this_col = m.from % 10;

        // find amibguous moves (except for pawns)
        if(piece_type != PAWN) {
            for(int i=0;i<legals.count();i++) {
                Move mi = legals.at(i);
                if(this->piece_type(mi.from) == piece_type && mi.to == m.to && mi.from != m.from) {
                    // found pontential amibg. move
                    if((mi.from % 10) != this_col) {
                        // can be resolved via row
                        col_disambig.append(mi);
                    } else { // otherwise resolve by col
                        row_disambig.append(mi);
                    }
                }
            }
            int cnt_col_disambig = col_disambig.count();
            //cout << "ambig cols: " << +cnt_col_disambig << endl;
            int cnt_row_disambig = row_disambig.count();
            //cout << "ambig rows: " << +cnt_row_disambig << endl;
            // if there is an ambiguity
            if(cnt_col_disambig != 0 || cnt_row_disambig != 0) {
                // preferred way: resolve via column
                if(cnt_col_disambig>0 && cnt_row_disambig==0) {
                    san.append(QChar(this_col + 96));
                    // if not try to resolve via row
                } else if(cnt_row_disambig>0 && cnt_col_disambig==0) {
                    san.append(QChar(this_row + 48));
                } else {
                    // if that also fails (think three queens)
                    // resolve via full coordinate
                    san.append(QChar(this_col + 96));
                    san.append(QChar(this_row + 48));
                }
            }
        }
        // handle a capture, i.e. if destination field
        // is not empty
        // in case of an en-passent capture, the destiation field
        // is empty. But then the destination field is the e.p. square
        if(this->piece_type(m.to) != EMPTY || m.to == this->en_passent_target) {
            if(piece_type == PAWN) {
                san.append(QChar(this_col + 96));
            }
            san.append(QString("x"));
        }
        //qDebug() << "calling idx to str: ";
        //qDebug() << "san append: " << m.to;
        //qDebug() << m.uci_string;
        //qDebug() << "--";
        san.append(this->idx_to_str(m.to));
        if(m.promotion_piece == KNIGHT) {
            san.append(("=N"));
        }
        if(m.promotion_piece == BISHOP) {
            san.append(("=B"));
        }
        if(m.promotion_piece == ROOK) {
            san.append(("=R"));
        }
        if(m.promotion_piece == QUEEN) {
            san.append(("=Q"));
        }
    }
    if(is_checkmate) {
        san.append("#");
    } else if(is_check) {
        san.append("+");
    }
    return san;
}

Move Board::parse_san(QString san) {

    // first check if null move
    if(san==QString("--")) {
        Move m = Move();
        return m;
    }

    Move m = Move(0,0);

    // check for castling moves
    if(san==QString("O-O") || san == QString("O-O+") || san==QString("O-O#")) {
        uint8_t to = G1;
        if(this->turn == BLACK) {
            to = G8;
        }
        QVector<Move> legals = this->legal_moves(to, KING);
        for(int i=0;i<legals.count();i++) {
            Move m = legals.at(i);
            if(this->castles_wking(m)) {
                return Move(E1,G1);
            } else if(this->castles_bking(m)) {
                return Move(E8,G8);
            }
        }
        throw std::invalid_argument("invalid san / ambiguous: "+san.toStdString());
    } else if(san==QString("O-O-O") || san == QString("O-O-O+") || san==QString("O-O-O#")) {
        //qDebug() << "castles long";
        uint8_t to = C1;
        if(this->turn == BLACK) {
            to = C8;
        }
        QVector<Move> legals = this->legal_moves(to, KING);
        for(int i=0;i<legals.count();i++) {
            Move m = legals.at(i);
            if(this->castles_wqueen(m)) {
                return Move(E1,C1);
            } else if(this->castles_bqueen(m)) {
                return Move(E8,C8);
            }
        }
        throw std::invalid_argument("invalid san / ambiguous: "+san.toStdString());
    } else { // we don't have a castles move
        QRegularExpressionMatch match = SAN_REGEX.match(san);
        if(!match.hasMatch()) {
            throw std::invalid_argument("invalid san: "+san.toStdString());
        }
        // get target square
        QString str_target = match.captured(4).toUpper();
        uint8_t target_col = this->alpha_to_pos(str_target.at(0));
        // -49 for ascii(1) -> int 0
        uint8_t target_row = (uint8_t) ((str_target.at(1).toLatin1()-49)+1);
        uint8_t target = ((target_row+1) * 10)+target_col;

        // get promotion piece
        QString str_prom = match.captured(5);
        if(!str_prom.isNull()) {
            //std::cout << match.captured(5).toStdString() << std::endl;
            if(match.captured(5)==QString("=N")) {
                m.promotion_piece = KNIGHT;
            } else if(match.captured(5)==QString("=B")) {
                m.promotion_piece = BISHOP;
            } else if(match.captured(5)==QString("=R")) {
                m.promotion_piece = ROOK;
            } else if(match.captured(5)==QString("=Q")) {
                m.promotion_piece = QUEEN;
            } else {
                throw std::invalid_argument("invalid san / promotion: "+match.captured(5).toStdString());
            }
            //if(this->turn == BLACK) {
            //    m.promotion_piece += 0x80;
            //}  NO: promotion piece _only_ encodes piece, _not_ color
        }
        // get piece type
        uint8_t piece_type = 0;
        if(match.captured(1) == QString("B")) {
            piece_type = BISHOP;
        } else if(match.captured(1) == QString("N")) {
            piece_type = KNIGHT;
        } else if(match.captured(1) == QString("R")) {
            piece_type = ROOK;
        } else if(match.captured(1) == QString("Q")) {
            piece_type = QUEEN;
        } else if(match.captured(1) == QString("K")) {
            piece_type = KING;
        } else {
            piece_type = PAWN;
        }

        QVector<Move> legals = this->legal_moves(target, piece_type);

        // get target square
        uint8_t src_col = 0;
        uint8_t src_row = 0;
        QString str_amb_col = match.captured(2).toUpper();
        if(!str_amb_col.isNull()) {
            src_col = this->alpha_to_pos(str_amb_col.at(0));
        }
        QString str_amb_row = match.captured(3).toUpper();
        if(!str_amb_row.isNull()) {
            src_row = (uint8_t) ((str_amb_row.at(0).toLatin1()-49) +1);
        }

        if(m.promotion_piece!=0) {
            //std::cout << "is WHITE: " << +(this->turn==WHITE) << std::endl;
        }
        // filter all moves
        QVector<Move> lgl_piece;
        for(int i=0;i<legals.count();i++) {
            Move mi = legals.at(i);
            if(m.promotion_piece!=0) {
             //std::cout << mi.uci().toStdString() << std::endl;
             //std::cout << "  mi: " << +mi.promotion_piece << std::endl;
             //std::cout << "  m: " << +m.promotion_piece << std::endl;
            }
            uint8_t mi_row = (mi.from / 10) - 1;
            uint8_t mi_col = mi.from % 10;
            if(target == mi.to && this->piece_type(mi.from) == piece_type
                    && mi.promotion_piece == m.promotion_piece) {
                if(src_col == 0 && src_row == 0) {
                    lgl_piece.append(mi);
                } else if(src_col !=0 && src_row ==0 && mi_col == src_col) {
                    lgl_piece.append(mi);
                } else if(src_col ==0 && src_row !=0 && mi_row == src_row) {
                    lgl_piece.append(mi);
                } else if(src_col !=0 && src_row !=0 && mi_row == src_row && mi_col == src_col) {
                    lgl_piece.append(mi);
                }
            }
        }
        if(m.promotion_piece != 0 && lgl_piece.count() > 1) {
            //std::cout << "there are too many moves!" << std::endl;
        }

        // now lgl_piece should contain only one move, since
        // all ambigiuous have been filtered. otherwise san is wrong
        if(lgl_piece.count() > 1 || lgl_piece.count() == 0) {
            //std::cout << *this << std::endl;
            //std::cout << +this->fullmove_number << std::endl;
            throw std::invalid_argument("invalid san / ambiguous: "+san.toStdString() + " " + QString::number(piece_type).toStdString() + " "+QString::number(target).toStdString());
        } else {
            Move mi = lgl_piece.at(0);
            m.from = mi.from;
            m.to = mi.to;
            m.promotion_piece = mi.promotion_piece;
            m.uci_string = mi.uci_string;
        }
    }
    return m;
}

/**
 * @brief Board::is_black_castle_right_lost
 * @return true if black king and kingside rook
 *         are on initial position, false otherwise
 *         i.e. checks the _possibility_ whether
 *         castling could be possible (to check consistency when
 *         entering a board position)
 *         to call board status, use can_castle_* functions
 */
bool Board::is_black_king_castle_right_lost() {
    if(this->board[E8] == BLACK_KING &&
            this->board[H8] == BLACK_ROOK) {
        return false;
    } else {
        return true;
    }
}

bool Board::is_black_queen_castle_right_lost() {
    if(this->board[E8] == BLACK_KING &&
            this->board[A8] == BLACK_ROOK) {
        return false;
    } else {
        return true;
    }
}

bool Board::is_white_king_castle_right_lost() {
    if(this->board[E1] == WHITE_KING &&
            this->board[H1] == WHITE_ROOK) {
        return false;
    } else {
        return true;
    }
}

bool Board::is_white_queen_castle_right_lost() {
    if(this->board[E1] == WHITE_KING &&
            this->board[A1] == WHITE_ROOK) {
        return false;
    } else {
        return true;
    }
}

bool Board::is_consistent() {
    int white_king_pos = -1;
    int black_king_pos = -1;

    int cnt_white_king = 0;
    int cnt_black_king = 0;

    int cnt_white_queens = 0;
    int cnt_white_rooks = 0;
    int cnt_white_bishops = 0;
    int cnt_white_knights = 0;
    int cnt_white_pawns = 0;

    int cnt_black_queens = 0;
    int cnt_black_rooks = 0;
    int cnt_black_bishops = 0;
    int cnt_black_knights = 0;
    int cnt_black_pawns = 0;

    for(int i=21;i<99;i++) {
        uint8_t piece_type = this->piece_type(i);
        bool piece_color = this->piece_color(i);
        if(piece_type != EMPTY) {
            if(piece_type == KING) {
                if(piece_color == WHITE) {
                    white_king_pos = i;
                    cnt_white_king++;
                } else {
                    black_king_pos = i;
                    cnt_black_king++;
                }
            } else if(piece_type == QUEEN) {
                if(piece_color == WHITE) {
                    cnt_white_queens++;
                } else {
                    cnt_black_queens++;
                }
            } else if(piece_type == ROOK) {
                if(piece_color == WHITE) {
                    cnt_white_rooks++;
                } else {
                    cnt_black_rooks++;
                }
            } else if(piece_type == BISHOP) {
                if(piece_color == WHITE) {
                    cnt_white_bishops++;
                } else {
                    cnt_black_bishops++;
                }
            } else if(piece_type == KNIGHT) {
                if(piece_color == WHITE) {
                    cnt_white_knights++;
                } else {
                    cnt_black_knights++;
                }
            } else if(piece_type == PAWN) {
                if(piece_color == WHITE) {
                    if((i / 10) == 2) { // white pawn in first rank
                        return false;
                    } else {
                        cnt_white_pawns++;
                    }
                } else {
                    if((i / 10) == 9) { // black pawn in 8th rank
                        return false;
                    } else {
                        cnt_black_pawns++;
                    }
                }
            }
        }
    }
    // exactly one white and black king exist on board
    if(white_king_pos < 21 || white_king_pos >= 99
            || black_king_pos < 21 || black_king_pos >= 99
            || cnt_white_king != 1 || cnt_black_king != 1) {
        //qDebug() << "kings not present";
        return false;
    }
    // white and black king at least on field apart
    int larger = white_king_pos;
    int smaller = black_king_pos;
    if(black_king_pos > white_king_pos) {
        larger = black_king_pos;
        smaller = white_king_pos;
    }
    int diff = larger - smaller;
    if(diff == 10 || diff == 1 || diff == 11 || diff == 9) {
        //qDebug() << "diff check";
        return false;
    }
    // side not to move must not be in check
    bool not_to_move = !this->turn;
    bool to_move = this->turn;
    int idx_king_not_to_move = white_king_pos;
    if(not_to_move == BLACK) {
        idx_king_not_to_move = black_king_pos;
    }
    if(this->is_attacked(idx_king_not_to_move, to_move)) {
        //qDebug() << "is attacked";
        return false;
    }
    // each side has 8 pawns or less
    if(cnt_white_pawns > 8 || cnt_black_pawns > 8) {
        //qDebug() << "pawn count";
        return false;
    }
    // check whether no. of promotions and pawn count fits for white
    int white_extra_pieces = std::max(0, cnt_white_queens-1) + std::max(0, cnt_white_rooks-2)
            + std::max(0, cnt_white_bishops - 2) + std::max(0, cnt_white_knights - 2);
    if(white_extra_pieces > (8-cnt_white_pawns)) {
        //qDebug() << "promotions and pawns, white";
        return false;
    }
    // ... for black
    int black_extra_pieces = std::max(0, cnt_black_queens-1) + std::max(0, cnt_black_rooks-2)
            + std::max(0, cnt_black_bishops - 2) + std::max(0, cnt_black_knights - 2);
    if(black_extra_pieces > (8-cnt_black_pawns)) {
        //qDebug() << "promotions and pawns, black";
        return false;
    }
    // compare encoded castling rights of this board w/ actual
    // position of king and rook
    if(this->can_castle_wking() && this->is_white_king_castle_right_lost()) {
        //qDebug() << "castling wking";
        return false;
    }
    if(this->can_castle_wqueen() && this->is_white_queen_castle_right_lost()) {
        //qDebug() << "castling wqueen";
        return false;
    }
    if(this->can_castle_bking() && this->is_black_king_castle_right_lost()) {
        //qDebug() << "castling bking";
        return false;
    }
    if(this->can_castle_bqueen() && this->is_black_queen_castle_right_lost()) {
        //qDebug() << "castling bqueen";
        return false;
    }
    return true;
}


/*
 * \brief operator <<
 * \param strm
 * \param b
 * \return stream prints board representation into stream
 */
/**
 * @brief operator <<
 * @param strm
 * @param b
 * @return
 *
 * prints board as ascii output.
 *
 * Example:
 * Board b();
 * std::cout << b << std::endl;
 *
 */
std::ostream& operator<<(std::ostream &strm, const Board &b) {
    for(uint8_t i=90;i>=20;i-=10) {
        for(uint8_t j=1;j<=9;j++) {
            //uint8_t piece = b.piece_type(i+j);
            IntBits piece = IntBits(b.board[i+j]);
            bool color = WHITE;
            if(piece.test(COLOR_FLAG) == WHITE) {
                color = WHITE;
            } else {
                color = BLACK;
            }
            piece.set(3,0);
            piece.set(4,0);
            piece.set(7,0);
            if(piece == PAWN) {
                if(color == WHITE) {
                    strm << "P ";
                }
                else {
                    strm << "p ";
                }
            }
            if(piece == KNIGHT) {
                if(color == WHITE) {
                    strm << "N ";
                }
                else {
                    strm << "n ";
                }
            }
            if(piece == BISHOP) {
                if(color == WHITE) {
                    strm << "B ";
                }
                else {
                    strm << "b ";
                }
            }
            if(piece == ROOK) {
                if(color == WHITE) {
                    strm << "R ";
                }
                else {
                    strm << "r ";
                }
            }
            if(piece == QUEEN) {
                if(color == WHITE) {
                    strm << "Q ";
                }
                else {
                    strm << "q ";
                }
            }
            if(piece == KING) {
                if(color == WHITE) {
                    strm << "K ";
                }
                else {
                    strm << "k ";
                }
            }
            if(b.en_passent_target == (i+j)) {
                strm << ": ";
            } else if(piece == EMPTY) {
                strm << ". ";
            }
        }
        strm << std::endl;
    }
    return strm;
}

int Board::zobrist_piece_type(uint8_t piece) {
    switch (piece)
    {
        case BLACK_PAWN:
            return 0;
        case WHITE_PAWN:
            return 1;
        case BLACK_KNIGHT:
            return 2;
        case WHITE_KNIGHT:
            return 3;
        case BLACK_BISHOP:
            return 4;
        case WHITE_BISHOP:
            return 5;
        case BLACK_ROOK:
            return 6;
        case WHITE_ROOK:
            return 7;
        case BLACK_QUEEN:
            return 8;
        case WHITE_QUEEN:
            return 9;
        case BLACK_KING:
            return 10;
        case WHITE_KING:
            return 11;
    }
    throw std::invalid_argument("piece type out of range in ZobristHash:kind_of_piece");
}

void Board::update_transposition_table() {
    quint64 current_zobrist = this->zobrist();
    if(this->transpositionTable.contains(current_zobrist)) {
        int cnt = this->transpositionTable.value(current_zobrist);
        this->transpositionTable.insert(current_zobrist, cnt+1);
    } else {
        this->transpositionTable.insert(current_zobrist, 1);
    }
}

quint64 Board::zobrist() {
    Board *b = this;
    quint64 piece = Q_UINT64_C(0);
    for(int i=0;i<8;i++) {
        for(int j=0;j<8;j++) {
            uint8_t piece_at_ij = b->get_piece_at(i,j);
            if(piece_at_ij != EMPTY) {
                int kind_of_piece = this->zobrist_piece_type(piece_at_ij);
                int offset_piece = 64 * kind_of_piece + 8 * j + i;
                piece = piece^POLYGLOT_RANDOM_64[offset_piece];
            }
        }
    }
    //std::cout << "pieces:" << std::endl;
    //std::cout << std::hex << piece << std::endl;
    quint64 en_passent = Q_UINT64_C(0);
    uint8_t ep_target = b->get_ep_target();
    if(ep_target != 0) {
        int file = (ep_target % 10) - 1;
        //qDebug() << file;
        //qDebug() << "eptarget: "<< ep_target;
        // check if left or right is a pawn from player to move
        if(b->turn == WHITE) {
            uint8_t left = b->piece_at(ep_target-11);
            uint8_t right = b->piece_at(ep_target-9);
            if(left == WHITE_PAWN || right == WHITE_PAWN) {
                //qDebug() << "white";
                en_passent = POLYGLOT_RANDOM_64[RANDOM_EN_PASSENT + file];
            }
        } else {
            uint8_t left = b->piece_at(ep_target+11);
            uint8_t right = b->piece_at(ep_target+9);
            if(left == BLACK_PAWN || right == BLACK_PAWN) {
                //qDebug() << "black";
                en_passent = POLYGLOT_RANDOM_64[RANDOM_EN_PASSENT + file];
            }
        }
    }
    //std::cout << "ep:" << std::endl;
    //std::cout << std::hex << en_passent << std::endl;
    quint64 castle = Q_UINT64_C(0);
    if(b->can_castle_wking()) {
        castle = castle^POLYGLOT_RANDOM_64[RANDOM_CASTLE];
    }
    if(b->can_castle_wqueen()) {
        castle = castle^POLYGLOT_RANDOM_64[RANDOM_CASTLE+1];
    }
    if(b->can_castle_bking()) {
        castle = castle^POLYGLOT_RANDOM_64[RANDOM_CASTLE+2];
    }
    if(b->can_castle_bqueen()) {
        castle = castle^POLYGLOT_RANDOM_64[RANDOM_CASTLE+3];
    }
    //std::cout << "castle:" << std::endl;
    //std::cout << std::hex << castle << std::endl;
    quint64 turn = Q_UINT64_C(0);
    if(b->turn == WHITE) {
        turn = POLYGLOT_RANDOM_64[RANDOM_TURN];
    }
    //std::cout << "turn:" << std::endl;
    //std::cout << std::hex << turn << std::endl;
    quint64 key = piece^castle^en_passent^turn;
    return key;
}



}
