# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NonSqlMigrationTaskInput(Model):
    """Base class for non sql migration task input.

    All required parameters must be populated in order to send to Azure.

    :param target_connection_info: Required. Information for connecting to
     target
    :type target_connection_info:
     ~azure.mgmt.datamigration.models.SqlConnectionInfo
    :param target_database_name: Required. Target database name
    :type target_database_name: str
    :param project_name: Required. Name of the migration project
    :type project_name: str
    :param project_location: Required. A URL that points to the drop location
     to access project artifacts
    :type project_location: str
    :param selected_tables: Required. Metadata of the tables selected for
     migration
    :type selected_tables:
     list[~azure.mgmt.datamigration.models.NonSqlDataMigrationTable]
    """

    _validation = {
        'target_connection_info': {'required': True},
        'target_database_name': {'required': True},
        'project_name': {'required': True},
        'project_location': {'required': True},
        'selected_tables': {'required': True},
    }

    _attribute_map = {
        'target_connection_info': {'key': 'targetConnectionInfo', 'type': 'SqlConnectionInfo'},
        'target_database_name': {'key': 'targetDatabaseName', 'type': 'str'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'project_location': {'key': 'projectLocation', 'type': 'str'},
        'selected_tables': {'key': 'selectedTables', 'type': '[NonSqlDataMigrationTable]'},
    }

    def __init__(self, **kwargs):
        super(NonSqlMigrationTaskInput, self).__init__(**kwargs)
        self.target_connection_info = kwargs.get('target_connection_info', None)
        self.target_database_name = kwargs.get('target_database_name', None)
        self.project_name = kwargs.get('project_name', None)
        self.project_location = kwargs.get('project_location', None)
        self.selected_tables = kwargs.get('selected_tables', None)
