# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StampCapacity(Model):
    """Stamp capacity information.

    :param name: Name of the stamp.
    :type name: str
    :param available_capacity: Available capacity (# of machines, bytes of
     storage etc...).
    :type available_capacity: long
    :param total_capacity: Total capacity (# of machines, bytes of storage
     etc...).
    :type total_capacity: long
    :param unit: Name of the unit.
    :type unit: str
    :param compute_mode: Shared/dedicated workers. Possible values include:
     'Shared', 'Dedicated', 'Dynamic'
    :type compute_mode: str or ~azure.mgmt.web.models.ComputeModeOptions
    :param worker_size: Size of the machines. Possible values include:
     'Small', 'Medium', 'Large', 'D1', 'D2', 'D3', 'Default'
    :type worker_size: str or ~azure.mgmt.web.models.WorkerSizeOptions
    :param worker_size_id: Size ID of machines:
     0 - Small
     1 - Medium
     2 - Large
    :type worker_size_id: int
    :param exclude_from_capacity_allocation: If <code>true</code>, it includes
     basic apps.
     Basic apps are not used for capacity allocation.
    :type exclude_from_capacity_allocation: bool
    :param is_applicable_for_all_compute_modes: <code>true</code> if capacity
     is applicable for all apps; otherwise, <code>false</code>.
    :type is_applicable_for_all_compute_modes: bool
    :param site_mode: Shared or Dedicated.
    :type site_mode: str
    :param is_linux: Is this a linux stamp capacity
    :type is_linux: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available_capacity': {'key': 'availableCapacity', 'type': 'long'},
        'total_capacity': {'key': 'totalCapacity', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
        'compute_mode': {'key': 'computeMode', 'type': 'ComputeModeOptions'},
        'worker_size': {'key': 'workerSize', 'type': 'WorkerSizeOptions'},
        'worker_size_id': {'key': 'workerSizeId', 'type': 'int'},
        'exclude_from_capacity_allocation': {'key': 'excludeFromCapacityAllocation', 'type': 'bool'},
        'is_applicable_for_all_compute_modes': {'key': 'isApplicableForAllComputeModes', 'type': 'bool'},
        'site_mode': {'key': 'siteMode', 'type': 'str'},
        'is_linux': {'key': 'isLinux', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(StampCapacity, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.available_capacity = kwargs.get('available_capacity', None)
        self.total_capacity = kwargs.get('total_capacity', None)
        self.unit = kwargs.get('unit', None)
        self.compute_mode = kwargs.get('compute_mode', None)
        self.worker_size = kwargs.get('worker_size', None)
        self.worker_size_id = kwargs.get('worker_size_id', None)
        self.exclude_from_capacity_allocation = kwargs.get('exclude_from_capacity_allocation', None)
        self.is_applicable_for_all_compute_modes = kwargs.get('is_applicable_for_all_compute_modes', None)
        self.site_mode = kwargs.get('site_mode', None)
        self.is_linux = kwargs.get('is_linux', None)
