# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ImageStoreContent(Model):
    """Information about the image store content.

    :param store_files: The list of image store file info objects represents
     files found under the given image store relative path.
    :type store_files: list[~azure.servicefabric.models.FileInfo]
    :param store_folders: The list of image store folder info objects
     represents subfolders found under the given image store relative path.
    :type store_folders: list[~azure.servicefabric.models.FolderInfo]
    """

    _attribute_map = {
        'store_files': {'key': 'StoreFiles', 'type': '[FileInfo]'},
        'store_folders': {'key': 'StoreFolders', 'type': '[FolderInfo]'},
    }

    def __init__(self, *, store_files=None, store_folders=None, **kwargs) -> None:
        super(ImageStoreContent, self).__init__(**kwargs)
        self.store_files = store_files
        self.store_folders = store_folders
