# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute string extents.
#'
#' Determines the width and height of a bounding box that's big enough
#' to (just) enclose the provided text.
#'
#' @param x Character vector of strings to measure
#' @param bold,italic Is text bold/italic?
#' @param fontname Font name
#' @param fontsize Font size
#' @param fontfile Font file
#' @examples
#' \donttest{
#' # The first run can be slow when font caches are missing
#' # as font files are then being scanned to build those font caches.
#' str_extents(letters)
#' str_extents("Hello World!", bold = TRUE, italic = FALSE,
#'   fontname = "sans", fontsize = 12)
#' }
#' @export
str_extents <- function(x, fontname = "sans", fontsize = 12, bold = FALSE, italic = FALSE, fontfile = "") {
    .Call('_gdtools_str_extents', PACKAGE = 'gdtools', x, fontname, fontsize, bold, italic, fontfile)
}

#' Get font metrics for a string.
#'
#' @return A named numeric vector
#' @inheritParams str_extents
#' @examples
#' \donttest{
#' # The first run can be slow when font caches are missing
#' # as font files are then being scanned to build those font caches.
#' str_metrics("Hello World!")
#' }
#' @export
str_metrics <- function(x, fontname = "sans", fontsize = 12, bold = FALSE, italic = FALSE, fontfile = "") {
    .Call('_gdtools_str_metrics', PACKAGE = 'gdtools', x, fontname, fontsize, bold, italic, fontfile)
}

m_str_extents_ <- function(x, fontname, fontsize, bold, italic, fontfile) {
    .Call('_gdtools_m_str_extents_', PACKAGE = 'gdtools', x, fontname, fontsize, bold, italic, fontfile)
}

#' Validate glyph entries
#'
#' Determines if strings contain glyphs not part of a font.
#'
#' @param x Character vector of strings
#' @param bold,italic Is text bold/italic?
#' @param fontname Font name
#' @param fontfile Font file
#' @return a logical vector, if a character element is containing at least
#' a glyph that can not be matched in the font table, FALSE is returned.
#'
#' @examples
#' glyphs_match(letters)
#' glyphs_match("\u265E", bold = TRUE)
#' @export
glyphs_match <- function(x, fontname = "sans", bold = FALSE, italic = FALSE, fontfile = "") {
    .Call('_gdtools_glyphs_match', PACKAGE = 'gdtools', x, fontname, bold, italic, fontfile)
}

context_create <- function() {
    .Call('_gdtools_context_create', PACKAGE = 'gdtools')
}

context_set_font <- function(cc, fontname, fontsize, bold, italic, fontfile = "") {
    .Call('_gdtools_context_set_font', PACKAGE = 'gdtools', cc, fontname, fontsize, bold, italic, fontfile)
}

context_extents <- function(cc, x) {
    .Call('_gdtools_context_extents', PACKAGE = 'gdtools', cc, x)
}

raster_to_str <- function(raster, w, h, width, height, interpolate) {
    .Call('_gdtools_raster_to_str', PACKAGE = 'gdtools', raster, w, h, width, height, interpolate)
}

raster_to_file <- function(raster, w, h, width, height, interpolate, filename) {
    .Call('_gdtools_raster_to_file', PACKAGE = 'gdtools', raster, w, h, width, height, interpolate, filename)
}

raster_png_ <- function(raster_, w, h, width, height, interpolate, filename) {
    .Call('_gdtools_raster_png_', PACKAGE = 'gdtools', raster_, w, h, width, height, interpolate, filename)
}

base64_raster_encode <- function(raster_, w, h, width, height, interpolate) {
    .Call('_gdtools_base64_raster_encode', PACKAGE = 'gdtools', raster_, w, h, width, height, interpolate)
}

base64_file_encode <- function(filename) {
    .Call('_gdtools_base64_file_encode', PACKAGE = 'gdtools', filename)
}

base64_string_encode <- function(string) {
    .Call('_gdtools_base64_string_encode', PACKAGE = 'gdtools', string)
}

#' @title List system fonts.
#'
#' @description List system fonts details into a data.frame containing columns foundry, family,
#' file, slant and weight.
#'
#' @examples
#' \donttest{
#' # The first run can be slow when font caches are missing
#' # as font files are then being scanned to build those font caches.
#' sys_fonts()
#' }
#' @export
sys_fonts <- function() {
    .Call('_gdtools_sys_fonts', PACKAGE = 'gdtools')
}

match_family_ <- function(font = "sans", bold = TRUE, italic = TRUE) {
    .Call('_gdtools_match_family_', PACKAGE = 'gdtools', font, bold, italic)
}

match_font_ <- function(font = "sans", bold = FALSE, italic = FALSE) {
    .Call('_gdtools_match_font_', PACKAGE = 'gdtools', font, bold, italic)
}

#' @rdname version_cairo
#' @export
version_freetype <- function() {
    .Call('_gdtools_version_freetype', PACKAGE = 'gdtools')
}

#' @rdname version_cairo
#' @export
version_fontconfig <- function() {
    .Call('_gdtools_version_fontconfig', PACKAGE = 'gdtools')
}

version_cairo_ <- function() {
    .Call('_gdtools_version_cairo_', PACKAGE = 'gdtools')
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_gdtools_RcppExport_registerCCallable', PACKAGE = 'gdtools')
})
