if (require("testthat") && require("sjstats")) {
  context("sjstats, var_names")

  test_that("var_names", {
    expect_equal(var_names("as.factor(test)"), "test")
    expect_equal(var_names("log(test)"), "test")
    expect_equal(var_names("log(log(test))"), "test")
    expect_equal(var_names("I(test^2)"), "test")
    expect_equal(var_names("I(test ^ 2)"), "test")
    expect_equal(var_names("I(test / 10)"), "test")
    expect_equal(var_names("poly(test, 2)"), "test")
    expect_equal(var_names("poly(test, degrees = 2)"), "test")
    expect_equal(var_names("poly(test, degrees = 2, raw = TRUE)"), "test")
    expect_equal(var_names("ns(test)"), "test")
    expect_equal(var_names("ns(test, df = 2)"), "test")
    expect_equal(var_names("bs(test)"), "test")
    expect_equal(var_names("bs(test, df = 2)"), "test")
    expect_equal(var_names("offset(test)"), "test")
    expect_equal(var_names("offset(log(test))"), "test")
    expect_equal(var_names("factor(test)"), "test")
    expect_equal(var_names("as.factor(test)"), "test")
    expect_equal(var_names("~ 1 | test"), "test")
    expect_equal(var_names("~1|test"), "test")
    expect_equal(var_names("1 | test"), "test")
  })
}
