% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_atomic_json.R
\name{update_atomic_json}
\alias{update_atomic_json}
\title{Atomic updates with JSON data}
\usage{
update_atomic_json(conn, body, name, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{body}{(character) JSON as a character string}

\item{name}{(character) Name of the core or collection}

\item{wt}{(character) One of json (default) or xml. If json, uses
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} to parse. If xml, uses \code{\link[xml2:read_xml]{xml2::read_xml()}} to parse}

\item{raw}{(logical) If \code{TRUE}, returns raw data in format specified by
\code{wt} param}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Atomic updates to parts of Solr documents
}
\examples{
\dontrun{
# start Solr in Cloud mode: bin/solr start -e cloud -noprompt

# connect
(conn <- SolrClient$new())

# create a collection
if (!conn$collection_exists("books")) {
  conn$collection_delete("books")
  conn$collection_create("books")
}

# Add documents
file <- system.file("examples", "books2.json", package = "solrium")
cat(readLines(file), sep = "\\n")
conn$update_json(file, "books")

# get a document
conn$get(ids = 343334534545, "books")

# atomic update
body <- '[{
 "id": "343334534545",
 "genre_s": {"set": "mystery" },
 "pages_i": {"inc": 1 }
}]'
conn$update_atomic_json(body, "books")

# get the document again
conn$get(ids = 343334534545, "books")

# another atomic update
body <- '[{
 "id": "343334534545",
 "price": {"remove": "12.5" }
}]'
conn$update_atomic_json(body, "books")

# get the document again
conn$get(ids = 343334534545, "books")
}
}
\references{
\url{https://lucene.apache.org/solr/guide/7_0/updating-parts-of-documents.html}
}
