% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zip.R
\name{zip}
\alias{zip}
\alias{zip_append}
\title{Compress Files into 'zip' Archives}
\usage{
zip(zipfile, files, recurse = TRUE, compression_level = 9)

zip_append(zipfile, files, recurse = TRUE, compression_level = 9)
}
\arguments{
\item{zipfile}{The zip file to create. If the file exists, \code{zip}
overwrites it, but \code{zip_append} appends to it.}

\item{files}{List of file to add to the archive. Absolute path names
will be added as absolute path names, relative path names stay
relative in the archive.}

\item{recurse}{Whether to add the contents of directories recursively.}

\item{compression_level}{A number between 1 and 9. 9 compresses best,
but it also takes the longest.}
}
\value{
The name of the created zip file, invisibly.
}
\description{
\code{zip} creates a new zip archive file.
}
\details{
\code{zip_append} appends compressed files to an existing 'zip' file.
}
\examples{
## Some files to zip up
dir.create(tmp <- tempfile())
cat("first file", file = file.path(tmp, "file1"))
cat("second file", file = file.path(tmp, "file2"))

zipfile <- tempfile(fileext = ".zip")
zip(zipfile, tmp)

## List contents
zip_list(zipfile)

## Add another file
cat("third file", file = file.path(tmp, "file3"))
zip_append(zipfile, file.path(tmp, "file3"))
zip_list(zipfile)
}
