/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.12*/
#include "mp_precomp.h"

#define ODM_WIN 0x08

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
#if RT_PLATFORM == PLATFORM_MACOSX
#include "phydm_precomp.h"
#else
#include "../phydm_precomp.h"
#endif
#else
#include "../../phydm_precomp.h"
#endif

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE

#define CUT_DONT_CARE	0xf
#define RFE_DONT_CARE	0xff
#define PARA_IF 0x8
#define PARA_ELSE_IF	0x9
#define PARA_ELSE	0xa
#define PARA_END	0xb
#define PARA_CHK	0x4


#if (RTL8822C_SUPPORT == 1)
static boolean
halbb_sel_headline(struct dm_struct *dm, u32 *array, u32 array_len,
				  u8 *headline_size, u8 *headline_idx)
{
	boolean case_match = false;
	u32 cut_drv = (u32)dm->cut_version;
	u32 rfe_drv = (u32)dm->rfe_type;
	u32 cut_para = 0, rfe_para = 0;
	u32 compare_target = 0;
	u32 cut_max = 0;
	u32 i = 0;

	*headline_idx = 0;
	*headline_size = 0;

	while ((i + 1) < array_len) {
		if ((array[i] >> 28) != 0xf) {
			*headline_size = (u8)i;
			break;
		}
		PHYDM_DBG(dm, ODM_COMP_INIT, "array[%02d]=0x%08x, array[%02d]=0x%08x\n",
			   i, array[i], i+1, array[i+1]);
		i += 2;
	}

	PHYDM_DBG(dm, ODM_COMP_INIT, "headline_size=%d\n", i);

	if (i == 0)
		return true;

	/*case_idx:1 {RFE:Match, CUT:Match}*/
	compare_target = ((cut_drv & 0x0f) << 24) | (rfe_drv & 0xff);
	PHYDM_DBG(dm, ODM_COMP_INIT, "[1] CHK {RFE:Match, CUT:Match}\n");
	for (i = 0; i < *headline_size; i += 2) {
		if ((array[i] & 0x0f0000ff) == compare_target) {
			*headline_idx = (u8)(i >> 1);
			return true;
		}
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 fail\n");

	/*case_idx:2 {RFE:Match, CUT:Dont care}*/
	compare_target = (CUT_DONT_CARE << 24) | (rfe_drv & 0xff);
	PHYDM_DBG(dm, ODM_COMP_INIT, "[2] CHK {RFE:Match, CUT:Dont_Care}\n");
	for (i = 0; i < *headline_size; i += 2) {
		if ((array[i] & 0x0f0000ff) == compare_target) {
			*headline_idx = (u8)(i >> 1);
			return true;
		}
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 fail\n");

	/*case_idx:3 {RFE:Match, CUT:Max_in_table}*/
	PHYDM_DBG(dm, ODM_COMP_INIT, "[3] CHK {RFE:Match, CUT:Max_in_Table}\n");
	for (i = 0; i < *headline_size; i += 2) {
		rfe_para = array[i] & 0xff;
		cut_para = (array[i] & 0x0f000000) >> 24;
		if (rfe_para == rfe_drv) {
			if (cut_para >= cut_max) {
				cut_max = cut_para;
				*headline_idx = (u8)(i >> 1);
				PHYDM_DBG(dm, ODM_COMP_INIT, "cut_max:%d\n", cut_max);
				case_match = true;
			}
		}
	}
	if (case_match) {
		return true;
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 fail\n");

	/*case_idx:4 {RFE:Dont Care, CUT:Max_in_table}*/
	PHYDM_DBG(dm, ODM_COMP_INIT, "[4] CHK {RFE:Dont_Care, CUT:Max_in_Table}\n");
	for (i = 0; i < *headline_size; i += 2) {
		rfe_para = array[i] & 0xff;
		cut_para = (array[i] & 0x0f000000) >> 24;
		if (rfe_para == RFE_DONT_CARE) {
			if (cut_para >= cut_max) {
				cut_max = cut_para;
				*headline_idx = (u8)(i >> 1);
				PHYDM_DBG(dm, ODM_COMP_INIT, "cut_max:%d\n", cut_max);
				case_match = true;
			}
		}
	}
	if (case_match) {
		return true;
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 fail\n");

	/*case_idx:5 {RFE:Not_Match, CUT:Not_Match}*/
	PHYDM_DBG(dm, ODM_COMP_INIT, "[5] CHK {RFE:Not_Match, CUT:Not_Match}\n");
	PHYDM_DBG(dm, ODM_COMP_INIT, "	 all fail\n");
	return false;
}

static void
halbb_flag_2_default(boolean *is_matched, boolean *find_target)
{
	*is_matched = true;
	*find_target = false;
}


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8822c_radioa[] = {
		0xF0FFFF00, 0x00000000,
		0xF0FFFF01, 0x00000001,
		0xF1FFFF01, 0x00000002,
		0xF1FFFF02, 0x00000003,
		0xF2FFFF01, 0x00000004,
		0xF2FFFF02, 0x00000005,
		0xF3FFFF01, 0x00000006,
		0xF3FFFF02, 0x00000007,
		0xF3FFFF03, 0x00000008,
		0xF3FFFF04, 0x00000009,
		0xF3FFFF05, 0x0000000A,
		0xF3FFFF06, 0x0000000B,
		0xF3FFFF15, 0x0000000C,
		0xF3FFFF16, 0x0000000D,
		0xF4FFFF01, 0x0000000E,
		0xF4FFFF02, 0x0000000F,
		0xF4FFFF03, 0x00000010,
		0xF4FFFF04, 0x00000011,
		0xF4FFFF05, 0x00000012,
		0xF4FFFF06, 0x00000013,
		0xF4FFFF15, 0x00000014,
		0xF4FFFF16, 0x00000015,
		0xF5FFFF01, 0x00000016,
		0xF5FFFF02, 0x00000017,
		0xF5FFFF03, 0x00000018,
		0xF5FFFF04, 0x00000019,
		0xF5FFFF05, 0x0000001A,
		0xF5FFFF06, 0x0000001B,
		0xF5FFFF15, 0x0000001C,
		0xF5FFFF16, 0x0000001D,
		0x000, 0x00030000,
		0x018, 0x00013124,
		0x093, 0x0008483F,
		0x0DE, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000B9140,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000B9140,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0xA0000000,	0x00000000,
		0x08E, 0x000A5540,
	0xB0000000,	0x00000000,
		0x081, 0x0000FC01,
		0x081, 0x0002FC01,
		0x081, 0x0003FC01,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x0006A06C,
	0xA0000000,	0x00000000,
		0x085, 0x0006A06C,
	0xB0000000,	0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000002,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000002,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000002,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773E8,
		0x033, 0x0000000E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000D,
		0x03F, 0x00000380,
		0x033, 0x0000000C,
		0x03F, 0x000FF380,
		0x033, 0x0000000B,
		0x03F, 0x00000300,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773E8,
		0x033, 0x0000000E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000D,
		0x03F, 0x00000380,
		0x033, 0x0000000C,
		0x03F, 0x000FF380,
		0x033, 0x0000000B,
		0x03F, 0x00000300,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773E8,
		0x033, 0x0000000E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000D,
		0x03F, 0x00000380,
		0x033, 0x0000000C,
		0x03F, 0x000FF380,
		0x033, 0x0000000B,
		0x03F, 0x00000300,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773E8,
		0x033, 0x0000001E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001D,
		0x03F, 0x00000380,
		0x033, 0x0000001C,
		0x03F, 0x000FF380,
		0x033, 0x0000001B,
		0x03F, 0x00000300,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773E8,
		0x033, 0x0000001E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001D,
		0x03F, 0x00000380,
		0x033, 0x0000001C,
		0x03F, 0x000FF380,
		0x033, 0x0000001B,
		0x03F, 0x00000300,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773E8,
		0x033, 0x0000001E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001D,
		0x03F, 0x00000380,
		0x033, 0x0000001C,
		0x03F, 0x000FF380,
		0x033, 0x0000001B,
		0x03F, 0x00000300,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773E8,
		0x033, 0x0000002E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002D,
		0x03F, 0x00000380,
		0x033, 0x0000002C,
		0x03F, 0x000FF380,
		0x033, 0x0000002B,
		0x03F, 0x00000300,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773E8,
		0x033, 0x0000002E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002D,
		0x03F, 0x00000380,
		0x033, 0x0000002C,
		0x03F, 0x000FF380,
		0x033, 0x0000002B,
		0x03F, 0x00000300,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773E8,
		0x033, 0x0000002E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002D,
		0x03F, 0x00000380,
		0x033, 0x0000002C,
		0x03F, 0x000FF380,
		0x033, 0x0000002B,
		0x03F, 0x00000300,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773E8,
		0x033, 0x0000003E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003D,
		0x03F, 0x00000380,
		0x033, 0x0000003C,
		0x03F, 0x000FF380,
		0x033, 0x0000003B,
		0x03F, 0x00000300,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773E8,
		0x033, 0x0000003E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003D,
		0x03F, 0x00000380,
		0x033, 0x0000003C,
		0x03F, 0x000FF380,
		0x033, 0x0000003B,
		0x03F, 0x00000300,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773E8,
		0x033, 0x0000003E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003D,
		0x03F, 0x00000380,
		0x033, 0x0000003C,
		0x03F, 0x000FF380,
		0x033, 0x0000003B,
		0x03F, 0x00000300,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773E8,
		0x033, 0x0000004E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004D,
		0x03F, 0x00000380,
		0x033, 0x0000004C,
		0x03F, 0x000FF380,
		0x033, 0x0000004B,
		0x03F, 0x00000300,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773E8,
		0x033, 0x0000004E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004D,
		0x03F, 0x00000380,
		0x033, 0x0000004C,
		0x03F, 0x000FF380,
		0x033, 0x0000004B,
		0x03F, 0x00000300,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773E8,
		0x033, 0x0000004E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004D,
		0x03F, 0x00000380,
		0x033, 0x0000004C,
		0x03F, 0x000FF380,
		0x033, 0x0000004B,
		0x03F, 0x00000300,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000043,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773E8,
		0x033, 0x0000005E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005D,
		0x03F, 0x00000380,
		0x033, 0x0000005C,
		0x03F, 0x000FF380,
		0x033, 0x0000005B,
		0x03F, 0x00000300,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773E8,
		0x033, 0x0000005E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005D,
		0x03F, 0x00000380,
		0x033, 0x0000005C,
		0x03F, 0x000FF380,
		0x033, 0x0000005B,
		0x03F, 0x00000300,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773E8,
		0x033, 0x0000005E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005D,
		0x03F, 0x00000380,
		0x033, 0x0000005C,
		0x03F, 0x000FF380,
		0x033, 0x0000005B,
		0x03F, 0x00000300,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000053,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x08A, 0x000E7DE3,
		0x08B, 0x0008FE00,
		0x0EE, 0x00000008,
		0x033, 0x00000000,
		0x03F, 0x00000023,
		0x033, 0x00000001,
		0x03F, 0x00000023,
		0x0EE, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000F,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000010,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000010,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000010,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
		0x01B, 0x00003A40,
		0x061, 0x0000D233,
		0x062, 0x0004D232,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000C02,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000C02,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x063, 0x00000C02,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000233,
		0x030, 0x00001233,
		0x030, 0x00002233,
		0x030, 0x00003233,
		0x030, 0x00004203,
		0x030, 0x00005233,
		0x030, 0x00006233,
		0x030, 0x00007233,
		0x030, 0x00008203,
		0x030, 0x00009233,
		0x030, 0x0000A233,
		0x030, 0x0000B233,
		0x030, 0x0000C233,
		0x030, 0x0000D233,
		0x030, 0x0000E203,
		0x030, 0x0000F233,
		0x030, 0x00010233,
		0x030, 0x00011233,
		0x030, 0x00012203,
		0x030, 0x00013233,
		0x030, 0x00014233,
		0x030, 0x00015233,
		0x030, 0x00016203,
		0x030, 0x00017233,
		0x030, 0x00018203,
		0x030, 0x00019233,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000233,
		0x030, 0x00001233,
		0x030, 0x00002233,
		0x030, 0x00003233,
		0x030, 0x00004203,
		0x030, 0x00005233,
		0x030, 0x00006233,
		0x030, 0x00007233,
		0x030, 0x00008203,
		0x030, 0x00009233,
		0x030, 0x0000A233,
		0x030, 0x0000B233,
		0x030, 0x0000C233,
		0x030, 0x0000D233,
		0x030, 0x0000E203,
		0x030, 0x0000F233,
		0x030, 0x00010233,
		0x030, 0x00011233,
		0x030, 0x00012203,
		0x030, 0x00013233,
		0x030, 0x00014233,
		0x030, 0x00015233,
		0x030, 0x00016203,
		0x030, 0x00017233,
		0x030, 0x00018203,
		0x030, 0x00019233,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0xA0000000,	0x00000000,
		0x030, 0x00000233,
		0x030, 0x00001233,
		0x030, 0x00002233,
		0x030, 0x00003233,
		0x030, 0x00004203,
		0x030, 0x00005233,
		0x030, 0x00006233,
		0x030, 0x00007233,
		0x030, 0x00008203,
		0x030, 0x00009233,
		0x030, 0x0000A233,
		0x030, 0x0000B233,
		0x030, 0x0000C233,
		0x030, 0x0000D233,
		0x030, 0x0000E203,
		0x030, 0x0000F233,
		0x030, 0x00010233,
		0x030, 0x00011233,
		0x030, 0x00012203,
		0x030, 0x00013233,
		0x030, 0x00014233,
		0x030, 0x00015233,
		0x030, 0x00016203,
		0x030, 0x00017233,
		0x030, 0x00018203,
		0x030, 0x00019233,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000232,
		0x030, 0x00001232,
		0x030, 0x00002232,
		0x030, 0x00003232,
		0x030, 0x00004232,
		0x030, 0x00005232,
		0x030, 0x00006232,
		0x030, 0x00007232,
		0x030, 0x00008232,
		0x030, 0x00009232,
		0x030, 0x0000A232,
		0x030, 0x0000B232,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000232,
		0x030, 0x00001232,
		0x030, 0x00002232,
		0x030, 0x00003232,
		0x030, 0x00004232,
		0x030, 0x00005232,
		0x030, 0x00006232,
		0x030, 0x00007232,
		0x030, 0x00008232,
		0x030, 0x00009232,
		0x030, 0x0000A232,
		0x030, 0x0000B232,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0xA0000000,	0x00000000,
		0x030, 0x00000232,
		0x030, 0x00001232,
		0x030, 0x00002232,
		0x030, 0x00003232,
		0x030, 0x00004232,
		0x030, 0x00005232,
		0x030, 0x00006232,
		0x030, 0x00007232,
		0x030, 0x00008232,
		0x030, 0x00009232,
		0x030, 0x0000A232,
		0x030, 0x0000B232,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000770,
		0x030, 0x00001770,
		0x030, 0x00002440,
		0x030, 0x00003440,
		0x030, 0x00004330,
		0x030, 0x00005330,
		0x030, 0x00008770,
		0x030, 0x0000A440,
		0x030, 0x0000C330,
		0x0EF, 0x00000000,
		0x0EE, 0x00010000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
		0x051, 0x0003C800,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000942CA,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000942CA,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0xA0000000,	0x00000000,
		0x052, 0x000942CA,
	0xB0000000,	0x00000000,
		0x053, 0x000090F9,
		0x054, 0x00088000,
		0x057, 0x0004C80A,
		0x0EF, 0x00000020,
		0x033, 0x00000000,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00028246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00010E46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030246,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00031E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00025E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0003D646,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00002A46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000EA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00021E46,
	0xA0000000,	0x00000000,
		0x03F, 0x00002A46,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EE, 0x00010000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000487,
		0x033, 0x00000061,
		0x03F, 0x00000887,
		0x033, 0x00000062,
		0x03F, 0x00000947,
		0x033, 0x00000063,
		0x03F, 0x00000D48,
		0x033, 0x00000064,
		0x03F, 0x00000D88,
		0x033, 0x00000065,
		0x03F, 0x00000DE8,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000487,
		0x033, 0x00000061,
		0x03F, 0x00000887,
		0x033, 0x00000062,
		0x03F, 0x00000947,
		0x033, 0x00000063,
		0x03F, 0x00000D48,
		0x033, 0x00000064,
		0x03F, 0x00000D88,
		0x033, 0x00000065,
		0x03F, 0x00000DE8,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x000008C8,
		0x033, 0x00000064,
		0x03F, 0x000008CB,
		0x033, 0x00000065,
		0x03F, 0x000008CE,
		0x033, 0x00000066,
		0x03F, 0x000008D1,
		0x033, 0x00000067,
		0x03F, 0x000008D4,
		0x033, 0x00000068,
		0x03F, 0x00000DD1,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000487,
		0x033, 0x00000061,
		0x03F, 0x00000887,
		0x033, 0x00000062,
		0x03F, 0x00000947,
		0x033, 0x00000063,
		0x03F, 0x00000D48,
		0x033, 0x00000064,
		0x03F, 0x00000D88,
		0x033, 0x00000065,
		0x03F, 0x00000DE8,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0xB0000000,	0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000487,
		0x033, 0x00000021,
		0x03F, 0x00000887,
		0x033, 0x00000022,
		0x03F, 0x00000947,
		0x033, 0x00000023,
		0x03F, 0x00000D48,
		0x033, 0x00000024,
		0x03F, 0x00000D88,
		0x033, 0x00000025,
		0x03F, 0x00000DE8,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000487,
		0x033, 0x00000021,
		0x03F, 0x00000887,
		0x033, 0x00000022,
		0x03F, 0x00000947,
		0x033, 0x00000023,
		0x03F, 0x00000D48,
		0x033, 0x00000024,
		0x03F, 0x00000D88,
		0x033, 0x00000025,
		0x03F, 0x00000DE8,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000487,
		0x033, 0x00000021,
		0x03F, 0x00000887,
		0x033, 0x00000022,
		0x03F, 0x00000947,
		0x033, 0x00000023,
		0x03F, 0x00000D48,
		0x033, 0x00000024,
		0x03F, 0x00000D88,
		0x033, 0x00000025,
		0x03F, 0x00000DE8,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x05C, 0x000FC000,
		0x067, 0x0000A505,
		0x0D3, 0x00000542,
		0x043, 0x00005000,
		0x07F, 0x00000000,
		0x0B0, 0x0001F0FC,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x00022400,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0xA0000000,	0x00000000,
		0x0B3, 0x0007C760,
	0xB0000000,	0x00000000,
		0x0B4, 0x00099D40,
		0x0B5, 0x0004103F,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000187F8,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B6, 0x000387F8,
	0xA0000000,	0x00000000,
		0x0B6, 0x000187F8,
	0xB0000000,	0x00000000,
		0x0B7, 0x00030018,
		0x0BC, 0x00000008,
		0x0D3, 0x00000542,
		0x0DD, 0x00000500,
		0x0BB, 0x00040010,
		0x0B0, 0x0001F0FA,
		0x0FE, 0x00000000,
		0x0CA, 0x00080000,
		0x0CA, 0x00080001,
		0x0FE, 0x00000000,
		0x0B0, 0x0001F0F8,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C700,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0xA0000000,	0x00000000,
		0x0B3, 0x0007C700,
	0xB0000000,	0x00000000,
		0x018, 0x0001B124,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x0007C760,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0B3, 0x000FC760,
	0xA0000000,	0x00000000,
		0x0B3, 0x0007C760,
	0xB0000000,	0x00000000,
		0x018, 0x00013124,
		0x0CC, 0x0000F000,
		0x0CD, 0x00089600,
		0x018, 0x00013108,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0B8, 0x000C0440,
		0x0BA, 0x000E840D,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x018, 0x00013124,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x059, 0x000A0000,
		0x05A, 0x00060000,
		0x05B, 0x00014000,
		0x0ED, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x0000000F,
		0x0ED, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000500,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000500,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000500,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000500,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000500,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000500,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0DD, 0x00000540,
	0xA0000000,	0x00000000,
		0x0DD, 0x00000500,
	0xB0000000,	0x00000000,
		0x0BC, 0x00000004,
		0x0EE, 0x00000002,
		0x033, 0x00000017,
		0x03F, 0x0000003F,
		0x033, 0x00000018,
		0x03F, 0x0000003F,
		0x033, 0x00000019,
		0x03F, 0x00000000,
		0x033, 0x0000001A,
		0x03F, 0x0000003F,
		0x033, 0x0000001B,
		0x03F, 0x0000003F,
		0x033, 0x0000001C,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
		0x0ED, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x000F45A4,
		0x033, 0x00000001,
		0x03F, 0x000F49A4,
		0x033, 0x00000002,
		0x03F, 0x000F49A4,
		0x033, 0x00000003,
		0x03F, 0x000F69A4,
		0x033, 0x00000004,
		0x03F, 0x000F69A4,
		0x033, 0x00000005,
		0x03F, 0x000F69A4,
		0x033, 0x00000006,
		0x03F, 0x000F6DA4,
		0x033, 0x00000007,
		0x03F, 0x000F6DA4,
		0x033, 0x00000008,
		0x03F, 0x000F6DA4,
		0x033, 0x00000009,
		0x03F, 0x000F8DA4,
		0x033, 0x0000000A,
		0x03F, 0x000F8DA4,
		0x033, 0x0000000B,
		0x03F, 0x000F8DA4,
		0x033, 0x0000000C,
		0x03F, 0x000F91A4,
		0x033, 0x0000000D,
		0x03F, 0x000F91A4,
		0x033, 0x0000000E,
		0x03F, 0x000F91A4,
		0x033, 0x0000000F,
		0x03F, 0x000FB1A4,
		0x033, 0x00000010,
		0x03F, 0x000FB1A4,
		0x033, 0x00000011,
		0x03F, 0x000FB1A4,
		0x033, 0x00000012,
		0x03F, 0x000FB5A4,
		0x033, 0x00000013,
		0x03F, 0x000FB5A4,
		0x033, 0x00000014,
		0x03F, 0x000FD9A4,
		0x033, 0x00000015,
		0x03F, 0x000FD9A4,
		0x033, 0x00000016,
		0x03F, 0x000FF9A4,
		0x033, 0x00000017,
		0x03F, 0x000FF9A4,
		0x033, 0x00000018,
		0x03F, 0x000FFDA4,
		0x033, 0x00000019,
		0x03F, 0x000FFDA4,
		0x033, 0x0000001A,
		0x03F, 0x000FFDA4,
		0x0ED, 0x00000000,
		0x092, 0x00084800,
		0x092, 0x00084801,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x092, 0x00084800,
		0x08F, 0x00001B4C,
		0x088, 0x0004326B,
		0x019, 0x00000005,
		0x0EF, 0x00080000,
		0x033, 0x00000004,
		0x03E, 0x00000003,
		0x03F, 0x000F60FF,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000006,
		0x03E, 0x00000003,
		0x03F, 0x000760FF,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000007,
		0x03E, 0x00000003,
		0x03F, 0x0007DEFF,
		0x0EF, 0x00000000,

};

void
odm_read_and_config_mp_8822c_radioa(struct dm_struct *dm)
{
	boolean is_matched, find_target;
	u32 cfg_target = 0, cfg_para = 0;
	u32 i = 0;
	u32 array_len = 0;
	u32 *array = NULL;
	u32 v1 = 0, v2 = 0;
	u8 h_size = 0;
	u8 h_idx = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	array_len =
		sizeof(array_mp_8822c_radioa) / sizeof(u32);
	array = (u32 *)array_mp_8822c_radioa;

	if (!halbb_sel_headline(dm, array, array_len, &h_size, &h_idx)) {
		PHYDM_DBG(dm, ODM_COMP_INIT, "No any match case.\n");
		return;
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "len = %d, h_size = %d, h_idx = %d\n",
			  array_len, h_size, h_idx);

	if (h_size != 0) {
		cfg_target = array[h_idx << 1] & 0x0fffffff;
	}

	i += h_size;

	PHYDM_DBG(dm, ODM_COMP_INIT, "cfg_target = 0x%x\n", cfg_target);
	PHYDM_DBG(dm, ODM_COMP_INIT, "array[i] = 0x%x, array[i+1] = 0x%x\n",
			  array[i], array[i + 1]);

	halbb_flag_2_default(&is_matched, &find_target);
	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];
		i += 2;

		switch (v1 >> 28) {
		case PARA_IF:
		case PARA_ELSE_IF:
			cfg_para = v1 & 0x0fffffff;
			PHYDM_DBG(dm, ODM_COMP_INIT, "*if (cart=%d, rfe=%d)\n",
			       (cfg_para & 0x0f000000) >> 24, cfg_para & 0xff);
			break;
		case PARA_ELSE:
			PHYDM_DBG(dm, ODM_COMP_INIT, "*else\n");
			is_matched = false;
			if (!find_target) {
				PHYDM_DBG(dm, ODM_COMP_INIT, "Init Fail in Reg 0x%x\n", array[i]);
				return;
			}
			break;
		case PARA_END:
			PHYDM_DBG(dm, ODM_COMP_INIT, "*endif\n");
			halbb_flag_2_default(&is_matched, &find_target);
			break;
		case PARA_CHK:
			/*Check this para meets driver's requirement or not*/
			if (find_target) {
				PHYDM_DBG(dm, ODM_COMP_INIT, "	 skip\n");
				is_matched = false;
				break;
			}

			if (cfg_para == cfg_target) {
				is_matched = true;
				find_target = true;
			} else {
				is_matched = false;
				find_target = false;
			}
			PHYDM_DBG(dm, ODM_COMP_INIT, "	 match=%d\n", is_matched);
			break;
		default:
			if (is_matched)
					odm_config_rf_radio_a_8822c(dm, v1, v2);
			break;
		}
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "BBCR Init Success\n");
}

u32
odm_get_version_mp_8822c_radioa(void)
{
		return 61;
}

/******************************************************************************
 *                           radiob.TXT
 ******************************************************************************/

const u32 array_mp_8822c_radiob[] = {
		0xF0FFFF00, 0x00000000,
		0xF0FFFF01, 0x00000001,
		0xF1FFFF01, 0x00000002,
		0xF1FFFF02, 0x00000003,
		0xF2FFFF01, 0x00000004,
		0xF2FFFF02, 0x00000005,
		0xF3FFFF01, 0x00000006,
		0xF3FFFF02, 0x00000007,
		0xF3FFFF03, 0x00000008,
		0xF3FFFF04, 0x00000009,
		0xF3FFFF05, 0x0000000A,
		0xF3FFFF06, 0x0000000B,
		0xF3FFFF15, 0x0000000C,
		0xF3FFFF16, 0x0000000D,
		0xF4FFFF01, 0x0000000E,
		0xF4FFFF02, 0x0000000F,
		0xF4FFFF03, 0x00000010,
		0xF4FFFF04, 0x00000011,
		0xF4FFFF05, 0x00000012,
		0xF4FFFF06, 0x00000013,
		0xF4FFFF15, 0x00000014,
		0xF4FFFF16, 0x00000015,
		0xF5FFFF01, 0x00000016,
		0xF5FFFF02, 0x00000017,
		0xF5FFFF03, 0x00000018,
		0xF5FFFF04, 0x00000019,
		0xF5FFFF05, 0x0000001A,
		0xF5FFFF06, 0x0000001B,
		0xF5FFFF15, 0x0000001C,
		0xF5FFFF16, 0x0000001D,
		0x000, 0x00030000,
		0x018, 0x00013124,
		0x093, 0x0008483F,
		0x0EF, 0x00080000,
		0x033, 0x00000001,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00091230,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00091230,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00091230,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00091230,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00091230,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00091230,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0009123E,
	0xA0000000,	0x00000000,
		0x03F, 0x00091230,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0DE, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000B9140,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000B9140,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x08E, 0x000A5540,
	0xA0000000,	0x00000000,
		0x08E, 0x000A5540,
	0xB0000000,	0x00000000,
		0x081, 0x0000FC01,
		0x081, 0x0002FC01,
		0x081, 0x0003FC01,
		0x085, 0x0006A06C,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000002,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000002,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000001,
		0x03F, 0x0000002A,
		0x033, 0x00000002,
		0x03F, 0x0000002A,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000001,
		0x03F, 0x0000003F,
		0x033, 0x00000002,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773E8,
		0x033, 0x0000000E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000D,
		0x03F, 0x00000380,
		0x033, 0x0000000C,
		0x03F, 0x000FF380,
		0x033, 0x0000000B,
		0x03F, 0x00000300,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773E8,
		0x033, 0x0000000E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000D,
		0x03F, 0x00000380,
		0x033, 0x0000000C,
		0x03F, 0x000FF380,
		0x033, 0x0000000B,
		0x03F, 0x00000300,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773C0,
		0x033, 0x0000000E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000000D,
		0x03F, 0x000773E8,
		0x033, 0x0000000C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000000B,
		0x03F, 0x00000287,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000207,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x0EF, 0x00010000,
		0x033, 0x0000000F,
		0x03F, 0x000773E8,
		0x033, 0x0000000E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000000D,
		0x03F, 0x00000380,
		0x033, 0x0000000C,
		0x03F, 0x000FF380,
		0x033, 0x0000000B,
		0x03F, 0x00000300,
		0x033, 0x0000000A,
		0x03F, 0x000002A8,
		0x033, 0x00000009,
		0x03F, 0x00000280,
		0x033, 0x00000008,
		0x03F, 0x000FF280,
		0x033, 0x00000007,
		0x03F, 0x00000200,
		0x033, 0x00000006,
		0x03F, 0x000001C0,
		0x033, 0x00000005,
		0x03F, 0x00000180,
		0x033, 0x00000004,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773E8,
		0x033, 0x0000001E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001D,
		0x03F, 0x00000380,
		0x033, 0x0000001C,
		0x03F, 0x000FF380,
		0x033, 0x0000001B,
		0x03F, 0x00000300,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773E8,
		0x033, 0x0000001E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001D,
		0x03F, 0x00000380,
		0x033, 0x0000001C,
		0x03F, 0x000FF380,
		0x033, 0x0000001B,
		0x03F, 0x00000300,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773C0,
		0x033, 0x0000001E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000001D,
		0x03F, 0x000773E8,
		0x033, 0x0000001C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000001B,
		0x03F, 0x00000287,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000207,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000001F,
		0x03F, 0x000773E8,
		0x033, 0x0000001E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000001D,
		0x03F, 0x00000380,
		0x033, 0x0000001C,
		0x03F, 0x000FF380,
		0x033, 0x0000001B,
		0x03F, 0x00000300,
		0x033, 0x0000001A,
		0x03F, 0x000002A8,
		0x033, 0x00000019,
		0x03F, 0x00000280,
		0x033, 0x00000018,
		0x03F, 0x000FF280,
		0x033, 0x00000017,
		0x03F, 0x00000200,
		0x033, 0x00000016,
		0x03F, 0x000001C0,
		0x033, 0x00000015,
		0x03F, 0x00000180,
		0x033, 0x00000014,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773E8,
		0x033, 0x0000002E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002D,
		0x03F, 0x00000380,
		0x033, 0x0000002C,
		0x03F, 0x000FF380,
		0x033, 0x0000002B,
		0x03F, 0x00000300,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773E8,
		0x033, 0x0000002E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002D,
		0x03F, 0x00000380,
		0x033, 0x0000002C,
		0x03F, 0x000FF380,
		0x033, 0x0000002B,
		0x03F, 0x00000300,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773C0,
		0x033, 0x0000002E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000002D,
		0x03F, 0x000773E8,
		0x033, 0x0000002C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000002B,
		0x03F, 0x00000287,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000207,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000002F,
		0x03F, 0x000773E8,
		0x033, 0x0000002E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000002D,
		0x03F, 0x00000380,
		0x033, 0x0000002C,
		0x03F, 0x000FF380,
		0x033, 0x0000002B,
		0x03F, 0x00000300,
		0x033, 0x0000002A,
		0x03F, 0x000002A8,
		0x033, 0x00000029,
		0x03F, 0x00000280,
		0x033, 0x00000028,
		0x03F, 0x000FF280,
		0x033, 0x00000027,
		0x03F, 0x00000200,
		0x033, 0x00000026,
		0x03F, 0x000001C0,
		0x033, 0x00000025,
		0x03F, 0x00000180,
		0x033, 0x00000024,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773E8,
		0x033, 0x0000003E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003D,
		0x03F, 0x00000380,
		0x033, 0x0000003C,
		0x03F, 0x000FF380,
		0x033, 0x0000003B,
		0x03F, 0x00000300,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773E8,
		0x033, 0x0000003E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003D,
		0x03F, 0x00000380,
		0x033, 0x0000003C,
		0x03F, 0x000FF380,
		0x033, 0x0000003B,
		0x03F, 0x00000300,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773C0,
		0x033, 0x0000003E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000003D,
		0x03F, 0x000773E8,
		0x033, 0x0000003C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000003B,
		0x03F, 0x00000287,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000207,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000003F,
		0x03F, 0x000773E8,
		0x033, 0x0000003E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000003D,
		0x03F, 0x00000380,
		0x033, 0x0000003C,
		0x03F, 0x000FF380,
		0x033, 0x0000003B,
		0x03F, 0x00000300,
		0x033, 0x0000003A,
		0x03F, 0x000002A8,
		0x033, 0x00000039,
		0x03F, 0x00000280,
		0x033, 0x00000038,
		0x03F, 0x000FF280,
		0x033, 0x00000037,
		0x03F, 0x00000200,
		0x033, 0x00000036,
		0x03F, 0x000001C0,
		0x033, 0x00000035,
		0x03F, 0x00000180,
		0x033, 0x00000034,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000033,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773E8,
		0x033, 0x0000004E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004D,
		0x03F, 0x00000380,
		0x033, 0x0000004C,
		0x03F, 0x000FF380,
		0x033, 0x0000004B,
		0x03F, 0x00000300,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773E8,
		0x033, 0x0000004E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004D,
		0x03F, 0x00000380,
		0x033, 0x0000004C,
		0x03F, 0x000FF380,
		0x033, 0x0000004B,
		0x03F, 0x00000300,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773C0,
		0x033, 0x0000004E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000004D,
		0x03F, 0x000773E8,
		0x033, 0x0000004C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000004B,
		0x03F, 0x00000287,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000207,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000004F,
		0x03F, 0x000773E8,
		0x033, 0x0000004E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000004D,
		0x03F, 0x00000380,
		0x033, 0x0000004C,
		0x03F, 0x000FF380,
		0x033, 0x0000004B,
		0x03F, 0x00000300,
		0x033, 0x0000004A,
		0x03F, 0x000002A8,
		0x033, 0x00000049,
		0x03F, 0x00000280,
		0x033, 0x00000048,
		0x03F, 0x000FF280,
		0x033, 0x00000047,
		0x03F, 0x00000200,
		0x033, 0x00000046,
		0x03F, 0x000001C0,
		0x033, 0x00000045,
		0x03F, 0x00000180,
		0x033, 0x00000044,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000043,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773E8,
		0x033, 0x0000005E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005D,
		0x03F, 0x00000380,
		0x033, 0x0000005C,
		0x03F, 0x000FF380,
		0x033, 0x0000005B,
		0x03F, 0x00000300,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773E8,
		0x033, 0x0000005E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005D,
		0x03F, 0x00000380,
		0x033, 0x0000005C,
		0x03F, 0x000FF380,
		0x033, 0x0000005B,
		0x03F, 0x00000300,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773C0,
		0x033, 0x0000005E,
		0x03F, 0x000FF3C0,
		0x033, 0x0000005D,
		0x03F, 0x000773E8,
		0x033, 0x0000005C,
		0x03F, 0x000FF3E8,
		0x033, 0x0000005B,
		0x03F, 0x00000287,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000207,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0xA0000000,	0x00000000,
		0x033, 0x0000005F,
		0x03F, 0x000773E8,
		0x033, 0x0000005E,
		0x03F, 0x000FF3A0,
		0x033, 0x0000005D,
		0x03F, 0x00000380,
		0x033, 0x0000005C,
		0x03F, 0x000FF380,
		0x033, 0x0000005B,
		0x03F, 0x00000300,
		0x033, 0x0000005A,
		0x03F, 0x000002A8,
		0x033, 0x00000059,
		0x03F, 0x00000280,
		0x033, 0x00000058,
		0x03F, 0x000FF280,
		0x033, 0x00000057,
		0x03F, 0x00000200,
		0x033, 0x00000056,
		0x03F, 0x000001C0,
		0x033, 0x00000055,
		0x03F, 0x00000180,
		0x033, 0x00000054,
		0x03F, 0x00000040,
	0xB0000000,	0x00000000,
		0x033, 0x00000053,
		0x03F, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x08A, 0x000E7DE3,
		0x08B, 0x0008FE00,
		0x0EE, 0x00000008,
		0x033, 0x00000000,
		0x03F, 0x00000023,
		0x033, 0x00000001,
		0x03F, 0x00000023,
		0x0EE, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000000F,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000010,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000010,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000008,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002F81C,
		0x033, 0x00000010,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001C86,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
		0x033, 0x00000000,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000001,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000002,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000003,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000004,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000005,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000008,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000009,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000000A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000000B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000000C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000000D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000000E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000000F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000010,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000011,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000012,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000013,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000014,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000015,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000018,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000019,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000001A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000001B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000001C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000001D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000001E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000001F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000020,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000021,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x00000022,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x00000023,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x00000024,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x00000025,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x00000026,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x00000027,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x033, 0x00000028,
		0x03E, 0x00001910,
		0x03F, 0x00020000,
		0x033, 0x00000029,
		0x03E, 0x00001C02,
		0x03F, 0x00020000,
		0x033, 0x0000002A,
		0x03E, 0x00000F02,
		0x03F, 0x00020000,
		0x033, 0x0000002B,
		0x03E, 0x00000F00,
		0x03F, 0x00020000,
		0x033, 0x0000002C,
		0x03E, 0x00000086,
		0x03F, 0x00020000,
		0x033, 0x0000002D,
		0x03E, 0x00000002,
		0x03F, 0x00020000,
		0x033, 0x0000002E,
		0x03E, 0x00000000,
		0x03F, 0x00020000,
		0x033, 0x0000002F,
		0x03E, 0x00000000,
		0x03F, 0x0002C010,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0FE, 0x00000000,
		0x01B, 0x00003A40,
		0x061, 0x0000D233,
		0x062, 0x0004D232,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000C02,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000C02,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x063, 0x00000C02,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000200,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000233,
		0x030, 0x00001233,
		0x030, 0x00002233,
		0x030, 0x00003233,
		0x030, 0x00004203,
		0x030, 0x00005233,
		0x030, 0x00006233,
		0x030, 0x00007233,
		0x030, 0x00008203,
		0x030, 0x00009233,
		0x030, 0x0000A233,
		0x030, 0x0000B233,
		0x030, 0x0000C233,
		0x030, 0x0000D233,
		0x030, 0x0000E203,
		0x030, 0x0000F233,
		0x030, 0x00010233,
		0x030, 0x00011233,
		0x030, 0x00012203,
		0x030, 0x00013233,
		0x030, 0x00014233,
		0x030, 0x00015233,
		0x030, 0x00016203,
		0x030, 0x00017233,
		0x030, 0x00018203,
		0x030, 0x00019233,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000233,
		0x030, 0x00001233,
		0x030, 0x00002233,
		0x030, 0x00003233,
		0x030, 0x00004203,
		0x030, 0x00005233,
		0x030, 0x00006233,
		0x030, 0x00007233,
		0x030, 0x00008203,
		0x030, 0x00009233,
		0x030, 0x0000A233,
		0x030, 0x0000B233,
		0x030, 0x0000C233,
		0x030, 0x0000D233,
		0x030, 0x0000E203,
		0x030, 0x0000F233,
		0x030, 0x00010233,
		0x030, 0x00011233,
		0x030, 0x00012203,
		0x030, 0x00013233,
		0x030, 0x00014233,
		0x030, 0x00015233,
		0x030, 0x00016203,
		0x030, 0x00017233,
		0x030, 0x00018203,
		0x030, 0x00019233,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000237,
		0x030, 0x00001237,
		0x030, 0x00002237,
		0x030, 0x00003237,
		0x030, 0x00004207,
		0x030, 0x00005237,
		0x030, 0x00006237,
		0x030, 0x00007237,
		0x030, 0x00008207,
		0x030, 0x00009237,
		0x030, 0x0000A237,
		0x030, 0x0000B237,
		0x030, 0x0000C237,
		0x030, 0x0000D237,
		0x030, 0x0000E207,
		0x030, 0x0000F237,
		0x030, 0x00010237,
		0x030, 0x00011237,
		0x030, 0x00012207,
		0x030, 0x00013237,
		0x030, 0x00014237,
		0x030, 0x00015237,
		0x030, 0x00016207,
		0x030, 0x00017237,
		0x030, 0x00018207,
		0x030, 0x00019237,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000238,
		0x030, 0x00001238,
		0x030, 0x00002238,
		0x030, 0x00003238,
		0x030, 0x00004228,
		0x030, 0x00005238,
		0x030, 0x00006238,
		0x030, 0x00007238,
		0x030, 0x00008228,
		0x030, 0x00009238,
		0x030, 0x0000A238,
		0x030, 0x0000B238,
		0x030, 0x0000C238,
		0x030, 0x0000D238,
		0x030, 0x0000E228,
		0x030, 0x0000F238,
		0x030, 0x00010238,
		0x030, 0x00011238,
		0x030, 0x00012228,
		0x030, 0x00013238,
		0x030, 0x00014238,
		0x030, 0x00015238,
		0x030, 0x00016228,
		0x030, 0x00017238,
		0x030, 0x00018228,
		0x030, 0x00019238,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000239,
		0x030, 0x00001239,
		0x030, 0x00002239,
		0x030, 0x00003239,
		0x030, 0x00004239,
		0x030, 0x00005239,
		0x030, 0x00006239,
		0x030, 0x00007239,
		0x030, 0x00008239,
		0x030, 0x00009239,
		0x030, 0x0000A239,
		0x030, 0x0000B239,
		0x030, 0x0000C239,
		0x030, 0x0000D239,
		0x030, 0x0000E209,
		0x030, 0x0000F239,
		0x030, 0x00010239,
		0x030, 0x00011239,
		0x030, 0x00012209,
		0x030, 0x00013239,
		0x030, 0x00014239,
		0x030, 0x00015239,
		0x030, 0x00016209,
		0x030, 0x00017239,
		0x030, 0x00018209,
		0x030, 0x00019239,
	0xA0000000,	0x00000000,
		0x030, 0x00000233,
		0x030, 0x00001233,
		0x030, 0x00002233,
		0x030, 0x00003233,
		0x030, 0x00004203,
		0x030, 0x00005233,
		0x030, 0x00006233,
		0x030, 0x00007233,
		0x030, 0x00008203,
		0x030, 0x00009233,
		0x030, 0x0000A233,
		0x030, 0x0000B233,
		0x030, 0x0000C233,
		0x030, 0x0000D233,
		0x030, 0x0000E203,
		0x030, 0x0000F233,
		0x030, 0x00010233,
		0x030, 0x00011233,
		0x030, 0x00012203,
		0x030, 0x00013233,
		0x030, 0x00014233,
		0x030, 0x00015233,
		0x030, 0x00016203,
		0x030, 0x00017233,
		0x030, 0x00018203,
		0x030, 0x00019233,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000080,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000232,
		0x030, 0x00001232,
		0x030, 0x00002232,
		0x030, 0x00003232,
		0x030, 0x00004232,
		0x030, 0x00005232,
		0x030, 0x00006232,
		0x030, 0x00007232,
		0x030, 0x00008232,
		0x030, 0x00009232,
		0x030, 0x0000A232,
		0x030, 0x0000B232,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000232,
		0x030, 0x00001232,
		0x030, 0x00002232,
		0x030, 0x00003232,
		0x030, 0x00004232,
		0x030, 0x00005232,
		0x030, 0x00006232,
		0x030, 0x00007232,
		0x030, 0x00008232,
		0x030, 0x00009232,
		0x030, 0x0000A232,
		0x030, 0x0000B232,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x030, 0x00000334,
		0x030, 0x00001334,
		0x030, 0x00002334,
		0x030, 0x00003334,
		0x030, 0x00004334,
		0x030, 0x00005334,
		0x030, 0x00006334,
		0x030, 0x00007334,
		0x030, 0x00008334,
		0x030, 0x00009334,
		0x030, 0x0000A334,
		0x030, 0x0000B334,
	0xA0000000,	0x00000000,
		0x030, 0x00000232,
		0x030, 0x00001232,
		0x030, 0x00002232,
		0x030, 0x00003232,
		0x030, 0x00004232,
		0x030, 0x00005232,
		0x030, 0x00006232,
		0x030, 0x00007232,
		0x030, 0x00008232,
		0x030, 0x00009232,
		0x030, 0x0000A232,
		0x030, 0x0000B232,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000770,
		0x030, 0x00001770,
		0x030, 0x00002440,
		0x030, 0x00003440,
		0x030, 0x00004330,
		0x030, 0x00005330,
		0x030, 0x00008770,
		0x030, 0x0000A440,
		0x030, 0x0000C330,
		0x0EF, 0x00000000,
		0x0EE, 0x00010000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x00000005,
		0x033, 0x00000201,
		0x03F, 0x00000008,
		0x033, 0x00000202,
		0x03F, 0x0000000B,
		0x033, 0x00000203,
		0x03F, 0x0000000E,
		0x033, 0x00000204,
		0x03F, 0x0000002B,
		0x033, 0x00000205,
		0x03F, 0x0000002E,
		0x033, 0x00000206,
		0x03F, 0x0000006B,
		0x033, 0x00000207,
		0x03F, 0x0000006E,
		0x033, 0x00000208,
		0x03F, 0x00000071,
		0x033, 0x00000209,
		0x03F, 0x00000074,
		0x033, 0x0000020A,
		0x03F, 0x00000077,
	0xA0000000,	0x00000000,
		0x033, 0x00000200,
		0x03F, 0x0000006A,
		0x033, 0x00000201,
		0x03F, 0x0000006D,
		0x033, 0x00000202,
		0x03F, 0x0000046A,
		0x033, 0x00000203,
		0x03F, 0x0000086A,
		0x033, 0x00000204,
		0x03F, 0x00000C89,
		0x033, 0x00000205,
		0x03F, 0x00000CE8,
		0x033, 0x00000206,
		0x03F, 0x00000CEB,
		0x033, 0x00000207,
		0x03F, 0x00000CEE,
		0x033, 0x00000208,
		0x03F, 0x00000CF1,
		0x033, 0x00000209,
		0x03F, 0x00000CF4,
		0x033, 0x0000020A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x00000005,
		0x033, 0x00000281,
		0x03F, 0x00000008,
		0x033, 0x00000282,
		0x03F, 0x0000000B,
		0x033, 0x00000283,
		0x03F, 0x0000000E,
		0x033, 0x00000284,
		0x03F, 0x0000002B,
		0x033, 0x00000285,
		0x03F, 0x0000002E,
		0x033, 0x00000286,
		0x03F, 0x0000006B,
		0x033, 0x00000287,
		0x03F, 0x0000006E,
		0x033, 0x00000288,
		0x03F, 0x00000071,
		0x033, 0x00000289,
		0x03F, 0x00000074,
		0x033, 0x0000028A,
		0x03F, 0x00000077,
	0xA0000000,	0x00000000,
		0x033, 0x00000280,
		0x03F, 0x0000006A,
		0x033, 0x00000281,
		0x03F, 0x0000006D,
		0x033, 0x00000282,
		0x03F, 0x0000046A,
		0x033, 0x00000283,
		0x03F, 0x0000086A,
		0x033, 0x00000284,
		0x03F, 0x00000C89,
		0x033, 0x00000285,
		0x03F, 0x00000CE8,
		0x033, 0x00000286,
		0x03F, 0x00000CEB,
		0x033, 0x00000287,
		0x03F, 0x00000CEE,
		0x033, 0x00000288,
		0x03F, 0x00000CF1,
		0x033, 0x00000289,
		0x03F, 0x00000CF4,
		0x033, 0x0000028A,
		0x03F, 0x00000CF7,
	0xB0000000,	0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x00000005,
		0x033, 0x00000301,
		0x03F, 0x00000008,
		0x033, 0x00000302,
		0x03F, 0x0000000B,
		0x033, 0x00000303,
		0x03F, 0x0000000E,
		0x033, 0x00000304,
		0x03F, 0x0000002B,
		0x033, 0x00000305,
		0x03F, 0x0000002E,
		0x033, 0x00000306,
		0x03F, 0x00000031,
		0x033, 0x00000307,
		0x03F, 0x00000034,
		0x033, 0x00000308,
		0x03F, 0x00000053,
		0x033, 0x00000309,
		0x03F, 0x00000056,
		0x033, 0x0000030A,
		0x03F, 0x000000D1,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000300,
		0x03F, 0x0000006A,
		0x033, 0x00000301,
		0x03F, 0x0000006D,
		0x033, 0x00000302,
		0x03F, 0x0000046A,
		0x033, 0x00000303,
		0x03F, 0x0000086A,
		0x033, 0x00000304,
		0x03F, 0x00000C89,
		0x033, 0x00000305,
		0x03F, 0x00000CE8,
		0x033, 0x00000306,
		0x03F, 0x00000CEB,
		0x033, 0x00000307,
		0x03F, 0x00000CEE,
		0x033, 0x00000308,
		0x03F, 0x00000CF1,
		0x033, 0x00000309,
		0x03F, 0x00000CF4,
		0x033, 0x0000030A,
		0x03F, 0x00000CF7,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
		0x051, 0x0003C800,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000942C0,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000942C0,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x052, 0x000902CA,
	0xA0000000,	0x00000000,
		0x052, 0x000942C0,
	0xB0000000,	0x00000000,
		0x053, 0x000090F9,
		0x054, 0x00088000,
		0x057, 0x0004C80A,
		0x0EF, 0x00000020,
		0x033, 0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000001,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000002,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000C246,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000C246,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000003,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000004,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000005,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000C246,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000C246,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000006,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000007,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000008,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000C246,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0000C246,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x0000C246,
	0xB0000000,	0x00000000,
		0x033, 0x00000009,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000A,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000B,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000C,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000D,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000241C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000E,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002C246,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000000F,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000010,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000011,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00024246,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000012,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000013,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000014,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000015,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000016,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000018,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000019,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001A,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001B,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001C,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001D,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001E,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000001F,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000020,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000021,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000022,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000023,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000024,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000025,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000026,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000027,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000028,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03E, 0x00000030,
		0x03F, 0x000209C6,
	0xA0000000,	0x00000000,
		0x03E, 0x00000020,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x00000029,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0002CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x033, 0x0000002A,
		0x03E, 0x00000020,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00008E46,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x0001CA46,
	0xA0000000,	0x00000000,
		0x03F, 0x00008E46,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EE, 0x00010000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000487,
		0x033, 0x00000061,
		0x03F, 0x00000887,
		0x033, 0x00000062,
		0x03F, 0x00000947,
		0x033, 0x00000063,
		0x03F, 0x00000D48,
		0x033, 0x00000064,
		0x03F, 0x00000D88,
		0x033, 0x00000065,
		0x03F, 0x00000DE8,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000487,
		0x033, 0x00000061,
		0x03F, 0x00000887,
		0x033, 0x00000062,
		0x03F, 0x00000947,
		0x033, 0x00000063,
		0x03F, 0x00000D48,
		0x033, 0x00000064,
		0x03F, 0x00000D88,
		0x033, 0x00000065,
		0x03F, 0x00000DE8,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000468,
		0x033, 0x00000061,
		0x03F, 0x00000868,
		0x033, 0x00000062,
		0x03F, 0x00000909,
		0x033, 0x00000063,
		0x03F, 0x00000D0A,
		0x033, 0x00000064,
		0x03F, 0x00000D4A,
		0x033, 0x00000065,
		0x03F, 0x00000D8B,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000467,
		0x033, 0x00000061,
		0x03F, 0x00000867,
		0x033, 0x00000062,
		0x03F, 0x00000908,
		0x033, 0x00000063,
		0x03F, 0x00000CC6,
		0x033, 0x00000064,
		0x03F, 0x00000CC9,
		0x033, 0x00000065,
		0x03F, 0x00000CCC,
		0x033, 0x00000066,
		0x03F, 0x00000CCF,
		0x033, 0x00000067,
		0x03F, 0x00000CD2,
		0x033, 0x00000068,
		0x03F, 0x00000CD5,
		0x033, 0x00000069,
		0x03F, 0x00000DD4,
		0x033, 0x0000006A,
		0x03F, 0x00000DD7,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000487,
		0x033, 0x00000061,
		0x03F, 0x00000887,
		0x033, 0x00000062,
		0x03F, 0x00000947,
		0x033, 0x00000063,
		0x03F, 0x00000D48,
		0x033, 0x00000064,
		0x03F, 0x00000D88,
		0x033, 0x00000065,
		0x03F, 0x00000DE8,
		0x033, 0x00000066,
		0x03F, 0x00000DEB,
		0x033, 0x00000067,
		0x03F, 0x00000DEE,
		0x033, 0x00000068,
		0x03F, 0x00000DF1,
		0x033, 0x00000069,
		0x03F, 0x00000DF4,
		0x033, 0x0000006A,
		0x03F, 0x00000DF7,
	0xB0000000,	0x00000000,
	0x80ffff00,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000487,
		0x033, 0x00000021,
		0x03F, 0x00000887,
		0x033, 0x00000022,
		0x03F, 0x00000947,
		0x033, 0x00000023,
		0x03F, 0x00000D48,
		0x033, 0x00000024,
		0x03F, 0x00000D88,
		0x033, 0x00000025,
		0x03F, 0x00000DE8,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x90ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000487,
		0x033, 0x00000021,
		0x03F, 0x00000887,
		0x033, 0x00000022,
		0x03F, 0x00000947,
		0x033, 0x00000023,
		0x03F, 0x00000D48,
		0x033, 0x00000024,
		0x03F, 0x00000D88,
		0x033, 0x00000025,
		0x03F, 0x00000DE8,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x91ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x91ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x92ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x92ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000468,
		0x033, 0x00000021,
		0x03F, 0x00000868,
		0x033, 0x00000022,
		0x03F, 0x00000909,
		0x033, 0x00000023,
		0x03F, 0x00000D0A,
		0x033, 0x00000024,
		0x03F, 0x00000D4A,
		0x033, 0x00000025,
		0x03F, 0x00000D8B,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x93ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x94ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff01,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff02,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff03,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff04,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff05,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff06,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff15,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0x95ffff16,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000467,
		0x033, 0x00000021,
		0x03F, 0x00000867,
		0x033, 0x00000022,
		0x03F, 0x00000908,
		0x033, 0x00000023,
		0x03F, 0x00000D09,
		0x033, 0x00000024,
		0x03F, 0x00000D49,
		0x033, 0x00000025,
		0x03F, 0x00000D8A,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000487,
		0x033, 0x00000021,
		0x03F, 0x00000887,
		0x033, 0x00000022,
		0x03F, 0x00000947,
		0x033, 0x00000023,
		0x03F, 0x00000D48,
		0x033, 0x00000024,
		0x03F, 0x00000D88,
		0x033, 0x00000025,
		0x03F, 0x00000DE8,
		0x033, 0x00000026,
		0x03F, 0x00000DEB,
		0x033, 0x00000027,
		0x03F, 0x00000DEE,
		0x033, 0x00000028,
		0x03F, 0x00000DF1,
		0x033, 0x00000029,
		0x03F, 0x00000DF4,
		0x033, 0x0000002A,
		0x03F, 0x00000DF7,
	0xB0000000,	0x00000000,
		0x0EE, 0x00000000,
		0x05C, 0x000FC000,
		0x067, 0x0000A505,
		0x0D3, 0x00000542,
		0x043, 0x00005000,
		0x059, 0x000A0000,
		0x05A, 0x00060000,
		0x05B, 0x00014000,
		0x001, 0x00040000,
		0x0EE, 0x00000002,
		0x033, 0x00000017,
		0x03F, 0x0000003F,
		0x033, 0x00000018,
		0x03F, 0x0000003F,
		0x033, 0x00000019,
		0x03F, 0x00000000,
		0x033, 0x0000001A,
		0x03F, 0x0000003F,
		0x033, 0x0000001B,
		0x03F, 0x0000003F,
		0x033, 0x0000001C,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
		0x092, 0x00084800,
		0x092, 0x00084801,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x0FE, 0x00000000,
		0x092, 0x00084800,
		0x08F, 0x00001B4C,
		0x088, 0x0004326B,
		0x019, 0x00000005,
		0x0EF, 0x00080000,
		0x033, 0x00000004,
		0x03F, 0x000FD83F,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000006,
		0x03F, 0x000DD83F,
		0x0EF, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000007,
		0x03F, 0x000DF7BF,
		0x0EF, 0x00000000,
		0x0EF, 0x00040000,
		0x033, 0x00000006,
		0x03F, 0x00000002,
		0x033, 0x00000007,
		0x03F, 0x00000002,
		0x0EF, 0x00000000,

};

void
odm_read_and_config_mp_8822c_radiob(struct dm_struct *dm)
{
	boolean is_matched, find_target;
	u32 cfg_target = 0, cfg_para = 0;
	u32 i = 0;
	u32 array_len = 0;
	u32 *array = NULL;
	u32 v1 = 0, v2 = 0;
	u8 h_size = 0;
	u8 h_idx = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	array_len =
		sizeof(array_mp_8822c_radiob) / sizeof(u32);
	array = (u32 *)array_mp_8822c_radiob;

	if (!halbb_sel_headline(dm, array, array_len, &h_size, &h_idx)) {
		PHYDM_DBG(dm, ODM_COMP_INIT, "No any match case.\n");
		return;
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "len = %d, h_size = %d, h_idx = %d\n",
			  array_len, h_size, h_idx);

	if (h_size != 0) {
		cfg_target = array[h_idx << 1] & 0x0fffffff;
	}

	i += h_size;

	PHYDM_DBG(dm, ODM_COMP_INIT, "cfg_target = 0x%x\n", cfg_target);
	PHYDM_DBG(dm, ODM_COMP_INIT, "array[i] = 0x%x, array[i+1] = 0x%x\n",
			  array[i], array[i + 1]);

	halbb_flag_2_default(&is_matched, &find_target);
	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];
		i += 2;

		switch (v1 >> 28) {
		case PARA_IF:
		case PARA_ELSE_IF:
			cfg_para = v1 & 0x0fffffff;
			PHYDM_DBG(dm, ODM_COMP_INIT, "*if (cart=%d, rfe=%d)\n",
			       (cfg_para & 0x0f000000) >> 24, cfg_para & 0xff);
			break;
		case PARA_ELSE:
			PHYDM_DBG(dm, ODM_COMP_INIT, "*else\n");
			is_matched = false;
			if (!find_target) {
				PHYDM_DBG(dm, ODM_COMP_INIT, "Init Fail in Reg 0x%x\n", array[i]);
				return;
			}
			break;
		case PARA_END:
			PHYDM_DBG(dm, ODM_COMP_INIT, "*endif\n");
			halbb_flag_2_default(&is_matched, &find_target);
			break;
		case PARA_CHK:
			/*Check this para meets driver's requirement or not*/
			if (find_target) {
				PHYDM_DBG(dm, ODM_COMP_INIT, "	 skip\n");
				is_matched = false;
				break;
			}

			if (cfg_para == cfg_target) {
				is_matched = true;
				find_target = true;
			} else {
				is_matched = false;
				find_target = false;
			}
			PHYDM_DBG(dm, ODM_COMP_INIT, "	 match=%d\n", is_matched);
			break;
		default:
			if (is_matched)
					odm_config_rf_radio_b_8822c(dm, v1, v2);
			break;
		}
	}
	PHYDM_DBG(dm, ODM_COMP_INIT, "BBCR Init Success\n");
}

u32
odm_get_version_mp_8822c_radiob(void)
{
		return 61;
}

/******************************************************************************
 *                           txpowertrack.TXT
 ******************************************************************************/

#ifdef CONFIG_8822C
const u8 delta_swingidx_mp_5gb_n_txpwrtrk_8822c[][D_S_SIZE] = {
	{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18,
	 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32},
	{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18,
	 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32},
	{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18,
	 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrk_8822c[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 22, 23, 24, 25, 26, 27},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 22, 23, 24, 25, 26, 27},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 22, 23, 24, 25, 26, 27},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrk_8822c[][D_S_SIZE] = {
	{0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18,
	 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33},
	{0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18,
	 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33},
	{0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18,
	 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrk_8822c[][D_S_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrk_8822c[]    = {
	0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 14,
	 15, 15, 16, 17, 18, 19, 20, 20, 21, 22, 23, 24, 25};
const u8 delta_swingidx_mp_2gb_p_txpwrtrk_8822c[]    = {
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28};
const u8 delta_swingidx_mp_2ga_n_txpwrtrk_8822c[]    = {
	0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11,
	 11, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19};
const u8 delta_swingidx_mp_2ga_p_txpwrtrk_8822c[]    = {
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 15,
	 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 26, 27};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8822c[] = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14,
	 15, 16, 17, 17, 18, 19, 20, 21, 22, 23, 23, 24, 25};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8822c[] = {
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8822c[] = {
	0, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 12, 12,
	 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 21, 22};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8822c[] = {
	0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14,
	 15, 16, 17, 18, 18, 19, 20, 21, 22, 23, 24, 24, 25};
#endif

void
odm_read_and_config_mp_8822c_txpowertrack(struct dm_struct *dm)
{
#ifdef CONFIG_8822C

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrk_8822c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpowertracktssi.TXT
 ******************************************************************************/

#ifdef CONFIG_8822CTSSI
const u8 delta_swingidx_mp_5gb_n_txpwrtrktssi_8822c[][D_S_SIZE] = {
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9},
};

const u8 delta_swingidx_mp_5gb_p_txpwrtrktssi_8822c[][D_S_SIZE] = {
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
};

const u8 delta_swingidx_mp_5ga_n_txpwrtrktssi_8822c[][D_S_SIZE] = {
	{0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5,
	 5, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5,
	 5, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
	{0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5,
	 5, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10},
};

const u8 delta_swingidx_mp_5ga_p_txpwrtrktssi_8822c[][D_S_SIZE] = {
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
	{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4,
	 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9},
};

const u8 delta_swingidx_mp_2gb_n_txpwrtrktssi_8822c[]    = {
	0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12};
const u8 delta_swingidx_mp_2gb_p_txpwrtrktssi_8822c[]    = {
	0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6,
	 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11};
const u8 delta_swingidx_mp_2ga_n_txpwrtrktssi_8822c[]    = {
	0, 0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6,
	 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12};
const u8 delta_swingidx_mp_2ga_p_txpwrtrktssi_8822c[]    = {
	0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7,
	 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13};
const u8 delta_swingidx_mp_2g_cck_b_n_txpwrtrktssi_8822c[] = {
	0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5,
	 5, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10};
const u8 delta_swingidx_mp_2g_cck_b_p_txpwrtrktssi_8822c[] = {
	0, 0, 0, 1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5,
	 6, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 11};
const u8 delta_swingidx_mp_2g_cck_a_n_txpwrtrktssi_8822c[] = {
	0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7,
	 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13};
const u8 delta_swingidx_mp_2g_cck_a_p_txpwrtrktssi_8822c[] = {
	0, 0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6,
	 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12};
#endif

void
odm_read_and_config_mp_8822c_txpowertracktssi(struct dm_struct *dm)
{
#ifdef CONFIG_8822CTSSI

struct dm_rf_calibration_struct  *cali_info = &dm->rf_calibrate_info;

PHYDM_DBG(dm, ODM_COMP_INIT, "===> ODM_ReadAndConfig_MP_mp_8822c\n");

odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_p,
		(void *)delta_swingidx_mp_2ga_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2ga_n,
		(void *)delta_swingidx_mp_2ga_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_p,
		(void *)delta_swingidx_mp_2gb_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2gb_n,
		(void *)delta_swingidx_mp_2gb_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_p,
		(void *)delta_swingidx_mp_2g_cck_a_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_a_n,
		(void *)delta_swingidx_mp_2g_cck_a_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_p,
		(void *)delta_swingidx_mp_2g_cck_b_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);
odm_move_memory(dm, cali_info->delta_swing_table_idx_2g_cck_b_n,
		(void *)delta_swingidx_mp_2g_cck_b_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE);

odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_p,
		(void *)delta_swingidx_mp_5ga_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5ga_n,
		(void *)delta_swingidx_mp_5ga_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_p,
		(void *)delta_swingidx_mp_5gb_p_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE * 3);
odm_move_memory(dm, cali_info->delta_swing_table_idx_5gb_n,
		(void *)delta_swingidx_mp_5gb_n_txpwrtrktssi_8822c,
		DELTA_SWINGIDX_SIZE * 3);
#endif
}

/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

#ifdef CONFIG_8822C
const struct txpwr_lmt_t_8822c array_mp_8822c_txpwr_lmt[] = {
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 72},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 72},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 72},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 72},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 72},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 72},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 72},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 72},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 72},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 72},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 72},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 72},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 72},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 72},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 72},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 72},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 48},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 48},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 48},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 48},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 68},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 72},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 72},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 72},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 1, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 72},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 72},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 72},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 2, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 5, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 6, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 7, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 8, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 9, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 72},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 72},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 72},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 10, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 72},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 72},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 72},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 11, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 12, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 36},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 36},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 36},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 36},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 13, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 56},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_CCK, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 68},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 68},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 68},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 68},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 68},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 68},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 68},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 68},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 40},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 40},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 40},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 40},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 28},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 28},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 28},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 1, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 2, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 68},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 68},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 68},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 68},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 5, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 6, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 7, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 68},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 68},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 68},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 68},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 8, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 9, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 10, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 11, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 40},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 40},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 40},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 40},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 12, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 48},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 64},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 28},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 62},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 48},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 28},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 48},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 28},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 13, 48},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 68},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 68},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 68},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 68},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 68},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 68},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 68},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 68},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 40},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 40},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 40},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 40},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 76},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 28},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 72},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 28},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 28},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 68},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 68},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 68},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 68},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 68},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 76},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 68},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 68},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 68},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 68},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 40},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 40},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 40},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 40},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 28},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 62},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 28},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 28},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 1, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 2, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 72},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 72},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 3, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 72},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 72},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 4, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 72},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 72},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 5, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 72},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 72},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 6, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 72},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 72},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 7, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 72},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 72},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 8, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 72},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 72},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 9, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 40},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 72},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 40},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 72},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 40},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 40},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 10, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 28},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 72},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 28},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 28},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 28},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 11, 60},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 12, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 13, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_1T, 14, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 1, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 2, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 66},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 48},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 3, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 48},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 4, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 5, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 64},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 64},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 64},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 6, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 60},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 60},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 60},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 60},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 7, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 8, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 52},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 52},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 52},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 52},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 9, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 40},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 40},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 70},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 40},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 40},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 10, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 26},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 36},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 66},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 26},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 66},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 36},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 26},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 36},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 26},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 11, 36},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 12, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 13, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_IC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_CN, PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_RS_HT, PW_LMT_PH_2T, 14, 127},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 74},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 62},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 60},
	{PW_LMT_REGU_IC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 62},
	{PW_LMT_REGU_KCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 76},
	{PW_LMT_REGU_ACMA, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 62},
	{PW_LMT_REGU_CHILE, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 64},
	{PW_LMT_REGU_UKRAINE, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 54},
	{PW_LMT_REGU_MEXICO, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 62},
	{PW_LMT_REGU_CN, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 36, 62},
	{PW_LMT_REGU_FCC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 40, 76},
	{PW_LMT_REGU_ETSI, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 40, 62},
	{PW_LMT_REGU_MKK, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T, 40, 62},
	{PW_LMT_REGU_IC, PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_RS_OFDM, PW_LMT_PH_1T,