/* rygel-media-object.c generated by valac 0.40.8, the Vala compiler
 * generated from rygel-media-object.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libxml/tree.h>
#include <rygel-core.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
enum  {
	RYGEL_MEDIA_OBJECT_0_PROPERTY,
	RYGEL_MEDIA_OBJECT_ID_PROPERTY,
	RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY,
	RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY,
	RYGEL_MEDIA_OBJECT_DATE_PROPERTY,
	RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY,
	RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY,
	RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY,
	RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY,
	RYGEL_MEDIA_OBJECT_GENRE_PROPERTY,
	RYGEL_MEDIA_OBJECT_PARENT_PROPERTY,
	RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY,
	RYGEL_MEDIA_OBJECT_TITLE_PROPERTY,
	RYGEL_MEDIA_OBJECT_OCM_FLAGS_PROPERTY,
	RYGEL_MEDIA_OBJECT_RESTRICTED_PROPERTY,
	RYGEL_MEDIA_OBJECT_NUM_PROPERTIES
};
static GParamSpec* rygel_media_object_properties[RYGEL_MEDIA_OBJECT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelMediaObjectGetWritableData RygelMediaObjectGetWritableData;
typedef struct _RygelMediaObjectGetWritablesData RygelMediaObjectGetWritablesData;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define RYGEL_TYPE_SERIALIZER_TYPE (rygel_serializer_type_get_type ())

#define RYGEL_TYPE_UPDATABLE_OBJECT (rygel_updatable_object_get_type ())
#define RYGEL_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObject))
#define RYGEL_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT))
#define RYGEL_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_UPDATABLE_OBJECT, RygelUpdatableObjectIface))

typedef struct _RygelUpdatableObject RygelUpdatableObject;
typedef struct _RygelUpdatableObjectIface RygelUpdatableObjectIface;
typedef struct _RygelMediaObjectApplyFragmentsData RygelMediaObjectApplyFragmentsData;
typedef struct _RygelMediaObjectCheckWritableData RygelMediaObjectCheckWritableData;

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaObjectPrivate {
	gchar* _id;
	gchar* _ref_id;
	gchar* _upnp_class;
	gchar* _date;
	gchar* _creator;
	guint64 _modified;
	guint _object_update_id;
	gchar* _artist;
	gchar* _genre;
	GeeArrayList* uris;
	GeeList* media_resources;
	RygelMediaContainer* _parent_ref;
	gchar* _title;
};

struct _RygelMediaObjectGetWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GFile* result;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _uri_size;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _uri_index;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* uri;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GFile* file;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	gboolean _tmp13_;
	GFile* _tmp14_;
	GError * _inner_error_;
};

struct _RygelMediaObjectGetWritablesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaObject* self;
	GCancellable* cancellable;
	GeeArrayList* result;
	GeeArrayList* writables;
	GeeArrayList* _tmp0_;
	GeeArrayList* _uri_list;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _uri_size;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _uri_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* uri;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	GFile* file;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gboolean _tmp14_;
	GFile* _tmp15_;
	GeeArrayList* _tmp16_;
	GFile* _tmp17_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	gchar* replaced_string;
};

typedef enum  {
	RYGEL_SERIALIZER_TYPE_GENERIC_DIDL,
	RYGEL_SERIALIZER_TYPE_DIDL_S,
	RYGEL_SERIALIZER_TYPE_M3UEXT
} RygelSerializerType;

struct _RygelUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit) (RygelUpdatableObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_finish) (RygelUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaObjectApplyFragmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaObject* self;
	GeeLinkedList* current_fragments;
	GeeLinkedList* new_fragments;
	RygelHTTPServer* http_server;
	GUPnPDIDLLiteFragmentResult result;
	GUPnPDIDLLiteFragmentResult _result_;
	RygelSerializer* writer;
	RygelSerializer* _tmp0_;
	GUPnPDIDLLiteObject* didl_object;
	RygelSerializer* _tmp1_;
	GUPnPDIDLLiteObject* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	xmlNode* _tmp4_;
	xmlNode* _tmp5_;
	GUPnPDIDLLiteObject* _tmp6_;
	xmlNs* _tmp7_;
	xmlNs* _tmp8_;
	GUPnPDIDLLiteObject* _tmp9_;
	gint _tmp10_;
	gpointer* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	gpointer* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GUPnPDIDLLiteFragmentResult _tmp16_;
	GUPnPDIDLLiteObject* _tmp17_;
	GError* e;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

struct _RygelMediaObjectCheckWritableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaObject* self;
	GFile* file;
	GCancellable* cancellable;
	gboolean result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GFileInfo* info;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	GError* _error_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_MEDIA_ITEM_ERROR_BAD_URI
} RygelMediaItemError;
#define RYGEL_MEDIA_ITEM_ERROR rygel_media_item_error_quark ()

static gpointer rygel_media_object_parent_class = NULL;
static GRegex* rygel_media_object_real_name_regex;
static GRegex* rygel_media_object_real_name_regex = NULL;
static GRegex* rygel_media_object_user_name_regex;
static GRegex* rygel_media_object_user_name_regex = NULL;
static GRegex* rygel_media_object_host_name_regex;
static GRegex* rygel_media_object_host_name_regex = NULL;
static GRegex* rygel_media_object_pretty_name_regex;
static GRegex* rygel_media_object_pretty_name_regex = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_OBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectPrivate))
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self);
void rygel_media_object_add_uri (RygelMediaObject* self,
                                 const gchar* uri);
static void rygel_media_object_real_add_uri (RygelMediaObject* self,
                                      const gchar* uri);
static void rygel_media_object_real_constructed (GObject* base);
static void rygel_media_object_get_writable_data_free (gpointer _data);
static void rygel_media_object_get_writable_async_ready_wrapper (GObject *source_object,
                                                          GAsyncResult *res,
                                                          void *user_data);
void rygel_media_object_get_writable (RygelMediaObject* self,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static gboolean rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_);
static void rygel_media_object_check_writable (RygelMediaObject* self,
                                        GFile* file,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean rygel_media_object_check_writable_finish (RygelMediaObject* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static void rygel_media_object_get_writable_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void rygel_media_object_get_writables_data_free (gpointer _data);
static void rygel_media_object_get_writables_async_ready_wrapper (GObject *source_object,
                                                           GAsyncResult *res,
                                                           void *user_data);
void rygel_media_object_get_writables (RygelMediaObject* self,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
GeeArrayList* rygel_media_object_get_writables_finish (RygelMediaObject* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static gboolean rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_);
static void rygel_media_object_get_writables_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
GeeList* rygel_media_object_get_resource_list (RygelMediaObject* self);
RygelMediaResource* rygel_media_object_get_resource_by_name (RygelMediaObject* self,
                                                             const gchar* resource_name);
gchar* rygel_media_resource_get_name (RygelMediaResource* self);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self,
                                                   RygelSerializer* serializer,
                                                   RygelHTTPServer* http_server,
                                                   GError** error);
static GUPnPDIDLLiteObject* rygel_media_object_real_serialize (RygelMediaObject* self,
                                                        RygelSerializer* serializer,
                                                        RygelHTTPServer* http_server,
                                                        GError** error);
void rygel_media_object_serialize_resource_list (RygelMediaObject* self,
                                                 GUPnPDIDLLiteObject* didl_object,
                                                 RygelHTTPServer* http_server,
                                                 GError** error);
GHashTable* rygel_http_server_get_replacements (RygelHTTPServer* self);
const gchar* rygel_media_resource_get_uri (RygelMediaResource* self);
gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self,
                                                RygelMediaObject* object,
                                                gint thumbnail_index,
                                                gint subtitle_index,
                                                const gchar* resource_name);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
void rygel_media_resource_set_import_uri (RygelMediaResource* self,
                                          const gchar* value);
void rygel_media_resource_set_uri (RygelMediaResource* self,
                                   const gchar* value);
void rygel_http_server_set_resource_delivery_options (RygelHTTPServer* self,
                                                      RygelMediaResource* res);
GUPnPDIDLLiteResource* rygel_media_resource_serialize (RygelMediaResource* self,
                                                       GUPnPDIDLLiteResource* didl_resource,
                                                       GHashTable* replacements);
gchar* rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                                const gchar* uri,
                                                GError** error);
gboolean rygel_http_server_is_local (RygelHTTPServer* self);
gchar* rygel_media_object_apply_replacements (GHashTable* replacement_pairs,
                                              const gchar* source_string);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda4_ (Block4Data* _data4_,
                 const gchar* search_string,
                 const gchar* replacement);
static void ___lambda4__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
RygelDataSource* rygel_media_object_create_stream_source_for_resource (RygelMediaObject* self,
                                                                       RygelHTTPRequest* request,
                                                                       RygelMediaResource* resource,
                                                                       GError** error);
static RygelDataSource* rygel_media_object_real_create_stream_source_for_resource (RygelMediaObject* self,
                                                                            RygelHTTPRequest* request,
                                                                            RygelMediaResource* resource,
                                                                            GError** error);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object);
static void rygel_media_object_real_apply_didl_lite (RygelMediaObject* self,
                                              GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_set_title (RygelMediaObject* self,
                                   const gchar* value);
static gchar* rygel_media_object_get_first (RygelMediaObject* self,
                                     GList* contributors);
void rygel_media_object_set_artist (RygelMediaObject* self,
                                    const gchar* value);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
void rygel_media_object_set_genre (RygelMediaObject* self,
                                   const gchar* value);
static void rygel_media_object_clean_node (RygelMediaObject* self,
                                    xmlNode* node,
                                    xmlNs* ns);
static void rygel_media_object_apply_fragments_data_free (gpointer _data);
static void rygel_media_object_apply_fragments_async_ready_wrapper (GObject *source_object,
                                                             GAsyncResult *res,
                                                             void *user_data);
void rygel_media_object_apply_fragments (RygelMediaObject* self,
                                         GeeLinkedList* current_fragments,
                                         GeeLinkedList* new_fragments,
                                         RygelHTTPServer* http_server,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self,
                                                                       GAsyncResult* _res_);
static gboolean rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_);
GType rygel_serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (RygelSerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type,
                                             RygelSerializerType type);
GType rygel_updatable_object_get_type (void) G_GNUC_CONST;
void rygel_updatable_object_commit (RygelUpdatableObject* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
void rygel_updatable_object_commit_finish (RygelUpdatableObject* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static void rygel_media_object_apply_fragments_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
gint rygel_media_object_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property);
static gint rygel_media_object_real_compare_by_property (RygelMediaObject* self,
                                                  RygelMediaObject* media_object,
                                                  const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self,
                                              const gchar* prop1,
                                              const gchar* prop2);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_upnp_class (RygelMediaObject* self);
const gchar* rygel_media_object_get_artist (RygelMediaObject* self);
const gchar* rygel_media_object_get_genre (RygelMediaObject* self);
const gchar* rygel_media_object_get_creator (RygelMediaObject* self);
static gint rygel_media_object_compare_by_date (RygelMediaObject* self,
                                         RygelMediaObject* object);
gint rygel_media_object_compare_int_props (RygelMediaObject* self,
                                           gint prop1,
                                           gint prop2);
static void rygel_media_object_check_writable_data_free (gpointer _data);
static void rygel_media_object_check_writable_async_ready_wrapper (GObject *source_object,
                                                            GAsyncResult *res,
                                                            void *user_data);
static gboolean rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_);
#define RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME "rygel-writable://"
static void rygel_media_object_check_writable_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
const gchar* rygel_media_object_get_date (RygelMediaObject* self);
static gint rygel_media_object_compare_long (RygelMediaObject* self,
                                      glong a,
                                      glong b);
GQuark rygel_media_item_error_quark (void);
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
GList* rygel_media_engine_get_internal_protocol_schemes (RygelMediaEngine* self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
RygelMediaObject* rygel_media_object_construct (GType object_type);
void rygel_media_object_set_id (RygelMediaObject* self,
                                const gchar* value);
const gchar* rygel_media_object_get_ref_id (RygelMediaObject* self);
void rygel_media_object_set_ref_id (RygelMediaObject* self,
                                    const gchar* value);
void rygel_media_object_set_upnp_class (RygelMediaObject* self,
                                        const gchar* value);
void rygel_media_object_set_date (RygelMediaObject* self,
                                  const gchar* value);
void rygel_media_object_set_creator (RygelMediaObject* self,
                                     const gchar* value);
guint64 rygel_media_object_get_modified (RygelMediaObject* self);
void rygel_media_object_set_modified (RygelMediaObject* self,
                                      guint64 value);
guint rygel_media_object_get_object_update_id (RygelMediaObject* self);
void rygel_media_object_set_object_update_id (RygelMediaObject* self,
                                              guint value);
void rygel_media_object_set_parent (RygelMediaObject* self,
                                    RygelMediaContainer* value);
RygelMediaContainer* rygel_media_object_get_parent_ref (RygelMediaObject* self);
void rygel_media_object_set_parent_ref (RygelMediaObject* self,
                                        RygelMediaContainer* value);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_media_object_finalize (GObject * obj);
static void _vala_rygel_media_object_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_rygel_media_object_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


GeeList*
rygel_media_object_get_uris (RygelMediaObject* self)
{
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uris;
	_tmp1_ = _g_object_ref0 ((GeeList*) _tmp0_);
	result = _tmp1_;
	return result;
}


gchar*
rygel_media_object_get_primary_uri (RygelMediaObject* self)
{
	gchar* result = NULL;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uris;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->uris;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
	result = (gchar*) _tmp4_;
	return result;
}


static void
rygel_media_object_real_add_uri (RygelMediaObject* self,
                                 const gchar* uri)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->uris;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, uri);
}


void
rygel_media_object_add_uri (RygelMediaObject* self,
                            const gchar* uri)
{
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_OBJECT_GET_CLASS (self)->add_uri (self, uri);
}


static void
rygel_media_object_real_constructed (GObject* base)
{
	RygelMediaObject * self;
	GeeArrayList* _tmp0_;
	self = (RygelMediaObject*) base;
	G_OBJECT_CLASS (rygel_media_object_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->uris);
	self->priv->uris = _tmp0_;
}


static void
rygel_media_object_get_writable_data_free (gpointer _data)
{
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectGetWritableData, _data_);
}


static void
rygel_media_object_get_writable_async_ready_wrapper (GObject *source_object,
                                                     GAsyncResult *res,
                                                     void *user_data)
{
	RygelMediaObjectGetWritableData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void
rygel_media_object_get_writable (RygelMediaObject* self,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelMediaObjectGetWritableData* _data_;
	RygelMediaObject* _tmp0_;
	GCancellable* _tmp1_;
	_data_ = g_slice_new0 (RygelMediaObjectGetWritableData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_media_object_get_writable_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_object_get_writable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	rygel_media_object_get_writable_co (_data_);
}


GFile*
rygel_media_object_get_writable_finish (RygelMediaObject* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GFile* result;
	RygelMediaObjectGetWritableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches a File object for any writable URI available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void
rygel_media_object_get_writable_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	RygelMediaObjectGetWritableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_media_object_get_writable_co (_data_);
}


static gboolean
rygel_media_object_get_writable_co (RygelMediaObjectGetWritableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->uris;
		_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
		_data_->_uri_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_uri_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_uri_size = _data_->_tmp4_;
		_data_->_uri_index = -1;
		while (TRUE) {
			_data_->_tmp5_ = _data_->_uri_index;
			_data_->_uri_index = _data_->_tmp5_ + 1;
			_data_->_tmp6_ = _data_->_uri_index;
			_data_->_tmp7_ = _data_->_uri_size;
			if (!(_data_->_tmp6_ < _data_->_tmp7_)) {
				break;
			}
			_data_->_tmp8_ = _data_->_uri_list;
			_data_->_tmp9_ = _data_->_uri_index;
			_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp8_, _data_->_tmp9_);
			_data_->uri = (gchar*) _data_->_tmp10_;
			_data_->_tmp11_ = _data_->uri;
			_data_->_tmp12_ = g_file_new_for_uri (_data_->_tmp11_);
			_data_->file = _data_->_tmp12_;
			_data_->_tmp14_ = _data_->file;
			_data_->_state_ = 1;
			rygel_media_object_check_writable (_data_->self, _data_->_tmp14_, _data_->cancellable, rygel_media_object_get_writable_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp13_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->_uri_list);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->_tmp13_) {
				_data_->result = _data_->file;
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->_uri_list);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (_data_->_task_complete_ != TRUE) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->uri);
		}
		_g_object_unref0 (_data_->_uri_list);
	}
	_data_->result = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void
rygel_media_object_get_writables_data_free (gpointer _data)
{
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectGetWritablesData, _data_);
}


static void
rygel_media_object_get_writables_async_ready_wrapper (GObject *source_object,
                                                      GAsyncResult *res,
                                                      void *user_data)
{
	RygelMediaObjectGetWritablesData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void
rygel_media_object_get_writables (RygelMediaObject* self,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	RygelMediaObjectGetWritablesData* _data_;
	RygelMediaObject* _tmp0_;
	GCancellable* _tmp1_;
	_data_ = g_slice_new0 (RygelMediaObjectGetWritablesData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_media_object_get_writables_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_object_get_writables_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	rygel_media_object_get_writables_co (_data_);
}


GeeArrayList*
rygel_media_object_get_writables_finish (RygelMediaObject* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GeeArrayList* result;
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Fetches File objects for all writable URIs available for this object.
     *
     * @param cancellable A GLib.Cancellable
     */
static void
rygel_media_object_get_writables_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	RygelMediaObjectGetWritablesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_media_object_get_writables_co (_data_);
}


static gboolean
rygel_media_object_get_writables_co (RygelMediaObjectGetWritablesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->writables = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->priv->uris;
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
		_data_->_uri_list = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->_uri_list;
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_uri_size = _data_->_tmp5_;
		_data_->_uri_index = -1;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_uri_index;
			_data_->_uri_index = _data_->_tmp6_ + 1;
			_data_->_tmp7_ = _data_->_uri_index;
			_data_->_tmp8_ = _data_->_uri_size;
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
				break;
			}
			_data_->_tmp9_ = _data_->_uri_list;
			_data_->_tmp10_ = _data_->_uri_index;
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
			_data_->uri = (gchar*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->uri;
			_data_->_tmp13_ = g_file_new_for_uri (_data_->_tmp12_);
			_data_->file = _data_->_tmp13_;
			_data_->_tmp15_ = _data_->file;
			_data_->_state_ = 1;
			rygel_media_object_check_writable (_data_->self, _data_->_tmp15_, _data_->cancellable, rygel_media_object_get_writables_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp14_ = rygel_media_object_check_writable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->uri);
				_g_object_unref0 (_data_->_uri_list);
				_g_object_unref0 (_data_->writables);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (_data_->_tmp14_) {
				_data_->_tmp16_ = _data_->writables;
				_data_->_tmp17_ = _data_->file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp16_, _data_->_tmp17_);
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->uri);
		}
		_g_object_unref0 (_data_->_uri_list);
	}
	_data_->result = _data_->writables;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Return the MediaResource list.
     */
GeeList*
rygel_media_object_get_resource_list (RygelMediaObject* self)
{
	GeeList* result = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->media_resources;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


RygelMediaResource*
rygel_media_object_get_resource_by_name (RygelMediaObject* self,
                                         const gchar* resource_name)
{
	RygelMediaResource* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (resource_name != NULL, NULL);
	{
		GeeList* _resource_list = NULL;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _resource_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _resource_index = 0;
		_tmp0_ = self->priv->media_resources;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_resource_list = _tmp1_;
		_tmp2_ = _resource_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_resource_size = _tmp4_;
		_resource_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			RygelMediaResource* resource = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			RygelMediaResource* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			_tmp5_ = _resource_index;
			_resource_index = _tmp5_ + 1;
			_tmp6_ = _resource_index;
			_tmp7_ = _resource_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _resource_list;
			_tmp9_ = _resource_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			resource = (RygelMediaResource*) _tmp10_;
			_tmp11_ = resource;
			_tmp12_ = rygel_media_resource_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, resource_name) == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				result = resource;
				_g_object_unref0 (_resource_list);
				return result;
			}
			_g_object_unref0 (resource);
		}
		_g_object_unref0 (_resource_list);
	}
	result = NULL;
	return result;
}


static GUPnPDIDLLiteObject*
rygel_media_object_real_serialize (RygelMediaObject* self,
                                   RygelSerializer* serializer,
                                   RygelHTTPServer* http_server,
                                   GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GUPnPDIDLLiteObject*
rygel_media_object_serialize (RygelMediaObject* self,
                              RygelSerializer* serializer,
                              RygelHTTPServer* http_server,
                              GError** error)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->serialize (self, serializer, http_server, error);
}


/**
     * Serialize the resource list
     *
     * Any resource with an empty URIs will get a resource-based HTTP URI and have its protocol
     * and delivery options adjusted to the HTTPServer.
     *
     * Internal (e.g. "file:") resources will only be included when the http server
     * is on the local host.
     *
     * Resources will be serialized in list order.
     */
void
rygel_media_object_serialize_resource_list (RygelMediaObject* self,
                                            GUPnPDIDLLiteObject* didl_object,
                                            RygelHTTPServer* http_server,
                                            GError** error)
{
	GHashTable* replacements = NULL;
	GHashTable* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (didl_object != NULL);
	g_return_if_fail (http_server != NULL);
	_tmp0_ = rygel_http_server_get_replacements (http_server);
	replacements = _tmp0_;
	{
		GeeList* _res_list = NULL;
		GeeList* _tmp1_;
		gint _res_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _res_index = 0;
		_tmp1_ = rygel_media_object_get_resource_list (self);
		_res_list = _tmp1_;
		_tmp2_ = _res_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_res_size = _tmp4_;
		_res_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			RygelMediaResource* res = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			RygelMediaResource* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp5_ = _res_index;
			_res_index = _tmp5_ + 1;
			_tmp6_ = _res_index;
			_tmp7_ = _res_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _res_list;
			_tmp9_ = _res_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			res = (RygelMediaResource*) _tmp10_;
			_tmp12_ = res;
			_tmp13_ = rygel_media_resource_get_uri (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == NULL) {
				_tmp11_ = TRUE;
			} else {
				RygelMediaResource* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = res;
				_tmp16_ = rygel_media_resource_get_uri (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = g_strcmp0 (_tmp17_, "") == 0;
			}
			if (_tmp11_) {
				gchar* uri = NULL;
				RygelMediaResource* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gboolean _tmp23_ = FALSE;
				GUPnPDIDLLiteResource* didl_resource = NULL;
				GUPnPDIDLLiteResource* _tmp30_;
				RygelMediaResource* _tmp31_;
				RygelMediaResource* _tmp32_;
				GUPnPDIDLLiteResource* _tmp33_;
				GHashTable* _tmp34_;
				GUPnPDIDLLiteResource* _tmp35_;
				GUPnPDIDLLiteResource* _tmp36_;
				RygelMediaResource* _tmp37_;
				RygelMediaResource* _tmp38_;
				_tmp18_ = res;
				_tmp19_ = rygel_media_resource_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = rygel_http_server_create_uri_for_object (http_server, self, -1, -1, _tmp20_);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp20_);
				uri = _tmp22_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
					gboolean _tmp24_;
					gboolean _tmp25_;
					_tmp24_ = rygel_media_file_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (self, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) self) : NULL);
					_tmp25_ = _tmp24_;
					_tmp23_ = _tmp25_;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					RygelMediaResource* _tmp26_;
					const gchar* _tmp27_;
					_tmp26_ = res;
					_tmp27_ = uri;
					rygel_media_resource_set_import_uri (_tmp26_, _tmp27_);
				} else {
					RygelMediaResource* _tmp28_;
					const gchar* _tmp29_;
					_tmp28_ = res;
					_tmp29_ = uri;
					rygel_media_resource_set_uri (_tmp28_, _tmp29_);
				}
				_tmp30_ = gupnp_didl_lite_object_add_resource (didl_object);
				didl_resource = _tmp30_;
				_tmp31_ = res;
				rygel_http_server_set_resource_delivery_options (http_server, _tmp31_);
				_tmp32_ = res;
				_tmp33_ = didl_resource;
				_tmp34_ = replacements;
				_tmp35_ = rygel_media_resource_serialize (_tmp32_, _tmp33_, _tmp34_);
				_tmp36_ = _tmp35_;
				_g_object_unref0 (_tmp36_);
				_tmp37_ = res;
				rygel_media_resource_set_uri (_tmp37_, NULL);
				_tmp38_ = res;
				rygel_media_resource_set_import_uri (_tmp38_, NULL);
				_g_object_unref0 (didl_resource);
				_g_free0 (uri);
			} else {
				{
					gchar* protocol = NULL;
					RygelMediaResource* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					gboolean _tmp43_ = FALSE;
					const gchar* _tmp44_;
					_tmp39_ = res;
					_tmp40_ = rygel_media_resource_get_uri (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = rygel_media_object_get_protocol_for_uri (self, _tmp41_, &_inner_error_);
					protocol = _tmp42_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch14_g_error;
					}
					_tmp44_ = protocol;
					if (_tmp44_ != NULL) {
						gboolean _tmp45_ = FALSE;
						const gchar* _tmp46_;
						_tmp46_ = protocol;
						if (g_strcmp0 (_tmp46_, "internal") != 0) {
							_tmp45_ = TRUE;
						} else {
							_tmp45_ = rygel_http_server_is_local (http_server);
						}
						_tmp43_ = _tmp45_;
					} else {
						_tmp43_ = FALSE;
					}
					if (_tmp43_) {
						GUPnPDIDLLiteResource* didl_resource = NULL;
						GUPnPDIDLLiteResource* _tmp47_;
						RygelMediaResource* _tmp48_;
						GUPnPDIDLLiteResource* _tmp49_;
						GHashTable* _tmp50_;
						GUPnPDIDLLiteResource* _tmp51_;
						GUPnPDIDLLiteResource* _tmp52_;
						_tmp47_ = gupnp_didl_lite_object_add_resource (didl_object);
						didl_resource = _tmp47_;
						_tmp48_ = res;
						_tmp49_ = didl_resource;
						_tmp50_ = replacements;
						_tmp51_ = rygel_media_resource_serialize (_tmp48_, _tmp49_, _tmp50_);
						_tmp52_ = _tmp51_;
						_g_object_unref0 (_tmp52_);
						_g_object_unref0 (didl_resource);
					}
					_g_free0 (protocol);
				}
				goto __finally14;
				__catch14_g_error:
				{
					GError* e = NULL;
					RygelMediaResource* _tmp53_;
					const gchar* _tmp54_;
					const gchar* _tmp55_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp53_ = res;
					_tmp54_ = rygel_media_resource_get_uri (_tmp53_);
					_tmp55_ = _tmp54_;
					g_warning (_ ("Could not determine protocol for %s"), _tmp55_);
					_g_error_free0 (e);
				}
				__finally14:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (res);
					_g_object_unref0 (_res_list);
					_g_hash_table_unref0 (replacements);
					return;
				}
			}
			_g_object_unref0 (res);
		}
		_g_object_unref0 (_res_list);
	}
	_g_hash_table_unref0 (replacements);
}


/**
     * Replace each key in replacement_pairs with its corresponding
     * value in the source_string and return the result.
     *
     * @param replacement_pairs HashTable of variable -> substitution pairs
     * @param source_string String that shall have the replacements applied
     * to.
     *
     * @return null if source_string is null, string with all replacements
     * applied otherwise.
     */
static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_free0 (_data4_->replaced_string);
		g_slice_free (Block4Data, _data4_);
	}
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch15_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch15_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally15;
	__catch15_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
__lambda4_ (Block4Data* _data4_,
            const gchar* search_string,
            const gchar* replacement)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search_string != NULL);
	g_return_if_fail (replacement != NULL);
	_tmp0_ = _data4_->replaced_string;
	_tmp1_ = string_replace (_tmp0_, search_string, replacement);
	_g_free0 (_data4_->replaced_string);
	_data4_->replaced_string = _tmp1_;
}


static void
___lambda4__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda4_ (self, (const gchar*) key, (const gchar*) value);
}


gchar*
rygel_media_object_apply_replacements (GHashTable* replacement_pairs,
                                       const gchar* source_string)
{
	gchar* result = NULL;
	Block4Data* _data4_;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (replacement_pairs != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	if (source_string == NULL) {
		result = NULL;
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	_tmp0_ = g_strdup (source_string);
	_data4_->replaced_string = _tmp0_;
	g_hash_table_foreach (replacement_pairs, ___lambda4__gh_func, _data4_);
	_tmp1_ = _data4_->replaced_string;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}


/**
     * Create a stream source for the given resource
     */
static RygelDataSource*
rygel_media_object_real_create_stream_source_for_resource (RygelMediaObject* self,
                                                           RygelHTTPRequest* request,
                                                           RygelMediaResource* resource,
                                                           GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_media_object_create_stream_source_for_resource'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


RygelDataSource*
rygel_media_object_create_stream_source_for_resource (RygelMediaObject* self,
                                                      RygelHTTPRequest* request,
                                                      RygelMediaResource* resource,
                                                      GError** error)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->create_stream_source_for_resource (self, request, resource, error);
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


static void
rygel_media_object_real_apply_didl_lite (RygelMediaObject* self,
                                         GUPnPDIDLLiteObject* didl_object)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (didl_object != NULL);
	_tmp0_ = gupnp_didl_lite_object_get_title (didl_object);
	_tmp1_ = _tmp0_;
	rygel_media_object_set_title (self, _tmp1_);
	_tmp2_ = gupnp_didl_lite_object_get_artists (didl_object);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_media_object_get_first (self, _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_media_object_set_artist (self, _tmp5_);
	_g_free0 (_tmp5_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (_g_list_free__g_object_unref0_ (_tmp3_), NULL));
	_tmp6_ = gupnp_didl_lite_object_get_genre (didl_object);
	_tmp7_ = _tmp6_;
	rygel_media_object_set_genre (self, _tmp7_);
}


void
rygel_media_object_apply_didl_lite (RygelMediaObject* self,
                                    GUPnPDIDLLiteObject* didl_object)
{
	g_return_if_fail (self != NULL);
	RYGEL_MEDIA_OBJECT_GET_CLASS (self)->apply_didl_lite (self, didl_object);
}


static void
rygel_media_object_clean_node (RygelMediaObject* self,
                               xmlNode* node,
                               xmlNs* ns)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	xmlAttr* attr = NULL;
	xmlAttr* _tmp1_;
	xmlNode* child = NULL;
	xmlNode* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = node->properties;
	attr = _tmp1_;
	while (TRUE) {
		xmlAttr* _tmp2_;
		xmlAttr* _tmp3_;
		xmlNs* _tmp4_;
		xmlAttr* _tmp8_;
		xmlAttr* _tmp9_;
		_tmp2_ = attr;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = attr;
		_tmp4_ = _tmp3_->ns;
		if (_tmp4_ == ns) {
			GeeArrayList* _tmp5_;
			xmlAttr* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = list;
			_tmp6_ = attr;
			_tmp7_ = _tmp6_->name;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp7_);
		}
		_tmp8_ = attr;
		_tmp9_ = _tmp8_->next;
		attr = _tmp9_;
	}
	{
		GeeArrayList* _name_list = NULL;
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		gint _name_size = 0;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _name_index = 0;
		_tmp10_ = list;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_name_list = _tmp11_;
		_tmp12_ = _name_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_name_size = _tmp14_;
		_name_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gchar* name = NULL;
			GeeArrayList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			const gchar* _tmp21_;
			_tmp15_ = _name_index;
			_name_index = _tmp15_ + 1;
			_tmp16_ = _name_index;
			_tmp17_ = _name_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _name_list;
			_tmp19_ = _name_index;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
			name = (gchar*) _tmp20_;
			_tmp21_ = name;
			xmlUnsetNsProp (node, ns, (xmlChar*) _tmp21_);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_list);
	}
	_tmp22_ = node->children;
	child = _tmp22_;
	while (TRUE) {
		xmlNode* _tmp23_;
		xmlNode* _tmp24_;
		xmlNode* _tmp25_;
		xmlNode* _tmp26_;
		_tmp23_ = child;
		if (!(_tmp23_ != NULL)) {
			break;
		}
		_tmp24_ = child;
		rygel_media_object_clean_node (self, _tmp24_, ns);
		_tmp25_ = child;
		_tmp26_ = _tmp25_->next;
		child = _tmp26_;
	}
	_g_object_unref0 (list);
}


static void
rygel_media_object_apply_fragments_data_free (gpointer _data)
{
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->current_fragments);
	_g_object_unref0 (_data_->new_fragments);
	_g_object_unref0 (_data_->http_server);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectApplyFragmentsData, _data_);
}


static void
rygel_media_object_apply_fragments_async_ready_wrapper (GObject *source_object,
                                                        GAsyncResult *res,
                                                        void *user_data)
{
	RygelMediaObjectApplyFragmentsData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


void
rygel_media_object_apply_fragments (RygelMediaObject* self,
                                    GeeLinkedList* current_fragments,
                                    GeeLinkedList* new_fragments,
                                    RygelHTTPServer* http_server,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	RygelMediaObjectApplyFragmentsData* _data_;
	RygelMediaObject* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	RygelHTTPServer* _tmp3_;
	_data_ = g_slice_new0 (RygelMediaObjectApplyFragmentsData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_media_object_apply_fragments_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_object_apply_fragments_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (current_fragments);
	_g_object_unref0 (_data_->current_fragments);
	_data_->current_fragments = _tmp1_;
	_tmp2_ = _g_object_ref0 (new_fragments);
	_g_object_unref0 (_data_->new_fragments);
	_data_->new_fragments = _tmp2_;
	_tmp3_ = _g_object_ref0 (http_server);
	_g_object_unref0 (_data_->http_server);
	_data_->http_server = _tmp3_;
	rygel_media_object_apply_fragments_co (_data_);
}


GUPnPDIDLLiteFragmentResult
rygel_media_object_apply_fragments_finish (RygelMediaObject* self,
                                           GAsyncResult* _res_)
{
	GUPnPDIDLLiteFragmentResult result;
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}


static void
rygel_media_object_apply_fragments_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	RygelMediaObjectApplyFragmentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_media_object_apply_fragments_co (_data_);
}


static gboolean
rygel_media_object_apply_fragments_co (RygelMediaObjectApplyFragmentsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_result_ = GUPNP_DIDL_LITE_FRAGMENT_RESULT_UNKNOWN_ERROR;
	{
		_data_->_tmp0_ = rygel_serializer_new (RYGEL_SERIALIZER_TYPE_GENERIC_DIDL);
		_data_->writer = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->writer;
		_data_->_tmp2_ = rygel_media_object_serialize (_data_->self, _data_->_tmp1_, _data_->http_server, &_data_->_inner_error_);
		_data_->didl_object = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->writer);
			goto __catch16_g_error;
		}
		_data_->_tmp3_ = _data_->didl_object;
		_data_->_tmp4_ = gupnp_didl_lite_object_get_xml_node (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->didl_object;
		_data_->_tmp7_ = gupnp_didl_lite_object_get_dlna_namespace (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		rygel_media_object_clean_node (_data_->self, _data_->_tmp5_, _data_->_tmp8_);
		_data_->_tmp9_ = _data_->didl_object;
		_data_->_tmp11_ = gee_collection_to_array ((GeeCollection*) _data_->current_fragments, &_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp12__length1 = _data_->_tmp10_;
		_data_->_tmp14_ = gee_collection_to_array ((GeeCollection*) _data_->new_fragments, &_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp15__length1 = _data_->_tmp13_;
		_data_->_result_ = gupnp_didl_lite_object_apply_fragments (_data_->_tmp9_, _data_->_tmp12_, _data_->_tmp10_, _data_->_tmp15_, _data_->_tmp13_);
		_data_->_tmp15_ = (_vala_array_free (_data_->_tmp15_, _data_->_tmp15__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp12_ = (_vala_array_free (_data_->_tmp12_, _data_->_tmp12__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp16_ = _data_->_result_;
		if (_data_->_tmp16_ == GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK) {
			_data_->_tmp17_ = _data_->didl_object;
			rygel_media_object_apply_didl_lite (_data_->self, _data_->_tmp17_);
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT)) {
				_data_->_state_ = 1;
				rygel_updatable_object_commit (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, rygel_media_object_apply_fragments_ready, _data_);
				return FALSE;
				_state_1:
				rygel_updatable_object_commit_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->self, RYGEL_TYPE_UPDATABLE_OBJECT) ? ((RygelUpdatableObject*) _data_->self) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->didl_object);
					_g_object_unref0 (_data_->writer);
					goto __catch16_g_error;
				}
			}
		}
		_g_object_unref0 (_data_->didl_object);
		_g_object_unref0 (_data_->writer);
	}
	goto __finally16;
	__catch16_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_debug ("rygel-media-object.vala:382: Failed to apply fragments: %s. Ignoring.", _data_->_tmp19_);
		_g_error_free0 (_data_->e);
	}
	__finally16:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gint
rygel_media_object_real_compare_by_property (RygelMediaObject* self,
                                             RygelMediaObject* media_object,
                                             const gchar* property)
{
	gint result = 0;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	_tmp0_ = property;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = self->priv->_id;
				_tmp4_ = media_object->priv->_id;
				result = rygel_media_object_compare_string_props (self, _tmp3_, _tmp4_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				RygelMediaContainer* _tmp5_;
				RygelMediaContainer* _tmp6_;
				const gchar* _tmp7_;
				RygelMediaContainer* _tmp8_;
				RygelMediaContainer* _tmp9_;
				const gchar* _tmp10_;
				_tmp5_ = rygel_media_object_get_parent (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = ((RygelMediaObject*) _tmp6_)->priv->_id;
				_tmp8_ = rygel_media_object_get_parent (media_object);
				_tmp9_ = _tmp8_;
				_tmp10_ = ((RygelMediaObject*) _tmp9_)->priv->_id;
				result = rygel_media_object_compare_string_props (self, _tmp7_, _tmp10_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp11_ = rygel_media_object_get_title (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = rygel_media_object_get_title (media_object);
				_tmp14_ = _tmp13_;
				result = rygel_media_object_compare_string_props (self, _tmp12_, _tmp14_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = self->priv->_upnp_class;
				_tmp16_ = media_object->priv->_upnp_class;
				result = rygel_media_object_compare_string_props (self, _tmp15_, _tmp16_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("dc:artist")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = self->priv->_artist;
				_tmp18_ = media_object->priv->_artist;
				result = rygel_media_object_compare_string_props (self, _tmp17_, _tmp18_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("upnp:genre")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp19_ = self->priv->_genre;
				_tmp20_ = media_object->priv->_genre;
				result = rygel_media_object_compare_string_props (self, _tmp19_, _tmp20_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				_tmp21_ = self->priv->_creator;
				_tmp22_ = media_object->priv->_creator;
				result = rygel_media_object_compare_string_props (self, _tmp21_, _tmp22_);
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				result = rygel_media_object_compare_by_date (self, media_object);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	}
}


gint
rygel_media_object_compare_by_property (RygelMediaObject* self,
                                        RygelMediaObject* media_object,
                                        const gchar* property)
{
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->compare_by_property (self, media_object, property);
}


gint
rygel_media_object_compare_string_props (RygelMediaObject* self,
                                         const gchar* prop1,
                                         const gchar* prop2)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (prop1 != NULL, 0);
	g_return_val_if_fail (prop2 != NULL, 0);
	if (prop1 == NULL) {
		result = -1;
		return result;
	} else {
		if (prop2 == NULL) {
			result = 1;
			return result;
		} else {
			result = g_utf8_collate (prop1, prop2);
			return result;
		}
	}
}


gint
rygel_media_object_compare_int_props (RygelMediaObject* self,
                                      gint prop1,
                                      gint prop2)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = CLAMP (prop1 - prop2, -1, 1);
	return result;
}


static void
rygel_media_object_check_writable_data_free (gpointer _data)
{
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaObjectCheckWritableData, _data_);
}


static void
rygel_media_object_check_writable_async_ready_wrapper (GObject *source_object,
                                                       GAsyncResult *res,
                                                       void *user_data)
{
	RygelMediaObjectCheckWritableData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void
rygel_media_object_check_writable (RygelMediaObject* self,
                                   GFile* file,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	RygelMediaObjectCheckWritableData* _data_;
	RygelMediaObject* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (RygelMediaObjectCheckWritableData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, rygel_media_object_check_writable_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_object_check_writable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_media_object_check_writable_co (_data_);
}


static gboolean
rygel_media_object_check_writable_finish (RygelMediaObject* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	gboolean result;
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}


static void
rygel_media_object_check_writable_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	RygelMediaObjectCheckWritableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_media_object_check_writable_co (_data_);
}


static gboolean
rygel_media_object_check_writable_co (RygelMediaObjectCheckWritableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_get_uri_scheme (_data_->file);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_str_has_prefix (RYGEL_WRITABLE_CONTAINER_WRITABLE_SCHEME, _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!g_file_is_native (_data_->file)) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->file, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->cancellable, rygel_media_object_check_writable_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch17_g_io_error_not_found;
			}
			goto __finally17;
		}
		_data_->_tmp4_ = _data_->info;
		_data_->result = g_file_info_get_attribute_boolean (_data_->_tmp4_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
		_g_object_unref0 (_data_->info);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally17;
	__catch17_g_io_error_not_found:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->result = TRUE;
		_g_error_free0 (_data_->_error_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally17:
	g_task_return_error (_data_->_async_result, _data_->_inner_error_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gint
rygel_media_object_compare_by_date (RygelMediaObject* self,
                                    RygelMediaObject* object)
{
	gint result = 0;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (object != NULL, 0);
	_tmp0_ = self->priv->_date;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = object->priv->_date;
		if (_tmp1_ == NULL) {
			result = 1;
			return result;
		} else {
			gchar* our_date = NULL;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* other_date = NULL;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp9_;
			GTimeVal tv1 = {0};
			const gchar* _tmp12_;
			GTimeVal tv2 = {0};
			const gchar* _tmp13_;
			gint ret = 0;
			GTimeVal _tmp14_;
			glong _tmp15_;
			GTimeVal _tmp16_;
			glong _tmp17_;
			gint _tmp18_;
			_tmp2_ = self->priv->_date;
			_tmp3_ = g_strdup (_tmp2_);
			our_date = _tmp3_;
			_tmp4_ = object->priv->_date;
			_tmp5_ = g_strdup (_tmp4_);
			other_date = _tmp5_;
			_tmp6_ = our_date;
			if (!string_contains (_tmp6_, "T")) {
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = our_date;
				_tmp8_ = g_strconcat (_tmp7_, "T00:00:00Z", NULL);
				_g_free0 (our_date);
				our_date = _tmp8_;
			}
			_tmp9_ = other_date;
			if (!string_contains (_tmp9_, "T")) {
				const gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp10_ = other_date;
				_tmp11_ = g_strconcat (_tmp10_, "T00:00:00Z", NULL);
				_g_free0 (other_date);
				other_date = _tmp11_;
			}
			g_get_current_time (&tv1);
			_tmp12_ = self->priv->_date;
			_vala_assert (g_time_val_from_iso8601 (_tmp12_, &tv1), "tv1.from_iso8601 (this.date)");
			g_get_current_time (&tv2);
			_tmp13_ = object->priv->_date;
			_vala_assert (g_time_val_from_iso8601 (_tmp13_, &tv2), "tv2.from_iso8601 (object.date)");
			_tmp14_ = tv1;
			_tmp15_ = _tmp14_.tv_sec;
			_tmp16_ = tv2;
			_tmp17_ = _tmp16_.tv_sec;
			ret = rygel_media_object_compare_long (self, _tmp15_, _tmp17_);
			_tmp18_ = ret;
			if (_tmp18_ == 0) {
				GTimeVal _tmp19_;
				glong _tmp20_;
				GTimeVal _tmp21_;
				glong _tmp22_;
				_tmp19_ = tv1;
				_tmp20_ = _tmp19_.tv_usec;
				_tmp21_ = tv2;
				_tmp22_ = _tmp21_.tv_usec;
				ret = rygel_media_object_compare_long (self, _tmp20_, _tmp22_);
			}
			result = ret;
			_g_free0 (other_date);
			_g_free0 (our_date);
			return result;
		}
	}
}


static gint
rygel_media_object_compare_long (RygelMediaObject* self,
                                 glong a,
                                 glong b)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (a < b) {
		result = -1;
		return result;
	} else {
		if (a > b) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}


static gchar*
rygel_media_object_get_first (RygelMediaObject* self,
                              GList* contributors)
{
	gchar* result = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	if (contributors != NULL) {
		gconstpointer _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = contributors->data;
		_tmp1_ = gupnp_didl_lite_contributor_get_name ((GUPnPDIDLLiteContributor*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}


static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}


static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}


gchar*
rygel_media_object_get_protocol_for_uri (RygelMediaObject* self,
                                         const gchar* uri,
                                         GError** error)
{
	gchar* result = NULL;
	gchar* scheme = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelMediaEngine* engine = NULL;
	RygelMediaEngine* _tmp3_;
	GList* schemes = NULL;
	RygelMediaEngine* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	const gchar* _tmp7_;
	GCompareFunc _tmp8_;
	GList* _tmp9_;
	const gchar* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_uri_parse_scheme (uri);
	scheme = _tmp0_;
	_tmp1_ = scheme;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new (RYGEL_MEDIA_ITEM_ERROR, RYGEL_MEDIA_ITEM_ERROR_BAD_URI, _ ("Bad URI: %s"), uri);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (scheme);
		return NULL;
	}
	_tmp3_ = rygel_media_engine_get_default ();
	engine = _tmp3_;
	_tmp4_ = engine;
	_tmp5_ = rygel_media_engine_get_internal_protocol_schemes (_tmp4_);
	schemes = _tmp5_;
	_tmp6_ = schemes;
	_tmp7_ = scheme;
	_tmp8_ = g_strcmp0;
	_tmp9_ = g_list_find_custom (_tmp6_, _tmp7_, _tmp8_);
	if (_tmp9_ != NULL) {
		result = NULL;
		(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
		_g_object_unref0 (engine);
		_g_free0 (scheme);
		return result;
	}
	_tmp10_ = scheme;
	if (g_strcmp0 (_tmp10_, "http") == 0) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("http-get");
		result = _tmp11_;
		(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
		_g_object_unref0 (engine);
		_g_free0 (scheme);
		return result;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = scheme;
		if (g_strcmp0 (_tmp12_, "file") == 0) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("internal");
			result = _tmp13_;
			(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
			_g_object_unref0 (engine);
			_g_free0 (scheme);
			return result;
		} else {
			const gchar* _tmp14_;
			_tmp14_ = scheme;
			if (g_strcmp0 (_tmp14_, "rtsp") == 0) {
				gchar* _tmp15_;
				_tmp15_ = g_strdup ("rtsp-rtp-udp");
				result = _tmp15_;
				(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
				_g_object_unref0 (engine);
				_g_free0 (scheme);
				return result;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = scheme;
				g_debug ("Could not translate protocol scheme for  %s. " " Using '%s' as-is", uri, _tmp16_);
				result = scheme;
				(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
				_g_object_unref0 (engine);
				return result;
			}
		}
	}
	(schemes == NULL) ? NULL : (schemes = (_g_list_free__g_free0_ (schemes), NULL));
	_g_object_unref0 (engine);
	_g_free0 (scheme);
}


RygelMediaObject*
rygel_media_object_construct (GType object_type)
{
	RygelMediaObject * self = NULL;
	self = (RygelMediaObject*) g_object_new (object_type, NULL);
	return self;
}


const gchar*
rygel_media_object_get_id (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_id (RygelMediaObject* self,
                           const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_object_get_id (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_ID_PROPERTY]);
	}
}


const gchar*
rygel_media_object_get_ref_id (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ref_id;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_ref_id (RygelMediaObject* self,
                               const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_object_get_ref_id (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_ref_id);
		self->priv->_ref_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY]);
	}
}


const gchar*
rygel_media_object_get_upnp_class (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_upnp_class;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_upnp_class (RygelMediaObject* self,
                                   const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_object_get_upnp_class (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_upnp_class);
		self->priv->_upnp_class = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY]);
	}
}


const gchar*
rygel_media_object_get_date (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_date (RygelMediaObject* self,
                             const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_object_get_date (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_date);
		self->priv->_date = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_DATE_PROPERTY]);
	}
}


const gchar*
rygel_media_object_get_creator (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_creator;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_creator (RygelMediaObject* self,
                                const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_object_get_creator (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_creator);
		self->priv->_creator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY]);
	}
}


guint64
rygel_media_object_get_modified (RygelMediaObject* self)
{
	guint64 result;
	guint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = self->priv->_modified;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_modified (RygelMediaObject* self,
                                 guint64 value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_object_get_modified (self) != value) {
		self->priv->_modified = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY]);
	}
}


guint
rygel_media_object_get_object_update_id (RygelMediaObject* self)
{
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_object_update_id;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_object_update_id (RygelMediaObject* self,
                                         guint value)
{
	g_return_if_fail (self != NULL);
	if (rygel_media_object_get_object_update_id (self) != value) {
		self->priv->_object_update_id = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY]);
	}
}


const gchar*
rygel_media_object_get_artist (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_artist;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_artist (RygelMediaObject* self,
                               const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_object_get_artist (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_artist);
		self->priv->_artist = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY]);
	}
}


const gchar*
rygel_media_object_get_genre (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_genre;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_genre (RygelMediaObject* self,
                              const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_media_object_get_genre (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_genre);
		self->priv->_genre = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_GENRE_PROPERTY]);
	}
}


RygelMediaContainer*
rygel_media_object_get_parent (RygelMediaObject* self)
{
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent_ptr;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_parent (RygelMediaObject* self,
                               RygelMediaContainer* value)
{
	g_return_if_fail (self != NULL);
	self->parent_ptr = value;
	g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_PARENT_PROPERTY]);
}


RygelMediaContainer*
rygel_media_object_get_parent_ref (RygelMediaObject* self)
{
	RygelMediaContainer* result;
	RygelMediaContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_ref;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_parent_ref (RygelMediaObject* self,
                                   RygelMediaContainer* value)
{
	RygelMediaContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	rygel_media_object_set_parent (self, value);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_parent_ref);
	self->priv->_parent_ref = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY]);
}


const gchar*
rygel_media_object_get_title (RygelMediaObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


void
rygel_media_object_set_title (RygelMediaObject* self,
                              const gchar* value)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* _tmp0_ = NULL;
		GRegex* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		GRegex* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp1_ = rygel_media_object_real_name_regex;
		_tmp2_ = g_get_real_name ();
		_tmp3_ = g_regex_replace_literal (_tmp1_, value, (gssize) -1, 0, _tmp2_, 0, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp4_;
		_tmp6_ = rygel_media_object_user_name_regex;
		_tmp7_ = self->priv->_title;
		_tmp8_ = g_get_user_name ();
		_tmp9_ = g_regex_replace_literal (_tmp6_, _tmp7_, (gssize) -1, 0, _tmp8_, 0, &_inner_error_);
		_tmp5_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp10_;
		_tmp12_ = rygel_media_object_host_name_regex;
		_tmp13_ = self->priv->_title;
		_tmp14_ = g_get_host_name ();
		_tmp15_ = g_regex_replace_literal (_tmp12_, _tmp13_, (gssize) -1, 0, _tmp14_, 0, &_inner_error_);
		_tmp11_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp5_);
			_g_free0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_free0 (_tmp5_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp16_ = _tmp11_;
		_tmp11_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp16_;
		_tmp18_ = rygel_media_object_pretty_name_regex;
		_tmp19_ = self->priv->_title;
		_tmp20_ = rygel_get_pretty_host_name ();
		_tmp21_ = _tmp20_;
		_tmp22_ = g_regex_replace_literal (_tmp18_, _tmp19_, (gssize) -1, 0, _tmp21_, 0, &_inner_error_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_tmp17_ = _tmp23_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (_tmp11_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch18_g_regex_error;
			}
			_g_free0 (_tmp11_);
			_g_free0 (_tmp5_);
			_g_free0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp24_ = _tmp17_;
		_tmp17_ = NULL;
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp24_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp0_);
	}
	goto __finally18;
	__catch18_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_TITLE_PROPERTY]);
}


GUPnPOCMFlags
rygel_media_object_get_ocm_flags (RygelMediaObject* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_MEDIA_OBJECT_GET_CLASS (self)->get_ocm_flags (self);
}


static GUPnPOCMFlags
rygel_media_object_real_get_ocm_flags (RygelMediaObject* base)
{
	GUPnPOCMFlags result;
	RygelMediaObject* self;
	self = base;
	result = GUPNP_OCM_FLAGS_NONE;
	return result;
}


gboolean
rygel_media_object_get_restricted (RygelMediaObject* self)
{
	gboolean result;
	GUPnPOCMFlags _tmp0_;
	GUPnPOCMFlags _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = rygel_media_object_get_ocm_flags (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == GUPNP_OCM_FLAGS_NONE;
	return result;
}


static void
rygel_media_object_class_init (RygelMediaObjectClass * klass)
{
	GError * _inner_error_ = NULL;
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaObjectPrivate));
	((RygelMediaObjectClass *) klass)->add_uri = (void (*) (RygelMediaObject *, const gchar*)) rygel_media_object_real_add_uri;
	((GObjectClass *) klass)->constructed = (void (*) (GObject *)) rygel_media_object_real_constructed;
	((RygelMediaObjectClass *) klass)->serialize = (GUPnPDIDLLiteObject* (*) (RygelMediaObject *, RygelSerializer*, RygelHTTPServer*, GError**)) rygel_media_object_real_serialize;
	((RygelMediaObjectClass *) klass)->create_stream_source_for_resource = (RygelDataSource* (*) (RygelMediaObject *, RygelHTTPRequest*, RygelMediaResource*, GError**)) rygel_media_object_real_create_stream_source_for_resource;
	((RygelMediaObjectClass *) klass)->apply_didl_lite = (void (*) (RygelMediaObject *, GUPnPDIDLLiteObject*)) rygel_media_object_real_apply_didl_lite;
	((RygelMediaObjectClass *) klass)->compare_by_property = (gint (*) (RygelMediaObject *, RygelMediaObject*, const gchar*)) rygel_media_object_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->get_ocm_flags = rygel_media_object_real_get_ocm_flags;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ID_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY] = g_param_spec_string ("ref-id", "ref-id", "ref-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY] = g_param_spec_string ("upnp-class", "upnp-class", "upnp-class", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_DATE_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_DATE_PROPERTY] = g_param_spec_string ("date", "date", "date", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY] = g_param_spec_string ("creator", "creator", "creator", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY] = g_param_spec_uint64 ("modified", "modified", "modified", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY] = g_param_spec_uint ("object-update-id", "object-update-id", "object-update-id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY] = g_param_spec_string ("artist", "artist", "artist", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_GENRE_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_GENRE_PROPERTY] = g_param_spec_string ("genre", "genre", "genre", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY] = g_param_spec_object ("parent-ref", "parent-ref", "parent-ref", RYGEL_TYPE_MEDIA_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The human-readable title of this container or item.
	     * These variables will be substituted:
	     *
	     *  - @@REALNAME@ will be substituted by the user's real name.
	     *  - @@USERNAME@ will be substituted by the users's login ID.
	     *  - @@HOSTNAME@ will be substituted by the name of the machine.
	     *  - @@ADDRESS@ will be substituted by the IP address of network interface
	     *    used for the UPnP communication.
	     *  - @@PRETTY_HOSTNAME@ will be substituted by the human readable name of the machine
	     *    (PRETTY_HOSTNAME field of /etc/machine-info)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_TITLE_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_OCM_FLAGS_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_OCM_FLAGS_PROPERTY] = g_param_spec_flags ("ocm-flags", "ocm-flags", "ocm-flags", gupnp_ocm_flags_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_OBJECT_RESTRICTED_PROPERTY, rygel_media_object_properties[RYGEL_MEDIA_OBJECT_RESTRICTED_PROPERTY] = g_param_spec_boolean ("restricted", "restricted", "restricted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	{
		GRegex* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		GRegex* _tmp11_;
		GRegex* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GRegex* _tmp15_;
		GRegex* _tmp16_;
		GRegex* _tmp17_;
		GRegex* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GRegex* _tmp21_;
		GRegex* _tmp22_;
		GRegex* _tmp23_;
		_tmp1_ = g_regex_escape_string ("@REALNAME@", -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (rygel_media_object_real_name_regex);
		rygel_media_object_real_name_regex = _tmp5_;
		_tmp7_ = g_regex_escape_string ("@USERNAME@", -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_tmp6_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			_g_regex_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp11_ = _tmp6_;
		_tmp6_ = NULL;
		_g_regex_unref0 (rygel_media_object_user_name_regex);
		rygel_media_object_user_name_regex = _tmp11_;
		_tmp13_ = g_regex_escape_string ("@HOSTNAME@", -1);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_regex_new (_tmp14_, 0, 0, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_tmp12_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp17_ = _tmp12_;
		_tmp12_ = NULL;
		_g_regex_unref0 (rygel_media_object_host_name_regex);
		rygel_media_object_host_name_regex = _tmp17_;
		_tmp19_ = g_regex_escape_string ("@PRETTY_HOSTNAME@", -1);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_regex_new (_tmp20_, 0, 0, &_inner_error_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_tmp18_ = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp12_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			_g_regex_unref0 (_tmp12_);
			_g_regex_unref0 (_tmp6_);
			_g_regex_unref0 (_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp23_ = _tmp18_;
		_tmp18_ = NULL;
		_g_regex_unref0 (rygel_media_object_pretty_name_regex);
		rygel_media_object_pretty_name_regex = _tmp23_;
		_g_regex_unref0 (_tmp18_);
		_g_regex_unref0 (_tmp12_);
		_g_regex_unref0 (_tmp6_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally19;
	__catch19_g_regex_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (err);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void
rygel_media_object_instance_init (RygelMediaObject * self)
{
	GeeLinkedList* _tmp0_;
	self->priv = RYGEL_MEDIA_OBJECT_GET_PRIVATE (self);
	_tmp0_ = gee_linked_list_new (RYGEL_TYPE_MEDIA_RESOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->media_resources = (GeeList*) _tmp0_;
}


static void
rygel_media_object_finalize (GObject * obj)
{
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_ref_id);
	_g_free0 (self->priv->_upnp_class);
	_g_free0 (self->priv->_date);
	_g_free0 (self->priv->_creator);
	_g_free0 (self->priv->_artist);
	_g_free0 (self->priv->_genre);
	_g_object_unref0 (self->priv->uris);
	_g_object_unref0 (self->priv->media_resources);
	_g_object_unref0 (self->priv->_parent_ref);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (rygel_media_object_parent_class)->finalize (obj);
}


/**
 * Represents a media object (container or item).
 *
 * The derived RygelMediaContainer class represents a container
 * and the derived MediaItem classes represent media items.
 */
GType
rygel_media_object_get_type (void)
{
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, NULL };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


static void
_vala_rygel_media_object_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_ID_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_ref_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_upnp_class (self));
		break;
		case RYGEL_MEDIA_OBJECT_DATE_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_date (self));
		break;
		case RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_creator (self));
		break;
		case RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY:
		g_value_set_uint64 (value, rygel_media_object_get_modified (self));
		break;
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY:
		g_value_set_uint (value, rygel_media_object_get_object_update_id (self));
		break;
		case RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_artist (self));
		break;
		case RYGEL_MEDIA_OBJECT_GENRE_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_genre (self));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_PROPERTY:
		g_value_set_object (value, rygel_media_object_get_parent (self));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY:
		g_value_set_object (value, rygel_media_object_get_parent_ref (self));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE_PROPERTY:
		g_value_set_string (value, rygel_media_object_get_title (self));
		break;
		case RYGEL_MEDIA_OBJECT_OCM_FLAGS_PROPERTY:
		g_value_set_flags (value, rygel_media_object_get_ocm_flags (self));
		break;
		case RYGEL_MEDIA_OBJECT_RESTRICTED_PROPERTY:
		g_value_set_boolean (value, rygel_media_object_get_restricted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_rygel_media_object_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	switch (property_id) {
		case RYGEL_MEDIA_OBJECT_ID_PROPERTY:
		rygel_media_object_set_id (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_REF_ID_PROPERTY:
		rygel_media_object_set_ref_id (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_UPNP_CLASS_PROPERTY:
		rygel_media_object_set_upnp_class (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_DATE_PROPERTY:
		rygel_media_object_set_date (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_CREATOR_PROPERTY:
		rygel_media_object_set_creator (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_MODIFIED_PROPERTY:
		rygel_media_object_set_modified (self, g_value_get_uint64 (value));
		break;
		case RYGEL_MEDIA_OBJECT_OBJECT_UPDATE_ID_PROPERTY:
		rygel_media_object_set_object_update_id (self, g_value_get_uint (value));
		break;
		case RYGEL_MEDIA_OBJECT_ARTIST_PROPERTY:
		rygel_media_object_set_artist (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_GENRE_PROPERTY:
		rygel_media_object_set_genre (self, g_value_get_string (value));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_PROPERTY:
		rygel_media_object_set_parent (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_PARENT_REF_PROPERTY:
		rygel_media_object_set_parent_ref (self, g_value_get_object (value));
		break;
		case RYGEL_MEDIA_OBJECT_TITLE_PROPERTY:
		rygel_media_object_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



